/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.tilegroups.citybutton;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.unciv.logic.city.City;
import com.unciv.models.ImmutableColor;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.widgets.BorderedTable;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/unciv/ui/components/tilegroups/citybutton/AirUnitTable;", "Lcom/unciv/ui/components/widgets/BorderedTable;", "city", "Lcom/unciv/logic/city/City;", "numberOfUnits", "", "size", "", "<init>", "(Lcom/unciv/logic/city/City;IF)V", "core"})
public final class AirUnitTable
extends BorderedTable {
    public AirUnitTable(@NotNull City city, int numberOfUnits, float size) {
        Intrinsics.checkNotNullParameter(city, "city");
        super("WorldScreen/CityButton/AirUnitTable", BaseScreen.Companion.getSkinStrings().getRoundedEdgeRectangleSmallShape(), BaseScreen.Companion.getSkinStrings().getRoundedEdgeRectangleSmallShape());
        this.pad(2.0f, 10.0f, 2.0f, 10.0f);
        Nation nation = city.getCiv().getNation();
        ImmutableColor textColor = nation.getInnerColor();
        this.setBgColor(nation.getOuterColor());
        this.setBgBorderColor(nation.getOuterColor());
        Image aircraftImage = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Aircraft", null, 2, null);
        aircraftImage.setColor(textColor);
        aircraftImage.setSize(size, size);
        this.add((Actor)aircraftImage);
        this.add((Actor)Scene2dExtensionsKt.toLabel$default(TranslationsKt.tr(numberOfUnits), textColor, (int)size, 0, false, 12, null));
    }

    public /* synthetic */ AirUnitTable(City city, int n, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            f = 14.0f;
        }
        this(city, n, f);
    }
}

