/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.objectdescriptions;

import com.unciv.models.ruleset.Belief;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.tech.Technology;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.stats.Stats;
import com.unciv.ui.objectdescriptions.DescriptionHelpersKt;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/unciv/ui/objectdescriptions/ResourceDescriptions;", "", "<init>", "()V", "getCivilopediaTextLines", "", "Lcom/unciv/ui/screens/civilopediascreen/FormattedLine;", "resource", "Lcom/unciv/models/ruleset/tile/TileResource;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "core"})
@SourceDebugExtension(value={"SMAP\nResourceDescriptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceDescriptions.kt\ncom/unciv/ui/objectdescriptions/ResourceDescriptions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n1915#2,2:128\n777#2:130\n873#2:131\n1807#2,3:132\n874#2:135\n1915#2,2:136\n777#2:138\n873#2:139\n1807#2,3:140\n874#2:143\n1915#2,2:144\n777#2:146\n873#2:147\n1807#2,3:148\n874#2:151\n1915#2,2:152\n777#2:154\n873#2,2:155\n1915#2,2:157\n777#2:159\n873#2,2:160\n1915#2,2:162\n777#2:164\n873#2,2:165\n1915#2,2:167\n*S KotlinDebug\n*F\n+ 1 ResourceDescriptions.kt\ncom/unciv/ui/objectdescriptions/ResourceDescriptions\n*L\n36#1:128,2\n50#1:130\n50#1:131\n51#1:132,3\n50#1:135\n58#1:136,2\n64#1:138\n64#1:139\n65#1:140,3\n64#1:143\n72#1:144,2\n78#1:146\n78#1:147\n79#1:148,3\n78#1:151\n86#1:152,2\n91#1:154\n91#1:155,2\n96#1:157,2\n101#1:159\n101#1:160,2\n106#1:162,2\n111#1:164\n111#1:165,2\n117#1:167,2\n*E\n"})
public final class ResourceDescriptions {
    @NotNull
    public static final ResourceDescriptions INSTANCE = new ResourceDescriptions();

    private ResourceDescriptions() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FormattedLine> getCivilopediaTextLines(@NotNull TileResource resource, @NotNull Ruleset ruleset) {
        void $this$filterTo$iv$iv;
        Iterable element$iv10;
        Iterator $this$filterTo$iv$iv2;
        Iterable element$iv22;
        Iterator $this$filterTo$iv$iv3;
        Iterable element$iv32;
        Iterator $this$filterTo$iv$iv4;
        void $this$filter$iv;
        Object element$iv42;
        Object element$iv$iv;
        Iterator $this$filterTo$iv$iv5;
        void $this$filter$iv2;
        Object element$iv52;
        Object element$iv$iv2;
        Iterator $this$filterTo$iv$iv6;
        void $this$filter$iv3;
        Object element$iv6;
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter(resource, "resource");
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        ArrayList textList = new ArrayList();
        ((Collection)textList).add(new FormattedLine(resource.getResourceType().name() + " resource", null, null, null, 0.0f, 0, 4, 0, 0.0f, resource.getResourceType().getColor(), false, false, false, false, 15806, null));
        ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
        DescriptionHelpersKt.uniquesToCivilopediaTextLines$default(resource, textList, null, false, null, 14, null);
        if (!((Stats)resource).isEmpty()) {
            ((Collection)textList).add(new FormattedLine(resource.cloneStats().toString(), null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
        }
        if (!((charSequence = (CharSequence)resource.getRevealedBy()) == null || charSequence.length() == 0)) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)textList).add(new FormattedLine("Revealed by:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            Collection collection = textList;
            String string = resource.getRevealedBy();
            Intrinsics.checkNotNull(string);
            collection.add(new FormattedLine(string, "Technology/" + resource.getRevealedBy(), null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null));
        }
        if (!((Collection)resource.getTerrainsCanBeFoundOn()).isEmpty()) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            if (resource.getTerrainsCanBeFoundOn().size() == 1) {
                String terrainName = resource.getTerrainsCanBeFoundOn().get(0);
                ((Collection)textList).add(new FormattedLine("{Can be found on} {" + terrainName + '}', "Terrain/" + terrainName, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
            } else {
                ((Collection)textList).add(new FormattedLine("{Can be found on}:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
                Iterable $this$forEach$iv = resource.getTerrainsCanBeFoundOn();
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv6 = iterator2.next();
                    String it = (String)element$iv6;
                    boolean bl = false;
                    ((Collection)textList).add(new FormattedLine(it, "Terrain/" + it, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null));
                }
            }
        }
        for (String improvement : resource.getImprovements()) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)textList).add(new FormattedLine("Improved by [" + improvement + ']', "Improvement/" + improvement, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
            if (resource.getImprovementStats() == null) continue;
            Stats stats = resource.getImprovementStats();
            Intrinsics.checkNotNull(stats);
            if (stats.isEmpty()) continue;
            ((Collection)textList).add(new FormattedLine("{Bonus stats for improvement}: " + resource.getImprovementStats(), null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
        }
        Collection<TileImprovement> collection = ruleset.getTileImprovements().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable improvement = collection;
        boolean $i$f$filter = false;
        element$iv6 = $this$filter$iv3;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator3 = $this$filterTo$iv$iv6.iterator();
        while (iterator3.hasNext()) {
            boolean bl;
            block34: {
                element$iv$iv2 = iterator3.next();
                TileImprovement improvement2 = (TileImprovement)element$iv$iv2;
                boolean bl2 = false;
                Iterable $this$any$iv = improvement2.getUniqueObjects();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv7 : $this$any$iv) {
                        Unique unique = (Unique)element$iv7;
                        boolean bl3 = false;
                        if (!(unique.getType() == UniqueType.ProvidesResources && Intrinsics.areEqual(unique.getParams().get(1), resource.getName()))) continue;
                        bl = true;
                        break block34;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        List improvementsThatProvideThis = (List)destination$iv$iv;
        if (!((Collection)improvementsThatProvideThis).isEmpty()) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)textList).add(new FormattedLine("{Improvements that provide this resource}:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            Iterable $this$forEach$iv = improvementsThatProvideThis;
            boolean $i$f$forEach = false;
            for (Object element$iv52 : $this$forEach$iv) {
                TileImprovement it = (TileImprovement)element$iv52;
                boolean bl = false;
                ((Collection)textList).add(new FormattedLine(it.getName(), it.makeLink(), null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null));
            }
        }
        Collection<Building> collection2 = ruleset.getBuildings().values();
        Intrinsics.checkNotNullExpressionValue(collection2, "<get-values>(...)");
        Iterable $i$f$forEach = collection2;
        boolean $i$f$filter2 = false;
        element$iv52 = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        element$iv$iv2 = $this$filterTo$iv$iv5.iterator();
        while (element$iv$iv2.hasNext()) {
            boolean bl;
            block35: {
                element$iv$iv = element$iv$iv2.next();
                Building building = (Building)element$iv$iv;
                boolean bl4 = false;
                Iterable $this$any$iv = building.getUniqueObjects();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv8 : $this$any$iv) {
                        Unique unique = (Unique)element$iv8;
                        boolean bl5 = false;
                        if (!(unique.getType() == UniqueType.ProvidesResources && Intrinsics.areEqual(unique.getParams().get(1), resource.getName()))) continue;
                        bl = true;
                        break block35;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List buildingsThatProvideThis = (List)destination$iv$iv2;
        if (!((Collection)buildingsThatProvideThis).isEmpty()) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)textList).add(new FormattedLine("{Buildings that provide this resource}:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            Iterable $this$forEach$iv = buildingsThatProvideThis;
            boolean $i$f$forEach2 = false;
            for (Object element$iv42 : $this$forEach$iv) {
                Building it = (Building)element$iv42;
                boolean bl = false;
                ((Collection)textList).add(new FormattedLine(it.getName(), it.makeLink(), null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null));
            }
        }
        Collection<Technology> collection3 = ruleset.getTechnologies().values();
        Intrinsics.checkNotNullExpressionValue(collection3, "<get-values>(...)");
        Iterable $i$f$forEach2 = collection3;
        boolean $i$f$filter3 = false;
        element$iv42 = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        element$iv$iv = $this$filterTo$iv$iv4.iterator();
        while (element$iv$iv.hasNext()) {
            boolean bl;
            Object element$iv$iv3;
            block36: {
                element$iv$iv3 = element$iv$iv.next();
                Technology technology = (Technology)element$iv$iv3;
                boolean bl6 = false;
                Iterable $this$any$iv = technology.getUniqueObjects();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv9 : $this$any$iv) {
                        Unique unique = (Unique)element$iv9;
                        boolean bl7 = false;
                        if (!(unique.getType() == UniqueType.ProvidesResources && Intrinsics.areEqual(unique.getParams().get(1), resource.getName()))) continue;
                        bl = true;
                        break block36;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv3.add(element$iv$iv3);
        }
        List technologiesThatProvideThis = (List)destination$iv$iv3;
        if (!((Collection)technologiesThatProvideThis).isEmpty()) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)textList).add(new FormattedLine("{Technologies that provide this resource}:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            Iterable $this$forEach$iv = technologiesThatProvideThis;
            boolean $i$f$forEach3 = false;
            for (Iterable element$iv32 : $this$forEach$iv) {
                Technology it = (Technology)((Object)element$iv32);
                boolean bl = false;
                ((Collection)textList).add(new FormattedLine(it.getName(), it.makeLink(), null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null));
            }
        }
        Collection<Building> collection4 = ruleset.getBuildings().values();
        Intrinsics.checkNotNullExpressionValue(collection4, "<get-values>(...)");
        Iterable $this$filter$iv4 = collection4;
        boolean $i$f$filter4 = false;
        element$iv32 = $this$filter$iv4;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterTo4 = false;
        Iterator element$iv$iv3 = $this$filterTo$iv$iv3.iterator();
        while (element$iv$iv3.hasNext()) {
            Object element$iv$iv4 = element$iv$iv3.next();
            Building it = (Building)element$iv$iv4;
            boolean bl = false;
            if (!it.getResourceRequirementsPerTurn(GameContext.Companion.getIgnoreConditionals()).containsKey(resource.getName())) continue;
            destination$iv$iv4.add(element$iv$iv4);
        }
        List buildingsThatConsumeThis = (List)destination$iv$iv4;
        if (!((Collection)buildingsThatConsumeThis).isEmpty()) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)textList).add(new FormattedLine("{Buildings that consume this resource}:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            Iterable $this$forEach$iv = buildingsThatConsumeThis;
            boolean $i$f$forEach4 = false;
            for (Iterable element$iv22 : $this$forEach$iv) {
                Building it = (Building)element$iv22;
                boolean bl = false;
                ((Collection)textList).add(new FormattedLine(it.getName(), it.makeLink(), null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null));
            }
        }
        Collection<BaseUnit> collection5 = ruleset.getUnits().values();
        Intrinsics.checkNotNullExpressionValue(collection5, "<get-values>(...)");
        Iterable $this$filter$iv5 = collection5;
        boolean $i$f$filter5 = false;
        element$iv22 = $this$filter$iv5;
        Collection destination$iv$iv5 = new ArrayList();
        boolean $i$f$filterTo5 = false;
        Iterator element$iv$iv4 = $this$filterTo$iv$iv2.iterator();
        while (element$iv$iv4.hasNext()) {
            Object element$iv$iv5 = element$iv$iv4.next();
            BaseUnit it = (BaseUnit)element$iv$iv5;
            boolean bl = false;
            if (!it.getResourceRequirementsPerTurn(GameContext.Companion.getIgnoreConditionals()).containsKey(resource.getName())) continue;
            destination$iv$iv5.add(element$iv$iv5);
        }
        List unitsThatConsumeThis = (List)destination$iv$iv5;
        if (!((Collection)unitsThatConsumeThis).isEmpty()) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)textList).add(new FormattedLine("{Units that consume this resource}: ", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            Iterable $this$forEach$iv = unitsThatConsumeThis;
            boolean $i$f$forEach5 = false;
            for (Iterable element$iv10 : $this$forEach$iv) {
                BaseUnit it = (BaseUnit)((Object)element$iv10);
                boolean bl = false;
                ((Collection)textList).add(new FormattedLine(it.getName(), it.makeLink(), null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null));
            }
        }
        Collection<Building> collection6 = ruleset.getBuildings().values();
        Intrinsics.checkNotNullExpressionValue(collection6, "<get-values>(...)");
        Iterable $this$filter$iv6 = collection6;
        boolean $i$f$filter6 = false;
        element$iv10 = $this$filter$iv6;
        Collection destination$iv$iv6 = new ArrayList();
        boolean $i$f$filterTo6 = false;
        for (Object element$iv$iv6 : $this$filterTo$iv$iv) {
            Building it = (Building)element$iv$iv6;
            boolean bl = false;
            List<String> list2 = it.getRequiredNearbyImprovedResources();
            boolean bl8 = list2 != null ? list2.contains(resource.getName()) : false;
            if (!bl8) continue;
            destination$iv$iv6.add(element$iv$iv6);
        }
        List buildingsRequiringThis = (List)destination$iv$iv6;
        if (!((Collection)buildingsRequiringThis).isEmpty()) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)textList).add(new FormattedLine("{Buildings that require this resource improved near the city}: ", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            Iterable $this$forEach$iv = buildingsRequiringThis;
            boolean $i$f$forEach6 = false;
            for (Object element$iv11 : $this$forEach$iv) {
                Building it = (Building)element$iv11;
                boolean bl = false;
                ((Collection)textList).add(new FormattedLine(it.getName(), it.makeLink(), null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null));
            }
        }
        CollectionsKt.addAll((Collection)textList, Belief.Companion.getCivilopediaTextMatching$default(Belief.Companion, resource.getName(), ruleset, false, 4, null));
        return textList;
    }
}

