/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens;

import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.LanguageTable;
import com.unciv.ui.screens.mainmenuscreen.MainMenuScreen;
import com.unciv.ui.screens.pickerscreens.PickerScreen;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\b\u0010\u000e\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/unciv/ui/screens/LanguagePickerScreen;", "Lcom/unciv/ui/screens/pickerscreens/PickerScreen;", "<init>", "()V", "chosenLanguage", "", "languageTables", "Ljava/util/ArrayList;", "Lcom/unciv/ui/components/widgets/LanguageTable;", "Lkotlin/collections/ArrayList;", "update", "", "onChoice", "choice", "pickLanguage", "core"})
@SourceDebugExtension(value={"SMAP\nLanguagePickerScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguagePickerScreen.kt\ncom/unciv/ui/screens/LanguagePickerScreen\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1915#2,2:69\n296#2,2:71\n*S KotlinDebug\n*F\n+ 1 LanguagePickerScreen.kt\ncom/unciv/ui/screens/LanguagePickerScreen\n*L\n25#1:69,2\n41#1:71,2\n*E\n"})
public final class LanguagePickerScreen
extends PickerScreen {
    @NotNull
    private String chosenLanguage = "English";
    @NotNull
    private final ArrayList<LanguageTable> languageTables;

    public LanguagePickerScreen() {
        super(false, 1, null);
        this.getCloseButton().setVisible(false);
        this.languageTables = LanguageTable.Companion.addLanguageTables(this.getTopTable(), this.getStage().getWidth() - 60.0f);
        Iterator<LanguageTable> iterator2 = this.languageTables.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<LanguageTable> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            LanguageTable languageTable;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            ActivationExtensionsKt.onClick(languageTable, () -> LanguagePickerScreen._init_$lambda$0(this, languageTable));
        }
        LanguageTable.Companion.addLanguageKeyShortcuts(this.getTopTable(), this.languageTables, () -> LanguagePickerScreen._init_$lambda$1(this), arg_0 -> LanguagePickerScreen._init_$lambda$2(this, arg_0));
        this.getRightSideButton().setText(TranslationsKt.tr$default("Pick language", false, false, 3, null));
        ActivationExtensionsKt.onClick(this.getRightSideButton(), () -> LanguagePickerScreen._init_$lambda$3(this));
    }

    public final void update() {
        Iterable $this$forEach$iv = this.languageTables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LanguageTable it = (LanguageTable)element$iv;
            boolean bl = false;
            it.update(this.chosenLanguage);
        }
    }

    private final void onChoice(String choice) {
        this.chosenLanguage = choice;
        Scene2dExtensionsKt.enable(this.getRightSideButton());
        this.update();
    }

    private final void pickLanguage() {
        this.getGame().getSettings().setLanguage(this.chosenLanguage);
        this.getGame().getSettings().updateLocaleFromLanguage();
        this.getGame().getSettings().setFreshlyCreated(false);
        this.getGame().getSettings().save();
        this.getGame().getTranslations().tryReadTranslationForCurrentLanguage();
        this.getGame().replaceCurrentScreen(new MainMenuScreen());
    }

    private static final Unit _init_$lambda$0(LanguagePickerScreen this$0, LanguageTable $languageTable) {
        this$0.onChoice($languageTable.getLanguage());
        return Unit.INSTANCE;
    }

    private static final String _init_$lambda$1(LanguagePickerScreen this$0) {
        return this$0.chosenLanguage;
    }

    private static final Unit _init_$lambda$2(LanguagePickerScreen this$0, String language) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter(language, "language");
            this$0.onChoice(language);
            Iterable $this$firstOrNull$iv = this$0.languageTables;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                LanguageTable it = (LanguageTable)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getLanguage(), language)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        LanguageTable languageTable = v0;
        if (languageTable == null) {
            return Unit.INSTANCE;
        }
        LanguageTable selectedTable = languageTable;
        Scene2dExtensionsKt.scrollTo(this$0.getScrollPane(), selectedTable, true);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(LanguagePickerScreen this$0) {
        this$0.pickLanguage();
        return Unit.INSTANCE;
    }
}

