/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.cityscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.UncivGame;
import com.unciv.logic.city.City;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.map.tile.TileDescription;
import com.unciv.logic.map.tile.TileStatFunctions;
import com.unciv.models.skins.SkinStrings;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.Stats;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.cityscreen.CityScreen;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import com.unciv.ui.screens.civilopediascreen.MarkupRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/unciv/ui/screens/cityscreen/CityScreenTileTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "cityScreen", "Lcom/unciv/ui/screens/cityscreen/CityScreen;", "<init>", "(Lcom/unciv/ui/screens/cityscreen/CityScreen;)V", "innerTable", "city", "Lcom/unciv/logic/city/City;", "getCity", "()Lcom/unciv/logic/city/City;", "update", "", "selectedTile", "Lcom/unciv/logic/map/tile/Tile;", "getTileStatsTable", "stats", "Lcom/unciv/models/stats/Stats;", "core"})
public final class CityScreenTileTable
extends Table {
    @NotNull
    private final CityScreen cityScreen;
    @NotNull
    private final Table innerTable;
    @NotNull
    private final City city;

    public CityScreenTileTable(@NotNull CityScreen cityScreen) {
        Intrinsics.checkNotNullParameter(cityScreen, "cityScreen");
        this.cityScreen = cityScreen;
        this.innerTable = new Table();
        this.city = this.cityScreen.getCity$core();
        this.innerTable.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "CityScreen/CityScreenTileTable/InnerTable", null, Scene2dExtensionsKt.darken(BaseScreen.Companion.getSkinStrings().getSkinConfig().getBaseColor(), 0.5f), 2, null));
        this.add((Actor)this.innerTable).pad(2.0f).fill();
        this.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "CityScreen/CityScreenTileTable/Background", null, Color.WHITE, 2, null));
    }

    @NotNull
    public final City getCity() {
        return this.city;
    }

    public final void update(@Nullable Tile selectedTile) {
        this.innerTable.clear();
        if (selectedTile == null) {
            this.setVisible(false);
            return;
        }
        this.setVisible(true);
        this.innerTable.clearChildren();
        Stats stats = TileStatFunctions.getTileStats$default(selectedTile.getStats(), this.city, this.city.getCiv(), null, 4, null);
        this.innerTable.pad(5.0f);
        this.innerTable.add((Actor)MarkupRenderer.render$default(MarkupRenderer.INSTANCE, TileDescription.INSTANCE.toMarkup(selectedTile, this.city.getCiv(), this.cityScreen.isSpying$core(), this.cityScreen.isSpying$core() ? this.cityScreen.getCity$core() : null), 0.0f, 0.0f, FormattedLine.IconDisplay.None, arg_0 -> CityScreenTileTable.update$lambda$0(this, arg_0), 6, null));
        this.innerTable.row();
        this.innerTable.add((Actor)this.getTileStatsTable(stats)).row();
        if (this.city.getExpansion().canBuyTile(selectedTile)) {
            int goldCostOfTile = this.city.getExpansion().getGoldCostOfTile(selectedTile);
            TextButton buyTileButton = Scene2dExtensionsKt.toTextButton$default("Buy for [" + goldCostOfTile + "] gold", null, false, 3, null);
            ActivationExtensionsKt.onActivation$default(buyTileButton, null, KeyboardBinding.BuyTile, () -> CityScreenTileTable.update$lambda$1(buyTileButton, this, selectedTile), 1, null);
            Scene2dExtensionsKt.setEnabled(buyTileButton, this.cityScreen.getCanChangeState() && this.city.getCiv().hasStatToBuy(Stat.Gold, goldCostOfTile));
            this.innerTable.add((Actor)buyTileButton).padTop(5.0f).row();
        }
        if (selectedTile.getOwningCity() != null) {
            StringBuilder stringBuilder = new StringBuilder().append("Owned by [");
            City city = selectedTile.getOwningCity();
            Intrinsics.checkNotNull(city);
            this.innerTable.add((Actor)Scene2dExtensionsKt.toLabel(stringBuilder.append(city.getName()).append(']').toString())).row();
        }
        if (selectedTile.getWorkingCity() != null) {
            StringBuilder stringBuilder = new StringBuilder().append("Worked by [");
            City city = selectedTile.getWorkingCity();
            Intrinsics.checkNotNull(city);
            this.innerTable.add((Actor)Scene2dExtensionsKt.toLabel(stringBuilder.append(city.getName()).append(']').toString())).row();
        }
        if (this.city.isWorked(selectedTile)) {
            if (selectedTile.isLocked()) {
                TextButton unlockButton = Scene2dExtensionsKt.toTextButton$default("Unlock", null, false, 3, null);
                ActivationExtensionsKt.onClick(unlockButton, () -> CityScreenTileTable.update$lambda$2(this, selectedTile));
                if (!this.cityScreen.getCanChangeState()) {
                    Scene2dExtensionsKt.disable(unlockButton);
                }
                this.innerTable.add((Actor)unlockButton).padTop(5.0f).row();
            } else {
                TextButton lockButton = Scene2dExtensionsKt.toTextButton$default("Lock", null, false, 3, null);
                ActivationExtensionsKt.onClick(lockButton, () -> CityScreenTileTable.update$lambda$3(this, selectedTile));
                if (!this.cityScreen.getCanChangeState()) {
                    Scene2dExtensionsKt.disable(lockButton);
                }
                this.innerTable.add((Actor)lockButton).padTop(5.0f).row();
            }
        }
        if (selectedTile.isCityCenter() && !Intrinsics.areEqual(selectedTile.getCity(), this.city)) {
            City city = selectedTile.getCity();
            Intrinsics.checkNotNull(city);
            if (Intrinsics.areEqual(city.getCiv(), this.city.getCiv()) && !this.cityScreen.isSpying$core()) {
                this.innerTable.add(ActivationExtensionsKt.onClick(Scene2dExtensionsKt.toTextButton$default("Move to city", null, false, 3, null), () -> CityScreenTileTable.update$lambda$4(this, selectedTile)));
            }
        }
        this.innerTable.pack();
        this.pack();
    }

    private final Table getTileStatsTable(Stats stats) {
        Table statsTable = new Table();
        statsTable.defaults().pad(2.0f);
        for (Stats.StatValuePair statValuePair : stats) {
            Stat key = statValuePair.component1();
            float value = statValuePair.component2();
            statsTable.add((Actor)ImageGetter.getStatIcon$default(ImageGetter.INSTANCE, key.name(), 0.0f, 2, null)).size(20.0f);
            statsTable.add((Actor)Scene2dExtensionsKt.toLabel(MathKt.roundToInt(value))).padRight(5.0f);
        }
        return statsTable;
    }

    private static final Unit update$lambda$0(CityScreenTileTable this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.cityScreen.openCivilopedia(it);
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$1(TextButton $buyTileButton, CityScreenTileTable this$0, Tile $selectedTile) {
        Scene2dExtensionsKt.disable($buyTileButton);
        this$0.cityScreen.askToBuyTile$core($selectedTile);
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$2(CityScreenTileTable this$0, Tile $selectedTile) {
        this$0.city.getLockedTiles().remove($selectedTile.getPosition());
        this$0.update($selectedTile);
        this$0.cityScreen.update$core();
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$3(CityScreenTileTable this$0, Tile $selectedTile) {
        this$0.city.getLockedTiles().add($selectedTile.getPosition());
        this$0.update($selectedTile);
        this$0.cityScreen.update$core();
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$4(CityScreenTileTable this$0, Tile $selectedTile) {
        UncivGame uncivGame = this$0.cityScreen.getGame();
        City city = $selectedTile.getCity();
        Intrinsics.checkNotNull(city);
        uncivGame.replaceCurrentScreen(new CityScreen(city, null, null, null, 14, null));
        return Unit.INSTANCE;
    }
}

