/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.victoryscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.logic.GameInfo;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.ruleset.Milestone;
import com.unciv.models.ruleset.Victory;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.widgets.TabbedPager;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.victoryscreen.VictoryScreenCivGroup;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import java.util.Comparator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J&\u0010\b\u001a\u00020\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0001H\u0016R\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/unciv/ui/screens/victoryscreen/VictoryScreenGlobalVictory;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "Lcom/unciv/ui/components/widgets/TabbedPager$IPageExtensions;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "<init>", "(Lcom/unciv/ui/screens/worldscreen/WorldScreen;)V", "header", "getColumn", "majorCivs", "Lkotlin/sequences/Sequence;", "Lcom/unciv/logic/civilization/Civilization;", "victory", "Lcom/unciv/models/ruleset/Victory;", "playerCiv", "activated", "", "index", "", "caption", "", "pager", "Lcom/unciv/ui/components/widgets/TabbedPager;", "getFixedContent", "core"})
public final class VictoryScreenGlobalVictory
extends Table
implements TabbedPager.IPageExtensions {
    @NotNull
    private final Table header;

    public VictoryScreenGlobalVictory(@NotNull WorldScreen worldScreen) {
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        super(BaseScreen.Companion.getSkin());
        this.header = new Table();
        this.align(2);
        GameInfo gameInfo = worldScreen.getGameInfo();
        Sequence<Civilization> majorCivs = SequencesKt.filter(CollectionsKt.asSequence((Iterable)gameInfo.getCivilizations()), VictoryScreenGlobalVictory::_init_$lambda$0);
        Map<String, Victory> victoriesToShow = gameInfo.getEnabledVictories();
        this.defaults().pad(10.0f);
        for (Map.Entry<String, Victory> entry : victoriesToShow.entrySet()) {
            String victoryName = entry.getKey();
            Victory victory = entry.getValue();
            this.header.add((Actor)Scene2dExtensionsKt.toLabel('[' + victoryName + "] Victory")).pad(10.0f);
            this.add((Actor)this.getColumn(majorCivs, victory, worldScreen.getViewingCiv()));
        }
        Color color = Color.GRAY;
        Intrinsics.checkNotNullExpressionValue(color, "GRAY");
        Scene2dExtensionsKt.addSeparator$default(this.header, color, 0, 0.0f, 6, null);
    }

    private final Table getColumn(Sequence<Civilization> majorCivs, Victory victory, Civilization playerCiv) {
        Table table2;
        Table $this$getColumn_u24lambda_u240 = table2 = new Table();
        boolean bl = false;
        $this$getColumn_u24lambda_u240.defaults().pad(10.0f);
        Object object = new Comparator(){

            public final int compare(T a, T b) {
                Civilization it = (Civilization)a;
                boolean bl = false;
                Comparable comparable = Boolean.valueOf(it.isDefeated());
                it = (Civilization)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.isDefeated());
            }
        };
        Sequence<Civilization> sortedCivs = SequencesKt.sortedWith(majorCivs, new Comparator((Comparator)object, victory){
            final /* synthetic */ Comparator $this_thenBy;
            final /* synthetic */ Victory $victory$inlined;
            {
                this.$this_thenBy = $receiver;
                this.$victory$inlined = victory;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Civilization it = (Civilization)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getVictoryManager().amountMilestonesCompleted(this.$victory$inlined));
                    it = (Civilization)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues(comparable2, it.getVictoryManager().amountMilestonesCompleted(this.$victory$inlined));
                }
                return n;
            }
        });
        object = sortedCivs.iterator();
        while (object.hasNext()) {
            String string;
            Civilization civ = (Civilization)object.next();
            Milestone milestone = civ.getVictoryManager().getNextMilestone(victory);
            String buttonText = milestone != null && (string = milestone.getVictoryScreenButtonHeaderText(false, civ)) != null ? string : "Done!";
            $this$getColumn_u24lambda_u240.add((Actor)new VictoryScreenCivGroup(civ, buttonText, playerCiv, null, 8, null)).fillX().row();
        }
        return table2;
    }

    @Override
    public void activated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        Intrinsics.checkNotNullParameter(caption, "caption");
        Intrinsics.checkNotNullParameter(pager, "pager");
        Table[] tableArray = new Table[]{this.header, this};
        Scene2dExtensionsKt.equalizeColumns(tableArray);
    }

    @Override
    @NotNull
    public Table getFixedContent() {
        return this.header;
    }

    private static final boolean _init_$lambda$0(Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isMajorCiv();
    }
}

