/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Align;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J\u001a\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u000bH\u0016J\u0018\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000bH\u0002J8\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/unciv/ui/screens/worldscreen/BackgroundActor;", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "background", "Lcom/badlogic/gdx/scenes/scene2d/utils/Drawable;", "align", "", "<init>", "(Lcom/badlogic/gdx/scenes/scene2d/utils/Drawable;I)V", "getBackground", "()Lcom/badlogic/gdx/scenes/scene2d/utils/Drawable;", "widthMultiplier", "", "heightMultiplier", "noClip", "", "xOffset", "yOffset", "hit", "x", "y", "touchable", "draw", "", "batch", "Lcom/badlogic/gdx/graphics/g2d/Batch;", "parentAlpha", "drawBackground", "w", "h", "core"})
public final class BackgroundActor
extends Actor {
    @NotNull
    private final Drawable background;
    private final float widthMultiplier;
    private final float heightMultiplier;
    private final boolean noClip;
    private final float xOffset;
    private final float yOffset;

    public BackgroundActor(@NotNull Drawable background, int align) {
        Intrinsics.checkNotNullParameter(background, "background");
        this.background = background;
        this.widthMultiplier = Align.isCenterHorizontal(align) ? 1.0f : 2.0f;
        this.heightMultiplier = Align.isCenterVertical(align) ? 1.0f : 2.0f;
        this.noClip = Align.isCenterHorizontal(align) && Align.isCenterVertical(align);
        this.xOffset = Align.isLeft(align) ? 0.5f : 0.0f;
        this.yOffset = Align.isBottom(align) ? 0.5f : 0.0f;
        this.setTouchable(Touchable.disabled);
    }

    @NotNull
    public final Drawable getBackground() {
        return this.background;
    }

    @Override
    @Nullable
    public Actor hit(float x, float y, boolean touchable) {
        return null;
    }

    @Override
    public void draw(@Nullable Batch batch, float parentAlpha) {
        if (batch == null) {
            return;
        }
        if (this.noClip) {
            this.drawBackground(batch, parentAlpha);
            return;
        }
        batch.flush();
        if (!this.clipBegin()) {
            return;
        }
        float w = this.getWidth() * this.widthMultiplier;
        float h = this.getHeight() * this.heightMultiplier;
        this.drawBackground(batch, parentAlpha, this.getX() - this.xOffset * w, this.getY() - this.yOffset * h, w, h);
        batch.flush();
        this.clipEnd();
    }

    private final void drawBackground(Batch batch, float parentAlpha) {
        this.drawBackground(batch, parentAlpha, this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    private final void drawBackground(Batch batch, float parentAlpha, float x, float y, float w, float h) {
        Color color = this.getColor();
        batch.setColor(color.r, color.g, color.b, color.a * parentAlpha);
        this.background.draw(batch, x, y, w, h);
    }
}

