/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.logic.GameInfo;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.models.ruleset.Event;
import com.unciv.models.ruleset.EventChoice;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.ui.components.UncivTooltip;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.components.widgets.WrappableLabel;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import com.unciv.ui.screens.civilopediascreen.MarkupRenderer;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\nH\u0002J\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001e\u00a8\u0006$"}, d2={"Lcom/unciv/ui/screens/worldscreen/RenderEvent;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "event", "Lcom/unciv/models/ruleset/Event;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "onChoice", "Lkotlin/Function1;", "Lcom/unciv/models/ruleset/EventChoice;", "", "<init>", "(Lcom/unciv/models/ruleset/Event;Lcom/unciv/ui/screens/worldscreen/WorldScreen;Lcom/unciv/logic/map/mapunit/MapUnit;Lkotlin/jvm/functions/Function1;)V", "getWorldScreen", "()Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "getUnit", "()Lcom/unciv/logic/map/mapunit/MapUnit;", "getOnChoice", "()Lkotlin/jvm/functions/Function1;", "gameInfo", "Lcom/unciv/logic/GameInfo;", "getGameInfo", "()Lcom/unciv/logic/GameInfo;", "stageWidth", "", "getStageWidth", "()F", "isValid", "", "()Z", "addChoice", "choice", "openCivilopedia", "link", "", "core"})
@SourceDebugExtension(value={"SMAP\nRenderEvent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderEvent.kt\ncom/unciv/ui/screens/worldscreen/RenderEvent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n777#2:83\n873#2,2:84\n832#2:86\n862#2,2:87\n1586#2:89\n1661#2,3:90\n*S KotlinDebug\n*F\n+ 1 RenderEvent.kt\ncom/unciv/ui/screens/worldscreen/RenderEvent\n*L\n73#1:83\n73#1:84,2\n74#1:86\n74#1:87,2\n75#1:89\n75#1:90,3\n*E\n"})
public final class RenderEvent
extends Table {
    @NotNull
    private final WorldScreen worldScreen;
    @Nullable
    private final MapUnit unit;
    @NotNull
    private final Function1<EventChoice, Unit> onChoice;
    private final boolean isValid;

    /*
     * WARNING - void declaration
     */
    public RenderEvent(@NotNull Event event, @NotNull WorldScreen worldScreen, @Nullable MapUnit unit, @NotNull Function1<? super EventChoice, Unit> onChoice) {
        Intrinsics.checkNotNullParameter(event, "event");
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        Intrinsics.checkNotNullParameter(onChoice, "onChoice");
        this.worldScreen = worldScreen;
        this.unit = unit;
        this.onChoice = onChoice;
        this.defaults().fillX().center().pad(5.0f);
        GameContext gameContext = new GameContext(this.getGameInfo().getCurrentPlayerCiv(), null, this.unit, null, null, null, null, null, null, null, false, 2042, null);
        Collection<EventChoice> choices = event.getMatchingChoices(gameContext);
        boolean bl = this.isValid = choices != null;
        if (this.isValid) {
            if (((CharSequence)event.getText()).length() > 0) {
                void $this$_init__u24lambda_u240;
                Object object;
                Object object2 = object = new WrappableLabel(event.getText(), this.getStageWidth() * 0.5f, null, 0, false, 28, null);
                RenderEvent renderEvent = this;
                boolean bl2 = false;
                $this$_init__u24lambda_u240.setWrap(true);
                $this$_init__u24lambda_u240.setAlignment(1);
                $this$_init__u24lambda_u240.optimizePrefWidth();
                renderEvent.add((Actor)object).row();
            }
            if (!((Collection)event.getCivilopediaText()).isEmpty()) {
                this.add((Actor)event.renderCivilopediaText(this.getStageWidth() * 0.5f, (Function1<? super String, Unit>)new Function1<String, Unit>((Object)this){

                    @Override
                    public final void invoke(String p0) {
                        Intrinsics.checkNotNullParameter(p0, "p0");
                        ((RenderEvent)this.receiver).openCivilopedia(p0);
                    }
                })).row();
            }
            Collection<EventChoice> collection = choices;
            Intrinsics.checkNotNull(collection);
            for (EventChoice choice : collection) {
                this.addChoice(choice);
            }
        }
    }

    public /* synthetic */ RenderEvent(Event event, WorldScreen worldScreen, MapUnit mapUnit, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            mapUnit = null;
        }
        this(event, worldScreen, mapUnit, function1);
    }

    @NotNull
    public final WorldScreen getWorldScreen() {
        return this.worldScreen;
    }

    @Nullable
    public final MapUnit getUnit() {
        return this.unit;
    }

    @NotNull
    public final Function1<EventChoice, Unit> getOnChoice() {
        return this.onChoice;
    }

    private final GameInfo getGameInfo() {
        return this.worldScreen.getGameInfo();
    }

    private final float getStageWidth() {
        return this.worldScreen.getStage().getWidth();
    }

    public final boolean isValid() {
        return this.isValid;
    }

    /*
     * WARNING - void declaration
     */
    private final void addChoice(EventChoice choice) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        Unique it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Scene2dExtensionsKt.addSeparator$default(this, null, 0, 0.0f, 7, null);
        TextButton button = Scene2dExtensionsKt.toTextButton$default(choice.getText(), null, false, 3, null);
        ActivationExtensionsKt.onActivation(button, () -> RenderEvent.addChoice$lambda$0(this, choice));
        KeyCharAndCode key = KeyCharAndCode.Companion.parse(choice.getKeyShortcut());
        if (!Intrinsics.areEqual(key, KeyCharAndCode.Companion.getUNKNOWN())) {
            ActivationExtensionsKt.getKeyShortcuts(button).add(key);
            UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, (Actor)button, key, 0.0f, 2, null);
        }
        this.add((Actor)button).row();
        Iterable iterable = choice.getUniqueObjects();
        Sequence sequence = CollectionsKt.asSequence((Iterable)choice.getCivilopediaText());
        boolean $i$f$filter = false;
        void var7_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Unique)element$iv$iv;
            boolean bl = false;
            if (!(it.isTriggerable() || it.getType() == UniqueType.Comment)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$filterTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (Unique)element$iv$iv;
            boolean bl = false;
            if (it.isHiddenToUsers()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Unique)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new FormattedLine(it, 0, 2, null));
        }
        Iterable lines2 = SequencesKt.asIterable(SequencesKt.plus(sequence, (List)destination$iv$iv));
        this.add((Actor)MarkupRenderer.render$default(MarkupRenderer.INSTANCE, lines2, this.getStageWidth() * 0.5f, 0.0f, null, new Function1<String, Unit>((Object)this){

            public final void invoke(String p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                RenderEvent.access$openCivilopedia((RenderEvent)this.receiver, p0);
            }
        }, 12, null)).row();
    }

    private final void openCivilopedia(String link) {
        this.worldScreen.openCivilopedia(link);
    }

    private static final Unit addChoice$lambda$0(RenderEvent this$0, EventChoice $choice) {
        this$0.onChoice.invoke($choice);
        $choice.triggerChoice(this$0.getGameInfo().getCurrentPlayerCiv(), this$0.unit);
        return Unit.INSTANCE;
    }
}

