/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.topbar;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.managers.GoldenAgeManager;
import com.unciv.models.stats.Stats;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.ScalingTableWrapper;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewCategories;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewScreen;
import com.unciv.ui.screens.pickerscreens.PolicyPickerScreen;
import com.unciv.ui.screens.pickerscreens.TechPickerScreen;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.topbar.WorldScreenTopBar;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0000\u0018\u0000 $2\u00020\u0001:\u0001$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/unciv/ui/screens/worldscreen/topbar/WorldScreenTopBarStats;", "Lcom/unciv/ui/components/widgets/ScalingTableWrapper;", "topbar", "Lcom/unciv/ui/screens/worldscreen/topbar/WorldScreenTopBar;", "<init>", "(Lcom/unciv/ui/screens/worldscreen/topbar/WorldScreenTopBar;)V", "goldLabel", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "goldPerTurnLabel", "scienceLabel", "happinessLabel", "cultureLabel", "faithLabel", "faithPerTurnLabel", "happinessContainer", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "malcontentColor", "Lcom/badlogic/gdx/graphics/Color;", "happinessColor", "malcontentImage", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "happinessImage", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "update", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "getCultureText", "", "nextTurnStats", "Lcom/unciv/models/stats/Stats;", "getHappinessText", "rateLabel", "value", "", "Companion", "core"})
public final class WorldScreenTopBarStats
extends ScalingTableWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Label goldLabel;
    @NotNull
    private final Label goldPerTurnLabel;
    @NotNull
    private final Label scienceLabel;
    @NotNull
    private final Label happinessLabel;
    @NotNull
    private final Label cultureLabel;
    @NotNull
    private final Label faithLabel;
    @NotNull
    private final Label faithPerTurnLabel;
    @NotNull
    private final Group happinessContainer;
    @NotNull
    private final Color malcontentColor;
    @NotNull
    private final Color happinessColor;
    @NotNull
    private final Image malcontentImage;
    @NotNull
    private final Image happinessImage;
    @NotNull
    private final WorldScreen worldScreen;
    public static final float defaultImageSize = 20.0f;
    public static final float defaultHorizontalPad = 3.0f;
    public static final float defaultTopPad = 8.0f;
    public static final float defaultBottomPad = 3.0f;
    public static final float defaultImageBottomPad = 6.0f;
    public static final float padRightBetweenStats = 20.0f;

    public WorldScreenTopBarStats(@NotNull WorldScreenTopBar topbar) {
        Intrinsics.checkNotNullParameter(topbar, "topbar");
        super(0.0f, 1, null);
        this.goldLabel = Scene2dExtensionsKt.toLabel$default("0", Scene2dExtensionsKt.colorFromRGB(225, 217, 71), 0, 0, false, 14, null);
        this.goldPerTurnLabel = Scene2dExtensionsKt.toLabel$default("+0", Scene2dExtensionsKt.colorFromRGB(225, 217, 71), 14, 0, false, 12, null);
        this.scienceLabel = Scene2dExtensionsKt.toLabel$default("0", Scene2dExtensionsKt.colorFromRGB(78, 140, 151), 0, 0, false, 14, null);
        this.happinessLabel = Scene2dExtensionsKt.toLabel("0");
        this.cultureLabel = Scene2dExtensionsKt.toLabel$default("0", Scene2dExtensionsKt.colorFromRGB(210, 94, 210), 0, 0, false, 14, null);
        this.faithLabel = Scene2dExtensionsKt.toLabel$default("0", Scene2dExtensionsKt.colorFromRGB(168, 196, 241), 0, 0, false, 14, null);
        this.faithPerTurnLabel = Scene2dExtensionsKt.toLabel$default("+0", Scene2dExtensionsKt.colorFromRGB(168, 196, 241), 14, 0, false, 12, null);
        this.happinessContainer = new Group();
        this.malcontentColor = Scene2dExtensionsKt.colorFromRGB(239, 83, 80);
        this.happinessColor = Scene2dExtensionsKt.colorFromRGB(92, 194, 77);
        this.malcontentImage = ImageGetter.getStatIcon$default(ImageGetter.INSTANCE, "Malcontent", 0.0f, 2, null);
        this.happinessImage = ImageGetter.getStatIcon$default(ImageGetter.INSTANCE, "Happiness", 0.0f, 2, null);
        this.worldScreen = topbar.getWorldScreen$core();
        this.setTransform(false);
        this.defaults().pad(8.0f, 3.0f, 3.0f, 3.0f);
        WorldScreenTopBarStats._init_$addStat$1(this, "Gold", this.goldLabel, EmpireOverviewCategories.Stats, true);
        WorldScreenTopBarStats._init_$addPerTurnLabel(this, this.goldPerTurnLabel);
        WorldScreenTopBarStats._init_$addStat$default(this, "Science", this.scienceLabel, false, () -> WorldScreenTopBarStats._init_$lambda$3(this), 8, null);
        Function0<Unit> invokeResourcesPage = () -> WorldScreenTopBarStats._init_$lambda$4(this);
        ActivationExtensionsKt.onClick(this.happinessContainer, invokeResourcesPage);
        ActivationExtensionsKt.onClick(this.happinessLabel, invokeResourcesPage);
        this.add(this.happinessContainer).padBottom(6.0f).size(20.0f);
        this.add(this.happinessLabel).padRight(20.0f);
        WorldScreenTopBarStats._init_$addStat$default(this, "Culture", this.cultureLabel, false, () -> WorldScreenTopBarStats._init_$lambda$5(this), 8, null);
        if (this.worldScreen.getGameInfo().isReligionEnabled()) {
            WorldScreenTopBarStats._init_$addStat$1(this, "Faith", this.faithLabel, EmpireOverviewCategories.Religion, true);
            WorldScreenTopBarStats._init_$addPerTurnLabel(this, this.faithPerTurnLabel);
        } else {
            this.add(Scene2dExtensionsKt.toLabel("Religion: Off"));
        }
    }

    public final void update(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        this.resetScale();
        Stats nextTurnStats = civInfo.getStats().getStatsForNextTurn();
        this.goldLabel.setText(TranslationsKt.tr(civInfo.getGold()));
        this.goldPerTurnLabel.setText(this.rateLabel(nextTurnStats.getGold()));
        this.scienceLabel.setText(this.rateLabel(nextTurnStats.getScience()));
        this.happinessLabel.setText(this.getHappinessText(civInfo));
        if (civInfo.getHappiness() < 0) {
            Scene2dExtensionsKt.setFontColor(this.happinessLabel, this.malcontentColor);
            this.happinessContainer.clearChildren();
            this.happinessContainer.addActor(this.malcontentImage);
        } else {
            Scene2dExtensionsKt.setFontColor(this.happinessLabel, this.happinessColor);
            this.happinessContainer.clearChildren();
            this.happinessContainer.addActor(this.happinessImage);
        }
        this.cultureLabel.setText(this.getCultureText(civInfo, nextTurnStats));
        this.faithLabel.setText(TranslationsKt.tr(civInfo.getReligionManager().getStoredFaith()));
        this.faithPerTurnLabel.setText(this.rateLabel(nextTurnStats.getFaith()));
        this.scaleTo(this.worldScreen.getStage().getWidth());
    }

    private final String getCultureText(Civilization civInfo, Stats nextTurnStats) {
        String cultureString = this.rateLabel(nextTurnStats.getCulture());
        float turnsToNextPolicy = (float)(civInfo.getPolicies().getCultureNeededForNextPolicy() - civInfo.getPolicies().getStoredCulture()) / nextTurnStats.getCulture();
        cultureString = cultureString + (turnsToNextPolicy <= 0.0f ? "\u2004(!)" : (nextTurnStats.getCulture() <= 0.0f ? "\u2004(\u221e)" : "\u2004(\u23f3\u2009" + TranslationsKt.tr((int)Math.ceil(turnsToNextPolicy)) + ')'));
        return cultureString;
    }

    private final String getHappinessText(Civilization civInfo) {
        String happinessText = TranslationsKt.tr(civInfo.getHappiness());
        GoldenAgeManager goldenAges = civInfo.getGoldenAges();
        happinessText = happinessText + (goldenAges.isGoldenAge() ? TranslationsKt.tr$default("    {GOLDEN AGE}(" + goldenAges.getTurnsLeftForCurrentGoldenAge() + ')', false, false, 3, null) : " (" + TranslationsKt.tr(goldenAges.getStoredHappiness()) + '/' + TranslationsKt.tr(goldenAges.happinessRequiredForNextGoldenAge()) + ')');
        return happinessText;
    }

    private final String rateLabel(float value) {
        return MathKt.roundToInt(value) == 0 ? "\u00b10" : FormattingExtensionsKt.toStringSigned(MathKt.roundToInt(value));
    }

    private static final Unit addStat$lambda$0(Function0 $screenFactory, WorldScreenTopBarStats this$0) {
        BaseScreen screen = (BaseScreen)$screenFactory.invoke();
        if (screen != null) {
            this$0.worldScreen.getGame().pushScreen(screen);
        }
        return Unit.INSTANCE;
    }

    private static final BaseScreen addStat$1$lambda$2(WorldScreenTopBarStats this$0, EmpireOverviewCategories $overviewPage) {
        return new EmpireOverviewScreen(this$0.worldScreen.getSelectedCiv(), $overviewPage, null, 4, null);
    }

    private static final void _init_$addStat(WorldScreenTopBarStats this$0, String icon, Label label, boolean noPad, Function0<? extends BaseScreen> screenFactory) {
        Image image = ImageGetter.getStatIcon$default(ImageGetter.INSTANCE, icon, 0.0f, 2, null);
        Function0<Unit> action2 = () -> WorldScreenTopBarStats.addStat$lambda$0(screenFactory, this$0);
        ActivationExtensionsKt.onClick(label, action2);
        ActivationExtensionsKt.onClick(image, action2);
        this$0.add(image).padBottom(6.0f).size(20.0f);
        this$0.add(label).padRight(noPad ? 0.0f : 20.0f);
    }

    static /* synthetic */ void _init_$addStat$default(WorldScreenTopBarStats worldScreenTopBarStats, String string, Label label, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        WorldScreenTopBarStats._init_$addStat(worldScreenTopBarStats, string, label, bl, function0);
    }

    private static final void _init_$addStat$1(WorldScreenTopBarStats this$0, String icon, Label label, EmpireOverviewCategories overviewPage, boolean noPad) {
        WorldScreenTopBarStats._init_$addStat(this$0, icon, label, noPad, () -> WorldScreenTopBarStats.addStat$1$lambda$2(this$0, overviewPage));
    }

    static /* synthetic */ void _init_$addStat$1$default(WorldScreenTopBarStats worldScreenTopBarStats, String string, Label label, EmpireOverviewCategories empireOverviewCategories, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        WorldScreenTopBarStats._init_$addStat$1(worldScreenTopBarStats, string, label, empireOverviewCategories, bl);
    }

    private static final void _init_$addPerTurnLabel(WorldScreenTopBarStats this$0, Label label) {
        this$0.add(label).padRight(20.0f).height(18.0f).top();
    }

    private static final BaseScreen _init_$lambda$3(WorldScreenTopBarStats this$0) {
        return new TechPickerScreen(this$0.worldScreen.getSelectedCiv(), null, 2, null);
    }

    private static final Unit _init_$lambda$4(WorldScreenTopBarStats this$0) {
        WorldScreen.openEmpireOverview$default(this$0.worldScreen, EmpireOverviewCategories.Resources, null, 2, null);
        return Unit.INSTANCE;
    }

    private static final BaseScreen _init_$lambda$5(WorldScreenTopBarStats this$0) {
        return this$0.worldScreen.getGameInfo().getRuleset().getPolicyBranches().isEmpty() ? null : (BaseScreen)new PolicyPickerScreen(this$0.worldScreen.getSelectedCiv(), this$0.worldScreen.getCanChangeState(), null, 4, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/unciv/ui/screens/worldscreen/topbar/WorldScreenTopBarStats$Companion;", "", "<init>", "()V", "defaultImageSize", "", "defaultHorizontalPad", "defaultTopPad", "defaultBottomPad", "defaultImageBottomPad", "padRightBetweenStats", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

