complete -c zellij -n "__fish_use_subcommand" -l max-panes -d 'Maximum panes on screen, caution: opening more panes will close old ones' -r
complete -c zellij -n "__fish_use_subcommand" -l data-dir -d 'Change where zellij looks for plugins' -r -F
complete -c zellij -n "__fish_use_subcommand" -l server -d 'Run server listening at the specified socket path' -r -F
complete -c zellij -n "__fish_use_subcommand" -s s -l session -d 'Specify name of a new session' -r
complete -c zellij -n "__fish_use_subcommand" -s l -l layout -d 'Name of a predefined layout inside the layout directory or the path to a layout file if inside a session (or using the --session flag) will be added to the session as a new tab or tabs, otherwise will start a new session' -r -F
complete -c zellij -n "__fish_use_subcommand" -s n -l new-session-with-layout -d 'Name of a predefined layout inside the layout directory or the path to a layout file Will always start a new session, even if inside an existing session' -r -F
complete -c zellij -n "__fish_use_subcommand" -s c -l config -d 'Change where zellij looks for the configuration file' -r -F
complete -c zellij -n "__fish_use_subcommand" -l config-dir -d 'Change where zellij looks for the configuration directory' -r -F
complete -c zellij -n "__fish_use_subcommand" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_use_subcommand" -s V -l version -d 'Print version information'
complete -c zellij -n "__fish_use_subcommand" -s d -l debug -d 'Specify emitting additional debug information'
complete -c zellij -n "__fish_use_subcommand" -f -a "options" -d 'Change the behaviour of zellij'
complete -c zellij -n "__fish_use_subcommand" -f -a "setup" -d 'Setup zellij and check its configuration'
complete -c zellij -n "__fish_use_subcommand" -f -a "web" -d 'Run a web server to serve terminal sessions'
complete -c zellij -n "__fish_use_subcommand" -f -a "list-sessions" -d 'List active sessions'
complete -c zellij -n "__fish_use_subcommand" -f -a "list-aliases" -d 'List existing plugin aliases'
complete -c zellij -n "__fish_use_subcommand" -f -a "attach" -d 'Attach to a session'
complete -c zellij -n "__fish_use_subcommand" -f -a "watch" -d 'Watch a session (read-only)'
complete -c zellij -n "__fish_use_subcommand" -f -a "kill-session" -d 'Kill a specific session'
complete -c zellij -n "__fish_use_subcommand" -f -a "delete-session" -d 'Delete a specific session'
complete -c zellij -n "__fish_use_subcommand" -f -a "kill-all-sessions" -d 'Kill all sessions'
complete -c zellij -n "__fish_use_subcommand" -f -a "delete-all-sessions" -d 'Delete all sessions'
complete -c zellij -n "__fish_use_subcommand" -f -a "action" -d 'Send actions to a specific session'
complete -c zellij -n "__fish_use_subcommand" -f -a "run" -d 'Run a command in a new pane Returns: Created pane ID (format: terminal_<id>)'
complete -c zellij -n "__fish_use_subcommand" -f -a "plugin" -d 'Load a plugin Returns: Created pane ID (format: plugin_<id>)'
complete -c zellij -n "__fish_use_subcommand" -f -a "edit" -d 'Edit file with default $EDITOR / $VISUAL Returns: Created pane ID (format: terminal_<id>)'
complete -c zellij -n "__fish_use_subcommand" -f -a "convert-config"
complete -c zellij -n "__fish_use_subcommand" -f -a "convert-layout"
complete -c zellij -n "__fish_use_subcommand" -f -a "convert-theme"
complete -c zellij -n "__fish_use_subcommand" -f -a "pipe" -d 'Send data to one or more plugins, launch them if they are not running'
complete -c zellij -n "__fish_use_subcommand" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c zellij -n "__fish_seen_subcommand_from options" -l simplified-ui -d 'Allow plugins to use a more simplified layout that is compatible with more fonts (true or false)' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from options" -l theme -d 'Set the default theme' -r
complete -c zellij -n "__fish_seen_subcommand_from options" -l default-mode -d 'Set the default mode' -r -f -a "{normal	In `Normal` mode, input is always written to the terminal, except for the shortcuts leading to other modes,locked	In `Locked` mode, input is always written to the terminal and all shortcuts are disabled except the one leading back to normal mode,resize	`Resize` mode allows resizing the different existing panes,pane	`Pane` mode allows creating and closing panes, as well as moving between them,tab	`Tab` mode allows creating and closing tabs, as well as moving between them,scroll	`Scroll` mode allows scrolling up and down within a pane,enter-search	`EnterSearch` mode allows for typing in the needle for a search in the scroll buffer of a pane,search	`Search` mode allows for searching a term in a pane (superset of `Scroll`),rename-tab	`RenameTab` mode allows assigning a new name to a tab,rename-pane	`RenamePane` mode allows assigning a new name to a pane,session	`Session` mode allows detaching sessions,move	`Move` mode allows moving the different existing panes within a tab,prompt	`Prompt` mode allows interacting with active prompts,tmux	`Tmux` mode allows for basic tmux keybindings functionality}"
complete -c zellij -n "__fish_seen_subcommand_from options" -l default-shell -d 'Set the default shell' -r -F
complete -c zellij -n "__fish_seen_subcommand_from options" -l default-cwd -d 'Set the default cwd' -r -F
complete -c zellij -n "__fish_seen_subcommand_from options" -l default-layout -d 'Set the default layout' -r -F
complete -c zellij -n "__fish_seen_subcommand_from options" -l layout-dir -d 'Set the layout_dir, defaults to subdirectory of config dir' -r -F
complete -c zellij -n "__fish_seen_subcommand_from options" -l theme-dir -d 'Set the theme_dir, defaults to subdirectory of config dir' -r -F
complete -c zellij -n "__fish_seen_subcommand_from options" -l mouse-mode -d 'Set the handling of mouse events (true or false) Can be temporarily bypassed by the [SHIFT] key' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from options" -l pane-frames -d 'Set display of the pane frames (true or false)' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from options" -l mirror-session -d 'Mirror session when multiple users are connected (true or false)' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from options" -l on-force-close -d 'Set behaviour on force close (quit or detach)' -r -f -a "{quit	,detach	}"
complete -c zellij -n "__fish_seen_subcommand_from options" -l scroll-buffer-size -r
complete -c zellij -n "__fish_seen_subcommand_from options" -l copy-command -d 'Switch to using a user supplied command for clipboard instead of OSC52' -r
complete -c zellij -n "__fish_seen_subcommand_from options" -l copy-clipboard -d 'OSC52 destination clipboard' -r -f -a "{system	,primary	}"
complete -c zellij -n "__fish_seen_subcommand_from options" -l copy-on-select -d 'Automatically copy when selecting text (true or false)' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from options" -l osc8-hyperlinks -d 'Enable OSC8 hyperlink output (true or false)' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from options" -l scrollback-editor -d 'Explicit full path to open the scrollback editor (default is $EDITOR or $VISUAL)' -r -F
complete -c zellij -n "__fish_seen_subcommand_from options" -l session-name -d 'The name of the session to create when starting Zellij' -r
complete -c zellij -n "__fish_seen_subcommand_from options" -l attach-to-session -d 'Whether to attach to a session specified in "session-name" if it exists' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from options" -l auto-layout -d 'Whether to lay out panes in a predefined set of layouts whenever possible' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from options" -l session-serialization -d 'Whether sessions should be serialized to the HD so that they can be later resurrected, default is true' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from options" -l serialize-pane-viewport -d 'Whether pane viewports are serialized along with the session, default is false' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from options" -l scrollback-lines-to-serialize -d 'Scrollback lines to serialize along with the pane viewport when serializing sessions, 0 defaults to the scrollback size. If this number is higher than the scrollback size, it will also default to the scrollback size' -r
complete -c zellij -n "__fish_seen_subcommand_from options" -l styled-underlines -d 'Whether to use ANSI styled underlines' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from options" -l serialization-interval -d 'The interval at which to serialize sessions for resurrection (in seconds)' -r
complete -c zellij -n "__fish_seen_subcommand_from options" -l disable-session-metadata -d 'If true, will disable writing session metadata to disk' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from options" -l support-kitty-keyboard-protocol -d 'Whether to enable support for the Kitty keyboard protocol (must also be supported by the host terminal), defaults to true if the terminal supports it' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from options" -l web-server -d 'Whether to make sure a local web server is running when a new Zellij session starts. This web server will allow creating new sessions and attaching to existing ones that have opted in to being shared in the browser' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from options" -l web-sharing -d 'Whether to allow new sessions to be shared through a local web server, assuming one is running (see the `web_server` option for more details)' -r -f -a "{on	,off	,disabled	}"
complete -c zellij -n "__fish_seen_subcommand_from options" -l stacked-resize -d 'Whether to stack panes when resizing beyond a certain size default is true' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from options" -l show-startup-tips -d 'Whether to show startup tips when starting a new session default is true' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from options" -l show-release-notes -d 'Whether to show release notes on first run of a new version default is true' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from options" -l advanced-mouse-actions -d 'Whether to enable mouse hover effects and pane grouping functionality default is true' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from options" -l mouse-hover-effects -d 'Whether to enable mouse hover visual effects (frame highlight and help text) default is true' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from options" -l post-command-discovery-hook -d 'A command to run after the discovery of running commands when serializing, for the purpose of manipulating the command (eg. with a regex) before it gets serialized' -r
complete -c zellij -n "__fish_seen_subcommand_from options" -l client-async-worker-tasks -d 'Number of async worker tasks to spawn per active client' -r
complete -c zellij -n "__fish_seen_subcommand_from options" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from setup" -l dump-layout -d 'Dump specified layout to stdout' -r
complete -c zellij -n "__fish_seen_subcommand_from setup" -l dump-swap-layout -d 'Dump the specified swap layout file to stdout' -r
complete -c zellij -n "__fish_seen_subcommand_from setup" -l dump-plugins -d 'Dump the builtin plugins to DIR or "DATA DIR" if unspecified' -r -F
complete -c zellij -n "__fish_seen_subcommand_from setup" -l generate-completion -d 'Generates completion for the specified shell' -r
complete -c zellij -n "__fish_seen_subcommand_from setup" -l generate-auto-start -d 'Generates auto-start script for the specified shell' -r
complete -c zellij -n "__fish_seen_subcommand_from setup" -l dump-config -d 'Dump the default configuration file to stdout'
complete -c zellij -n "__fish_seen_subcommand_from setup" -l clean -d 'Disables loading of configuration file at default location, loads the defaults that zellij ships with'
complete -c zellij -n "__fish_seen_subcommand_from setup" -l check -d 'Checks the configuration of zellij and displays currently used directories'
complete -c zellij -n "__fish_seen_subcommand_from setup" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from web" -l timeout -d 'Timeout in seconds for the status check (default: 30)' -r
complete -c zellij -n "__fish_seen_subcommand_from web" -l token-name -d 'Optional name for the token' -r
complete -c zellij -n "__fish_seen_subcommand_from web" -l revoke-token -d 'Revoke a login token by its name' -r
complete -c zellij -n "__fish_seen_subcommand_from web" -l ip -d 'The ip address to listen on locally for connections (defaults to 127.0.0.1)' -r
complete -c zellij -n "__fish_seen_subcommand_from web" -l port -d 'The port to listen on locally for connections (defaults to 8082)' -r
complete -c zellij -n "__fish_seen_subcommand_from web" -l cert -d 'The path to the SSL certificate (required if not listening on 127.0.0.1)' -r -F
complete -c zellij -n "__fish_seen_subcommand_from web" -l key -d 'The path to the SSL key (required if not listening on 127.0.0.1)' -r -F
complete -c zellij -n "__fish_seen_subcommand_from web" -l start -d 'Start the server (default unless other arguments are specified)'
complete -c zellij -n "__fish_seen_subcommand_from web" -l stop -d 'Stop the server'
complete -c zellij -n "__fish_seen_subcommand_from web" -l status -d 'Get the server status'
complete -c zellij -n "__fish_seen_subcommand_from web" -s d -l daemonize -d 'Run the server in the background'
complete -c zellij -n "__fish_seen_subcommand_from web" -l create-token -d 'Create a login token for the web interface, will only be displayed once and cannot later be retrieved. Returns the token name and the token'
complete -c zellij -n "__fish_seen_subcommand_from web" -l create-read-only-token -d 'Create a read-only login token (can only attach to existing sessions as watcher)'
complete -c zellij -n "__fish_seen_subcommand_from web" -l revoke-all-tokens -d 'Revoke all login tokens'
complete -c zellij -n "__fish_seen_subcommand_from web" -l list-tokens -d 'List token names and their creation dates (cannot show actual tokens)'
complete -c zellij -n "__fish_seen_subcommand_from web" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from list-sessions" -s n -l no-formatting -d 'Do not add colors and formatting to the list (useful for parsing)'
complete -c zellij -n "__fish_seen_subcommand_from list-sessions" -s s -l short -d 'Print just the session name'
complete -c zellij -n "__fish_seen_subcommand_from list-sessions" -s r -l reverse -d 'List the sessions in reverse order (default is ascending order)'
complete -c zellij -n "__fish_seen_subcommand_from list-sessions" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from list-aliases" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from attach; and not __fish_seen_subcommand_from options; and not __fish_seen_subcommand_from help" -l index -d 'Number of the session index in the active sessions ordered creation date' -r
complete -c zellij -n "__fish_seen_subcommand_from attach; and not __fish_seen_subcommand_from options; and not __fish_seen_subcommand_from help" -s t -l token -d 'Authentication token for remote sessions' -r
complete -c zellij -n "__fish_seen_subcommand_from attach; and not __fish_seen_subcommand_from options; and not __fish_seen_subcommand_from help" -s c -l create -d 'Create a session if one does not exist'
complete -c zellij -n "__fish_seen_subcommand_from attach; and not __fish_seen_subcommand_from options; and not __fish_seen_subcommand_from help" -s b -l create-background -d 'Create a detached session in the background if one does not exist'
complete -c zellij -n "__fish_seen_subcommand_from attach; and not __fish_seen_subcommand_from options; and not __fish_seen_subcommand_from help" -s f -l force-run-commands -d 'If resurrecting a dead session, immediately run all its commands on startup'
complete -c zellij -n "__fish_seen_subcommand_from attach; and not __fish_seen_subcommand_from options; and not __fish_seen_subcommand_from help" -s r -l remember -d 'Save session for automatic re-authentication (4 weeks)'
complete -c zellij -n "__fish_seen_subcommand_from attach; and not __fish_seen_subcommand_from options; and not __fish_seen_subcommand_from help" -l forget -d 'Delete saved session before connecting'
complete -c zellij -n "__fish_seen_subcommand_from attach; and not __fish_seen_subcommand_from options; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from attach; and not __fish_seen_subcommand_from options; and not __fish_seen_subcommand_from help" -f -a "options" -d 'Change the behaviour of zellij'
complete -c zellij -n "__fish_seen_subcommand_from attach; and not __fish_seen_subcommand_from options; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c zellij -n "__fish_seen_subcommand_from attach; and __fish_seen_subcommand_from options" -l simplified-ui -d 'Allow plugins to use a more simplified layout that is compatible with more fonts (true or false)' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from attach; and __fish_seen_subcommand_from options" -l theme -d 'Set the default theme' -r
complete -c zellij -n "__fish_seen_subcommand_from attach; and __fish_seen_subcommand_from options" -l default-mode -d 'Set the default mode' -r -f -a "{normal	In `Normal` mode, input is always written to the terminal, except for the shortcuts leading to other modes,locked	In `Locked` mode, input is always written to the terminal and all shortcuts are disabled except the one leading back to normal mode,resize	`Resize` mode allows resizing the different existing panes,pane	`Pane` mode allows creating and closing panes, as well as moving between them,tab	`Tab` mode allows creating and closing tabs, as well as moving between them,scroll	`Scroll` mode allows scrolling up and down within a pane,enter-search	`EnterSearch` mode allows for typing in the needle for a search in the scroll buffer of a pane,search	`Search` mode allows for searching a term in a pane (superset of `Scroll`),rename-tab	`RenameTab` mode allows assigning a new name to a tab,rename-pane	`RenamePane` mode allows assigning a new name to a pane,session	`Session` mode allows detaching sessions,move	`Move` mode allows moving the different existing panes within a tab,prompt	`Prompt` mode allows interacting with active prompts,tmux	`Tmux` mode allows for basic tmux keybindings functionality}"
complete -c zellij -n "__fish_seen_subcommand_from attach; and __fish_seen_subcommand_from options" -l default-shell -d 'Set the default shell' -r -F
complete -c zellij -n "__fish_seen_subcommand_from attach; and __fish_seen_subcommand_from options" -l default-cwd -d 'Set the default cwd' -r -F
complete -c zellij -n "__fish_seen_subcommand_from attach; and __fish_seen_subcommand_from options" -l default-layout -d 'Set the default layout' -r -F
complete -c zellij -n "__fish_seen_subcommand_from attach; and __fish_seen_subcommand_from options" -l layout-dir -d 'Set the layout_dir, defaults to subdirectory of config dir' -r -F
complete -c zellij -n "__fish_seen_subcommand_from attach; and __fish_seen_subcommand_from options" -l theme-dir -d 'Set the theme_dir, defaults to subdirectory of config dir' -r -F
complete -c zellij -n "__fish_seen_subcommand_from attach; and __fish_seen_subcommand_from options" -l mouse-mode -d 'Set the handling of mouse events (true or false) Can be temporarily bypassed by the [SHIFT] key' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from attach; and __fish_seen_subcommand_from options" -l pane-frames -d 'Set display of the pane frames (true or false)' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from attach; and __fish_seen_subcommand_from options" -l mirror-session -d 'Mirror session when multiple users are connected (true or false)' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from attach; and __fish_seen_subcommand_from options" -l on-force-close -d 'Set behaviour on force close (quit or detach)' -r -f -a "{quit	,detach	}"
complete -c zellij -n "__fish_seen_subcommand_from attach; and __fish_seen_subcommand_from options" -l scroll-buffer-size -r
complete -c zellij -n "__fish_seen_subcommand_from attach; and __fish_seen_subcommand_from options" -l copy-command -d 'Switch to using a user supplied command for clipboard instead of OSC52' -r
complete -c zellij -n "__fish_seen_subcommand_from attach; and __fish_seen_subcommand_from options" -l copy-clipboard -d 'OSC52 destination clipboard' -r -f -a "{system	,primary	}"
complete -c zellij -n "__fish_seen_subcommand_from attach; and __fish_seen_subcommand_from options" -l copy-on-select -d 'Automatically copy when selecting text (true or false)' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from attach; and __fish_seen_subcommand_from options" -l osc8-hyperlinks -d 'Enable OSC8 hyperlink output (true or false)' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from attach; and __fish_seen_subcommand_from options" -l scrollback-editor -d 'Explicit full path to open the scrollback editor (default is $EDITOR or $VISUAL)' -r -F
complete -c zellij -n "__fish_seen_subcommand_from attach; and __fish_seen_subcommand_from options" -l session-name -d 'The name of the session to create when starting Zellij' -r
complete -c zellij -n "__fish_seen_subcommand_from attach; and __fish_seen_subcommand_from options" -l attach-to-session -d 'Whether to attach to a session specified in "session-name" if it exists' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from attach; and __fish_seen_subcommand_from options" -l auto-layout -d 'Whether to lay out panes in a predefined set of layouts whenever possible' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from attach; and __fish_seen_subcommand_from options" -l session-serialization -d 'Whether sessions should be serialized to the HD so that they can be later resurrected, default is true' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from attach; and __fish_seen_subcommand_from options" -l serialize-pane-viewport -d 'Whether pane viewports are serialized along with the session, default is false' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from attach; and __fish_seen_subcommand_from options" -l scrollback-lines-to-serialize -d 'Scrollback lines to serialize along with the pane viewport when serializing sessions, 0 defaults to the scrollback size. If this number is higher than the scrollback size, it will also default to the scrollback size' -r
complete -c zellij -n "__fish_seen_subcommand_from attach; and __fish_seen_subcommand_from options" -l styled-underlines -d 'Whether to use ANSI styled underlines' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from attach; and __fish_seen_subcommand_from options" -l serialization-interval -d 'The interval at which to serialize sessions for resurrection (in seconds)' -r
complete -c zellij -n "__fish_seen_subcommand_from attach; and __fish_seen_subcommand_from options" -l disable-session-metadata -d 'If true, will disable writing session metadata to disk' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from attach; and __fish_seen_subcommand_from options" -l support-kitty-keyboard-protocol -d 'Whether to enable support for the Kitty keyboard protocol (must also be supported by the host terminal), defaults to true if the terminal supports it' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from attach; and __fish_seen_subcommand_from options" -l web-server -d 'Whether to make sure a local web server is running when a new Zellij session starts. This web server will allow creating new sessions and attaching to existing ones that have opted in to being shared in the browser' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from attach; and __fish_seen_subcommand_from options" -l web-sharing -d 'Whether to allow new sessions to be shared through a local web server, assuming one is running (see the `web_server` option for more details)' -r -f -a "{on	,off	,disabled	}"
complete -c zellij -n "__fish_seen_subcommand_from attach; and __fish_seen_subcommand_from options" -l stacked-resize -d 'Whether to stack panes when resizing beyond a certain size default is true' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from attach; and __fish_seen_subcommand_from options" -l show-startup-tips -d 'Whether to show startup tips when starting a new session default is true' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from attach; and __fish_seen_subcommand_from options" -l show-release-notes -d 'Whether to show release notes on first run of a new version default is true' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from attach; and __fish_seen_subcommand_from options" -l advanced-mouse-actions -d 'Whether to enable mouse hover effects and pane grouping functionality default is true' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from attach; and __fish_seen_subcommand_from options" -l mouse-hover-effects -d 'Whether to enable mouse hover visual effects (frame highlight and help text) default is true' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from attach; and __fish_seen_subcommand_from options" -l post-command-discovery-hook -d 'A command to run after the discovery of running commands when serializing, for the purpose of manipulating the command (eg. with a regex) before it gets serialized' -r
complete -c zellij -n "__fish_seen_subcommand_from attach; and __fish_seen_subcommand_from options" -l client-async-worker-tasks -d 'Number of async worker tasks to spawn per active client' -r
complete -c zellij -n "__fish_seen_subcommand_from attach; and __fish_seen_subcommand_from options" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from watch" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from kill-session" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from delete-session" -s f -l force -d 'Kill the session if it\'s running before deleting it'
complete -c zellij -n "__fish_seen_subcommand_from delete-session" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from kill-all-sessions" -s y -l yes -d 'Automatic yes to prompts'
complete -c zellij -n "__fish_seen_subcommand_from kill-all-sessions" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from delete-all-sessions" -s y -l yes -d 'Automatic yes to prompts'
complete -c zellij -n "__fish_seen_subcommand_from delete-all-sessions" -s f -l force -d 'Kill the sessions if they\'re running before deleting them'
complete -c zellij -n "__fish_seen_subcommand_from delete-all-sessions" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "write" -d 'Write bytes to the terminal'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "write-chars" -d 'Write characters to the terminal'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "send-keys" -d 'Send one or more keys to the terminal (e.g., "Ctrl a", "F1", "Alt Shift b")'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "resize" -d '[increase|decrease] the focused panes area at the [left|down|up|right] border'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "focus-next-pane" -d 'Change focus to the next pane'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "focus-previous-pane" -d 'Change focus to the previous pane'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "move-focus" -d 'Move the focused pane in the specified direction. [right|left|up|down]'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "move-focus-or-tab" -d 'Move focus to the pane or tab (if on screen edge) in the specified direction [right|left|up|down]'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "move-pane" -d 'Change the location of the focused pane in the specified direction or rotate forwrads [right|left|up|down]'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "move-pane-backwards" -d 'Rotate the location of the previous pane backwards'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "clear" -d 'Clear all buffers for a focused pane'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "dump-screen" -d 'Dump the focused pane to a file'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "dump-layout" -d 'Dump current layout to stdout'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "save-session" -d 'Save the current session state to disk immediately'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "edit-scrollback" -d 'Open the pane scrollback in your default editor'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "scroll-up" -d 'Scroll up in the focused pane'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "scroll-down" -d 'Scroll down in focus pane'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "scroll-to-bottom" -d 'Scroll down to bottom in focus pane'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "scroll-to-top" -d 'Scroll up to top in focus pane'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "page-scroll-up" -d 'Scroll up one page in focus pane'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "page-scroll-down" -d 'Scroll down one page in focus pane'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "half-page-scroll-up" -d 'Scroll up half page in focus pane'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "half-page-scroll-down" -d 'Scroll down half page in focus pane'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "toggle-fullscreen" -d 'Toggle between fullscreen focus pane and normal layout'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "toggle-pane-frames" -d 'Toggle frames around panes in the UI'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "toggle-active-sync-tab" -d 'Toggle between sending text commands to all panes on the current tab and normal mode'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "new-pane" -d 'Open a new pane in the specified direction [right|down] If no direction is specified, will try to use the biggest available space. Returns: Created pane ID (format: terminal_<id> or plugin_<id>)'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "edit" -d 'Open the specified file in a new zellij pane with your default EDITOR Returns: Created pane ID (format: terminal_<id>)'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "switch-mode" -d 'Switch input mode of all connected clients [locked|pane|tab|resize|move|search|session]'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "toggle-pane-embed-or-floating" -d 'Embed focused pane if floating or float focused pane if embedded'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "toggle-floating-panes" -d 'Toggle the visibility of all floating panes in the current Tab, open one if none exist'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "show-floating-panes" -d 'Show all floating panes in the specified tab (or active tab if tab_id is not provided)'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "hide-floating-panes" -d 'Hide all floating panes in the specified tab (or active tab if tab_id is not provided)'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "close-pane" -d 'Close the focused pane'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "rename-pane" -d 'Renames the focused pane'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "undo-rename-pane" -d 'Remove a previously set pane name'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "go-to-next-tab" -d 'Go to the next tab'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "go-to-previous-tab" -d 'Go to the previous tab'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "close-tab" -d 'Close the current tab'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "go-to-tab" -d 'Go to tab with index [index]'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "go-to-tab-name" -d 'Go to tab with name [name]'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "rename-tab" -d 'Renames the focused pane'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "undo-rename-tab" -d 'Remove a previously set tab name'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "go-to-tab-by-id" -d 'Go to tab with stable ID'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "close-tab-by-id" -d 'Close tab with stable ID'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "rename-tab-by-id" -d 'Rename tab by stable ID'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "new-tab" -d 'Create a new tab, optionally with a specified tab layout and name'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "move-tab" -d 'Move the focused tab in the specified direction. [right|left]'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "previous-swap-layout"
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "next-swap-layout"
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "override-layout" -d 'Override the layout of the active tab'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "query-tab-names" -d 'Query all tab names'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "start-or-reload-plugin"
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "launch-or-focus-plugin" -d 'Returns: Plugin pane ID (format: plugin_<id>) when creating or focusing plugin'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "launch-plugin" -d 'Returns: Plugin pane ID (format: plugin_<id>)'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "rename-session"
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "pipe" -d 'Send data to one or more plugins, launch them if they are not running'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "list-clients"
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "list-panes" -d 'List all panes in the current session'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "list-tabs" -d 'List all tabs with their information'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "current-tab-info" -d 'Get information about the currently active tab'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "toggle-pane-pinned"
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "stack-panes" -d 'Stack pane ids Ids are a space separated list of pane ids. They should either be in the form of `terminal_<int>` (eg. terminal_1), `plugin_<int>` (eg. plugin_1) or bare integers in which case they\'ll be considered terminals (eg. 1 is the equivalent of terminal_1)'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "change-floating-pane-coordinates"
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "toggle-pane-borderless"
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "set-pane-borderless"
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "detach" -d 'Detach from the current session'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "switch-session" -d 'Switch to a different session'
complete -c zellij -n "__fish_seen_subcommand_from action; and not __fish_seen_subcommand_from write; and not __fish_seen_subcommand_from write-chars; and not __fish_seen_subcommand_from send-keys; and not __fish_seen_subcommand_from resize; and not __fish_seen_subcommand_from focus-next-pane; and not __fish_seen_subcommand_from focus-previous-pane; and not __fish_seen_subcommand_from move-focus; and not __fish_seen_subcommand_from move-focus-or-tab; and not __fish_seen_subcommand_from move-pane; and not __fish_seen_subcommand_from move-pane-backwards; and not __fish_seen_subcommand_from clear; and not __fish_seen_subcommand_from dump-screen; and not __fish_seen_subcommand_from dump-layout; and not __fish_seen_subcommand_from save-session; and not __fish_seen_subcommand_from edit-scrollback; and not __fish_seen_subcommand_from scroll-up; and not __fish_seen_subcommand_from scroll-down; and not __fish_seen_subcommand_from scroll-to-bottom; and not __fish_seen_subcommand_from scroll-to-top; and not __fish_seen_subcommand_from page-scroll-up; and not __fish_seen_subcommand_from page-scroll-down; and not __fish_seen_subcommand_from half-page-scroll-up; and not __fish_seen_subcommand_from half-page-scroll-down; and not __fish_seen_subcommand_from toggle-fullscreen; and not __fish_seen_subcommand_from toggle-pane-frames; and not __fish_seen_subcommand_from toggle-active-sync-tab; and not __fish_seen_subcommand_from new-pane; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from switch-mode; and not __fish_seen_subcommand_from toggle-pane-embed-or-floating; and not __fish_seen_subcommand_from toggle-floating-panes; and not __fish_seen_subcommand_from show-floating-panes; and not __fish_seen_subcommand_from hide-floating-panes; and not __fish_seen_subcommand_from close-pane; and not __fish_seen_subcommand_from rename-pane; and not __fish_seen_subcommand_from undo-rename-pane; and not __fish_seen_subcommand_from go-to-next-tab; and not __fish_seen_subcommand_from go-to-previous-tab; and not __fish_seen_subcommand_from close-tab; and not __fish_seen_subcommand_from go-to-tab; and not __fish_seen_subcommand_from go-to-tab-name; and not __fish_seen_subcommand_from rename-tab; and not __fish_seen_subcommand_from undo-rename-tab; and not __fish_seen_subcommand_from go-to-tab-by-id; and not __fish_seen_subcommand_from close-tab-by-id; and not __fish_seen_subcommand_from rename-tab-by-id; and not __fish_seen_subcommand_from new-tab; and not __fish_seen_subcommand_from move-tab; and not __fish_seen_subcommand_from previous-swap-layout; and not __fish_seen_subcommand_from next-swap-layout; and not __fish_seen_subcommand_from override-layout; and not __fish_seen_subcommand_from query-tab-names; and not __fish_seen_subcommand_from start-or-reload-plugin; and not __fish_seen_subcommand_from launch-or-focus-plugin; and not __fish_seen_subcommand_from launch-plugin; and not __fish_seen_subcommand_from rename-session; and not __fish_seen_subcommand_from pipe; and not __fish_seen_subcommand_from list-clients; and not __fish_seen_subcommand_from list-panes; and not __fish_seen_subcommand_from list-tabs; and not __fish_seen_subcommand_from current-tab-info; and not __fish_seen_subcommand_from toggle-pane-pinned; and not __fish_seen_subcommand_from stack-panes; and not __fish_seen_subcommand_from change-floating-pane-coordinates; and not __fish_seen_subcommand_from toggle-pane-borderless; and not __fish_seen_subcommand_from set-pane-borderless; and not __fish_seen_subcommand_from detach; and not __fish_seen_subcommand_from switch-session; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from write" -s p -l pane-id -d 'The pane_id of the pane, eg. terminal_1, plugin_2 or 3 (equivalent to terminal_3)' -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from write" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from write-chars" -s p -l pane-id -d 'The pane_id of the pane, eg. terminal_1, plugin_2 or 3 (equivalent to terminal_3)' -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from write-chars" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from send-keys" -s p -l pane-id -d 'The pane_id of the pane, eg. terminal_1, plugin_2 or 3 (equivalent to terminal_3)' -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from send-keys" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from resize" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from focus-next-pane" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from focus-previous-pane" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from move-focus" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from move-focus-or-tab" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from move-pane" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from move-pane-backwards" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from clear" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from dump-screen" -s f -l full -d 'Dump the pane with full scrollback'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from dump-screen" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from dump-layout" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from save-session" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from edit-scrollback" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from scroll-up" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from scroll-down" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from scroll-to-bottom" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from scroll-to-top" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from page-scroll-up" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from page-scroll-down" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from half-page-scroll-up" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from half-page-scroll-down" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from toggle-fullscreen" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from toggle-pane-frames" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from toggle-active-sync-tab" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from new-pane" -s d -l direction -d 'Direction to open the new pane in' -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from new-pane" -s p -l plugin -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from new-pane" -l cwd -d 'Change the working directory of the new pane' -r -F
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from new-pane" -s n -l name -d 'Name of the new pane' -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from new-pane" -l configuration -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from new-pane" -s x -l x -d 'The x coordinates if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)' -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from new-pane" -s y -l y -d 'The y coordinates if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)' -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from new-pane" -l width -d 'The width if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)' -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from new-pane" -l height -d 'The height if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)' -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from new-pane" -l pinned -d 'Whether to pin a floating pane so that it is always on top' -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from new-pane" -l borderless -d 'start this pane without a border (warning: will make it impossible to move with the mouse)' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from new-pane" -s f -l floating -d 'Open the new pane in floating mode'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from new-pane" -s i -l in-place -d 'Open the new pane in place of the current pane, temporarily suspending it'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from new-pane" -l close-replaced-pane -d 'Close the replaced pane instead of suspending it (only effective with --in-place)'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from new-pane" -s c -l close-on-exit -d 'Close the pane immediately when its command exits'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from new-pane" -s s -l start-suspended -d 'Start the command suspended, only running it after the you first press ENTER'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from new-pane" -l skip-plugin-cache
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from new-pane" -l stacked
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from new-pane" -s b -l blocking
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from new-pane" -l near-current-pane -d 'if set, will open the pane near the current one rather than following the user\'s focus'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from new-pane" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from edit" -s d -l direction -d 'Direction to open the new pane in' -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from edit" -s l -l line-number -d 'Open the file in the specified line number' -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from edit" -l cwd -d 'Change the working directory of the editor' -r -F
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from edit" -s x -l x -d 'The x coordinates if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)' -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from edit" -s y -l y -d 'The y coordinates if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)' -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from edit" -l width -d 'The width if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)' -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from edit" -l height -d 'The height if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)' -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from edit" -l pinned -d 'Whether to pin a floating pane so that it is always on top' -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from edit" -s b -l borderless -d 'start this pane without a border (warning: will make it impossible to move with the mouse)' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from edit" -s f -l floating -d 'Open the new pane in floating mode'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from edit" -s i -l in-place -d 'Open the new pane in place of the current pane, temporarily suspending it'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from edit" -l close-replaced-pane -d 'Close the replaced pane instead of suspending it (only effective with --in-place)'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from edit" -l near-current-pane -d 'if set, will open the pane near the current one rather than following the user\'s focus'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from edit" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from switch-mode" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from toggle-pane-embed-or-floating" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from toggle-floating-panes" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from show-floating-panes" -s t -l tab-id -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from show-floating-panes" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from hide-floating-panes" -s t -l tab-id -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from hide-floating-panes" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from close-pane" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from rename-pane" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from undo-rename-pane" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from go-to-next-tab" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from go-to-previous-tab" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from close-tab" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from go-to-tab" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from go-to-tab-name" -s c -l create -d 'Create a tab if one does not exist'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from go-to-tab-name" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from rename-tab" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from undo-rename-tab" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from go-to-tab-by-id" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from close-tab-by-id" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from rename-tab-by-id" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from new-tab" -s l -l layout -d 'Layout to use for the new tab' -r -F
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from new-tab" -l layout-dir -d 'Default folder to look for layouts' -r -F
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from new-tab" -s n -l name -d 'Name of the new tab' -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from new-tab" -s c -l cwd -d 'Change the working directory of the new tab' -r -F
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from new-tab" -l initial-plugin -d 'Initial plugin to load in the new tab' -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from new-tab" -l close-on-exit -d 'Close the pane immediately when its command exits'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from new-tab" -l start-suspended -d 'Start the command suspended, only running it after you first press ENTER'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from new-tab" -l block-until-exit-success -d 'Block until the command exits successfully (exit status 0) OR its pane has been closed'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from new-tab" -l block-until-exit-failure -d 'Block until the command exits with failure (non-zero exit status) OR its pane has been closed'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from new-tab" -l block-until-exit -d 'Block until the command exits (regardless of exit status) OR its pane has been closed'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from new-tab" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from move-tab" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from previous-swap-layout" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from next-swap-layout" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from override-layout" -l layout-dir -d 'Default folder to look for layouts' -r -F
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from override-layout" -l retain-existing-terminal-panes -d 'Retain existing terminal panes that do not fit in the layout (default: false)'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from override-layout" -l retain-existing-plugin-panes -d 'Retain existing plugin panes that do not fit with the layout default: false)'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from override-layout" -l apply-only-to-active-tab -d 'Only apply the layout to the active tab (uses just the first layout tab if it has multiple)'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from override-layout" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from query-tab-names" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from start-or-reload-plugin" -s c -l configuration -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from start-or-reload-plugin" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from launch-or-focus-plugin" -s c -l configuration -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from launch-or-focus-plugin" -s f -l floating
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from launch-or-focus-plugin" -s i -l in-place
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from launch-or-focus-plugin" -l close-replaced-pane -d 'Close the replaced pane instead of suspending it (only effective with --in-place)'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from launch-or-focus-plugin" -s m -l move-to-focused-tab
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from launch-or-focus-plugin" -s s -l skip-plugin-cache
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from launch-or-focus-plugin" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from launch-plugin" -s c -l configuration -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from launch-plugin" -s f -l floating
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from launch-plugin" -s i -l in-place
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from launch-plugin" -l close-replaced-pane -d 'Close the replaced pane instead of suspending it (only effective with --in-place)'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from launch-plugin" -s s -l skip-plugin-cache
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from launch-plugin" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from rename-session" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from pipe" -s n -l name -d 'The name of the pipe' -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from pipe" -s a -l args -d 'The args of the pipe' -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from pipe" -s p -l plugin -d 'The plugin url (eg. file:/tmp/my-plugin.wasm) to direct this pipe to, if not specified, will be sent to all plugins, if specified and is not running, the plugin will be launched' -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from pipe" -s c -l plugin-configuration -d 'The plugin configuration (note: the same plugin with different configuration is considered a different plugin for the purposes of determining the pipe destination)' -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from pipe" -s f -l floating-plugin -d 'If launching a plugin, should it be floating or not, defaults to floating' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from pipe" -s i -l in-place-plugin -d 'If launching a plugin, launch it in-place (on top of the current pane)' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from pipe" -s w -l plugin-cwd -d 'If launching a plugin, specify its working directory' -r -F
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from pipe" -s t -l plugin-title -d 'If launching a plugin, specify its pane title' -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from pipe" -s l -l force-launch-plugin -d 'Launch a new plugin even if one is already running'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from pipe" -s s -l skip-plugin-cache -d 'If launching a new plugin, skip cache and force-compile the plugin'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from pipe" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from list-clients" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from list-panes" -s t -l tab -d 'Include tab information (name, position, ID)'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from list-panes" -s c -l command -d 'Include running command information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from list-panes" -s s -l state -d 'Include pane state (focused, floating, exited, etc.)'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from list-panes" -s g -l geometry -d 'Include geometry (position, size)'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from list-panes" -s a -l all -d 'Include all available fields'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from list-panes" -s j -l json -d 'Output as JSON'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from list-panes" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from list-tabs" -s s -l state -d 'Include state information (active, fullscreen, sync, floating visibility)'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from list-tabs" -s d -l dimensions -d 'Include dimension information (viewport, display area)'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from list-tabs" -s p -l panes -d 'Include pane counts'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from list-tabs" -s l -l layout -d 'Include layout information (swap layout name and dirty state)'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from list-tabs" -s a -l all -d 'Include all available fields'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from list-tabs" -s j -l json -d 'Output as JSON'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from list-tabs" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from current-tab-info" -s j -l json -d 'Output as JSON with full TabInfo'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from current-tab-info" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from toggle-pane-pinned" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from stack-panes" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from change-floating-pane-coordinates" -s p -l pane-id -d 'The pane_id of the floating pane, eg.  terminal_1, plugin_2 or 3 (equivalent to terminal_3)' -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from change-floating-pane-coordinates" -s x -l x -d 'The x coordinates if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)' -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from change-floating-pane-coordinates" -s y -l y -d 'The y coordinates if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)' -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from change-floating-pane-coordinates" -l width -d 'The width if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)' -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from change-floating-pane-coordinates" -l height -d 'The height if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)' -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from change-floating-pane-coordinates" -l pinned -d 'Whether to pin a floating pane so that it is always on top' -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from change-floating-pane-coordinates" -s b -l borderless -d 'change this pane to be with/without a border (warning: will make it impossible to move with the mouse if without a border)' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from change-floating-pane-coordinates" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from toggle-pane-borderless" -s p -l pane-id -d 'The pane_id of the pane, eg. terminal_1, plugin_2 or 3 (equivalent to terminal_3)' -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from toggle-pane-borderless" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from set-pane-borderless" -s p -l pane-id -d 'The pane_id of the pane, eg. terminal_1, plugin_2 or 3 (equivalent to terminal_3)' -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from set-pane-borderless" -s b -l borderless -d 'Whether the pane should be borderless (flag present) or bordered (flag absent)'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from set-pane-borderless" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from detach" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from switch-session" -l tab-position -d 'Optional tab position to focus' -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from switch-session" -l pane-id -d 'Optional pane ID to focus (eg. "terminal_1" for terminal pane with id 1, or "plugin_2" for plugin pane with id 2)' -r
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from switch-session" -s l -l layout -d 'Layout to apply when switching to the session (relative paths start at layout-dir)' -r -F
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from switch-session" -l layout-dir -d 'Default folder to look for layouts' -r -F
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from switch-session" -s c -l cwd -d 'Change the working directory when switching' -r -F
complete -c zellij -n "__fish_seen_subcommand_from action; and __fish_seen_subcommand_from switch-session" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from run" -s d -l direction -d 'Direction to open the new pane in' -r
complete -c zellij -n "__fish_seen_subcommand_from run" -l cwd -d 'Change the working directory of the new pane' -r -F
complete -c zellij -n "__fish_seen_subcommand_from run" -s n -l name -d 'Name of the new pane' -r
complete -c zellij -n "__fish_seen_subcommand_from run" -s x -l x -d 'The x coordinates if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)' -r
complete -c zellij -n "__fish_seen_subcommand_from run" -s y -l y -d 'The y coordinates if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)' -r
complete -c zellij -n "__fish_seen_subcommand_from run" -l width -d 'The width if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)' -r
complete -c zellij -n "__fish_seen_subcommand_from run" -l height -d 'The height if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)' -r
complete -c zellij -n "__fish_seen_subcommand_from run" -l pinned -d 'Whether to pin a floating pane so that it is always on top' -r
complete -c zellij -n "__fish_seen_subcommand_from run" -s b -l borderless -d 'start this pane without a border (warning: will make it impossible to move with the mouse)' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from run" -s f -l floating -d 'Open the new pane in floating mode'
complete -c zellij -n "__fish_seen_subcommand_from run" -s i -l in-place -d 'Open the new pane in place of the current pane, temporarily suspending it'
complete -c zellij -n "__fish_seen_subcommand_from run" -l close-replaced-pane -d 'Close the replaced pane instead of suspending it (only effective with --in-place)'
complete -c zellij -n "__fish_seen_subcommand_from run" -s c -l close-on-exit -d 'Close the pane immediately when its command exits'
complete -c zellij -n "__fish_seen_subcommand_from run" -s s -l start-suspended -d 'Start the command suspended, only running after you first presses ENTER'
complete -c zellij -n "__fish_seen_subcommand_from run" -l stacked
complete -c zellij -n "__fish_seen_subcommand_from run" -l blocking -d 'Block until the command has finished and its pane has been closed'
complete -c zellij -n "__fish_seen_subcommand_from run" -l block-until-exit-success -d 'Block until the command exits successfully (exit status 0) OR its pane has been closed'
complete -c zellij -n "__fish_seen_subcommand_from run" -l block-until-exit-failure -d 'Block until the command exits with failure (non-zero exit status) OR its pane has been closed'
complete -c zellij -n "__fish_seen_subcommand_from run" -l block-until-exit -d 'Block until the command exits (regardless of exit status) OR its pane has been closed'
complete -c zellij -n "__fish_seen_subcommand_from run" -l near-current-pane -d 'if set, will open the pane near the current one rather than following the user\'s focus'
complete -c zellij -n "__fish_seen_subcommand_from run" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from plugin" -s c -l configuration -d 'Plugin configuration' -r
complete -c zellij -n "__fish_seen_subcommand_from plugin" -s x -l x -d 'The x coordinates if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)' -r
complete -c zellij -n "__fish_seen_subcommand_from plugin" -s y -l y -d 'The y coordinates if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)' -r
complete -c zellij -n "__fish_seen_subcommand_from plugin" -l width -d 'The width if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)' -r
complete -c zellij -n "__fish_seen_subcommand_from plugin" -l height -d 'The height if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)' -r
complete -c zellij -n "__fish_seen_subcommand_from plugin" -l pinned -d 'Whether to pin a floating pane so that it is always on top' -r
complete -c zellij -n "__fish_seen_subcommand_from plugin" -s b -l borderless -d 'start this pane without a border (warning: will make it impossible to move with the mouse)' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from plugin" -s f -l floating -d 'Open the new pane in floating mode'
complete -c zellij -n "__fish_seen_subcommand_from plugin" -s i -l in-place -d 'Open the new pane in place of the current pane, temporarily suspending it'
complete -c zellij -n "__fish_seen_subcommand_from plugin" -l close-replaced-pane -d 'Close the replaced pane instead of suspending it (only effective with --in-place)'
complete -c zellij -n "__fish_seen_subcommand_from plugin" -s s -l skip-plugin-cache -d 'Skip the memory and HD cache and force recompile of the plugin (good for development)'
complete -c zellij -n "__fish_seen_subcommand_from plugin" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from edit" -s l -l line-number -d 'Open the file in the specified line number' -r
complete -c zellij -n "__fish_seen_subcommand_from edit" -s d -l direction -d 'Direction to open the new pane in' -r
complete -c zellij -n "__fish_seen_subcommand_from edit" -l cwd -d 'Change the working directory of the editor' -r -F
complete -c zellij -n "__fish_seen_subcommand_from edit" -s x -l x -d 'The x coordinates if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)' -r
complete -c zellij -n "__fish_seen_subcommand_from edit" -s y -l y -d 'The y coordinates if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)' -r
complete -c zellij -n "__fish_seen_subcommand_from edit" -l width -d 'The width if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)' -r
complete -c zellij -n "__fish_seen_subcommand_from edit" -l height -d 'The height if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)' -r
complete -c zellij -n "__fish_seen_subcommand_from edit" -l pinned -d 'Whether to pin a floating pane so that it is always on top' -r
complete -c zellij -n "__fish_seen_subcommand_from edit" -s b -l borderless -d 'start this pane without a border (warning: will make it impossible to move with the mouse)' -r -f -a "{true	,false	}"
complete -c zellij -n "__fish_seen_subcommand_from edit" -s i -l in-place -d 'Open the new pane in place of the current pane, temporarily suspending it'
complete -c zellij -n "__fish_seen_subcommand_from edit" -l close-replaced-pane -d 'Close the replaced pane instead of suspending it (only effective with --in-place)'
complete -c zellij -n "__fish_seen_subcommand_from edit" -s f -l floating -d 'Open the new pane in floating mode'
complete -c zellij -n "__fish_seen_subcommand_from edit" -l near-current-pane -d 'if set, will open the pane near the current one rather than following the user\'s focus'
complete -c zellij -n "__fish_seen_subcommand_from edit" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from convert-config" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from convert-layout" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from convert-theme" -s h -l help -d 'Print help information'
complete -c zellij -n "__fish_seen_subcommand_from pipe" -s n -l name -d 'The name of the pipe' -r
complete -c zellij -n "__fish_seen_subcommand_from pipe" -s a -l args -d 'The args of the pipe' -r
complete -c zellij -n "__fish_seen_subcommand_from pipe" -s p -l plugin -d 'The plugin url (eg. file:/tmp/my-plugin.wasm) to direct this pipe to, if not specified, will be sent to all plugins, if specified and is not running, the plugin will be launched' -r
complete -c zellij -n "__fish_seen_subcommand_from pipe" -s c -l plugin-configuration -d 'The plugin configuration (note: the same plugin with different configuration is considered a different plugin for the purposes of determining the pipe destination)' -r
complete -c zellij -n "__fish_seen_subcommand_from pipe" -s h -l help -d 'Print help information'
function __fish_complete_sessions
    zellij list-sessions --short --no-formatting 2>/dev/null
end
complete -c zellij -n "__fish_seen_subcommand_from attach" -f -a "(__fish_complete_sessions)" -d "Session"
complete -c zellij -n "__fish_seen_subcommand_from a" -f -a "(__fish_complete_sessions)" -d "Session"
complete -c zellij -n "__fish_seen_subcommand_from kill-session" -f -a "(__fish_complete_sessions)" -d "Session"
complete -c zellij -n "__fish_seen_subcommand_from k" -f -a "(__fish_complete_sessions)" -d "Session"
complete -c zellij -n "__fish_seen_subcommand_from setup" -l "generate-completion" -x -a "bash elvish fish zsh powershell" -d "Shell"
function zr
  command zellij run --name "$argv" -- fish -c "$argv"
end
function zrf
  command zellij run --name "$argv" --floating -- fish -c "$argv"
end
function zri
  command zellij run --name "$argv" --in-place -- fish -c "$argv"
end
function ze
  command zellij edit $argv
end
function zef
  command zellij edit --floating $argv
end
function zei
  command zellij edit --in-place $argv
end

# the zpipe alias and its completions
function __fish_complete_aliases
  zellij list-aliases 2>/dev/null
end
function zpipe
  if count $argv > /dev/null
    command zellij pipe -p $argv
  else
    command zellij pipe
  end
end
complete -c zpipe -f -a "(__fish_complete_aliases)" -d "Zpipes"