var plasma = getApiVersion(1)

// Center Krunner on screen - requires relogin
const krunner = ConfigFile('krunnerrc')
krunner.group = 'General'
krunner.writeEntry('FreeFloating', true);

// Change keyboard repeat delay from default 600ms to 250ms
const kbd = ConfigFile('kcminputrc')
kbd.group = 'Keyboard'
kbd.writeEntry('RepeatDelay', 250);

// Create Top Panel
loadTemplate("org.garuda.desktop.defaultPanel")

// Create Bottom Panel (Dock)
loadTemplate("org.garuda.desktop.defaultDock")


// Configure Contextual Menu Plugin
// Loop through all desktops (for multi-monitor setups)
// Mokka Desktop Configuration - ISO Default
var allDesktops = desktops();

for (var i in allDesktops) {
    var d = allDesktops[i];

    // 1. Set the Right-Click Plugin to Context Menu (Folder View)
    d.currentConfigGroup = ["ActionPlugins", "RightButton;NoModifier"];
    d.writeConfig("plugin", "org.kde.contextmenu");

    // 2. Define the Mokka Action List
    d.currentConfigGroup = ["ActionPlugins", "RightButton;NoModifier", "org.kde.contextmenu"];

    // System Actions
    d.writeConfig("show_run_command", true);       // KRunner
    d.writeConfig("show_lock_screen", true);       // Lock
    d.writeConfig("show_logout", true);            // Logout
    d.writeConfig("show_leave_group", true);       // Other Actions (Shutdown/Restart)

    // UI Management
    d.writeConfig("show_add_widgets", true);
    d.writeConfig("show_configure_panel", true);
    d.writeConfig("show_configure_desktop", true); // Wallpaper Actions

    // File/Terminal Actions (specific to org.kde.contextmenu)
    d.writeConfig("show_terminal", true);          // Open Terminal
    d.writeConfig("show_create_new", true);
    d.writeConfig("show_paste", true);
}

// Apply Wallpaper Active Blur plugin to all Desktops of the current Activity
var allDesktops = desktops();
for (i=0;i<allDesktops.length;i++){
  d = allDesktops[i];
  d.wallpaperPlugin = "a2n.blur";
  d.currentConfigGroup = Array("Wallpaper", "a2n.blur", "General");
}
