      SUBROUTINE DPML1(Y,CENSOR,N,ICASPL,IFLAGD,IFLAG9,
     1                 TEMP1,TEMP2,TEMP3,TEMP4,TEMP5,YTEMP,
     1                 DTEMP1,DTEMP2,DTEMP3,ITEMP1,MAXNXT,
     1                 ALOC,ASCALE,ALOWLI,AUPPLI,
     1                 SH1,SH2,SH3,SH4,
     1                 SH5,SH6,SH7,
     1                 YLOWLM,YUPPLM,A,B,MINMAX,
     1                 IADEDF,IGEPDF,IMAKDF,IBEIDF,
     1                 ILGADF,ISKNDF,IGLDDF,IGOMDF,IGIGDF,
     1                 IGEODF,IBGEDF,
     1                 ICENSO,IEXPBC,IWEIBC,ICENTY,IDFTTY,
     1                 CLLIMI,CLWIDT,IHSTCW,IHSTOU,IRELAT,IRHSTG,
     1                 IBUGA3,ISUBRO,IERROR)
C
C     PURPOSE--COMPUTE THE MAXIMUM LIKELIHOOD ESTIMATE FOR THE
C              GIVEN SET OF POINTS.  THIS WILL BE USED BY THE
C              "GOODNESS OF FIT", "BOOTSTRAP", AND POSSIBLY OTHER
C              COMMANDS.  PUTTING THIS IN A DISTINCT SUBROUTINE
C              IS TO REDUCE DUPLICATION OF CODE.  ALSO, WE ARE
C              PRIMARILY INTERESTED IN THE POINT ESTIMATES OF THE
C              PARAMETERS.
C
C              THIS ROUTINE HANDLES THE UNGROUPED DATA FOR EITHER
C              THE UNCENSORED OR THE CENSORED CASE (CENSORING IS
C              ONLY SUPPORTED FOR A SUBSET OF THE DISTRIBUTIONS).
C              IF IFLAGD = 1, THEN DISCRETE DISTRIBUTIONS WILL
C              BE SKIPPED.
C
C              IF THE MAXIMUM LIKELIHOOD ESTIMATES ARE NOT CURRENTLY
C              AVAILABLE FOR THE SPECIFIED DISTRIBUTION, THEN IFLAG9
C              WILL BE SET TO -99.
C
C              THE FOLLOWING ARE CURRENTLY SUPPORTED.
C
C              LOCATION/SCALE DISTRIBUTIONS:
C                 1) NORMAL
C                    NORMAL CENSORED
C                 2) UNIFORM
C                 3) LOGISTIC
C                 4) DOUBLE EXPONENTIAL
C                 5) CAUCHY
C                 6) EXTREME VALUE TYPE 1 (GUMBEL)
C                 7) SLASH
C                 8) EXPONENTIAL (EITHER 1-PARAMETER OR 2-PARAMETER)
C                    EXPONENTIAL CENSORED (EITHER 1-PARAMETER OR
C                    2-PARAMETER)
C                 9) FOLDED NORMAL
C                10) RAYLEIGH
C                11) MAXWELL
C
C              ONE SHAPE PARAMETER DISTRIBUTIONS:
C                 1) 2-PARAMETER WEIBULL/3-PARAMETER WEIBULL
C                    2-PARAMETER WEIBULL CENSORED
C                 2) 2-PARAMETER INVERTED WEIBULL
C                    2-PARAMETER INVERTED WEIBULL CENSORED
C                 3) 2-PARAMETER LOGNORMAL
C                    2-PARAMETER LOGNORMAL CENSORED
C                 4) 2-PARAMETER GAMMA
C                    2-PARAMETER GAMMA CENSORED
C                 5) 2-PARAMETER INVERTED GAMMA
C                    2-PARAMETER INVERTED GAMMA CENSORED
C                 6) 2-PARAMETER GEOMETRIC EXTREME EXPONENTIAL
C                 7) 2-PARAMETER FATIGUE LIFE
C                 8) 2-PARAMETER EXTREME VALUE TYPE 2 (FRECHET)
C                 9) 2-PARAMETER BURR TYPE 10
C                10) 2-PARAMETER LOGISTIC EXPONENTIAL
C                11) 2-PARAMETER VON MISES (LOCATION/SHAPE)
C                12) 3-PARAMETER PEARSON TYPE 3 (L-MOMENTS ONLY)
C                13) 3-PARAMETER GENERALIZED LOGISTIC TYPE 5
C                    (L-MOMENTS ONLY)
C                14) TRIANGULAR
C                15) TOPP AND LEONE
C                16) POWER AND REFLECTED POWER
C                17) GENERALIZED EXTREME VALUE
C                18) GENERALIZED PARETO
C                19) 2-PARAMETER ALPHA
C                20) 2-PARAMETER EXPONENTIAL POWER
C                    (NEEDS ALGORITHMIC WORK)
C                21) 3-PARAMETER ASYMMETRIC LAPLACE
C                22) PARETO
C                23) TRUNCATED PARETO
C                24) 2-PARAMETER BRITTLE FIBER WEIBULL
C
C                (NEED TO ADD: WALD)
C
C              TWO SHAPE PARAMETER DISTRIBUTIONS:
C                 1) 2-PARAMETER BETA
C                 2) 4-PARAMETER BETA
C                 3) KAPPA (L-MOMENTS)
C                 4) BETA-NORMAL
C                 5) TWO-SIDED POWER
C                 6) REFLECTED GENERALIZED TOPP AND LEONE
C
C                (NEED TO ADD: INVERSE GAUSSIAN, JOHNSON SB/SU)
C
C              THREE+ SHAPE PARAMETER DISTRIBUTIONS:
C                 1) WAKEBY (L-MOMENTS)
C                 2) NORMAL MIXTURE
C
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL BUREAU OF STANDARDS.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2009/10
C     ORIGINAL VERSION--OCTOBER   2009.
C     UPDATED         --JUNE      2011. FOR BRITTLE FIBER WEIBULL,
C                                       SET SHAPE2 PARAMETER TO L
C     UPDATED         --AUGUST    2011. WHEN ESTIMATION FAILS, SET
C                                       ALL PARAMETERS TO CPUMIN
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      LOGICAL POINT
      LOGICAL MLFLAG
C
      CHARACTER*4 ICASPL
      CHARACTER*4 IBUGA3
      CHARACTER*4 ISUBRO
      CHARACTER*4 IWRITE
      CHARACTER*4 IADEDF
      CHARACTER*4 IGEPDF
      CHARACTER*4 IMAKDF
      CHARACTER*4 IBEIDF
      CHARACTER*4 ILGADF
      CHARACTER*4 ISKNDF
      CHARACTER*4 IGLDDF
      CHARACTER*4 IGOMDF
      CHARACTER*4 IGIGDF
      CHARACTER*4 IGEODF
      CHARACTER*4 IBGEDF
      CHARACTER*4 IGUMBC
      CHARACTER*4 IEXPBC
      CHARACTER*4 IWEIBC
      CHARACTER*4 ICENTY
      CHARACTER*4 IDFTTY
      CHARACTER*4 IHSTCW
      CHARACTER*4 IHSTOU
      CHARACTER*4 IRELAT
      CHARACTER*4 IRHSTG
      CHARACTER*4 IWEIFL
      CHARACTER*4 IGAMFL
      CHARACTER*4 ICASE2
      CHARACTER*4 ICASE3
      CHARACTER*7 ICASE4
      CHARACTER*4 IGEPSV
      CHARACTER*4 IERROR
C
      CHARACTER*40 IDIST
      CHARACTER*4 ICENSO
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*4 MESSAG
      CHARACTER*4 IHWUSE
      CHARACTER*4 IHP
      CHARACTER*4 IHP2
C
      CHARACTER*4 IWEIML
      CHARACTER*4 IWEIMM
      CHARACTER*4 IWEIMO
C
      REAL ALOC
      REAL ASCALE
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION CENSOR(*)
      DIMENSION TEMP1(*)
      DIMENSION TEMP2(*)
      DIMENSION TEMP3(*)
      DIMENSION TEMP4(*)
      DIMENSION TEMP5(*)
      DIMENSION YTEMP(*)
C
      REAL CLWIDT(*)
      REAL CLLIMI(*)
C
      DOUBLE PRECISION DTEMP1(*)
      DOUBLE PRECISION DTEMP2(*)
      DOUBLE PRECISION DTEMP3(*)
      DOUBLE PRECISION XMOM(5)
      INTEGER   ITEMP1(*)
C
      PARAMETER (MAXALP=6)
      REAL ALPHA(MAXALP)
      REAL ALOWLO(MAXALP)
      REAL AUPPLO(MAXALP)
      REAL ALOWSC(MAXALP)
      REAL AUPPSC(MAXALP)
      REAL ALOWL2(MAXALP)
      REAL AUPPL2(MAXALP)
      REAL ALOWS2(MAXALP)
      REAL AUPPS2(MAXALP)
      REAL ALOSH1(MAXALP)
      REAL AUPSH1(MAXALP)
      REAL ALOSH2(MAXALP)
      REAL AUPSH2(MAXALP)
      REAL ALOSH3(MAXALP)
      REAL AUPSH3(MAXALP)
C
      REAL VARCOV(3,3)
C
      PARAMETER (KMAX=20)
      REAL MIXPRO(KMAX)
      REAL XMEANV(KMAX)
      REAL XSDV(KMAX)
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOHK.INC'
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA ALPHA /0.50, 0.25, 0.10, 0.05, 0.01, 0.001/
C
C-----START POINT-----------------------------------------------------
C
C
      ISUBN1='DPML'
      ISUBN2='1   '
      IERROR='NO'
      IFLAG9=-99
C
      ICASE=0
      ALOC=CPUMIN
      ASCALE=CPUMIN
      SH1=CPUMIN
      SH2=CPUMIN
      SH3=CPUMIN
      SH4=CPUMIN
      SH5=CPUMIN
      SH6=CPUMIN
      SH7=CPUMIN
C
      CLWIDT(1)=CPUMIN
      CLWIDT(2)=CPUMIN
      CLLIMI(1)=CPUMIN
      CLLIMI(2)=CPUMIN
      CLLIMI(3)=CPUMIN
      CLLIMI(4)=CPUMIN
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      IF(N.LT.2)THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,31)
   31   FORMAT('***** ERROR IN DPML1--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,32)
   32   FORMAT('      THE NUMBER OF OBSERVATIONS MUST BE AT LEAST 2.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,34)N
   34   FORMAT('      THE ENTERED NUMBER OF OBSERVATIONS HERE = ',I6)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      HOLD=Y(1)
      DO60I=1,N
        IF(Y(I).NE.HOLD)GOTO69
   60 CONTINUE
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,31)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,62)
   62 FORMAT('      ALL ELEMENTS IN THE RESPONSE VARIABLE ARE ',
     1       'IDENTICALLY EQUAL TO ',G15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
C
   69 CONTINUE
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'PML1')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,71)
   71   FORMAT('***** AT THE BEGINNING OF DPML1--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,72)ICASPL,N,MINMAX
   72   FORMAT('ICASPL,N,MINMAX = ',A4,2X,2X,I8,I8)
        CALL DPWRST('XXX','BUG ')
        DO85I=1,N
          WRITE(ICOUT,86)I,Y(I)
   86     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','BUG ')
   85   CONTINUE
      ENDIF
C
C               ************************************************
C               **  STEP 2.1--                                **
C               **  COMPUTE ML FOR SPECIFIED DISTRIBUTIONS    **
C               ************************************************
C
      IF(ICASPL.EQ.'UNIF')THEN
        IFLAG9=1
        CALL UNIML1(Y,N,
     1              XMIN,XMAX,XMEAN,XSD,XRANG,XMIDR,
     1              ALOWLI,AUPPLI,AHAT,HHAT,ALO2LI,AUP2LI,
     1              ALOCMO,ASCAMO,ALOC,ASCALE,
     1              ISUBRO,IBUGA3,IERROR)
         IF(IDFTTY.EQ.'MOME')THEN
           ALOC=ALOCMO
           ASCALE=ASCAMO
         ENDIF
      ELSEIF(ICASPL.EQ.'NORM')THEN
        IFLAG9=1
        IF(ICENSO.EQ.'OFF')THEN
          CALL NORML1(Y,N,ICASE,
     1                ALOWLO,AUPPLO,ALOWSC,AUPPSC,ALPHA,MAXALP,NUMOUT,
     1                XMEAN,XSD,XVAR,XMIN,XMAX,XSDMEA,XSDSD,
     1                ISUBRO,IBUGA3,IERROR)
          ALOC=XMEAN
          ASCALE=XSD
          IF(ASCALE.LE.0.0)IERROR='YES'
        ELSE
          CALL NORML2(Y,CENSOR,N,IR,
     1                TEMP1,DTEMP1,ITEMP1,MAXNXT,IOUNI2,
     1                ALOWLO,AUPPLO,ALOWSC,AUPPSC,ALPHA,MAXALP,NUMOUT,
     1                XMEAN,XSD,XVAR,XMIN,XMAX,XSDMEA,XSDSD,
     1                XCOV,TEMP2,
     1                ISUBRO,IBUGA3,IERROR)
          ALOC=XMEAN
          ASCALE=XSD
          IF(ASCALE.LE.0.0)IERROR='YES'
        ENDIF
C
      ELSEIF(ICASPL.EQ.'LOGI')THEN
        IFLAG9=1
        CALL LOGML1(Y,N,MAXNXT,
     1              DTEMP1,
     1              XMEAN,XSD,XMIN,XMAX,
     1              ALOC,ASCALE,
     1              ISUBRO,IBUGA3,IERROR)
C
        IF(ASCALE.LE.0.0)IERROR='YES'
      ELSEIF(ICASPL.EQ.'DEXP')THEN
        IFLAG9=1
        CALL DEXML1(Y,N,TEMP1,ICASE,MAXNXT,
     1              ALOWLO,AUPPLO,ALOWSC,AUPPSC,ALPHA,MAXALP,NUMOUT,
     1              XMEAN,XMED,XSD,XMIN,XMAX,
     1              ALOC,ASCALE,
     1              ISUBRO,IBUGA3,IERROR)
C
        IF(ASCALE.LE.0.0)IERROR='YES'
      ELSEIF(ICASPL.EQ.'CAUC')THEN
        IFLAG9=1
        CALL CAUML1(Y,N,TEMP1,TEMP2,DTEMP1,MAXNXT,
     1              XMEAN,XMED,XSD,XMAD,XIQ,XMIN,XMAX,
     1              ALOC,ASCALE,ALOCOS,ASCLOS,ALOWOS,SCAWOS,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IDFTTY.EQ.'OS')THEN
          ALOC=ALOCOS
          ASCALE=ASCLOS
        ELSEIF(IDFTTY.EQ.'WOS')THEN
          ALOC=ALOWOS
          ASCALE=SCAWOS
        ENDIF
        IF(ASCALE.LE.0.0)IERROR='YES'
C
      ELSEIF(ICASPL.EQ.'EV1 ')THEN
        IFLAG9=1
        IGUMBC='OFF'
        CALL EV1ML1(Y,N,MINMAX,IGUMBC,ICASE,
     1              DTEMP1,
     1              ALOWLO,AUPPLO,ALOWSC,AUPPSC,
     1              ALOWL2,AUPPL2,ALOWS2,AUPPS2,
     1              ALPHA,MAXALP,NUMOUT,
     1              XMEAN,XSD,XMIN,XMAX,
     1              ALOCMO,ASCAMO,ALMOSE,ASMOSE,
     1              ALOCML,ASCAML,ASC2ML,ALMLSE,ASMLSE,COVSE,
     1              ISUBRO,IBUGA3,IERROR)
        ALOC=ALOCML
        ASCALE=ASCAML
        IF(IDFTTY.EQ.'MOME')THEN
          ALOC=ALOCMO
          ASCALE=ASCAMO
        ENDIF
        IF(ASCALE.LE.0.0)IERROR='YES'
C
      ELSEIF(ICASPL.EQ.'1EXP' .OR. ICASPL.EQ.'EXPO')THEN
        IFLAG9=1
        ICASE2='1'
        IF(ICASPL.EQ.'EXPO')ICASE2='2'
C
        IF(ICENSO.EQ.'ON')THEN
          IHP='TEND'
          IHP2='    '
          IHWUSE='P'
          MESSAG='NO'
          CALL CHECKN(IHP,IHP2,IHWUSE,
     1                IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1                ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCP,IERROR)
          TEND=0.0
          IF(IERROR.EQ.'NO')TEND=VALUE(ILOCP)
C
          IF(ICENTY.EQ.'1')THEN
            CALL EXPML2(Y,CENSOR,N,ICASPL,ICASE2,TEND,TEMP1,MAXNXT,
     1                  XMEAN,XSD,XVAR,XMIN,XMAX,XSUM,
     1                  ALOCML,ALOCSE,SCALML,SCALSE,
     1                  IR,IM,AN,AR,AM,
     1                  ISUBRO,IBUGA3,IERROR)
          ELSEIF(ICENTY.EQ.'2')THEN
            CALL EXPML3(Y,CENSOR,TEMP1,N,ICASPL,ICASE2,TEND,MAXNXT,
     1                  XMEAN,XSD,XVAR,XMIN,XMAX,XSUM,
     1                  ALOCML,ALOCSE,SCALML,SCALSE,
     1                  IR,IM,AN,AR,AM,
     1                  ISUBRO,IBUGA3,IERROR)
          ENDIF
        ELSE
          CALL EXPML1(Y,N,ICASE2,IEXPBC,
     1                ALOWLO,AUPPLO,ALOWSC,AUPPSC,ALPHA,
     1                MAXALP,NUMOUT,
     1                XMEAN,XSD,XVAR,XMIN,XMAX,
     1                ALOCML,ALOCSE,SCALML,SCALSE,
     1                ALOCBC,ALOBSE,SCABML,SCABSE,
     1                ISUBRO,IBUGA3,IERROR)
        ENDIF
        ALOC=ALOCML
        ASCALE=SCALML
        IF(IDFTTY.EQ.'BC')THEN
          ALOC=ALOCBC
          ASCALE=SCABML
        ENDIF
        IF(ASCALE.LE.0.0)IERROR='YES'
C
      ELSEIF(ICASPL.EQ.'SLAS')THEN
        IFLAG9=1
        CALL SLAML1(Y,N,MAXNXT,
     1              TEMP1,TEMP2,TEMP3,DTEMP1,
     1              XMEAN,XSD,XMIN,XMAX,XMED,XMAD,
     1              ALOC,ASCALE,
     1              ISUBRO,IBUGA3,IERROR)
C
      ELSEIF(ICASPL.EQ.'FNOR')THEN
        IFLAG9=1
        CALL FNRML1(Y,N,MAXNXT,
     1              TEMP1,DTEMP1,
     1              XMEAN,XSD,XVAR,XMIN,XMAX,
     1              ALOC,ASCALE,
     1              ISUBRO,IBUGA3,IERROR)
C
        IF(ASCALE.LE.0.0)IERROR='YES'
      ELSEIF(ICASPL.EQ.'RAYL' .OR. ICASPL.EQ.'RAY2')THEN
        IFLAG9=1
        ICASE2='2'
        CALL RAYML1(Y,N,ICASE2,
     1              DTEMP1,
     1              XMEAN,XSD,XMIN,XMAX,
     1              ALOCML,SCALML,SCALSE,
     1              ALOCMM,SCALMM,SCA2SE,
     1              ISUBRO,IBUGA3,IERROR)
        ALOC=ALOCML
        ASCALE=SCALML
        IF(IDFTTY.EQ.'MMOM')THEN
          ALOC=ALOCMM
          ASCALE=SCALMM
        ENDIF
        IF(ASCALE.LE.0.0)IERROR='YES'
C
      ELSEIF(ICASPL.EQ.'1RAY')THEN
        IFLAG9=1
        ICASE2='1'
        CALL RAYML1(Y,N,ICASE2,
     1              DTEMP1,
     1              XMEAN,XSD,XMIN,XMAX,
     1              ALOCML,SCALML,SCALSE,
     1              ALOCMM,SCALMM,SCA2SE,
     1              ISUBRO,IBUGA3,IERROR)
        ALOC=CPUMIN
        ASCALE=SCALML
        IF(IDFTTY.EQ.'MMOM')THEN
          ASCALE=SCALMM
        ENDIF
        IF(ASCALE.LE.0.0)IERROR='YES'
C
      ELSEIF(ICASPL.EQ.'MAXW' .OR. ICASPL.EQ.'MAX2')THEN
        IFLAG9=1
        ICASE2='2'
        CALL MAXML1(Y,N,ICASE2,
     1              DTEMP1,
     1              XMEAN,XSD,XMIN,XMAX,
     1              ALOCML,SCALML,SCALSE,
     1              ALOCMO,SCALMO,
     1              ISUBRO,IBUGA3,IERROR)
        ALOC=ALOCMO
        ASCALE=SCALMO
        IF(IDFTTY.EQ.'MOME')THEN
          ALOC=ALOCMO
          ASCALE=SCALMO
        ENDIF
        IF(ASCALE.LE.0.0)IERROR='YES'
C
      ELSEIF(ICASPL.EQ.'1MAX')THEN
        IFLAG9=1
        ICASE2='1'
        CALL MAXML1(Y,N,ICASE2,
     1              DTEMP1,
     1              XMEAN,XSD,XMIN,XMAX,
     1              ALOCML,SCALML,SCALSE,
     1              ALOCMO,SCALMO,
     1              ISUBRO,IBUGA3,IERROR)
        ALOC=CPUMIN
        ASCALE=SCALML
        IF(IDFTTY.EQ.'MOME')THEN
          ASCALE=SCALMO
        ENDIF
        IF(ASCALE.LE.0.0)IERROR='YES'
C
      ELSEIF(ICASPL.EQ.'WEIB')THEN
        IFLAG9=1
        IWEIBC='OFF'
        IWEIFL='WEIB'
        IF(ICENSO.EQ.'ON')THEN
          CALL WEIML2(Y,CENSOR,N,IWEIBC,IWEIFL,MINMAX,MAXNXT,
     1                ICASE3,ICASE4,IDIST,
     1                TEMP1,DTEMP1,ITEMP1,
     1                XMEAN,XSD,XVAR,XMIN,XMAX,
     1                ZMEAN,ZSD,
     1                SCALML,SCALSE,SHAPML,SHAPSE,
     1                SHAPBC,SHABSE,COVSE,COVBSE,
     1                IR,
     1                ISUBRO,IBUGA3,IERROR)
        ELSE
          CALL WEIML1(Y,N,IWEIBC,IWEIFL,MINMAX,
     1                TEMP1,DTEMP1,
     1                XMEAN,XSD,XVAR,XMIN,XMAX,
     1                ZMEAN,ZSD,
     1                SCALML,SCALSE,SHAPML,SHAPSE,
     1                SHABML,SHABSE,COVSE,COVBSE,
     1                ISUBRO,IBUGA3,IERROR)
        ENDIF
        ALOC=CPUMIN
        ASCALE=SCALML
        SH1=SHAPML
        IF(IDFTTY.EQ.'BC')THEN
          SH1=SHABML
        ENDIF
        IF(ASCALE.LE.0.0 .OR. SH1.LE.0.0)IERROR='YES'
C
      ELSEIF(ICASPL.EQ.'3WEI')THEN
        IFLAG9=1
        IWEIFL='WEIB'
        IWEIML='OFF'
        IWEIMO='OFF'
        IWEIMM='OFF'
        IF(IDFTTY.EQ.'MMOM')IWEIMM='ON'
        IF(IDFTTY.EQ.'MOME')IWEIMO='ON'
        IF(IDFTTY.EQ.'ML  ')IWEIML='ON'
        CALL WEIML3(Y,N,IWEIFL,IWEIML,IWEIMM,IWEIMO,MINMAX,MAXNXT,
     1              TEMP1,DTEMP1,
     1              XMEAN,XSD,XVAR,XMIN,XMAX,XSKEW,
     1              ZMEAN,ZSD,
     1              ALOCPE,SCALPE,SHAPPE,
     1              ALOCWB,SCALWB,SHAPWB,
     1              ALOCMO,SCALMO,SHAPMO,
     1              ALOCM2,SCALM2,SHAPM2,
     1              ALOCML,SCALML,SHAPML,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IDFTTY.EQ.'PERC')THEN
          ALOC=ALOCPE
          ASCALE=SCALPE
          SH1=SHAPPE
        ELSEIF(IDFTTY.EQ.'WBE')THEN
          ALOC=ALOCWB
          ASCALE=SCALWB
          SH1=SHAPWB
        ELSEIF(IDFTTY.EQ.'MMOM')THEN
          ALOC=ALOCMO
          ASCALE=SCALMO
          SH1=SHAPMO
        ELSEIF(IDFTTY.EQ.'MOME')THEN
          ALOC=ALOCM2
          ASCALE=SCALM2
          SH1=SHAPM2
        ELSE
          ALOC=ALOCML
          ASCALE=SCALML
          SH1=SHAPML
        ENDIF
        IERROR='NO'
        IF(ASCALE.LE.0.0 .OR. SH1.LE.0.0)IERROR='YES'
C
      ELSEIF(ICASPL.EQ.'IWEI')THEN
        IWEIBC='OFF'
        IWEIFL='IWEI'
        IFLAG9=1
        IF(ICENSO.EQ.'ON')THEN
          CALL WEIML2(Y,CENSOR,N,IWEIBC,IWEIFL,MINMAX,MAXNXT,
     1                ICASE3,ICASE4,IDIST,
     1                TEMP1,DTEMP1,ITEMP1,
     1                XMEAN,XSD,XVAR,XMIN,XMAX,
     1                ZMEAN,ZSD,
     1                SCALML,SCALSE,SHAPML,SHAPSE,
     1                SHAPBC,SHABSE,COVSE,COVBSE,
     1                IR,
     1                ISUBRO,IBUGA3,IERROR)
        ELSE
          CALL WEIML1(Y,N,IWEIBC,IWEIFL,MINMAX,
     1                TEMP1,DTEMP1,
     1                XMEAN,XSD,XVAR,XMIN,XMAX,
     1                ZMEAN,ZSD,
     1                SCALML,SCALSE,SHAPML,SHAPSE,
     1                SHABML,SHABSE,COVSE,COVBSE,
     1                ISUBRO,IBUGA3,IERROR)
        ENDIF
        ALOC=CPUMIN
        ASCALE=SCALML
        SH1=SHAPML
        IF(IDFTTY.EQ.'BC')THEN
          SH1=SHABML
        ENDIF
        IF(ASCALE.LE.0.0 .OR. SH1.LE.0.0)IERROR='YES'
C
      ELSEIF(ICASPL.EQ.'3IWE')THEN
        IFLAG9=1
        IWEIFL='IWEI'
        IWEIML='OFF'
        IWEIMO='OFF'
        IWEIMM='OFF'
        IF(IDFTTY.EQ.'MMOM')IWEIMM='ON'
        IF(IDFTTY.EQ.'MOME')IWEIMO='ON'
        IF(IDFTTY.EQ.'ML  ')IWEIML='ON'
        CALL WEIML3(Y,N,IWEIFL,IWEIML,IWEIMM,IWEIMO,MINMAX,MAXNXT,
     1              TEMP1,DTEMP1,
     1              XMEAN,XSD,XVAR,XMIN,XMAX,XSKEW,
     1              ZMEAN,ZSD,
     1              ALOCPE,SCALPE,SHAPPE,
     1              ALOCWB,SCALWB,SHAPWB,
     1              ALOCMO,SCALMO,SHAPMO,
     1              ALOCM2,SCALM2,SHAPM2,
     1              ALOCML,SCALML,SHAPML,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IDFTTY.EQ.'PERC')THEN
          ALOC=ALOCPE
          ASCALE=SCALPE
          SH1=SHAPPE
        ELSEIF(IDFTTY.EQ.'WBE')THEN
          ALOC=ALOCWB
          ASCALE=SCALWB
          SH1=SHAPWB
        ELSEIF(IDFTTY.EQ.'MMOM')THEN
          ALOC=ALOCMO
          ASCALE=SCALMO
          SH1=SHAPMO
        ELSEIF(IDFTTY.EQ.'MOME')THEN
          ALOC=ALOCM2
          ASCALE=SCALM2
          SH1=SHAPM2
        ELSE
          ALOC=ALOCML
          ASCALE=SCALML
          SH1=SHAPML
        ENDIF
        IF(ASCALE.LE.0.0 .OR. SH1.LE.0.0)IERROR='YES'
C
      ELSEIF(ICASPL.EQ.'BFWE')THEN
        IFLAG9=1
C
        IHP='SHAP'
        IHP2='ESV '
        IHWUSE='P'
        MESSAG='NO'
        CALL CHECKN(IHP,IHP2,IHWUSE,
     1  IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1  ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCP,IERROR)
        SHAPSV=CPUMIN
        IF(IERROR.EQ.'NO')SHAPSV=VALUE(ILOCP)
C
        IHP='SCAL'
        IHP2='ESV '
        IHWUSE='P'
        MESSAG='NO'
        CALL CHECKN(IHP,IHP2,IHWUSE,
     1  IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1  ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCP,IERROR)
        SCALSV=CPUMIN
        IF(IERROR.EQ.'NO')SCALSV=VALUE(ILOCP)
C
        IHP='L   '
        IHP2='    '
        IHWUSE='P'
        MESSAG='NO'
        CALL CHECKN(IHP,IHP2,IHWUSE,
     1  IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1  ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCP,IERROR)
        ALJUNK=1.0
        IF(IERROR.EQ.'NO')ALJUNK=VALUE(ILOCP)
        IF(ALJUNK.LE.0.0)THEN
          ALJUNK=1.0
        ENDIF
        DO5341II=1,N
          CENSOR(II)=ALJUNK
 5341   CONTINUE
C
        CALL BFWML1(Y,CENSOR,N,MAXNXT,
     1              TEMP1,TEMP2,DTEMP1,
     1              XMEAN,XSD,XVAR,XMIN,XMAX,
     1              SCALSV,SHAPSV,SCALML,SHAPML,
     1              ISUBRO,IBUGA3,IERROR)
C
        ALOC=CPUMIN
        ASCALE=SCALML
        SH1=SHAPML
        SH2=ALJUNK
        IF(ASCALE.LE.0.0 .OR. SH1.LE.0.0)IERROR='YES'
C
      ELSEIF(ICASPL.EQ.'LOGN')THEN
        IFLAG9=1
        CALL LGNML1(Y,N,MAXNXT,
     1              TEMP1,
     1              XMEAN,XMED,XSD,XVAR,XMIN,XMAX,XMEANL,XSDL,
     1              SCALML,SCALSE,SHAPML,SHAPSE,UHATML,UHATSE,
     1              ISUBRO,IBUGA3,IERROR)
        ALOC=CPUMIN
        ASCALE=SCALML
        SH1=SHAPML
        IF(ASCALE.LE.0.0 .OR. SH1.LE.0.0)IERROR='YES'
C
      ELSEIF(ICASPL.EQ.'GAMM')THEN
        IFLAG9=1
        IGAMFL='GAMM'
        IF(ICENSO.EQ.'OFF')THEN
          CALL GAMML1(Y,N,IGAMFL,
     1                TEMP1,DTEMP1,
     1                XMEAN,XSD,XVAR,XMIN,XMAX,XGEOM,
     1                ZMEAN,ZSD,ZGEOM,
     1                SCALML,SCALSE,SHAPML,SHAPSE,COVSE,
     1                SCALMO,SHAPMO,
     1                ISUBRO,IBUGA3,IERROR)
          ALOC=CPUMIN
          ASCALE=SCALML
          SH1=SHAPML
          IF(IDFTTY.EQ.'MOME')THEN
            ASCALE=SCALMO
            SH1=SHAPMO
          ENDIF
        ELSE
          CALL GAMML2(Y,CENSOR,N,IGAMFL,MAXNXT,
     1                ICASE3,IDIST,
     1                TEMP1,TEMP2,TEMP3,DTEMP1,ITEMP1,
     1                XMEANF,XSDF,XVARF,XMINF,XMAXF,XGEOMF,
     1                XMEANC,XSDC,XVARC,XMINC,XMAXC,XGEOMC,
     1                SCALMO,SHAPMO,
     1                SCALML,SCALSE,SHAPML,SHAPSE,COVSE,
     1                IR,ISE,
     1                ISUBRO,IBUGA3,IERROR)
          ALOC=CPUMIN
          ASCALE=SCALML
          SH1=SHAPML
          IF(IDFTTY.EQ.'MOME')THEN
            ASCALE=SCALMO
            SH1=SHAPMO
          ENDIF
        ENDIF
        IF(ASCALE.LE.0.0 .OR. SH1.LE.0.0)IERROR='YES'
C
      ELSEIF(ICASPL.EQ.'IGAM')THEN
        IGAMFL='IGAM'
        IFLAG9=1
        IF(ICENSO.EQ.'OFF')THEN
          CALL GAMML1(Y,N,IGAMFL,
     1                TEMP1,DTEMP1,
     1                XMEAN,XSD,XVAR,XMIN,XMAX,XGEOM,
     1                ZMEAN,ZSD,ZGEOM,
     1                SCALML,SCALSE,SHAPML,SHAPSE,COVSE,
     1                SCALMO,SHAPMO,
     1                ISUBRO,IBUGA3,IERROR)
          ALOC=CPUMIN
          ASCALE=SCALML
          SH1=SHAPML
          IF(IDFTTY.EQ.'MOME')THEN
            ASCALE=SCALMO
            SH1=SHAPMO
          ENDIF
        ELSE
          CALL GAMML2(Y,CENSOR,N,IGAMFL,MAXNXT,
     1                ICASE3,IDIST,
     1                TEMP1,TEMP2,TEMP3,DTEMP1,ITEMP1,
     1                XMEANF,XSDF,XVARF,XMINF,XMAXF,XGEOMF,
     1                XMEANC,XSDC,XVARC,XMINC,XMAXC,XGEOMC,
     1                SCALMO,SHAPMO,
     1                SCALML,SCALSE,SHAPML,SHAPSE,COVSE,
     1                IR,ISE,
     1                ISUBRO,IBUGA3,IERROR)
          ALOC=CPUMIN
          ASCALE=SCALML
          SH1=SHAPML
          IF(IDFTTY.EQ.'MOME')THEN
            ASCALE=SCALMO
            SH1=SHAPMO
          ENDIF
        ENDIF
        IF(ASCALE.LE.0.0 .OR. SH1.LE.0.0)IERROR='YES'
C
      ELSEIF(ICASPL.EQ.'GEEX')THEN
        IFLAG9=1
        IHP='GAMM'
        IHP2='SV  '
        IHWUSE='P'
        MESSAG='NO'
        CALL CHECKN(IHP,IHP2,IHWUSE,
     1  IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1  ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCP,IERROR)
        SHAPSV=CPUMIN
        IF(IERROR.EQ.'NO')SHAPSV=VALUE(ILOCP)
C
        IHP='SCAL'
        IHP2='ESV '
        IHWUSE='P'
        MESSAG='NO'
        CALL CHECKN(IHP,IHP2,IHWUSE,
     1  IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1  ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCP,IERROR)
        SCALSV=CPUMIN
        IF(IERROR.EQ.'NO')SCALSV=VALUE(ILOCP)
C
        CALL GEEML1(Y,N,MAXNXT,
     1              TEMP1,TEMP2,TEMP3,DTEMP1,
     1              XMEAN,XSD,XVAR,XMIN,XMAX,
     1              SCALSV,SHAPSV,SCALML,SHAPML,
     1              ISUBRO,IBUGA3,IERROR)
        ALOC=CPUMIN
        ASCALE=SCALML
        SH1=SHAPML
        IF(ASCALE.LE.0.0 .OR. SH1.LE.0.0)IERROR='YES'
C
      ELSEIF(ICASPL.EQ.'FREC' .OR. ICASPL.EQ.'EV2 ')THEN
        IFLAG9=1
        CALL EV2ML1(Y,N,MINMAX,
     1              TEMP1,DTEMP1,
     1              XMEAN,XSD,XVAR,XMIN,XMAX,XLOGSD,XLOGSM,
     1              SCALML,SCALSE,SHAPML,SHAPSE,
     1              SHABML,SHABSE,COVSE,COVBSE,
     1              ISUBRO,IBUGA3,IERROR)
        ALOC=CPUMIN
        ASCALE=SCALML
        SH1=SHAPML
        IF(IDFTTY.EQ.'BC')THEN
          SH1=SHABML
        ENDIF
        IF(ASCALE.LE.0.0 .OR. SH1.LE.0.0)IERROR='YES'
C
      ELSEIF(ICASPL.EQ.'FATL')THEN
        IFLAG9=1
        CALL FLML1(Y,N,MAXNXT,
     1             TEMP1,DTEMP1,
     1             XMEAN,XSD,XVAR,XMIN,XMAX,
     1             SCALML,SHAPML,SCALMO,SHAPMO,
     1             ISUBRO,IBUGA3,IERROR)
        ALOC=CPUMIN
        ASCALE=SCALML
        SH1=SHAPML
        IF(IDFTTY.EQ.'MOME')THEN
          ASCALE=SCALMO
          SH1=SHAPMO
        ENDIF
        IF(ASCALE.LE.0.0 .OR. SH1.LE.0.0)IERROR='YES'
C
      ELSEIF(ICASPL.EQ.'GEV ')THEN
        IFLAG9=1
        MLFLAG=.TRUE.
        CALL GEVML1(Y,N,MAXNXT,MINMAX,ICASPL,MLFLAG,IGEPDF,ISEED,IDFTTY,
     1              TEMP1,TEMP2,TEMP3,TEMP4,TEMP5,
     1              DTEMP1,XMOM,NMOM,VARCOV,
     1              XMEAN,XSD,XVAR,XMIN,XMAX,
     1              ALOCLM,SCALLM,SHAPLM,
     1              ALOCEP,SCALEP,SHAPEP,
     1              ALOCML,SCALML,SHAPML,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IDFTTY.EQ.'EPER')THEN
          ALOC=ALOCEP
          ASCALE=SCALEP
          SH1=SHAPEP
        ELSEIF(IDFTTY.EQ.'LMOM')THEN
          ALOC=ALOCLM
          ASCALE=SCALLM
          SH1=SHAPLM
        ELSE
          ALOC=ALOCML
          ASCALE=SCALML
          SH1=SHAPML
        ENDIF
        IF(ASCALE.LE.0.0 .OR. SH1.LE.0.0)IERROR='YES'
C
      ELSEIF(ICASPL.EQ.'GPAR')THEN
        IGEPSV='EPER'
        IFLAG9=1
        MLFLAG=.TRUE.
        CALL GEPML1(Y,N,MAXNXT,MINMAX,ICASPL,IGEPDF,IGEPSV,IDFTTY,
     1              GAMMSV,SCALSV,ISEED,THRESH,
     1              TEMP1,TEMP2,TEMP3,TEMP4,TEMP5,YTEMP,
     1              DTEMP1,XMOM,NMOM,
     1              XMEAN,XSD,XVAR,XMIN,XMAX,
     1              ALOCMO,SCALMO,SHAPMO,
     1              ALOCLM,SCALLM,SHAPLM,
     1              ALOCEP,SCALEP,SHAPEP,
     1              ALOCML,SCALML,SHAPML,MLFLA2,
     1              NUSE,ZMEAN,ZVAR,ZSD,ALOC2,
     1              VARMM1,VARMM2,COVMOM,
     1              VARML1,VARML2,COVML,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IDFTTY.EQ.'EPER')THEN
          ALOC=ALOCEP
          ASCALE=SCALEP
          SH1=SHAPEP
        ELSEIF(IDFTTY.EQ.'LMOM')THEN
          ALOC=ALOCLM
          ASCALE=SCALLM
          SH1=SHAPLM
        ELSEIF(IDFTTY.EQ.'MOME')THEN
          ALOC=ALOCMO
          ASCALE=SCALMO
          SH1=SHAPMO
        ELSE
          ALOC=ALOCML
          ASCALE=SCALML
          SH1=SHAPML
        ENDIF
        IF(ASCALE.LE.0.0 .OR. SH1.LE.0.0)IERROR='YES'
C
      ELSEIF(ICASPL.EQ.'BU10')THEN
        IFLAG9=1
C
        IHP='RSV '
        IHP2='    '
        IHWUSE='P'
        MESSAG='NO'
        CALL CHECKN(IHP,IHP2,IHWUSE,
     1  IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1  ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCP,IERROR)
        SHAPSV=CPUMIN
        IF(IERROR.EQ.'NO')SHAPSV=VALUE(ILOCP)
C
        IHP='SCAL'
        IHP2='ESV '
        IHWUSE='P'
        MESSAG='NO'
        CALL CHECKN(IHP,IHP2,IHWUSE,
     1  IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1  ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCP,IERROR)
        SCALSV=CPUMIN
        IF(IERROR.EQ.'NO')SCALSV=VALUE(ILOCP)
C
        CALL B10ML1(Y,N,MAXNXT,
     1              TEMP1,TEMP2,TEMP3,DTEMP1,
     1              XMEAN,XSD,XVAR,XMIN,XMAX,
     1              SCALSV,SHAPSV,SCALML,SHAPML,
     1              ISUBRO,IBUGA3,IERROR)
        ALOC=CPUMIN
        ASCALE=SCALML
        SH1=SHAPML
        IF(ASCALE.LE.0.0 .OR. SH1.LE.0.0)IERROR='YES'
C
      ELSEIF(ICASPL.EQ.'LEXP')THEN
        IFLAG9=1
C
        IHP='ALPH'
        IHP2='ASV '
        IHWUSE='P'
        MESSAG='NO'
        CALL CHECKN(IHP,IHP2,IHWUSE,
     1  IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1  ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCP,IERROR)
        SCALSV=CPUMIN
        IF(IERROR.EQ.'NO')SCALSV=VALUE(ILOCP)
C
        IHP='BETA'
        IHP2='SV  '
        IHWUSE='P'
        MESSAG='NO'
        CALL CHECKN(IHP,IHP2,IHWUSE,
     1  IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1  ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCP,IERROR)
        SHAPSV=CPUMIN
        IF(IERROR.EQ.'NO')SHAPSV=VALUE(ILOCP)
C
        CALL LEXML1(Y,N,MAXNXT,
     1              TEMP1,DTEMP1,
     1              XMEAN,XSD,XVAR,XMIN,XMAX,XSUM,
     1              SCALSV,SHAPSV,SCALML,SHAPML,
     1              ISUBRO,IBUGA3,IERROR)
        ALOC=CPUMIN
        ASCALE=SCALML
        SH1=SHAPML
        IF(ASCALE.LE.0.0 .OR. SH1.LE.0.0)IERROR='YES'
C
      ELSEIF(ICASPL.EQ.'PEA3')THEN
        IFLAG9=1
        CALL PE3ML1(Y,N,
     1              DTEMP1,XMOM,NMOM,
     1              XMEAN,XSD,XVAR,XMIN,XMAX,
     1              ALOC,ASCALE,SH1,
     1              ISUBRO,IBUGA3,IERROR)
        IF(ASCALE.LE.0.0 .OR. SH1.LE.0.0)IERROR='YES'
        IF(IERROR.EQ.'YES')GOTO9000
C
      ELSEIF(ICASPL.EQ.'G5LO')THEN
        IFLAG9=1
        CALL GL5ML1(Y,N,
     1              DTEMP1,XMOM,NMOM,
     1              XMEAN,XSD,XVAR,XMIN,XMAX,
     1              ALOC,ASCALE,SH1,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IF(ASCALE.LE.0.0)IERROR='YES'
C
      ELSEIF(ICASPL.EQ.'KAPP')THEN
        IFLAG9=1
        CALL KAPML1(Y,N,
     1              DTEMP1,XMOM,NMOM,
     1              XMEAN,XSD,XVAR,XMIN,XMAX,
     1              ALOC,ASCALE,SH1,SH2,
     1              ISUBRO,IBUGA3,IERROR)
        IF(ASCALE.LE.0.0)IERROR='YES'
        IF(IERROR.EQ.'YES')GOTO9000
C
      ELSEIF(ICASPL.EQ.'BNOR')THEN
        IFLAG9=1
C
        IHP='ALPH'
        IHP2='ASV '
        IHWUSE='P'
        MESSAG='NO'
        CALL CHECKN(IHP,IHP2,IHWUSE,
     1  IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1  ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCP,IERROR)
        ALPHSV=CPUMIN
        IF(IERROR.EQ.'NO')ALPHSV=VALUE(ILOCP)
C
        IHP='BETA'
        IHP2='SV  '
        IHWUSE='P'
        MESSAG='NO'
        CALL CHECKN(IHP,IHP2,IHWUSE,
     1  IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1  ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCP,IERROR)
        BETASV=CPUMIN
        IF(IERROR.EQ.'NO')BETASV=VALUE(ILOCP)
C
        IHP='MUSV'
        IHP2='    '
        IHWUSE='P'
        MESSAG='NO'
        CALL CHECKN(IHP,IHP2,IHWUSE,
     1  IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1  ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCP,IERROR)
        AMUSV=CPUMIN
        IF(IERROR.EQ.'NO')AMUSV=VALUE(ILOCP)
C
        IHP='SIGM'
        IHP2='ASV '
        IHWUSE='P'
        MESSAG='NO'
        CALL CHECKN(IHP,IHP2,IHWUSE,
     1  IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1  ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCP,IERROR)
        SIGMSV=CPUMIN
        IF(IERROR.EQ.'NO')SIGMSV=VALUE(ILOCP)
C
        CALL BNOML1(Y,N,MAXNXT,DTEMP1,
     1              XMEAN,XSD,XVAR,XMIN,XMAX,
     1              AMUSV,SIGMSV,ALPHSV,BETASV,
     1              ALOCML,ASCALE,SH1,SH2,
     1              ISUBRO,IBUGA3,IERROR)
        IF(ASCALE.LE.0.0 .OR. SH1.LE.0.0 .OR. SH2.LE.0.0)IERROR='YES'
        IF(IERROR.EQ.'YES')GOTO9000
C
      ELSEIF(ICASPL.EQ.'PEXP')THEN
        IFLAG9=1
        IHP='BETA'
        IHP2='SV  '
        IHWUSE='P'
        MESSAG='NO'
        CALL CHECKN(IHP,IHP2,IHWUSE,
     1  IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1  ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCP,IERROR)
        BETASV=CPUMIN
        IF(IERROR.EQ.'NO')BETASV=VALUE(ILOCP)
C
        IHP='SCAL'
        IHP2='ESV '
        IHWUSE='P'
        MESSAG='NO'
        CALL CHECKN(IHP,IHP2,IHWUSE,
     1  IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1  ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCP,IERROR)
        SCALSV=CPUMIN
        IF(IERROR.EQ.'NO')SCALSV=VALUE(ILOCP)
C
        CALL PEXML1(Y,N,BETASV,SCALSV,MAXNXT,
     1             TEMP1,TEMP2,TEMP3,DTEMP1,
     1             XMEAN,XSD,XVAR,XMIN,XMAX,
     1             SH1,ASCALE,
     1             ISUBRO,IBUGA3,IERROR)
        ALOC=CPUMIN
        IF(ASCALE.LE.0.0 .OR. SH1.LE.0.0)IERROR='YES'
C
      ELSEIF(ICASPL.EQ.'ALPH')THEN
        IFLAG9=1
        IHP='ALPH'
        IHP2='ASV '
        IHWUSE='P'
        MESSAG='NO'
        CALL CHECKN(IHP,IHP2,IHWUSE,
     1  IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1  ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCP,IERROR)
        ALPHSV=CPUMIN
        IF(IERROR.EQ.'NO')ALPHSV=VALUE(ILOCP)
C
        IHP='SCAL'
        IHP2='ESV '
        IHWUSE='P'
        MESSAG='NO'
        CALL CHECKN(IHP,IHP2,IHWUSE,
     1  IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1  ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCP,IERROR)
        SCALSV=CPUMIN
        IF(IERROR.EQ.'NO')SCALSV=VALUE(ILOCP)
C
        CALL ALPML1(Y,N,ALPHSV,SCALSV,MAXNXT,
     1              TEMP1,TEMP2,TEMP3,DTEMP1,
     1              XMEAN,XSD,XVAR,XMIN,XMAX,
     1              ALPHMO,SCALMO,ALPHML,SCALML,
     1              ISUBRO,IBUGA3,IERROR)
        ALOC=CPUMIN
        ASCALE=SCALML
        SH1=SCALML
        IF(ASCALE.LE.0.0 .OR. SH1.LE.0.0)IERROR='YES'
C
      ELSEIF(ICASPL.EQ.'ADEX')THEN
        IFLAG9=1
        CALL ADEML1(Y,N,MAXNXT,
     1              TEMP1,DTEMP1,DTEMP2,DTEMP3,
     1              XMEAN,XMED,XSD,XVAR,XMIN,XMAX,
     1              ALOC,ASCALE,SH1,
     1              ISUBRO,IBUGA3,IERROR)
        IF(ASCALE.LE.0.0 .OR. SH1.LE.0.0)IERROR='YES'
        IF(SH1.EQ.CPUMIN)IERROR='YES'
C
      ELSEIF(ICASPL.EQ.'PARE')THEN
        IFLAG9=1
C
        CALL PARML1(Y,N,
     1              DTEMP1,
     1              XMEAN,XSD,XMIN,XMAX,
     1              AMOM,SHAPMO,
     1              AMM,SHAPMM,
     1              AML,SHAPML,AMLSE,SHAPSE,
     1              ISUBRO,IBUGA3,IERROR)
C
        SH1=AML
        SH2=SHAPML
        IF(IDFTTY.EQ.'MOME')THEN
          SH1=AMOM
          SH2=SHAPMO
        ELSEIF(IDFTTY.EQ.'MMOM')THEN
          SH1=AMM
          SH2=SHAPMM
        ENDIF
        IF(SH2.LE.0.0)IERROR='YES'
C
      ELSEIF(ICASPL.EQ.'TPAR')THEN
        IFLAG9=1
C
        IHP='R   '
        IHP2='    '
        IHWUSE='P'
        MESSAG='NO'
        CALL CHECKN(IHP,IHP2,IHWUSE,
     1  IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1  ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCP,IERROR)
        IF(IERROR.EQ.'NO')THEN
          AR=VALUE(ILOCP)
        ELSE
          AR=-1.0
        ENDIF
        IR=INT(AR)
C
        CALL TNPML1(Y,N,IR,DTEMP1,
     1              XMEAN,XSD,XMIN,XMAX,
     1              AML,ANUML,GAMMML,
     1              ISUBRO,IBUGA3,IERROR)
C
        SH1=AML
        SH2=ANUML
        SH3=GAMMML
        IF(SH3.LE.0.0)IERROR='YES'
C
      ELSEIF(ICASPL.EQ.'WAKE')THEN
        IFLAG9=1
        CALL WAKML1(Y,N,
     1              DTEMP1,XMOM,NMOM,
     1              XMEAN,XSD,XVAR,XMIN,XMAX,
     1              ALOC,ASCALE,SH1,SH2,SH3,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
      ELSEIF(ICASPL.EQ.'TRIA')THEN
        IFLAG9=1
        CALL TRIML1(Y,N,MAXNXT,
     1              TEMP1,TEMP2,DTEMP1,
     1              XMIN,XMAX,XMEAN,XSD,
     1              A,B,ALOWQN,AUPPQN,
     1              AQUANT,BQUANT,
     1              AML,BML,CML,
     1              ISUBRO,IBUGA3,IERROR)
        ALOC=AML
        ASCALE=BML
        SH1=CML
C
      ELSEIF(ICASPL.EQ.'TOPL')THEN
        IFLAG9=1
        IF(YLOWLM.NE.CPUMIN .AND. YUPPLM.NE.CPUMIN)THEN
          ZMIN=YLOWLM
          ZMAX=YUPPLM
        ELSE
          ZMIN=CPUMIN
          ZMAX=CPUMIN
        ENDIF
        CALL TOPML1(Y,N,ZMIN,ZMAX,
     1              XMIN,XMAX,XMEAN,XSD,
     1              SH1,ZLOC,ZSCALE,
     1              ISUBRO,IBUGA3,IERROR)
        ALOC=ZLOC
        ASCALE=ZLOC + ZSCALE
        IF(ASCALE.LE.0.0 .OR. SH1.LE.0.0)IERROR='YES'
C
      ELSEIF(ICASPL.EQ.'POWF')THEN
        IFLAG9=1
        ICASE2='POWE'
        IF(YLOWLM.NE.CPUMIN .AND. YUPPLM.NE.CPUMIN)THEN
          ZMIN=YLOWLM
          ZMAX=YUPPLM
        ELSE
          ZMIN=CPUMIN
          ZMAX=CPUMIN
        ENDIF
        CALL POWML1(Y,N,ICASE2,
     1              XMIN,XMAX,XMEAN,XSD,
     1              SHAPMO,SHAPML,ZMIN,ZMAX,
     1              ISUBRO,IBUGA3,IERROR)
        ALOC=ZMIN
        ASCALE=ZMAX
        SH1=SHAPML
        IF(SH1.LE.0.0)IERROR='YES'
C
      ELSEIF(ICASPL.EQ.'RPOW')THEN
        IFLAG9=1
        ICASE2='RPOW'
        IF(YLOWLM.NE.CPUMIN .AND. YUPPLM.NE.CPUMIN)THEN
          ZMIN=YLOWLM
          ZMAX=YUPPLM
        ELSE
          ZMIN=CPUMIN
          ZMAX=CPUMIN
        ENDIF
        CALL POWML1(Y,N,ICASE2,
     1              XMIN,XMAX,XMEAN,XSD,
     1              SHAPMO,SHAPML,ZMIN,ZMAX,
     1              ISUBRO,IBUGA3,IERROR)
        ALOC=ZMIN
        ASCALE=ZMAX
        SH1=SHAPML
        IF(SH1.LE.0.0)IERROR='YES'
C
      ELSEIF(ICASPL.EQ.'BETA')THEN
        IFLAG9=1
C
        IHP='BETA'
        IHP2='LL  '
        IHWUSE='P'
        MESSAG='NO'
        CALL CHECKN(IHP,IHP2,IHWUSE,
     1  IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1  ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCP,IERROR)
        AUSER=CPUMIN
        IF(IERROR.EQ.'NO')AUSER=VALUE(ILOCP)
C
        IHP='BETA'
        IHP2='UL  '
        IHWUSE='P'
        MESSAG='NO'
        CALL CHECKN(IHP,IHP2,IHWUSE,
     1  IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1  ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCP,IERROR)
        BUSER=CPUMIN
        IF(IERROR.EQ.'NO')AUSER=VALUE(ILOCP)
C
        IF(AUSER.EQ.CPUMIN .OR. BUSER.EQ.CPUMIN)THEN
          IF(YLOWLM.NE.CPUMIN .AND. YUPPLM.NE.CPUMIN)THEN
            AUSER=YLOWLM
            BUSER=YUPPLM
          ELSE
            AUSER=CPUMIN
            BUSER=CPUMIN
          ENDIF
        ENDIF
C
        CALL BETML1(Y,N,DTEMP1,MAXNXT,AUSER,BUSER,
     1              XMIN,XMAX,XMEAN,XSD,XVAR,
     1              A,B,
     1              ALPHMO,BETAMO,
     1              ALPHML,BETAML,
     1              ISUBRO,IBUGA3,IERROR)
         SH1=ALPHML
         SH2=BETAML
         ALOC=A
         ASCALE=B
         IF(IDFTTY.EQ.'MOME')THEN
           SH1=ALPHMO
           SH2=BETAMO
         ENDIF
        IF(ASCALE.LE.0.0 .OR. SH1.LE.0.0 .OR. SH2.LE.0.0)IERROR='YES'
C
      ELSEIF(ICASPL.EQ.'4BET')THEN
        IFLAG9=1
C
        CALL BETML4(Y,N,DTEMP1,MAXNXT,
     1              XMIN,XMAX,XMEAN,XSD,XVAR,
     1              AMOM,BMOM,ALPHMO,BETAMO,
     1              AML,BML,ALPHML,BETAML,IMLFLG,
     1              ISUBRO,IBUGA3,IERROR)
        SH1=ALPHML
        SH2=BETAML
        ALOC=AML
        ASCALE=BML
        IF(IDFTTY.EQ.'MOME')THEN
          SH1=ALPHMO
          SH2=BETAMO
          ALOC=AMOM
          ASCALE=BMOM
        ENDIF
        IF(ASCALE.LE.0.0 .OR. SH1.LE.0.0 .OR. SH2.LE.0.0)IERROR='YES'
C
      ELSEIF(ICASPL.EQ.'TSPO')THEN
        IFLAG9=1
C
        CALL TSPML1(Y,N,TEMP1,TEMP2,TEMP3,TEMP4,DTEMP1,
     1              XMIN,XMAX,XMEAN,XSD,
     1              ALOC,ASCALE,SH1,SH2,
     1              ISUBRO,IBUGA3,IERROR)
        IF(ASCALE.LE.0.0 .OR. SH2.LE.0.0)IERROR='YES'
C
      ELSEIF(ICASPL.EQ.'RGTL')THEN
        IFLAG9=1
        NUMV=1
        ALPHSV=CPUMIN
C
        CALL RGTML1(Y,TEMP5,YTEMP,N,NUMV,MAXNXT,N,
     1              DTEMP1,TEMP1,TEMP2,TEMP3,TEMP4,
     1              XMIN,XMAX,XMEAN,XSD,
     1              ALPHSV,A,B,
     1              SH1,SH2,ALOC,ASCALE,
     1              ISUBRO,IBUGA3,IERROR)
        IF(ASCALE.LE.0.0 .OR. SH1.LE.0.0 .OR. SH2.LE.0.0)IERROR='YES'
C
      ELSEIF(ICASPL.EQ.'VONM')THEN
        IFLAG9=1
        CALL VONML1(Y,N,
     1              TEMP1,
     1              XMEAN,XSD,XVAR,XMIN,XMAX,
     1              ALOCML,SHAPML,
     1              ISUBRO,IBUGA3,IERROR)
        ALOC=ALOCML
        ASCALE=1.0
        SH1=SHAPML
        IF(SH1.LE.0.0)IERROR='YES'
C
C     NORMAL MIXTURE: CURRENTLY LIMIT IT TO THE 2-COMPONENT
C                     CASE.
C
      ELSEIF(ICASPL.EQ.'NORX')THEN
        IFLAG9=1
        NCOMP=2
        NVAR=1
        CALL NMXML1(Y,CENSOR,N,NVAR,YTEMP,TEMP1,N2,
     1              TEMP2,TEMP3,TEMP4,TEMP5,ITEMP1,MAXNXT,
     1              CLLIMI,CLWIDT,NCOMP,IHSTCW,
     1              MIXPRO,XMEANV,XSDV,KMAX,NTOT2,ALOGL,
     1              AMEAN,ASD,AMIN,AMAX,
     1              ISUBRO,IBUGA3,IERROR)
        SH1=XMEANV(1)
        SH2=XMEANV(2)
        SH3=XSDV(1)
        SH4=XSDV(2)
        SH5=MIXPRO(1)
        IF(IERROR.EQ.'YES')GOTO9000
C
      ELSE
CCCCC   WRITE(ICOUT,999)
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   WRITE(ICOUT,31)
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   WRITE(ICOUT,8011)ICASPL
 8011   FORMAT('      UNKNOWN DISTRIBUTION -- ',A40)
CCCCC   CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        IFLAG9=-99
        GOTO9000
      ENDIF
C
      GOTO9000
C
C     SET AN ERROR FLAG TO INDICATE A DISCRETE DISTRIBUTION
C     IS NOT TO BE PROCESSED.
C
 8000 CONTINUE
      IFLAGD=99
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
C
      IF(IERROR.EQ.'YES')THEN
        ALOC=CPUMIN
        ASCALE=CPUMIN
        SH1=CPUMIN
        SH2=CPUMIN
        SH3=CPUMIN
        SH4=CPUMIN
        SH5=CPUMIN
        SH6=CPUMIN
        SH7=CPUMIN
      ENDIF
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'PML1')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPML1--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)ICASPL,N,MINMAX,IERROR
 9012   FORMAT('ICASPL,N,MINMAX,IERROR = ',A4,2X,2I8,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9014)ALOC,ASCALE,SH1,SH2
 9014   FORMAT('ALOC,ASCALE,SH1,SH2 = ',4G15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLAD(Y,N,MAXNXT,
     1                  TEMP1,ITEMP,DALPHA,DBETA,DH,
     1                  AKML,ALOCML,SCALML,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR THE ASYMMETRIC DOUBLE EXPONENTIAL
C              DISTRIBUTION.
C     EXAMPLE--ASYMMETRIC DOUBLE EXPONENTIAL MAXIMUM LIKELIHOOD Y
C     REFERENCES--KOTZ, KOZUBOWSKI, AND PODGORSKI, "THE LAPLACE
C                 DISTRIBUTION AND GENERALIZATIONS: A REVISIT WITH
C                 APPLICATIONS TO COMMUNICATIONS, ECONOMICS,
C                 ENGINEERING, AND FINANCE", BIRKHAUSR, 2001,
C                 PP. 133-178.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004/8
C     ORIGINAL VERSION--AUGUST    2004.
C     UPDATED         --JULY      2010. USE DPDTA1, DPDT8A TO
C                                       PRINT OUTPUT
C     UPDATED         --JULY      2010. EXTRACT POINT ESTIMATES
C                                       TO ADEML1
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION TEMP1(*)
      DIMENSION ITEMP(*)
C
      DOUBLE PRECISION DALPHA(*)
      DOUBLE PRECISION DBETA(*)
      DOUBLE PRECISION DH(*)
C
      DIMENSION QP(1)
      DIMENSION FISH(3,3)
      DIMENSION COV(3,3)
C
      CHARACTER*4 IOP
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=20)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*40 ITEXT(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='AD  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLAD')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLAD--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N
   52   FORMAT('IBUGA3,ISUBRO,N = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLAD')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NPERC=0
      NMIN=4
      CALL CKDIST(Y,N,NMIN,QP,NPERC,ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C               *********************************************
C               **  STEP 21--                              **
C               **  CARRY OUT CALCULATIONS                 **
C               **  FOR ASYMMETRIC DOUBLE EXPONENTIAL MLE  **
C               **  ESTIMATE (FULL SAMPLE CASE)            **
C               *********************************************
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLAD')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IERROR='NO'
      IWRITE='OFF'
C
      CALL ADEML1(Y,N,MAXNXT,
     1            TEMP1,DALPHA,DBETA,DH,
     1            XMEAN,XMED,XSD,XVAR,XMIN,XMAX,
     1            ALOCML,SCALML,AKML,
     1            ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C  NOW COMPUTE THE FISHER INFORMATION MATRIX, THEN INVERT TO
C  OBTAIN THE ASYMPTOTIC VARIANCE-COVARIANCE MATRIX.  THEN WRITE
C  TO DPST1F.DAT.
C
      FISH(1,1)=2.0/(SCALML**2)
      FISH(1,2)=-SQRT(2.0)*2.0/(SCALML*(1.0+AKML**2))
      FISH(3,1)=0.0
      FISH(2,1)=FISH(1,2)
      FISH(2,2)=(1.0/(AKML**2)) + 4.0/((1.0+AKML**2)**2)
      FISH(2,3)=-(1.0-AKML**2)/(SCALML*AKML*(1.0+AKML**2))
      FISH(1,3)=FISH(3,1)
      FISH(3,2)=FISH(2,3)
      FISH(3,3)=1.0/(SCALML**2)
CCCCC print *,'fish(1,1) = ',fish(1,1)
CCCCC print *,'fish(2,2) = ',fish(2,2)
CCCCC print *,'fish(3,3) = ',fish(3,3)
CCCCC print *,'fish(1,2) = ',fish(1,2)
CCCCC print *,'fish(2,3) = ',fish(2,3)
CCCCC print *,'fish(3,1) = ',fish(3,1)
      CALL SGECO(FISH,3,3,ITEMP,RCOND,TEMP1)
      IJOB=1
      CALL SGEDI(FISH,3,3,ITEMP,TEMP1,TEMP1(MAXNXT/2),IJOB)
      DO2810J=1,3
        DO2815I=1,3
          COV(I,J)=FISH(I,J)
 2815   CONTINUE
 2810 CONTINUE
C
      IOP='OPEN'
      IFLAG1=1
      IFLAG2=0
      IFLAG3=0
      IFLAG4=0
      IFLAG5=0
      CALL DPAUFI(IOP,IFLAG1,IFLAG2,IFLAG3,IFLAG4,IFLAG5,
     1            IOUNI1,IOUNI2,IOUNI3,IOUNI4,IOUNI5,
     1            IBUGA3,ISUBRO,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      WRITE(IOUNI1,2905)
 2905 FORMAT(' THETA             K               SIGMA')
      DO2910I=1,3
        WRITE(IOUNI1,'(3(E15.7,2X))')COV(I,1),COV(I,2),COV(I,3)
 2910 CONTINUE
C
      IOP='CLOS'
      CALL DPAUFI(IOP,IFLAG1,IFLAG2,IFLAG3,IFLAG4,IFLAG5,
     1            IOUNI1,IOUNI2,IOUNI3,IOUNI4,IOUNI5,
     1            IBUGA3,ISUBRO,IERROR)
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Asymmetric Double Exponential Parameter Estimation'
      NCTITL=50
      ITITLZ=' '
      NCTITZ=0
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(N)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Median:'
      NCTEXT(ICNT)=14
      AVALUE(ICNT)=XMED
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Maximum Likelihood:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Location (Theta):'
      NCTEXT(ICNT)=29
      AVALUE(ICNT)=ALOCML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Scale (Sigma):'
      NCTEXT(ICNT)=30
      AVALUE(ICNT)=SCALML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Shape (K):'
      NCTEXT(ICNT)=22
      AVALUE(ICNT)=AKML
      IDIGIT(ICNT)=NUMDIG
C
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='Log-likelihood:'
CCCCC NCTEXT(ICNT)=15
CCCCC AVALUE(ICNT)=ALIK
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=AIC
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AICc:'
CCCCC NCTEXT(ICNT)=5
CCCCC AVALUE(ICNT)=AICC
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='BIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=BIC
CCCCC IDIGIT(ICNT)=-7
C
      NUMROW=ICNT
      DO2320I=1,NUMROW
        NTOT(I)=15
 2320 CONTINUE
C
      IFRST=.FALSE.
      ILAST=.FALSE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLAD')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLAD--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012   FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLAE(Y,X,N,NVAR,
     1                  TEMP1,TEMP2,TEMP3,DTEMP1,
     1                  THETMO,PMOM,THETFR,PFR,THETAF2,PF2,THETML,PML,
     1                  ICAPSW,ICAPTY,IFORSW,MAXNXT,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR THE POLYA-AEPPLI DISTRIBUTION.
C
C              THE MOMENT ESTIMATORS ARE:
C
C                  THETAHAT = 2*XBAR**2/(s**2+XBAR)
C                  PHAT     = (S**2 - XBAR)/(S**2 + XBAR)
C
C              THE MEAN AND ZERO FREQUENCY ESTIMATORS ARE:
C
C                  THETAHAT = LOG(f0/N)
C                  PHAT     = 1 - THETHAT/XBAR
C
C              THE FIRST TWO FREQUENCIES ESTIMATORS ARE:
C
C                  THETAHAT = -LOG(f0/N)
C                  PHAT     = -f1/{f0*LOG(f0/N)}
C
C              THE MAXIMUM LIKELIHOOD ESTIMATES ARE THE SOLUTION
C              THE FOLLOWING EQUATIONS:
C
C                  XBAR - THETAHAT/(1-PHAT) = 0
C                  XBAR - SUM[J=1 to N][fj*(J-1)*P(J-1)/(N*P(J))} = 0
C
C              WHERE P(J) = THE POLYA-AEPPLI PDF USING THE
C              ESTIMATED PARAMETERS.
C
C              THERE ARE TWO CASES:
C
C              1) ONE VARIABLE CASE: Y IS RAW DATA
C              2) TWO VARIABLE CASE: Y IS FREQUENCY, X IS CLASS
C                 MID-POINT.
C
C     EXAMPLE--POLYA-AEPPLI MAXIMUM LIKELIHOOD Y
C            --POLYA-AEPPLI MAXIMUM LIKELIHOOD Y X
C     REFERENCES--JOHNSON, KOTZ, AND KEMP (1992).  "UNIVARIATE
C                 DISCRETE DISTRIBUTIONS", SECOND EDITION, 
C                 WILEY, PP. 378-382.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2006/6
C     ORIGINAL VERSION--JUNE      2006.
C     UPDATED         --APRIL     2011. USE DPDTA1 TO PRINT OUTPUT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-----------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*4 ISUBN0
      CHARACTER*4 IRELAT
      CHARACTER*4 IRHSTG
C
      PARAMETER (MAXROW=50)
      CHARACTER*60 ITITLE
      CHARACTER*1  ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 IDIST
      CHARACTER*40 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(MAXROW)
      CHARACTER*4  VALIGN(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL      IFRST
      LOGICAL      ILAST
C
C-------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION TEMP1(*)
      DIMENSION TEMP2(*)
      DIMENSION TEMP3(*)
      DOUBLE PRECISION DTEMP1(*)
C
      DOUBLE PRECISION TOL
      DOUBLE PRECISION XPAR(2)
      DOUBLE PRECISION FVEC(2)
C
      EXTERNAL PAPFUN
      DOUBLE PRECISION XBAR
      COMMON/PAPCOM/MAXRO2,NTOT2,XBAR
C
C-------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT---------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='AE  '
C
      IERROR='NO'
      IWRITE='OFF'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLAE')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLAE--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N,NVAR
   52   FORMAT('IBUGA3,ISUBRO,N,NVAR = ',2(A4,2X),2I8)
        CALL DPWRST('XXX','WRIT')
        IF(NVAR.EQ.1)THEN
          DO56I=1,MIN(N,100)
            WRITE(ICOUT,57)I,Y(I)
   57       FORMAT('I,Y(I) = ',I8,G15.7)
            CALL DPWRST('XXX','WRIT')
   56     CONTINUE
        ELSE
          DO61I=1,N
            WRITE(ICOUT,62)I,X(I),Y(I)
   62       FORMAT('I,X(I),Y(I) = ',I8,2G15.7)
            CALL DPWRST('XXX','WRIT')
   61     CONTINUE
        ENDIF
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  1) ROUND DATA TO INTEGER VALUES       **
C               **  2) COMPUTE SUMMARY STATISTICS         **
C               **  3) CHECK INPUT FOR NEGATIVE VALUES,   **
C               **     INSUFFICIENT SAMPLE SIZE           **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLAE')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IDIST='POLYA-AEPPLI'
C
      NPERC=0
      MAXGRP=MAXNXT/2
      NMIN=2
      IF(NVAR.EQ.1)THEN
        DO1105I=1,N
          ITEMP=INT(Y(I)+0.5)
          Y(I)=REAL(ITEMP)
 1105   CONTINUE
        CALL CKDIST(Y,N,NMIN,TEMP1,NPERC,ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
        IFLAG=1
        CALL SUMRAW(Y,N,IDIST,IFLAG,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        NTOTZZ=N
C
C       NOW BIN THE DATA FOR USE BY THE ESTIMATION METHOD BELOW
C
        IRELAT='OFF'
        IRHSTG='OFF'
        XSTART=XMIN-0.5
        XSTOP=XMAX+0.5
        CLWID=1.0
        CALL DPBINI(Y,N,IRELAT,CLWID,XSTART,XSTOP,IRHSTG,
     1              TEMP1,X,N2,IBUGA3,IERROR)
        ICNT=0
        DO1121I=1,N2
          IF(TEMP1(I).GT.0.0)THEN
            ICNT=ICNT+1
            Y(ICNT)=TEMP1(I)
            X(ICNT)=X(I)
          ENDIF
1121    CONTINUE
        N2=ICNT
      ELSE
        CALL CKDIS2(Y,X,TEMP1,N,MAXGRP,NMIN,TEMP2,NPERC,NTOTZZ,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IFLAG1=1
        IFLAG2=1
        CALL SUMGRP(Y,X,N,IDIST,IFLAG1,IFLAG2,
     1              TEMP1,TEMP2,TEMP3,MAXNXT,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ,
     1              ISUBRO,IBUGA3,IERROR)
        ICNT=0
        DO1221I=1,N2
          IF(Y(I).GT.0.0)THEN
            ICNT=ICNT+1
            Y(ICNT)=Y(I)
            X(ICNT)=X(I)
          ENDIF
1221    CONTINUE
        N2=ICNT
      ENDIF
      IF(IERROR.EQ.'YES')GOTO9000
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLAE')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1311)
 1311   FORMAT('AFTER COMPUTE SUMMARY STATISTICS--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1312)XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ
 1312   FORMAT('XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ = ',5G15.7,I10)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
C               *********************************************
C               **  STEP 21--                              **
C               **  CARRY OUT CALCULATIONS                 **
C               **  FOR POLYA-AEPPLI MLE ESTIMATION        **
C               *********************************************
C
 2100 CONTINUE
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLAE')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IML=0
      IINDX=MAXNXT/2
      IF(N2.LE.IINDX)THEN
        IWD=0
        DO2290I=1,N2
          TEMP3(I)=Y(I)
          TEMP3(IINDX+I)=X(I)
 2290   CONTINUE
        IK=N2
      ELSE
        IML=1
      ENDIF
C
      F1=Y(1)
      F2=Y(2)
C
      THETMO=2.0*XMEAN**2/(XVAR+XMEAN)
      PMOM=(XVAR - XMEAN)/(XVAR + XMEAN)
      THETFR=-LOG(F1/REAL(NTOTZZ))
      PFR=1.0 - THETFR/XMEAN
      THETF2=-LOG(F1/REAL(NTOTZZ))
      PF2=-F2/(F1*LOG(F1/REAL(NTOTZZ)))
      THETML=THETMO
      PML=PMOM
C
      IF(IML.EQ.0)THEN
        IOPT=2
        TOL=1.0D-5
        NPAR=2
        NPRINT=-1
        INFO=0
        LWA=MAXNXT
        MAXRO2=MAXNXT
        NTOT2=NTOTZZ
C
        XBAR=DBLE(XMEAN)
        XPAR(1)=DBLE(THETML)
        XPAR(2)=DBLE(PML)
        CALL DNSQE(PAPFUN,JAC,IOPT,NPAR,XPAR,FVEC,TOL,NPRINT,INFO,
     1             DTEMP1,LWA,TEMP3,IK)
C
        THETML=REAL(XPAR(1))
        PML=REAL(XPAR(2))
      ENDIF
C
C               ***********************************************
C               **   STEP 42--                               **
C               **   WRITE OUT EVERYTHING                    **
C               **   FOR POLYA-AEPPLI MLE ESTIMATION         **
C               ***********************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLAE')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     PRINT SUMMARY STATISTICS TABLE
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Polya-Aeppli Parameter Estimation'
      NCTITL=33
      ITITLZ=' '
      NCTITZ=0
C
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(NTOTZZ)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample First Frequency:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=F1
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Second Frequency:'
      NCTEXT(ICNT)=24
      AVALUE(ICNT)=F2
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Method of Moments:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Theta:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=THETMO
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of P:'
      NCTEXT(ICNT)=14
      AVALUE(ICNT)=PMOM
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Method of Zero Frequency and Mean:'
      NCTEXT(ICNT)=34
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Theta:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=THETFR
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of P:'
      NCTEXT(ICNT)=14
      AVALUE(ICNT)=PFR
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Method of First Two Frequencies:'
      NCTEXT(ICNT)=32
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Theta:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=THETF2
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of P:'
      NCTEXT(ICNT)=14
      AVALUE(ICNT)=PF2
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Method of Maximum Likelihood:'
      NCTEXT(ICNT)=29
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Theta:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=THETML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of P:'
      NCTEXT(ICNT)=14
      AVALUE(ICNT)=PML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      NUMROW=ICNT
      DO2310I=1,NUMROW
        NTOT(I)=15
 2310 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLAE')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLAE--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)IERROR
 9012   FORMAT('IERROR = ',A4)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLAL(Y,N,MAXNXT,
     1                  TEMP1,TEMP2,DISPAR,DTEMP,ITEMP,
     1                  ALPHSV,SCALSV,
     1                  SCALML,ALPHML,SCALMO,ALPHMO,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD ESTIMATES
C              FOR THE ALPHA DISTRIBUTION FOR THE FULL SAMPLE CASE.
C     EXAMPLE--ALPHA MAXIMUM LIKELIHOOD Y
C     REFERENCE--JOHNSON, KOTZ, AND BALAKRISHNAN (1994), "CONTINUOUS
C                UNIVARIATE DISTRIBUTIONS--VOLUME I", SECOND EDITION,
C                WILEY, P. 173.
C              --SALVIA (1985), "RELIABILITY APPLICATIONS OF THE
C                ALPHA DISTRIBUTION", IEEE TRANSACTIONS ON
C                RELIABILITY, VOL. R-34, NO. 3, PP. 251-252.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2007/12
C     ORIGINAL VERSION--DECEMBER  2007.
C     UPDATED         --JULY      2010. USE DPDTA1 TO PRINT OUTPUT
C     UPDATED         --JULY      2010. EXTRACT POINT ESTIMATES TO
C                                       ALPML1
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION TEMP1(*)
      DIMENSION TEMP2(*)
      DIMENSION DISPAR(*)
      DOUBLE PRECISION DTEMP(*)
      INTEGER ITEMP(*)
      DIMENSION QP(1)
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=20)
      CHARACTER*40 ITITLE
      CHARACTER*1  ITITLZ
      CHARACTER*40 ITEXT(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='AL  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLAL')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLAL--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N
   52   FORMAT('IBUGA3,ISUBRO,N = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLAL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NPERC=0
      NMIN=3
      CALL CKDIST(Y,N,NMIN,QP,NPERC,ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C  COMPUTE SUMMARY STATISTICS.
C
      IERROR='NO'
      IWRITE='OFF'
C
      CALL ALPML1(Y,N,ALPHSV,SCALSV,MAXNXT,
     1             TEMP1,TEMP2,DISPAR,DTEMP,
     1             XMEAN,XSD,XVAR,XMIN,XMAX,
     1             ALPHMO,SCALMO,ALPHML,SCALML,
     1             ISUBRO,IBUGA3,IERROR)
C
C               *******************************************
C               **   STEP 42--                           **
C               **   WRITE OUT EVERYTHING                **
C               **   FOR ALPHA MLE ESTIMATE              **
C               *******************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLAL')
     1  CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Alpha Parameter Estimation'
      NCTITL=26
      ITITLZ=' '
      NCTITZ=0
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(N)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Moments:'
      NCTEXT(ICNT)=8
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Shape (Alpha):'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=ALPHMO
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Scale (Beta):'
      NCTEXT(ICNT)=25
      AVALUE(ICNT)=SCALMO
      IDIGIT(ICNT)=NUMDIG
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='Log-likelihood:'
CCCCC NCTEXT(ICNT)=15
CCCCC AVALUE(ICNT)=ALIKMO
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=AICMO
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AICc:'
CCCCC NCTEXT(ICNT)=5
CCCCC AVALUE(ICNT)=AICCMO
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='BIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=BICMO
CCCCC IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Maximum Likelihood:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Shape (Alpha):'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=ALPHML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Scale (Beta):'
      NCTEXT(ICNT)=25
      AVALUE(ICNT)=SCALML
      IDIGIT(ICNT)=NUMDIG
C
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='Log-likelihood:'
CCCCC NCTEXT(ICNT)=15
CCCCC AVALUE(ICNT)=ALIKML
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=AICML
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AICc:'
CCCCC NCTEXT(ICNT)=5
CCCCC AVALUE(ICNT)=AICCML
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='BIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=BICML
CCCCC IDIGIT(ICNT)=-7
C
      NUMROW=ICNT
      DO2320I=1,NUMROW
        NTOT(I)=15
 2320 CONTINUE
C
      IFRST=.FALSE.
      ILAST=.FALSE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLAL')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLAL--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012   FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9015)N
 9015   FORMAT('N = ',I8)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLBB(Y,X,N,NVAR,NTRIAL,
     1                  TEMP1,TEMP2,TEMP3,TEMP4,TEMP5,
     1                  DTEMP1,DTEMP2,ITEMP1,ITEMP2,ITEMP3,MAXNXT,
     1                  AMUML,THETML,ALPHML,BETAML,
     1                  ICASAN,ICAPSW,ICAPTY,IFORSW,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR THE BETA-BINOMIAL DISTRIBUTION
C     EXAMPLE--BETA-BINOMIAL MAXIMUM LIKELIHOOD Y
C     REFERENCE--XX
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2011/4
C     ORIGINAL VERSION--APRIL     2011. EXTRACTED AS DISTINCT
C                                       SUBROUTINE
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASAN
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 IBGEDF
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ICASPL
      CHARACTER*4 IRELAT
      CHARACTER*4 IRHSTG
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION TEMP1(*)
      DIMENSION TEMP2(*)
      DIMENSION TEMP3(*)
      DIMENSION TEMP4(*)
      DIMENSION TEMP5(*)
      DOUBLE PRECISION DTEMP1(*)
      DOUBLE PRECISION DTEMP2(*)
      INTEGER ITEMP1(*)
      INTEGER ITEMP2(*)
      INTEGER ITEMP3(*)
C
      PARAMETER (NUMALP=6)
      DIMENSION ALPHA(NUMALP)
      DIMENSION ALOWSC(NUMALP)
      DIMENSION AUPPSC(NUMALP)
      DIMENSION ALOWGA(NUMALP)
      DIMENSION AUPPGA(NUMALP)
C
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DSUM2
      DOUBLE PRECISION CCRIT
      DOUBLE PRECISION DMEW
      DOUBLE PRECISION DTHETA
      DOUBLE PRECISION SEM
      DOUBLE PRECISION SETH
      DOUBLE PRECISION RNL
C
      PARAMETER (MAXROW=30)
      CHARACTER*60 ITITLE
      CHARACTER*1  ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 IDIST
      CHARACTER*40 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(MAXROW)
      CHARACTER*4  VALIGN(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL      IFRST
      LOGICAL      ILAST
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='BB  '
C
      IERROR='NO'
      IWRITE='OFF'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLBB')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLBB--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N,NVAR
   52   FORMAT('IBUGA3,ISUBRO,N,NVAR = ',2(A4,2X),2I8)
        CALL DPWRST('XXX','WRIT')
        IF(NVAR.EQ.1)THEN
          DO56I=1,MIN(N,100)
            WRITE(ICOUT,57)I,Y(I)
   57       FORMAT('I,Y(I) = ',I8,G15.7)
            CALL DPWRST('XXX','WRIT')
   56     CONTINUE
        ELSE
          DO61I=1,N
            WRITE(ICOUT,62)I,X(I),Y(I)
   62       FORMAT('I,X(I),Y(I) = ',I8,2G15.7)
            CALL DPWRST('XXX','WRIT')
   61     CONTINUE
        ENDIF
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  1) ROUND DATA TO INTEGER VALUES       **
C               **  2) COMPUTE SUMMARY STATISTICS         **
C               **  3) CHECK INPUT FOR NEGATIVE VALUES,   **
C               **     INSUFFICIENT SAMPLE SIZE           **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLBB')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IDIST='BETA BINOMIAL'
C
      NPERC=0
      MAXGRP=MAXNXT
      NMIN=3
      IF(NVAR.EQ.1)THEN
        DO1105I=1,N
          ITEMP=INT(Y(I)+0.5)
          Y(I)=REAL(ITEMP)
 1105   CONTINUE
        CALL CKDIST(Y,N,NMIN,TEMP1,NPERC,ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
        IFLAG=1
        CALL SUMRAW(Y,N,IDIST,IFLAG,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        NTOTZZ=N
      ELSE
        CALL CKDIS2(Y,X,TEMP1,N,MAXGRP,NMIN,TEMP2,NPERC,NTOTZZ,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IFLAG1=1
        IFLAG2=1
        CALL SUMGRP(Y,X,N,IDIST,IFLAG1,IFLAG2,
     1              TEMP1,TEMP2,TEMP3,MAXNXT,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ,
     1              ISUBRO,IBUGA3,IERROR)
        CALL DPRAW(X,Y,N,IWRITE,MAXNXT,TEMP4,NTOTZZ,IBUGA3,IERROR)
C
C       COPY UNBINNED DATA TO Y
C
        DO1220I=1,NTOTZZ
          Y(I)=TEMP4(I)
1220    CONTINUE
        N=NTOTZZ
      ENDIF
      IF(IERROR.EQ.'YES')GOTO9000
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLBB')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1311)
 1311   FORMAT('AFTER COMPUTE SUMMARY STATISTICS--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1312)XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ
 1312   FORMAT('XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ = ',5G15.7,I10)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
C               ***************************************************
C               **  STEP 21--                                    **
C               **  CARRY OUT CALCULATIONS                       **
C               **  FOR BETA-BINOMIAL MOMENT/MLE ESTIMATION      **
C               ***************************************************
C
 2000 CONTINUE
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLBB')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      DO4410J=1,N
        ITEMP1(J)=INT(Y(J)+0.5)
        ITEMP2(J)=NTRIAL
        DTEMP1(J)=0.0D0
        DTEMP2(J)=0.0D0
 4410 CONTINUE
C
      DO4430I=1,N
        IF(ITEMP1(I).GT.ITEMP2(I))THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          IF(ICASAN.EQ.'BBML')THEN
            WRITE(ICOUT,4421)
 4421       FORMAT('***** ERROR: BETA-BINOMIAL MAXIMUM LIKEHOOD ',
     1             'ESTIMATION--')
          ELSE
            WRITE(ICOUT,4422)
 4422       FORMAT('***** ERROR: POLYA MAXIMUM LIKEHOOD ESTIMATION--')
          ENDIF
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,4423)I,ITEMP1(I)
 4423     FORMAT('        FOR ROW ',I8,', THE NUMBER OF SUCCESSES (',
     1           I8,') IS')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,4425)ITEMP2(I)
 4425     FORMAT('        GREATER THAN THE NUMBER OF TRIALS (',I8,')')
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ELSEIF(ITEMP2(I).LE.0)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          IF(ICASAN.EQ.'BBML')THEN
            WRITE(ICOUT,4421)
          ELSE
            WRITE(ICOUT,4422)
          ENDIF
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,4438)I,ITEMP1(I)
 4438     FORMAT('        FOR ROW ',I8,', THE NUMBER OF TRIALS IS ',
     1           'NON-POSITIVE.')
          CALL DPWRST('XXX','BUG ')
        ENDIF
 4430 CONTINUE
C
      MRL=MAXNXT
      ITER=1000
      CCRIT=1.0D-4
      DMEW=0.0D0
      DTHETA=0.0D0
      SEM=0.0D0
      SETH=0.0D0
      RNL=0.0D0
      IFAULT=0
C
      CALL BBNML(NS1,ITEMP1,ITEMP2,DTEMP1,DTEMP2,ITEMP3,MRL,
     1          ITER,CCRIT,DMEW,DTHETA,SEM,SETH,RNL,IFAULT)
      IF(ICASAN.EQ.'PZML')THEN
        ALPHA=DMEW/DTHETA
        BETA=(1.0D0 - DMEW)/DTHETA
      ELSE
        BETA=DMEW/DTHETA
        ALPHA=(1.0D0 - DMEW)/DTHETA
      ENDIF
      AMUML=REAL(DMEW)
C
      IF(IFAULT.GE.1)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        IF(ICASAN.EQ.'BBML')THEN
          WRITE(ICOUT,4421)
        ELSE
          WRITE(ICOUT,4422)
        ENDIF
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      IF(IFAULT.EQ.1)THEN
        WRITE(ICOUT,1113)
 1113   FORMAT('        THE NUMBER OF OBSERVATIONS IS <= 1.')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ELSEIF(IFAULT.EQ.2)THEN
        WRITE(ICOUT,1123)
 1123   FORMAT(
     1'      THE NUMBER OF SUCCESSES IS ZERO FOR ALL OBSERVATIONS.')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ELSEIF(IFAULT.EQ.3)THEN
        WRITE(ICOUT,1133)
 1133   FORMAT('        THE NUMBER OF SUCCESSES IS EQUAL TO THE ',
     1         'NUMBER OF ')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1135)
 1135   FORMAT('        TRIALS FOR ALL OBSERVATIONS.')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ELSEIF(IFAULT.EQ.4)THEN
        WRITE(ICOUT,1143)MAXNXT
 1143   FORMAT('        THE NUMBER OF SUCCESSES IS GREATER THAN ',I8)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ELSEIF(IFAULT.EQ.5)THEN
        IERROR='YES'
        GOTO9000
      ELSEIF(IFAULT.EQ.6 .OR. IFAULT.EQ.8)THEN
        WRITE(ICOUT,1163)MAXNXT
 1163   FORMAT('        NUMERICAL DIFFICULTIES ENCOUNTERED.')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ELSEIF(IFAULT.EQ.7)THEN
        WRITE(ICOUT,1173)ITER
 1173   FORMAT('        MAXIMUM NUMBER OF ITERATIONS, ',I8,
     1         ', EXCEEDED.')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
C               ***********************************************
C               **   STEP 42--                               **
C               **   WRITE OUT EVERYTHING                    **
C               **   FOR BETA-BINOMIAL MLE ESTIMATION        **
C               ***********************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLBB')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     PRINT SUMMARY STATISTICS TABLE
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Beta Binomial Parameter Estimation'
      NCTITL=34
      ITITLZ=' '
      NCTITZ=0
C
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(NTOTZZ)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Method of Maximum Likelihood:'
      NCTEXT(ICNT)=29
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Mu:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=REAL(DMEW)
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Theta:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=REAL(DTHETA)
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Alpha:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=ALPHML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Beta:'
      NCTEXT(ICNT)=17
      AVALUE(ICNT)=BETAML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      NUMROW=ICNT
      DO2310I=1,NUMROW
        NTOT(I)=15
 2310 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLBB')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLBB--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)IERROR
 9012   FORMAT('IERROR = ',A4)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLBE(Y,N,XTEMP,DTEMP1,MAXNXT,
     1                  AUSER,BUSER,
     1                  A,B,ALPHMO,BETAMO,ALPHML,BETAML,
     1                  ALPHSE,BETASE,COVSE,
     1                  QP,XQPHAT,XQPLCL,XQPUCL,XQPSE,NPERC,
     1                  IOUNI1,IOUNI2,ALPHAP,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE METHOD OF MOMENT AND
C              MAXIMUM LIKELIHOOD ESTIMATES FOR THE 2-PARAMETER
C              BETA DISTRIBUTION
C     EXAMPLE--BETA MLE Y
C     REFERENCES--KARL BURY, "STATISTICAL DISTRIBUTIONS IN
C                 ENGINEERING", CAMBRIDGE UNIVERSITY PRESS,
C                 1999, CHAPTER 14.
C               --EVANS, HASTINGS, AND PEACOCK.  "STATISTICAL
C                 DISTRIBUTIONS", THIRD EDITION, WILEY, 2000,
C                 PP. 34-42.
C               --JOHNSON, KOTZ, AND BALAKRISHNAN.  "CONTINUOUS
C                 UNIVARIATE DISTRIBUTIONS, VOLUME II", SECOND
C                 EDITION, WILEY, 1994.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2003/11
C     ORIGINAL VERSION--NOVEMBER  2003.
C     UPDATED         --DECEMBER  2004. CONFIDENCE INTERVALS FOR
C                                       SHAPE PARAMETERS
C     UPDATED         --JULY      2005. SOME COSMETIC CHANGES TO THE
C                                       OUTPUT
C     UPDATED         --JULY      2010. USE DPDTA1, DPDTA8, DPDTA9
C                                       TO PRINT OUTPUT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION XTEMP(*)
      DOUBLE PRECISION DTEMP1(*)
C
      PARAMETER (NUMALP=6)
      DIMENSION ALPHA(NUMALP)
      DIMENSION ALO1SH(NUMALP)
      DIMENSION AUP1SH(NUMALP)
      DIMENSION ALO2SH(NUMALP)
      DIMENSION AUP2SH(NUMALP)
      DIMENSION AL1SH2(NUMALP)
      DIMENSION AU1SH2(NUMALP)
      DIMENSION AL2SH2(NUMALP)
      DIMENSION AU2SH2(NUMALP)
      DIMENSION ALOWLO(NUMALP)
      DIMENSION AUPPLO(NUMALP)
      DIMENSION ALOWSC(NUMALP)
      DIMENSION AUPPSC(NUMALP)
C
      DIMENSION QP(*)
      DIMENSION XQPHAT(*)
      DIMENSION XQPSE(*)
      DIMENSION XQPLCL(*)
      DIMENSION XQPUCL(*)
C
      DOUBLE PRECISION TOL
      DOUBLE PRECISION XPAR(2)
      DOUBLE PRECISION FVEC(2)
      DOUBLE PRECISION DAE
      DOUBLE PRECISION DRE
      DOUBLE PRECISION DXSTRT
      DOUBLE PRECISION DXLOW
      DOUBLE PRECISION DXUP
C
      DOUBLE PRECISION BETFU2
      EXTERNAL BETFU2
      DOUBLE PRECISION BETFU5
      EXTERNAL BETFU5
      REAL     BETFU7
      EXTERNAL BETFU7
      REAL     BETFU8
      EXTERNAL BETFU8
C
      DOUBLE PRECISION DLBETA
      EXTERNAL DLBETA
C
      DOUBLE PRECISION DANS(10)
      DOUBLE PRECISION DA
      DOUBLE PRECISION DB
      DOUBLE PRECISION DC
      DOUBLE PRECISION DALPHA
      DOUBLE PRECISION DBETA
      DOUBLE PRECISION DALPBE
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM2
      DOUBLE PRECISION DTERM3
      DOUBLE PRECISION DTERM4
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=50)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(NUMALP)
      CHARACTER*4  VALIGN(NUMALP)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C
      CHARACTER*4 ILIKFL
      CHARACTER*4 ILOCFL
      CHARACTER*4 ISCAFL
      CHARACTER*8 ISHAP1
      CHARACTER*8 ISHAP2
C
C---------------------------------------------------------------------
C
      COMMON /BETMLE/ BETALL, BETAUL
C
      INTEGER N2
      DOUBLE PRECISION DSUM3
      DOUBLE PRECISION DSUM4
      DOUBLE PRECISION DLLAB
      DOUBLE PRECISION DK
      COMMON/BETCO9/DSUM3,DSUM4,DLLAB,DK,N2
C
      DOUBLE PRECISION DBETA2
      COMMON/BETCO2/DBETA2
C
      DOUBLE PRECISION DALPH2
      COMMON/BETCO5/DALPH2
C
      DOUBLE PRECISION DBETA3
      COMMON/BETCO3/DBETA3
C
      DOUBLE PRECISION DALPH3
      COMMON/BETCO4/DALPH3
C
      COMMON/BETCO7/P7,BETA3
      COMMON/BETCO8/P8,ALPHA3
C
      DOUBLE PRECISION DN
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA ALPHA /0.50, 0.25, 0.10, 0.05, 0.01, 0.001/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='BE  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLBE')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLBE--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N,AUSER,BUSER
   52   FORMAT('IBUGA3,ISUBRO,N,AUSER,BUSER = ',A4,2X,A4,2X,I8,2G15.7)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,E15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NMIN=3
      CALL CKDIST(Y,N,NMIN,QP,NPERC,ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C               *************************************
C               **  STEP 31--                      **
C               **  CARRY OUT CALCULATIONS         **
C               **  FOR BETA MOMENT/MLE ESTIMATION **
C               *************************************
C
 3100 CONTINUE
C
      ISTEPN='41'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLBE')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IERROR='NO'
      IWRITE='OFF'
C
      CALL BETML1(Y,N,DTEMP1,MAXNXT,AUSER,BUSER,
     1            XMIN,XMAX,XMEAN,XSD,XVAR,
     1            A,B,
     1            ALPHMO,BETAMO,
     1            ALPHML,BETAML,
     1            ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      NP=2
      CALL BETLI1(Y,N,NP,
     1            A,B,ALPHMO,BETAMO,
     1            ALIKMO,AICMO,AICCMO,BICMO,
     1            ISUBRO,IBUGA3,IERROR)
C
      CALL BETLI1(Y,N,NP,
     1            A,B,ALPHML,BETAML,
     1            ALIKML,AICML,AICCML,BICML,
     1            ISUBRO,IBUGA3,IERROR)
C
C     CONFIDENCE INTERVALS FOR SHAPE PARAMETERS
C
      DN=DBLE(N)
      DALPHA=DBLE(ALPHML)
      DBETA=DBLE(BETAML)
      DALPBE=DBLE(ALPHML + BETAML)
C
      KODE=1
      NTEMP=1
      M=1
      NZ=0
C
      CALL DPSIFN(DALPHA,NTEMP,KODE,M,DANS,NZ,IERR)
      DA=DANS(1)
      IF(IERR.EQ.1)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1111)
 1111   FORMAT('****** ERROR IN BETA MAXIMUM LIKELIHOOD--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,3203)
 3203   FORMAT('      UNABLE TO COMPUTE TRIGAMMA FUNCTION.')
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ELSEIF(IERR.EQ.2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1111)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,3205)
 3205   FORMAT('      OVERFLOW IN COMPUTING THE TRIGAMMA FUNCTION.')
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ELSEIF(IERR.EQ.3)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1111)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,3207)
 3207   FORMAT('      OVERFLOW IN COMPUTING THE TRIGAMMA FUNCTION.')
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      CALL DPSIFN(DBETA,NTEMP,KODE,M,DANS,NZ,IERR)
      DB=DANS(1)
      IF(IERR.EQ.1)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1111)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,3203)
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ELSEIF(IERR.EQ.2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1111)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,3205)
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ELSEIF(IERR.EQ.3)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1111)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,3207)
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      CALL DPSIFN(DALPBE,NTEMP,KODE,M,DANS,NZ,IERR)
      DC=DANS(1)
      IF(IERR.EQ.1)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1111)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,3203)
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ELSEIF(IERR.EQ.2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1111)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,3205)
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ELSEIF(IERR.EQ.3)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1111)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,3207)
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      DTERM1=1.0D0/(DN*(DA*DB - DC*(DA+DB)))
      DTERM2=DTERM1*(DB-DC)
      ALPHSE=REAL(DSQRT(DTERM2))
      DTERM2=DTERM1*(DA-DC)
      BETASE=REAL(DSQRT(DTERM2))
      DTERM2=DTERM1*DC
      COVSE=REAL(DSQRT(DTERM2))
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLBE')THEN
        WRITE(ICOUT,3301)DA,DB,DC
 3301   FORMAT('DA,DB,DC = ',3G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,3302)ALPHSE,BETASE,COVSE
 3302   FORMAT('ALPHSE,BETASE,COVSE = ',3G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      DO3310I=1,NUMALP
        ALP=ALPHA(I)
        P=1.0-(ALP/2.0)
        CALL NORPPF(P,PPF)
        ALO1SH(I)=ALPHML - PPF*ALPHSE
        AUP1SH(I)=ALPHML + PPF*ALPHSE
        ALO2SH(I)=BETAML - PPF*BETASE
        AUP2SH(I)=BETAML + PPF*BETASE
C
        IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLBE')THEN
          WRITE(ICOUT,3311)I,ALO1SH(I),AUP1SH(I),ALO2SH(I),AUP2SH(I)
 3311     FORMAT('I,ALO1SH(I),AUP1SH(I),ALO2SH(I),AUP2SH(I) = ',
     1           I8,4G15.7)
          CALL DPWRST('XXX','WRIT')
        ENDIF
C
 3310 CONTINUE
C
      N2=N
      DA=DBLE(A)
      DB=DBLE(B)
      DALPH2=DBLE(ALPHML)
      DALPH3=DBLE(ALPHML)
      DBETA2=DBLE(BETAML)
      DBETA3=DBLE(BETAML)
      DSUM3=0.0D0
      DSUM4=0.0D0
      DO3320I=1,N
        DTEMP1(I)=DBLE(Y(I))
        DSUM3=DSUM3 + DLOG(DBLE(Y(I)) - DA)
        DSUM4=DSUM4 + DLOG(DB - DBLE(Y(I)))
 3320 CONTINUE
      DSUM3=DSUM3/(DN*(DB - DA))
      DSUM4=DSUM4/(DN*(DB - DA))
C
      DTERM1=-DN*DLBETA(DALPH2,DBETA2)
      DTERM2=DN*(DALPH2-1.0D0)*DSUM3
      DTERM3=DN*(DBETA2-1.0D0)*DSUM4
      DLLAB=DTERM1 + DTERM2 + DTERM3
C
      DAE=1.D-7
      DRE=1.D-7
      NUTEMP=1
C
      DO3410I=1,NUMALP
        ALP=ALPHA(I)
        CALL CHSPPF(1.0-ALP,NUTEMP,APPF)
        DK=DBLE(APPF)
C
        DXSTRT=DBLE(ALO1SH(I))
        DXLOW=DXSTRT/5.0D0
        DXUP=DBLE(ALPHML)
        CALL DFZER2(BETFU2,DXLOW,DXUP,DXSTRT,DRE,DAE,IFLAG,DTEMP1)
        AL1SH2(I)=REAL(DXLOW)
C
        DXSTRT=DBLE(AUP1SH(I))
        DXUP=DXSTRT*5.0D0
        DXLOW=DBLE(ALPHML)
        CALL DFZER2(BETFU2,DXLOW,DXUP,DXSTRT,DRE,DAE,IFLAG,DTEMP1)
        AU1SH2(I)=REAL(DXLOW)
C
        DXSTRT=DBLE(ALO2SH(I))
        DXLOW=DXSTRT/5.0D0
        DXUP=DBLE(BETAML)
        CALL DFZER2(BETFU5,DXLOW,DXUP,DXSTRT,DRE,DAE,IFLAG,DTEMP1)
        AL2SH2(I)=REAL(DXLOW)
C
        DXSTRT=DBLE(AUP2SH(I))
        DXUP=DXSTRT*5.0D0
        DXLOW=DBLE(BETAML)
        CALL DFZER2(BETFU5,DXLOW,DXUP,DXSTRT,DRE,DAE,IFLAG,DTEMP1)
        AU2SH2(I)=REAL(DXLOW)
C
 3410 CONTINUE
C
C  CONFIDENCE INTERVALS FOR SELECTED PERCENTILES.
C
C  1. STANDARD ERROR USES TECHNIQUE DEMONSTRATED IN EXAMPLE 14.3
C     (PP. 256-257) OF BURY.  THIS IS BASED ON PROPOGATION OF ERROR.
C 
C  2. CONFIDENCE INTERVAL IS THEN GENERATED USING NORMAL
C     APPROXIMATION (EXAMPLE 14.3 OF BURY).
C
      IF(NPERC.GE.1)THEN
C
        ALPHL=ALPHAP/2.0
        ALPHU=1.0 - ALPHAP/2.0
        CALL NORPPF(ALPHU,Z95)
C
        ALPHA3=ALPHML
        BETA3=BETAML
        IORD=1
        EPS=0.001
        ACCUR=0.0
C
        WRITE(IOUNI1,3531)
        WRITE(IOUNI1,3532)
        DO3529I=1,NPERC
          QPTEMP=QP(I)/100.0
          CALL BETPPF(QPTEMP,ALPHML,BETAML,APPF)
          XQPHAT(I)=APPF
C
          P7=QPTEMP
          P8=QPTEMP
C
          IFAIL=0
C
          ALPHAT = ALPHML
          ALPHMN = 0.0001
          ALPHMX = ALPHML + 10.0
          CALL DIFF(IORD,ALPHAT,ALPHMN,ALPHMX,BETFU7,EPS,ACCUR,
     1              D1,ERROR,IFAIL)
C
          IF(IFAIL.EQ.1)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3501)
 3501       FORMAT('***** WARNING IN NUMERICAL DERIVATIVE FOR BETA ',
     1             'MAXIMUM LIKELIHOOD PERCENTILES.')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3503)
 3503       FORMAT('      THE ESTIMATED ERROR IN THE RESULT ',
     1             'EXCEEDS THE')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3505)
 3505       FORMAT('      REQUESTED ERROR, BUT THE MOST ACCURATE ',
     1             'RESULT')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3507)
 3507       FORMAT('      POSSIBLE HAS BEEN RETURNED.')
            CALL DPWRST('XXX','BUG ')
          ELSEIF(IFAIL.EQ.2)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3511)
 3511       FORMAT('***** ERROR IN NUMERICAL DERIVATIVE FOR BETA ',
     1             'MAXIMUM LIKELIHOOD PERCENTILES.')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3513)
 3513       FORMAT('      ERROR IN THE INPUT TO THE DIFF ROUTINE.')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3515)
 3515       FORMAT('      NO PERCENTILES WILL BE GENERATED.')
            CALL DPWRST('XXX','BUG ')
            NPERC=0
          ELSEIF(IFAIL.EQ.3)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3511)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3523)
 3523       FORMAT('      THE INTERVAL FOR DIFFERENTIATION, (',G15.7,
     1             ',',G15.7,')')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3525)
 3525       FORMAT('      IS TOO SMALL.')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3515)
            CALL DPWRST('XXX','BUG ')
            D1=0.0
            NPERC=0
          ENDIF
C
          BETAT = BETAML
          BETAMN = 0.0001
          BETAMX = BETAML + 10.0
          CALL DIFF(IORD,BETAT,BETAMN,BETAMX,BETFU8,EPS,ACCUR,
     1              D2,ERROR,IFAIL)
C
          IF(IFAIL.EQ.1)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3501)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3503)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3505)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3507)
            CALL DPWRST('XXX','BUG ')
          ELSEIF(IFAIL.EQ.2)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3511)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3513)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3515)
            CALL DPWRST('XXX','BUG ')
            NPERC=0
          ELSEIF(IFAIL.EQ.3)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3511)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3523)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3525)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3515)
            CALL DPWRST('XXX','BUG ')
            D2=0.0
            NPERC=0
          ENDIF
          V11=ALPHSE**2
          V22=BETASE**2
          V21=COVSE
          V12=V21
          TERM11=(D1*ALPHSE)**2
          TERM22=(D2*BETASE)**2
          TERM12=2.0*D2*D1*COVSE**2
          SEXQP=TERM11+TERM12+TERM22
          IF(SEXQP.GE.0.0)THEN
            SEXQP=SQRT(SEXQP)
          ELSE
            SEXQP=0.0
          ENDIF
          XQPSE(I)=SEXQP
          XQPLCL(I)=XQPHAT(I) - Z95*SEXQP
          XQPUCL(I)=XQPHAT(I) + Z95*SEXQP
          WRITE(IOUNI1,'(5E15.7)')
     1         QP(I),XQPHAT(I),XQPSE(I),XQPLCL(I),XQPUCL(I)
 3529   CONTINUE
 3531   FORMAT(15X,'       POINT     ','   STANDARD   ',
     1         '     LOWER     ',
     1         '     UPPER')
 3532   FORMAT('    PERCENTILE ','     ESTIMATE   ',
     1         '     ERRROR     ',
     1         'CONFIDENCE LIMIT ','CONFIDENCE LIMIT')
      ENDIF
C               *********************************
C               **   STEP 42--                 **
C               **   WRITE OUT EVERYTHING      **
C               **   FOR BETA MLE ESTIMATION   **
C               **********************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     PRINT SUMMARY STATISTICS TABLE
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Two-Parameter Beta Parameter Estimation:'
      NCTITL=40
      ITITLZ='Full Sample Case'
      NCTITZ=16
      ITEXT(1)='Summary Statistics:'
      NCTEXT(1)=19
      AVALUE(1)=0.0
      IDIGIT(1)=0
      ITEXT(2)='Number of Observations:'
      NCTEXT(2)=23
      AVALUE(2)=REAL(N)
      IDIGIT(2)=0
      ITEXT(3)='Sample Mean:'
      NCTEXT(3)=12
      AVALUE(3)=XMEAN
      IDIGIT(3)=NUMDIG
      ITEXT(4)='Sample Standard Deviation:'
      NCTEXT(4)=26
      AVALUE(4)=XSD
      IDIGIT(4)=NUMDIG
      ITEXT(5)='Sample Minimum:'
      NCTEXT(5)=15
      AVALUE(5)=XMIN
      IDIGIT(5)=NUMDIG
      ITEXT(6)='Sample Maximum:'
      NCTEXT(6)=15
      AVALUE(6)=XMAX
      IDIGIT(6)=NUMDIG
      ICNT=6
      IF(AUSER.NE.CPUMIN)THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='User Specified Lower Limit:'
        NCTEXT(ICNT)=27
        AVALUE(ICNT)=AUSER
        IDIGIT(ICNT)=NUMDIG
      ENDIF
      IF(BUSER.NE.CPUMIN)THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='User Specified Upper Limit:'
        NCTEXT(ICNT)=27
        AVALUE(ICNT)=BUSER
        IDIGIT(ICNT)=NUMDIG
      ENDIF
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Moments:'
      NCTEXT(ICNT)=8
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Alpha:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=ALPHMO
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Beta:'
      NCTEXT(ICNT)=17
      AVALUE(ICNT)=BETAMO
      IDIGIT(ICNT)=NUMDIG
C
      IF(ALIKMO.NE.CPUMIN)THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='Log-likelihood:'
        NCTEXT(ICNT)=15
        AVALUE(ICNT)=ALIKMO
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='AIC:'
        NCTEXT(ICNT)=4
        AVALUE(ICNT)=AICMO
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='AICc:'
        NCTEXT(ICNT)=5
        AVALUE(ICNT)=AICCMO
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='BIC:'
        NCTEXT(ICNT)=4
        AVALUE(ICNT)=BICMO
        IDIGIT(ICNT)=-7
      ENDIF
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Maximum Likelihood:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Alpha:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=ALPHML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Standard Error of Alpha:'
      NCTEXT(ICNT)=24
      AVALUE(ICNT)=ALPHSE
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Beta:'
      NCTEXT(ICNT)=17
      AVALUE(ICNT)=BETAML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Standard Error of Beta:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=BETASE
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Covariance:'
      NCTEXT(ICNT)=11
      AVALUE(ICNT)=COVSE
      IDIGIT(ICNT)=NUMDIG
      IF(ALIKML.NE.CPUMIN)THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='Log-likelihood:'
        NCTEXT(ICNT)=15
        AVALUE(ICNT)=ALIKML
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='AIC:'
        NCTEXT(ICNT)=4
        AVALUE(ICNT)=AICML
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='AICc:'
        NCTEXT(ICNT)=5
        AVALUE(ICNT)=AICCML
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='BIC:'
        NCTEXT(ICNT)=4
        AVALUE(ICNT)=BICML
        IDIGIT(ICNT)=-7
      ENDIF
C
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      NUMROW=ICNT
      DO2320I=1,NUMROW
        NTOT(I)=15
 2320 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
      ILIKFL='ON'
      ILOCFL='OFF'
      ISCAFL='OFF'
      ISHAP1='Alpha'
      NCSHA1=5
      ISHAP2='Beta'
      NCSHA2=4
      CALL DPDT8A(ALOWLO,AUPPLO,ALOWSC,AUPPSC,
     1            ALO1SH,AUP1SH,AL1SH2,AU1SH2,
     1            ALO2SH,AUP2SH,AL2SH2,AU2SH2,
     1            ALPHA,NUMALP,
     1            ICAPSW,ICAPTY,NUMDIG,
     1            ILOCFL,ISCAFL,ILIKFL,
     1            ISHAP1,NCSHA1,ISHAP2,NCSHA2,
     1            ISUBRO,IBUGA3,IERROR)
C
      IF(NPERC.GT.1)THEN
        ILIKFL='OFF'
        CALL DPDTA9(QP,XQPHAT,XQPLCL,XQPUCL,XQPSE,NPERC,
     1              ICAPSW,ICAPTY,ILIKFL,NUMDIG,ALPHAP,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'OFF'.AND.ISUBRO.NE.'MLBE')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPMLBE--')
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012 FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,9015)N
 9015 FORMAT('N = ',I8)
      CALL DPWRST('XXX','WRIT')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPMLB4(Y,N,
     1                  XTEMP,DTEMP1,MAXNXT,
     1                  AMOM,BMOM,ALPHMO,BETAMO,
     1                  AML,BML,ALPHML,BETAML,ICONF,
     1                  QP,XQPHAT,XQPLCL,XQPUCL,XQPSE,NPERC,
     1                  IOUNI1,IOUNI2,ALPHAP,
     1                  ICAPSW,ICAPTY,IFORSW,MLFLAG,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE METHOD OF MOMENT AND
C              MAXIMUM LIKELIHOOD ESTIMATES FOR THE FOUR-PARAMETER
C              BETA DISTRIBUTION
C     EXAMPLE--BETA FOUR PARAMETER MLE Y
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN
C                ENGINEERING", CAMBRIDGE UNIVERSITY PRESS,
C                1999, CHAPTER 14.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2007/6
C     ORIGINAL VERSION--JUNE      2007.
C     UPDATED         --JULY      2010. USE DPDTA1 TO PRINT OUTPUT
C     UPDATED         --JULY      2010. EXTRACT POINT ESTIMATES TO
C                                       BETML4
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION XTEMP(*)
      DOUBLE PRECISION DTEMP1(*)
C
      PARAMETER (NUMALP=6)
      DIMENSION ALPHA(NUMALP)
      DIMENSION ALOWAL(NUMALP)
      DIMENSION AUPPAL(NUMALP)
      DIMENSION ALOWBE(NUMALP)
      DIMENSION AUPPBE(NUMALP)
      DIMENSION ALOWA2(NUMALP)
      DIMENSION AUPPA2(NUMALP)
      DIMENSION ALOWB2(NUMALP)
      DIMENSION AUPPB2(NUMALP)
C
      DIMENSION QP(*)
      DIMENSION XQPHAT(*)
      DIMENSION XQPSE(*)
      DIMENSION XQPLCL(*)
      DIMENSION XQPUCL(*)
C
      DOUBLE PRECISION TOL
      DOUBLE PRECISION XPAR(2)
      DOUBLE PRECISION FVEC(2)
      DOUBLE PRECISION DAE
      DOUBLE PRECISION DRE
      DOUBLE PRECISION DXSTRT
      DOUBLE PRECISION DXLOW
      DOUBLE PRECISION DXUP
C
      DOUBLE PRECISION BE4FUN
      EXTERNAL BE4FUN
      DOUBLE PRECISION BE4FU2
      EXTERNAL BE4FU2
C
      DOUBLE PRECISION DANS(10)
      DOUBLE PRECISION DA
      DOUBLE PRECISION DB
      DOUBLE PRECISION DC
      DOUBLE PRECISION DALPHA
      DOUBLE PRECISION DBETA
      DOUBLE PRECISION DALPBE
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM2
      DOUBLE PRECISION DTERM3
      DOUBLE PRECISION DTERM4
      DOUBLE PRECISION DTERM5
      DOUBLE PRECISION DTERM6
      DOUBLE PRECISION DTERM7
      DOUBLE PRECISION DTERM8
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DSUM2
      DOUBLE PRECISION DSUM3
      DOUBLE PRECISION DSUM4
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DM1
      DOUBLE PRECISION DM2
      DOUBLE PRECISION DM3
      DOUBLE PRECISION DM4
C
      DOUBLE PRECISION DM1P
      DOUBLE PRECISION DM2P
      DOUBLE PRECISION DM3P
      DOUBLE PRECISION DM4P
      COMMON /BET4ML/ DM2P, DM3P, DM4P
C
      DOUBLE PRECISION SIGMA
      DOUBLE PRECISION S5
      DOUBLE PRECISION S6
      DOUBLE PRECISION S7
      DOUBLE PRECISION S8
      DOUBLE PRECISION DXMIN
      DOUBLE PRECISION DXMAX
      COMMON /BET4M2/ S5, S6, S7, S8, SIGMA, DXMIN, DXMAX
C
      DOUBLE PRECISION DN
C
      PARAMETER (MAXROW=20)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*50 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(MAXROW)
      CHARACTER*4  VALIGN(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA ALPHA /0.50, 0.25, 0.10, 0.05, 0.01, 0.001/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='B4  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLB4')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLB4--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N
   52   FORMAT('IBUGA3,ISUBRO,N = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLB4')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NMIN=5
      CALL CKDIST(Y,N,NMIN,QP,NPERC,ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C               *************************************
C               **  STEP 31--                      **
C               **  CARRY OUT CALCULATIONS         **
C               **  FOR BETA MOMENT/MLE ESTIMATION **
C               *************************************
C
 3100 CONTINUE
C
      ISTEPN='31'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLB4')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IERROR='NO'
      IWRITE='OFF'
C
      CALL BETML4(Y,N,DTEMP1,MAXNXT,
     1            XMIN,XMAX,XMEAN,XSD,XVAR,
     1            AMOM,BMOM,ALPHMO,BETAMO,
     1            AML,BML,ALPHML,BETAML,MLFLAG,
     1            ISUBRO,IBUGA3,IERROR)
C
      NP=4
      CALL BETLI1(Y,N,NP,
     1            AMOM,BMOM,ALPHMO,BETAMO,
     1            ALIKMO,AICMO,AICCMO,BICMO,
     1            ISUBRO,IBUGA3,IERROR)
C
      IF(MLFLAG.EQ.0)THEN
        CALL BETLI1(Y,N,NP,
     1              AML,BML,ALPHML,BETAML,
     1              ALIKML,AICML,AICCML,BICML,
     1              ISUBRO,IBUGA3,IERROR)
      ELSE
        ALIKML=CPUMIN
        AICML=CPUMIN
        AICCML=CPUMIN
        BICML=CPUMIN
      ENDIF
C
C               *********************************
C               **   STEP 42--                 **
C               **   WRITE OUT EVERYTHING      **
C               **   FOR BETA MLE ESTIMATION   **
C               **********************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLB4')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='4-Parameter Beta Parameter Estimation:'
      NCTITL=38
      ITITLZ='Full Sample Case'
      NCTITZ=16
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(N)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Method of Moments:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Lower Limit:'
      NCTEXT(ICNT)=24
      AVALUE(ICNT)=AMOM
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Upper Limit:'
      NCTEXT(ICNT)=24
      AVALUE(ICNT)=BMOM
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Shape Parameter Alpha:'
      NCTEXT(ICNT)=34
      AVALUE(ICNT)=ALPHMO
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Shape Parameter Beta:'
      NCTEXT(ICNT)=33
      AVALUE(ICNT)=BETAMO
      IDIGIT(ICNT)=NUMDIG
C
      IF(ALIKMO.NE.CPUMIN)THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='Log-likelihood:'
        NCTEXT(ICNT)=15
        AVALUE(ICNT)=ALIKMO
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='AIC:'
        NCTEXT(ICNT)=4
        AVALUE(ICNT)=AICMO
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='AICc:'
        NCTEXT(ICNT)=5
        AVALUE(ICNT)=AICCMO
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='BIC:'
        NCTEXT(ICNT)=4
        AVALUE(ICNT)=BICMO
        IDIGIT(ICNT)=-7
      ENDIF
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      IF(MLFLAG.EQ.0)THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='Maximum Likelihood:'
        NCTEXT(ICNT)=19
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of Lower Limit:'
        NCTEXT(ICNT)=24
        AVALUE(ICNT)=AML
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of Upper Limit:'
        NCTEXT(ICNT)=24
        AVALUE(ICNT)=BML
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of Shape Parameter Alpha:'
        NCTEXT(ICNT)=34
        AVALUE(ICNT)=ALPHML
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of Shape Parameter Beta:'
        NCTEXT(ICNT)=33
        AVALUE(ICNT)=BETAML
        IDIGIT(ICNT)=NUMDIG
C
        IF(ALIKML.NE.CPUMIN)THEN
          ICNT=ICNT+1
          ITEXT(ICNT)='Log-likelihood:'
          NCTEXT(ICNT)=15
          AVALUE(ICNT)=ALIKML
          IDIGIT(ICNT)=-7
          ICNT=ICNT+1
          ITEXT(ICNT)='AIC:'
          NCTEXT(ICNT)=4
          AVALUE(ICNT)=AICML
          IDIGIT(ICNT)=-7
          ICNT=ICNT+1
          ITEXT(ICNT)='AICc:'
          NCTEXT(ICNT)=5
          AVALUE(ICNT)=AICCML
          IDIGIT(ICNT)=-7
          ICNT=ICNT+1
          ITEXT(ICNT)='BIC:'
          NCTEXT(ICNT)=4
          AVALUE(ICNT)=BICML
          IDIGIT(ICNT)=-7
        ENDIF
        ICNT=ICNT+1
        ITEXT(ICNT)=' '
        NCTEXT(ICNT)=0
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
C
      ELSE
        ICNT=ICNT+1
        ITEXT(ICNT)='Unable to Compute Maximum Likelihood Estimates'
        NCTEXT(ICNT)=47
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
      ENDIF
C
      NUMROW=ICNT
      DO2320I=1,NUMROW
        NTOT(I)=15
 2320 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'OFF'.AND.ISUBRO.NE.'MLB4')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPMLB4--')
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012 FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,9015)N
 9015 FORMAT('N = ',I8)
      CALL DPWRST('XXX','WRIT')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPMLBF(Y,N,
     1                  XTEMP,DTEMP,ITEMP,MAXNXT,
     1                  ALPHSV,BETASV,RSV,
     1                  ALPHML,BETAML,RML,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR THE BRITTLE FRACTURE DISTRIBUTION
C              FOR THE FULL SAMPLE CASE.
C     NOTE--THE MAXIMIUM LIKELIHOOD ESTIMATES FOR BETA AND R ARE
C           THE SOLUTION TO THE FOLLOWING EQUATIONS:
C
C           0 = (ANUM/ADEN) + SUM[i=1 to N][1/(r*X(i)**2 + BETA) -
C               SUM[i=1 to N][X(i)**2]
C
C               ANUM = N*SUM[i=1 TO N][X(i)**2**(2*R-2)*
C                      EXP(-BETA/X(i)**2)
C               ADEN = SUM[i=1 TO N][X(i)**(2*R)*EXP(-BETA/X(i)**2)]
C
C           0 = 2*SUM[i=1 TO N][LOG(X(i))] +
C               SUM[i=1 TO N][1/(R + BETA/X(i)**2)] - (ANUM/ADEN)
C
C               ANUM = 2*SUM[i=1 TO N][LOG(X(i))*X(i)**(2*R)*
C                      EXP(-BETA/X(i)**2)]
C               ADEN = SUM[i=1 TO N][X(i)**(2*R)*EXP(-BETA/X(i)**2)]
C
C           ONCE WE HAVE SOLVED FOR BETA AND R, THE ESTIMATE OF
C           ALPHA IS THEN
C
C           ALPHAHAT = N/{SUM[i=1 TO N][X(i)**(2*R)*
C                      EXP(-BETA/X(i)**2)]
C
C     EXAMPLE--BRITTLE FRACTURE MAXIMUM LIKELIHOOD Y
C     REFERENCES--BLACK, DURHAM, AND PADGETT (1990), "PARAMETER
C                 ESTIMATION FOR A NEW DISTRIBUTION FOR THE STRENGTH
C                 OF BRITTLE FIBERS: A SIMULATION STUDY",
C                 COMMUNICATIONS IN STATISTICS--SIMULATION AND
C                 COMPUTATION, VOL. 19, PP. 809-825
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2008/2
C     ORIGINAL VERSION--FEBRUARY  2008.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*40 IDIST
      PARAMETER (MAXROW=30)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 ITEXT(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION XTEMP(*)
      DOUBLE PRECISION DTEMP(*)
      INTEGER ITEMP(*)
C
      EXTERNAL BFRFUN
C
      DOUBLE PRECISION DSUM
      DOUBLE PRECISION DX
      DOUBLE PRECISION DN
      DOUBLE PRECISION DALPHA
      DOUBLE PRECISION DBETA
      DOUBLE PRECISION DR
C
      DOUBLE PRECISION TOL
      DOUBLE PRECISION XPAR(2)
      DOUBLE PRECISION FVEC(2)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='BF  '
C
      IERROR='NO'
      IWRITE='OFF'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLBF')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLBF--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3
   52   FORMAT('IBUGA3 = ',A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)N,ALPHSV,BETASV,RSV
   55   FORMAT('N,ALPHSV,BETASV,RSV = ',I8,3G15.7)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLBF')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NMIN=5
      NPERC=0
      CALL CKDIST(Y,N,NMIN,XTEMP,NPERC,ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IDIST='BRITTLE FRACTURE'
      IFLAG=1
      CALL SUMRAW(Y,N,IDIST,IFLAG,
     1            XMEAN,XVAR,XSD,XMIN,XMAX,
     1            ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C               *************************************
C               **  STEP 21--                      **
C               **  CARRY OUT CALCULATIONS         **
C               **  FOR BRITTLE FRACTURE MLE       **
C               **  ESTIMATE (FULL SAMPLE CASE)    **
C               *************************************
C
 2100 CONTINUE
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLBF')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(BETASV.GT.0.0)THEN
        XPAR(1)=DBLE(BETASV)
      ELSE
        XPAR(1)=1.0D0
      ENDIF
      IF(RSV.GT.0.0)THEN
        XPAR(2)=DBLE(RSV)
      ELSE
        XPAR(2)=1.0D0
      ENDIF
C
      DN=DBLE(N)
C
C               *************************************
C               **  STEP 22--                      **
C               **  COMPUTE THE MAXIMUM            **
C               **  LIKELIHOOD ESTIMATES.          **
C               *************************************
C
C
      IOPT=2
      TOL=1.0D-6
      NVAR=2
      NPRINT=-1
      INFO=0
      LWA=MAXNXT
      CALL DNSQE(BFRFUN,JAC,IOPT,NVAR,XPAR,FVEC,TOL,NPRINT,INFO,
     1           DTEMP,MAXNXT,Y,N)
C
      DBETA=XPAR(1)
      DR=XPAR(2)
      DSUM=0.0D0
      DO2210I=1,N
        DX=DBLE(Y(I))
        DSUM=DSUM + DX**(2.0D0*DR)*DEXP(-DBETA/DX**2)
 2210 CONTINUE
      ALPHML=REAL(DN/DSUM)
      BETAML=REAL(XPAR(1))
      RML=REAL(XPAR(2))
C
C               **********************************************
C               **   STEP 42--                              **
C               **   WRITE OUT EVERYTHING                   **
C               **   FOR BRITTLE FRACTURE MLE ESTIMATE      **
C               **********************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLBF')
     1  CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     PRINT SUMMARY STATISTICS TABLE
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Brittle Fracture Parameter Estimation: Full Sample Case'
      NCTITL=55
      ITITLZ=' '
      NCTITZ=0
C
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(N)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Maximum Likelihood Method:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Alpha:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=ALPHML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Beta:'
      NCTEXT(ICNT)=17
      AVALUE(ICNT)=BETAML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of R:'
      NCTEXT(ICNT)=14
      AVALUE(ICNT)=RML
      IDIGIT(ICNT)=NUMDIG
C
      NUMROW=ICNT
      DO2310I=1,NUMROW
        NTOT(I)=15
 2310 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLBF')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLBF--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)IERROR
 9012   FORMAT('IERROR = ',A4)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLBG(Y,X,N,NVAR,
     1                  TEMP1,TEMP2,TEMP3,TEMP4,TEMP5,
     1                  DTEMP1,MAXNXT,
     1                  THETML,PIML,ALPHML,BETAML,
     1                  THETFR,PIFR,ALPHFR,BETAFR,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  IBGEDF,IOUNI1,IOUNI2,ISEED,ALPHAP,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR THE BETA-GEOMETRIC DISTRIBUTION
C     EXAMPLE--BETA-GEOMETRIC MAXIMUM LIKELIHOOD Y
C     REFERENCE--SUDHIR R. PAUL (2004).  "APPLICATIONS OF THE
C                BETA DISTRIBUTION" in "HANDBOOK OF THE BETA
C                DISTRIBUTION", EDITED BY GUPTA AND NADARAJAH,
C                MARCEL-DEKKER, PP.431-436.
C              --J. O. Irwin (1963), "Mathematcs in Medical and
C                Biological Statistics", Journal of the Royal
C                Statistical Society, A, pp. 1-44.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2006/5
C     ORIGINAL VERSION--MAY       2006.
C     UPDATED         --JUNE      2006. ADD FIRST FREQUENCY AND
C                                       SAMPLE MEAN ESTIMATE
C     UPDATED         --JUNE      2006. SUPPORT FOR GROUPED DATA
C     UPDATED         --APRIL     2011. USE DPDTA1 TO PRINT THE
C                                       OUTPUT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 IBGEDF
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ICASPL
      CHARACTER*4 IRELAT
      CHARACTER*4 IRHSTG
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*1 IBASLC
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION TEMP1(*)
      DIMENSION TEMP2(*)
      DIMENSION TEMP3(*)
      DIMENSION TEMP4(*)
      DIMENSION TEMP5(*)
      DOUBLE PRECISION DTEMP1(*)
C
      PARAMETER (NUMALP=6)
      DIMENSION ALPHA(NUMALP)
      DIMENSION ALOWSC(NUMALP)
      DIMENSION AUPPSC(NUMALP)
      DIMENSION ALOWGA(NUMALP)
      DIMENSION AUPPGA(NUMALP)
C
      DOUBLE PRECISION TOL
      DOUBLE PRECISION XPAR(2)
      DOUBLE PRECISION FVEC(2)
      DOUBLE PRECISION G
      DOUBLE PRECISION T3
      DOUBLE PRECISION DT1
      DOUBLE PRECISION DT2
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DG
      DOUBLE PRECISION DS
      DOUBLE PRECISION DQP
C
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DSUM2
      DOUBLE PRECISION DSUM3
      DOUBLE PRECISION DSUM4
      DOUBLE PRECISION DTERM2
      DOUBLE PRECISION DTERM3
      DOUBLE PRECISION DNUM
      DOUBLE PRECISION DN
      DOUBLE PRECISION D11
      DOUBLE PRECISION D22
      DOUBLE PRECISION D12
C
      EXTERNAL BGEFUN
C
      PARAMETER (MAXROW=30)
      CHARACTER*60 ITITLE
      CHARACTER*1  ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 IDIST
      CHARACTER*40 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(MAXROW)
      CHARACTER*4  VALIGN(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL      IFRST
      LOGICAL      ILAST
C
      PARAMETER(NUMCLI=5)
      PARAMETER(MAXLIN=3)
      CHARACTER*60 ITITL2(MAXLIN,NUMCLI)
      INTEGER      NCTIT2(MAXLIN,NUMCLI)
      INTEGER      IWHTML(NUMCLI)
      INTEGER      IWRTF(NUMCLI)
      REAL         AMAT(NUMALP,NUMCLI)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA ALPHA /0.50, 0.25, 0.10, 0.05, 0.01, 0.001/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='BG  '
C
      IERROR='NO'
      IWRITE='OFF'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLBG')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLBG--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,IBGEDF,N,NVAR
   52   FORMAT('IBUGA3,ISUBRO,IBGEDF,N,NVAR = ',3(A4,2X),2I8)
        CALL DPWRST('XXX','WRIT')
        IF(NVAR.EQ.1)THEN
          DO56I=1,MIN(N,100)
            WRITE(ICOUT,57)I,Y(I)
   57       FORMAT('I,Y(I) = ',I8,G15.7)
            CALL DPWRST('XXX','WRIT')
   56     CONTINUE
        ELSE
          DO61I=1,N
            WRITE(ICOUT,62)I,X(I),Y(I)
   62       FORMAT('I,X(I),Y(I) = ',I8,2G15.7)
            CALL DPWRST('XXX','WRIT')
   61     CONTINUE
        ENDIF
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  1) ROUND DATA TO INTEGER VALUES       **
C               **  2) COMPUTE SUMMARY STATISTICS         **
C               **  3) CHECK INPUT FOR NEGATIVE VALUES,   **
C               **     INSUFFICIENT SAMPLE SIZE           **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLBG')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IDIST='BETA GEOMETRIC'
C
      NPERC=0
      MAXGRP=MAXNXT
      NMIN=3
      IF(NVAR.EQ.1)THEN
        DO1105I=1,N
          ITEMP=INT(Y(I)+0.5)
          Y(I)=REAL(ITEMP)
 1105   CONTINUE
        CALL CKDIST(Y,N,NMIN,TEMP1,NPERC,ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
        IFLAG=1
        CALL SUMRAW(Y,N,IDIST,IFLAG,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        NTOTZZ=N
C
C       NOW BIN THE DATA FOR USE BY THE ESTIMATION METHOD BELOW
C
        IRELAT='OFF'
        IRHSTG='OFF'
        XSTART=XMIN-0.5
        XSTOP=XMAX+0.5
        CLWID=1.0
        CALL DPBINI(Y,N,IRELAT,CLWID,XSTART,XSTOP,IRHSTG,
     1              TEMP5,X,N2,IBUGA3,IERROR)
        ICNT=0
        DO1121I=1,N2
          IF(TEMP5(I).GT.0.0)THEN
            ICNT=ICNT+1
            TEMP5(ICNT)=TEMP5(I)
            X(ICNT)=X(I)
          ENDIF
1121    CONTINUE
        N2=ICNT
      ELSE
        CALL CKDIS2(Y,X,TEMP1,N,MAXGRP,NMIN,TEMP2,NPERC,NTOTZZ,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IFLAG1=1
        IFLAG2=1
        CALL SUMGRP(Y,X,N,IDIST,IFLAG1,IFLAG2,
     1              TEMP1,TEMP2,TEMP3,MAXNXT,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ,
     1              ISUBRO,IBUGA3,IERROR)
        CALL DPRAW(X,Y,N,IWRITE,MAXNXT,TEMP4,NTOTZZ,IBUGA3,IERROR)
C
C       SAVE FREQUENCIES IN TEMP5
C
        ICNT=0
        DO1220I=1,N
          IF(Y(I).GT.0.0)THEN
            ICNT=ICNT+1
            TEMP5(ICNT)=Y(I)
            X(ICNT)=X(I)
          ENDIF
1220    CONTINUE
        N2=ICNT
C
        DO1221I=1,NTOTZZ
          Y(I)=TEMP4(I)
1221    CONTINUE
        N=NTOTZZ
      ENDIF
      IF(IERROR.EQ.'YES')GOTO9000
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLBG')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1311)
 1311   FORMAT('AFTER COMPUTE SUMMARY STATISTICS--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1312)XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ
 1312   FORMAT('XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ = ',5G15.7,I10)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
C               ***************************************************
C               **  STEP 21--                                    **
C               **  CARRY OUT CALCULATIONS                       **
C               **  FOR BETA-GEOMETRIC MOMENT/MLE ESTIMATION     **
C               ***************************************************
C
 2000 CONTINUE
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLBG')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C
C     COMPUTE THE FIRST FREQUENCY AND SAMPLE MEAN ESTIMATES
C
      P1=TEMP5(1)/REAL(NTOTZZ)
      Q1=1.0-P1
      TERM1=1.0/Q1
      TERM2=(1.0/Q1) - (1.0/XMEAN) - 1.0
      IF(TERM2.EQ.0.0)THEN
        ALPHFR=0.0
        BETAFR=0.0
        PIFR=0.0
        THETFR=0.0
      ELSE
        AHAT=TERM1/TERM2
        CHAT=1.0/TERM2
        IF(CHAT.GT.AHAT)THEN
          BETAFR=AHAT
          ALPHFR=CHAT-AHAT
        ELSE
          BETAFR=CHAT
          ALPHFR=AHAT-CHAT
        ENDIF
        PIFR=ALPHFR/(ALPHFR+BETAFR)
        THETFR=1.0/(ALPHFR+BETAFR)
      ENDIF
C
      DO2111I=1,MAXNXT
        DTEMP1(I)=0.0D0
 2111 CONTINUE
C
      IOPT=2
      TOL=1.0D-5
      NPAR=2
      NPRINT=-1
      INFO=0
      LWA=MAXNXT
      IF(PIFR.GT.0.0)THEN
        XPAR(2)=PIFR
      ELSE
        XPAR(2)=0.5D0
      ENDIF
      IF(THETFR.GT.0.0)THEN
        XPAR(1)=THETFR
      ELSE
        XPAR(1)=0.5D0
      ENDIF
      CALL DNSQE(BGEFUN,JAC,IOPT,NPAR,XPAR,FVEC,TOL,NPRINT,INFO,
     1           DTEMP1,MAXNXT,Y,N)
C
      THETML=REAL(XPAR(1))
      PIML=REAL(XPAR(2))
      ALPHML=PIML/THETML
      BETAML=(1.0-PIML)/THETML
      MLFLAG=0
      IF(INFO.EQ.0)MLFLAG=1
      IF(INFO.EQ.2)MLFLAG=1
      IF(INFO.EQ.4)MLFLAG=1
C
      IF(MLFLAG.EQ.0)THEN
C
        IF(NPERC.GE.1)THEN
C
        ENDIF
C
        DSUM1=0.0D0
        DSUM2=0.0D0
        DSUM3=0.0D0
        DSUM4=0.0D0
        DN=DBLE(N)
        DTERM1=DN/DBLE(PIML**2)
        NTERMS=5000
C
        DO2410IR=2,NTERMS
          IRTEMP=IR-1
          CALL BGECDF(REAL(IRTEMP),ALPHML,BETAML,CDF)
          DNUM=1.0D0 - DBLE(CDF)
          DTERM2=(1.0D0 - DBLE(PIML) + DBLE(IR-2)*DBLE(THETML))**2
          DTERM3=(1.0D0 + DBLE(IR-2)*DBLE(THETML))**2
          IF(IR.GE.2)THEN
            DSUM1=DSUM1 + DNUM/DTERM2
            DSUM4=DSUM4 + DBLE(IR-1)**2*DNUM/DTERM3
          ENDIF
          IF(IR.GE.3)THEN
            DSUM2=DSUM2 + DBLE(IR-2)*DNUM/DTERM2
            DSUM3=DSUM3 + DBLE(IR-2)**2*DNUM/DTERM2
          ENDIF
 2410   CONTINUE
        D11=REAL(DTERM1 + DN*DSUM1)
        D22=REAL(DN*(DSUM3 + DSUM4))
        D12=REAL(-DN*DSUM2)
        VARPI=REAL(D22/(D11*D22-D12**2))
        VARTHE=REAL(D11/(D11*D22-D12**2))
C
      ELSE
      ENDIF
C
C
C               ***********************************************
C               **   STEP 42--                               **
C               **   WRITE OUT EVERYTHING                    **
C               **   FOR BETA-GEOMETRIC MLE ESTIMATION       **
C               ***********************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLBG')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     PRINT SUMMARY STATISTICS TABLE
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Beta Geometric Parameter Estimation'
      NCTITL=35
      ITITLZ=' '
      NCTITZ=0
C
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(NTOTZZ)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample First Frequency:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=P1
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Method of First Frequency:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Theta:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=THETFR
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Pi:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=PIFR
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Alpha:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=ALPHFR
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Beta:'
      NCTEXT(ICNT)=17
      AVALUE(ICNT)=BETAFR
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Method of Maximum Likelihood:'
      NCTEXT(ICNT)=29
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Theta:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=THETML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Pi:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=PIML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Alpha:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=ALPHML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Beta:'
      NCTEXT(ICNT)=17
      AVALUE(ICNT)=BETAML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Approximate Standard Error of Theta:'
      NCTEXT(ICNT)=36
      AVALUE(ICNT)=SQRT(VARTHE)
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Approximate Standard Error of Pi:'
      NCTEXT(ICNT)=33
      AVALUE(ICNT)=SQRT(VARPI)
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      NUMROW=ICNT
      DO2310I=1,NUMROW
        NTOT(I)=15
 2310 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLBG')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLBG--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)IERROR
 9012   FORMAT('IERROR = ',A4)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLBI(Y,X,N,NTRIAL,NVAR,
     1                  TEMP1,TEMP2,TEMP3,MAXNXT,
     1                  P,PCC,PLCL,PUCL,PSD,PSDCC,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  IBINCC,PBINTH,IOUNI1,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR BINOMIAL DISTRIBUTION
C     EXAMPLE--BINOMIAL MAXIMUM LIKELIHOOD Y
C     REFERENCE--XX
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--98/5
C     ORIGINAL VERSION--MAY       1998.
C     UPDATED         --MARCH     2004. SUPPORT FOR HTML, LATEX
C     UPDATED         --MARCH     2004. CONFIDENCE INTERVAL FOR P
C     UPDATED         --MARCH     2004. SUPPORT FOR USER-SPECIFIED
C                                       VALUE FOR N (NTRIAL)
C     UPDATED         --AUGUST    2005. REFORMAT OUTPUT FOR
C                                       CONSISTENCY WITH OTHER ML
C                                       ROUTINES
C     UPDATED         --AUGUST    2005. IMPROVED CONFIDENCE INTERVALS
C                                       FOR P
C     UPDATED         --FEBRUARY  2007. FOLLOWING CHANGES:
C                                       1) ADDITIONAL ALPHA LEVELS
C                                       2) WRITE CONFIDENCE LIMTIS
C                                          TO FILE
C                                       3) OPTIONAL CONTINUITY
C                                          CORRECTION.  NOTE THAT
C                                          THIS SHOULD NOT BE APPLIED
C                                          TO AGRESTI-COUL.
C                                       4) SAVE ADDITIONAL PARAMETERS
C                                       5) SET LIMIT FOR CHOOSING
C                                          EXACT INTERVAL OR NORMAL
C                                          APPROXIMATION
C     UPDATED         --APRIL     2007. FOR EXACT LOWER BOUND, DO
C                                       NOT USE CONTINUITY CORRECTED
C                                       ESTIMATE OF P
C     UPDATED         --APRIL     2011. USE DPDTA1 AND DPDTA4 TO PRINT
C                                       OUTPUT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 IBINCC
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*4 IRELAT
      CHARACTER*4 IRHSTG
C
      REAL LCL
      REAL UCL
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION TEMP1(*)
      DIMENSION TEMP2(*)
      DIMENSION TEMP3(*)
C
      PARAMETER (NUMALP=6)
      DIMENSION ALPHA(NUMALP)
      DIMENSION ALOWAC(NUMALP)
      DIMENSION AUPPAC(NUMALP)
      DIMENSION ALOWNO(NUMALP)
      DIMENSION AUPPNO(NUMALP)
C
      REAL BINFUN
      EXTERNAL BINFUN
      COMMON/BINCOM/XSUCC,CONST,NTEMP
C
      PARAMETER (MAXROW=20)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*60 ITITL9
      CHARACTER*40 IDIST
      CHARACTER*40 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(MAXROW)
      CHARACTER*4  VALIGN(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL      IFRST
      LOGICAL      ILAST
C
      PARAMETER(NUMCLI=5)
      PARAMETER(MAXLIN=3)
      CHARACTER*60 ITITL2(MAXLIN,NUMCLI)
      INTEGER      NCTIT2(MAXLIN,NUMCLI)
      INTEGER      IWHTML(NUMCLI+1)
      INTEGER      IWRTF(NUMCLI)
      REAL         AMAT(NUMALP,NUMCLI)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
CCCCC DATA ALPHA /0.50, 0.25, 0.10, 0.05, 0.01,  0.001/
      DATA ALPHA /0.50, 0.25, 0.10, 0.05, 0.025, 0.01/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='BI  '
C
      IERROR='NO'
      IWRITE='OFF'
C
      IF(PBINTH.GE.1.0)THEN
        PTHRES=INT(PBINTH+0.5)
      ELSE
        PTHRES=30.0
      ENDIF
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLBI')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLBI--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N,NVAR,PTHRES
   52   FORMAT('IBUGA3,ISUBRO,N,NVAR,PTHRES = ',2(A4,2X),2I8,G15.7)
        CALL DPWRST('XXX','WRIT')
        IF(NVAR.EQ.1)THEN
          DO56I=1,MIN(N,100)
            WRITE(ICOUT,57)I,Y(I)
   57       FORMAT('I,Y(I) = ',I8,G15.7)
            CALL DPWRST('XXX','WRIT')
   56     CONTINUE
        ELSE
          DO61I=1,N
            WRITE(ICOUT,62)I,X(I),Y(I)
   62       FORMAT('I,X(I),Y(I) = ',I8,2G15.7)
            CALL DPWRST('XXX','WRIT')
   61     CONTINUE
        ENDIF
       ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  1) ROUND DATA TO INTEGER VALUES       **
C               **  2) COMPUTE SUMMARY STATISTICS         **
C               **  3) CHECK INPUT FOR NEGATIVE VALUES,   **
C               **     INSUFFICIENT SAMPLE SIZE           **
C               **  4) FOR RAW DATA CASE, BIN THE DATA.   **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLBI')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IDIST='BINOMIAL'
C
      NPERC=0
      MAXGRP=MAXNXT/2
      NMIN=2
      IF(NVAR.EQ.1)THEN
        DO1105I=1,N
          ITEMP=INT(Y(I)+0.5)
          Y(I)=REAL(ITEMP)
 1105   CONTINUE
        CALL CKDIST(Y,N,NMIN,TEMP1,NPERC,ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
C       BINOMIAL HAS ADDITIONAL CHECK:
C
C           1) IF NTRIAL = 1, THEN ONLY 0 OR 1 VALUES ALLOWED
C
C           2) IF NTRIAL > 1, THEN NTRIAL IS THE MAXIMUM VALUE
C              ALLOWED.
C
        CALL DISTIN(Y,N,IWRITE,TEMP1,NDIST,IBUGA3,IERROR)
        IF(NTRIAL.GT.1)THEN
          DO2105I=1,N
            ITEMP=INT(Y(I)+0.5)
            Y(I)=REAL(ITEMP)
            IF(Y(I).LT.0.0 .OR. Y(I).GT.NTRIAL)THEN
              WRITE(ICOUT,999)
              CALL DPWRST('XXX','WRIT')
              WRITE(ICOUT,2111)
 2111         FORMAT('***** ERROR FROM BINOMIAL MAXIMUM LIKELIHOOD--')
              CALL DPWRST('XXX','WRIT')
              WRITE(ICOUT,2113)I,NTRIAL
 2113         FORMAT('      ROW ',I8,' IS LESS THAN ZERO OR GREATER ',
     1               'THAN ',I8,' (= NUMBER OF TRIALS)')
              CALL DPWRST('XXX','WRIT')
              IERROR='YES'
              GOTO9000
            ENDIF
 2105     CONTINUE
        ELSE
          IF(NDIST.GT.2)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,2111)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,2113)NDIST
 2118       FORMAT('      FOR BINOMIAL CASE WITH 1 TRIAL, MORE THAN ',
     1             'TWO DISTINCT VALUES DETECTED.')
            CALL DPWRST('XXX','WRIT')
            IERROR='YES'
            GOTO9000
          ELSEIF(NDIST.EQ.1)THEN
            DO2130I=1,N
              IF(Y(I).LE.0.5)THEN
                Y(I)=0.0
              ELSE
                Y(I)=1.0
              ENDIF
 2130       CONTINUE
          ELSE
            HOLD1=TEMP1(1)
            HOLD2=TEMP1(2)
            IF(HOLD1.LT.HOLD2)THEN
              XMIN=HOLD1
              XMAX=HOLD2
            ELSE
              XMAX=HOLD1
              XMIN=HOLD2
            ENDIF
            DO2120I=1,N
              IF(Y(I).EQ.XMAX)THEN
                Y(I)=1.0
              ELSE
                Y(I)=0.0
              ENDIF
 2120       CONTINUE
          ENDIF
        ENDIF
C
        CALL SORT(Y,N,Y)
        IFLAG=1
        CALL SUMRAW(Y,N,IDIST,IFLAG,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,
     1              ISUBRO,IBUGA3,IERROR)
        CALL SUMDP(Y,N,IWRITE,XSUM,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        NTOTZZ=N
      ELSE
        CALL CKDIS2(Y,X,TEMP1,N,MAXGRP,NMIN,TEMP2,NPERC,NTOTZZ,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
C       COMPUTE XSUM AND CHECK THAT X(I) VALUE NOT GREATER
C       THAN NTRIAL VALUE
C
        XSUM=0.0
        DO2211I=1,N
          ITEMP=INT(Y(I)+0.5)
          Y(I)=REAL(ITEMP)
          ITEMP=INT(X(I)+0.5)
          X(I)=REAL(ITEMP)
          IF(X(I).LT.0.0 .OR. X(I).GT.NTRIAL)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,2111)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,2113)I,NTRIAL
            CALL DPWRST('XXX','WRIT')
            IERROR='YES'
            GOTO9000
          ENDIF
          XSUM=XSUM + Y(I)*X(I)
2211    CONTINUE
        N2=N
        IFLAG1=1
        IFLAG2=1
        CALL SUMGRP(Y,X,N,IDIST,IFLAG1,IFLAG2,
     1              TEMP1,TEMP2,TEMP3,MAXNXT,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
      ENDIF
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLBI')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1151)
 1151   FORMAT('AFTER COMPUTE SUMMARY STATISTICS--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1152)XMEAN,XVAR,XSD,XMIN,XMAX,XSUM
 1152   FORMAT('XMEAN,XVAR,XSD,XMIN,XMAX,XSUM = ',6G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
C               *******************************
C               **  STEP 41--                **
C               **  CARRY OUT CALCULATIONS   **
C               **  FOR BINOMIAL MLE ESTIMATE**
C               *******************************
C
 2100 CONTINUE
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLBI')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     NOTE: COMPUTE P AND PSD BOTH WITH AND WITHOUT
C           CONTINUITY CORRECTION.  NOTE THAT THE SD
C           FORMULA USES N (RATHER THAN N+1) IN THE
C           DENOMINATOR FOR BOTH THE UNCORRECTED AND
C           THE CORRECTED CASES.
C
      IF(NTRIAL.GT.1)THEN
        AN=REAL(NTOTZZ)*REAL(NTRIAL)
        P=XSUM/(REAL(NTOTZZ)*REAL(NTRIAL))
        Q=1.0-P
        PSD=SQRT(P*Q/AN)
        PCC=(XSUM+0.5)/(REAL(NTOTZZ)*REAL(NTRIAL)+1.0)
        ANCC=AN+1.0
        QCC=1.0-PCC
        PSDCC=SQRT(PCC*QCC/AN)
      ELSE
        AN=REAL(NTOTZZ)
        P=XSUM/REAL(NTOTZZ)
        Q=1.0-P
        PSD=SQRT(P*Q/AN)
        ANCC=AN+1.0
        PCC=(XSUM+0.5)/ANCC
        QCC=1.0-PCC
        PSDCC=SQRT(PCC*QCC/AN)
      ENDIF
C
      NTEMP=N*NTRIAL
      XSUCC=XSUM
      AE=1.E-6
      RE=1.E-6
      IFLAG=0
C
      DO2210I=1,NUMALP
C
        ALP=ALPHA(I)
        P1=ALP/2.0
        P2=1.0-(ALP/2.0)
C
C       GENERATE THE AGRESTI-COULL INTERVALS: THESE DO NOT
C       REQUIRE CONTINUITY CORRECTION.
C
        CALL NORPPF(P2,ZALPHA)
        TERM1=ZALPHA*ZALPHA/(2.0*AN)
        TERM2=ZALPHA*SQRT((P*Q/AN) + ZALPHA*ZALPHA/(4.0*AN*AN))
        TERM3=1.0 + ZALPHA*ZALPHA/AN
        UCL=(P + TERM1 + TERM2)/TERM3
        LCL=(P + TERM1 - TERM2)/TERM3
        IF(UCL.GT.1.0)UCL=1.0
        IF(LCL.LT.0.0)LCL=0.0
        ALOWAC(I)=LCL
        AUPPAC(I)=UCL
C
C       FOR NUMBER OF SUCCESSES >= 30, GENERATE NORMAL APPROXIMATION INTERVALS
C       FOR NUMBER OF SUCCESSES <  30, GENERATE EXACT INTERVALS
C
C       FEBRUARY 2007: 1) MAKE THRESHOLD USER SETTABLE.
C                      2) USER OPTION ON WHETHER TO USE CORRECTED
C                         OR UNCORRECTED INTERVALS.
C       APRIL    2007: 1) FOR EXACT BOUND, ALWAYS USE ESTIMATE OF
C                         P WITHOUT THE CONTINUITY CORRECTION.
C
        IF(XSUCC.GE.PTHRES)THEN
          CALL NORPPF(P2,ZALPHA)
          IF(IBINCC.EQ.'OFF')THEN
            UCL=P + ZALPHA*SQRT(P*Q/AN)
            LCL=P - ZALPHA*SQRT(P*Q/AN)
          ELSE
            UCL=PCC + ZALPHA*SQRT(PCC*QCC/AN)
            LCL=PCC - ZALPHA*SQRT(PCC*QCC/AN)
          ENDIF
          IF(UCL.GT.1.0)UCL=1.0
          IF(LCL.LT.0.0)LCL=0.0
          ALOWNO(I)=LCL
          AUPPNO(I)=UCL
        ELSE
          CONST=P2
          PHAT=P
          PLOWLI=0.0
          PUPPLI=PHAT
          XSUCC=XSUM-1.0
          IF(XSUCC.LE.0)XSUCC=0.0
          IF(PHAT.LE.0.0)THEN
            ALOWNO(I)=0.0
          ELSE
            CALL FZERO(BINFUN,PLOWLI,PUPPLI,PHAT,RE,AE,IFLAG)
            IF(PLOWLI.GT.PHAT)THEN
              ALOWNO(I)=0.0
            ELSE
              ALOWNO(I)=PLOWLI
            ENDIF
            IF(ALOWNO(I).LT.0.0)ALOWNO(I)=0.0
          IF(IFLAG.EQ.2)THEN
C
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2311)
 2311       FORMAT('***** WARNING FROM BINOMIAL MAXIMUM LIKELIHOOD--')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2313)
 2313       FORMAT('      ESTIMATE OF LOWER CONFIDENCE VALUE FOR P ',
     1             'MAY NOT BE COMPUTED TO DESIRED TOLERANCE.')
            CALL DPWRST('XXX','BUG ')
          ELSEIF(IFLAG.EQ.3)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2311)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2223)
 2223       FORMAT('      ESTIMATE OF LOWER CONFIDENCE VALUE FOR P ',
     1             'MAY BE NEAR A SINGULAR POINT.')
            CALL DPWRST('XXX','BUG ')
          ELSEIF(IFLAG.EQ.4)THEN
CCCCC       WRITE(ICOUT,999)
CCCCC       CALL DPWRST('XXX','BUG ')
CCCCC       WRITE(ICOUT,2211)
CCCCC       CALL DPWRST('XXX','BUG ')
CCCCC       WRITE(ICOUT,2233)
C2233       FORMAT('      APPROPRIATE BRACKETING INTERVAL NOT FOUND.')
CCCCC       CALL DPWRST('XXX','BUG ')
          ELSEIF(IFLAG.EQ.5)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2311)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2343)
 2343       FORMAT('      MAXIMUM ITERATIONS EXCEEDED.')
            CALL DPWRST('XXX','BUG ')
          ENDIF
          ENDIF
C
          IFLAG=0
          CONST=P1
          PHAT=P
          PLOWLI=PHAT
          PUPPLI=1.0
          XSUCC=XSUM
          IF(XSUCC.LE.0.0)XSUCC=0.0
          IF(PHAT.GE.1.0)THEN
            AUPPNO(I)=1.0
          ELSE
            CALL FZERO(BINFUN,PLOWLI,PUPPLI,PHAT,RE,AE,IFLAG)
            IF(PLOWLI.LT.PHAT)THEN
              AUPPNO(I)=PUPPLI
            ELSE
              AUPPNO(I)=PLOWLI
            ENDIF
            IF(AUPPNO(I).GT.1.0)AUPPNO(I)=1.0
          IF(IFLAG.EQ.2)THEN
C
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2311)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2263)
 2263       FORMAT('      ESTIMATE OF UPPER CONFIDENCE VALUE FOR P ',
     1             'MAY NOT BE COMPUTED TO DESIRED TOLERANCE.')
            CALL DPWRST('XXX','BUG ')
          ELSEIF(IFLAG.EQ.3)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2311)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2273)
 2273       FORMAT('      ESTIMATE OF UPPER CONFIDENCE VALUE FOR P ',
     1             'MAY BE NEAR A SINGULAR POINT.')
            CALL DPWRST('XXX','BUG ')
          ELSEIF(IFLAG.EQ.4)THEN
CCCCC       WRITE(ICOUT,999)
CCCCC       CALL DPWRST('XXX','BUG ')
CCCCC       WRITE(ICOUT,2311)
CCCCC       CALL DPWRST('XXX','BUG ')
CCCCC       WRITE(ICOUT,2233)
C2233       FORMAT('      APPROPRIATE BRACKETING INTERVAL NOT FOUND.')
CCCCC       CALL DPWRST('XXX','BUG ')
          ELSEIF(IFLAG.EQ.5)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2311)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,2283)
 2283       FORMAT('      MAXIMUM ITERATIONS EXCEEDED.')
            CALL DPWRST('XXX','BUG ')
          ENDIF
          ENDIF
C
        ENDIF
C
 2210 CONTINUE
C
C               *********************************
C               **   STEP 42--                 **
C               **   WRITE OUT EVERYTHING      **
C               **   FOR BINOMIAL MLE ESTIMATE **
C               **********************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLBI')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     PRINT SUMMARY STATISTICS TABLE
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Binomial Parameter Estimation'
      NCTITL=29
      ITITLZ=' '
      NCTITZ=0
C
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(NTOTZZ)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Trials:'
      NCTEXT(ICNT)=17
      AVALUE(ICNT)=REAL(NTRIAL)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Successes:'
      NCTEXT(ICNT)=20
      AVALUE(ICNT)=XSUM
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Binomal SD (= SQRT(P*Q/N) (Uncorrected):'
      NCTEXT(ICNT)=40
      AVALUE(ICNT)=PSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Binomal SD (with Continuity Correction):'
      NCTEXT(ICNT)=40
      AVALUE(ICNT)=PSDCC
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Method of Maximum Likelihood:'
      NCTEXT(ICNT)=29
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of P (Uncorrected):'
      NCTEXT(ICNT)=28
      AVALUE(ICNT)=P
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of P (Continuity Correction):'
      NCTEXT(ICNT)=38
      AVALUE(ICNT)=PCC
      IDIGIT(ICNT)=NUMDIG
C
      NUMROW=ICNT
      DO2410I=1,NUMROW
        NTOT(I)=15
 2410 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
      ITITL9='Confidence Interval for Probability of Success Parameter'
      NCTIT9=59
      IF(IBINCC.EQ.'ON')THEN
        ITITLE='Continuity Correction for Normal/Exact Intervals'
        NCTITL=48
      ELSE
        ITITLE='No Continuity Correction for Normal/Exact Intervals'
        NCTITL=51
      ENDIF
C
      NUMLIN=3
      NUMCOL=5
      DO2510J=1,NUMCLI
        DO2520I=1,NUMLIN
          ITITL2(I,J)=' '
          NCTIT2(I,J)=0
 2520   CONTINUE
 2510 CONTINUE
C
      ITITL2(2,1)='Confidence'
      ITITL2(3,1)='Value (%)'
      NCTIT2(2,1)=10
      NCTIT2(3,1)=9
C
      ITITL2(1,2)='Exact'
      ITITL2(2,2)='Lower'
      ITITL2(3,2)='Limit'
      NCTIT2(1,2)=5
      NCTIT2(2,2)=5
      NCTIT2(3,2)=5
C
      ITITL2(1,3)='Interval'
      ITITL2(2,3)='Upper'
      ITITL2(3,3)='Limit'
      NCTIT2(1,3)=8
      NCTIT2(2,3)=5
      NCTIT2(3,3)=5
C
      ITITL2(1,4)='Agresti-Coull'
      ITITL2(2,4)='Lower'
      ITITL2(3,4)='Limit'
      NCTIT2(1,4)=13
      NCTIT2(2,4)=5
      NCTIT2(3,4)=5
C
      ITITL2(1,5)='Approximation'
      ITITL2(2,5)='Upper'
      ITITL2(3,5)='Limit'
      NCTIT2(1,5)=13
      NCTIT2(2,5)=5
      NCTIT2(3,5)=5
C
      IF(XSUM.GE.PTHRES)THEN
        ITITL2(1,2)='Normal'
        NCTIT2(1,2)=6
        ITITL2(1,3)='Approximation'
        NCTIT2(1,3)=13
      ENDIF
C
      NMAX=0
      DO2321I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        NMAX=NMAX+NTOT(I)
        IDIGIT(I)=NUMDIG
 2321 CONTINUE
      IDIGIT(1)=2
      DO2323I=1,NUMALP
        NCTEXT(I)=0
        AMAT(I,1)=100.0*(1.0 - ALPHA(I))
        AMAT(I,2)=ALOWNO(I)
        AMAT(I,3)=AUPPNO(I)
        AMAT(I,4)=ALOWAC(I)
        AMAT(I,5)=AUPPAC(I)
 2323 CONTINUE
      IWHTML(1)=100
      IWHTML(2)=150
      IWHTML(3)=150
      IWHTML(4)=150
      IWHTML(5)=150
      IWHTML(6)=150
      IWRTF(1)=1600
      IWRTF(2)=IWRTF(1)+1800
      IWRTF(3)=IWRTF(2)+1800
      IWRTF(4)=IWRTF(3)+1800
      IWRTF(5)=IWRTF(4)+1800
      IFRST=.TRUE.
      ILAST=.TRUE.
C
      CALL DPDTA2(ITITL9,NCTIT9,
     1            ITITLE,NCTITL,ITITL2,NCTIT2,
     1            MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1            ITEXT,NCTEXT,AMAT,NUMALP,NUMALP,
     1            IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1            ICAPSW,ICAPTY,IFRST,ILAST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLBI')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLBI--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)IERROR
 9012   FORMAT('IERROR = ',A4)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLBN(Y,N,
     1                  XTEMP,DTEMP1,MAXNXT,
     1                  AMUSV,SIGMSV,ALPHSV,BETASV,
     1                  AMUML,SIGMML,ALPHML,BETAML,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR THE BETA NORMAL DISTRIBUTION.
C     EXAMPLE--BETA NORMAL MLE Y
C     REFERENCE--EUGENE, LEE, AND FAMOYE (2002), "BETA-NORMAL
C                DISTRIBUTION AND ITS APPLICATIONS", COMMUNICATIONS
C                IN STATISTICS--THEORY AND METHODS, 31(4),
C                PP. 497-512.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2007/6
C     ORIGINAL VERSION--JUNE      2007.
C     UPDATED         --JULY      2010. USE DPDTA1 TO PRINT OUTPUT
C     UPDATED         --JULY      2010. EXTRACT POINT ESTIMATES TO
C                                       BNOML1
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION XTEMP(*)
      DOUBLE PRECISION DTEMP1(*)
C
      DIMENSION QP(1)
C
      PARAMETER (MAXROW=20)
      CHARACTER*50 ITITLE
      CHARACTER*1  ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*50 ITEXT(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='BN  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLBN')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLBN--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N
   52   FORMAT('IBUGA3,ISUBRO,N = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,E15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLBN')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NPERC=0
      NMIN=5
      CALL CKDIST(Y,N,NMIN,QP,NPERC,ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C               *************************************
C               **  STEP 31--                      **
C               **  CARRY OUT CALCULATIONS         **
C               **  FOR BETA NORMAL MLE ESTIMATION **
C               *************************************
C
      ISTEPN='31'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLBN')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IERROR='NO'
      IWRITE='OFF'
C
      CALL BNOML1(Y,N,MAXNXT,DTEMP1,
     1            XMEAN,XSD,XVAR,XMIN,XMAX,
     1            AMUSV,SIGMSV,ALPHSV,BETASV,
     1            AMUML,SIGMML,ALPHML,BETAML,
     1            ISUBRO,IBUGA3,IERROR)
C
C               ****************************************
C               **   STEP 42--                        **
C               **   WRITE OUT EVERYTHING             **
C               **   FOR BETA NORMAL MLE ESTIMATION   **
C               ****************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLBN')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Beta-Normal Parameter Estimation:'
      NCTITL=33
      ITITLZ='Full Sample Case'
      NCTITZ=16
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(N)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Maximum Likelihood:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Location:'
      NCTEXT(ICNT)=21
      AVALUE(ICNT)=AMUML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Scale:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=SIGMML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Shape Parameter Alpha:'
      NCTEXT(ICNT)=34
      AVALUE(ICNT)=ALPHML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Shape Parameter Beta:'
      NCTEXT(ICNT)=33
      AVALUE(ICNT)=BETAML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='Log-likelihood:'
CCCCC NCTEXT(ICNT)=15
CCCCC AVALUE(ICNT)=ALIK
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=AIC
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AICc:'
CCCCC NCTEXT(ICNT)=5
CCCCC AVALUE(ICNT)=AICC
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='BIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=BIC
CCCCC IDIGIT(ICNT)=-7
C
      NUMROW=ICNT
      DO2320I=1,NUMROW
        NTOT(I)=15
 2320 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLBN')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLBN--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012   FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9015)N
 9015   FORMAT('N = ',I8)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLBT(Y,X,N,NVAR,
     1                  TEMP1,TEMP2,TEMP3,MAXNXT,
     1                  AKHAT,ALAMHT,
     1                  AIC,AICC,BIC,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR THE BOREL-TANNER DISTRIBUTION.
C              THE MAXIMUM LIKELIHOOD ESTIMATES ARE:
C
C              1) USE THE MINIMUM VALUE AS THE ESTIMATE OF
C                 K.
C
C              2) THEN USE
C
C                   (XMEAN - K)/XMEAN
C
C                 AS THE ESTIMATE OF LAMBDA.  NOTE THAT THIS
C                 IS BOTH THE MOMENT AND MAXIMUM LIKELIHOOD
C                 ESTIMATE.
C
C              THERE ARE TWO CASES:
C
C              1) ONE VARIABLE CASE: Y IS RAW DATA
C              2) TWO VARIABLE CASE: Y IS FREQUENCY, X IS CLASS
C                 MID-POINT.
C
C     EXAMPLE--BOREL-TANNER MAXIMUM LIKELIHOOD Y
C            --BOREL-TANNER MAXIMUM LIKELIHOOD Y X
C     REFERENCES--JOHNSON, KOTZ, AND KEMP (1992).  "UNIVARIATE
C                 DISCRETE DISTRIBUTIONS", SECOND EDITION, 
C                 WILEY, PP. 394-396.
C               --LUC DEVROYE, "THE BRANCHING PROCESS METHOD IN
C                 LAGRANGE RANDOM VARIATE GENERATION",
C                 FROM DEVROYES'S WEB SITE.
C               --HAIGHT AND BREUER (1960), "THE BOREL-TANNER
C                 DISTRIBUTION", BIOMETRIKA, 47, PP. 143-150.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2006/5
C     ORIGINAL VERSION--MAY       2006.
C     UPDATED         --APRIL     2011. USE DPDTA1 TO PRINT THE OUTPUT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-----------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*4 ISUBN0
C
      PARAMETER (MAXROW=20)
      CHARACTER*60 ITITLE
      CHARACTER*1  ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 IDIST
      CHARACTER*40 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(MAXROW)
      CHARACTER*4  VALIGN(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL      IFRST
      LOGICAL      ILAST
C
C-------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION TEMP1(*)
      DIMENSION TEMP2(*)
      DIMENSION TEMP3(*)
C
C-------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT---------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='BT  '
C
      IERROR='NO'
      IWRITE='OFF'
C
      AKHAT=CPUMIN
      ALAMHT=CPUMIN
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLNM')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLBT--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N,NVAR
   52   FORMAT('IBUGA3,ISUBRO,N,NVAR = ',2(A4,2X),2I8)
        CALL DPWRST('XXX','WRIT')
        IF(NVAR.EQ.1)THEN
          DO56I=1,MIN(N,100)
            WRITE(ICOUT,57)I,Y(I)
   57       FORMAT('I,Y(I) = ',I8,G15.7)
            CALL DPWRST('XXX','WRIT')
   56     CONTINUE
        ELSE
          DO61I=1,N
            WRITE(ICOUT,62)I,X(I),Y(I)
   62       FORMAT('I,X(I),Y(I) = ',I8,2G15.7)
            CALL DPWRST('XXX','WRIT')
   61     CONTINUE
        ENDIF
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  1) ROUND DATA TO INTEGER VALUES       **
C               **  2) COMPUTE SUMMARY STATISTICS         **
C               **  3) CHECK INPUT FOR NEGATIVE VALUES,   **
C               **     INSUFFICIENT SAMPLE SIZE           **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLBT')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IDIST='BOREL-TANNER'
      NPERC=0
      MAXGRP=MAXNXT/2
      NMIN=2
C
      IF(NVAR.EQ.1)THEN
        DO1105I=1,N
          ITEMP=INT(Y(I)+0.5)
          Y(I)=REAL(ITEMP)
 1105   CONTINUE
        CALL CKDIST(Y,N,NMIN,TEMP2,NPERC,ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
        IFLAG=1
        CALL SUMRAW(Y,N,IDIST,IFLAG,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        NTOTZZ=N
C
      ELSE
        CALL CKDIS2(Y,X,TEMP1,N,MAXGRP,NMIN,TEMP2,NPERC,NTOTZZ,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IFLAG1=1
        IFLAG2=1
        CALL SUMGRP(Y,X,N,IDIST,IFLAG1,IFLAG2,
     1              TEMP1,TEMP2,TEMP3,MAXNXT,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
      ENDIF
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLBT')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1151)
 1151   FORMAT('AFTER COMPUTE SUMMARY STATISTICS--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1152)XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ
 1152   FORMAT('XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ = ',5G15.7,I10)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
C               *****************************************
C               **  STEP 21--                          **
C               **  CARRY OUT CALCULATIONS             **
C               **  FOR BOREL-TANNER MLE ESTIMATION    **
C               *****************************************
C
 2100 CONTINUE
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLBT')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      AKHAT=XMIN
      ALAMHT=(XMEAN-AKHAT)/XMEAN
C
C               ***********************************************
C               **   STEP 42--                               **
C               **   WRITE OUT EVERYTHING                    **
C               **   FOR BOREL-TANNER MLE ESTIMATION         **
C               ***********************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLBT')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     PRINT SUMMARY STATISTICS TABLE
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Borel-Tanner Parameter Estimation'
      NCTITL=34
      ITITLZ=' '
      NCTITZ=0
C
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(NTOTZZ)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Maximum Likelihood (= Moment) Estimates:'
      NCTEXT(ICNT)=40
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of K:'
      NCTEXT(ICNT)=14
      AVALUE(ICNT)=AKHAT
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Lambda:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=ALAMHT
      IDIGIT(ICNT)=NUMDIG
C
      NUMROW=ICNT
      DO2310I=1,NUMROW
        NTOT(I)=15
 2310 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLBT')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLBT--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)IERROR,AKHAT,ALAMHT
 9012   FORMAT('IERROR,AKHAT,ALAMHT = ',A4,2X,2G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLCA(Y,N,
     1                  XTEMP,TEMP1,DTEMP1,MAXNXT,
     1                  ALOC,ASCALE,ALOCOS,ASCLOS,ALOWOS,SCAWOS,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR CAUCHY DISTRIBUTION
C     EXAMPLE--CAUCHY MAXIMUM LIKELIHOOD Y
C     REFERENCE--GERALD HAAS, LEE BAIN, CHARLES ANTLE, (1970).
C                "INFERENCES FOR THE CAUCHY DISTRIBUTION BASED ON
C                MAXIMUM LIKELIHOOD ESTIMATORS", BIOMETRIKA,
C                PP. 403-407.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2003/10
C     ORIGINAL VERSION--OCTOBER   2003.
C     UPDATED         --MAY       2005. ADD SUMS OF WEIGHTED ORDER
C                                       STATISTICS METHOD
C     UPDATED         --JUNE      2010. USE DPDTA1 AND DPDTA7 TO
C                                       PRINT OUTPUT, ADD AIC AND
C                                       RELATED STATISTICS TO OUTPUT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
      CHARACTER*4 IWRITE
      CHARACTER*4 INORM
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION XTEMP(*)
      DIMENSION TEMP1(*)
      DIMENSION QP(1)
      DOUBLE PRECISION DTEMP1(*)
C
      DIMENSION ATABLE(11,2)
      DIMENSION BTABLE(10,4)
C
      PARAMETER (NUMALP=2)
      DIMENSION ALPHA(NUMALP)
      DIMENSION ALOWLO(NUMALP)
      DIMENSION AUPPLO(NUMALP)
      DIMENSION ALOWSC(NUMALP)
      DIMENSION AUPPSC(NUMALP)
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=50)
      CHARACTER*60 ITITLE
      CHARACTER*1  ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*50 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(NUMALP)
      CHARACTER*4  VALIGN(NUMALP)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
C
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA PI/3.14159265358979/
C
      DATA (ATABLE(1,J),J=1,2)/4.77, 6.78/
      DATA (ATABLE(2,J),J=1,2)/3.11, 3.95/
      DATA (ATABLE(3,J),J=1,2)/2.79, 3.46/
      DATA (ATABLE(4,J),J=1,2)/2.63, 3.27/
      DATA (ATABLE(5,J),J=1,2)/2.60, 3.13/
      DATA (ATABLE(6,J),J=1,2)/2.51, 3.05/
      DATA (ATABLE(7,J),J=1,2)/2.48, 2.97/
      DATA (ATABLE(8,J),J=1,2)/2.45, 2.96/
      DATA (ATABLE(9,J),J=1,2)/2.40, 2.89/
      DATA (ATABLE(10,J),J=1,2)/2.38, 2.85/
      DATA (ATABLE(11,J),J=1,2)/2.33, 2.77/
C
      DATA (BTABLE(1,J),J=1,4)/0.130, 0.101, 2.56, 3.277/
      DATA (BTABLE(2,J),J=1,4)/0.320, 0.387, 2.005, 2.353/
      DATA (BTABLE(3,J),J=1,4)/0.418, 0.479, 1.746, 1.970/
      DATA (BTABLE(4,J),J=1,4)/0.488, 0.546, 1.628, 1.811/
      DATA (BTABLE(5,J),J=1,4)/0.533, 0.583, 1.536, 1.708/
      DATA (BTABLE(6,J),J=1,4)/0.568, 0.621, 1.498, 1.635/
      DATA (BTABLE(7,J),J=1,4)/0.622, 0.670, 1.412, 1.525/
      DATA (BTABLE(8,J),J=1,4)/0.656, 0.702, 1.366, 1.463/
      DATA (BTABLE(9,J),J=1,4)/0.710, 0.751, 1.289, 1.358/
      DATA (BTABLE(10,J),J=1,4)/0.746, 0.779, 1.251, 1.305/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='CA  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLCA')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLCA--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3
   52   FORMAT('IBUGA3 = ',A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)N
   55   FORMAT('N = ',I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,N
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,E15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLCA')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NPERC=0
      NMIN=4
      CALL CKDIST(Y,N,NMIN,QP,NPERC,ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C               ********************************
C               **  STEP 41--                 **
C               **  CARRY OUT CALCULATIONS    **
C               **  FOR CAUCHY MLE ESTIMATE   **
C               ********************************
C
 3100 CONTINUE
C
      ISTEPN='41'
      IF(IBUGA3.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IWRITE='OFF'
      IERROR='NO'
C
      CALL CAUML1(Y,N,TEMP1,XTEMP,DTEMP1,MAXNXT,
     1            XMEAN,XMED,XSD,XMAD,XIQ,XMIN,XMAX,
     1            ALOC,ASCALE,ALOCOS,ASCLOS,ALOWOS,SCAWOS,
     1            ISUBRO,IBUGA3,IERROR)
C
      CALL CAULI1(Y,N,ALOC,ASCALE,
     1            ALIKML,AICML,AICCML,BICML,
     1            ISUBRO,IBUGA3,IERROR)
C
      CALL CAULI1(Y,N,ALOCOS,ASCLOS,
     1            ALIKOS,AICOS,AICCOS,BICOS,
     1            ISUBRO,IBUGA3,IERROR)
C
      CALL CAULI1(Y,N,ALOWOS,SCAWOS,
     1            ALIKWS,AICWS,AICCWS,BICWS,
     1            ISUBRO,IBUGA3,IERROR)
C
C               ***********************************************
C               **  STEP 41B-                                **
C               **  COMPUTE 90% AND 95% CONFIDENCE INTERVALS **
C               **  USING METHOD GIVEN IN ANTLE PAPER        **
C               ***********************************************
C
      AN=REAL(N)
      IF(N.EQ.5)THEN
        A1=ATABLE(1,1)
        A2=ATABLE(1,2)
      ELSEIF(N.GE.6 .AND. N.LE.9)THEN
        AFACT=REAL(N-5)/REAL(10-5)
        A1=ATABLE(2,1) - AFACT*ABS(ATABLE(2,1)-ATABLE(1,1))
        A2=ATABLE(2,2) - AFACT*ABS(ATABLE(2,2)-ATABLE(1,2))
      ELSEIF(N.EQ.10)THEN
        A1=ATABLE(2,1)
        A2=ATABLE(2,2)
      ELSEIF(N.GE.11 .AND. N.LE.14)THEN
        AFACT=REAL(N-10)/REAL(15-10)
        A1=ATABLE(3,1) - AFACT*ABS(ATABLE(3,1)-ATABLE(2,1))
        A2=ATABLE(3,2) - AFACT*ABS(ATABLE(3,2)-ATABLE(2,2))
      ELSEIF(N.GE.15 .AND. N.LE.18)THEN
        A1=ATABLE(3,1)
        A2=ATABLE(3,2)
      ELSEIF(N.GE.19 .AND. N.LE.23)THEN
        A1=ATABLE(4,1)
        A2=ATABLE(4,2)
      ELSEIF(N.GE.24 .AND. N.LE.28)THEN
        A1=ATABLE(5,1)
        A2=ATABLE(5,2)
      ELSEIF(N.GE.29 .AND. N.LE.35)THEN
        A1=ATABLE(6,1)
        A2=ATABLE(6,2)
      ELSEIF(N.GE.36 .AND. N.LE.45)THEN
        A1=ATABLE(7,1)
        A2=ATABLE(7,2)
      ELSEIF(N.GE.46 .AND. N.LE.63)THEN
        A1=ATABLE(8,1)
        A2=ATABLE(8,2)
      ELSEIF(N.GE.64 .AND. N.LE.88)THEN
        A1=ATABLE(9,1)
        A2=ATABLE(9,2)
      ELSEIF(N.GE.89 .AND. N.LE.100)THEN
        A1=ATABLE(10,1)
        A2=ATABLE(10,2)
      ELSE
        A1=ATABLE(11,1)
        A2=ATABLE(11,2)
      ENDIF
      ALOWLO(1)=ALOC - A1*ASCALE/SQRT(AN)
      AUPPLO(1)=ALOC + A1*ASCALE/SQRT(AN)
      ALOWLO(2)=ALOC - A2*ASCALE/SQRT(AN)
      AUPPLO(2)=ALOC + A2*ASCALE/SQRT(AN)
C
      IF(N.EQ.5)THEN
        B1=BTABLE(1,1)
        B2=BTABLE(1,2)
        B3=BTABLE(1,3)
        B4=BTABLE(1,4)
      ELSEIF(N.GE.6 .AND. N.LE.9)THEN
        AFACT=REAL(N-5)/REAL(10-5)
        B1=BTABLE(1,1) + AFACT*ABS(BTABLE(2,1)-BTABLE(1,1))
        B2=BTABLE(1,2) + AFACT*ABS(BTABLE(2,2)-BTABLE(1,2))
        B3=BTABLE(1,3) + AFACT*ABS(BTABLE(2,3)-BTABLE(1,3))
        B4=BTABLE(1,4) + AFACT*ABS(BTABLE(2,4)-BTABLE(1,4))
      ELSEIF(N.EQ.10)THEN
        B1=BTABLE(2,1)
        B2=BTABLE(2,2)
        B3=BTABLE(2,3)
        B4=BTABLE(2,4)
      ELSEIF(N.GE.11 .AND. N.LE.14)THEN
        AFACT=REAL(N-10)/REAL(15-10)
        B1=BTABLE(2,1) + AFACT*ABS(BTABLE(3,1)-BTABLE(2,1))
        B2=BTABLE(2,2) + AFACT*ABS(BTABLE(3,2)-BTABLE(2,2))
        B3=BTABLE(2,3) + AFACT*ABS(BTABLE(3,3)-BTABLE(2,3))
        B4=BTABLE(2,4) + AFACT*ABS(BTABLE(3,4)-BTABLE(2,4))
      ELSEIF(N.EQ.15)THEN
        B1=BTABLE(3,1)
        B2=BTABLE(3,2)
        B3=BTABLE(3,3)
        B4=BTABLE(3,4)
      ELSEIF(N.GE.16 .AND. N.LE.19)THEN
        AFACT=REAL(N-15)/REAL(20-15)
        B1=BTABLE(3,1) + AFACT*ABS(BTABLE(4,1)-BTABLE(3,1))
        B2=BTABLE(3,2) + AFACT*ABS(BTABLE(4,2)-BTABLE(3,2))
        B3=BTABLE(3,3) + AFACT*ABS(BTABLE(4,3)-BTABLE(3,3))
        B4=BTABLE(3,4) + AFACT*ABS(BTABLE(4,4)-BTABLE(3,4))
      ELSEIF(N.EQ.20)THEN
        B1=BTABLE(4,1)
        B2=BTABLE(4,2)
        B3=BTABLE(4,3)
        B4=BTABLE(4,4)
      ELSEIF(N.GE.21 .AND. N.LE.24)THEN
        AFACT=REAL(N-20)/REAL(25-20)
        B1=BTABLE(4,1) + AFACT*ABS(BTABLE(5,1)-BTABLE(4,1))
        B2=BTABLE(4,2) + AFACT*ABS(BTABLE(5,2)-BTABLE(4,2))
        B3=BTABLE(4,3) + AFACT*ABS(BTABLE(5,3)-BTABLE(4,3))
        B4=BTABLE(4,4) + AFACT*ABS(BTABLE(5,4)-BTABLE(4,4))
      ELSEIF(N.GE.25)THEN
        B1=BTABLE(5,1)
        B2=BTABLE(5,2)
        B3=BTABLE(5,3)
        B4=BTABLE(5,4)
      ELSEIF(N.GE.26 .AND. N.LE.29)THEN
        AFACT=REAL(N-25)/REAL(30-25)
        B1=BTABLE(5,1) + AFACT*ABS(BTABLE(6,1)-BTABLE(5,1))
        B2=BTABLE(5,2) + AFACT*ABS(BTABLE(6,2)-BTABLE(5,2))
        B3=BTABLE(5,3) + AFACT*ABS(BTABLE(6,3)-BTABLE(5,3))
        B4=BTABLE(5,4) + AFACT*ABS(BTABLE(6,4)-BTABLE(5,4))
      ELSEIF(N.GE.30)THEN
        B1=BTABLE(6,1)
        B2=BTABLE(6,2)
        B3=BTABLE(6,3)
        B4=BTABLE(6,4)
      ELSEIF(N.GE.31 .AND. N.LE.39)THEN
        AFACT=REAL(N-30)/REAL(40-30)
        B1=BTABLE(6,1) + AFACT*ABS(BTABLE(7,1)-BTABLE(6,1))
        B2=BTABLE(6,2) + AFACT*ABS(BTABLE(7,2)-BTABLE(6,2))
        B3=BTABLE(6,3) + AFACT*ABS(BTABLE(7,3)-BTABLE(6,3))
        B4=BTABLE(6,4) + AFACT*ABS(BTABLE(7,4)-BTABLE(6,4))
      ELSEIF(N.GE.40)THEN
        B1=BTABLE(7,1)
        B2=BTABLE(7,2)
        B3=BTABLE(7,3)
        B4=BTABLE(7,4)
      ELSEIF(N.GE.41 .AND. N.LE.49)THEN
        AFACT=REAL(N-40)/REAL(50-40)
        B1=BTABLE(7,1) + AFACT*ABS(BTABLE(8,1)-BTABLE(7,1))
        B2=BTABLE(7,2) + AFACT*ABS(BTABLE(8,2)-BTABLE(7,2))
        B3=BTABLE(7,3) + AFACT*ABS(BTABLE(8,3)-BTABLE(7,3))
        B4=BTABLE(7,4) + AFACT*ABS(BTABLE(8,4)-BTABLE(7,4))
      ELSEIF(N.GE.50)THEN
        B1=BTABLE(8,1)
        B2=BTABLE(8,2)
        B3=BTABLE(8,3)
        B4=BTABLE(8,4)
      ELSEIF(N.GE.51 .AND. N.LE.74)THEN
        AFACT=REAL(N-50)/REAL(75-50)
        B1=BTABLE(8,1) + AFACT*ABS(BTABLE(9,1)-BTABLE(8,1))
        B2=BTABLE(8,2) + AFACT*ABS(BTABLE(9,2)-BTABLE(8,2))
        B3=BTABLE(8,3) + AFACT*ABS(BTABLE(9,3)-BTABLE(8,3))
        B4=BTABLE(8,4) + AFACT*ABS(BTABLE(9,4)-BTABLE(8,4))
      ELSEIF(N.GE.75)THEN
        B1=BTABLE(9,1)
        B2=BTABLE(9,2)
        B3=BTABLE(9,3)
        B4=BTABLE(9,4)
      ELSEIF(N.GE.76 .AND. N.LE.99)THEN
        AFACT=REAL(N-75)/REAL(100-75)
        B1=BTABLE(9,1) + AFACT*ABS(BTABLE(10,1)-BTABLE(9,1))
        B2=BTABLE(9,2) + AFACT*ABS(BTABLE(10,2)-BTABLE(9,2))
        B3=BTABLE(9,3) + AFACT*ABS(BTABLE(10,3)-BTABLE(9,3))
        B4=BTABLE(9,4) + AFACT*ABS(BTABLE(10,4)-BTABLE(9,4))
      ELSE
        B1=BTABLE(10,1)
        B2=BTABLE(10,2)
        B3=BTABLE(10,3)
        B4=BTABLE(10,4)
      ENDIF
      ALOWSC(1)=ASCALE/B4
      AUPPSC(1)=ASCALE/B2
      ALOWSC(2)=ASCALE/B3
      AUPPSC(2)=ASCALE/B1
C
C               *********************************
C               **   STEP 42--                 **
C               **   WRITE OUT EVERYTHING      **
C               **   FOR CAUCHY MLE ESTIMATE   **
C               **********************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLCA')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Cauchy Parameter Estimation'
      NCTITL=27
      ITEXT(1)='Summary Statistics:'
      NCTEXT(1)=19
      AVALUE(1)=0.0
      IDIGIT(1)=-1
      ITEXT(2)='Number of Observations:'
      NCTEXT(2)=23
      AVALUE(2)=REAL(N)
      IDIGIT(2)=0
      ICNT=3
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Median:'
      NCTEXT(ICNT)=14
      AVALUE(ICNT)=XMED
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Median Absolute Deviation:'
      NCTEXT(ICNT)=33
      AVALUE(ICNT)=XMAD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Interquartile Range:'
      NCTEXT(ICNT)=27
      AVALUE(ICNT)=XIQ
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Order Statistic Estimation Method:'
      NCTEXT(ICNT)=34
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Location Parameter:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=ALOCOS
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Scale Parameter:'
      NCTEXT(ICNT)=16
      AVALUE(ICNT)=ASCLOS
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Log-likelihood:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=ALIKOS
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)='AIC:'
      NCTEXT(ICNT)=4
      AVALUE(ICNT)=AICOS
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)='AICc:'
      NCTEXT(ICNT)=5
      AVALUE(ICNT)=AICCOS
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)='BIC:'
      NCTEXT(ICNT)=4
      AVALUE(ICNT)=BICOS
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Weighted Order Statistic Estimation Method:'
      NCTEXT(ICNT)=43
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Location Parameter:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=ALOWOS
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Scale Parameter:'
      NCTEXT(ICNT)=16
      AVALUE(ICNT)=SCAWOS
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Log-likelihood:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=ALIKWS
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)='AIC:'
      NCTEXT(ICNT)=4
      AVALUE(ICNT)=AICWS
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)='AICc:'
      NCTEXT(ICNT)=5
      AVALUE(ICNT)=AICCWS
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)='BIC:'
      NCTEXT(ICNT)=4
      AVALUE(ICNT)=BICWS
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Maximum Likelihood Estimation Method:'
      NCTEXT(ICNT)=37
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Location Parameter:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=ALOC
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Scale Parameter:'
      NCTEXT(ICNT)=16
      AVALUE(ICNT)=ASCALE
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Log-likelihood:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=ALIKML
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)='AIC:'
      NCTEXT(ICNT)=4
      AVALUE(ICNT)=AICML
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)='AICc:'
      NCTEXT(ICNT)=5
      AVALUE(ICNT)=AICCML
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)='BIC:'
      NCTEXT(ICNT)=4
      AVALUE(ICNT)=BICML
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      NUMROW=ICNT
      DO2310I=1,NUMROW
        NTOT(I)=15
 2310 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.FALSE.
      NCTITZ=0
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,
     1            NCTEXT,AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
      IFRST=.FALSE.
      ITITLE=' '
      NCTITL=0
C
      ALPHA(1)=0.10
      ALPHA(2)=0.05
      INORM='YES'
      CALL DPDTA7(ALOWLO,AUPPLO,ALOWSC,AUPPSC,ALPHA,NUMALP,
     1            ICAPSW,ICAPTY,NUMDIG,INORM,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLCA')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLCA--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012   FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLCN(Y,X,N,NVAR,
     1                  TEMP1,TEMP2,TEMP3,DTEMP1,
     1                  AMUMOM,AMMOM,AMUFR,AMFR,AMUML,AMML,
     1                  ICAPSW,ICAPTY,IFORSW,MAXNXT,
     1                  ICONDF,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR THE CONSUL DISTRIBUTION.  ESTIMATES
C              ARE GENERATED IN TERMS OF THE MU/M
C              PARAMETERIZATION.
C
C              THE MOMENT ESTIMATES OF MU AND M ARE:
C
C                 MUHAT = XBAR
C                 MHAT = XBAR*(XBAR - 1)**2/
C                        [XBAR**2*(XBAR-1)-S**2}
C
C              NOTE THAT IF THE MOMENT ESTIMATE OF M IS LESS
C              THAN 1, THE CONSUL DISTRIBUTION IS NOT AN
C              APPROPRIATE MODEL.  SPECIFICALLY, IF
C
C                  S**2 >= XBAR**2*(XBAR - 1)
C
C              THEN THE GEETA DISTRIBUTION IS THE MORE
C              APPROPRIATE MODEL.  IF
C
C                  XBAR*(XBAR-1) <= S**2 <= XBAR**2*(XBAR - 1)
C
C              THEN THE CONSUL IS MORE APPROPRIATE THAN THE
C              GEETA MODEL.  IF
C
C                  S**2 < XBAR*(XBAR - 1)
C
C              THEN NEITHER THE GEETA OR THE CONSUL IS AN
C              APPROPRIATE MODEL.
C
C              THE MEAN AND ONES FREQUENCY ESTIMATE OF MU IS:
C
C                  MUHAT = XBAR
C
C              THE ESTIMATE OF M IS THEN THE SOLUTION OF THE
C              EQUATION
C
C                 M*LOG(1 - (XBAR-1)/(M*XBAR)) - LOG(N1/N) = 0
C
C              THE MAXIMUM LIKELIHOOD FREQUENCY ESTIMATE OF MU IS:
C
C                  MUHAT = XBAR
C
C              THE ESTIMATE OF M IS THEN THE SOLUTION OF THE
C              EQUATION
C
C                 LOG(1 - (XBAR-1)/(M*XBAR)) + (1/(N*XBAR))*
C                 SUM[X=2 to k][SUM[i=0 to X-2][X*N(x)/(M*X-i)]] = 0
C
C              THERE ARE TWO CASES:
C
C              1) ONE VARIABLE CASE: Y IS RAW DATA
C              2) TWO VARIABLE CASE: Y IS FREQUENCY, X IS CLASS
C                 MID-POINT.
C
C     EXAMPLE--CONSUL MAXIMUM LIKELIHOOD Y
C            --CONSUL MAXIMUM LIKELIHOOD Y X
C     REFERENCES--CONSUL AND FAMOYE (2006), "LAGRANGIAN PROBABILITY
C                 DISTRIBUTIONS", BIRKHAUSER, CHAPTER 8.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2855
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2006/8
C     ORIGINAL VERSION--AUGUST    2006.
C     UPDATED         --APRIL     2011. USE DPDTA1 AND DPDTA5 TO PRINT
C                                       OUTPUT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-----------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ICONDF
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*4 ISUBN0
      CHARACTER*4 IRELAT
      CHARACTER*4 IRHSTG
C
C-------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION TEMP1(*)
      DIMENSION TEMP2(*)
      DIMENSION TEMP3(*)
      DOUBLE PRECISION DTEMP1(*)
C
      DOUBLE PRECISION TOL
      DOUBLE PRECISION XPAR(2)
      DOUBLE PRECISION FVEC(2)
C
      DOUBLE PRECISION AE
      DOUBLE PRECISION RE
      DOUBLE PRECISION XLOW
      DOUBLE PRECISION XUP
      DOUBLE PRECISION XMID
      DOUBLE PRECISION DALPHA
C
      DOUBLE PRECISION CONFUN
      DOUBLE PRECISION CONFU2
      EXTERNAL CONFUN
      EXTERNAL CONFU2
      DOUBLE PRECISION XBAR
      DOUBLE PRECISION S2
      DOUBLE PRECISION F1FREQ
      COMMON/CONCOM/XBAR,S2,F1FREQ,MAXRO2,NTOT2
C
      PARAMETER (MAXROW=30)
      CHARACTER*60 ITITLE
      CHARACTER*1  ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 IDIST
      CHARACTER*40 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(MAXROW)
      CHARACTER*4  VALIGN(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL      IFRST
      LOGICAL      ILAST
C
C-------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT---------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='CN  '
C
      IERROR='NO'
      IWRITE='OFF'
C
      AMUMOM=CPUMIN
      AMMOM=CPUMIN
      AMUFR=CPUMIN
      AMFR=CPUMIN
      AMUML=CPUMIN
      AMML=CPUMIN
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLCN')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLCN--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,ICONDF,N,NVAR
   52   FORMAT('IBUGA3,ISUBRO,ICONDF,N,NVAR = ',3(A4,2X),2I8)
        CALL DPWRST('XXX','WRIT')
        IF(NVAR.EQ.1)THEN
          DO56I=1,MIN(N,100)
            WRITE(ICOUT,57)I,Y(I)
   57       FORMAT('I,Y(I) = ',I8,G15.7)
            CALL DPWRST('XXX','WRIT')
   56     CONTINUE
        ELSE
          DO61I=1,N
            WRITE(ICOUT,62)I,X(I),Y(I)
   62       FORMAT('I,X(I),Y(I) = ',I8,2G15.7)
            CALL DPWRST('XXX','WRIT')
   61     CONTINUE
        ENDIF
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  1) ROUND DATA TO INTEGER VALUES       **
C               **  2) COMPUTE SUMMARY STATISTICS         **
C               **  3) CHECK INPUT FOR NEGATIVE VALUES,   **
C               **     INSUFFICIENT SAMPLE SIZE           **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLGS')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IDIST='CONSUL'
C
      NPERC=0
      MAXGRP=MAXNXT/2
      NMIN=2
      IF(NVAR.EQ.1)THEN
        DO1105I=1,N
          ITEMP=INT(Y(I)+0.5)
          Y(I)=REAL(ITEMP)
 1105   CONTINUE
        CALL CKDIST(Y,N,NMIN,TEMP1,NPERC,ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
        IFLAG=1
        CALL SUMRAW(Y,N,IDIST,IFLAG,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        NTOTZZ=N
C
C       NOW BIN THE DATA FOR USE BY THE ESTIMATION METHOD BELOW
C
        IRELAT='OFF'
        IRHSTG='OFF'
        XSTART=XMIN-0.5
        XSTOP=XMAX+0.5
        CLWID=1.0
        CALL DPBINI(Y,N,IRELAT,CLWID,XSTART,XSTOP,IRHSTG,
     1              TEMP1,X,N2,IBUGA3,IERROR)
        ICNT=0
        DO1121I=1,N2
          Y(I)=TEMP1(I)
          ICNT=ICNT+1
          Y(ICNT)=Y(I)
          X(ICNT)=X(I)
1121    CONTINUE
        N2=ICNT
      ELSE
        CALL CKDIS2(Y,X,TEMP1,N,MAXGRP,NMIN,TEMP2,NPERC,NTOTZZ,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IFLAG1=1
        IFLAG2=1
        CALL SUMGRP(Y,X,N,IDIST,IFLAG1,IFLAG2,
     1              TEMP1,TEMP2,TEMP3,MAXNXT,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ,
     1              ISUBRO,IBUGA3,IERROR)
        N2=N
      ENDIF
      IF(IERROR.EQ.'YES')GOTO9000
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLCN')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1311)
 1311   FORMAT('AFTER COMPUTE SUMMARY STATISTICS--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1312)XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ
 1312   FORMAT('XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ = ',5G15.7,I10)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
C               *********************************************
C               **  STEP 21--                              **
C               **  CARRY OUT CALCULATIONS                 **
C               **  FOR CONSUL MLE                         **
C               **  ESTIMATION                             **
C               *********************************************
C
 2100 CONTINUE
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLCN')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      F1=Y(1)/REAL(NTOTZZ)
      IINDX=MAXNXT/2
      IF(N2.LE.IINDX)THEN
        IML=0
        DO2210I=1,N2
          TEMP3(I)=Y(I)
          TEMP3(IINDX+I)=X(I)
 2210   CONTINUE
        IK=N2
      ELSE
        IML=1
      ENDIF
C
      XBAR=XMEAN
      ACUTLO=XBAR*(XBAR-1.0)
      ACUTHI=XBAR**2*(XBAR-1.0)
CCCCC IF(AVAR.GE.ACUTHI)THEN
CCCCC   WRITE(ICOUT,999)
CCCCC   CALL DPWRST('XXX','WRIT')
CCCCC   WRITE(ICOUT,1111)
CCCCC   CALL DPWRST('XXX','WRIT')
CCCCC   WRITE(ICOUT,2223)
C2223   FORMAT('      FOR THIS DATA SET')
CCCCC   CALL DPWRST('XXX','WRIT')
CCCCC   WRITE(ICOUT,2224)
C2224   FORMAT('         S**2 >= XBAR**2*(XBAR - 1)')
CCCCC   CALL DPWRST('XXX','WRIT')
CCCCC   WRITE(ICOUT,2226)
C2226   FORMAT('      IN THIS CASE, THE CONSUL DISTRIBUTION IS ',
CCCCC1         'NOT APPLICABLE.')
CCCCC   CALL DPWRST('XXX','WRIT')
CCCCC   WRITE(ICOUT,2227)
C2227   FORMAT('      IT IS RECOMMENDED THAT YOU TRY FITTING THE ',
CCCCC1         'GEETA DISTRIBUTION.')
CCCCC   CALL DPWRST('XXX','WRIT')
CCCCC   WRITE(ICOUT,2228)AMEAN
C2228   FORMAT('      SAMPLE MEAN     = ',G15.7)
CCCCC   CALL DPWRST('XXX','WRIT')
CCCCC   WRITE(ICOUT,2229)AVAR
C2229   FORMAT('      SAMPLE VARIANCE = ',G15.7)
CCCCC   CALL DPWRST('XXX','WRIT')
CCCCC   GOTO9000
CCCCC ENDIF
C
CCCCC IF(AVAR.LT.ACUTLO)THEN
CCCCC   WRITE(ICOUT,999)
CCCCC   CALL DPWRST('XXX','WRIT')
CCCCC   WRITE(ICOUT,1111)
CCCCC   CALL DPWRST('XXX','WRIT')
CCCCC   WRITE(ICOUT,2233)
C2233   FORMAT('      FOR THIS DATA SET')
CCCCC   CALL DPWRST('XXX','WRIT')
CCCCC   WRITE(ICOUT,2234)
C2234   FORMAT('         S**2 < XBAR*(XBAR - 1)')
CCCCC   CALL DPWRST('XXX','WRIT')
CCCCC   WRITE(ICOUT,2235)
C2235   FORMAT('      IN THIS CASE, THE CONSUL DISTRIBUTION IS ',
CCCCC1         'NOT APPLICABLE.')
CCCCC   CALL DPWRST('XXX','WRIT')
CCCCC   WRITE(ICOUT,2237)
C2237   FORMAT('      NOTE THAT THE GEETA DISTRIBUTION IS ALSO ',
CCCCC1         'NOT APPLICABLE.')
CCCCC   CALL DPWRST('XXX','WRIT')
CCCCC   WRITE(ICOUT,2238)AMEAN
C2238   FORMAT('      SAMPLE MEAN     = ',G15.7)
CCCCC   CALL DPWRST('XXX','WRIT')
CCCCC   WRITE(ICOUT,2239)AVAR
C2239   FORMAT('      SAMPLE VARIANCE = ',G15.7)
CCCCC   CALL DPWRST('XXX','WRIT')
CCCCC   GOTO9000
CCCCC ENDIF
C
      AMUMOM=XMEAN
      AMMOM=XMEAN*(XMEAN-1.0)**2/(XMEAN**2*(XMEAN-1.0)-XVAR)
      AMUFR=XMEAN
      AMUML=XMEAN
C
      AE=1.D-7
      RE=1.D-7
      XBAR=DBLE(XMEAN)
      S2=DBLE(XSD)**2
      F1FREQ=DBLE(F1)
      IF(AMMOM.LE.1.0)THEN
        AMMOM=1.5
      ELSE
        XMID=DBLE(AMMOM)
      ENDIF
      XLOW=1.000001D0
      XUP=XMID + 10.0D0
      CALL DFZERO(CONFUN,XLOW,XUP,XMID,RE,AE,IFLAG)
      AMFR=REAL(XLOW)
C
      IOPT=2
      TOL=1.0D-5
      NPAR=1
      NPRINT=-1
      INFO=0
      LWA=MAXNXT
      MAXRO2=MAXNXT
      NTOT2=NTOTZZ
C
      IF(AMMOM.LE.1.0)THEN
        XPAR(1)=DBLE(AMFR)
        IF(XPAR(1).LE.1.0D0)XPAR(1)=1.5D0
      ELSE
        XPAR(1)=DBLE(AMMOM)
      ENDIF
      CALL DNSQE(CONFU2,JAC,IOPT,NPAR,XPAR,FVEC,TOL,NPRINT,INFO,
     1             DTEMP1,LWA,TEMP3,IK)
C
      AMML=REAL(XPAR(1))
C
C               ***********************************************
C               **   STEP 42--                               **
C               **   WRITE OUT EVERYTHING                    **
C               **   FOR CONSUL MLE                          **
C               **   ESTIMATION                              **
C               ***********************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLCN')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     PRINT SUMMARY STATISTICS TABLE
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Consul Parameter Estimation'
      NCTITL=43
      ITITLZ=' '
      NCTITZ=0
C
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(NTOTZZ)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample First Frequency:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=F1
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Method of Moments:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      IF(ICONDF.EQ.'THET')THEN
        ITEXT(ICNT)='Estimate of Theta:'
        NCTEXT(ICNT)=18
      ELSE
        ITEXT(ICNT)='Estimate of Mu:'
        NCTEXT(ICNT)=15
      ENDIF
      AVALUE(ICNT)=AMUMOM
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of M:'
      NCTEXT(ICNT)=14
      AVALUE(ICNT)=AMMOM
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Method of First Frequency and Mean:'
      NCTEXT(ICNT)=35
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      IF(ICONDF.EQ.'THET')THEN
        ITEXT(ICNT)='Estimate of Theta:'
        NCTEXT(ICNT)=18
      ELSE
        ITEXT(ICNT)='Estimate of Mu:'
        NCTEXT(ICNT)=15
      ENDIF
      ITEXT(ICNT)='Estimate of Theta:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=AMUFR
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of M:'
      NCTEXT(ICNT)=14
      AVALUE(ICNT)=AMFR
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Method of Maximum Likelihood:'
      NCTEXT(ICNT)=29
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      IF(ICONDF.EQ.'THET')THEN
        ITEXT(ICNT)='Estimate of Theta:'
        NCTEXT(ICNT)=18
      ELSE
        ITEXT(ICNT)='Estimate of Mu:'
        NCTEXT(ICNT)=15
      ENDIF
      AVALUE(ICNT)=AMUML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of M:'
      NCTEXT(ICNT)=14
      AVALUE(ICNT)=AMML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      NUMROW=ICNT
      DO2310I=1,NUMROW
        NTOT(I)=15
 2310 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLCN')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLCN--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9013)AMUMOM,AMMOM,AMUFR,AMFR,AMUML,AMML
 9013   FORMAT('AMUMOM,AMMOM,AMUFR,AMFR,AMUML,AMML = ',6G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLDE(Y,N,
     1                  XTEMP,MAXNXT,
     1                  ALOC,SCALE,ALOCSE,SCALESE,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR THER DOUBLE EXPONENTIAL DISTRIBUTION
C     EXAMPLE--DOUBLE EXPONENTIAL MAXIMUM LIKELIHOOD Y
C     REFERENCE--XX
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--98/6
C     ORIGINAL VERSION--JUNE      1998.
C     UPDATED         --MARCH     2004.
C     UPDATED         --FEBRUARY  2005. SOME CHANGES IN THE OUTPUT
C                                       FORMAT
C     UPDATED         --MAY       2005. ADD CONFIDENCE INTERVALS FOR
C                                       LOCATION AND SCALE PARAMETERS
C     UPDATED         --JUNE      2010. USE DPDTA1 AND DPDTA7 TO
C                                       PRINT OUTPUT, ADD AIC AND
C                                       RELATED STATISTICS TO OUTPUT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      DOUBLE PRECISION DSUM
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*1 IBASLC
      CHARACTER*4 INORM
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION XTEMP(*)
      DIMENSION QP(1)
C
      PARAMETER (NUMALP=6)
      DIMENSION ALPHA(NUMALP)
      DIMENSION ALOWSC(NUMALP)
      DIMENSION AUPPSC(NUMALP)
      DIMENSION ALOWLO(NUMALP)
      DIMENSION AUPPLO(NUMALP)
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=50)
      CHARACTER*60 ITITLE
      CHARACTER*1  ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(NUMALP)
      CHARACTER*4  VALIGN(NUMALP)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
C
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA ALPHA /0.50, 0.25, 0.10, 0.05, 0.01, 0.001/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='DE  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLDE')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLDE--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)N,IBUGA3
   55   FORMAT('N,IBUGA3 = ',I8,2X,A4)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLDE')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NPERC=0
      NMIN=2
      CALL CKDIST(Y,N,NMIN,QP,NPERC,ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C               **********************************
C               **  STEP 41--                   **
C               **  CARRY OUT CALCULATIONS      **
C               **  FOR DOUBLE EXPONENTIAL MLE  **
C               **  ESTIMATE (FULL SAMPLE CASE) **
C               **********************************
C
 4100 CONTINUE
C
      ISTEPN='41'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLDE')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IERROR='NO'
      IWRITE='OFF'
      ICASE=1
C
      CALL DEXML1(Y,N,XTEMP,ICASE,MAXNXT,
     1            ALOWLO,AUPPLO,ALOWSC,AUPPSC,
     1            ALPHA,NUMALP,NUMOUT,
     1            XMEAN,XMED,XSD,XMIN,XMAX,
     1            ALOC,SCALE,
     1            ISUBRO,IBUGA3,IERROR)
C
      CALL DEXLI1(Y,N,ALOC,SCALE,
     1            ALIK,AIC,AICC,BIC,
     1            ISUBRO,IBUGA3,IERROR)
C
      IF(IPRINT.EQ.'OFF')GOTO8000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Double Exponential Parameter Estimation'
      NCTITL=39
      ITEXT(1)='Summary Statistics:'
      NCTEXT(1)=19
      AVALUE(1)=0.0
      IDIGIT(1)=-1
      ITEXT(2)='Number of Observations:'
      NCTEXT(2)=23
      AVALUE(2)=REAL(N)
      IDIGIT(2)=0
      ICNT=3
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Maximum Likelihood Estimation Method:'
      NCTEXT(ICNT)=37
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Location Parameter:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=ALOC
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Scale Parameter:'
      NCTEXT(ICNT)=16
      AVALUE(ICNT)=SCALE
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Log-likelihood:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=ALIK
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)='AIC:'
      NCTEXT(ICNT)=4
      AVALUE(ICNT)=AIC
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)='AICc:'
      NCTEXT(ICNT)=5
      AVALUE(ICNT)=AICC
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)='BIC:'
      NCTEXT(ICNT)=4
      AVALUE(ICNT)=BIC
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      NUMROW=ICNT
      DO2310I=1,NUMROW
        NTOT(I)=15
 2310 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.FALSE.
      NCTITZ=0
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,
     1            NCTEXT,AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
      IFRST=.FALSE.
      ITITLE=' '
      NCTITL=0
C
      INORM='YES'
      CALL DPDTA7(ALOWLO,AUPPLO,ALOWSC,AUPPSC,ALPHA,NUMALP,
     1            ICAPSW,ICAPTY,NUMDIG,INORM,
     1            ISUBRO,IBUGA3,IERROR)
C
C
 8000 CONTINUE
C
      IF(IFEEDB.EQ.'ON')THEN
        WRITE(ICOUT,4141)
 4141   FORMAT('THE LOCATION AND SCALE PARAMETERS WILL BE SAVED AS')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4143)
 4143   FORMAT(6X,'THE INTERNAL PARAMETERS LOCML AND SCALEML.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'OFF'.AND.ISUBRO.NE.'MLDE')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPMLDE--')
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012 FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,9015)N
 9015 FORMAT('N = ',I8)
      CALL DPWRST('XXX','WRIT')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPMLDL(Y,X,N,NVAR,
     1                  TEMP1,TEMP2,TEMP3,MAXNXT,
     1                  THETML,THETSE,
     1                  AIC,AICC,BIC,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR LOGARITHMIC SERIES DISTRIBUTION
C              THE MAXIMUM LIKELIHOOD ESTIMATE OF THETA IS THE
C              SOLUTION TO THE EQUATION:
C                 XBAR = THETAHAT/[-(1-THETAHAT)LN(1-THETAHAT)
C              BOUNDS FOR THETAHAT ARE:
C                [(9*XBAR-6)-SQRT(9*XBAR**2-12*XBAR+12)]/(6*XBAR-2)
C                         <= THETAHAT  <=
C                [(6*XBAR-3)-SQRT(24*XBAR**2-24*XBAR+9)]/XBAR
C              THE ASYMPTOTIC VARIANCE OF THETAHAT IS:
C                 (1/N)*THETA**2/U2)
C              WITH U2 DENOTING THE VARIANCE OF THE LOGARITMIC
C              SERIES DISTRIBUTION:
C                 U2 = A*THETA(1-A*THETA)/(1-THETA)**2
C                  A = -1/LN(1-THETA)
C              THE SAMPLE VARIANCE AND THETAHAT ARE USED TO
C              COMPUTE AN ESTIMATE OF THIS ASYMPTOTIC VARIANCE.
C     EXAMPLE--LOGARITHMIC SERIES MAXIMUM LIKELIHOOD Y
C     REFERENCE--"UNIVARIATE DISCRETE DISTRIBUTIONS", SECOND EDITION,
C                JOHNSON, KOTZ, AND KEMP, WILEY, 1992, CHAPTER 7.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004/3
C     ORIGINAL VERSION--MARCH     2004.
C     UPDATED         --APRIL     2011. USE DPDTA1 TO PRINT THE OUTPUT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*4 IBASLC
C
      REAL     DLGFU2
      EXTERNAL DLGFU2
      REAL XMEAN
      COMMON/DLGCOM/XMEAN
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION TEMP1(*)
      DIMENSION TEMP2(*)
      DIMENSION TEMP3(*)
C
      PARAMETER (NUMALP=5)
      DIMENSION ALPHA(NUMALP)
      DIMENSION ALOWTH(NUMALP)
      DIMENSION AUPPTH(NUMALP)
C
      PARAMETER (MAXROW=20)
      CHARACTER*60 ITITLE
      CHARACTER*1  ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 IDIST
      CHARACTER*40 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(MAXROW)
      CHARACTER*4  VALIGN(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL      IFRST
      LOGICAL      ILAST
C
      PARAMETER(NUMCLI=3)
      PARAMETER(MAXLIN=2)
      CHARACTER*60 ITITL2(MAXLIN,NUMCLI)
      INTEGER      NCTIT2(MAXLIN,NUMCLI)
      INTEGER      IWHTML(NUMALP)
      INTEGER      IWRTF(NUMALP)
      REAL         AMAT(MAXROW,NUMCLI)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      DATA ALPHA /0.50, 0.25, 0.10, 0.05, 0.01/
C
      ISUBN1='DPML'
      ISUBN2='DL  '
C
      IERROR='NO'
      IWRITE='OFF'
C
      THETA=CPUMIN
      ASYMVA=CPUMIN
      AIC=CPUMIN
      AICC=CPUMIN
      BIC=CPUMIN
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLDL')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLDL--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N,NVAR
   52   FORMAT('IBUGA3,ISUBRO,N,NVAR = ',2(A4,2X),2I8)
        CALL DPWRST('XXX','WRIT')
        IF(NVAR.EQ.1)THEN
          DO56I=1,MIN(N,100)
            WRITE(ICOUT,57)I,Y(I)
   57       FORMAT('I,Y(I) = ',I8,G15.7)
            CALL DPWRST('XXX','WRIT')
   56     CONTINUE
        ELSE
          DO61I=1,N
            WRITE(ICOUT,62)I,X(I),Y(I)
   62       FORMAT('I,X(I),Y(I) = ',I8,2G15.7)
            CALL DPWRST('XXX','WRIT')
   61     CONTINUE
        ENDIF
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  1) ROUND DATA TO INTEGER VALUES       **
C               **  2) COMPUTE SUMMARY STATISTICS         **
C               **  3) CHECK INPUT FOR NEGATIVE VALUES,   **
C               **     INSUFFICIENT SAMPLE SIZE           **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLDL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IDIST='LOGARITHMIC SERIES'
C
      NPERC=0
      MAXGRP=MAXNXT/2
      NMIN=2
      IF(NVAR.EQ.1)THEN
        DO1105I=1,N
          ITEMP=INT(Y(I)+0.5)
          Y(I)=REAL(ITEMP)
 1105   CONTINUE
        CALL CKDIST(Y,N,NMIN,TEMP1,NPERC,ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
        IFLAG=1
        CALL SUMRAW(Y,N,IDIST,IFLAG,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        NTOTZZ=N
C
      ELSE
        CALL CKDIS2(Y,X,TEMP1,N,MAXGRP,NMIN,TEMP2,NPERC,NTOTZZ,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IFLAG1=1
        IFLAG2=1
        CALL SUMGRP(Y,X,N,IDIST,IFLAG1,IFLAG2,
     1              TEMP1,TEMP2,TEMP3,MAXNXT,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
      ENDIF
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLDL')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1151)
 1151   FORMAT('AFTER COMPUTE SUMMARY STATISTICS--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1152)XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ
 1152   FORMAT('XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ = ',5G15.7,I10)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
C               ******************************************
C               **  STEP 21--                           **
C               **  CARRY OUT CALCULATIONS              **
C               **  FOR LOGARITHMIC SERIES MLE ESTIMATE **
C               ******************************************
C
 2100 CONTINUE
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLDL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      TERM1=9.0*XMEAN-6.0
      TERM2=SQRT(9.0*XMEAN*XMEAN - 12.0*XMEAN + 12.0)
      TERM3=6.0*XMEAN - 2.0
      XLOWLI=(TERM1-TERM2)/TERM3
      TERM1=6.0*XMEAN-3.0
      TERM2=SQRT(24.0*XMEAN*XMEAN - 24.0*XMEAN + 9.0)
      TERM3=XMEAN
      XUPPLI=(TERM1-TERM2)/TERM3
C
      AE=1.E-6
      RE=1.E-6
      IFLAG=0
      THETA2=(XLOWLI+XUPPLI)/2.0
      CALL FZERO(DLGFU2,XLOWLI,THETA2,XUPPLI,RE,AE,IFLAG)
C
      THETML=XLOWLI
      A=-1.0/(LOG(1.0-THETML))
      DVARI=A*THETML*(1.0-A*THETML)/(1.0-THETML)**2
      ASYMVA=(1.0/REAL(NTOTZZ))*(THETML**2/DVARI)
      THETSE=SQRT(ASYMVA)
C
      IF(IFLAG.EQ.2)THEN
C
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2211)
 2211   FORMAT('***** WARNING FROM LOGARITHMIC SERIES MAXIMUM ',
     1         'LIKELIHOOD--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2213)
 2213   FORMAT('      ESTIMATE OF THETA VALUE MAY NOT BE COMPUTED ',
     1         'TO DESIRED TOLERANCE.')
        CALL DPWRST('XXX','BUG ')
      ELSEIF(IFLAG.EQ.3)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2211)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2223)
 2223   FORMAT('      ESTIMATE OF THETA MAY BE NEAR A SINGULAR POINT.')
        CALL DPWRST('XXX','BUG ')
      ELSEIF(IFLAG.EQ.4)THEN
CCCCC   WRITE(ICOUT,999)
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   WRITE(ICOUT,2231)
C2231   FORMAT('***** ERROR FROM LOGARITHMIC SERIES MAXIMUM ',
CCCCC1         'LIKELIHOOD--')
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   WRITE(ICOUT,2233)
C2233   FORMAT('      APPROPRIATE BRACKETING INTERVAL NOT FOUND.')
CCCCC   CALL DPWRST('XXX','BUG ')
      ELSEIF(IFLAG.EQ.5)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2211)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2243)
 2243   FORMAT('      MAXIMUM ITERATIONS EXCEEDED.')
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      DO2290I=1,NUMALP
        ALP=ALPHA(I)
        P1=ALP/2.0
        P2=1.0-(ALP/2.0)
        CALL NORPPF(P1,APPF1)
        CALL NORPPF(P2,APPF2)
        ALOWTH(I)=THETML + APPF1*THETSE
        AUPPTH(I)=THETML + APPF2*THETSE
        IF(ALOWTH(I).LT.0.0)ALOWTH(I)=0.0
        IF(AUPPTH(I).GT.1.0)AUPPTH(I)=1.0
 2290 CONTINUE
C
C               ********************************************
C               **   STEP 42--                            **
C               **   WRITE OUT EVERYTHING                 **
C               **   FOR LOGARITHMIC SERIES MLE ESTIMATE  **
C               ********************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLDL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     PRINT SUMMARY STATISTICS TABLE
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Logarithmic Series Parameter Estimation'
      NCTITL=39
      ITITLZ=' '
      NCTITZ=0
C
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(NTOTZZ)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Maximum Likelihood (= Moment) Estimates:'
      NCTEXT(ICNT)=40
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Theta:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=THETML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Asymptotic Standard Error of Theta:'
      NCTEXT(ICNT)=35
      AVALUE(ICNT)=THETSE
      IDIGIT(ICNT)=NUMDIG
C
      NUMROW=ICNT
      DO2310I=1,NUMROW
        NTOT(I)=15
 2310 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
C     NORMAL APPROXIMATION MAY NOT BE RELIABLE FOR N < 9 OR
C     THETA > 0.9.  SO FOR THESE CASES, DO NOT PRINT THE
C     CONFIDENCE INTERVALS.
C
      IF(NTOTZZ.LT.9 .OR. THETML.GT.0.9)GOTO9000
C
      ITITLE(1:43)='Confidence Interval (normal approximation) '
      ITITLE(44:52)='for Theta'
      NCTITL=52
      NUMLIN=2
      NUMCOL=3
      ITITL2(1,1)='Confidence'
      ITITL2(2,1)='Coefficient'
      ITITL2(1,2)='Lower'
      ITITL2(2,2)='Limit'
      ITITL2(1,3)='Upper'
      ITITL2(2,3)='Limit'
      NCTIT2(1,1)=10
      NCTIT2(2,1)=11
      NCTIT2(1,2)=5
      NCTIT2(2,2)=5
      NCTIT2(1,3)=5
      NCTIT2(2,3)=5
      NMAX=0
      DO2521I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        NMAX=NMAX+NTOT(I)
        IDIGIT(I)=NUMDIG
 2521 CONTINUE
      IDIGIT(1)=2
      DO2523I=1,NUMALP
        NCTEXT(I)=0
        AMAT(I,1)=100.0*(1.0 - ALPHA(I))
        AMAT(I,2)=ALOWTH(I)
        AMAT(I,3)=AUPPTH(I)
 2523 CONTINUE
      IWHTML(1)=150
      IWHTML(2)=150
      IWHTML(3)=150
      IWHTML(4)=150
      IWRTF(1)=2000
      IWRTF(2)=IWRTF(1)+2000
      IWRTF(3)=IWRTF(2)+2000
      IFRST=.FALSE.
      ILAST=.TRUE.
C
      CALL DPDTA2(ITITL9,NCTIT9,
     1            ITITLE,NCTITL,ITITL2,NCTIT2,
     1            MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1            ITEXT,NCTEXT,AMAT,MAXROW,NUMALP,
     1            IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1            ICAPSW,ICAPTY,IFRST,ILAST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLDL')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLDL--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)THETA,THETSE
 9012   FORMAT('THETA,THETSE = ',2G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLE1(Y,N,ICASPL,
     1                  XTEMP,MAXNXT,
     1                  XMIN,SCALE,SCALE2,NUMV,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  QP,XQPHAT,XQPLCL,XQPUCL,NPERC,
     1                  XQPHTZ,XQPLCZ,XQPUCZ,XQPSE,
     1                  IOUNI1,IOUNI2,ALPHAP,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR EXPONENTIAL DISTRIBUTION
C              FOR THE FULL SAMPLE CASE.
C
C              NOTE THAT THE USER CAN SPECIFY EITHER THE
C              "1-PARAMETER" MODEL (LOCATION = 0) OR THE
C              "2-PARAMETER" MODEL.
C     EXAMPLE--EXPONENTIAL MAXIMUM LIKELIHOOD Y
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN
C                ENGINEERING", CAMBRIDGE UNIVERSITY PRESS,
C                1999, CHAPTER 12.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--98/3
C     ORIGINAL VERSION--MARCH     1998.
C     UPDATED         --OCTOBER   2003. SUPPORT FOR HTML/LATEX OUTPUT
C     UPDATED         --OCTOBER   2004. SUPPORT FOR BOTH TIME AND
C                                       NUMBER OF FAILURES CENSORING,
C                                       MULTIPLY CENSORED DATA FOR
C                                       TIME CENSORED DATA
C     UPDATED         --OCTOBER   2004. CONFIDENCE INTERVALS FOR
C                                       SELECT PERCENTILES
C     UPDATED         --OCTOBER   2004. SPLIT FULL CASE OUT FROM
C                                       CENSORED CASE
C     UPDATED         --JUNE      2010. USE DPDTA1, DPDTA7, DPDTA9 TO
C                                       PRINT OUTPUT, ADD AIC AND
C                                       RELATED STATISTICS TO OUTPUT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ICASE2
      CHARACTER*4 INORM
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      PARAMETER (NUMALP=6)
      DIMENSION ALPHA(NUMALP)
      DIMENSION ALOWLO(NUMALP)
      DIMENSION AUPPLO(NUMALP)
      DIMENSION ALOWSC(NUMALP)
      DIMENSION AUPPSC(NUMALP)
C
      DIMENSION Y(*)
      DIMENSION XTEMP(*)
      DIMENSION XQPHTZ(*)
      DIMENSION XQPLCZ(*)
      DIMENSION XQPUCZ(*)
      DIMENSION QP(*)
      DIMENSION XQPHAT(*)
      DIMENSION XQPLCL(*)
      DIMENSION XQPUCL(*)
      DIMENSION XQPSE(*)
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=50)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*40 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(NUMALP)
      CHARACTER*4  VALIGN(NUMALP)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C
      CHARACTER*4 ILIKFL
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA ALPHA /0.50, 0.25, 0.10, 0.05, 0.01, 0.001/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='E1  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLE1')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLE1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3
   52   FORMAT('IBUGA3 = ',A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)N,NUMV,NPERC
   55   FORMAT('N,NUMV,NPERC = ',3I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I)) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLE1')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NMIN=2
      CALL CKDIST(Y,N,NMIN,QP,NPERC,ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C               **********************************
C               **  STEP 41--                   **
C               **  CARRY OUT CALCULATIONS      **
C               **  FOR EXPONENTIAL MLE         **
C               **  ESTIMATE (FULL SAMPLE CASE) **
C               **********************************
C
 4100 CONTINUE
C
      ISTEPN='41'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLE1')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IERROR='NO'
      IWRITE='OFF'
      AN=REAL(N)
C
      ICASE2='2'
      IF(ICASPL.EQ.'1EXP')ICASE2='1'
      CALL EXPML1(Y,N,ICASE2,IEXPBC,
     1            ALOWLO,AUPPLO,ALOWSC,AUPPSC,ALPHA,
     1            NUMALP,NUMOUT,
     1            XMEAN,XSD,XVAR,XMIN,XMAX,
     1            ALOCML,ALOCSE,SCALML,SCALSE,
     1            ALOCBC,ALOBSE,SCABML,SCABSE,
     1            ISUBRO,IBUGA3,IERROR)
      IF(ICASPL.EQ.'1EXP')THEN
        ALOC=0.0
        SCALE=SCALML
        ALOWLO(1)=CPUMIN
      ELSE
         IF(IEXPBC.EQ.'OFF')THEN
           ALOC=ALOCML
           SCALE=SCALML
         ELSE
           ALOC=ALOCBC
           SCALE=SCABML
           ALOCSE=ALOBSE
           SCALSE=SCABSE
         ENDIF
      ENDIF
C
      CALL EXPLI1(Y,N,ICASPL,
     1            ALOC,SCALE,
     1            ALIK,AIC,AICC,BIC,
     1            ISUBRO,IBUGA3,IERROR)
C
      IF(NPERC.GE.1 .AND. ICASPL.EQ.'1EXP')THEN
C
        NU2=2*N
        ALPHL=ALPHAP/2.0
        ALPHU=1.0 - ALPHAP/2.0
        CALL CHSPPF(ALPHL,NU2,ACHSLL)
        CALL CHSPPF(ALPHU,NU2,ACHSUL)
C
        WRITE(IOUNI1,4131)
        WRITE(IOUNI1,4132)
        DO4119I=1,NPERC
          QPTEMP=QP(I)/100.0
          CALL EXPPPF(QPTEMP,APPF)
          XQPHAT(I)=SCALE*APPF
          SEXQP=APPF*SCALSE
          ATEMP1=APPF*2.0*AN*SCALE/ACHSUL
          ATEMP2=APPF*2.0*AN*SCALE/ACHSLL
          XQPLCL(I)=MIN(ATEMP1,ATEMP2)
          XQPUCL(I)=MAX(ATEMP1,ATEMP2)
C
          WRITE(IOUNI1,'(3E15.7,2X,E15.7)')
     1         QP(I),XQPHAT(I),XQPLCL(I),XQPUCL(I)
C
          IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLE1')THEN
            WRITE(ICOUT,4133)I,QP(I),XQPHTZ(I),SEXQP,APPF
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,4135)ACHSUL,ACHSLL,ATEMP1,ATEMP2
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,4137)XQPLCZ(I),XQPUCZ(I)
            CALL DPWRST('XXX','BUG ')
          ENDIF
C
 4119   CONTINUE
 4131   FORMAT(15X,'       POINT     ','     LOWER     ')
 4132   FORMAT('    PERCENTILE ','     ESTIMATE   ',
     1         'CONFIDENCE LIMIT ')
 4133       FORMAT('I,QP(I),XQPHAT(I),SEXQP,APPF = ',I8,4G15.7)
 4135       FORMAT('ACHSUL,ACHSLL,ATEMP1,ATEMP2 = ',4G15.7)
 4137       FORMAT('XQPLCL(I),XQPUCL(I) = ',2G15.7)
      ENDIF
C
C               **********************************************
C               **  STEP 41B--                              **
C               **  ESTIMATE CONFIDENCE LIMITS FOR SELECTED **
C               **  PERCENTILES.  THE CONFIDENCE LIMITS ON  **
C               **  SIGMA ARE (SL,SU) ARE:                  **
C               **  (2*N*SIGMAHAT/CHSPPF(2N,1-ALPHA/2),     **
C               **   2*N*SIGMAHAT/CHSPPF(2N,1-ALPHA/2))     **
C               **  THEN (XpLCL,XpUCL) IS:                  **
C               **  ((-LN(1 - Xp))*SL,(-LN(1 - Xp))*SU)     **
C               **********************************************
C
      ISTEPN='41B'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLNO')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C  NOTE: USE APPROXIMATION FOR LOWER LIMIT GIVEN ON PP. 190-191 OF BURY.
C
      IF(NPERC.GE.1 .AND. ICASPL.EQ.'EXPO')THEN
C
        DSUM1=0.0D0
        DO4140I=1,N
          DSUM1=DSUM1 + DBLE(Y(I))
 4140   CONTINUE
        DS=DSUM1 - DBLE(AN*Y(1))
C
        D1N=DBLE(1.0/AN)
        DN=DBLE(AN)
        D2N=DBLE(1.0D0/(AN-1.0))
        DALPH=DBLE(ALPHAP)
        ALPHL=ALPHAP/2.0
        ALPHU=1.0 - ALPHAP/2.0
C
        WRITE(IOUNI2,4131)
        WRITE(IOUNI2,4132)
C
C       NOT SURE IF FORMULA FOR UPPER CL IS CORRECT, SO ONLY
C       GENERATE LOWER LIMIT FOR NOW.
C
        DO4130I=1,NPERC
          QPTEMP=QP(I)/100.0
          CALL EXPPPF(QPTEMP,APPF)
          XQPHAT(I)=ALOC + SCALE*APPF
          DAK=D1N*(1.0D0 - (DBLE(1.0D0 - QPTEMP)**DN/DALPH)**D2N)
CCCCC     DAK=D1N*(1.0D0 - (DBLE(1.0D0 - QPTEMP)**DN/DBLE(ALPHL))**D2N)
          XQPLCL(I)=Y(1) + REAL(DAK*DS)
CCCCC     DAK=D1N*(1.0D0 - (DBLE(1.0D0 - QPTEMP)**DN/DBLE(ALPHU))**D2N)
          XQPUCL(I)=CPUMIN
CCCCC     XQPUCL(I)=Y(1) + REAL(DAK*DS)
          WRITE(IOUNI2,'(4E15.7)')
     1         QP(I),XQPHAT(I),XQPLCL(I)
CCCCC1         QP(I),XQPHAT(I),XQPLCL(I),XQPUCL(I)
C
          IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLE3')THEN
            WRITE(ICOUT,44133)I,QP(I),XQPHAT(I),DS,DAK
44133       FORMAT('I,QP(I),XQPHAT(I),DS,DAK = ',I8,4G15.7)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,44137)XQPLCL(I)
44137       FORMAT('XQPLCL(I) = ',2G15.7)
            CALL DPWRST('XXX','BUG ')
          ENDIF
C
 4130   CONTINUE
      ENDIF
C
C               *************************************
C               **   STEP 42--                     **
C               **   WRITE OUT EVERYTHING          **
C               **   FOR EXPONENTIAL MLE ESTIMATE  **
C               *************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLE1')
     1  CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      IF(ICASPL.EQ.'1EXP')THEN
        ITITLE='1-Parameter Exponential Parameter Estimation'
        NCTITL=44
        ITITLZ=' '
        NCTITZ=0
      ELSE
        ITITLE='2-Parameter Exponential Parameter Estimation'
        NCTITL=44
        IF(IEXPBC.EQ.'ON')THEN
          ITITLZ='(with Bias Correction)'
          NCTITZ=22
        ELSE
          ITITLZ='(without Bias Correction)'
          NCTITZ=25
        ENDIF
      ENDIF
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(N)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Maximum Likelihood:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      IF(ICASPL.EQ.'EXPO')THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of Location:'
        NCTEXT(ICNT)=21
        AVALUE(ICNT)=ALOC
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Standard Error of Location:'
        NCTEXT(ICNT)=27
        AVALUE(ICNT)=ALOCSE
        IDIGIT(ICNT)=NUMDIG
      ENDIF
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Scale:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=SCALE
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Standard Error of Scale:'
      NCTEXT(ICNT)=24
      AVALUE(ICNT)=SCALSE
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Log-likelihood:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=ALIK
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)='AIC:'
      NCTEXT(ICNT)=4
      AVALUE(ICNT)=AIC
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)='AICc:'
      NCTEXT(ICNT)=5
      AVALUE(ICNT)=AICC
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)='BIC:'
      NCTEXT(ICNT)=4
      AVALUE(ICNT)=BIC
      IDIGIT(ICNT)=-7
C
      NUMROW=ICNT
      DO2320I=1,NUMROW
        NTOT(I)=15
 2320 CONTINUE
C
      IFRST=.FALSE.
      ILAST=.FALSE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
      IF(NUMOUT.GT.1)THEN
        INORM='OFF'
        CALL DPDTA7(ALOWLO,AUPPLO,ALOWSC,AUPPSC,ALPHA,NUMALP,
     1              ICAPSW,ICAPTY,NUMDIG,INORM,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
C
      IF(NPERC.GT.1)THEN
        ILIKFL='EXAC'
        XQPSE(1)=CPUMIN
        IF(ICASPL.EQ.'EXPO')THEN
          CALL DPDTA9(QP,XQPHAT,XQPLCL,XQPUCL,XQPSE,NPERC,
     l                ICAPSW,ICAPTY,ILIKFL,NUMDIG,ALPHAP,
     1                ISUBRO,IBUGA3,IERROR)
        ELSE
          CALL DPDTA9(QP,XQPHAT,XQPLCL,XQPUCL,XQPSE,NPERC,
     1                ICAPSW,ICAPTY,ILIKFL,NUMDIG,ALPHAP,
     1                ISUBRO,IBUGA3,IERROR)
        ENDIF
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLE1')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLE1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012   FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9015)N
 9015   FORMAT('N = ',I8)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLE2(Y,TAG,N,ICASPL,
     1                  XTEMP,MAXNXT,
     1                  XMIN,SCALML,SCALSE,NUMV,TEND,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  QP,XQPHAT,XQPSE,XQPLCL,XQPUCL,NPERC,
     1                  XQPHTZ,XQPLCZ,XQPUCZ,
     1                  IOUNI1,IOUNI2,ALPHAP,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR EXPONENTIAL DISTRIBUTION
C              FOR THE TIME CENSORED (TYPE I, EITHER SINGLY OR
C              MULTIPLY CENSORED) CASE.
C     EXAMPLE--EXPONENTIAL MAXIMUM LIKELIHOOD Y X
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN
C                ENGINEERING", CAMBRIDGE UNIVERSITY PRESS,
C                1999, CHAPTER 12.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--98/3
C     ORIGINAL VERSION--MARCH     1998.
C     UPDATED         --OCTOBER   2003. SUPPORT FOR HTML/LATEX OUTPUT
C     UPDATED         --OCTOBER   2004. SUPPORT FOR BOTH TIME AND
C                                       NUMBER OF FAILURES CENSORING,
C                                       MULTIPLY CENSORED DATA FOR
C                                       TIME CENSORED DATA
C     UPDATED         --OCTOBER   2004. CONFIDENCE INTERVALS FOR
C                                       SELECT PERCENTILES
C     UPDATED         --OCTOBER   2004. SPLIT FULL SAMPLE AND CENSORED
C                                       CASES INTO DISTINCT
C                                       SUBROUTINES
C     UPDATED         --JUNE      2010. USE DPDTA1, DPDTA7, DPDTA9 TO
C                                       PRINT OUTPUT, ADD AIC AND
C                                       RELATED STATISTICS TO OUTPUT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 IFORSW
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ILIKFL
      CHARACTER*4 INORM
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*4 ICASE
C
C---------------------------------------------------------------------
C
      PARAMETER (NUMALP=6)
      DIMENSION ALPHA(NUMALP)
      DIMENSION ALOWLO(NUMALP)
      DIMENSION AUPPLO(NUMALP)
      DIMENSION ALOWSC(NUMALP)
      DIMENSION AUPPSC(NUMALP)
      DIMENSION ALOWS2(NUMALP)
      DIMENSION AUPPS2(NUMALP)
C
      DIMENSION Y(*)
      DIMENSION TAG(*)
      DIMENSION XTEMP(*)
      DIMENSION XQPHTZ(*)
      DIMENSION XQPLCZ(*)
      DIMENSION XQPUCZ(*)
      DIMENSION QP(*)
      DIMENSION XQPHAT(*)
      DIMENSION XQPSE(*)
      DIMENSION XQPLCL(*)
      DIMENSION XQPUCL(*)
C
      DOUBLE PRECISION DN
      DOUBLE PRECISION D1N
      DOUBLE PRECISION D2R
      DOUBLE PRECISION DS
      DOUBLE PRECISION DAK
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DALPH
      DOUBLE PRECISION XLOW
      DOUBLE PRECISION XUP
C
      DOUBLE PRECISION AE
      DOUBLE PRECISION RE
C
      DOUBLE PRECISION DK
      DOUBLE PRECISION DR
      DOUBLE PRECISION SHAT
      DOUBLE PRECISION DXSUM
      DOUBLE PRECISION DC
      COMMON/EXPCOM/DK,DR,SHAT,DXSUM,DC
      DOUBLE PRECISION EXPFUN
      EXTERNAL EXPFUN
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=50)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*40 ITEXT(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C
      DATA ALPHA /0.50, 0.25, 0.10, 0.05, 0.01, 0.001/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='E1  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLE2')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLE2--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)N,NUMV,IBUGA3,ICENTY
   55   FORMAT('N,NUMV,NPERC,IBUGA3,ICENTY = ',3I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I),TAG(I)
   57     FORMAT('I,Y(I),TAG(I) = ',I8,2E15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLE2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NMIN=3
      CALL CKDIST(Y,N,NMIN,QP,NPERC,ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C               ********************************************
C               **  STEP 21--                             **
C               **  CHECK THE CENSORING VARIABLE: SHOULD  **
C               **  BE AT MOST 2 DISTINCT VALUES, 1       **
C               **  INDICATES FAILURE TIME, 0 INDICATES   **
C               **  CENSORING TIME.                       **
C               ********************************************
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLE2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL EXPML2(Y,TAG,N,ICASPL,ICASE,TEND,XTEMP,MAXNXT,
     1            XMEAN,XSD,XVAR,XMIN,XMAX,XSUM,
     1            ALOCML,ALOCSE,SCALML,SCALSE,
     1            IR,IM,AN,AR,AM,
     1            ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C               *************************************
C               **  STEP 41--                      **
C               **  GENERATE CONFIDENCE INTERVALS  **
C               **  FOR PARAMETERS AND PERCENTILES **
C               *************************************
C
      ISTEPN='41'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLE2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IERROR='NO'
      IWRITE='OFF'
C
C  ESTIMATES FOR 1-PARAMETER MODEL
C
      IF(ICASPL.EQ.'1EXP')THEN
        SHAT=DBLE(SCALML)
        DXSUM=DBLE(XSUM)
        DR=DBLE(IR)
        NUTEMP=1
        AE=1.D-7
        RE=1.D-7
        DC=2.0D0*(-DR*DLOG(SHAT) - DXSUM/SHAT)
C
        DO4110I=1,NUMALP
          ALP=ALPHA(I)
          P=1.0-(ALP/2.0)
          CALL NORPPF(P,ZP)
          CALL CHSPPF(1.0-ALP,NUTEMP,APPF)
          DK=DBLE(APPF)
C
C         NOW COMPUTE NORMAL APPROXIMATION INTERVAL (USE AS
C         STARTING VALUE FOR LIKELIHOOD RATIO METHOD).
C
          SLNOR=SCALML - ZP*SCALSE
          SUNOR=SCALML + ZP*SCALSE
C
C         NOW COMPUTE LIKELIHOOD RATIO BASED INTERVAL
C
CCCCC     XLOW=DBLE(XMIN)
          XLOW=DBLE(SLNOR)/3.0D0
          XUP=DBLE(SCALML)
          CALL DFZERO(EXPFUN,XLOW,XUP,DBLE(SLNOR),RE,AE,IFLAG)
          ALOWSC(I)=XLOW
          ALOWS2(I)=SLNOR
C
          XLOW=DBLE(SCALE)
          XUP=2.0D0*DBLE(SUNOR)
          CALL DFZERO(EXPFUN,XLOW,XUP,DBLE(SUNOR),RE,AE,IFLAG)
          AUPPSC(I)=XLOW
          AUPPS2(I)=SUNOR
 4110   CONTINUE
C
C               **********************************************
C               **  STEP 41A--                              **
C               **  ESTIMATE CONFIDENCE LIMITS FOR SELECTED **
C               **  PERCENTILES.  COMPUTE THE LOWER         **
C               **  CONFIDENCE INTERVAL GIVEN ON PP. 190-191**
C               **  OF BURY.  NOTE THAT THIS APPROXIMATION  **
C               **  IS FOR THE SINGLY CENSORED CASE ONLY.   **
C               **  NO FORMULA IS GIVEN FOR THE MULTIPLY    **
C               **  CENSORED CASE.  USE THE 2-PARAMETER     **
C               **  CASE WITH X(1) = 0.                     **
C               **********************************************
C
        ISTEPN='41A'
        IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLNO')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        IF(NPERC.GE.1)THEN
C
          DSUM1=0.0D0
          DO4112I=1,N
            DSUM1=DSUM1 + DBLE(Y(I))
 4112     CONTINUE
          DS=DSUM1 + DBLE(AN*XMIN)
C
          D1N=DBLE(1.0/AN)
          DN=DBLE(AN)
          DR=DBLE(AR)
          D2R=DBLE(1.0D0/(AR+0.5-1.0))
          DALPH=DBLE(ALPHAP)
          ALPHL=ALPHAP/2.0
          ALPHU=1.0 - ALPHAP/2.0
C
          WRITE(IOUNI1,4131)
          WRITE(IOUNI1,4132)
          DO4115I=1,NPERC
            QPTEMP=QP(I)/100.0
            CALL EXPPPF(QPTEMP,APPF)
            XQPHAT(I)=SCALML*APPF
            DAK=D1N*(1.0D0 - (DBLE(1.0D0 - QPTEMP)**DN/DALPH)**D2R)
            XQPLCL(I)=REAL(DAK*DS)
            WRITE(IOUNI1,'(3E15.7)')
     1           QP(I),XQPHAT(I),XQPLCL(I)
C
            IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLE2')THEN
              WRITE(ICOUT,4133)I,QP(I),XQPHAT(I),DS,DAK
              CALL DPWRST('XXX','BUG ')
              WRITE(ICOUT,4137)XQPLCL(I)
              CALL DPWRST('XXX','BUG ')
            ENDIF
C
 4115     CONTINUE
        ENDIF
      ELSE
C
C       2-PARAMETER MODEL
C
        UHAT=XMIN
        UHATSE=CPUMIN
C
        NU2=2*IR-1
        DO4125I=1,NUMALP
          ALP=ALPHA(I)
          P=1.0-(ALP/2.0)
          CALL CHSPPF(P,NU2,PPF3)
          P=ALP/2.0
          CALL CHSPPF(P,NU2,PPF4)
          ALOWSC(I)=2.0*AR*SCALML/PPF3
          AUPPSC(I)=2.0*AR*SCALML/PPF4
          ACONS1=(ALP/2.0)**(2.0/(1.0-2.0*AR)) - 1.0
          ACONS2=(1.0 - ALP/2.0)**(2.0/(1.0-2.0*AR)) - 1.0
          ATEMP1=XMIN - SCALML*(AR/AN)*ACONS1
          ATEMP2=XMIN - SCALML*(AR/AN)*ACONS2
          ALOWLO(I)=MIN(ATEMP1,ATEMP2)
          AUPPLO(I)=MAX(ATEMP1,ATEMP2)
 4125   CONTINUE
C
C               **********************************************
C               **  STEP 41B--                              **
C               **  ESTIMATE CONFIDENCE LIMITS FOR SELECTED **
C               **  PERCENTILES.  COMPUTE THE LOWER         **
C               **  CONFIDENCE INTERVAL GIVEN ON PP. 190-191**
C               **  OF BURY.  NOTE THAT THIS APPROXIMATION  **
C               **  IS FOR THE SINGLY CENSORED CASE ONLY.   **
C               **  NO FORMULA IS GIVEN FOR THE MULTIPLY    **
C               **  CENSORED CASE.                          **
C               **********************************************
C
        ISTEPN='41B'
        IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLNO')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        IF(NPERC.GE.1)THEN
C
          DSUM1=0.0D0
          DO4140I=1,N
            DSUM1=DSUM1 + DBLE(Y(I))
 4140     CONTINUE
          DS=DSUM1 - DBLE(AN*XMIN)
C
          D1N=DBLE(1.0/AN)
          DN=DBLE(AN)
          DR=DBLE(AR)
          D2R=DBLE(1.0D0/(AR+0.5-1.0))
          DALPH=DBLE(ALPHAP)
          ALPHL=ALPHAP/2.0
          ALPHU=1.0 - ALPHAP/2.0
C
          WRITE(IOUNI2,4131)
 4131     FORMAT(15X,'       POINT     ','     LOWER     ')
          WRITE(IOUNI2,4132)
 4132     FORMAT('    PERCENTILE ','     ESTIMATE   ',
     1           'CONFIDENCE LIMIT ')
          DO4130I=1,NPERC
            QPTEMP=QP(I)/100.0
            CALL EXPPPF(QPTEMP,APPF)
            XQPHAT(I)=UHAT + SCALML*APPF
            DAK=D1N*(1.0D0 - (DBLE(1.0D0 - QPTEMP)**DN/DALPH)**D2R)
            XQPLCL(I)=UHAT + REAL(DAK*DS)
CCCCC       XQPUCL(I)=UHAT + MAX(ATEMP1,ATEMP2)
            WRITE(IOUNI2,'(3E15.7)')QP(I),XQPHAT(I),XQPLCL(I)
C
            IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLE2')THEN
              WRITE(ICOUT,4133)I,QP(I),XQPHAT(I),DS,DAK
 4133         FORMAT('I,QP(I),XQPHAT(I),DS,DAK = ',I8,4G15.7)
              CALL DPWRST('XXX','BUG ')
              WRITE(ICOUT,4137)XQPLCL(I)
 4137         FORMAT('XQPLCL(I) = ',2G15.7)
              CALL DPWRST('XXX','BUG ')
            ENDIF
C
 4130     CONTINUE
        ENDIF
      ENDIF
C
C               *************************************
C               **   STEP 42--                     **
C               **   WRITE OUT EVERYTHING          **
C               **   FOR EXPONENTIAL MLE ESTIMATE  **
C               *************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLE2')
     1  CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      IF(ICASPL.EQ.'1EXP')THEN
        ITITLE='1-Parameter Exponential Parameter Estimation'
        NCTITL=44
      ELSE
        ITITLE='2-Parameter Exponential Parameter Estimation'
        NCTITL=44
      ENDIF
      IF(ICASE.EQ.'SING')THEN
        ITITLZ='Time (Singly) Censored Case'
        NCTITZ=27
      ELSE
        ITITLZ='Time (Multiply) Censored Case'
        NCTITZ=29
      ENDIF
C
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(N)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Failure Times:'
      NCTEXT(ICNT)=24
      AVALUE(ICNT)=AR
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Censoring Times:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=AM
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Maximum Likelihood:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      IF(ICASPL.EQ.'EXPO')THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of Location:'
        NCTEXT(ICNT)=21
        AVALUE(ICNT)=ALOCML
        IDIGIT(ICNT)=NUMDIG
CCCCC   ICNT=ICNT+1
CCCCC   ITEXT(ICNT)='Standard Error of Location:'
CCCCC   NCTEXT(ICNT)=27
CCCCC   AVALUE(ICNT)=ALOCSE
CCCCC   IDIGIT(ICNT)=NUMDIG
      ENDIF
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Scale:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=SCALML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Standard Error of Scale:'
      NCTEXT(ICNT)=24
      AVALUE(ICNT)=SCALSE
      IDIGIT(ICNT)=NUMDIG
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='Covariance:'
CCCCC NCTEXT(ICNT)=11
CCCCC AVALUE(ICNT)=COVSE
CCCCC IDIGIT(ICNT)=NUMDIG
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='Log-likelihood:'
CCCCC NCTEXT(ICNT)=15
CCCCC AVALUE(ICNT)=ALIK
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=AIC
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AICc:'
CCCCC NCTEXT(ICNT)=5
CCCCC AVALUE(ICNT)=AICC
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='BIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=BIC
CCCCC IDIGIT(ICNT)=-7
C
      NUMROW=ICNT
      DO2320I=1,NUMROW
        NTOT(I)=15
 2320 CONTINUE
C
      IFRST=.FALSE.
      ILAST=.FALSE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
      IF(ICASPL.EQ.'1EXP')THEN
        ALOWLO(1)=CPUMIN
        ILIKFL='ON'
        CALL DPDT77(ALOWLO,AUPPLO,ALOWS2,AUPPS2,
     1              ALOWLO,AUPPLO,ALOWSC,AUPPSC,
     1              ALPHA,NUMALP,
     1              ICAPSW,ICAPTY,NUMDIG,
     1              ISUBRO,IBUGA3,IERROR)
      ELSE
        INORM='NO'
        CALL DPDTA7(ALOWLO,AUPPLO,ALOWSC,AUPPSC,ALPHA,NUMALP,
     1              ICAPSW,ICAPTY,NUMDIG,INORM,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
C
      IF(NPERC.GE.1)THEN
        ILIKFL='EXAC'
        XQPSE(1)=CPUMIN
        XQPUCL(1)=CPUMIN
        CALL DPDTA9(QP,XQPHAT,XQPLCL,XQPUCL,XQPSE,NPERC,
     1              ICAPSW,ICAPTY,ILIKFL,NUMDIG,ALPHAP,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLE2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLE2--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012   FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLE3(Y,TAG,N,ICASPL,
     1                  XTEMP,MAXNXT,
     1                  XMIN,SCALML,SCALSE,NUMV,TEND,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  QP,XQPHAT,XQPSE,XQPLCL,XQPUCL,NPERC,
     1                  XQPHTZ,XQPLCZ,XQPUCZ,
     1                  IOUNI1,IOUNI2,ALPHAP,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR EXPONENTIAL DISTRIBUTION
C              FOR THE FAILURE CENSORED (TYPE II, EITHER SINGLY OR
C              MULTIPLY CENSORED) CASE.
C     EXAMPLE--EXPONENTIAL MAXIMUM LIKELIHOOD Y X
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN
C                ENGINEERING", CAMBRIDGE UNIVERSITY PRESS,
C                1999, CHAPTER 12.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--98/3
C     ORIGINAL VERSION--MARCH     1998.
C     UPDATED         --OCTOBER   2003. SUPPORT FOR HTML/LATEX OUTPUT
C     UPDATED         --OCTOBER   2004. SUPPORT FOR BOTH TIME AND
C                                       NUMBER OF FAILURES CENSORING,
C                                       MULTIPLY CENSORED DATA FOR
C                                       TIME CENSORED DATA
C     UPDATED         --OCTOBER   2004. CONFIDENCE INTERVALS FOR
C                                       SELECT PERCENTILES
C     UPDATED         --OCTOBER   2004. SPLIT FULL SAMPLE AND CENSORED
C                                       CASES INTO DISTINCT
C                                       SUBROUTINES
C     UPDATED         --JUNE      2010. USE DPDTA1, DPDTA7, DPDTA9 TO
C                                       PRINT OUTPUT, ADD AIC AND
C                                       RELATED STATISTICS TO OUTPUT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 ICASPL
      CHARACTER*4 IFORSW
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ILIKFL
      CHARACTER*4 INORM
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*4 ICASE
C
C---------------------------------------------------------------------
C
      PARAMETER (NUMALP=6)
      DIMENSION ALPHA(NUMALP)
      DIMENSION ALOWLO(NUMALP)
      DIMENSION AUPPLO(NUMALP)
      DIMENSION ALOWSC(NUMALP)
      DIMENSION AUPPSC(NUMALP)
      DIMENSION ALOWS2(NUMALP)
      DIMENSION AUPPS2(NUMALP)
C
      DIMENSION Y(*)
      DIMENSION TAG(*)
      DIMENSION XTEMP(*)
      DIMENSION XQPHTZ(*)
      DIMENSION XQPLCZ(*)
      DIMENSION XQPUCZ(*)
      DIMENSION QP(*)
      DIMENSION XQPHAT(*)
      DIMENSION XQPSE(*)
      DIMENSION XQPLCL(*)
      DIMENSION XQPUCL(*)
C
      DOUBLE PRECISION DN
      DOUBLE PRECISION D1N
      DOUBLE PRECISION D2R
      DOUBLE PRECISION DS
      DOUBLE PRECISION DAK
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DALPH
      DOUBLE PRECISION XLOW
      DOUBLE PRECISION XUP
C
      DOUBLE PRECISION AE
      DOUBLE PRECISION RE
C
      DOUBLE PRECISION DK
      DOUBLE PRECISION DR
      DOUBLE PRECISION SHAT
      DOUBLE PRECISION DXSUM
      DOUBLE PRECISION DC
      COMMON/EXPCOM/DK,DR,SHAT,DXSUM,DC
      DOUBLE PRECISION EXPFUN
      EXTERNAL EXPFUN
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=50)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*40 ITEXT(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA ALPHA /0.50, 0.25, 0.10, 0.05, 0.01, 0.001/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='E3  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLE3')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLE3--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)N,NUMV,IBUGA3
   55   FORMAT('N,NUMV,NPERC,IBUGA3 = ',3I8,2X,A4)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I),TAG(I)
   57     FORMAT('I,Y(I),TAG(I) = ',I8,2E15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLE3')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NMIN=3
      CALL CKDIST(Y,N,NMIN,QP,NPERC,ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C               ********************************************
C               **  STEP 21--                             **
C               **  CHECK THE CENSORING VARIABLE: SHOULD  **
C               **  BE AT MOST 2 DISTINCT VALUES, 1       **
C               **  INDICATES FAILURE TIME, 0 INDICATES   **
C               **  CENSORING TIME.                       **
C               ********************************************
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLE3')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL EXPML3(Y,TAG,XTEMP,N,ICASPL,ICASE,TEND,MAXNXT,
     1            XMEAN,XSD,XVAR,XMIN,XMAX,XSUM,
     1            ALOCML,ALOCSE,SCALML,SCALSE,
     1            IR,IM,AN,AR,AM,
     1            ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
      DR=DBLE(IR)
C
C               *************************************
C               **  STEP 41--                      **
C               **  GENERATE CONFIDENCE INTERVALS  **
C               **  FOR PARAMETERS AND PERCENTILES **
C               *************************************
C
      ISTEPN='41'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLE3')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IERROR='NO'
      IWRITE='OFF'
C
      IF(ICASPL.EQ.'1EXP')THEN
        IF(ICASE.EQ.'SING')THEN
          NUTEMP=2*IR
          DO4110I=1,NUMALP
            ALP=ALPHA(I)
            P=1.0-(ALP/2.0)
            CALL CHSPPF(P,NUTEMP,APPF1)
            P=ALP/2.0
            CALL CHSPPF(P,NUTEMP,APPF2)
            SLNOR=SCALML - ZP*SCALSE
            SUNOR=SCALML + ZP*SCALSE
            ALOWSC(I)=2.0*AR*SCALML/APPF1
            AUPPSC(I)=2.0*AR*SCALML/APPF2
 4110     CONTINUE
        ELSE
          SHAT=DBLE(SCALE)
          NUTEMP=1
          AE=1.D-7
          RE=1.D-7
          DXSUM=DBLE(XSUM)
          DC=2.0D0*(-DR*DLOG(SHAT) - DXSUM/SHAT)
C
          DO4120I=1,NUMALP
            ALP=ALPHA(I)
            P=1.0-(ALP/2.0)
            CALL NORPPF(P,ZP)
            CALL CHSPPF(1.0-ALP,NUTEMP,APPF)
            DK=DBLE(APPF)
C
C           NOW COMPUTE NORMAL APPROXIMATION INTERVAL (USE AS
C           STARTING VALUE FOR LIKELIHOOD RATIO METHOD).
C
            SLNOR=SCALML - ZP*SCALSE
            SUNOR=SCALML + ZP*SCALSE
C
C           NOW COMPUTE LIKELIHOOD RATIO BASED INTERVAL
C
            XLOW=DBLE(XMIN)
            XUP=DBLE(SCALML)
            CALL DFZERO(EXPFUN,XLOW,XUP,DBLE(SLNOR),RE,AE,IFLAG)
            ALOWSC(I)=XLOW
            AUPPS2(I)=SLNOR
C
            XLOW=DBLE(SCALML)
            XUP=1.3D0*DBLE(SUNOR)
            CALL DFZERO(EXPFUN,XLOW,XUP,DBLE(SUNOR),RE,AE,IFLAG)
            AUPPSC(I)=XLOW
            AUPPS2(I)=SUNOR
 4120     CONTINUE
        ENDIF
C
C               **********************************************
C               **  STEP 41A--                              **
C               **  ESTIMATE CONFIDENCE LIMITS FOR SELECTED **
C               **  PERCENTILES.  BASED ON FORMULAS GIVEN   **
C               **  ON PAGE 186 OF BURY FOR SINGLY CENSORED **
C               **  CASE.  FOR MULTIPLY CENSORED DATA, USE  **
C               **  FORMULA ON PAGE 190-191 FOR TWO         **
C               **  MODEL (IN THIS CASE, OBTAIN LOWER       **
C               **  CONFIDENCE INTERVAL ONLY, SET U = 0 IN  **
C               **  FORMUALA).                              **
C               **********************************************
C
        ISTEPN='41A'
        IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLNO')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        IF(NPERC.GE.1 .AND. ICASE.EQ.'SING')THEN
C
          NU2=2*IR
          ALPHL=ALPHAP/2.0
          ALPHU=1.0 - ALPHAP/2.0
          CALL CHSPPF(ALPHL,NU2,ACHSLL)
          CALL CHSPPF(ALPHU,NU2,ACHSUL)
C
          WRITE(IOUNI1,4131)
          WRITE(IOUNI1,4132)
          DO4119I=1,NPERC
            QPTEMP=QP(I)/100.0
            CALL EXPPPF(QPTEMP,APPF)
            XQPHAT(I)=SCALML*APPF
            SEXQP=APPF*SCALSE
            ATEMP1=APPF*2.0*IR*SCALML/ACHSUL
            ATEMP2=APPF*2.0*IR*SCALML/ACHSLL
            XQPLCL(I)=MIN(ATEMP1,ATEMP2)
            XQPUCL(I)=MAX(ATEMP1,ATEMP2)
            WRITE(IOUNI1,'(3E15.7,2X,E15.7)')
     1           QP(I),XQPHTZ(I),XQPLCZ(I),XQPUCZ(I)
C
            IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLE1')THEN
              WRITE(ICOUT,4133)I,QP(I),XQPHAT(I),SEXQP,APPF
              CALL DPWRST('XXX','BUG ')
              WRITE(ICOUT,4135)ACHSUL,ACHSLL,ATEMP1,ATEMP2
 4135         FORMAT('ACHSUL,ACHSLL,ATEMP1,ATEMP2 = ',4G15.7)
              CALL DPWRST('XXX','BUG ')
              WRITE(ICOUT,4137)XQPLCL(I),XQPUCL(I)
              CALL DPWRST('XXX','BUG ')
            ENDIF
C
 4119     CONTINUE
        ELSEIF(NPERC.GE.1 .AND. ICASE.EQ.'MULT')THEN
C
C       NOTE: THE FIRST AND THIRD TERMS OF S (P. 191 OF BURY) ARE
C                SUM[i=1 to r][X(i)] AND (n-r)*X(r)
C             THIS IS SIMPLY THE SUM OF THE FAILURE TIMES AND THE SUM
C             OF THE CENSORING TIMES (FOR SINGLY CENSORED DATA),
C             RESPECTIVELY.  THIS IS SIMPLY THE SUM OF THE COMBINED
C             FAILURE AND CENSORING TIMES, SO JUST NEED TO TAKE THE
C             SUM OF ALL THE DATA.  FOR 1-PARAMETER MODEL, JUST SET
C             LOCATION PARAMETER TO 0.
C      
          DSUM1=0.0D0
          DO44140I=1,N
            DSUM1=DSUM1 + DBLE(Y(I))
44140     CONTINUE
          DS=DSUM1 - DBLE(AN*XMIN)
C
          D1N=DBLE(1.0/AN)
          DN=DBLE(AN)
          DR=DBLE(AR)
          D2R=DBLE(1.0D0/(AR-1.0))
          DALPH=DBLE(ALPHAP)
          ALPHL=ALPHAP/2.0
          ALPHU=1.0 - ALPHAP/2.0
C
          WRITE(IOUNI2,4131)
          WRITE(IOUNI2,4132)
          DO44130I=1,NPERC
            QPTEMP=QP(I)/100.0
            CALL EXPPPF(QPTEMP,APPF)
            XQPHAT(I)=SCALML*APPF
            DAK=D1N*(1.0D0 - (DBLE(1.0D0 - QPTEMP)**DN/DALPH)**D2R)
            XQPLCL(I)=REAL(DAK*DS)
CCCCC       XQPUCL(I)=MAX(ATEMP1,ATEMP2)
            WRITE(IOUNI2,'(3E15.7)')
     1           QP(I),XQPHAT(I),XQPLCL(I)
C
            IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLE3')THEN
              WRITE(ICOUT,4133)I,QP(I),XQPHAT(I),DS,DAK
              CALL DPWRST('XXX','BUG ')
              WRITE(ICOUT,4137)XQPLCL(I)
              CALL DPWRST('XXX','BUG ')
            ENDIF
C
44130     CONTINUE
        ENDIF
      ELSE
C
C     ESTIMATES FOR 2-PARAMETER MODEL
C
        IF(ICASE.EQ.'SING')THEN
          NU2=2*IR-1
          DO4125I=1,NUMALP
            ALP=ALPHA(I)
            P=1.0-(ALP/2.0)
            CALL CHSPPF(P,NU2,PPF3)
            P=ALP/2.0
            CALL CHSPPF(P,NU2,PPF4)
            ALOWSC(I)=2.0*AR*SCALML/PPF3
            AUPPSC(I)=2.0*AR*SCALML/PPF4
            ACONS1=(ALP/2.0)**(2.0/(1.0-2.0*AR)) - 1.0
            ACONS2=(1.0 - ALP/2.0)**(2.0/(1.0-2.0*AR)) - 1.0
            ATEMP1=XMIN - SCALML*(AR/AN)*ACONS1
            ATEMP2=XMIN - SCALML*(AR/AN)*ACONS2
            ALOWLO(I)=MIN(ATEMP1,ATEMP2)
            AUPPLO(I)=MAX(ATEMP1,ATEMP2)
 4125     CONTINUE
        ELSE
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,4126)
 4126     FORMAT('***** NOTE FROM EXPONENTIAL MAXIMUM LIKELIHOOD--')
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,4127)
 4127     FORMAT('      TWO-PARAMETER MODEL NOT SUPPORTED FOR')
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,4128)
 4128     FORMAT('      MULTIPLY FAILURE CENSORED DATA.')
          CALL DPWRST('XXX','WRIT')
          IERROR='YES'
          GOTO9000
        ENDIF
C
C               **********************************************
C               **  STEP 41B--                              **
C               **  ESTIMATE CONFIDENCE LIMITS FOR SELECTED **
C               **  PERCENTILES.  COMPUTE THE LOWER         **
C               **  CONFIDENCE INTERVAL GIVEN ON PP. 190-191**
C               **  OF BURY.  NOTE THAT THIS APPROXIMATION  **
C               **  IS FOR THE SINGLY CENSORED CASE ONLY.   **
C               **  NO FORMULA IS GIVEN FOR THE MULTIPLY    **
C               **  CENSORED CASE.                          **
C               **********************************************
C
        ISTEPN='41B'
        IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLNO')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        IF(NPERC.GE.1)THEN
C
C       NOTE: THE FIRST AND THIRD TERMS OF S (P. 191 OF BURY) ARE
C                SUM[i=1 to r][X(i)] AND (n-r)*X(r)
C             THIS IS SIMPLY THE SUM OF THE FAILURE TIMES AND THE SUM
C             OF THE CENSORING TIMES (FOR SINGLY CENSORED DATA),
C             RESPECTIVELY.  THIS IS SIMPLY THE SUM OF THE COMBINED
C             FAILURE AND CENSORING TIMES, SO JUST NEED TO TAKE THE
C             SUM OF ALL THE DATA.
C      
          DSUM1=0.0D0
          DO4140I=1,N
            DSUM1=DSUM1 + DBLE(Y(I))
 4140     CONTINUE
          DS=DSUM1 - DBLE(AN*XMIN)
C
          D1N=DBLE(1.0/AN)
          DN=DBLE(AN)
          DR=DBLE(AR)
          D2R=DBLE(1.0D0/(AR+0.5-1.0))
          DALPH=DBLE(ALPHAP)
          ALPHL=ALPHAP/2.0
          ALPHU=1.0 - ALPHAP/2.0
C
          WRITE(IOUNI2,4131)
 4131     FORMAT(15X,'       POINT     ','     LOWER     ')
C4131     FORMAT(15X,'       POINT     ','     LOWER     ',
CCCCC1           '     UPPER')
          WRITE(IOUNI2,4132)
 4132     FORMAT('    PERCENTILE ','     ESTIMATE   ',
CCCCC1           'CONFIDENCE LIMIT ','CONFIDENCE LIMIT')
     1           'CONFIDENCE LIMIT ')
          DO4130I=1,NPERC
            QPTEMP=QP(I)/100.0
            CALL EXPPPF(QPTEMP,APPF)
            XQPHAT(I)=ALOCML + SCALML*APPF
            DAK=D1N*(1.0D0 - (DBLE(1.0D0 - QPTEMP)**DN/DALPH)**D2R)
            XQPLCL(I)=ALOCML + REAL(DAK*DS)
CCCCC       XQPUCL(I)=ALOCML + MAX(ATEMP1,ATEMP2)
            WRITE(IOUNI2,'(3E15.7)')
     1           QP(I),XQPHAT(I),XQPLCL(I)
C
            IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLE3')THEN
              WRITE(ICOUT,4133)I,QP(I),XQPHAT(I),DS,DAK
 4133         FORMAT('I,QP(I),XQPHAT(I),DS,DAK = ',I8,4G15.7)
              CALL DPWRST('XXX','BUG ')
              WRITE(ICOUT,4137)XQPLCL(I)
 4137         FORMAT('XQPLCL(I) = ',2G15.7)
              CALL DPWRST('XXX','BUG ')
            ENDIF
C
 4130     CONTINUE
        ENDIF
      ENDIF
C
C               *************************************
C               **   STEP 42--                     **
C               **   WRITE OUT EVERYTHING          **
C               **   FOR EXPONENTIAL MLE ESTIMATE  **
C               *************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLE3')
     1  CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      IF(ICASPL.EQ.'1EXP')THEN
        ITITLE='1-Parameter Exponential Parameter Estimation'
        NCTITL=44
      ELSE
        ITITLE='2-Parameter Exponential Parameter Estimation'
        NCTITL=44
      ENDIF
      IF(ICASE.EQ.'SING')THEN
        ITITLZ='Failure (Singly) Censored Case'
        NCTITZ=30
      ELSE
        ITITLZ='Failure (Multiply) Censored Case'
        NCTITZ=32
      ENDIF
C
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(N)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Failure Times:'
      NCTEXT(ICNT)=24
      AVALUE(ICNT)=AR
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Censoring Times:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=AM
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Maximum Likelihood:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      IF(ICASPL.EQ.'EXPO')THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of Location:'
        NCTEXT(ICNT)=21
        AVALUE(ICNT)=ALOCML
        IDIGIT(ICNT)=NUMDIG
CCCCC   ICNT=ICNT+1
CCCCC   ITEXT(ICNT)='Standard Error of Location:'
CCCCC   NCTEXT(ICNT)=27
CCCCC   AVALUE(ICNT)=ALOCSE
CCCCC   IDIGIT(ICNT)=NUMDIG
      ENDIF
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Scale:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=SCALML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Standard Error of Scale:'
      NCTEXT(ICNT)=24
      AVALUE(ICNT)=SCALSE
      IDIGIT(ICNT)=NUMDIG
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='Covariance:'
CCCCC NCTEXT(ICNT)=11
CCCCC AVALUE(ICNT)=COVSE
CCCCC IDIGIT(ICNT)=NUMDIG
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='Log-likelihood:'
CCCCC NCTEXT(ICNT)=15
CCCCC AVALUE(ICNT)=ALIK
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=AIC
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AICc:'
CCCCC NCTEXT(ICNT)=5
CCCCC AVALUE(ICNT)=AICC
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='BIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=BIC
CCCCC IDIGIT(ICNT)=-7
C
      NUMROW=ICNT
      DO2320I=1,NUMROW
        NTOT(I)=15
 2320 CONTINUE
C
      IFRST=.FALSE.
      ILAST=.FALSE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
      IF(ICASPL.EQ.'1EXP')THEN
        ALOWLO(1)=CPUMIN
        IF(ICASE.EQ.'SING')THEN
          INORM='NO'
          CALL DPDTA7(ALOWLO,AUPPLO,ALOWSC,AUPPSC,ALPHA,NUMALP,
     1                ICAPSW,ICAPTY,NUMDIG,INORM,
     1                ISUBRO,IBUGA3,IERROR)
        ELSE
          ILIKFL='ON'
          CALL DPDT77(ALOWLO,AUPPLO,ALOWS2,AUPPS2,
     1                ALOWLO,AUPPLO,ALOWSC,AUPPSC,
     1                ALPHA,NUMALP,
     1                ICAPSW,ICAPTY,NUMDIG,
     1                ISUBRO,IBUGA3,IERROR)
        ENDIF
      ELSE
        INORM='NO'
        CALL DPDTA7(ALOWLO,AUPPLO,ALOWSC,AUPPSC,ALPHA,NUMALP,
     1              ICAPSW,ICAPTY,NUMDIG,INORM,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
C
      IF(NPERC.GE.1)THEN
        XQPSE(1)=CPUMIN
        IF(ICASPL.EQ.'1EXP' .AND. ICASE.EQ.'SING')THEN
          ILIKFL='OFF'
          CALL DPDTA9(QP,XQPHAT,XQPLCL,XQPUCL,XQPSE,NPERC,
     1                ICAPSW,ICAPTY,ILIKFL,NUMDIG,ALPHAP,
     1                ISUBRO,IBUGA3,IERROR)
        ELSE
          ILIKFL='OFF'
          XQPUCL(1)=CPUMIN
          CALL DPDTA9(QP,XQPHAT,XQPLCL,XQPUCL,XQPSE,NPERC,
     1                ICAPSW,ICAPTY,ILIKFL,NUMDIG,ALPHAP,
     1                ISUBRO,IBUGA3,IERROR)
        ENDIF
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLE3')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLE3--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012   FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9015)N
 9015   FORMAT('N = ',I8)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLE4(Y,X1,X2,N,
     1                  XTEMP,TEMP2,TEMP3,MAXNXT,
     1                  XMIN,SCALML,SCALSE,NUMV,TEND,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  QP,XQPHAT,XQPSE,XQPLCL,XQPUCL,NPERC,
     1                  IOUNI1,IOUNI2,ALPHAP,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR EXPONENTIAL DISTRIBUTION
C              FOR THE FULL SAMPLE CASE WHEN THE DATA ARE BINNED.
C              CURRENTLY, ONLY THE ONE-PARAMETER MODEL IS
C              ESTIMATED.
C
C              THE ML ESTIMATE IS BASED ON KNOWING THE END POINTS
C              OF THE GROUPS (I.E., THE BIN WIDTHS NEED NOT BE
C              EQUAL).  SO TWO SYNTAXES ARE ALLOWED: IF ONE GROUPING
C              VARIABLE, THEN IT IS ASSUMED THIS REPRESENTS THE
C              BIN MID-POINTS AND BINS ARE EQUAL WIDTH.  IF THERE
C              ARE TWO GROUPING VARIABLES, THEN IT IS ASSUMED THAT
C              THE FIRST REPRESENTS THE LOWER BOUNDARY OF THE BIN
C              AND THE SECOND REPRESENTS THE UPPER BOUNDARY OF THE
C              BIN.
C
C              THE CURRENT IMPLEMENTATION PROVIDES A POINT ESTIMATE
C              AND THE STANDARD ERROR, BUT NO EXPLICIT CONFIDENCE
C              INTERVAL.
C
C     EXAMPLE--SET CENSORING TYPE GROUPED
C              EXPONENTIAL MAXIMUM LIKELIHOOD Y X
C
C              EXPONENTIAL MAXIMUM LIKELIHOOD Y XLOW XHIGH
C
C     REFERENCE--JOHNSON, KOTZ, AND BALAKRISHNAN, "CONTINUOUS
C                UNIVARIATE DISTRIBUTIONS--Volume 1", SECOND EDITION,
C                WILEY, 1994, PP. 509-510.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004/10
C     ORIGINAL VERSION--OCTOBER   2004.
C     UPDATED         --JUNE      2010. USE DPDTA1, DPDTA7, DPDTA9 TO
C                                       PRINT OUTPUT, ADD AIC AND
C                                       RELATED STATISTICS TO OUTPUT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      PARAMETER (NUMALP=6)
      DIMENSION ALPHA(NUMALP)
      DIMENSION ALOWLO(NUMALP)
      DIMENSION AUPPLO(NUMALP)
      DIMENSION ALOWSC(NUMALP)
      DIMENSION AUPPSC(NUMALP)
C
      DIMENSION Y(*)
      DIMENSION X1(*)
      DIMENSION X2(*)
      DIMENSION XTEMP(*)
      DIMENSION TEMP2(*)
      DIMENSION TEMP3(*)
      DIMENSION QP(*)
      DIMENSION XQPHAT(*)
      DIMENSION XQPSE(*)
      DIMENSION XQPLCL(*)
      DIMENSION XQPUCL(*)
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=50)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*40 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(NUMALP)
      CHARACTER*4  VALIGN(NUMALP)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C
      CHARACTER*4 ILIKFL
      CHARACTER*4 INORM
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA ALPHA /0.50, 0.25, 0.10, 0.05, 0.01, 0.001/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='E4  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLE4')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLE4--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)N,NUMV,NPERC,ICENTY,IBUGA3
   55   FORMAT('N,NUMV,NPERC,ICENTY,IBUGA3 = ',3I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I),X1(I),X2(I)
   57     FORMAT('I,Y(I),X1(I),X2(I) = ',I8,3G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLE4')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NMIN=2
      IF(NUMV.EQ.2)THEN
        CALL CKDIS2(Y,X1,XTEMP,N,MAXNXT,NMIN,QP,NPERC,NTOT2,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
      ELSEIF(NUMV.EQ.3)THEN
        CALL CKDIS3(Y,X1,X2,XTEMP,N,MAXNXT,NMIN,QP,NPERC,NTOT2,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
      ENDIF
C
C               *****************************************
C               **  STEP 21--                          **
C               **  CARRY OUT CALCULATIONS FOR GROUPED **
C               **  EXPONENTIAL MLE (GROUPED, FULL     **
C               **  SAMPLE CASE).  ML ESTIMATE GIVEN   **
C               **  ON PAGE 509 OF JOHNSON, KOTZ, AND  **
C               **  BALAKRISHNAN.                      **
C               *****************************************
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLE4')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
      IERROR='NO'
      IWRITE='OFF'
C
      CALL EXPML4(Y,X1,X2,N,NUMV,MAXNXT,
     1            XTEMP,TEMP2,TEMP3,
     1            XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ,
     1            SCALML,SCALSE,
     1            ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      DO2110I=1,NUMALP
        ALPHAT=ALPHA(I)
        ALPHAT=1.0 - ALPHAT/2.0
        CALL NORPPF(ALPHAT,ZPPF)
        ALOWSC(I)=SCALML - ZPPF*SCALSE
        AUPPSC(I)=SCALML + ZPPF*SCALSE
 2110 CONTINUE
C
      IF(NPERC.GE.1)THEN
C
        NU2=2*NTOTZZ
        ALPHL=ALPHAP/2.0
        ALPHU=1.0 - ALPHAP/2.0
        CALL CHSPPF(ALPHL,NU2,ACHSLL)
        CALL CHSPPF(ALPHU,NU2,ACHSUL)
C
        WRITE(IOUNI1,4131)
        WRITE(IOUNI1,4132)
        DO4119I=1,NPERC
          QPTEMP=QP(I)/100.0
          CALL EXPPPF(QPTEMP,APPF)
          XQPHAT(I)=SCALML*APPF
          SEXQP=APPF*SCALSE
          ATEMP1=APPF*2.0*AN*SCALML/ACHSUL
          ATEMP2=APPF*2.0*AN*SCALML/ACHSLL
          XQPLCL(I)=MIN(ATEMP1,ATEMP2)
          XQPUCL(I)=MAX(ATEMP1,ATEMP2)
C
          WRITE(IOUNI1,'(3E15.7,2X,E15.7)')
     1         QP(I),XQPHAT(I),XQPLCL(I),XQPUCL(I)
C
          IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLE4')THEN
            WRITE(ICOUT,4133)I,QP(I),XQPHAT(I),SEXQP,APPF
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,4135)ACHSUL,ACHSLL,ATEMP1,ATEMP2
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,4137)XQPLCL(I),XQPUCL(I)
            CALL DPWRST('XXX','BUG ')
          ENDIF
C
 4119   CONTINUE
 4131   FORMAT(15X,'       POINT     ','     LOWER     ',
     1         '     UPPER')
 4132   FORMAT('    PERCENTILE ','     ESTIMATE   ',
     1         'CONFIDENCE LIMIT ','CONFIDENCE LIMIT')
 4133   FORMAT('I,QP(I),XQPHAT(I),SEXQP,APPF = ',I8,4G15.7)
 4135   FORMAT('ACHSUL,ACHSLL,ATEMP1,ATEMP2 = ',4G15.7)
 4137   FORMAT('XQPLCL(I),XQPUCL(I) = ',2G15.7)
      ENDIF
C
C               *************************************
C               **   STEP 42--                     **
C               **   WRITE OUT EVERYTHING          **
C               **   FOR EXPONENTIAL MLE ESTIMATE  **
C               *************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLE4')
     1  CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='1-Parameter Exponential Parameter Estimation'
      NCTITL=44
      ITITLZ='(Grouped Data)'
      NCTITZ=14
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(NTOTZZ)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Maximum Likelihood:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
CCCCC IF(ICASPL.EQ.'EXPO')THEN
CCCCC   ICNT=ICNT+1
CCCCC   ITEXT(ICNT)='Estimate of Location:'
CCCCC   NCTEXT(ICNT)=21
CCCCC   AVALUE(ICNT)=ALOC
CCCCC   IDIGIT(ICNT)=NUMDIG
CCCCC   ICNT=ICNT+1
CCCCC   ITEXT(ICNT)='Standard Error of Location:'
CCCCC   NCTEXT(ICNT)=27
CCCCC   AVALUE(ICNT)=ALOCSE
CCCCC   IDIGIT(ICNT)=NUMDIG
CCCCC ENDIF
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Scale:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=SCALE
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Standard Error of Scale:'
      NCTEXT(ICNT)=24
      AVALUE(ICNT)=SCALSE
      IDIGIT(ICNT)=NUMDIG
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='Log-likelihood:'
CCCCC NCTEXT(ICNT)=15
CCCCC AVALUE(ICNT)=ALIK
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=AIC
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AICc:'
CCCCC NCTEXT(ICNT)=5
CCCCC AVALUE(ICNT)=AICC
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='BIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=BIC
CCCCC IDIGIT(ICNT)=-7
C
      NUMROW=ICNT
      DO2320I=1,NUMROW
        NTOT(I)=15
 2320 CONTINUE
C
      IFRST=.FALSE.
      ILAST=.FALSE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
      INORM='ON'
      ALOWLO(1)=CPUMIN
      CALL DPDTA7(ALOWLO,AUPPLO,ALOWSC,AUPPSC,ALPHA,NUMALP,
     1            ICAPSW,ICAPTY,NUMDIG,INORM,
     1            ISUBRO,IBUGA3,IERROR)
C
      IF(NPERC.GT.1)THEN
        ILIKFL='OFF'
        XQPSE(1)=CPUMIN
        CALL DPDTA9(QP,XQPHAT,XQPLCL,XQPUCL,XQPSE,NPERC,
     1              ICAPSW,ICAPTY,ILIKFL,NUMDIG,ALPHAP,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLE4')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLE4--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012   FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9015)N,NTOT
 9015   FORMAT('NNTOT = ',2I8)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLEL(Y1,N,
     1                  TEND,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  AHAT,BHAT,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR A NON-HOMOGENEOUS POISSON PROCESS
C              THAT FOLLOWS THE "EXPONENTIAL LAW" MODEL.
C
C              THE EXPONENTIAL LAW MODEL IS:
C
C                  M(t) = EXP(C + B*t)
C
C              WHERE
C
C                 M(t) = CUMULATIVE REPAIR FUNCTION
C                 t    = TIME TO FAILURE
C                 b, c = PARAMETERS TO BE ESTIMATED
C
C               THE EXPONENTIAL LAW IS INDICATED WHEN A PLOT
C               OF LOG(CUMULATIVE NUMBER OF REPAIRS) VS TIME
C               IS APPROXIMATELY LINEAR.
C
C               THE INPUT IS ASSUMED TO BE REPAIR TIMES.  WE CAN
C               OPTIONALLY HAVE A CENSORING VARIABLE (THERE SHOULD
C               BE AT MOST ONE CENSORING TIME).
C
C               FOR THE CASE WHERE THE TEST IS TERMINATED AT THE
C               NTH FAILURE, THE MAXIMUM LIKELIHOOD ESTIMATE OF B
C               IS THE SOLUTION OF THE EQUATION
C
C                   SUM[i=1 to n][t(i)] + (n/bhat) -
C                   n*t(n)/(1 - EXP(-bhat*t(n)) = 0
C
C               THE ESTIMATE OF C IS THEN
C
C                   chat = LOG(n*bhat/(EXP(bhat*t(n)) - 1)
C
C               FOR THE CASE WHERE THE TEST IS TERMINATED AT A FIXED
C               TIME T, THE MAXIMUM LIKELIHOOD ESTIMATE OF B IS
C               THE SOLUTION OF THE EQUATION
C
C                   SUM[i=1 to n][t(i)] + (N/bhat) -
C                   N*t(n)/(1 - EXP(-bhat*T)) = 0
C
C               WHERE T IS THE TIME OF TRUNCATION AND N IS THE
C               NUMBER OF REPAIRS.
C
C               THE ESTIMATE OF C IS THEN
C
C                   chat = LOG(N*bhat/(EXP(bhat*T) - 1)
C
C     EXAMPLE--EXPONENTIAL LAW MAXIMUM LIKELIHOOD Y
C     REFERENCE--TOBIAS AND TRINDADE, "APPLIED RELIABILITY", SECOND
C                EDITION, PP. 363-365.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2007/2
C     ORIGINAL VERSION--FEBRUARY  2007.
C     UPDATED         --APRIL     2011.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      DOUBLE PRECISION DBHAT
      DOUBLE PRECISION DAHAT
      DOUBLE PRECISION DCHAT
C
      DOUBLE PRECISION AE
      DOUBLE PRECISION RE
      DOUBLE PRECISION XLOW
      DOUBLE PRECISION XUP
C
      DOUBLE PRECISION DN
      DOUBLE PRECISION DTEND
      DOUBLE PRECISION DXSUM
      DOUBLE PRECISION DXN
      COMMON/EPLCOM/DXSUM,DXN,DTEND,DN
      DOUBLE PRECISION EPLFUN
      DOUBLE PRECISION EPLFU2
      EXTERNAL EPLFUN
      EXTERNAL EPLFU2
C
C---------------------------------------------------------------------
C
      DIMENSION Y1(*)
C
      PARAMETER (MAXROW=10)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*40 IDIST
      CHARACTER*40 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(MAXROW)
      CHARACTER*4  VALIGN(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL      IFRST
      LOGICAL      ILAST
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='EL  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLEL')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLEL--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)IBUGA3,ISUBRO,N,TEND
   55   FORMAT('IBUGA3,ISUBRO,N,TEND = ',2(A4,2X),I8,G15.7)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y1(I)
   57     FORMAT('I,Y1(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLEL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(N.LT.3)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1111)
 1111   FORMAT('***** ERROR IN EXPONENTIAL LAW MAXIMUM LIKELIHOOD--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1112)
 1112   FORMAT('      THE NUMBER OF OBSERVATIONS IS < 3')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1113)N
 1113   FORMAT('      SAMPLE SIZE = ',I8)
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      DO1135I=1,N
        IF(Y1(I).LE.0.0)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,1111)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,1132)I
 1132     FORMAT('      FAILURE TIME ',I8,' IS NON-POSITIVE.')
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,1134)Y1(I)
 1134     FORMAT('      FAILURE TIME = ',G15.7)
          CALL DPWRST('XXX','WRIT')
          IERROR='YES'
          GOTO9000
        ENDIF
 1135 CONTINUE
C
C               **********************************
C               **  STEP 41--                   **
C               **  CARRY OUT CALCULATIONS      **
C               **  FOR EXPONENTIAL LAW MLE     **
C               **  ESTIMATE (FULL SAMPLE CASE) **
C               **********************************
C
 4100 CONTINUE
C
      ISTEPN='41'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLEL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IERROR='NO'
      IWRITE='OFF'
      AN=REAL(N)
      DN=DBLE(N)
      AE=1.D-7
      RE=1.D-7
C
      CALL SORT(Y1,N,Y1)
      IF(TEND.LE.Y1(N))TEND=0.0
C
      IF(TEND.LE.0.0)THEN
C
C       NUMBER OF FAILURES CASE
C
        NUMCEN=0
        DTEND=0.0D0
        DXN=DBLE(Y1(N))
        DXSUM=0.0D0
        DO4110I=1,N
          DXSUM=DXSUM + DBLE(Y1(I))
 4110   CONTINUE
        XLOW=0.000000001D0
        XUP=10.0D0
        DBHAT=0.1D0
        CALL DFZERO(EPLFUN,XLOW,XUP,DBHAT,RE,AE,IFLAG)
        DBHAT=XLOW
        DCHAT=DLOG(DN*DBHAT/(DEXP(DBHAT*DXN)-1.0D0))
        DAHAT=DEXP(DCHAT)
      ELSE
C
C       TIME CENSORED CASE CASE
C
        NUMCEN=1
        DTEND=DBLE(TEND)
        DXN=DBLE(Y1(N))
        DXSUM=0.0D0
        DO4210I=1,N
          DXSUM=DXSUM + DBLE(Y1(I))
 4210   CONTINUE
        XLOW=0.000000001D0
        XUP=10.0D0
        DBHAT=0.1D0
        CALL DFZERO(EPLFU2,XLOW,XUP,DBHAT,RE,AE,IFLAG)
        DBHAT=XLOW
        DCHAT=DLOG(DN*DBHAT/(DEXP(DBHAT*DTEND)-1.0D0))
        DAHAT=DEXP(DCHAT)
      ENDIF
C
      AHAT=REAL(DAHAT)
      BHAT=REAL(DBHAT)
      CHAT=REAL(DCHAT)
C
C     PRINT TABLE
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Exponential Law ML Estimation (M(t) = (a/b)*exp(b*t) - 1)'
      NCTITL=57
      IF(NUMCEN.EQ.0)THEN
        ITITLZ='Single System, Failure Truncated Case'
        NCTITZ=37
      ELSE
        ITITLZ='Single System, Time Truncated Case'
        NCTITZ=34
      ENDIF
C
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Failure Times:'
      NCTEXT(ICNT)=24
      AVALUE(ICNT)=REAL(N)
      IDIGIT(ICNT)=0
      IF(TEND.GT.0.0)THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='Censoring Time:'
        NCTEXT(ICNT)=15
        AVALUE(ICNT)=TEND
        IDIGIT(ICNT)=NUMDIG
      ENDIF
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Parameter Estimates:'
      NCTEXT(ICNT)=20
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of B:'
      NCTEXT(ICNT)=14
      AVALUE(ICNT)=REAL(DBHAT)
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of A:'
      NCTEXT(ICNT)=14
      AVALUE(ICNT)=REAL(DAHAT)
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      NUMROW=ICNT
      DO2310I=1,NUMROW
        NTOT(I)=15
 2310 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLEL')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLEL--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012   FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9015)IERROR,DAHAT,DBHAT
 9015   FORMAT('IERROR,DAHAT,DBHAT = ',A4,2X,2G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLFL(Y,N,
     1XTEMP,DTEMP1,MAXNXT,
     1SHAPMO,SCALMO,SHAPML,SCALML,
     1ICAPSW,ICAPTY,IFORSW,
     1ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE METHOD OF MOMENT AND
C              MAXIMUM LIKELIHOOD ESTIMATES FOR THE FATIGUE LIFE
C              DISTRIBUTION
C     EXAMPLE--FATIGUE LIFE MAXIMUM LIKELIHOOD Y
C     REFERENCE--JOHNSON, KOTZ, AND BALAKRISHNAN.  "CONTINUOUS
C                UNIVARIATE DISTRIBUTIONS, VOLUME I", SECOND
C                EDITION, WILEY, 1994, PP. 614-619.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004/3
C     ORIGINAL VERSION--MARCH     2004.
C     UPDATED         --AUGUST    2005. ORDER OF SCALE/SHAPE WERE
C                                       INVERTED.  FIXED.
C     UPDATED         --AUGUST    2005. AESTHETIC FIXES TO OUTOUT
C     UPDATED         --FEBRUARY  2010. EXTRACT POINT ESTIMATES TO
C                                       DISTINCT ROUTINE (FLML1) TO
C                                       FACILITATE USE BY MULTIPLE
C                                       ROUTINES
C     UPDATED         --FEBRUARY  2010. PRINT TABLES USING DPDTA2
C                                       AND DPDTA8
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION XTEMP(*)
      DOUBLE PRECISION DTEMP1(*)
      DIMENSION QP(1)
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=10)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(MAXROW)
      CHARACTER*4  VALIGN(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='FL  '
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLFL')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLFL--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N
   52   FORMAT('IBUGA3,ISUBRO,N = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,E15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ***************************************************
C               **  STEP 21--                                    **
C               **  CARRY OUT CALCULATIONS                       **
C               **  FOR FATIGUE LIFE MOMENT/MLE ESTIMATION       **
C               ***************************************************
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLFL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NPERC=0
      NMIN=3
      CALL CKDIST(Y,N,NMIN,QP,NPERC,ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      CALL FLML1(Y,N,MAXNXT,
     1           XTEMP,DTEMP1,
     1           XMEAN,XSD,XVAR,XMIN,XMAX,
     1           SCALML,SHAPML,SCALMO,SHAPMO,
     1           ISUBRO,IBUGA3,IERROR)
C
C               ***********************************************
C               **   STEP 42--                               **
C               **   WRITE OUT EVERYTHING                    **
C               **   FOR FATIGUE LIFE MLE ESTIMATION         **
C               ***********************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLFL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     PRINT SUMMARY STATISTICS TABLE
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Two-Parameter Fatigue Life Parameter Estimation:'
      NCTITL=48
      ITITLZ='Full Sample Case'
      NCTITZ=16
      ITEXT(1)='Summary Statistics:'
      NCTEXT(1)=19
      AVALUE(1)=0.0
      IDIGIT(1)=0
      ITEXT(2)='Number of Observations:'
      NCTEXT(2)=23
      AVALUE(2)=REAL(N)
      IDIGIT(2)=0
      ITEXT(3)='Sample Mean:'
      NCTEXT(3)=12
      AVALUE(3)=XMEAN
      IDIGIT(3)=NUMDIG
      ITEXT(4)='Sample Standard Deviation:'
      NCTEXT(4)=26
      AVALUE(4)=XSD
      IDIGIT(4)=NUMDIG
      ITEXT(5)='Sample Minimum:'
      NCTEXT(5)=15
      AVALUE(5)=XMIN
      IDIGIT(5)=NUMDIG
      ITEXT(6)='Sample Maximum:'
      NCTEXT(6)=15
      AVALUE(6)=XMAX
      IDIGIT(6)=NUMDIG
      NUMROW=6
      DO2310I=1,NUMROW
        NTOT(I)=15
 2310 CONTINUE
      NTOT(2)=8
C
      IFRST=.TRUE.
      ILAST=.FALSE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,
     1            NCTEXT,AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
      IFRST=.FALSE.
      ITITLE=' '
      NCTITL=0
C
      ITEXT(1)='Method of Moments:'
      NCTEXT(1)=18
      AVALUE(1)=0.0
      IDIGIT(1)=0
      ITEXT(2)='Estimate of Shape (Gamma):'
      NCTEXT(2)=26
      AVALUE(2)=SHAPMO
      IDIGIT(2)=NUMDIG
      ITEXT(3)='Estimate of Scale:'
      NCTEXT(3)=18
      AVALUE(3)=SCALMO
      IDIGIT(3)=NUMDIG
      ITEXT(4)=' '
      NCTEXT(4)=0
      AVALUE(4)=0.0
      IDIGIT(4)=-1
      ITEXT(5)='Maximum Likelihood:'
      NCTEXT(5)=19
      AVALUE(5)=0.0
      IDIGIT(5)=-1
      ITEXT(6)='Estimate of Shape (Gamma):'
      NCTEXT(6)=26
      AVALUE(6)=SHAPML
      IDIGIT(6)=NUMDIG
      ITEXT(7)='Estimate of Scale:'
      NCTEXT(7)=18
      AVALUE(7)=SCALML
      IDIGIT(7)=NUMDIG
C
      ICNT=7
C
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='Log-likelihood:'
CCCCC NCTEXT(ICNT)=15
CCCCC AVALUE(ICNT)=ALIK
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=AIC
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AICc:'
CCCCC NCTEXT(ICNT)=5
CCCCC AVALUE(ICNT)=AICC
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='BIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=BIC
CCCCC IDIGIT(ICNT)=-7
C
      NUMROW=ICNT
      DO2320I=1,NUMROW
        NTOT(I)=15
 2320 CONTINUE
C
      IFRST=.FALSE.
      ILAST=.FALSE.
      ITITLZ=' '
      NCTITZ=0
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLFL')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLFL--')
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLFN(Y,N,
     1                  TEMP1,DTEMP1,MAXNXT,
     1                  ALOC,SCALE,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD ESTIMATES
C              FOR THE FOLDED NORMAL DISTRIBUTION.
C              THE MAXIMUM LIKELIHOOD ESTIMATES ARE THE SOLUTION TO
C              THE FOLLOWING SIMULTANEOUS NONLINEAR EQUATIONS:
C              EQUATIONS.
C
C              LOC**2 + SCALE**2 - SUM[i=1 to n][X(i)**2]/N
C
C              LOC - SUM[i=1 to n][X(i)*tanh(LOC*X(i)/SCALE**2)]/n
C
C              WITH LOC AND SCALE DENOTING THE SHAPE PARAMETERS.
C
C     EXAMPLE--FOLDED NORMAL MAXIMUM LIKELIHOOD Y
C     REFERENCE--"CONTINUOUS UNIVARIATE DISTRIBUTIONS-VVOLUME II",
C                SECOND EDITION, JOHNSON, KOTZ, AND BALAKRISHNAN,
C                1994, WILEY, P. 454.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004/3
C     ORIGINAL VERSION--MARCH     2004.
C     UPDATED         --AUGUST    2005. REFORMAT OUTPUT FOR CONSISTENCY
C                                       WITH OTHER ML ROUTINES
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      PARAMETER (MAXROW=20)
      CHARACTER*60 ITITLE
      CHARACTER*1  ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 ITEXT(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION TEMP1(*)
      DOUBLE PRECISION DTEMP1(*)
C
      DIMENSION QP(1)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='FN  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLFN')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLFN--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N
   52   FORMAT('IBUGA3,ISUBRO,N = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,E15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLFN')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NPERC=0
      NMIN=2
      CALL CKDIST(Y,N,NMIN,QP,NPERC,ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C               ********************************************
C               **  STEP 21--                             **
C               **  CARRY OUT CALCULATIONS                **
C               **  FOR FOLDED NORMAL MLE ESTIMATION      **
C               ********************************************
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLFN')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IERROR='NO'
      IWRITE='OFF'
      CALL FNRML1(Y,N,MAXNXT,
     1            TEMP1,DTEMP1,
     1            XMEAN,XSD,XVAR,XMIN,XMAX,
     1            ALOC,SCALE,
     1            ISUBRO,IBUGA3,IERROR)
C
C               ***********************************************
C               **   STEP 42--                               **
C               **   WRITE OUT EVERYTHING                    **
C               **   FOR FOLDED NORMAL MLE                   **
C               **   ESTIMATION                              **
C               ***********************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLFN')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     PRINT SUMMARY STATISTICS TABLE
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Folded Normal Parameter Estimation'
      NCTITL=34
      ITEXT(1)='Summary Statistics:'
      NCTEXT(1)=19
      AVALUE(1)=0.0
      IDIGIT(1)=0
      ITEXT(2)='Number of Observations:'
      NCTEXT(2)=23
      AVALUE(2)=REAL(N)
      IDIGIT(2)=0
      ITEXT(3)='Sample Mean:'
      NCTEXT(3)=12
      AVALUE(3)=XMEAN
      IDIGIT(3)=NUMDIG
      ITEXT(4)='Sample Standard Deviation:'
      NCTEXT(4)=26
      AVALUE(4)=XSD
      IDIGIT(4)=NUMDIG
      ITEXT(5)='Sample Minimum:'
      NCTEXT(5)=15
      AVALUE(5)=XMIN
      IDIGIT(5)=NUMDIG
      ITEXT(6)='Sample Minimum:'
      NCTEXT(6)=15
      AVALUE(6)=XMAX
      IDIGIT(6)=NUMDIG
      ITEXT(7)=' '
      NCTEXT(7)=0
      AVALUE(7)=0.0
      IDIGIT(7)=-1
C
      ICNT=8
      ITEXT(ICNT)='Maximum Likelihood:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Location:'
      NCTEXT(ICNT)=21
      AVALUE(ICNT)=ALOC
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Scale:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=SCALE
      IDIGIT(ICNT)=NUMDIG
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='Log-likelihood:'
CCCCC NCTEXT(ICNT)=15
CCCCC AVALUE(ICNT)=ALIK
CCCCC IDIGIT(ICNT)=NUMDIG
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=AIC
CCCCC IDIGIT(ICNT)=NUMDIG
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AICc:'
CCCCC NCTEXT(ICNT)=5
CCCCC AVALUE(ICNT)=AICC
CCCCC IDIGIT(ICNT)=NUMDIG
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='BIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=BIC
CCCCC IDIGIT(ICNT)=NUMDIG
      NUMROW=ICNT
      DO2320I=1,NUMROW
        NTOT(I)=15
 2320 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      NCTITZ=0
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLFN')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLFN--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012   FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9015)N
 9015   FORMAT('N = ',I8)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLFR(Y,TAG,N,
     1XTEMP,DTEMP,MAXNXT,MINMAX,
     1SCALE,SCALSE,GAMMA,GAMMSE,GAMMBC,GABCSE,COVSE,COBCSE,
     1NUMV,
     1ICAPSW,ICAPTY,IFORSW,
     1QP,XQPHAT,XQPLCL,XQPUCL,XQPSE,NPERC,
     1IOUNI1,IOUNI2,ALPHAP,
     1ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR FRECHET DISTRIBUTION
C              FOR THE FULL SAMPLE CASE.
C     EXAMPLE--FRECHET MAXIMUM LIKELIHOOD Y
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN
C                ENGINEERING", CAMBRIDGE UNIVERSITY PRESS,
C                1999, CHAPTER 16.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2005/5
C     ORIGINAL VERSION--MAY       2005.
C     UPDATED         --APRIL     2008. ADD MINMAX ARGUMENT TO SUPPORT
C                                       MINIMUM CASE
C     UPDATED         --FEBRUARY  2010. EXTRACT POINT ESTIMATES TO
C                                       EV2ML1
C     UPDATED         --FEBRUARY  2010. USE DPDTA1, DPDTA8, AND
C                                       DPDTA9 TO PRINT OUTPUT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*4 ILIKFL
      CHARACTER*7 ICASE
C
C---------------------------------------------------------------------
C
      PARAMETER (NUMALP=6)
      DIMENSION ALPHA(NUMALP)
      DIMENSION ALOWSC(NUMALP)
      DIMENSION AUPPSC(NUMALP)
      DIMENSION ALOWGA(NUMALP)
      DIMENSION AUPPGA(NUMALP)
      DIMENSION ALOWS2(NUMALP)
      DIMENSION AUPPS2(NUMALP)
      DIMENSION ALOWG2(NUMALP)
      DIMENSION AUPPG2(NUMALP)
C
      DIMENSION Y(*)
      DIMENSION TAG(*)
      DIMENSION XTEMP(*)
      DIMENSION QP(*)
      DIMENSION XQPHAT(*)
      DIMENSION XQPSE(*)
      DIMENSION XQPLCL(*)
      DIMENSION XQPUCL(*)
      DOUBLE PRECISION DTEMP(*)
C
      DOUBLE PRECISION EV2FU2
      DOUBLE PRECISION EV2FU3
      EXTERNAL EV2FU2
      EXTERNAL EV2FU3
C
      INTEGER IN2
      DOUBLE PRECISION DK
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM2
      COMMON/EV2CO2/DK,DTERM1,DTERM2,IN2
      INTEGER IN3
      DOUBLE PRECISION DK2
      DOUBLE PRECISION DTERM6
      DOUBLE PRECISION DTERM7
      DOUBLE PRECISION DGAMMA
      COMMON/EV2CO3/DK2,DTERM6,DTERM7,DGAMMA,IN3
C
      DOUBLE PRECISION DN
      DOUBLE PRECISION DAE
      DOUBLE PRECISION DRE
      DOUBLE PRECISION DG
      DOUBLE PRECISION DS
      DOUBLE PRECISION DT1
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DSUM2
      DOUBLE PRECISION DXSTRT
      DOUBLE PRECISION DXLOW
      DOUBLE PRECISION DXUP
      DOUBLE PRECISION XLOWSV
      DOUBLE PRECISION XUPSV
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=50)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 ITEXT(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA ALPHA /0.50, 0.25, 0.10, 0.05, 0.01, 0.001/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='FR  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLFR')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLFR--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,IFREBC
   52   FORMAT('IBUGA3,ISUBRO,IFREBC = ',A4,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)N,NUMV,NPERC
   55   FORMAT('N,NUMV,NPERC = ',3I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I),TAG(I)
   57     FORMAT('I,Y(I),TAG(I) = ',I8,2E15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLFR')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NMIN=3
      CALL CKDIST(Y,N,NMIN,QP,NPERC,ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C               **********************************
C               **  STEP 41--                   **
C               **  CARRY OUT CALCULATIONS      **
C               **  FOR FRECHET MLE             **
C               **  ESTIMATE (FULL SAMPLE CASE) **
C               **********************************
C
      CALL EV2ML1(Y,N,MINMAX,
     1            XTEMP,DTEMP,
     1            XMEAN,XSD,XVAR,XMIN,XMAX,XLOGSD,XLOGSM,
     1            SCALE,SCALSE,GAMMA,GAMMSE,
     1            GAMMBC,GABCSE,COVSE,COBCSE,
     1            ISUBRO,IBUGA3,IERROR)
C
C  CONFIDENCE INTERVALS FOR PARAMETERS.  CAN BASE ON EITHER NORMAL
C  APPROXIMATION OR ON LIKELIHOOD RATIO APPROXIMATION.
C
C  NORMAL APPROXIMATION FIRST.
C
      DO4110I=1,NUMALP
        ALP=ALPHA(I)
        P=1.0-(ALP/2.0)
        CALL NORPPF(P,PPF)
        ALOWSC(I)=SCALE - PPF*SCALSE
        AUPPSC(I)=SCALE + PPF*SCALSE
        IF(IFREBC.EQ.'ON')THEN
          ALOWGA(I)=GAMMBC - PPF*GABCSE
          AUPPGA(I)=GAMMBC + PPF*GABCSE
        ELSE
          ALOWGA(I)=GAMMA - PPF*GAMMSE
          AUPPGA(I)=GAMMA + PPF*GAMMSE
        ENDIF
 4110 CONTINUE
C
C  NOW DO LIKELIHOOD RATIO APPROXIMATION.
C
      IN2=N
      IN3=N
      DN=DBLE(N)
      DAE=1.D-7
      DRE=1.D-7
      NUTEMP=1
C
      DN=DBLE(N)
      DG=DBLE(GAMMA)
      DS=DBLE(SCALE)
      DT1=DN*DLOG(DBLE(GAMMA)) + DN*DG*DLOG(DS)
      DSUM1=0.0D0
      DSUM2=0.0D0
      DO4125I=1,N
        DTEMP(I)=DBLE(Y(I))
        DSUM1=DSUM1 + DLOG(DBLE(Y(I)))
        DSUM2=DSUM2 + DBLE(Y(I))**(-DG)
 4125 CONTINUE
      DTERM2=DSUM1
      DTERM1=2.0D0*(DT1 - (DG+1.0D0)*DTERM2 - DS**DG*DSUM2)
      DTERM7=DTERM2
      DTERM6=DTERM1
      DGAMMA=DBLE(GAMMA)
C
      DO4120I=1,NUMALP
        ALP=ALPHA(I)
        CALL CHSPPF(1.0-ALP,NUTEMP,APPF)
        DK=DBLE(APPF)
        DK2=DK
C
        DXSTRT=DBLE(ALOWGA(I))
        DXLOW=DXSTRT/5.0D0
        DXUP=DBLE(GAMMA)
        CALL DFZER2(EV2FU2,DXLOW,DXUP,DXSTRT,DRE,DAE,IFLAG,DTEMP)
        ALOWG2(I)=REAL(DXLOW)
C
        DXSTRT=DBLE(AUPPGA(I))
        DXUP=DXSTRT*5.0D0
        DXLOW=DBLE(GAMMA)
        CALL DFZER2(EV2FU2,DXLOW,DXUP,DXSTRT,DRE,DAE,IFLAG,DTEMP)
        AUPPG2(I)=REAL(DXLOW)
C
        DXSTRT=DBLE(ALOWSC(I))
        DXLOW=DXSTRT/5.0D0
        DXUP=DBLE(SCALE)
        CALL DFZER2(EV2FU3,DXLOW,DXUP,DXSTRT,DRE,DAE,IFLAG,DTEMP)
        ALOWS2(I)=REAL(DXLOW)
C
        DXSTRT=DBLE(AUPPSC(I))
        DXUP=DXSTRT*5.0D0
        DXLOW=DBLE(SCALE)
        CALL DFZER2(EV2FU3,DXLOW,DXUP,DXSTRT,DRE,DAE,IFLAG,DTEMP)
        AUPPS2(I)=REAL(DXLOW)
 4120 CONTINUE
C
C  CONFIDENCE INTERVALS FOR SELECTED PERCENTILES.
C
C  1. STANDARD ERROR USES TECHNIQUE DEMONSTRATED IN EXAMPLE 17.4
C     (P. 344) OF BURY.  THIS IS BASED ON PROPOGATION OF ERROR.
C 
C  2. CONFIDENCE INTERVAL IS THEN GENERATED USING NORMAL
C     APPROXIMATION (EXAMPLE 17.7 OF BURY).  BURY ALSO DEMONSTRATES
C     A LIKELIHOOD RATIO APPROACH, BUT OMIT THIS FOR NOW.
C
      IF(NPERC.GE.1)THEN
C
        ALPHL=ALPHAP/2.0
        ALPHU=1.0 - ALPHAP/2.0
        CALL NORPPF(ALPHU,Z95)
        MINMAX=2
C
        IF(IFREBC.EQ.'ON')THEN
          G=GAMMBC
          GSE=GABCSE
          COV=COBCSE
        ELSE
          G=GAMMA
          GSE=GAMMSE
          COV=COVSE
        ENDIF
C
        WRITE(IOUNI1,4131)
        WRITE(IOUNI1,4132)
        DO4129I=1,NPERC
          QPTEMP=QP(I)/100.0
          CALL EV2PPF(QPTEMP,G,MINMAX,APPF)
          XQPHAT(I)=SCALE*APPF
C
          C=LOG(1.0/QPTEMP)
          DA=C**(-1.0/G)
          DB=(SCALE*C**(-1.0/G)*LOG(C)/(G**2))
          TERM1=(DA*SCALSE)**2
          TERM2=(DB*GSE)**2
          TERM3=2.0*DA*DB*COV*COV
          SEXQP=SQRT(TERM1 + TERM2 + TERM3)
          XQPSE(I)=SEXQP
          XQPLCL(I)=XQPHAT(I) - Z95*SEXQP
          XQPUCL(I)=XQPHAT(I) + Z95*SEXQP
          WRITE(IOUNI1,'(5E15.7)')
     1         QP(I),XQPHAT(I),XQPSE(I),XQPLCL(I),XQPUCL(I)
 4129   CONTINUE
 4131   FORMAT(15X,'       POINT     ','     LOWER     ',
     1         '     UPPER')
 4132   FORMAT('    PERCENTILE ','     ESTIMATE   ',
     1         'CONFIDENCE LIMIT ','CONFIDENCE LIMIT')
      ENDIF
C
C               *************************************
C               **   STEP 42--                     **
C               **   WRITE OUT EVERYTHING          **
C               **   FOR FRECHET MLE ESTIMATE      **
C               *************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLFR')
     1  CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     PRINT SUMMARY STATISTICS TABLE
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ICASE='MINIMUM'
      IF(MINMAX.EQ.2)ICASE='MAXIMUM'
C
      IF(ICASE.EQ.'MINIMUM')THEN
        ITITLE='Two-Parameter Frechet (Minimum) Parameter Estimation:'
        NCTITL=53
        ITITLZ='Full Sample Case'
        NCTITZ=16
      ELSEIF(ICASE.EQ.'MAXIMUM')THEN
        ITITLE='Two-Parameter Frechet (Maximum) Parameter Estimation:'
        NCTITL=53
        ITITLZ='Full Sample Case'
        NCTITZ=16
      ENDIF
      ITEXT(1)='Summary Statistics:'
      NCTEXT(1)=19
      AVALUE(1)=0.0
      IDIGIT(1)=-1
      ITEXT(2)='Number of Observations:'
      NCTEXT(2)=23
      AVALUE(2)=REAL(N)
      IDIGIT(2)=0
      ITEXT(3)='Sample Mean:'
      NCTEXT(3)=12
      AVALUE(3)=XMEAN
      IDIGIT(3)=NUMDIG
      ITEXT(4)='Sample Standard Deviation:'
      NCTEXT(4)=26
      AVALUE(4)=XSD
      IDIGIT(4)=NUMDIG
      ITEXT(5)='Sample Minimum:'
      NCTEXT(5)=15
      AVALUE(5)=XMIN
      IDIGIT(5)=NUMDIG
      ITEXT(6)='Sample Maximum:'
      NCTEXT(6)=15
      AVALUE(6)=XMAX
      IDIGIT(6)=NUMDIG
      NUMROW=6
      DO2310I=1,NUMROW
        NTOT(I)=15
 2310 CONTINUE
      NTOT(2)=8
C
      IFRST=.TRUE.
      ILAST=.FALSE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,
     1            NCTEXT,AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
      IFRST=.FALSE.
      ITITLE=' '
      NCTITL=0
C
      ITEXT(1)='Maximum Likelihood:'
      NCTEXT(1)=19
      AVALUE(1)=0.0
      IDIGIT(1)=0
      ITEXT(2)='Estimate of Shape (Gamma):'
      NCTEXT(2)=26
      AVALUE(2)=GAMMA
      IDIGIT(2)=NUMDIG
      ITEXT(3)='Standard Error of Shape:'
      NCTEXT(3)=24
      AVALUE(3)=GAMMSE
      IDIGIT(3)=NUMDIG
      ICNT=3
      ITEXT(4)='Estimate of Scale:'
      NCTEXT(4)=18
      AVALUE(4)=SCALE
      IDIGIT(4)=NUMDIG
      ITEXT(5)='Standard Error of Scale:'
      NCTEXT(5)=24
      AVALUE(5)=SCALSE
      IDIGIT(5)=NUMDIG
      ITEXT(6)='Shape/Scale Covariance:'
      NCTEXT(6)=23
      AVALUE(6)=COVSE
      IDIGIT(6)=NUMDIG
C
      ICNT=6
C
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='Log-likelihood:'
CCCCC NCTEXT(ICNT)=15
CCCCC AVALUE(ICNT)=ALIK
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=AIC
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AICc:'
CCCCC NCTEXT(ICNT)=5
CCCCC AVALUE(ICNT)=AICC
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='BIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=BIC
CCCCC IDIGIT(ICNT)=-7
C
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Maximum Likelihood (Bias Corrected):'
      NCTEXT(ICNT)=36
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Shape (Gamma):'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=GAMMBC
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Standard Error of Shape:'
      NCTEXT(ICNT)=24
      AVALUE(ICNT)=GABCSE
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Scale:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=SCALE
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Standard Error of Scale:'
      NCTEXT(ICNT)=24
      AVALUE(ICNT)=SCALSE
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Shape/Scale Covariance:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=COVSE
      IDIGIT(ICNT)=NUMDIG
C
      NUMROW=ICNT
      DO2320I=1,NUMROW
        NTOT(I)=15
 2320 CONTINUE
C
      IFRST=.FALSE.
      ILAST=.FALSE.
      ITITLZ=' '
      NCTITZ=0
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
      ILIKFL='ON'
      CALL DPDTA8(ALOWSC,AUPPSC,ALOWS2,AUPPS2,
     1            ALOWGA,AUPPGA,ALOWG2,AUPPG2,ALPHA,NUMALP,
     1            ICAPSW,ICAPTY,NUMDIG,ILIKFL,
     1            ISUBRO,IBUGA3,IERROR)
C
      IF(NPERC.GT.1)THEN
        ILIKFL='OFF'
        CALL DPDTA9(QP,XQPHAT,XQPLCL,XQPUCL,XQPSE,NPERC,
     1              ICAPSW,ICAPTY,ILIKFL,NUMDIG,ALPHAP,
     1              ISUBRO,IBUGA3,IERROR)
      
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLFR')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLFR--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012   FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9015)N
 9015   FORMAT('N = ',I8)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLG1(Y,TAG,N,
     1XTEMP,DTEMP,MAXNXT,
     1SCALMO,SHAPMO,SCALML,SCALSE,SHAPML,SHAPSE,COVSE,
     1AIC,AICC,BIC,ALIKE,
     1NUMV,
     1ICAPSW,ICAPTY,IGAMFL,IFORSW,
     1QP,XQPHAT,XQPLCL,XQPUCL,XQPSE,NPERC,
     1IOUNI1,IOUNI2,ALPHAP,
     1ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR GAMMA DISTRIBUTION
C              FOR THE FULL SAMPLE CASE.
C     EXAMPLE--GAMMA MAXIMUM LIKELIHOOD Y
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN
C                ENGINEERING", CAMBRIDGE UNIVERSITY PRESS,
C                1999, CHAPTER 13.
C              --JOHNSON, KOTZ, AND BALAKRISNAN, "CONTINUOUS
C                UNIVARIATE DISTRIBUTIONS--VOLUME 1", SECOND EDITION,
C                WILEY, 1994, CHAPTER xx.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004/11
C     ORIGINAL VERSION--NOVEMBER  2004. NOTE: THIS REPLACES SOME
C                                       EARLIER IMPLEMENTATIONS.
C     UPDATED         --JULY      2008. ADD SUPPORT FOR INVERTED GAMMA
C     UPDATED         --FEBRUARY  2010. PUT POINT ESTIMATES IN A
C                                       SEPARATE ROUTINE TO MAKE IT
C                                       EASIER TO CALL FROM OTHER
C                                       ROUTINES (BOOTSTRAP, GOODNESS
C                                       OF FIT)
C     UPDATED         --FEBRUARY  2010. USE DPDTA1, DPDTA8, DPDTA9
C                                       ROUTINES TO PRINT OUTPUT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IGAMFL
      CHARACTER*4 IFORSW
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*4 ILIKFL
      CHARACTER*40 IDIST
C
C---------------------------------------------------------------------
C
      PARAMETER (NUMALP=6)
      DIMENSION ALPHA(NUMALP)
      DIMENSION ALOWSC(NUMALP)
      DIMENSION AUPPSC(NUMALP)
      DIMENSION ALOWGA(NUMALP)
      DIMENSION AUPPGA(NUMALP)
      DIMENSION ALOWS2(NUMALP)
      DIMENSION AUPPS2(NUMALP)
      DIMENSION ALOWG2(NUMALP)
      DIMENSION AUPPG2(NUMALP)
C
      DIMENSION Y(*)
      DIMENSION TAG(*)
      DIMENSION XTEMP(*)
      DIMENSION QP(*)
      DIMENSION XQPHAT(*)
      DIMENSION XQPSE(*)
      DIMENSION XQPLCL(*)
      DIMENSION XQPUCL(*)
      DOUBLE PRECISION DTEMP(*)
C
      DOUBLE PRECISION GAMFU2
      DOUBLE PRECISION GAMFU3
      REAL GAMFU8
      REAL GAMFU9
      EXTERNAL GAMFU2
      EXTERNAL GAMFU3
      EXTERNAL GAMFU8
      EXTERNAL GAMFU9
C
      INTEGER IN2
      DOUBLE PRECISION DK
      DOUBLE PRECISION DXBAR
      DOUBLE PRECISION DGMEAN
      DOUBLE PRECISION DSCALE
      DOUBLE PRECISION DGAM
      COMMON/GAMCO2/DK,DXBAR,DGMEAN,DSCALE,DGAM,IN2
C
      INTEGER IN3
      DOUBLE PRECISION DK2
      DOUBLE PRECISION DTERM6
      DOUBLE PRECISION DTERM7
      DOUBLE PRECISION DGAMMA
      COMMON/GAMCO3/DK2,DTERM6,DTERM7,DGAMMA,IN3
C
      COMMON/GAMCO8/P8,SCALE8
      COMMON/GAMCO9/P9,GHAT9
C
      DOUBLE PRECISION DN
      DOUBLE PRECISION AE
      DOUBLE PRECISION RE
      DOUBLE PRECISION DG
      DOUBLE PRECISION DS
      DOUBLE PRECISION DT1
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DSUM2
      DOUBLE PRECISION DXSTRT
      DOUBLE PRECISION DXLOW
      DOUBLE PRECISION DXUP
      DOUBLE PRECISION XLOWSV
      DOUBLE PRECISION XUPSV
      DOUBLE PRECISION DANS(10)
      DOUBLE PRECISION TRIGAM
      DOUBLE PRECISION DTRM11
      DOUBLE PRECISION DTRM12
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=50)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 ITEXT(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA ALPHA /0.50, 0.25, 0.10, 0.05, 0.01, 0.001/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='G1  '
      IERROR='NO'
C
      IF(IGAMFL.EQ.'IGAM')THEN
        IDIST='INVERTED GAMMA'
      ELSE
        IDIST='GAMMA'
      ENDIF
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLG1')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLG1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,IGAMFL,N
   52   FORMAT('IBUGA3,ISUBRO,IGAMFL,N = ',3(A4,2X),I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I),TAG(I)
   57     FORMAT('I,Y(I),TAG(I) = ',I8,2E15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLG1')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NMIN=3
      CALL CKDIST(Y,N,NMIN,QP,NPERC,ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      CALL GAMML1(Y,N,IGAMFL,
     1            XTEMP,DTEMP,
     1            XMEAN,XSD,XVAR,XMIN,XMAX,XGEOM,
     1            ZMEAN,ZSD,ZGEOM,
     1            SCALML,SCALSE,SHAPML,SHAPSE,COVSE,
     1            SCALMO,SHAPMO,
     1            ISUBRO,IBUGA3,IERROR)
C
C     CONFIDENCE INTERVALS FOR PARAMETERS.  CAN BASE ON EITHER NORMAL
C     APPROXIMATION OR ON LIKELIHOOD RATIO APPROXIMATION.
C
C     NORMAL APPROXIMATION FIRST.
C
      DO4110I=1,NUMALP
        ALP=ALPHA(I)
        P=1.0-(ALP/2.0)
        CALL NORPPF(P,PPF)
        ALOWSC(I)=SCALML - PPF*SCALSE
        AUPPSC(I)=SCALML + PPF*SCALSE
        ALOWGA(I)=SHAPML - PPF*SHAPSE
        AUPPGA(I)=SHAPML + PPF*SHAPSE
 4110 CONTINUE
C
C     NOW DO LIKELIHOOD RATIO APPROXIMATION.
C
      IN2=N
      IN3=N
      DN=DBLE(N)
      AE=1.D-7
      RE=1.D-7
      NUTEMP=1
C
      DGAM=DBLE(SHAPML)
      DXBAR=DBLE(XMEAN)
      DGMEAN=DBLE(XGEOM)
      DSCALE=DBLE(SCALML)
C
      DO4120I=1,NUMALP
        ALP=ALPHA(I)
        CALL CHSPPF(1.0-ALP,NUTEMP,APPF)
        DK=DBLE(APPF)
        DK2=DK
C
        DXSTRT=DBLE(ALOWGA(I))
        DXLOW=DXSTRT/5.0D0
        DXUP=DBLE(SHAPML)
        CALL DFZERO(GAMFU2,DXLOW,DXUP,DXSTRT,RE,AE,IFLAG)
        ALOWG2(I)=REAL(DXLOW)
C
        DXSTRT=DBLE(AUPPGA(I))
        DXUP=DXSTRT*5.0D0
        DXLOW=DBLE(SHAPML)
        CALL DFZERO(GAMFU2,DXLOW,DXUP,DXSTRT,RE,AE,IFLAG)
        AUPPG2(I)=REAL(DXLOW)
C
        IF(IGAMFL.EQ.'IGAM')THEN
          DXSTRT=MIN(1.0D0/DBLE(ALOWSC(I)),1.0D0/DBLE(AUPPSC(I)))
          DXLOW=DXSTRT/5.0D0
          DXUP=1.0D0/DBLE(SCALML)
        ELSE
          DXSTRT=DBLE(ALOWSC(I))
          DXLOW=DXSTRT/5.0D0
          DXUP=DBLE(SCALML)
        ENDIF
        CALL DFZER2(GAMFU3,DXLOW,DXUP,DXSTRT,RE,AE,IFLAG,DTEMP)
        IF(IGAMFL.EQ.'IGAM')THEN
          ALOWS2(I)=REAL(1.0D0/DXLOW)
        ELSE
          ALOWS2(I)=REAL(DXLOW)
        ENDIF
C
        IF(IGAMFL.EQ.'IGAM')THEN
          DXSTRT=MAX(1.0D0/DBLE(ALOWSC(I)),1.0D0/DBLE(AUPPSC(I)))
          DXUP=DXSTRT*5.0D0
          DXLOW=1.0D0/DBLE(SCALML)
        ELSE
          DXSTRT=DBLE(AUPPSC(I))
          DXUP=DXSTRT*5.0D0
          DXLOW=DBLE(SCALML)
        ENDIF
        CALL DFZER2(GAMFU3,DXLOW,DXUP,DXSTRT,RE,AE,IFLAG,DTEMP)
        IF(IGAMFL.EQ.'IGAM')THEN
          AUPPS2(I)=REAL(1.0D0/DXLOW)
          IF(AUPPS2(I).LT.ALOWS2(I))THEN
            ATEMP=AUPPS2(I)
            AUPPS2(I)=ALOWS2(I)
            ALOWS2(I)=ATEMP
          ENDIF
        ELSE
          AUPPS2(I)=REAL(DXLOW)
        ENDIF
 4120 CONTINUE
C
C     CONFIDENCE INTERVALS FOR SELECTED PERCENTILES.
C
C     1. STANDARD ERROR USES TECHNIQUE DEMONSTRATED IN EXAMPLE 13.1
C        (P. 227) OF BURY.  THIS IS BASED ON PROPOGATION OF ERROR.
C 
C     2. CONFIDENCE INTERVAL IS THEN GENERATED USING NORMAL
C        APPROXIMATION (EXAMPLE 13.1 OF BURY).
C
      IF(NPERC.GE.1)THEN
C
        ALPHL=ALPHAP/2.0
        ALPHU=1.0 - ALPHAP/2.0
        CALL NORPPF(ALPHU,Z95)
C
        GHAT9=SHAPML
        SCALE8=SCALML
        IORD=1
        EPS=0.001
        ACCUR=0.0
C
        WRITE(IOUNI1,4131)
        WRITE(IOUNI1,4132)
        DO4129I=1,NPERC
          QPTEMP=QP(I)/100.0
          CALL GAMPPF(QPTEMP,SHAPML,APPF)
          XQPHAT(I)=SCALML*APPF
C
          P8=QPTEMP
          P9=QPTEMP
C
          IFAIL=0
C
          GHAT   = SHAPML
          GHATMN = 0.0001
          GHATMX = GHAT + 20.0
          CALL DIFF(IORD,GHAT,GHATMN,GHATMX,GAMFU8,EPS,ACCUR,
     1              GHATP,ERROR,IFAIL)
C
          IF(IFAIL.EQ.1)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,301)IDIST
  301       FORMAT('***** WARNING IN NUMERICAL DERIVATIVE FOR ',A14)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,302)
  302       FORMAT('      MAXIMUM LIKELIHOOD PERCENTILES.')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,303)
  303       FORMAT('      THE ESTIMATED ERROR IN THE RESULT ',
     1             'EXCEEDS THE')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,305)
  305       FORMAT('      REQUESTED ERROR, BUT THE MOST ACCURATE ',
     1             'RESULT')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,307)
  307       FORMAT('      POSSIBLE HAS BEEN RETURNED.')
            CALL DPWRST('XXX','BUG ')
          ELSEIF(IFAIL.EQ.2)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,301)IDIST
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,302)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,313)
  313       FORMAT('      ERROR IN THE INPUT TO THE DIFF ROUTINE.')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,315)
  315       FORMAT('      NO PERCENTILES WILL BE GENERATED.')
            CALL DPWRST('XXX','BUG ')
            NPERC=0
          ELSEIF(IFAIL.EQ.3)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,301)IDIST
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,302)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,323)
  323       FORMAT('      THE INTERVAL FOR DIFFERENTIATION, (',G15.7,
     1             ',',G15.7,')')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,325)
  325       FORMAT('      IS TOO SMALL.')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,315)
            CALL DPWRST('XXX','BUG ')
            GHATP=0.0
            NPERC=0
          ENDIF
C
          SCALHT = SCALML
          SCALMN = 0.0001
          SCALMX = SCALHT + 20.0
          CALL DIFF(IORD,SCALHT,SCALMN,SCALMX,GAMFU9,EPS,ACCUR,
     1              SCALEP,ERROR,IFAIL)
C
          IF(IFAIL.EQ.1)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,301)IDIST
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,302)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,303)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,305)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,307)
            CALL DPWRST('XXX','BUG ')
          ELSEIF(IFAIL.EQ.2)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,301)IDIST
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,302)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,313)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,315)
            CALL DPWRST('XXX','BUG ')
            NPERC=0
          ELSEIF(IFAIL.EQ.3)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,301)IDIST
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,302)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,323)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,325)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,315)
            CALL DPWRST('XXX','BUG ')
            GHATP=0.0
            NPERC=0
          ENDIF
          D1=SCALEP
          D2=GHATP
          V11=SCALSE**2
          V22=SHAPSE**2
          V21=COVSE
          V12=V21
          TERM11=D1*D1*V11
          TERM12=D1*D2*V12
          TERM21=D2*D1*V21
          TERM22=D2*D2*V22
          SEXQP=TERM11+TERM12+TERM21+TERM22
          IF(SEXQP.GE.0.0)THEN
            SEXQP=SQRT(SEXQP)
          ELSE
            SEXQP=0.0
          ENDIF
          XQPSE(I)=SEXQP
          XQPLCL(I)=XQPHAT(I) - Z95*SEXQP
          XQPUCL(I)=XQPHAT(I) + Z95*SEXQP
          WRITE(IOUNI1,'(5E15.7)')
     1         QP(I),XQPHAT(I),XQPSE(I),XQPLCL(I),XQPUCL(I)
 4129   CONTINUE
 4131   FORMAT(15X,'       POINT     ','     LOWER     ',
     1         '     UPPER')
 4132   FORMAT('    PERCENTILE ','     ESTIMATE   ',
     1         'CONFIDENCE LIMIT ','CONFIDENCE LIMIT')
      ENDIF
C
C               *************************************
C               **   STEP 42--                     **
C               **   WRITE OUT EVERYTHING          **
C               **   FOR GAMMA MLE ESTIMATE        **
C               *************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLG1')
     1  CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     PRINT SUMMARY STATISTICS TABLE
C
      IF(IPRINT.EQ.'OFF')GOTO8900
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      IF(IGAMFL.EQ.'IGAM')THEN
        ITITLE='Two-Parameter Inverted Gamma Parameter Estimation:'
        NCTITL=50
        ITITLZ='Full Sample Case'
        NCTITZ=16
      ELSE
        ITITLE='Two-Parameter Gamma Parameter Estimation:'
        NCTITL=41
        ITITLZ='Full Sample Case'
        NCTITZ=16
      ENDIF
      ITEXT(1)='Summary Statistics:'
      NCTEXT(1)=19
      AVALUE(1)=0.0
      IDIGIT(1)=0
      ITEXT(2)='Number of Observations:'
      NCTEXT(2)=23
      AVALUE(2)=REAL(N)
      IDIGIT(2)=0
      ITEXT(3)='Sample Mean:'
      NCTEXT(3)=12
      AVALUE(3)=XMEAN
      IDIGIT(3)=NUMDIG
      ITEXT(4)='Sample Standard Deviation:'
      NCTEXT(4)=26
      AVALUE(4)=XSD
      IDIGIT(4)=NUMDIG
      ITEXT(5)='Sample Minimum:'
      NCTEXT(5)=15
      AVALUE(5)=XMIN
      IDIGIT(5)=NUMDIG
      ITEXT(6)='Sample Maximum:'
      NCTEXT(6)=15
      AVALUE(6)=XMAX
      IDIGIT(6)=NUMDIG
      ITEXT(7)='Sample Geometric Mean:'
      NCTEXT(7)=22
      AVALUE(7)=XGEOM
      IDIGIT(7)=NUMDIG
      NUMROW=7
      DO2310I=1,NUMROW
        NTOT(I)=15
 2310 CONTINUE
      NTOT(2)=8
C
      IFRST=.TRUE.
      ILAST=.FALSE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,
     1            NCTEXT,AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
      IFRST=.FALSE.
      ITITLE=' '
      NCTITL=0
C
      ITEXT(1)='Method of Moments:'
      NCTEXT(1)=18
      AVALUE(1)=0.0
      IDIGIT(1)=0
      ITEXT(2)='Estimate of Shape (Gamma):'
      NCTEXT(2)=26
      AVALUE(2)=SHAPMO
      IDIGIT(2)=NUMDIG
      ITEXT(3)='Estimate of Scale:'
      NCTEXT(3)=18
      AVALUE(3)=SCALMO
      IDIGIT(3)=NUMDIG
      ITEXT(4)=' '
      NCTEXT(4)=0
      AVALUE(4)=0.0
      IDIGIT(4)=-1
      ITEXT(5)='Maximum Likelihood:'
      NCTEXT(5)=19
      AVALUE(5)=0.0
      IDIGIT(5)=-1
      ITEXT(6)='Estimate of Shape (Gamma):'
      NCTEXT(6)=26
      AVALUE(6)=SHAPML
      IDIGIT(6)=NUMDIG
      ITEXT(7)='Standard Error of Shape:'
      NCTEXT(7)=24
      AVALUE(7)=SHAPSE
      IDIGIT(7)=NUMDIG
      ITEXT(8)='Estimate of Scale:'
      NCTEXT(8)=18
      AVALUE(8)=SCALML
      IDIGIT(8)=NUMDIG
      ITEXT(9)='Standard Error of Scale:'
      NCTEXT(9)=24
      AVALUE(9)=SCALSE
      IDIGIT(9)=NUMDIG
      ITEXT(10)='Shape/Scale Covariance:'
      NCTEXT(10)=23
      AVALUE(10)=COVSE
      IDIGIT(10)=NUMDIG
C
      ICNT=10
C
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='Log-likelihood:'
CCCCC NCTEXT(ICNT)=15
CCCCC AVALUE(ICNT)=ALIK
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=AIC
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AICc:'
CCCCC NCTEXT(ICNT)=5
CCCCC AVALUE(ICNT)=AICC
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='BIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=BIC
CCCCC IDIGIT(ICNT)=-7
C
      NUMROW=ICNT
      DO2320I=1,NUMROW
        NTOT(I)=15
 2320 CONTINUE
C
      IFRST=.FALSE.
      ILAST=.FALSE.
      ITITLZ=' '
      NCTITZ=0
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
      ILIKFL='ON'
      CALL DPDTA8(ALOWSC,AUPPSC,ALOWS2,AUPPS2,
     1            ALOWGA,AUPPGA,ALOWG2,AUPPG2,ALPHA,NUMALP,
     1            ICAPSW,ICAPTY,NUMDIG,ILIKFL,
     1            ISUBRO,IBUGA3,IERROR)
C
      IF(NPERC.GT.1)THEN
        ILIKFL='ON'
        CALL DPDTA9(QP,XQPHAT,XQPLCL,XQPUCL,XQPSE,NPERC,
     1              ICAPSW,ICAPTY,ILIKFL,NUMDIG,ALPHAP,
     1              ISUBRO,IBUGA3,IERROR)
      
      ENDIF
C
 8900 CONTINUE
      IF(IFEEDB.EQ.'ON' .AND. IPRINT.EQ.'ON')THEN
        WRITE(ICOUT,4291)
 4291   FORMAT('THE FOLLOWING INTERNAL PARAMETERS ARE SAVED:')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4293)
 4293   FORMAT('      GAMMAML, GAMMASE, SCALEML, SCALESE, ',
     1         'GAMMAMOM, SCALEMOM,COVSE')
        CALL DPWRST('XXX','BUG ')
C
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        IF(NPERC.GT.0)THEN
          WRITE(ICOUT,4943)
 4943     FORMAT('PERCENTILE CONFIDENCE LIMITS  WRITTEN TO ',
     1           'FILE  dpst1f.dat')
          CALL DPWRST('XXX','BUG ')
        ENDIF
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLG1')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLG1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012   FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9015)N
 9015   FORMAT('N = ',I8)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLG2(Y,TAG,N,
     1                  TEMP1,XTEMP,YSAVE,DTEMP1,ITEMP,MAXNXT,
     1                  SCALMO,GAMMMO,
     1                  SCALML,SCALSE,GAMMML,GAMMSE,COVSE,
     1                  NUMV,TEND,
     1                  ICAPSW,ICAPTY,IFORSW,IGAMFL,
     1                  QP,XQPHAT,XQPLCL,XQPUCL,XQPSE,NPERC,
     1                  IOUNI1,IOUNI2,ALPHAP,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD ESTIMATES
C              FOR THE TIME CENSORED GAMMA DISTRIBUTION.
C     EXAMPLE--GAMMA MAXIMUM LIKELIHOOD Y CENSOR
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN
C                ENGINEERING", CAMBRIDGE UNIVERSITY PRESS,
C                1999, CHAPTER 13.
C              --JOHNSON, KOTZ, AND BALAKRISNAN, "CONTINUOUS
C                UNIVARIATE DISTRIBUTIONS--VOLUME 1", SECOND EDITION,
C                WILEY, 1994, CHAPTER xx.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004/11
C     ORIGINAL VERSION--NOVEMBER  2004.
C     UPDATED         --JULY      2008. SUPPORT FOR INVERTED GAMMA
C     UPDATED         --JULY      2010. PRINT TABLES WITH DPDTA1,
C                                       DPDTA8, AND DPDTA9
C     UPDATED         --JULY      2010. EXTRACT POINT ESTIMATES TO
C                                       GAMML2
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 IGAMFL
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*40 IDIST
      CHARACTER*4 ICASE
      CHARACTER*4 ILIKFL
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      PARAMETER (NUMALP=6)
      DIMENSION ALPHA(NUMALP)
      DIMENSION ALOWSC(NUMALP)
      DIMENSION AUPPSC(NUMALP)
      DIMENSION ALOWGA(NUMALP)
      DIMENSION AUPPGA(NUMALP)
      DIMENSION ALOWS2(NUMALP)
      DIMENSION AUPPS2(NUMALP)
      DIMENSION ALOWG2(NUMALP)
      DIMENSION AUPPG2(NUMALP)
C
      DIMENSION Y(*)
      DIMENSION TAG(*)
      DIMENSION TEMP1(*)
      DIMENSION XTEMP(*)
      DIMENSION ITEMP(*)
      DIMENSION YSAVE(*)
      DIMENSION QP(*)
      DIMENSION XQPHAT(*)
      DIMENSION XQPSE(*)
      DIMENSION XQPLCL(*)
      DIMENSION XQPUCL(*)
      DOUBLE PRECISION DTEMP1(*)
C
      EXTERNAL GAMFU8
      EXTERNAL GAMFU9
      COMMON/GAMCO8/P8,SCALE8
      COMMON/GAMCO9/P9,GHAT9
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=50)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 ITEXT(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA ALPHA /0.50, 0.25, 0.10, 0.05, 0.01, 0.001/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='G2  '
      IWRITE='NO'
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLG2')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLG2--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)IBUGA3,ISUBRO,ICENTY,N,NUMV,NPERC
   55   FORMAT('IBUGA3,ISUBRO,ICENTY,N,NUMV,NPERC = ',3(A4,2X),3I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I),TAG(I)
   57     FORMAT('I,Y(I),TAG(I) = ',I8,2E15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLG2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NMIN=3
      CALL CKDIST(Y,N,NMIN,QP,NPERC,ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      CALL GAMML2(Y,TAG,N,IGAMFL,MAXNXT,
     1            ICASE,IDIST,
     1            TEMP1,XTEMP,YSAVE,DTEMP1,ITEMP,
     1            XMEANF,XSDF,XVARF,XMINF,XMAXF,XGEOMF,
     1            XMEANC,XSDC,XVARC,XMINC,XMAXC,XGEOMC,
     1            SCALMO,SHAPMO,
     1            SCALML,SCALSE,SHAPML,SHAPSE,COVSE,
     1            IR,ISE,
     1            ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
      IM=N-IR
      IF(ISE.EQ.0)GOTO4199
C
C     CONFIDENCE INTERVALS FOR PARAMETERS BASED ON NORMAL
C     APPROXIMATION
C
      DO4110I=1,NUMALP
        ALP=ALPHA(I)
        P=1.0-(ALP/2.0)
        CALL NORPPF(P,PPF)
        ALOWSC(I)=SCALML - PPF*SCALSE
        AUPPSC(I)=SCALML + PPF*SCALSE
        ALOWGA(I)=SHAPML - PPF*SHAPSE
        AUPPGA(I)=SHAPML + PPF*SHAPSE
 4110 CONTINUE
C
C     CONFIDENCE INTERVALS FOR SELECTED PERCENTILES.
C
C     1. STANDARD ERROR USES TECHNIQUE DEMONSTRATED IN EXAMPLE 13.1
C        (P. 227) OF BURY.  THIS IS BASED ON PROPOGATION OF ERROR.
C 
C     2. CONFIDENCE INTERVAL IS THEN GENERATED USING NORMAL
C        APPROXIMATION (EXAMPLE 13.1 OF BURY).
C
      IF(NPERC.GE.1)THEN
C
        ALPHL=ALPHAP/2.0
        ALPHU=1.0 - ALPHAP/2.0
        CALL NORPPF(ALPHU,Z95)
C
        GHAT9=SHAPML
        SCALE8=SCALML
        IORD=1
        EPS=0.001
        ACCUR=0.0
C
        WRITE(IOUNI1,3531)
        WRITE(IOUNI1,3532)
        DO3529I=1,NPERC
          QPTEMP=QP(I)/100.0
          CALL GAMPPF(QPTEMP,SHAPML,APPF)
          XQPHAT(I)=SCALML*APPF
C
          P8=QPTEMP
          P9=QPTEMP
C
          IFAIL=0
C
          GHAT   = SHAPML
          GHATMN = GHAT/10.0
          GHATMX = GHAT*10.0
          CALL DIFF(IORD,GHAT,GHATMN,GHATMX,GAMFU8,EPS,ACCUR,
     1              GHATP,ERROR,IFAIL)
C
          IF(IFAIL.EQ.1)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,301)
  301       FORMAT('***** WARNING IN NUMERICAL DERIVATIVE FOR GAMMA ',
     1             'MAXIMUM LIKELIHOOD PERCENTILES.')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,303)
  303       FORMAT('      THE ESTIMATED ERROR IN THE RESULT ',
     1             'EXCEEDS THE')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,305)
  305       FORMAT('      REQUESTED ERROR, BUT THE MOST ACCURATE ',
     1             'RESULT')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,307)
  307       FORMAT('      POSSIBLE HAS BEEN RETURNED.')
            CALL DPWRST('XXX','BUG ')
          ELSEIF(IFAIL.EQ.2)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,311)
  311       FORMAT('***** ERROR IN NUMERICAL DERIVATIVE FOR GAMMA ',
     1             'MAXIMUM LIKELIHOOD PERCENTILES.')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,313)
  313       FORMAT('      ERROR IN THE INPUT TO THE DIFF ROUTINE.')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,315)
  315       FORMAT('      NO PERCENTILES WILL BE GENERATED.')
            CALL DPWRST('XXX','BUG ')
            NPERC=0
          ELSEIF(IFAIL.EQ.3)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,311)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,323)
  323       FORMAT('      THE INTERVAL FOR DIFFERENTIATION, (',G15.7,
     1             ',',G15.7,')')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,325)
  325       FORMAT('      IS TOO SMALL.')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,315)
            CALL DPWRST('XXX','BUG ')
            GHATP=0.0
            NPERC=0
          ENDIF
C
          SCALHT = SCALML
          SCALMN = SCALHT/10.0
          SCALMX = SCALHT*10.0
          CALL DIFF(IORD,SCALHT,SCALMN,SCALMX,GAMFU9,EPS,ACCUR,
     1              SCALEP,ERROR,IFAIL)
C
          IF(IFAIL.EQ.1)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,301)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,303)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,305)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,307)
            CALL DPWRST('XXX','BUG ')
          ELSEIF(IFAIL.EQ.2)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,311)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,313)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,315)
            CALL DPWRST('XXX','BUG ')
            NPERC=0
          ELSEIF(IFAIL.EQ.3)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,311)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,323)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,325)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,315)
            CALL DPWRST('XXX','BUG ')
            GHATP=0.0
            NPERC=0
          ENDIF
          D1=SCALEP
          D2=GHATP
          V11=SCALSE**2
          V22=SHAPSE**2
          V21=COVSE
          V12=V21
          TERM11=D1*D1*V11
          TERM12=D1*D2*V12
          TERM21=D2*D1*V21
          TERM22=D2*D2*V22
          SEXQP=TERM11+TERM12+TERM21+TERM22
          IF(SEXQP.GE.0.0)THEN
            SEXQP=SQRT(SEXQP)
          ELSE
            SEXQP=0.0
          ENDIF
          XQPSE(I)=SEXQP
          XQPLCL(I)=XQPHAT(I) - Z95*SEXQP
          XQPUCL(I)=XQPHAT(I) + Z95*SEXQP
          WRITE(IOUNI1,'(5E15.7)')
     1         QP(I),XQPHAT(I),XQPSE(I),XQPLCL(I),XQPUCL(I)
 3529   CONTINUE
 3531   FORMAT(15X,'       POINT     ','   STANDARD    ',
     1         '     LOWER     ',
     1         '     UPPER')
 3532   FORMAT('    PERCENTILE ','     ESTIMATE   ',
     1         '     ERROR     ',
     1         'CONFIDENCE LIMIT ','CONFIDENCE LIMIT')
      ENDIF
C
 4199 CONTINUE
C               *************************************
C               **   STEP 42--                     **
C               **   WRITE OUT EVERYTHING          **
C               **   FOR GAMMA MLE ESTIMATE        **
C               *************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLG2')
     1  CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     PRINT SUMMARY STATISTICS TABLE
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      IF(IGAMFL.EQ.'IGAM')THEN
        ITITLE='Two-Parameter Inverted Gamma Parameter Estimation:'
        NCTITL=50
        ITITLZ='Censored Case'
        NCTITZ=13
      ELSE
        ITITLE='Two-Parameter Gamma Parameter Estimation:'
        NCTITL=41
        ITITLZ='Censored Case'
        NCTITZ=13
      ENDIF
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-99
      ICNT=ICNT+1
      ITEXT(ICNT)='Total Number of Observations:'
      NCTEXT(ICNT)=29
      AVALUE(ICNT)=REAL(N)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Uncensored Observations:'
      NCTEXT(ICNT)=34
      AVALUE(ICNT)=REAL(IR)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Censored Observations:'
      NCTEXT(ICNT)=32
      AVALUE(ICNT)=REAL(IM)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean (All Data):'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=XMEANF
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample SD (All Data):'
      NCTEXT(ICNT)=21
      AVALUE(ICNT)=XSDF
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum (All Data):'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XMINF
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum (All Data):'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XMAXF
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Geometric Mean (All Data):'
      NCTEXT(ICNT)=33
      AVALUE(ICNT)=XGEOMF
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean (Uncensored Data):'
      NCTEXT(ICNT)=30
      AVALUE(ICNT)=XMEANC
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample SD (Uncensored Data):'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSDF
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum (Uncensored Data):'
      NCTEXT(ICNT)=33
      AVALUE(ICNT)=XMINC
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum (Uncensored Data):'
      NCTEXT(ICNT)=33
      AVALUE(ICNT)=XMAXC
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Geometric Mean (Uncensored Data):'
      NCTEXT(ICNT)=40
      AVALUE(ICNT)=XGEOMC
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Moments:'
      NCTEXT(ICNT)=8
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Shape (Gamma):'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=SHAPMO
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Scale:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=SCALMO
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Maximum Likelihood:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Shape (Gamma):'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=SHAPML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Standard Error of Shape:'
      NCTEXT(ICNT)=24
      AVALUE(ICNT)=SHAPSE
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Scale:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=SCALML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Standard Error of Scale:'
      NCTEXT(ICNT)=24
      AVALUE(ICNT)=SCALSE
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Shape/Scale Covariance:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=COVSE
      IDIGIT(ICNT)=NUMDIG
C
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='Log-likelihood:'
CCCCC NCTEXT(ICNT)=15
CCCCC AVALUE(ICNT)=ALIK
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=AIC
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AICc:'
CCCCC NCTEXT(ICNT)=5
CCCCC AVALUE(ICNT)=AICC
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='BIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=BIC
CCCCC IDIGIT(ICNT)=-7
C
      NUMROW=ICNT
      DO2310I=1,NUMROW
        NTOT(I)=15
 2310 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
      ILIKFL='OFF'
      CALL DPDTA8(ALOWSC,AUPPSC,ALOWS2,AUPPS2,
     1            ALOWGA,AUPPGA,ALOWG2,AUPPG2,ALPHA,NUMALP,
     1            ICAPSW,ICAPTY,NUMDIG,ILIKFL,
     1            ISUBRO,IBUGA3,IERROR)
C
      IF(NPERC.GT.1)THEN
        ILIKFL='OFF'
        CALL DPDTA9(QP,XQPHAT,XQPLCL,XQPUCL,XQPSE,NPERC,
     1              ICAPSW,ICAPTY,ILIKFL,NUMDIG,ALPHAP,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLG2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLG2--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012   FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9015)N
 9015   FORMAT('N = ',I8)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLGD(Y,N,
     1                  XTEMP,DTEMP1,MAXNXT,
     1                  CSV,ALPHSV,SCALSV,
     1                  CML,ALPHML,SCALML,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES MOMENT ESTIMATES
C              FOR THE GENERALIZED GAMMA DISTRIBUTION.
C              THE MOMENT ESTIMATES ARE THE SOLUTION TO
C              THE FOLLOWING SIMULTANEOUS NONLINEAR EQUATIONS:
C
C              A*(GAMMA(K+1/C))**2 - GAMMA(K+2/C)*GAMMA(K) = 0
C
C              XBAR - GAMMA(K+1/C)/(ALPHA*GAMMA(K)) = 0
C
C              SUM[i=1 to n][X(i)**C] - N*K/(ALPHA**C)
C
C              WHERE
C
C
C              ALPHA = 1/SCALE
C              C, K  = SHAPE PARAMETERS
C              A = {N*XBAR**2 + (N-1)*S**2}/{N*XBAR**2 - S**2)
C
C     EXAMPLE--GENERALIZED GAMMA MAXIMUM LIKELIHOOD Y
C     REFERENCE--HWANG AND HUANG (2006), "ON NEW MOMENT ESTIMATION
C                OF PARAMETERS OF THE GENERALIZED GAMMA DISTRIBUTION
C                USING IT'S CHARACTERIZATION", TAIWANESE JOURNAL OF
C                MATHEMATICS, VOL.10, NO. 4, PP. 1083-1093.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2007/1
C     ORIGINAL VERSION--JANUARY   2007.
C     UPDATED         --MAY       2011. USE DPDTA1 TO PRINT OUTPUT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION XTEMP(*)
      DOUBLE PRECISION DTEMP1(*)
C
      DOUBLE PRECISION DN
      DOUBLE PRECISION TOL
      DOUBLE PRECISION XPAR(3)
      DOUBLE PRECISION FVEC(3)
C
      DOUBLE PRECISION XBAR
      DOUBLE PRECISION S2
      DOUBLE PRECISION DA
      COMMON/GGDCOM/XBAR,S2,DA
C
      EXTERNAL GGDFUN
C
      CHARACTER*40 IDIST
      PARAMETER (MAXROW=20)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 ITEXT(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='GD  '
C
      IERROR='NO'
      IWRITE='OFF'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLGD')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLGD--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N
   52   FORMAT('IBUGA3,ISUBRO,N = ',2(A4,2X),I8)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,53)CSV,ALPHSV,SCALSV
   53   FORMAT('CSV,ALPHSV,SCALSV = ',3G15.7)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLGD')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NMIN=5
      NPERC=0
      CALL CKDIST(Y,N,NMIN,XTEMP,NPERC,ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IDIST='GENERALIZED GAMMA'
      IFLAG=1
      CALL SUMRAW(Y,N,IDIST,IFLAG,
     1            XMEAN,XVAR,XSD,XMIN,XMAX,
     1            ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C               *************************************************
C               **  STEP 21--                                  **
C               **  CARRY OUT CALCULATIONS                     **
C               **  FOR GENERALIZED GAMMA MLE ESTIMATION       **
C               *************************************************
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLGD')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL SORT(Y,N,Y)
C
C     USE MOMENT ESTIMATES FOR GAMMA DISTRIBUTION AS STARTING
C     VALUES.
C
      XBAR=DBLE(XMEAN)
      S2=DBLE(XSD)**2
      DN=DBLE(N)
      DA=(DN*XBAR**2 + (DN-1.0D0)*S2)/(DN*XBAR**2 - S2)
C
      IF(CSV.GT.0.0 .AND. ALPHSV.GT.0.0 .AND.
     1   SCALSV.GT.0.0)THEN
        XPAR(1)=DBLE(CSV)
        XPAR(2)=DBLE(ALPHSV)
        XPAR(3)=DBLE(SCALSV)
      ELSE
        XPAR(1)=1.0D0
        XPAR(2)=(XBAR**2/S2) - (1.0D0/DBLE(N))
        XPAR(3)=XPAR(2)/XBAR
      ENDIF
C
      IOPT=2
      TOL=1.0D-6
      NVAR=3
      NPRINT=-1
      INFO=0
      LWA=MAXNXT
      CALL DNSQE(GGDFUN,JAC,IOPT,NVAR,XPAR,FVEC,TOL,NPRINT,INFO,
     1           DTEMP1,MAXNXT,Y,N)
C
      CML=REAL(XPAR(1))
      ALPHML=REAL(XPAR(2))
      SCALML=REAL(1.0D0/XPAR(3))
C
C               ***********************************************
C               **   STEP 42--                               **
C               **   WRITE OUT EVERYTHING                    **
C               **   FOR GENERALIZED GAMMA  ML ESTIMATION    **
C               ***********************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLGD')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     PRINT SUMMARY STATISTICS TABLE
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Generalized Gamma Parameter Estimation: Full Sample Case'
      NCTITL=56
      ITITLZ=' '
      NCTITZ=0
C
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(N)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Hwang and Huang Moment Estimates:'
      NCTEXT(ICNT)=33
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of C:'
      NCTEXT(ICNT)=14
      AVALUE(ICNT)=CML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Alpha:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=ALPHML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Scale:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=SCALML
      IDIGIT(ICNT)=NUMDIG
C
      NUMROW=ICNT
      DO2310I=1,NUMROW
        NTOT(I)=15
 2310 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLGD')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLGD--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)IERROR
 9012   FORMAT('IERROR = ',A4)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLGG(Y,X,N,NVAR,
     1                  TEMP1,TEMP2,TEMP3,DTEMP1,
     1                  PMOM,AMOM,PML,AML,PVARML,AVARML,COVML,
     1                  ICAPSW,ICAPTY,IFORSW,MAXNXT,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR THE GENERALIZED LOST GAMES
C              DISTRIBUTION.
C
C              IT IS ASSUMED THAT J IS KNOWN (TYPICALLY IT WILL
C              BE THE MINIMUM DATA POINT).
C
C              THE METHOD OF MOMENT ESTIMATES ARE:
C
C              PHAT = 0.5 + {XBAR + SQRT[XBAR*(XBAR+8*S**2)]/{8*S**2}
C
C              AHAT = XBAR*(1/(1-PHAT) - 2)
C
C              WITH XBAR AND S**2 DENOTING THE SAMPLE MEAN AND
C              VARIANCE, RESPECTIVELY.
C
C              THE MAXIMUM LIKELIHOOD ESTIMATES ARE:
C
C              1) USE THE MINIMUM VALUE AS THE ESTIMATE OF J.
C                 THEN SHIFT THE DATA TO START AT ZERO (I.E.,
C                 J = 0).
C
C              2) THEN SOLVE THE FOLLOWING SIMULTANEOUS EQUATIONS:
C
C                 N*SUM[x>=0][f(x)*{(a+x)/p - x/(1-p)} = 0
C
C                 N*SUM[x >= 0][f(x)*{LOG(p) + 1/a + PSI(a+2*x) - 
C                 PS(a+x-1)}] = 0
C
C              WITH N, f(x), AND PSI DENOTING THE TOTAL SAMPLE
C              SIZE, THE FREQUENCY FOR CLASS X = x, AND THE
C              DIGAMMA FUNCTION, RESPECTIVELY.
C
C              THERE ARE TWO CASES:
C
C              1) ONE VARIABLE CASE: Y IS RAW DATA
C              2) TWO VARIABLE CASE: Y IS FREQUENCY, X IS CLASS
C                 MID-POINT.
C
C     EXAMPLE--GENERALIZED LOST GAMES MAXIMUM LIKELIHOOD Y
C            --GENERALIZED LOST GAMES MAXIMUM LIKELIHOOD Y X
C     REFERENCES--JOHNSON, KOTZ, AND KEMP (2006).  "UNIVARIATE
C                 DISCRETE DISTRIBUTIONS", THIRD EDITION, 
C                 WILEY, PP. 503-505.
C               --KEMP AND KEMP (1992), "A GROUP-DYNAMIC MODEL AND
C                 THE LOST-GAMES DISTRIBUTION", COMMUNICATIONS IN
C                 STATISTICS--THEORY AND METHODS, 21(3),
C                 PP. 791-798.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2006/12
C     ORIGINAL VERSION--DECEMBER  2006.
C     UPDATED         --APRIL     2011. USE DPDTA1 AND DPDTA4 TO
C                                       PRINT OUTPUT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-----------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*4 ISUBN0
      CHARACTER*4 IRELAT
      CHARACTER*4 IRHSTG
C
C-------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION TEMP1(*)
      DIMENSION TEMP2(*)
      DIMENSION TEMP3(*)
C
      DOUBLE PRECISION DTEMP1(*)
C
      DOUBLE PRECISION DN
      DOUBLE PRECISION DX
      DOUBLE PRECISION DX2
      DOUBLE PRECISION DFREQ
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DSUM2
C
      DOUBLE PRECISION TOL
      DOUBLE PRECISION XPAR(2)
      DOUBLE PRECISION FVEC(2)
C
      EXTERNAL GLGFUN
CCCCC EXTERNAL GLGFU2
CCCCC EXTERNAL GLGFU3
      DOUBLE PRECISION XBAR
      DOUBLE PRECISION S2
      DOUBLE PRECISION DF0
      COMMON/GLGCOM/XBAR,S2,DF0,MAXRO2,IINDX,NTOTZZ
C
      PARAMETER (MAXROW=30)
      CHARACTER*60 ITITLE
      CHARACTER*1  ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 IDIST
      CHARACTER*40 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(MAXROW)
      CHARACTER*4  VALIGN(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL      IFRST
      LOGICAL      ILAST
C
C-------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT---------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='GG  '
C
      IERROR='NO'
      IWRITE='OFF'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLGG')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLGG--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N,NVAR
   52   FORMAT('IBUGA3,ISUBRO,N,NVAR = ',2(A4,2X),2I8)
        CALL DPWRST('XXX','WRIT')
        IF(NVAR.EQ.1)THEN
          DO56I=1,MIN(N,100)
            WRITE(ICOUT,57)I,Y(I)
   57       FORMAT('I,Y(I) = ',I8,G15.7)
            CALL DPWRST('XXX','WRIT')
   56     CONTINUE
        ELSE
          DO61I=1,N
            WRITE(ICOUT,62)I,X(I),Y(I)
   62       FORMAT('I,X(I),Y(I) = ',I8,2G15.7)
            CALL DPWRST('XXX','WRIT')
   61     CONTINUE
        ENDIF
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  1) ROUND DATA TO INTEGER VALUES       **
C               **  2) COMPUTE SUMMARY STATISTICS         **
C               **  3) CHECK INPUT FOR NEGATIVE VALUES,   **
C               **     INSUFFICIENT SAMPLE SIZE           **
C               **  4) FOR RAW DATA CASE, BIN THE DATA.   **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLGG')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IDIST='GENERALIZED LOST GAMES'
C
      NPERC=0
      MAXGRP=MAXNXT/2
      NMIN=2
      IF(NVAR.EQ.1)THEN
        DO1105I=1,N
          ITEMP=INT(Y(I)+0.5)
          Y(I)=REAL(ITEMP)
 1105   CONTINUE
        CALL CKDIST(Y,N,NMIN,TEMP1,NPERC,ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
        CALL SORT(Y,N,Y)
        IFLAG=1
        CALL SUMRAW(Y,N,IDIST,IFLAG,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        NTOTZZ=N
C
        IRELAT='OFF'
        IRHSTG='OFF'
        XSTART=XMIN-0.5
        XSTOP=XMAX+0.5
        CLWID=1.0
        CALL DPBINI(Y,N,IRELAT,CLWID,XSTART,XSTOP,IRHSTG,
     1              TEMP1,X,N2,IBUGA3,IERROR)
        ICNT=0
        DO1121I=1,N2
          Y(I)=TEMP1(I)
          IF(TEMP1(I).GT.0.0)THEN
            ICNT=ICNT+1
            Y(ICNT)=Y(I)
            X(ICNT)=X(I)
          ENDIF
1121    CONTINUE
        N2=ICNT
        IF(IERROR.EQ.'YES')GOTO9000
      ELSE
        CALL CKDIS2(Y,X,TEMP1,N,MAXGRP,NMIN,TEMP2,NPERC,NTOTZZ,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IFLAG1=1
        IFLAG2=1
        CALL SUMGRP(Y,X,N,IDIST,IFLAG1,IFLAG2,
     1              TEMP1,TEMP2,TEMP3,MAXNXT,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        ICNT=0
        NTOTZZ=0
        DO1211I=1,N
          IF(Y(I).GT.0.0)THEN
            ICNT=ICNT+1
            Y(ICNT)=Y(I)
            X(ICNT)=X(I)
            NTOTZZ=NTOTZZ + INT(Y(I)+0.01)
          ENDIF
1211    CONTINUE
        N2=ICNT
      ENDIF
C
      F0=Y(1)/REAL(NTOTZZ)
      IINDX=MAXNXT/2
      IF(N2.LE.IINDX)THEN
        IWD=0
        DO2210I=1,N2
          TEMP3(I)=Y(I)
          TEMP3(IINDX+I)=X(I)
 2210   CONTINUE
        IK=N
      ELSE
        IWD=1
      ENDIF
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLBT')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1151)
 1151   FORMAT('AFTER COMPUTE SUMMARY STATISTICS--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1152)XMEAN,XVAR,XSD,XMIN,XMAX
 1152   FORMAT('XMEAN,XVAR,XSD,XMIN,XMAX = ',5G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1154)F0,N,N2,NTOTZZ,IK,IWD
 1154   FORMAT('F0,N,N2,NTOTZZ,IK,IWD = ',G15.7,4I8)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
C               ************************************************
C               **  STEP 21--                                 **
C               **  CARRY OUT CALCULATIONS                    **
C               **  FOR GENERALIZED LOST GAMES MLE ESTIMATION **
C               ************************************************
C
 2100 CONTINUE
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLGG')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      PMOM=0.5 + (XMEAN + SQRT(XMEAN*(XMEAN+8.0*XVAR)))/(8.0*XVAR)
      AMOM=XMEAN*(1.0/(1.0 - PMOM) - 2.0)
C
      IOPT=2
      TOL=1.0D-6
      NPAR=2
      NPRINT=-1
      INFO=0
      LWA=MAXNXT
      MAXRO2=MAXNXT
      XBAR=DBLE(XMEAN)
      S2=DBLE(XVAR)
      DF0=DBLE(F0)
C
      XPAR(1)=DBLE(PMOM)
      XPAR(2)=DBLE(AMOM)
      CALL DNSQE(GLGFUN,JAC,IOPT,NPAR,XPAR,FVEC,TOL,NPRINT,INFO,
     1             DTEMP1,LWA,TEMP3,IK)
C
      PML=REAL(XPAR(1))
      AML=REAL(XPAR(2))
CCCCC Q=1.0-PML
CCCCC TERM1=REAL(NTOT)*AML/(PML*PML)
CCCCC TERM2=REAL(NTOT)*DA*(1.0-2.0*PML*Q)/((PML-Q)*PMP*PML*Q)
CCCCC PVARML=TERM1 + TERM2
CCCCC COVML=-REAL(NTOT)/PML
CCCCC AVARML=0.0
C
CCCCC DSUM1=0.0D0
CCCCC DSUM2=0.0D0
CCCCC DO2300I=1,IK
CCCCC   DSUM2=0.0D0
CCCCC   DX=DBLE(TEMP3(IINDX+I))
CCCCC   IF(DX.LT.1.99D0)GOTO2300
CCCCC   AX=REAL(DX)
CCCCC   CALL GLGPDF(AX,PML,AMIN,AML,PX)
CCCCC   DFREQ=DBLE(PX)
CCCCC   IK2=INT(DX-1.0D0 + 0.5D0)
CCCCC   DO2400J=1,IK2
CCCCC     DX2=DBLE(TEMP3(IINDX+J))
CCCCC     DSUM2=DSUM2 + 1.0D0/(DA+DX+DBLE(J)**2)
C2400   CONTINUE
CCCCC   DSUM1=DSUM1 + (DFREQ/DN)*DSUM2
C2300 CONTINUE
C
CCCCC AX=0.0
CCCCC CALL GLGPDF(AX,PML,AMIN,AML,P0)
CCCCC AVARML=REAL(DN*DLOG(1.0D0-DBLE(P0))/AML**2 + DN*DSUM1)
C
C               *************************************************
C               **   STEP 42--                                 **
C               **   WRITE OUT EVERYTHING                      **
C               **   FOR GENERALIZED LOST GAMES MLE ESTIMATION **
C               *************************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLGG')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     PRINT SUMMARY STATISTICS TABLE
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Generalized Lost Games Parameter Estimation'
      NCTITL=43
      ITITLZ=' '
      NCTITZ=0
C
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(NTOTZZ)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Method of Moments:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of J:'
      NCTEXT(ICNT)=14
      AVALUE(ICNT)=AMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of P:'
      NCTEXT(ICNT)=14
      AVALUE(ICNT)=PMOM
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of A:'
      NCTEXT(ICNT)=14
      AVALUE(ICNT)=AMOM
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Method of Maximum Likelihood:'
      NCTEXT(ICNT)=29
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of J:'
      NCTEXT(ICNT)=14
      AVALUE(ICNT)=AMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of P:'
      NCTEXT(ICNT)=14
      AVALUE(ICNT)=PML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of A:'
      NCTEXT(ICNT)=14
      AVALUE(ICNT)=AML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      NUMROW=ICNT
      DO2310I=1,NUMROW
        NTOT(I)=15
 2310 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLGG')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLGG--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)PMOM,AMOM,PML,AML
 9012   FORMAT('PMOM,AMOM,PML,AML = ',4G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLGL(Y,N,
     1                  DTEMP1,XMOM,MAXNXT,
     1                  SHAPML,SCALML,ALOCML,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE L-MOMENT ESTIMATES
C              FOR THE GENERALIZED LOGISTIC DISTRIBUTION
C     EXAMPLE--GENERALIZED LOGISTIC MAXIMUM LIKELIHOOD Y
C     REFERENCE--FORTRAN CODE WRITTEN FOR INCLUSION IN IBM
C                RESEARCH REPORT RC20525, 'FORTRAN ROUTINES FOR
C                USE WITH THE METHOD OF L-MOMENTS, VERSION 3',
C                J. R. M. HOSKING, IBM RESEARCH DIVISION,
C                T. J. WATSON RESEARCH CENTER, YORKTOWN HEIGHTS
C                NEW YORK 10598, U.S.A., VERSION 3     AUGUST 1996
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2006/2
C     ORIGINAL VERSION--FEBRUARY  2006.
C     UPDATED         --JULY      2010. EXTRACT POINT ESTIMATES TO
C                                       PE3ML1
C     UPDATED         --JULY      2010. USE DPDTA1 TO PRINT OUTPUT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION QP(1)
      DOUBLE PRECISION DTEMP1(*)
      DOUBLE PRECISION XMOM(*)
C
CCCCC PARAMETER (NUMALP=6)
CCCCC DIMENSION ALPHA(NUMALP)
CCCCC DIMENSION ALOWSC(NUMALP)
CCCCC DIMENSION AUPPSC(NUMALP)
CCCCC DIMENSION ALOWGA(NUMALP)
CCCCC DIMENSION AUPPGA(NUMALP)
C
      PARAMETER (MAXROW=20)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(MAXROW)
      CHARACTER*4  VALIGN(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
CCCCC DATA ALPHA /0.50, 0.25, 0.10, 0.05, 0.01, 0.001/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='GL  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLGL')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLGL--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N
   52   FORMAT('IBUGA3,ISUBRO,N = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ***************************************************
C               **  STEP 21--                                    **
C               **  CARRY OUT CALCULATIONS                       **
C               **  FOR GENERALIZED LOGISTIC L-MOMENT ESTIMATION **
C               ***************************************************
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLGL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NPERC=0
      NMIN=4
      CALL CKDIST(Y,N,NMIN,QP,NPERC,ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IERROR='NO'
      IWRITE='OFF'
C
      CALL GL5ML1(Y,N,
     1            DTEMP1,XMOM,NMOM,
     1            XMEAN,XSD,XVAR,XMIN,XMAX,
     1            ALOCML,SCALML,SHAPML,
     1            ISUBRO,IBUGA3,IERROR)
C
C               ***********************************************
C               **   STEP 42--                               **
C               **   WRITE OUT EVERYTHING                    **
C               **   FOR GENERALIZED LOGISTIC MLE ESTIMATION **
C               ***********************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLGL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Three-Parameter Generalized Logistic Type 5'
      NCTITL=43
      ITITLZ='Parameter Estimation (Full Sample Case):'
      NCTITZ=40
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(N)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='First Sample L-Moment:'
      NCTEXT(ICNT)=22
      AVALUE(ICNT)=REAL(XMOM(1))
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Second Sample L-Moment:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(XMOM(2))
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Third Sample L-Moment:'
      NCTEXT(ICNT)=22
      AVALUE(ICNT)=REAL(XMOM(3))
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Method of L-Moments:'
      NCTEXT(ICNT)=20
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Location:'
      NCTEXT(ICNT)=22
      AVALUE(ICNT)=ALOCML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Scale:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=SCALML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Shape (Gamma):'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=SHAPML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='Log-likelihood:'
CCCCC NCTEXT(ICNT)=15
CCCCC AVALUE(ICNT)=ALIK
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=AIC
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AICc:'
CCCCC NCTEXT(ICNT)=5
CCCCC AVALUE(ICNT)=AICC
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='BIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=BIC
CCCCC IDIGIT(ICNT)=-7
C
      NUMROW=ICNT
      DO2320I=1,NUMROW
        NTOT(I)=15
 2320 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLGL')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLGL--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012   FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9015)N
 9015   FORMAT('N = ',I8)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLGP(Y,N,ICASPL,
     1                  TEMP1,TEMP2,TEMP3,TEMP4,TEMP5,YTEMP,
     1                  DTEMP1,XMOM,
     1                  MAXNXT,THRESH,MINMAX,
     1                  QP,XQPHAT,XQPLCL,XQPUCL,XQPSE,NPERC,
     1                  SHAPMO,SCALMO,ALOCMO,
     1                  SHAPLM,SCALLM,ALOCLM,
     1                  SHAPEP,SCALEP,ALOCEP,
     1                  SHAPML,SCALML,ALOCML,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  IOUNI1,IOUNI2,ISEED,ALPHAP,
     1                  GAMMSV,SCALSV,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE METHOD OF MOMENT AND
C              MAXIMUM LIKELIHOOD ESTIMATES FOR THE GENERALIZED PARETO
C              DISTRIBUTION
C     EXAMPLE--GENERALIZED PARETO MAXIMUM LIKELIHOOD Y
C     REFERENCE--JOHNSON, KOTZ, AND BALAKRISHNAN.  "CONTINUOUS
C                UNIVARIATE DISTRIBUTIONS, VOLUME I", SECOND
C                EDITION, WILEY, 1994, PP. 614-619.
C              --CASTILLO, HADI, BALAKRISHNAN, SARABIA, "EXTREME
C                VALUE AND RELATED MODELS WITH APPLICATIONS IN
C                ENGINEERING AND SCIENCE", WILEY, 2005.
C              --FORTRAN CODE WRITTEN FOR INCLUSION IN IBM
C                RESEARCH REPORT RC20525, 'FORTRAN ROUTINES FOR
C                USE WITH THE METHOD OF L-MOMENTS, VERSION 3',
C                J. R. M. HOSKING, IBM RESEARCH DIVISION,
C                T. J. WATSON RESEARCH CENTER, YORKTOWN HEIGHTS
C                NEW YORK 10598, U.S.A., VERSION 3     AUGUST 1996
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2003/11
C     ORIGINAL VERSION--NOVEMBER  2003.
C     UPDATED         --JUNE      2004. SUPPORT FOR IGEPDF (ALTERNATE
C                                       DEFINITION OF GENERALIZED
C                                       PARETO: SIGN IS REVERSED)
C     UPDATED         --JUNE      2004. PRINT VARIANCE-COVARIANCE
C                                       MATRIX
C     UPDATED         --JUNE      2005. SUPPORT FOR L-MOMENTS
C                                       ESTIMATES
C     UPDATED         --JUNE      2005. FOR MLE, MOMENTS, DEFINE
C                                       "THRESH" AS THE LOCATION
C                                       PARAMETER.
C     UPDATED         --OCTOBER   2005. ALLOW DIFFERENT CHOICES FOR
C                                       STARTING VALUES
C     UPDATED         --APRIL     2008. ADD MINMAX TO SUPPORT MINIMUM
C                                       CASE
C     UPDATED         --JULY      2010. EXTRACT POINT ESTIMATION TO
C                                       GEPML1
C     UPDATED         --JULY      2010. CALL GEPLI1 TO OBTAIN
C                                       LIKELIHOOD, AIC VALUES
C     UPDATED         --JULY      2010. USE DPDTA1, DPDTA7, DPDTA9
C                                       TO PRINT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ILIKFL
      CHARACTER*4 IDFTZZ
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*7 ICASE
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION YTEMP(*)
      DIMENSION TEMP1(*)
      DIMENSION TEMP2(*)
      DIMENSION TEMP3(*)
      DIMENSION TEMP4(*)
      DIMENSION TEMP5(*)
      DOUBLE PRECISION DTEMP1(*)
      DOUBLE PRECISION XMOM(*)
C
      PARAMETER (NUMALP=6)
      DIMENSION ALPHA(NUMALP)
      DIMENSION ALOWSC(NUMALP)
      DIMENSION AUPPSC(NUMALP)
      DIMENSION ALOWSH(NUMALP)
      DIMENSION AUPPSH(NUMALP)
C
      DIMENSION QP(*)
      DIMENSION XQPHAT(*)
      DIMENSION XQPSE(*)
      DIMENSION XQPLCL(*)
      DIMENSION XQPUCL(*)
C
      DOUBLE PRECISION G
      DOUBLE PRECISION T3
      DOUBLE PRECISION DT1
      DOUBLE PRECISION DT2
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DG
      DOUBLE PRECISION DS
      DOUBLE PRECISION DQP
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=60)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*60 ITEXT(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA ALPHA /0.50, 0.25, 0.10, 0.05, 0.01, 0.001/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='GP  '
C
      ICASE='MAXIMUM'
      IF(MINMAX.EQ.1)ICASE='MINIMUM'
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLGP')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLGP--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N
   52   FORMAT('IBUGA3,ISUBRO,N = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLGP')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C               ***************************************************
C               **  STEP 21--                                    **
C               **  CARRY OUT CALCULATIONS                       **
C               **  FOR GENERALIZED PARETO MOMENT/MLE ESTIMATION **
C               ***************************************************
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLGP')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NMIN=3
      CALL CKDIST(Y,N,NMIN,QP,NPERC,ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IDFTZZ='ALL'
      CALL GEPML1(Y,N,MAXNXT,MINMAX,ICASPL,IGEPDF,IGEPSV,IDFTTY,
     1            GAMMSV,SCALSV,ISEED,THRESH,
     1            TEMP1,TEMP2,TEMP3,TEMP4,TEMP5,YTEMP,
     1            DTEMP1,XMOM,NMOM,
     1            XMEAN,XSD,XVAR,XMIN,XMAX,
     1            ALOCMO,SCALMO,SHAPMO,
     1            ALOCLM,SCALLM,SHAPLM,
     1            ALOCEP,SCALEP,SHAPEP,
     1            ALOCML,SCALML,SHAPML,MLFLAG,
     1            NUSE,ZMEAN,ZVAR,ZSD,ALOC,
     1            VARMM1,VARMM2,COVMOM,
     1            VARML1,VARML2,COVML,
     1            ISUBRO,IBUGA3,IERROR)
C
      CALL GEPLI1(Y,N,MINMAX,IGEPDF,
     1            ALOCLM,SCALLM,SHAPLM,
     1            ALIKLM,AICLM,AICCLM,BICLM,
     1            ISUBRO,IBUGA3,IERROR)
C
      CALL GEPLI1(Y,N,MINMAX,IGEPDF,
     1            ALOCMO,SCALMO,SHAPMO,
     1            ALIKMO,AICMO,AICCMO,BICMO,
     1            ISUBRO,IBUGA3,IERROR)
C
      CALL GEPLI1(Y,N,MINMAX,IGEPDF,
     1            ALOCEP,SCALEP,SHAPEP,
     1            ALIKEP,AICEP,AICCEP,BICEP,
     1            ISUBRO,IBUGA3,IERROR)
C
      IF(MLFLAG.EQ.0 .AND. SHAPML.NE.CPUMIN)THEN
        CALL GEPLI1(Y,N,MINMAX,IGEPDF,
     1              ALOCML,SCALML,SHAPML,
     1              ALIKML,AICML,AICCML,BICML,
     1              ISUBRO,IBUGA3,IERROR)
      ELSE
        ALIKML=CPUMIN
        AICML=CPUMIN
        AICCML=CPUMIN
        BICML=CPUMIN
      ENDIF
C
      IF(MLFLAG.EQ.0)THEN
        AN=REAL(N)
        DO2310I=1,NUMALP
          ALP=ALPHA(I)
          P=1.0-(ALP/2.0)
          CALL NORPPF(P,PPF)
          ALOWSC(I)=SCALML - PPF*SQRT(VARML2)
          AUPPSC(I)=SCALML + PPF*SQRT(VARML2)
          IF(IGEPDF.EQ.'SIMI')THEN
            ALOWSH(I)=SHAPML - PPF*SQRT(VARML1)
            AUPPSH(I)=SHAPML + PPF*SQRT(VARML1)
          ELSE
            ALOWSH(I)=(-SHAPML) - PPF*SQRT(VARML1)
            AUPPSH(I)=(-SHAPML) + PPF*SQRT(VARML1)
          ENDIF
 2310   CONTINUE
C
        IF(NPERC.GE.1)THEN
C
          ALPHL=ALPHAP/2.0
          ALPHU=1.0 - ALPHAP/2.0
          CALL NORPPF(ALPHU,Z95)
C
C
CCCCC     WRITE(IOUNI1,2531)
CCCCC     WRITE(IOUNI1,2532)
          DO2429I=1,NPERC
            QPTEMP=QP(I)/100.0
            CALL GEPPPF(QPTEMP,SHAPML,MINMAX,IGEPDF,APPF)
            XQPHAT(I)=ALOCML + SCALML*APPF
C
            IF(SHAPML.EQ.0.0)THEN
              DT1=-DLOG(1.0D0 - DBLE(QPTEMP))
              DT2=0.0D0
            ELSE
              DG=DBLE(SHAPML)
              DS=DBLE(SCALML)
              DQP=DBLE(QPTEMP)
              DT1=(1.0D0/DG)*(1.0D0 - (1.0D0 - DQP)**DG)
              DT2=-(DS/(DG*DG))*(1.0D0 - (1.0D0 - DQP)**DG) -
     1            (DS/DG)*((1.0D0 - DQP)**DG)*DLOG(1.0D0 - DQP)
            ENDIF
C
            DTERM1=DT1**2*DBLE(VARML2) + DT1*DT2*DBLE(COVML) +
     1             DT2**2*DBLE(VARML1) + DT1*DT2*DBLE(COVML)
            SEXQP=REAL(DTERM1)
            IF(SEXQP.GE.0.0)THEN
              SEXQP=SQRT(SEXQP)
            ELSE
              SEXQP=0.0
            ENDIF
            XQPSE(I)=SEXQP
            XQPLCL(I)=XQPHAT(I) - Z95*SEXQP
            XQPUCL(I)=XQPHAT(I) + Z95*SEXQP
CCCCC       WRITE(IOUNI1,'(5E15.7)')
CCCCC1           QP(I),XQPHAT(I),XQPSE(I),XQPLCL(I),XQPUCL(I)
 2429     CONTINUE
C2531     FORMAT(15X,'       POINT     ','   STANDARD    ',
CCCCC1           '     LOWER     ',
CCCCC1           '     UPPER')
C2532     FORMAT('    PERCENTILE ','     ESTIMATE   ',
CCCCC1           '     ERROR     ',
CCCCC1           'CONFIDENCE LIMIT ','CONFIDENCE LIMIT')
        ENDIF
C
      ENDIF
C
C               ***********************************************
C               **   STEP 42--                               **
C               **   WRITE OUT EVERYTHING                    **
C               **   FOR GENERALIZED PARETO MLE ESTIMATION   **
C               ***********************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLGP')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Generalized Pareto Parameter Estimation'
      NCTITL=39
      IF(MINMAX.EQ.1)THEN
        ITITLZ='(Minimum Case)'
        NCTITZ=14
      ELSE
        ITITLZ='(Maximum Case)'
        NCTITZ=14
      ENDIF
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(N)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      IF(THRESH.NE.CPUMIN)THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='User-Specified Threshold:'
        NCTEXT(ICNT)=25
        AVALUE(ICNT)=THRESH
        IDIGIT(ICNT)=NUMDIG
      ENDIF
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Method of Moments:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      IF(IGEPDF.EQ.'SIMI')THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='(Valid if shape parameter < 1)'
        NCTEXT(ICNT)=30
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
      ELSE
        ICNT=ICNT+1
        ITEXT(ICNT)='(Valid if shape parameter > -1)'
        NCTEXT(ICNT)=31
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
      ENDIF
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean After Subtract Location:'
      NCTEXT(ICNT)=36
      AVALUE(ICNT)=ZMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample SD After Subtract Location:'
      NCTEXT(ICNT)=34
      AVALUE(ICNT)=ZSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Location:'
      NCTEXT(ICNT)=22
      AVALUE(ICNT)=ALOCMO
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Scale:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=SCALMO
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Shape (Gamma):'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=SHAPMO
      IDIGIT(ICNT)=NUMDIG
C
      IF(VARMM1.NE.CPUMIN)THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='Standard Error of Shape:'
        NCTEXT(ICNT)=24
        AVALUE(ICNT)=SQRT(VARMM1)
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Standard Error of Scale:'
        NCTEXT(ICNT)=24
        AVALUE(ICNT)=SQRT(VARMM2)
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Scale/Shape Covariance:'
        NCTEXT(ICNT)=23
        AVALUE(ICNT)=COVMOM
        IDIGIT(ICNT)=NUMDIG
      ENDIF
C
      IF(ALIKMO.NE.CPUMIN)THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='Log-likelihood:'
        NCTEXT(ICNT)=15
        AVALUE(ICNT)=ALIKMO
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='AIC:'
        NCTEXT(ICNT)=4
        AVALUE(ICNT)=AICMO
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='AICc:'
        NCTEXT(ICNT)=5
        AVALUE(ICNT)=AICCMO
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='BIC:'
        NCTEXT(ICNT)=4
        AVALUE(ICNT)=BICMO
        IDIGIT(ICNT)=-7
      ENDIF
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Method of L-Moments:'
      NCTEXT(ICNT)=20
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='(L-Moment Estimates Work Best for Values'
      NCTEXT(ICNT)=40
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='for Shape Parameter in (-0.5,0.5))'
      NCTEXT(ICNT)=34
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='First Sample L-Moment:'
      NCTEXT(ICNT)=22
      AVALUE(ICNT)=REAL(XMOM(1))
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Second Sample L-Moment:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(XMOM(2))
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Third Sample L-Moment:'
      NCTEXT(ICNT)=22
      AVALUE(ICNT)=REAL(XMOM(3))
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Location:'
      NCTEXT(ICNT)=22
      AVALUE(ICNT)=ALOCLM
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Scale:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=SCALLM
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Shape (Gamma):'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=SHAPLM
      IDIGIT(ICNT)=NUMDIG
C
      IF(ALIKLM.NE.CPUMIN)THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='Log-likelihood:'
        NCTEXT(ICNT)=15
        AVALUE(ICNT)=ALIKLM
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='AIC:'
        NCTEXT(ICNT)=4
        AVALUE(ICNT)=AICLM
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='AICc:'
        NCTEXT(ICNT)=5
        AVALUE(ICNT)=AICCLM
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='BIC:'
        NCTEXT(ICNT)=4
        AVALUE(ICNT)=BICLM
        IDIGIT(ICNT)=-7
      ENDIF
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Method of Elemental Percentiles:'
      NCTEXT(ICNT)=32
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Location:'
      NCTEXT(ICNT)=22
      AVALUE(ICNT)=ALOCEP
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Scale:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=SCALEP
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Shape (Gamma):'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=SHAPEP
      IDIGIT(ICNT)=NUMDIG
C
      IF(ALIKEP.NE.CPUMIN)THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='Log-likelihood:'
        NCTEXT(ICNT)=15
        AVALUE(ICNT)=ALIKEP
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='AIC:'
        NCTEXT(ICNT)=4
        AVALUE(ICNT)=AICEP
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='AICc:'
        NCTEXT(ICNT)=5
        AVALUE(ICNT)=AICCEP
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='BIC:'
        NCTEXT(ICNT)=4
        AVALUE(ICNT)=BICEP
        IDIGIT(ICNT)=-7
      ENDIF
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      IF(MLFLAG .EQ.0 .AND. SHAPML.NE.CPUMIN)THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='Maximum Likelihood:'
        NCTEXT(ICNT)=19
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of Location:'
        NCTEXT(ICNT)=22
        AVALUE(ICNT)=ALOCML
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of Scale:'
        NCTEXT(ICNT)=18
        AVALUE(ICNT)=SCALML
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of Shape (Gamma):'
        NCTEXT(ICNT)=26
        AVALUE(ICNT)=SHAPML
        IDIGIT(ICNT)=NUMDIG
C
        IF(VARML1.NE.CPUMIN)THEN
          ICNT=ICNT+1
          ITEXT(ICNT)='Standard Error of Shape:'
          NCTEXT(ICNT)=24
          AVALUE(ICNT)=SQRT(VARML1)
          IDIGIT(ICNT)=NUMDIG
          ICNT=ICNT+1
          ITEXT(ICNT)='Standard Error of Scale:'
          NCTEXT(ICNT)=24
          AVALUE(ICNT)=SQRT(VARML2)
          IDIGIT(ICNT)=NUMDIG
          ICNT=ICNT+1
          ITEXT(ICNT)='Scale/Shape Covariance:'
          NCTEXT(ICNT)=23
          AVALUE(ICNT)=COVML
          IDIGIT(ICNT)=NUMDIG
        ENDIF
C
        IF(ALIKML.NE.CPUMIN)THEN
          ICNT=ICNT+1
          ITEXT(ICNT)='Log-likelihood:'
          NCTEXT(ICNT)=15
          AVALUE(ICNT)=ALIKML
          IDIGIT(ICNT)=-7
          ICNT=ICNT+1
          ITEXT(ICNT)='AIC:'
          NCTEXT(ICNT)=4
          AVALUE(ICNT)=AICML
          IDIGIT(ICNT)=-7
          ICNT=ICNT+1
          ITEXT(ICNT)='AICc:'
          NCTEXT(ICNT)=5
          AVALUE(ICNT)=AICCML
          IDIGIT(ICNT)=-7
          ICNT=ICNT+1
          ITEXT(ICNT)='BIC:'
          NCTEXT(ICNT)=4
          AVALUE(ICNT)=BICML
          IDIGIT(ICNT)=-7
        ENDIF
      ELSE
        ICNT=ICNT+1
        ITEXT(ICNT)='Unable to Compute Maximum Likelihood Estimates'
        NCTEXT(ICNT)=46
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
      ENDIF
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      NUMROW=ICNT
      DO2320I=1,NUMROW
        NTOT(I)=15
 2320 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
      IF(MLFLAG .EQ.0 .AND. SHAPML.NE.CPUMIN)THEN
        ILIKFL='OFF'
        CALL DPDTA8(ALOWSC,AUPPSC,ALOWSC,AUPPSC,
     1              ALOWSH,AUPPSH,ALOWSH,AUPPSH,ALPHA,NUMALP,
     1              ICAPSW,ICAPTY,NUMDIG,ILIKFL,
     1              ISUBRO,IBUGA3,IERROR)
C
        ILIKFL='OFF'
        IF(NPERC.GT.1)THEN
          ILIKFL='OFF'
          CALL DPDTA9(QP,XQPHAT,XQPLCL,XQPUCL,XQPSE,NPERC,
     1                ICAPSW,ICAPTY,ILIKFL,NUMDIG,ALPHAP,
     1                ISUBRO,IBUGA3,IERROR)
        ENDIF
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'OFF'.AND.ISUBRO.NE.'MLGP')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPMLGP--')
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012 FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,9015)N
 9015 FORMAT('N = ',I8)
      CALL DPWRST('XXX','WRIT')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPMLGS(Y,X,N,NVAR,
     1                  TEMP1,TEMP2,TEMP3,DTEMP1,
     1                  THETMO,BETAMO,THETFR,BETAFR,THETML,BETAML,
     1                  ICAPSW,ICAPTY,IFORSW,MAXNXT,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR THE GENERALIZED LOGARITHMIC SERIES
C              DISTRIBUTION.
C
C              THE MOMENT ESTIMATE OF THETA IS THE SOLUTION
C              OF THE EQUATION:
C
C                 (1-THETA)*XBAR**3/ALPHA**2 -
C                 THETA**2*(s**2+XBAR**2) 0
C
C              WHERE ALPHA = 1/-LOG(1-THETA)
C
C                 BETA = (1/THETA) - ALPHA/XBAR
C
C              THE MEAN AND ONES FREQUENCY ESTIMATE OF THETA
C              IS THE SOLUTION OF THE EQUATION
C
C                 LOG(THETA) + ((1/THETA) -
C                 (1/XBAR)*(-1/LOG(1-THETA) - 1)*LOG(1-THETA) -
C                 LOG(-LOG(1-THETA)) - LOG(F1/N) = 0
C
C                 BETA = (1/THETA) - ALPHA/XBAR
C
C              THE MAXIMUM LIKELIHOOD ESTIMATES ARE THE SOLUTIONS
C              TO THE EQUATIONS:
C
C                 (N*XBAR/THETA) - (BETA-1)*N*XBAR/(1-THETA) +
C                 N/((1-THETA)*LOG(1-THETA)) = 0
C
C                 N*XBAR*LOG(1-THETA) +
C                 SUM[X=2 to K][SUM[i=1 to x-1][X*N(X)/(BETA*X-i)]]
C                 = 0
C
C              THERE ARE TWO CASES:
C
C              1) ONE VARIABLE CASE: Y IS RAW DATA
C              2) TWO VARIABLE CASE: Y IS FREQUENCY, X IS CLASS
C                 MID-POINT.
C
C     EXAMPLE--GENERALIZED LOGARITHMIC SERIES MAXIMUM LIKELIHOOD Y
C            --GENERALIZED LOGARITHMIC SERIES MAXIMUM LIKELIHOOD Y X
C     REFERENCES--CONSUL AND FAMOYE (2006), "LAGRANGIAN PROBABILITY
C                 DISTRIBUTIONS", BIRKHAUSER, CHAPTER 11.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2006/6
C     ORIGINAL VERSION--LAGRANGE  2006.
C     UPDATED         --APRIL     2011. USE DPDTA1 TO PRINT THE OUTPUT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-----------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*1 IBASLC
      CHARACTER*4 ISUBN0
      CHARACTER*4 IRELAT
      CHARACTER*4 IRHSTG
C
C-------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION TEMP1(*)
      DIMENSION TEMP2(*)
      DIMENSION TEMP3(*)
      DOUBLE PRECISION DTEMP1(*)
C
      DOUBLE PRECISION TOL
      DOUBLE PRECISION XPAR(2)
      DOUBLE PRECISION FVEC(2)
C
      DOUBLE PRECISION AE
      DOUBLE PRECISION RE
      DOUBLE PRECISION XLOW
      DOUBLE PRECISION XUP
      DOUBLE PRECISION XMID
      DOUBLE PRECISION DALPHA
C
      DOUBLE PRECISION GLSFUN
      DOUBLE PRECISION GLSFU3
      EXTERNAL GLSFUN
      EXTERNAL GLSFU2
      EXTERNAL GLSFU3
      DOUBLE PRECISION XBAR
      DOUBLE PRECISION S2
      DOUBLE PRECISION F1FREQ
      COMMON/GLSCOM/XBAR,S2,F1FREQ,MAXRO2,NTOT2
C
      PARAMETER (MAXROW=30)
      CHARACTER*60 ITITLE
      CHARACTER*1  ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 IDIST
      CHARACTER*40 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(MAXROW)
      CHARACTER*4  VALIGN(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL      IFRST
      LOGICAL      ILAST
C
CCCCC PARAMETER(NUMCLI=3)
CCCCC PARAMETER(MAXLIN=2)
CCCCC CHARACTER*60 ITITL2(MAXLIN,NUMCLI)
CCCCC INTEGER      NCTIT2(MAXLIN,NUMCLI)
CCCCC INTEGER      IWHTML(NUMALP)
CCCCC INTEGER      IWRTF(NUMALP)
CCCCC REAL         AMAT(MAXROW,NUMCLI)
C
C-------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT---------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='GS  '
C
      IERROR='NO'
      IWRITE='OFF'
C
      THETMO=CPUMIN
      BETAMO=CPUMIN
      THETFR=CPUMIN
      BETAFR=CPUMIN
      THETML=CPUMIN
      BETAML=CPUMIN
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLGS')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLGS--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N,NVAR
   52   FORMAT('IBUGA3,ISUBRO,N,NVAR = ',2(A4,2X),2I8)
        CALL DPWRST('XXX','WRIT')
        IF(NVAR.EQ.1)THEN
          DO56I=1,MIN(N,100)
            WRITE(ICOUT,57)I,Y(I)
   57       FORMAT('I,Y(I) = ',I8,G15.7)
            CALL DPWRST('XXX','WRIT')
   56     CONTINUE
        ELSE
          DO61I=1,N
            WRITE(ICOUT,62)I,X(I),Y(I)
   62       FORMAT('I,X(I),Y(I) = ',I8,2G15.7)
            CALL DPWRST('XXX','WRIT')
   61     CONTINUE
        ENDIF
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  1) ROUND DATA TO INTEGER VALUES       **
C               **  2) COMPUTE SUMMARY STATISTICS         **
C               **  3) CHECK INPUT FOR NEGATIVE VALUES,   **
C               **     INSUFFICIENT SAMPLE SIZE           **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLYU')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IDIST='GENERALIZED LOST GAMES'
C
      NPERC=0
      MAXGRP=MAXNXT/2
      NMIN=2
      IF(NVAR.EQ.1)THEN
        DO1105I=1,N
          ITEMP=INT(Y(I)+0.5)
          Y(I)=REAL(ITEMP)
 1105   CONTINUE
        CALL CKDIST(Y,N,NMIN,TEMP1,NPERC,ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
        IFLAG=1
        CALL SUMRAW(Y,N,IDIST,IFLAG,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        NTOTZZ=N
C
C       NOW BIN THE DATA FOR USE BY THE ESTIMATION METHOD BELOW
C
        IRELAT='OFF'
        IRHSTG='OFF'
        XSTART=XMIN-0.5
        XSTOP=XMAX+0.5
        CLWID=1.0
        CALL DPBINI(Y,N,IRELAT,CLWID,XSTART,XSTOP,IRHSTG,
     1              TEMP1,X,N2,IBUGA3,IERROR)
        ICNT=0
        DO1121I=1,N2
          Y(I)=TEMP1(I)
          ICNT=ICNT+1
          Y(ICNT)=Y(I)
          X(ICNT)=X(I)
1121    CONTINUE
        N2=ICNT
      ELSE
        CALL CKDIS2(Y,X,TEMP1,N,MAXGRP,NMIN,TEMP2,NPERC,NTOTZZ,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IFLAG1=1
        IFLAG2=1
        CALL SUMGRP(Y,X,N,IDIST,IFLAG1,IFLAG2,
     1              TEMP1,TEMP2,TEMP3,MAXNXT,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ,
     1              ISUBRO,IBUGA3,IERROR)
        N2=N
      ENDIF
      IF(IERROR.EQ.'YES')GOTO9000
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLGS')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1311)
 1311   FORMAT('AFTER COMPUTE SUMMARY STATISTICS--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1312)XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ
 1312   FORMAT('XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ = ',5G15.7,I10)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
C               *********************************************
C               **  STEP 21--                              **
C               **  CARRY OUT CALCULATIONS                 **
C               **  FOR GENERALIZED LOGARITHMIC SERIES MLE **
C               **  ESTIMATION                             **
C               *********************************************
C
 2100 CONTINUE
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLGS')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      F1=Y(1)/REAL(NTOTZZ)
      IINDX=MAXNXT/2
      IF(N2.LE.IINDX)THEN
        IML=0
        DO2210I=1,N2
          TEMP3(I)=Y(I)
          TEMP3(IINDX+I)=X(I)
 2210   CONTINUE
        IK=N2
      ELSE
        IML=1
      ENDIF
C
      AE=1.D-7
      RE=1.D-7
      XBAR=DBLE(XMEAN)
      S2=DBLE(XSD)**2
      XLOW=0.000001D0
      XUP=0.999999D0
      XMID=0.5D0
      CALL DFZERO(GLSFUN,XLOW,XUP,XMID,RE,AE,IFLAG)
      THETMO=REAL(XLOW)
      DALPHA=-1.0D0/DLOG(1.0D0 - THETMO)
      BETAMO=(1.0D0/THETMO) - DALPHA/XBAR
      IF(BETAMO.LE.1.0)BETAMO=1.0
C
      F1FREQ=DBLE(F1)
      NTOT2=NTOTZZ
      XLOW=0.000001D0
      XUP=0.999999D0
      XMID=DBLE(THETMO)
      CALL DFZERO(GLSFU3,XLOW,XUP,XMID,RE,AE,IFLAG)
      THETFR=REAL(XLOW)
      DALPHA=-1.0D0/DLOG(1.0D0 - THETFR)
      BETAFR=(1.0D0/THETFR) - DALPHA/XBAR
      IF(BETAFR.LE.1.0)BETAFR=1.0
C
      IF(IML.EQ.0)THEN
        IOPT=2
        TOL=1.0D-5
        NPAR=2
        NPRINT=-1
        INFO=0
        LWA=MAXNXT
        MAXRO2=MAXNXT
C
        XPAR(1)=DBLE(THETMO)
        XPAR(2)=DBLE(BETAMO)
        CALL DNSQE(GLSFU2,JAC,IOPT,NPAR,XPAR,FVEC,TOL,NPRINT,INFO,
     1             DTEMP1,LWA,TEMP3,IK)
C
        THETML=REAL(XPAR(1))
        BETAML=REAL(XPAR(2))
        IF(BETAML.LE.1.0)BETAML=1.0
      ENDIF
C
C               ***********************************************
C               **   STEP 42--                               **
C               **   WRITE OUT EVERYTHING                    **
C               **   FOR GENERALIZED LOGARITHMIC SERIES MLE  **
C               **   ESTIMATION                              **
C               ***********************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLNM')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     PRINT SUMMARY STATISTICS TABLE
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Generalized Logarithmic Series Parameter Estimation'
      NCTITL=51
      ITITLZ=' '
      NCTITZ=0
C
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(NTOTZZ)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample First Frequency:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=F1
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Method of Moments:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Theta:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=THETMO
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Beta:'
      NCTEXT(ICNT)=17
      AVALUE(ICNT)=BETAMO
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Method of First Frequency:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Theta:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=THETFR
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Beta:'
      NCTEXT(ICNT)=17
      AVALUE(ICNT)=BETAFR
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Method of Maximum Likelihood:'
      NCTEXT(ICNT)=29
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Theta:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=THETML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Beta:'
      NCTEXT(ICNT)=17
      AVALUE(ICNT)=BETAML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      NUMROW=ICNT
      DO2310I=1,NUMROW
        NTOT(I)=15
 2310 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLGS')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLGS--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9015)THETMO,BETAMO,THETFR,BETAFR,THETML,BETAML
 9015   FORMAT('THETMO,BETAMO,THETFR,BETAFR,THETML,BETAML = ',6G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLGV(Y,N,ICASPL,MAXNXT,MINMAX,
     1                  TEMP1,TEMP2,TEMP3,TEMP4,TEMP5,
     1                  DTEMP1,XMOM,
     1                  QP,XQPHAT,XQPLCL,XQPUCL,XQPSE,NPERC,
     1                  ALOCLM,SCALLM,SHAPLM,
     1                  ALOCEP,SCALEP,SHAPEP,
     1                  ALOCML,SCALML,SHAPML,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  IOUNI1,IOUNI2,ISEED,ALPHA,
     1                  MLFLAG,ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES PARAMETER ESTIMATES FOR THE
C              GENERALIZED EXTREME VALUE DISTRIBUTION USING THE
C              FOLLOWING METHODS:
C
C              1) L-MOMENTS
C              2) ELEMENTAL PERCENTILES
C              3) MAXIMUM LIKELIHOOD
C
C                 NOTE: I AM HAVING PROBLEMS WITH HOSKINGS MAXIMUM
C                 LIKELIHOOD ROUTINE.  FOR NOW, BYPASS ML ESTIMATION.
C                 IF I GET THIS WORKING BETTER, THEN I WILL
C                 RE-ACTIVATE IT.
C
C     EXAMPLE--GENERALIZED EXTREME VALUE MAXIMUM LIKELIHOOD Y
C     REFERENCE--JOHNSON, KOTZ, AND BALAKRISHNAN.  "CONTINUOUS
C                UNIVARIATE DISTRIBUTIONS, VOLUME I", SECOND
C                EDITION, WILEY, 1994, PP. 614-619.
C              --HOSKING, ALGORITHM AS215   APPL. STATIST. (1985)
C                VOL. 34, NO. 3, Modifications in AS R76 (1989)
C                have been incorporated.
C              --CASTILLO, HADI, BALAKRISHNAN, SARABIA, "EXTREME
C                VALUE AND RELATED MODELS WITH APPLICATIONS IN
C                ENGINEERING AND SCIENCE", WILEY, 2005.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2855
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2005/7
C     ORIGINAL VERSION--JULY      2005.
C     UPDATED         --JULY      2010. EXTRACT POINT ESTIMATES TO
C                                       GEVML1
C     UPDATED         --JULY      2010. USE DPDTA1 TO PRINT OUTPUT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ICASPL
      CHARACTER*4 IDFTZZ
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      LOGICAL MLFLAG
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION TEMP1(*)
      DIMENSION TEMP2(*)
      DIMENSION TEMP3(*)
      DIMENSION TEMP4(*)
      DIMENSION TEMP5(*)
      DOUBLE PRECISION DTEMP1(*)
      DOUBLE PRECISION XMOM(*)
C
      DIMENSION QP(*)
      DIMENSION XQPHAT(*)
      DIMENSION XQPSE(*)
      DIMENSION XQPLCL(*)
      DIMENSION XQPUCL(*)
C
      DOUBLE PRECISION VARCOV(6)
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=40)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*40 ITEXT(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='GV  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLGV')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLGV--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3
   52   FORMAT('IBUGA3 = ',A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)N
   55   FORMAT('N = ',I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,E15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ***************************************************
C               **  STEP 21--                                    **
C               **  CARRY OUT CALCULATIONS                       **
C               **  FOR GENERALIZED EXTREME VALUE MOMENT/MLE     **
C               **  ESTIMATION                                   **
C               ***************************************************
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLGV')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NMIN=3
      CALL CKDIST(Y,N,NMIN,QP,NPERC,ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IERROR='NO'
      IWRITE='OFF'
      IDFTZZ='ALL'
C
      MLFLAG=.TRUE.
      CALL GEVML1(Y,N,MAXNXT,MINMAX,ICASPL,MLFLAG,IGEPDF,ISEED,IDFTTY,
     1            TEMP1,TEMP2,TEMP3,TEMP4,TEMP5,
     1            DTEMP1,XMOM,NMOM,VARCOV,
     1            XMEAN,XSD,XVAR,XMIN,XMAX,
     1            ALOCLM,SCALLM,SHAPLM,
     1            ALOCEP,SCALEP,SHAPEP,
     1            ALOCML,SCALML,SHAPML,
     1            ISUBRO,IBUGA3,IERROR)
C
      CALL GEVLI1(Y,N,MINMAX,
     1            ALOCLM,SCALLM,SHAPLM,
     1            ALIKLM,AICLM,AICCLM,BICLM,
     1            ISUBRO,IBUGA3,IERROR)
C
      CALL GEVLI1(Y,N,MINMAX,
     1            ALOCEP,SCALEP,SHAPEP,
     1            ALIKEP,AICEP,AICCEP,BICEP,
     1            ISUBRO,IBUGA3,IERROR)
C
      IF(MLFLAG .AND. SHAPML.NE.CPUMIN)THEN
        CALL GEVLI1(Y,N,MINMAX,
     1              ALOCML,SCALML,SHAPML,
     1              ALIKML,AICML,AICCML,BICML,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
C
C               ***********************************************
C               **   STEP 42--                               **
C               **   WRITE OUT EVERYTHING                    **
C               **   FOR GENERALIZED EXTREME VALUE           **
C               **   MLE ESTIMATION                          **
C               ***********************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLGV')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Generalized Extreme Value Parameter Estimation'
      NCTITL=46
      IF(MINMAX.EQ.1)THEN
        ITITLZ='(Minimum Case)'
        NCTITZ=14
      ELSE
        ITITLZ='(Maximum Case)'
        NCTITZ=14
      ENDIF
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(N)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='First Sample L-Moment:'
      NCTEXT(ICNT)=22
      AVALUE(ICNT)=REAL(XMOM(1))
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Second Sample L-Moment:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(XMOM(2))
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Third Sample L-Moment:'
      NCTEXT(ICNT)=22
      AVALUE(ICNT)=REAL(XMOM(3))
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Method of L-Moments:'
      NCTEXT(ICNT)=20
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Location:'
      NCTEXT(ICNT)=22
      AVALUE(ICNT)=ALOCLM
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Scale:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=SCALLM
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Shape (Gamma):'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=SHAPLM
      IDIGIT(ICNT)=NUMDIG
C
      IF(ALIKLM.NE.CPUMIN)THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='Log-likelihood:'
        NCTEXT(ICNT)=15
        AVALUE(ICNT)=ALIKLM
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='AIC:'
        NCTEXT(ICNT)=4
        AVALUE(ICNT)=AICLM
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='AICc:'
        NCTEXT(ICNT)=5
        AVALUE(ICNT)=AICCLM
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='BIC:'
        NCTEXT(ICNT)=4
        AVALUE(ICNT)=BICLM
        IDIGIT(ICNT)=-7
      ENDIF
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Method of Elemental Percentiles:'
      NCTEXT(ICNT)=32
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Location:'
      NCTEXT(ICNT)=22
      AVALUE(ICNT)=ALOCEP
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Scale:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=SCALEP
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Shape (Gamma):'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=SHAPEP
      IDIGIT(ICNT)=NUMDIG
C
      IF(ALIKEP.NE.CPUMIN)THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='Log-likelihood:'
        NCTEXT(ICNT)=15
        AVALUE(ICNT)=ALIKEP
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='AIC:'
        NCTEXT(ICNT)=4
        AVALUE(ICNT)=AICEP
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='AICc:'
        NCTEXT(ICNT)=5
        AVALUE(ICNT)=AICCEP
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='BIC:'
        NCTEXT(ICNT)=4
        AVALUE(ICNT)=BICEP
        IDIGIT(ICNT)=-7
      ENDIF
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      IF(MLFLAG .AND. SHAPML.NE.CPUMIN)THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='Maximum Likelihood:'
        NCTEXT(ICNT)=19
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of Location:'
        NCTEXT(ICNT)=22
        AVALUE(ICNT)=ALOCML
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of Scale:'
        NCTEXT(ICNT)=18
        AVALUE(ICNT)=SCALML
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of Shape (Gamma):'
        NCTEXT(ICNT)=26
        AVALUE(ICNT)=SHAPML
        IDIGIT(ICNT)=NUMDIG
C
        IF(ALIKML.NE.CPUMIN)THEN
          ICNT=ICNT+1
          ITEXT(ICNT)='Log-likelihood:'
          NCTEXT(ICNT)=15
          AVALUE(ICNT)=ALIKML
          IDIGIT(ICNT)=-7
          ICNT=ICNT+1
          ITEXT(ICNT)='AIC:'
          NCTEXT(ICNT)=4
          AVALUE(ICNT)=AICML
          IDIGIT(ICNT)=-7
          ICNT=ICNT+1
          ITEXT(ICNT)='AICc:'
          NCTEXT(ICNT)=5
          AVALUE(ICNT)=AICCML
          IDIGIT(ICNT)=-7
        ENDIF
        ICNT=ICNT+1
        ITEXT(ICNT)='BIC:'
        NCTEXT(ICNT)=4
        AVALUE(ICNT)=BICML
        IDIGIT(ICNT)=-7
      ENDIF
C
      NUMROW=ICNT
      DO2320I=1,NUMROW
        NTOT(I)=15
 2320 CONTINUE
C
      IFRST=.FALSE.
      ILAST=.FALSE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'OFF'.AND.ISUBRO.NE.'MLGV')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPMLGV--')
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012 FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,9015)N
 9015 FORMAT('N = ',I8)
      CALL DPWRST('XXX','WRIT')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPMLGX(Y,N,
     1XTEMP,XTEMP2,XTEMP3,DTEMP1,MAXNXT,
     1SHAPSV,SCALSV,SHAPML,SCALML,
     1ICAPSW,ICAPTY,IFORSW,
     1ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD ESTIMATES
C              FOR THE GEOMETRIC EXTREME EXPONENTIAL DISTRIBUTION.
C              THE MAXIMUM LIKELIHOOD ESTIMATES ARE THE SOLUTION TO
C              THE FOLLOWING SIMULTANEOUS NONLINEAR EQUATIONS:
C              EQUATIONS.
C
C              N/G - 2*SUM[i=1 to N][EXP(-L*X(i)/(1-(1-G)*EXP(-L*X(i)))]
C
C              N/L - SUM[i=1 to n][X(i)] -
C                    2*SUM[i=1 to N][(1-G)*X(i)*EXP(-L*X(i))/
C                    (1 - (1-G)*EXP(-L*X(i)))]
C
C              WITH G AND L DENOTING THE SHAPE PARAMETER GAMMA AND
C              SCALE PARAMETER LAMBDA RESPECTIVELY.  NOTE THAT L
C              IS ACTUALLY (1/SCALE).
C
C     EXAMPLE--GEOMETRIC EXTREME EXPONENTIAL MAXIMUM LIKELIHOOD Y
C     REFERENCE--"CAN DATA RECOGNIZE ITS PARENT DISTRIBUTION?",
C                MARSHALL, MEZA, AND OLKIN, JOURNAL OF COMPUTATIONAL
C                AND GRAPHICAL STATISTICS, SEPTEMBER, 2001,
C                PP. 555-580.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004/3
C     ORIGINAL VERSION--MARCH     2004.
C     UPDATED         --AUGUST    2005. MODIFY OUTPUT OF FORMAT TO MAKE IT
C                                       MORE CONSISTENT WITH OTHER ML
C                                       ROUTINES
C     UPDATED         --FEBRUARY  2010. EXTRACT POINT ESTIMATES TO
C                                       GEEML1 TO MAKE IT CALLABLE
C                                       FROM MULTIPLE ROUTINES
C     UPDATED         --FEBRUARY  2010. PRINT TABLES WITH DPDTA1
C     UPDATED         --FEBRUARY  2010. CORRECT: LAMBDA ACTUALLY
C                                       (1/SCALE)
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION XTEMP(*)
      DIMENSION XTEMP2(*)
      DIMENSION XTEMP3(*)
      DOUBLE PRECISION DTEMP1(*)
      DIMENSION QP(1)
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=10)
      PARAMETER(NUMCLI=3)
      PARAMETER(MAXLIN=2)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 ITEXT(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(NUMCLI)
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='GX  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLGX')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLGX--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N
   52   FORMAT('IBUGA3,ISUBRO,N = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************************
C               **  STEP 21--                                         **
C               **  CARRY OUT CALCULATIONS                            **
C               **  FOR GEOMETRIC EXTREME EXPONENTIAL MLE ESTIMATION  **
C               ********************************************************
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLGX')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NPERC=0
      NMIN=3
      CALL CKDIST(Y,N,NMIN,QP,NPERC,ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      CALL GEEML1(Y,N,MAXNXT,
     1            XTEMP,XTEMP2,XTEMP3,DTEMP1,
     1            XMEAN,XSD,XVAR,XMIN,XMAX,
     1            SCALSV,SHAPSV,SCALML,SHAPML,
     1            ISUBRO,IBUGA3,IERROR)
C
C               ***********************************************
C               **   STEP 42--                               **
C               **   WRITE OUT EVERYTHING                    **
C               **   FOR GEOMETRIC   EXTREME EXPONENTIAL MLE **
C               **   ESTIMATION                              **
C               ***********************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLGX')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     PRINT SUMMARY STATISTICS TABLE
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Two-Parameter Geometric Extreme Exponential'
      NCTITL=43
      ITITLZ='Parameter Estimation: Full Sample Case'
      NCTITZ=38
      ITEXT(1)='Summary Statistics:'
      NCTEXT(1)=19
      AVALUE(1)=0.0
      IDIGIT(1)=0
      ITEXT(2)='Number of Observations:'
      NCTEXT(2)=23
      AVALUE(2)=REAL(N)
      IDIGIT(2)=0
      ITEXT(3)='Sample Mean:'
      NCTEXT(3)=12
      AVALUE(3)=XMEAN
      IDIGIT(3)=NUMDIG
      ITEXT(4)='Sample Standard Deviation:'
      NCTEXT(4)=26
      AVALUE(4)=XSD
      IDIGIT(4)=NUMDIG
      ITEXT(5)='Sample Minimum:'
      NCTEXT(5)=15
      AVALUE(5)=XMIN
      IDIGIT(5)=NUMDIG
      ITEXT(6)='Sample Maximum:'
      NCTEXT(6)=15
      AVALUE(6)=XMAX
      IDIGIT(6)=NUMDIG
      NUMROW=6
      DO2310I=1,NUMROW
        NTOT(I)=15
 2310 CONTINUE
      NTOT(2)=8
C
      IFRST=.TRUE.
      ILAST=.FALSE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,
     1            NCTEXT,AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
      IFRST=.FALSE.
      ITITLE=' '
      NCTITL=0
C
      ITEXT(1)='Maximum Likelihood:'
      NCTEXT(1)=19
      AVALUE(1)=0.0
      IDIGIT(1)=-1
      ITEXT(2)='Estimate of Shape (Gamma):'
      NCTEXT(2)=26
      AVALUE(2)=SHAPML
      IDIGIT(2)=NUMDIG
      ITEXT(3)='Estimate of Scale:'
      NCTEXT(3)=18
      AVALUE(3)=SCALML
      IDIGIT(3)=NUMDIG
C
      ICNT=3
C
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='Log-likelihood:'
CCCCC NCTEXT(ICNT)=15
CCCCC AVALUE(ICNT)=ALIK
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=AIC
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AICc:'
CCCCC NCTEXT(ICNT)=5
CCCCC AVALUE(ICNT)=AICC
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='BIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=BIC
CCCCC IDIGIT(ICNT)=-7
C
      NUMROW=ICNT
      DO2320I=1,NUMROW
        NTOT(I)=15
 2320 CONTINUE
C
      IFRST=.FALSE.
      ILAST=.FALSE.
      ITITLZ=' '
      NCTITZ=0
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLGX')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLGX--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012   FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9015)N
 9015   FORMAT('N = ',I8)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLGZ(Y,TAG,XLOW,XHIGH,N,NVAR,
     1                  Y2,X2,X3,N2,
     1                  TEMP1,TEMP2,TEMP3,DTEMP1,ITEMP9,MAXNXT,
     1                  CLLIMI,CLWIDT,
     1                  IHSTCW,MAXOBV,
     1                  IGOMDF,ICFLAG,ALPHAT,AK,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR THE GOMPERTZ DISTRIBUTION.
C              IT USES THE ALGORITHM GIVEN IN THE GARG
C              ARTICLE.  THIS ALGORITHM IS GIVEN FOR GROUPED
C              DATA THAT MAY CONTAIN CENSORED DATA.  THE
C              ALGORITHM DOES NOT REQUIRE EQUAL SIZE BINS.
C              IF THE USER SPECIFIES UNBINNED DATA, THEN
C              BIN THE DATA FIRST.
C
C              THE MAXIMUM LIKELIHOOD ESTIMATES ARE:
C
C                  KHAT = D*ALPHAHAT/Q(ALPHAHAT)
C
C              WHERE ALPHAHAT IS THE SOLUTION OF THE EQUATION
C
C                  T + (D/ALPHA) - D*Q'(ALPHA)/Q(ALPHA) = 0
C
C                  N    = THE TOTAL NUMBER OF OBSERVATIONS
C                  d(i) = NUMBER OF FAILURE TIMES IN THE
C                         I-TH INTERVAL
C                  s(i) = NUMBER OF CENSORING TIMES IN I-TH
C                         INTERVAL
C                  t(i) = UPPER END POINT OF I-TH INTERVAL
C                 
C                  T    = SUM[i=1 to p][d(i)*tau(i)]
C                  D    = SUM[i=1 to p][d(i)]
C                  Q(ALPHA)  = SUM[i=1 to p]
C                              [s(i)*(EXP(ALPHA*t(i)) - 1) +
C                              d(i)*(EXP(ALPHA*t(i)) - 1)]
C
C     EXAMPLE--GOMPERTZ MLE Y
C            --GOMPERTZ MLE Y X
C            --GOMPERTZ MLE Y XLOW XHIGH
C            --GOMPERTZ CENSORED MLE Y CENS
C            --GOMPERTZ CENSORED MLE Y CENS X
C            --GOMPERTZ CENSORED MLE Y CENS XLOW XHIGH
C     REFERENCE--GARG, RAO, AND REDMOND (1970), "MAXIMUM LIKELIHOOD
C                ESTIMATION OF THE PARAMETERS OF THE GOMPERTZ
C                SURVIVAL FUNCTION", APPLIED STATISTICS,
C                PP. 152-159.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2007/1
C     ORIGINAL VERSION--JANUARY   2007.
C     UPDATED         --APRIL     2011. USE DPDTA1 TO PRINT OUTPUT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-----------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 IGOMDF
      CHARACTER*4 ICFLAG
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 IHSTCW
      CHARACTER*4 IHSTO2
      CHARACTER*4 IRELAT
      CHARACTER*4 IRHSTG
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*4 IOP
C
      CHARACTER*40 IDIST
      PARAMETER (MAXROW=25)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 ITEXT(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C
C-------------------------------------------------------------------
C
      PARAMETER (KMAX=20)
      PARAMETER (MMAX=200)
C
      DIMENSION Y(*)
      DIMENSION TAG(*)
      DIMENSION XLOW(*)
      DIMENSION XHIGH(*)
      DIMENSION Y2(*)
      DIMENSION X2(*)
      DIMENSION X3(*)
      DIMENSION TEMP1(*)
      DIMENSION TEMP2(*)
      DIMENSION TEMP3(*)
      DIMENSION CLLIMI(*)
      DIMENSION CLWIDT(*)
C
      INTEGER ITEMP9(*)
      DOUBLE PRECISION DTEMP1(*)
C
      REAL TOL
C
      PARAMETER (NUMALP=6)
      DIMENSION ALPHA(NUMALP)
      DIMENSION ALOWSC(NUMALP)
      DIMENSION AUPPSC(NUMALP)
      DIMENSION ALOWGA(NUMALP)
      DIMENSION AUPPGA(NUMALP)
      DIMENSION ALOWS2(NUMALP)
      DIMENSION AUPPS2(NUMALP)
      DIMENSION ALOWG2(NUMALP)
      DIMENSION AUPPG2(NUMALP)
C
      DIMENSION FISH(2,2)
      DIMENSION COV(2,2)
C
      DOUBLE PRECISION GOMFUN
      EXTERNAL GOMFUN
      INTEGER NTOTZZ,NCLASS 
      DOUBLE PRECISION D
      DOUBLE PRECISION T
      DOUBLE PRECISION DQ
      DOUBLE PRECISION DQP
      DOUBLE PRECISION DQPP
      COMMON/GOMCOM/D,T,DQ,DQP,DQPP,NTOTZZ,NCLASS
C
      DOUBLE PRECISION DN
      DOUBLE PRECISION DAE
      DOUBLE PRECISION DRE
      DOUBLE PRECISION DG
      DOUBLE PRECISION DS
      DOUBLE PRECISION DT1
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DSUM2
      DOUBLE PRECISION DXSTRT
      DOUBLE PRECISION DXLOW
      DOUBLE PRECISION DXUP
      DOUBLE PRECISION XLOWSV
      DOUBLE PRECISION XUPSV
C
C-------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA ALPHA /0.50, 0.25, 0.10, 0.05, 0.01, 0.001/
C
C-----START POINT---------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='GZ  '
C
      IWRITE='OFF'
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLGZ')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLGZ--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)N,NVAR,ICFLAG,IBUGA3,ISUBRO
   55   FORMAT('N,NVAR,ICFLAG,IBUGA3,ISUBRO = ',2I8,2X,2(A4,2X),A4)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,N
          WRITE(ICOUT,57)I,Y(I),TAG(I),XLOW(I),XHIGH(I)
   57     FORMAT('I,Y(I),TAG(I),XLOW(I),XHIGH(I) = ',I8,4G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLGZ')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     NOTE: THERE ARE 6 POSSIBLE CASES.
C
C            I. NO CENSORING
C               1. UNBINNED DATA
C               2. GROUPED DATA, BIN MID-POINTS PROVIDED
C               3. GROUPED DATA, BIN LOWER/UPPER LIMITS
C                  PROVIDED (I.E., UNEQUAL SIZE BINS)
C           II. CENSORING
C               1. UNBINNED DATA
C               2. GROUPED DATA, BIN MID-POINTS PROVIDED
C               3. GROUPED DATA, BIN LOWER/UPPER LIMITS
C                  PROVIDED (I.E., UNEQUAL SIZE BINS)
C
      NPERC=0
      MAXGRP=MAXNXT/2
      NMIN=3
C
      IF(ICFLAG.EQ.'OFF')THEN
        IF(NVAR.EQ.1)THEN
          CALL CKDIST(Y,N,NMIN,TEMP1,NPERC,ISUBRO,IBUGA3,IERROR)
          IF(IERROR.EQ.'YES')GOTO9000
          IFLAG=1
          CALL SUMRAW(Y,N,IDIST,IFLAG,
     1                XMEAN,XVAR,XSD,XMIN,XMAX,
     1                ISUBRO,IBUGA3,IERROR)
          NTOTZZ=N
          IF(IERROR.EQ.'YES')GOTO9000
          IRELAT='OFF'
          IRHSTG='PERC'
          CLWID=CLWIDT(1)
          IHSTO2='ON'
          CALL DPBIN(Y,N,IRELAT,CLWID,CLLIMI(1),CLLIMI(2),IRHSTG,
     1               TEMP1,MAXOBV,IHSTCW,IHSTO2,
     1               Y2,X2,N2,IBUGA3,IERROR)
C
        ELSEIF(NVAR.EQ.2)THEN
          CALL CKDIS2(Y,XLOW,TEMP1,N,MAXGRP,NMIN,TEMP2,NPERC,NTOT2,
     1                ISUBRO,IBUGA3,IERROR)
          IF(IERROR.EQ.'YES')GOTO9000
          IFLAG1=1
          IFLAG2=1
          CALL SUMGRP(Y,XLOW,N,IDIST,IFLAG1,IFLAG2,
     1                TEMP1,TEMP2,TEMP3,MAXNXT,
     1                XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ,
     1                ISUBRO,IBUGA3,IERROR)
          IF(IERROR.EQ.'YES')GOTO9000
C
        ELSEIF(NVAR.EQ.3)THEN
          CALL CKDIS3(Y,XLOW,XHIGH,
     1                TEMP1,N,MAXGRP,NMIN,TEMP2,NPERC,NTOT2,
     1                ISUBRO,IBUGA3,IERROR)
          IF(IERROR.EQ.'YES')GOTO9000
          IFLAG1=1
          IFLAG2=1
          CALL SUMGR2(Y,XLOW,XHIGH,N,IDIST,IFLAG1,IFLAG2,
     1                TEMP1,TEMP2,TEMP3,MAXNXT,
     1                XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ,
     1                ISUBRO,IBUGA3,IERROR)
          IF(IERROR.EQ.'YES')GOTO9000
C
        ELSE
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,111)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,390)
  390     FORMAT('      FOR THE UNCENSORED CASE, MORE THAN ',
     1           'THREE VARIABLES WERE SPECIFIED.')
          CALL DPWRST('XXX','WRIT')
          IERROR='YES'
          GOTO9000
        ENDIF
C
        IF(N2.LT.2 .OR. N2.GT.25000)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,111)
  111     FORMAT('***** ERROR IN GOMPERTZ MAXIMUM LIKELIHOOD--')
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,171)
  171     FORMAT('      AFTER BINNING, THE NUMBER OF CLASSES ',
     1           'IS GREATER THAN 25,000')
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,173)
 173      FORMAT('      OR LESS THAN 2.')
          CALL DPWRST('XXX','WRIT')
          IERROR='YES'
          GOTO9000
        ENDIF
C
        DSUM1=0.0D0
        DSUM2=0.0D0
        DELTA=(X2(2) - X2(1))/2.0
        DO330I=1,N2
          DTEMP1(I)=DBLE(Y2(I))
          DTEMP1(I+25000)=0.0D0
          IF(NVAR.EQ.3)THEN
            DTEMP1(I+50000)=DBLE(X2(I))
            DTEMP1(I+75000)=DBLE(X3(I))
          ELSE
            DTEMP1(I+50000)=DBLE(X2(I)-DELTA)
            DTEMP1(I+75000)=DBLE(X3(I)+DELTA)
          ENDIF
          DSUM1=DSUM1 + DBLE(Y2(I))
          TAU=(X3(I) + X2(I))/2.0
          DSUM2=DSUM2 + DBLE(Y2(I)*TAU)
  330   CONTINUE
        D=DSUM1
        T=DSUM2
C
C     NOW DO THE CENSORED CASES
C
      ELSE
        IF(NVAR.EQ.2)THEN
C
          CALL CKDIST(Y,N,NMIN,TEMP1,NPERC,ISUBRO,IBUGA3,IERROR)
          IF(IERROR.EQ.'YES')GOTO9000
          CALL CKCENS(TAG,TEMP1,N,IDIST,ISUBRO,IBUGA3,IERROR)
          IF(IERROR.EQ.'YES')GOTO9000
          IFLAG=0
          CALL SUMRAW(Y,N,IDIST,IFLAG,
     1                XMEAN,XVAR,XSD,XMIN,XMAX,
     1                ISUBRO,IBUGA3,IERROR)
          NTOTZZ=N
C
          CALL SORTC(Y,TAG,N,Y,TAG)
          IR=0
          DO460I=1,N
            IF(TAG(I).EQ.1.0)IR=IR+1
  460     CONTINUE
          IM=N-IR
C
C         BIN BASED ON FULL DATA SET.
C
          IRELAT='OFF'
          IRHSTG='PERC'
          CLWID=CLWIDT(1)
          IHSTO2='ON'
          CALL DPBIN(Y,N,IRELAT,CLWID,CLLIMI(1),CLLIMI(2),IRHSTG,
     1               TEMP1,MAXOBV,IHSTCW,IHSTO2,
     1               Y2,X2,N2,IBUGA3,IERROR)
C
          IF(N2.LT.2 .OR. N2.GT.25000)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,111)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,471)
  471       FORMAT('      AFTER BINNING, THE NUMBER OF CLASSES ',
     1             'IS GREATER THAN 25,000')
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,473)
  473       FORMAT('      OR LESS THAN 2.')
            CALL DPWRST('XXX','WRIT')
            IERROR='YES'
            GOTO9000
          ENDIF
C
          DSUM1=0.0D0
          DSUM2=0.0D0
          DELTA=(X2(2) - X2(1))/2.0
          DO480I=1,N2
            XLOWLM=X2(I) - DELTA
            XHIGHLM=X2(I) + DELTA
            ITEMP1=0
            ITEMP2=0
            DO485J=1,N
              IF(Y(J).GE.XLOWLM .AND. Y(J).LT.XHIGHLM)THEN
                IF(TAG(J).EQ.1.0)THEN
                  ITEMP1=ITEMP1+1
                ELSE
                  ITEMP2=ITEMP2+1
                ENDIF
              ENDIF
  485       CONTINUE
            DTEMP1(I)=DBLE(ITEMP1)
            DTEMP1(I+25000)=DBLE(ITEMP2)
            DTEMP1(I+50000)=DBLE(X2(I)-DELTA)
            DTEMP1(I+75000)=DBLE(X2(I)+DELTA)
            DSUM1=DSUM1 + DBLE(Y2(I))
            DSUM2=DSUM2 + DBLE(Y2(I)*X2(I))
  480     CONTINUE
          D=DSUM1
          T=DSUM2
C
        ELSEIF(NVAR.EQ.3)THEN
          CALL CKDIS2(Y,XLOW,TEMP1,N,MAXGRP,NMIN,TEMP2,NPERC,NTOT2,
     1                ISUBRO,IBUGA3,IERROR)
          IF(IERROR.EQ.'YES')GOTO9000
C
          DO510I=1,N
            IF(TAG(I).LT.0.0)THEN
              WRITE(ICOUT,999)
              CALL DPWRST('XXX','WRIT')
              WRITE(ICOUT,111)
              CALL DPWRST('XXX','WRIT')
              WRITE(ICOUT,518)I,TAG(I)
  518         FORMAT('      THE CENSORING FREQUENCY FOR CLASS ',I8,
     1               'IS NEGATIVE (',G15.7,').')
              CALL DPWRST('XXX','WRIT')
              IERROR='YES'
              GOTO9000
            ENDIF
  510     CONTINUE
C
          IFLAG1=1
          IFLAG2=1
          CALL SUMGRP(Y,XLOW,N,IDIST,IFLAG1,IFLAG2,
     1                TEMP1,TEMP2,TEMP3,MAXNXT,
     1                XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ,
     1                ISUBRO,IBUGA3,IERROR)
          IF(IERROR.EQ.'YES')GOTO9000
C
          N2=N
          DELTA=(X2(2) - X2(1))/2.0
          DSUM1=0.0D0
          DSUM2=0.0D0
          IR=0
          DO530I=1,N2
            DTEMP1(I)=DBLE(Y(I))
            DTEMP1(I+25000)=DBLE(TAG(I))
            IR=IR + INT(TAG(I)+0.5)
            DTEMP1(I+50000)=DBLE(XLOW(I)-DELTA)
            DTEMP1(I+75000)=DBLE(XLOW(I)+DELTA)
            DSUM1=DSUM1 + DBLE(Y(I))
            DSUM2=DSUM2 + DBLE(Y(I)*XLOW(I))
  530     CONTINUE
          D=DSUM1
          T=DSUM2
C
        ELSEIF(NVAR.EQ.4)THEN
          CALL CKDIS3(Y,XLOW,XHIGH,
     1                TEMP1,N,MAXGRP,NMIN,TEMP2,NPERC,NTOT2,
     1                ISUBRO,IBUGA3,IERROR)
          IF(IERROR.EQ.'YES')GOTO9000
C
          DO610I=1,N
            IF(TAG(I).LT.0.0)THEN
              WRITE(ICOUT,999)
              CALL DPWRST('XXX','WRIT')
              WRITE(ICOUT,111)
              CALL DPWRST('XXX','WRIT')
              WRITE(ICOUT,518)I,TAG(I)
              CALL DPWRST('XXX','WRIT')
              IERROR='YES'
              GOTO9000
            ENDIF
  610     CONTINUE
C
          IFLAG1=1
          IFLAG2=1
          CALL SUMGR2(Y,XLOW,XHIGH,N,IDIST,IFLAG1,IFLAG2,
     1                TEMP1,TEMP2,TEMP3,MAXNXT,
     1                XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ,
     1                ISUBRO,IBUGA3,IERROR)
          IF(IERROR.EQ.'YES')GOTO9000
C
C
          N2=N
          DSUM1=0.0D0
          DSUM2=0.0D0
          IR=0
          DO630I=1,N2
            DTEMP1(I)=DBLE(Y(I))
            DTEMP1(I+25000)=DBLE(TAG(I))
            IR=IR + INT(TAG(I)+0.5)
            DTEMP1(I+50000)=DBLE(XLOW(I))
            DTEMP1(I+75000)=DBLE(XHIGH(I))
            DSUM1=DSUM1 + DBLE(Y(I))
            TAU=(XHIGH(I) + XLOW(I))/2.0
            DSUM2=DSUM2 + DBLE(Y2(I)*TAU)
  630     CONTINUE
          D=DSUM1
          T=DSUM2
C
        ELSE
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,111)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,690)
  690     FORMAT('      FOR THE CENSORED CASE, MORE THAN ',
     1           'FOUR VARIABLES WERE SPECIFIED.')
          CALL DPWRST('XXX','WRIT')
          IERROR='YES'
          GOTO9000
        ENDIF
      ENDIF
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLGZ')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,901)N,N2
  901   FORMAT('N,N2 = ',2I10)
        CALL DPWRST('XXX','WRIT')
        DO910I=1,N2
          WRITE(ICOUT,911)I,DTEMP1(I),DTEMP1(I+25000),
     1                    DTEMP1(I+50000),DTEMP1(I+75000)
  911     FORMAT('I,DTEMP1(I),DTEMP1(I+25000),DTEMP1(I+50000),',
     1           'DTEMP1(I+75000)= ',I8,4G15.7)
          CALL DPWRST('XXX','WRIT')
  910   CONTINUE
      ENDIF
C
C               *****************************************
C               **  STEP 21--                          **
C               **  CARRY OUT CALCULATIONS             **
C               **  FOR GOMPERTZ MLE ESTIMATION        **
C               *****************************************
C
 2100 CONTINUE
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLGZ')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NCLASS=N2
      DXSTRT=0.5D0
      DXLOW=0.1D0
      DXUP=1.0D0
      DAE=2.0*0.000001D0*DXSTRT
      DRE=DAE
      IFLAG=0
      ITBRAC=0
 2105 CONTINUE
      XLOWSV=DXLOW
      XUPSV=DXUP
      CALL DFZER2(GOMFUN,DXLOW,DXUP,DXSTRT,DRE,DAE,IFLAG,DTEMP1)
C
      IF(IFLAG.EQ.4 .AND. ITBRAC.LE.100)THEN
        DXLOW=XLOWSV/2.0D0
        DXUP=2.0D0*XUPSV
        ITBRAC=ITBRAC+1
        GOTO2105
      ENDIF
C
      ALPHAT=REAL(DXLOW)
      AK=REAL(D*DXLOW/DQ)
C
      FISH(1,1)=-REAL(DBLE(-2.0*AK/ALPHAT**3)*DQ +
     1          DBLE(2.0*AK/ALPHAT**2)*DQP - DBLE(AK/ALPHAT)*DQPP)
      FISH(2,2)=-REAL(-D/DBLE(AK**2))
      FISH(1,2)=-REAL(DQ/DBLE(ALPHAT**2) - DQP/DBLE(ALPHAT))
      FISH(2,1)=FISH(1,2)
C
C  NOW COMPUTE THE FISHER INFORMATION MATRIX, THEN INVERT TO
C  OBTAIN THE ASYMPTOTIC VARIANCE-COVARIANCE MATRIX.
C
      CALL SGECO(FISH,2,2,ITEMP9,RCOND,TEMP1)
      IJOB=1
      CALL SGEDI(FISH,2,2,ITEMP9,TEMP1,TEMP1(MAXNXT/2),IJOB)
      DO2810J=1,2
        DO2815I=1,2
          COV(I,J)=FISH(I,J)
 2815   CONTINUE
 2810 CONTINUE
C
C
      IF(IFLAG.EQ.2)THEN
C
C  NOTE: SUPPRESS THIS MESSAGE FOR NOW.
CCCCC   WRITE(ICOUT,999)
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   WRITE(ICOUT,2111)
C2111   FORMAT('***** WARNING FROM GOMPERTZ MAXIMUM ',
CCCCC1         'LIKELIHOOD--')
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   WRITE(ICOUT,2113)
C2113   FORMAT('      ESTIMATE OF SIGMA MAY NOT BE COMPUTED TO ',
CCCCC1         'DESIRED TOLERANCE.')
CCCCC   CALL DPWRST('XXX','BUG ')
      ELSEIF(IFLAG.EQ.3)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2121)
 2121   FORMAT('***** WARNING FROM GOMPERTZ MAXIMUM LIKELIHOOD--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2123)
 2123   FORMAT('      ESTIMATE OF COMPERTZ MAY BE NEAR A SINGULAR ',
     1         'POINT.')
        CALL DPWRST('XXX','BUG ')
      ELSEIF(IFLAG.EQ.4)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,111)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2133)
 2133   FORMAT('      APPROPRIATE BRACKETING INTERVAL NOT FOUND.')
        CALL DPWRST('XXX','BUG ')
      ELSEIF(IFLAG.EQ.5)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2121)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2143)
 2143   FORMAT('      MAXIMUM ITERATIONS EXCEEDED.')
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      IOP='OPEN'
      IFLAG1=1
      IFLAG2=0
      IFLAG3=0
      IFLAG4=0
      IFLAG5=0
      CALL DPAUFI(IOP,IFLAG1,IFLAG2,IFLAG3,IFLAG4,IFLAG5,
     1            IOUNI1,IOUNI2,IOUNI3,IOUNI4,IOUNI5,
     1            IBUGA3,ISUBRO,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
CCCCC DO2300I=1,NCOMP
CCCCC   WRITE(IOUNI1,2301)ALPHA(I),XMEAN(I),XSD(I)
C2300 CONTINUE
C2301 FORMAT(3(E15.7,1X))
C
      IOP='CLOS'
      CALL DPAUFI(IOP,IFLAG1,IFLAG2,IFLAG3,IFLAG4,IFLAG5,
     1            IOUNI1,IOUNI2,IOUNI3,IOUNI4,IOUNI5,
     1            IBUGA3,ISUBRO,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C               ***********************************************
C               **   STEP 42--                               **
C               **   WRITE OUT EVERYTHING                    **
C               **   FOR GOMPERTZ MLE ESTIMATION             **
C               ***********************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLGZ')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     PRINT SUMMARY STATISTICS TABLE
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      IF(ICFLAG.EQ.'OFF')THEN
        ITITLE='Gompertz Parameter Estimation'
        NCTITL=29
        ICNT=1
        ITEXT(ICNT)='Summary Statistics:'
        NCTEXT(ICNT)=19
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=0
        ICNT=ICNT+1
        ITEXT(ICNT)='Number of Observations:'
        NCTEXT(ICNT)=23
        AVALUE(ICNT)=REAL(NTOTZZ)
        IDIGIT(ICNT)=0
        ICNT=ICNT+1
        ITEXT(ICNT)='Sample Mean:'
        NCTEXT(ICNT)=12
        AVALUE(ICNT)=XMEAN
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Sample Standard Deviation:'
        NCTEXT(ICNT)=26
        AVALUE(ICNT)=XSD
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Sample Minimum:'
        NCTEXT(ICNT)=15
        AVALUE(ICNT)=XMIN
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Sample Minimum:'
        NCTEXT(ICNT)=15
        AVALUE(ICNT)=XMAX
        IDIGIT(ICNT)=NUMDIG
      ELSE
        ITITLE='Gompertz Parameter Estimation: Censoring Case'
        NCTITL=45
        ICNT=1
        ITEXT(ICNT)='Summary Statistics:'
        NCTEXT(ICNT)=19
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=0
        ICNT=ICNT+1
        ITEXT(ICNT)='Number of Uncensored Observations:'
        NCTEXT(ICNT)=34
        AVALUE(ICNT)=REAL(NTOTZZ-IR)
        IDIGIT(ICNT)=0
        ICNT=ICNT+1
        ITEXT(ICNT)='Number of Censored Observations:'
        NCTEXT(ICNT)=32
        AVALUE(ICNT)=REAL(IR)
        IDIGIT(ICNT)=0
        ICNT=ICNT+1
        ITEXT(ICNT)='Sample Mean:'
        NCTEXT(ICNT)=12
        AVALUE(ICNT)=XMEAN
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Sample Standard Deviation:'
        NCTEXT(ICNT)=26
        AVALUE(ICNT)=XSD
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Sample Minimum:'
        NCTEXT(ICNT)=15
        AVALUE(ICNT)=XMIN
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Sample Minimum:'
        NCTEXT(ICNT)=15
        AVALUE(ICNT)=XMAX
        IDIGIT(ICNT)=NUMDIG
      ENDIF
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Maximum Likelihood:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Alpha:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=ALPHAT
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of K:'
      NCTEXT(ICNT)=14
      AVALUE(ICNT)=AK
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Standard Error of Alpha:'
      NCTEXT(ICNT)=24
      AVALUE(ICNT)=SQRT(COV(1,1))
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Standard Error of K:'
      NCTEXT(ICNT)=20
      AVALUE(ICNT)=SQRT(COV(2,2))
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Covariance of Alpha and K:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=COV(1,2)
      IDIGIT(ICNT)=NUMDIG
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='Log-likelihood:'
CCCCC NCTEXT(ICNT)=15
CCCCC AVALUE(ICNT)=ALIK
CCCCC IDIGIT(ICNT)=NUMDIG
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=AIC
CCCCC IDIGIT(ICNT)=NUMDIG
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AICc:'
CCCCC NCTEXT(ICNT)=5
CCCCC AVALUE(ICNT)=AICC
CCCCC IDIGIT(ICNT)=NUMDIG
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='BIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=BIC
CCCCC IDIGIT(ICNT)=NUMDIG
      NUMROW=ICNT
      DO2320I=1,NUMROW
        NTOT(I)=15
 2320 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      NCTITZ=0
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLGZ')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLGZ--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)IERROR
 9012   FORMAT('IERROR = ',A4)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLHE(Y,X,N,NVAR,
     1                  TEMP1,TEMP2,TEMP3,ITEMP1,MAXNXT,
     1                  ALPHMO,BETAMO,ALPHML,BETAML,
     1                  ALPHEP,BETAEP,ALPHZF,BETAZF,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES AND METHOD OF MOMENT ESTIMATES FOR
C              THE HERMITE DISTRIBUTION.  FOUR METHODS OF ESTIMATION
C              ARE COMPUTED.
C
C              1. THE METHOD OF MOMENT ESTIMATES ARE THE SOLUTIONS
C                 TO THE EQUATIONS:
C                    ALPHA*(ALPHA+BETA)   - XMEAN = 0
C                    ALPHA*(2*ALPHA+BETA) - XVARI = 0
C                 WITH XMEAN AND XVARI DENOTING THE SAMPLE MEAN AND
C                 VARIANCE RESPECTIVELY.  AFTER SOME ALGEBRA, THIS
C                 CAN BE SOLVED AS:
C
C                    ALPHAHAT = SQRT(XVAR - XBAR)
C                    BETAHAT  = (XVAR/ALPHAHAT) - 2*ALPHAHAT
C
C              2. THE MAXIMUM LIKELIHOOD EQUATIONS ARE:
C                    SUM[n=0 to k][f(n)*{(n/ALPHA) - (ALPHA + BETA)}]
C                       = 0
C                    SUM[n=0 to k][f(n)*ALPHA*{(p(n-1)/p(n) - 1}] = 0
C                 WITH f(n) DENOTING THE SAMPLE FREQUENCIES FOR
C                 N = 0, 1, 2, ..., K   (K = MAXIMUM OBSERVED VALUE)
C                 AND P(n) = HERPDF.
C
C              3. THE EVEN POINT ESTIMATORS ARE
C
C                    AHAT=-0.5*LOG(2*SE/N - 1)
C                    BHAT=0.5*(XBAR - AHAT)
C
C                 WHERE
C
C                    XBAR = SAMPLE MEAN
C                    SE = SUM OF OBSEVED FREQUENCES AT X = 0, 2, ...
C                    ALPHAHAT = SQRT(2*BHAT)
C                    BETAHAT = AHAT/SQRT(2*BHAT)
C
C              4. THE ZEROTH FREQUENCY AND THE MEAN ESTIMATORS ARE
C
C                    AHAT = -(XBAR + 2*LOG(N0/N))
C                    BHAT = XBAR + LOG(N0/N)
C
C              DETAILS OF MAXIMIM LIKELIHOOD ESTIMATION ARE GIVEN
C              IN "SOME PROPERTIES OF THE HERMITE DISTRIBUTION",
C              KEMP AND KEMP, BIOMETRIKA (1965), 52, 3 and 4,
C              P. 381.  THE OTHER METHODS ARE DESCRIBED IN
C              "EVEN POINT ESTIMATION AND MOMENT ESTIMATION IN
C              HERMITE DISTRIBUTIONS", Y. C. PATEL, BIOMETRICS,
C              32, DECEMBER, 1976, PP. 865-873.  THE PATEL
C              ARTICLE ALSO GIVES THE VARIANCES AND COVARIANCES
C              FOR EACH OF THESE METHODS.
C     EXAMPLE--HERMITE MAXIMUM LIKELIHOOD Y
C     REFERENCE--"UNIVARIATE DISCRETE DISTRIBUTIONS", SECOND EDITION,
C                JOHNSON, KOTZ, AND KEMP, WILEY, PP. 202.
C              --"SOME PROPERTIES OF THE HERMITE DISTRIBUTION",
C                KEMP AND KEMP, BIOMETRIKA (1965), 52, 3 and 4,
C                P. 381.
C              --"EVEN POINT ESTIMATION AND MOMENT ESTIMATION IN
C                HERMITE DISTRIBUTIONS", Y. C. PATEL, BIOMETRICS,
C                32, DECEMBER, 1976, PP. 865-873.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004/4
C     ORIGINAL VERSION--APRIL     2004.
C     UPDATED         --APRIL     2011. USE DPDTA1 AND DPDTA5 TO PRINT
C                                       OUTPUT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 IRELAT
      CHARACTER*4 IRHSTG
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*1 IBASLC
C
      REAL IAA
      REAL IAB
      REAL IBB
      REAL MOMCOV
      REAL MLCOV
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DSUM2
      DOUBLE PRECISION DSUM3
      DOUBLE PRECISION DSE
      DOUBLE PRECISION DS0
C
      PARAMETER (MAXROW=50)
      CHARACTER*60 ITITLE
      CHARACTER*1  ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 IDIST
      CHARACTER*40 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(MAXROW)
      CHARACTER*4  VALIGN(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL      IFRST
      LOGICAL      ILAST
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION TEMP1(*)
      DIMENSION TEMP2(*)
      DIMENSION TEMP3(*)
      DIMENSION ITEMP1(*)
C
      REAL AMLCOV(2,2)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='HE  '
C
      IERROR='NO'
      IWRITE='OFF'
C
      IFLAG1=0
      IFLAG2=0
      IFLAG3=0
      IFLAG4=0
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLHE')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLHE--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N,NVAR
   52   FORMAT('IBUGA3,ISUBRO,N,NVAR = ',2(A4,2X),2I8)
        CALL DPWRST('XXX','WRIT')
        IF(NVAR.EQ.1)THEN
          DO56I=1,MIN(N,100)
            WRITE(ICOUT,57)I,Y(I)
   57       FORMAT('I,Y(I) = ',I8,G15.7)
            CALL DPWRST('XXX','WRIT')
   56     CONTINUE
        ELSE
          DO61I=1,N
            WRITE(ICOUT,62)I,X(I),Y(I)
   62       FORMAT('I,X(I),Y(I) = ',I8,2G15.7)
            CALL DPWRST('XXX','WRIT')
   61     CONTINUE
        ENDIF
       ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  1) ROUND DATA TO INTEGER VALUES       **
C               **  2) COMPUTE SUMMARY STATISTICS         **
C               **  3) CHECK INPUT FOR NEGATIVE VALUES,   **
C               **     INSUFFICIENT SAMPLE SIZE           **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLHE')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IDIST='HERMITE'
C
      NPERC=0
      MAXGRP=MAXNXT/2
      NMIN=2
      IF(NVAR.EQ.1)THEN
        DSE=0.0D0
        DSO=0.0D0
        DO1105I=1,N
          ITEMP=INT(Y(I)+0.5)
          Y(I)=REAL(ITEMP)
          IF(MOD(ITEMP,2).EQ.0)THEN
            DSE=DSE + 1.0D0
          ELSE
            DSO=DSO + 1.0D0
          ENDIF
 1105   CONTINUE
        CALL CKDIST(Y,N,NMIN,TEMP1,NPERC,ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
        IFLAG=1
        CALL SUMRAW(Y,N,IDIST,IFLAG,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        NTOTZZ=N
C
C       NOW BIN THE DATA FOR USE BY THE ESTIMATION METHOD BELOW
C
        IRELAT='OFF'
        IRHSTG='OFF'
        XSTART=XMIN-0.5
        XSTOP=XMAX+0.5
        CLWID=1.0
        CALL DPBINI(Y,N,IRELAT,CLWID,XSTART,XSTOP,IRHSTG,
     1              TEMP1,X,N2,IBUGA3,IERROR)
        ICNT=0
        DO1121I=1,N2
          Y(I)=TEMP1(I)
          ICNT=ICNT+1
          Y(ICNT)=Y(I)
          X(ICNT)=X(I)
1121    CONTINUE
        N2=ICNT
      ELSE
        CALL CKDIS2(Y,X,TEMP1,N,MAXGRP,NMIN,TEMP2,NPERC,NTOTZZ,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IFLAG1=1
        IFLAG2=1
        CALL SUMGRP(Y,X,N,IDIST,IFLAG1,IFLAG2,
     1              TEMP1,TEMP2,TEMP3,MAXNXT,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ,
     1              ISUBRO,IBUGA3,IERROR)
        N2=N
      ENDIF
      IF(IERROR.EQ.'YES')GOTO9000
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLHE')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1311)
 1311   FORMAT('AFTER COMPUTE SUMMARY STATISTICS--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1312)XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ
 1312   FORMAT('XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ = ',5G15.7,I10)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
C               *********************************************
C               **  STEP 21--                              **
C               **  CARRY OUT CALCULATIONS FOR HERMITE     **
C               **  PARAMETER ESTIMATION (4 METHODS)       **
C               *********************************************
C
C     HERMITE ONLY APPROPRIATE IF MEAN < VARIANCE
C
      TEMP=XVAR - XMEAN
      IF(TEMP.LE.0.0)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2121)
 2121   FORMAT('***** ERROR FROM HERMITE MAXIMUM LIKELIHOOD ',
     1         'ESTIMATION--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2123)
 2123   FORMAT('      MEAN IS GREATER THAN VARIANCE.  MOMENT AND ')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2125)
 2125   FORMAT('      MAXIMUM LIKELIHOOD ESTIMATES DO NOT EXIST.')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2127)
 2127   FORMAT('      HERMITE DISTRIBUTION NOT APPROPRIATE FOR ',
     1         'THESE DATA.')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2129)XMEAN,XVAR
 2129   FORMAT('      MEAN = ',F14.7,' AND VARIANCE = ',F14.7)
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      ALPHMO=SQRT(XVAR - XMEAN)
      BETAMO=(XVAR/ALPHMO) - 2.0*ALPHMO
      IF(BETAMO.LE.0.0)IFLAG1=1
      IF(IFLAG1.EQ.0)THEN
        AHAT=ALPHMO*BETAMO
        BHAT=ALPHMO**2/2.0
        AN=REAL(NTOTZZ)
        TERM1=(1.0/AN)*(AHAT + 2.0*(AHAT + 4.0*BHAT)**2)
        TERM2=(1.0/AN**2)*(2.0*AHAT - 2.0*(AHAT + 4.0*BHAT)**2)
        TERM3=(1.0/AN**3)*(AHAT + 16.0*BHAT)
        AMOVAR=TERM1 + TERM2 + TERM3
        TERM1=(1.0/AN)*(BHAT + 0.5*(AHAT + 4.0*BHAT)**2)
        TERM2=(1.0/AN**2)*(-4.0*BHAT - 0.5*(AHAT + 4.0*BHAT)**2)
        TERM3=(1.0/AN**3)*(0.25*AHAT + 4.0*BHAT)
        BMOVAR=TERM1 + TERM2 + TERM3
        TERM1=(1.0/AN)*(-1.0*(AHAT + 4.0*BHAT)**2)
        TERM2=(1.0/AN**2)*(-0.5*AHAT + 4.0*BHAT + (AHAT+4.0*BHAT)**2)
        TERM3=(1.0/AN**3)*(-0.5*AHAT - 8.0*BHAT)
        MOMCOV=TERM1 + TERM2 + TERM3
      ENDIF
C
C  EVEN POINT ESTIMATOR
C
C  NOTE: FORMULAS FOR VARIANCES, COVARIANCE IN PATEL ARTICLE
C        SEEM TO BE INCORRECT (I.E., PLUGGING AHAT AND BHAT INTO
C        HIS FORMULAS DOES NOT GIVE ANYTHING CLOSE TO HIS PRINTED
C        RESULTS, I SUSPECT EXP(4*A) TERM IS NOT ACCURATE).
C
      IF(NVAR.EQ.1 .AND. DSE.GT.DSO)THEN
        AHAT=REAL(-0.5D0*DLOG(2.0D0*DSE/DBLE(N) - 1.0D0))
        BHAT=0.5*(XMEAN - AHAT)
        ALPHEP=SQRT(2.0*BHAT)
        BETAEP=AHAT/SQRT(2.0*BHAT)
CCCCC   AEPVAR=0.25*(EXP(4.0*AHAT) - 1.0)
CCCCC   BEPVAR=(1.0/16.0)*(EXP(4.0*AHAT) - 1.0 - 4.0*AHAT + 16.0*BHAT)
CCCCC   EPCOV=(1.0/8.0)*(4.0*AHAT - EXP(4.0*AHAT) + 1.0)
      ELSE
        IFLAG2=1
      ENDIF
C
C  ZERO FREQUENCY AND MEAN ESTIMATOR
C
      DO2160I=1,N2
        IF(X(I).EQ.XMIN)THEN
          AN0=Y(I)
          GOTO2169
        ENDIF
 2160 CONTINUE
      IFLAG3=1
 2169 CONTINUE
C
      IF(IFLAG3.EQ.0)THEN
        AN=REAL(NTOTZZ)
        ALOWLM=-LOG(AN0/AN)
        AUPPLM=-2.0*LOG(AN0/AN)
        IF(XMEAN.GE.ALOWLM .AND. XMEAN.LE.AUPPLM)THEN
          ATEMP=LOG(AN0/AN)
          AHAT=-(XMEAN + 2.0*ATEMP)
          BHAT=XMEAN + ATEMP
          ALPHZF=SQRT(2.0*BHAT)
          BETAZF=AHAT/SQRT(2.0*BHAT)
          Z=EXP(AHAT+BHAT)
          AZFVAR=(1.0/AN)*(4.0*Z - 3.0*AHAT - 4.0*BHAT - 4.0)
          BZFVAR=(1.0/AN)*(Z - AHAT - 1.0)
          ZFCOV=(2.0/AN)*(Z - AHAT - BHAT - 1.0)
        ELSE
          IFLAG3=1
        ENDIF
      ENDIF
C
C  USE MOMENT ESTIMATORS AS INITIAL VALUES FOR MAXIMUM
C  LIKELIHOOD.
C
      BETAML=BETAMO
      IF(BETAML.LE.0.01)BETAML=0.3
      ALPHML=ALPHMO
      IF(ALPHML.LE.0.01)ALPHML=0.3
      MAXIT=100
      ITER=0
C
 2200 CONTINUE
      ITER=ITER+1
      IF(ITER.GT.MAXIT)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2201)
 2201   FORMAT('***** WARNING FROM HERMITE MAXIMUM LIKELIHOOD ',
     1         'ESTIMATION--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2203)
 2203   FORMAT('      MAXIMUM NUMBER OF ITERATIONS REACHED ',
     1         'WITHOUT CONVERGENCE.')
        CALL DPWRST('XXX','WRIT')
        GOTO2299
      ENDIF
C
      IAB=REAL(N)
      IF(ALPHML.GT.0.0)THEN
        IAA=REAL(N)*(1.0 + XMEAN/(ALPHML*ALPHML))
      ELSE
        IFLAG4=1
        GOTO2299
      ENDIF
C
      DSUM1=0.0D0
      DSUM2=0.0D0
      DSUM3=0.0D0
      ANMAX=X(N2)
      DO2210I=1,N2
        AN=X(I)
        FN=Y(I)
        CALL HERPDF(AN,ALPHML,BETAML,PDFN)
        AN2=AN-1
        IF(AN2.GE.0.0)THEN
          CALL HERPDF(AN2,ALPHML,BETAML,PDFNM1)
        ELSE
          PDFNM1=0.0
        ENDIF
        IF(PDFN.GT.0.0)THEN
          THETAN=(PDFNM1/PDFN) - 1.0
        ELSE
          THETAN=0.0
        ENDIF
        DSUM1=DSUM1 + DBLE(FN)*DBLE(THETAN)
        DSUM2=DSUM2 + DBLE(PDFN)*DBLE(THETAN)**2
 2210 CONTINUE
C
      SB=ALPHML*REAL(DSUM1)
      IBB=REAL(N)*ALPHML*ALPHML*REAL(DSUM2)
      BETANW=BETAML + (IAA*SB)/(IAA*IBB - IAB*IAB)
      ALPHML=(-BETANW + SQRT(BETANW*BETANW + 4.0*XMEAN))/2.0
C
C     CHECK FOR CONVERGENCE
C
      IF(ABS(BETANW - BETAML).GT.0.0001)THEN
        BETAML=BETANW
        GOTO2200
      ELSE
        BETAML=BETANW
      ENDIF
C
 2299 CONTINUE
C
      IF(IFLAG4.EQ.0)THEN
        AMLCOV(1,1)=IAA
        AMLCOV(2,2)=IBB
        AMLCOV(1,2)=IAB
        AMLCOV(2,1)=IAB
        MAXROM=2
        NR1=2
        CALL SGECO(AMLCOV,MAXROM,NR1,ITEMP1,RCOND,TEMP1)
        IJOB=1
        CALL SGEDI(AMLCOV,MAXROM,NR1,ITEMP1,TEMP1,TEMP2,IJOB)
        AMLVAR=AMLCOV(1,1)
        BMLVAR=AMLCOV(2,2)
        MLCOV=AMLCOV(1,2)
      ENDIF
C
C               ******************************************
C               **   STEP 42--                          **
C               **   WRITE OUT EVERYTHING               **
C               **   FOR HERMITE MLE ESTIMATE           **
C               ******************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLHE')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
      IF(IBUGA3.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     PRINT SUMMARY STATISTICS TABLE
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Hermite Parameter Estimation'
      NCTITL=28
      ITITLZ=' '
      NCTITZ=0
C
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(NTOTZZ)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample First Frequency:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=F1
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      IF(IFLAG1.EQ.0)THEN
        AHAT=ALPHMO*BETAMO
        BHAT=ALPHMO**2/2.0
        ICNT=ICNT+1
        ITEXT(ICNT)='Method of Moments:'
        NCTEXT(ICNT)=18
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of Alpha:'
        NCTEXT(ICNT)=18
        AVALUE(ICNT)=ALPHMO
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of Beta:'
        NCTEXT(ICNT)=17
        AVALUE(ICNT)=BETAMO
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of A:'
        NCTEXT(ICNT)=14
        AVALUE(ICNT)=AHAT
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of B:'
        NCTEXT(ICNT)=14
        AVALUE(ICNT)=BHAT
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Standard Error of A:'
        NCTEXT(ICNT)=20
        AVALUE(ICNT)=SQRT(AMOVAR)
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Standard Error of B:'
        NCTEXT(ICNT)=20
        AVALUE(ICNT)=SQRT(BMOVAR)
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='A-B Covariance:'
        NCTEXT(ICNT)=15
        AVALUE(ICNT)=MOMCOV
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)=' '
        NCTEXT(ICNT)=0
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
      ENDIF
C
      IF(IFLAG1.EQ.0)THEN
        AHAT=ALPHEP*BETAEP
        BHAT=ALPHEP**2/2.0
        ICNT=ICNT+1
        ITEXT(ICNT)='Method of Even Points:'
        NCTEXT(ICNT)=22
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
        ICNT=ICNT+1
        ITEXT(ICNT)='Sum of Even Frequencies:'
        NCTEXT(ICNT)=24
        AVALUE(ICNT)=REAL(DSE)
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Sum of Odd Frequencies:'
        NCTEXT(ICNT)=23
        AVALUE(ICNT)=REAL(DSO)
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of Alpha:'
        NCTEXT(ICNT)=18
        AVALUE(ICNT)=ALPHEP
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of Beta:'
        NCTEXT(ICNT)=17
        AVALUE(ICNT)=BETAEP
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of A:'
        NCTEXT(ICNT)=14
        AVALUE(ICNT)=AHAT
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of B:'
        NCTEXT(ICNT)=14
        AVALUE(ICNT)=BHAT
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)=' '
        NCTEXT(ICNT)=0
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
      ENDIF
C
      IF(IFLAG3.EQ.0)THEN
        AHAT=ALPHZF*BETAZF
        BHAT=ALPHZF**2/2.0
        ICNT=ICNT+1
        ITEXT(ICNT)='Method of First Frequency:'
        NCTEXT(ICNT)=26
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of Alpha:'
        NCTEXT(ICNT)=18
        AVALUE(ICNT)=ALPHZF
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of Beta:'
        NCTEXT(ICNT)=17
        AVALUE(ICNT)=BETAZF
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of A:'
        NCTEXT(ICNT)=14
        AVALUE(ICNT)=AHAT
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of B:'
        NCTEXT(ICNT)=14
        AVALUE(ICNT)=BHAT
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Standard Error of A:'
        NCTEXT(ICNT)=20
        AVALUE(ICNT)=SQRT(AZFVAR)
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Standard Error of B:'
        NCTEXT(ICNT)=20
        AVALUE(ICNT)=SQRT(BZFVAR)
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='A-B Covariance:'
        NCTEXT(ICNT)=15
        AVALUE(ICNT)=ZFCOV
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)=' '
        NCTEXT(ICNT)=0
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
      ENDIF
C
      IF(IFLAG4.EQ.0)THEN
        AHAT=ALPHML*BETAML
        BHAT=ALPHML**2/2.0
        ICNT=ICNT+1
        ITEXT(ICNT)='Method of Maximum Likelihood:'
        NCTEXT(ICNT)=29
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of Alpha:'
        NCTEXT(ICNT)=18
        AVALUE(ICNT)=ALPHML
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of Beta:'
        NCTEXT(ICNT)=17
        AVALUE(ICNT)=BETAML
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of A:'
        NCTEXT(ICNT)=14
        AVALUE(ICNT)=AHAT
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of B:'
        NCTEXT(ICNT)=14
        AVALUE(ICNT)=BHAT
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Standard Error of A:'
        NCTEXT(ICNT)=20
        AVALUE(ICNT)=SQRT(AMLVAR)
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Standard Error of B:'
        NCTEXT(ICNT)=20
        AVALUE(ICNT)=SQRT(BMLVAR)
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='A-B Covariance:'
        NCTEXT(ICNT)=15
        AVALUE(ICNT)=MLCOV
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)=' '
        NCTEXT(ICNT)=0
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
      ENDIF
C
      NUMROW=ICNT
      DO2310I=1,NUMROW
        NTOT(I)=15
 2310 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLHE')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLHE--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9013)ALPHMO,BETAMO,ALPHML,BETAML
 9013   FORMAT('ALPHMO,BETAMO,ALPHML,BETAML = ',4G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9015)ALPHEP,BETAEP,ALPHZF,BETAZF
 9015   FORMAT('ALPHEP,BETAEP,ALPHZF,BETAZF = ',4G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLHY(Y,N,ITEMP1,ITEMP2,
     1XTEMP,MAXNXT,
     1ICAPSW,ICAPTY,IHYPTY,IOUNI1,
     1ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR HYPERGEOMETRIC DISTRIBUTION.
C              FOR THE HYPERGEOMETRIC DISTRIBUTION, WE HAVE:
C
C                 1) N  = TOTAL NUMBER OF ITEMS IN POPULATION
C                 2) n  = NUMBER OF ITEMS SAMPLED (STORED IN THE
C                         ITEMP1 ARRAY)
C                 3) K  = NUMBER OF DEFECTIVE ITEMS (OR SUCCESSES)
C                         IN POPULATION
C                 4) x  = NUMBER OF DEFECTIVES IN SAMPLE (STORED IN
C                         Y ARRAY)
C
C              THERE ARE TWO DISTINCT CASES:
C
C              GIVEN THAT N (THE POPULATION SIZE) IS KNOWN, WE
C              WANT TO ESTIMATE THE NUMBER OF DEFECTIVES IN
C              THE POPULATION GIVEN A SAMPLE OF SIZE n WITH x
C              DEFECTIVES.  AN EXAMPLE IS ACCEPTANCE SAMPLING
C              WHERE THE LOT SIZE IS KNOWN AND A SUBSAMPLE IS
C              CHOOSEN FOR INSPECTION.  IN THIS CASE, THE MAXIMUM
C              LIKELIHOOD ESTIMATE OF K IS:
C
C                   K = MAX INTEGER <= x*(N+1)/n
C
C              IN CAPTURE/RECAPTURE PROBLEMS, A SAMPLE IS TAKEN
C              AND MARKED.  THAT IS, K IS KNOWN.  THEN A SECOND
C              SAMPLE (OF SIZE n) IS TAKEN AND THE NUMBER OF MARKED
C              ITEMS (x) ARE COUNTED.  IN THIS CASE,
C              THE MAXIMUM LIKELIHOOD ESTIMATES ARE:
C
C                   N = MAX INTEGER <= n*K/x
C
C              WE IMPLEMENT THE REFINEMENT OF CHAPMAN (SEE
C              PAGE 263 OF JOHNSON, KOTZ, AND KEMP):
C
C                   N* = (n+1)*(K+1)/(x+1) - 1
C
C              FORMULAS FOR THE VARIANCE ARE ALSO GIVEN IN
C              JOHNSON, KOTZ, AND KEMP.
C         
C
C     EXAMPLE--HYPERGEOMETRIC MAXIMUM LIKELIHOOD NUMDEF NSAMP NPOP
C              HYPERGEOMETRIC MAXIMUM LIKELIHOOD NUMDEF NSAMP NK
C     REFERENCE--"UNIVARIATE DISCRETE DISTRIBUTIONS", SECOND EDITION,
C                JOHNSON, KOTZ, AND KEMP, WILEY, PP. 262-264.
C              --"STATISTICAL DISTRIBUTIONS", THIRD EDITION,
C                EVANS, HASTINGS, AND PEACOCK, WILEY, PP. 109-113.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004/3
C     ORIGINAL VERSION--MARCH     2004.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IHYPTY
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*1 IBASLC
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION XTEMP(*)
      DIMENSION ITEMP1(*)
      DIMENSION ITEMP2(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='HY  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLHY')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLHY--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,IHYPTY
   52   FORMAT('IBUGA3,IHYPTY = ',A4,1X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)N
   55   FORMAT('N = ',I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I),ITEMP1(I),ITEMP2(I)
   57     FORMAT('I,Y(I),ITEMP1(I) = ',I8,E15.7,2I8)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
       ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLHY')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(N.LT.1)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1111)
 1111   FORMAT('***** ERROR IN HYPERGEOMETRIC MAXIMUM ',
     1         'LIKELIHOOD--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1113)
 1113   FORMAT('      THE NUMBER OF OBSERVATIONS ',
     1         'FOR VARIABLE 1 IS NON-POSITIVE.')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1115)N
 1115   FORMAT('SAMPLE SIZE = ',I8)
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
C               ********************************************
C               **  STEP 21--                             **
C               **  PRINT OUT PRELIMINARY INFORMATION     **
C               ********************************************
C
      IF(IPRINT.EQ.'ON')THEN
      IF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'HTML')THEN
C
C  STEP 2: START TABLE AND DEFINE A CAPTION
C
 5001   FORMAT('</PRE>')
 5011   FORMAT('<UL>')
 5013   FORMAT('<TABLE NOBORDER>')
 5015   FORMAT('   <CAPTION ALIGN=CENTER>')
 5017   FORMAT('      <B>Hypergeometric  Maximum Likelihood ',
     1         'Estimation</B>')
 5019   FORMAT('   </CAPTION>')
        WRITE(ICOUT,5001)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,999)
        WRITE(ICOUT,5011)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5013)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5015)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5017)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5019)
        CALL DPWRST('XXX','WRIT')
C
 5021   FORMAT('   <TR>')
 5023   FORMAT('      <TH ALIGN=CENTER VALIGN=BOTTOM WIDTH=150>')
 5027   FORMAT('      </TH>')
 5029   FORMAT('   </TR>')
 5031   FORMAT('         Number of<BR> Defectives<BR>in Sample')
 5032   FORMAT('         Number of<BR> Items<BR>in Sample')
 5033   FORMAT('         Number of<BR> Defectives<BR>in Population')
 5034   FORMAT('         Number of<BR> Defectives<BR>in Population')
 5035   FORMAT('         Maximum Likelihood<BR>Estimate of<BR>',
     1         'Defectives in Population')
 5036   FORMAT('         Maximum Likelihood<BR>Estimate of<BR>',
     1         'Population Size')
 5037   FORMAT('         Approximate<BR>Variance of<BR>',
     1         'Estimate')
 5038   FORMAT('      <TH COLSPAN=5>')
 5039   FORMAT('         <HR>')
C
        WRITE(ICOUT,5021)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5023)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5031)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5027)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5023)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5032)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5027)
        CALL DPWRST('XXX','WRIT')
        IF(IHYPTY.EQ.'ACCE')THEN
          WRITE(ICOUT,5023)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,5033)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,5027)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,5023)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,5035)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,5027)
          CALL DPWRST('XXX','WRIT')
        ELSE
          WRITE(ICOUT,5023)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,5033)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,5027)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,5023)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,5036)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,5027)
          CALL DPWRST('XXX','WRIT')
        ENDIF
        WRITE(ICOUT,5023)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5037)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5027)
        CALL DPWRST('XXX','WRIT')
C
        WRITE(ICOUT,5029)
        CALL DPWRST('XXX','WRIT')
C
        WRITE(ICOUT,5021)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5038)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5039)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5027)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5021)
        CALL DPWRST('XXX','WRIT')
C
      ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'LATE')THEN
C
C  STEP 1: END ASIS FORMAT, START TABLE ENVIRONMENT, WRITE A HEADER,
C          AND WRITE A TABLE CAPTION
C
 8001 FORMAT(A1,'end{verbatim}')
 8003 FORMAT(A1,'begin{table}')
 8007 FORMAT(5X,'$ ',A1,1X,A1,' $ ',A1,A1,' ')
 8009 FORMAT(A1,'begin{center}')
 8011 FORMAT(5X,'{',A1,'bf Hypergeometric Maximum Likelihood ',
     1       'Estimate}')
 8013 FORMAT(A1,'end{center}')
 8015 FORMAT(5X,'} ',A1,A1)
C
        CALL DPCONA(92,IBASLC)
C
        WRITE(ICOUT,8001)IBASLC
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,8003)IBASLC
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,8009)IBASLC
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,8011)IBASLC
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,8007)IBASLC,IBASLC,IBASLC,IBASLC
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,8007)IBASLC,IBASLC,IBASLC,IBASLC
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,8013)IBASLC
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
C
C STEP 2: START TABULAR ENVIRONMENT, WRITE SUBSESQUENT ROWS, END
C         TABULAR ENVIRONMENT
C
 8020 FORMAT(5X,A1,'begin{tabular} {ccccc}')
 8021 FORMAT(5X,'Number of & Number of & Number of & ',
     1       'Maximum Likelihood & Approximate', 2X,A1,A1)
 8022 FORMAT(5X,'Defectives & Items & Items & ',
     1       'Estimate of & Variance of', 2X,A1,A1)
 8023 FORMAT(5X,'Defectives & Items & Items & ',
     1       'Estimate of & Variance of', 2X,A1,A1)
 8024 FORMAT(5X,'Defectives & Items & Defectives & ',
     1       'Estimate of', 2X,A1,A1)
 8025 FORMAT(5X,'In Sample & In Sample & In Population & ',
     1       'Defectives in Population & Estimate', 2X,A1,A1)
 8026 FORMAT(5X,'In Sample & In Sample & In Population & ',
     1       'Population Size & Estimate', 2X,A1,A1)
 8040 FORMAT(5X,A1,'hline')
 8049 FORMAT(A1,'end{tabular}')
        WRITE(ICOUT,8009)IBASLC
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,8020)IBASLC
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,8021)IBASLC,IBASLC
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,8022)IBASLC,IBASLC
        CALL DPWRST('XXX','WRIT')
        IF(IHYPTY.EQ.'ACCE')THEN
          WRITE(ICOUT,8023)IBASLC,IBASLC
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,8025)IBASLC,IBASLC
          CALL DPWRST('XXX','WRIT')
        ELSE
          WRITE(ICOUT,8024)IBASLC,IBASLC
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,8026)IBASLC,IBASLC
          CALL DPWRST('XXX','WRIT')
        ENDIF
        WRITE(ICOUT,8049)IBASLC
        CALL DPWRST('XXX','WRIT')
      ELSE
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,4301)
 4301   FORMAT('HYPERGEOMETRIC MAXIMUM LIKELIHOOD ESTIMATION:')
        CALL DPWRST('XXX','WRIT')
C
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,4311)
 4311   FORMAT('NUMBER OF      NUMBER OF     NUMBER OF    ',
     1         '   MAXIMUM LIKELIHOOD         APPROXIMATE')
        CALL DPWRST('XXX','WRIT')
        IF(IHYPTY.EQ.'ACCE')THEN
          WRITE(ICOUT,4313)
 4313   FORMAT('DEFECTIVES     ITEMS         ITEMS        ',
     1         '   ESTIMATE OF                VARIANCE OF')
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,4315)
 4315   FORMAT('IN SAMPLE      IN SAMPLE     IN POPULATION',
     1         '   DEFECTIVES IN POPULATION   ESTIMATE')
          CALL DPWRST('XXX','WRIT')
        ELSE
          WRITE(ICOUT,4323)
 4323   FORMAT('DEFECTIVES     ITEMS         DEFECTIVES   ',
     1         '   ESTIMATE OF                VARIANCE OF')
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,4325)
 4325   FORMAT('IN SAMPLE      IN SAMPLE     IN POPULATION',
     1         '   POPULATION SIZE            ESTIMATE')
          CALL DPWRST('XXX','WRIT')
        ENDIF
        WRITE(ICOUT,4331)
 4331   FORMAT('------------------------------------------',
     1         '-----------------------------------------')
        CALL DPWRST('XXX','WRIT')
C
      ENDIF
      ENDIF
C
C               ****************************************
C               **  STEP 41--                         **
C               **  CARRY OUT CALCULATIONS            **
C               **  FOR HYPERGEOMETRIC MLE ESTIMATE   **
C               ****************************************
C
 4100 CONTINUE
C
      ISTEPN='41'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLHY')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IERROR='NO'
      IWRITE='OFF'
C
      DO1405I=1,N
        ITEMP=INT(Y(I)+0.5)
        Y(I)=REAL(ITEMP)
        IF(ITEMP.LT.0)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,1411)
 1411     FORMAT('***** ERROR FROM HYPERGEOMETRIC MAXIMUM ',
     1           'LIKELIHOOD--')
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,1413)
 1413     FORMAT('      NEGATIVE VALUE ENCOUNTERED FOR NUMBER OF ',
     1           'DEFECTIVES.')
          CALL DPWRST('XXX','WRIT')
          IERROR='YES'
          GOTO9000
        ELSEIF(ITEMP1(I).LT.1)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,1421)
 1421     FORMAT('***** ERROR FROM HYPERGEOMETRIC MAXIMUM ',
     1           'LIKELIHOOD--')
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,1423)
 1423     FORMAT('      NON-POSITIVE VALUE ENCOUNTERED IN SECOND ',
     1           'RESPONSE VARIABLE.')
          CALL DPWRST('XXX','WRIT')
          IERROR='YES'
          GOTO9000
        ELSEIF(ITEMP2(I).LT.1)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,1431)
 1431     FORMAT('***** ERROR FROM HYPERGEOMETRIC MAXIMUM ',
     1           'LIKELIHOOD--')
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,1433)
 1433     FORMAT('      NON-POSITIVE VALUE ENCOUNTERED IN THIRD ',
     1           'RESPONSE VARIABLE.')
          CALL DPWRST('XXX','WRIT')
          IERROR='YES'
          GOTO9000
        ENDIF
 1405 CONTINUE
      IERROR='NO'
      IWRITE='OFF'
C
      IF(IHYPTY.EQ.'ACCE')THEN
        DO2010I=1,N
          IX=Y(I)
          NSAMP=ITEMP1(I)
          NPOP=ITEMP2(I)
          ANSAMP=REAL(NSAMP)
          ANPOP=REAL(NPOP)
          AX=REAL(IX)
          AK=AX*(ANPOP+1.0)/ANSAMP
          K=INT(AK)
          AK=REAL(K)
          AP=AK/ANPOP
          AVAR=(ANPOP+1.0)**2*(ANPOP-ANSAMP)*AP*(1.0-AP)/
     1         (ANSAMP*(ANPOP-1.0))
          IF(IPRINT.EQ.'ON')THEN
          IF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'HTML')THEN
C
C  STEP 4: DEFINE DATA ROW
C
 5041       FORMAT('   <TR>')
 5043       FORMAT('      <TD ALIGN=CENTER VALIGN=BOTTOM WIDTH=150>')
 5047       FORMAT('      </TD>')
 5053       FORMAT('         ',I8)
 5055       FORMAT('         ',E15.7)
 5059       FORMAT('   </TR>')
C
            WRITE(ICOUT,5041)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,5043)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,5053)IX
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,5047)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,5043)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,5053)NSAMP
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,5047)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,5043)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,5053)NPOP
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,5047)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,5043)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,5053)K
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,5047)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,5043)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,5055)AVAR
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,5047)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,5059)
            CALL DPWRST('XXX','WRIT')
C
          ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'LATE')THEN
 8031       FORMAT(5X,I8,' & ',I8,' & ',I8,' & ',I8,' & ',G15.7,
     1             2X,A1,A1)
            WRITE(ICOUT,8031)IX,NSAMP,NPOP,K,AVAR,IBASLC,IBASLC
            CALL DPWRST('XXX','WRIT')
          ELSE
            WRITE(ICOUT,4351)IX,NSAMP,NPOP,K,AVAR
            WRITE(IOUNI1,4352)IX,NSAMP,NPOP,K,AVAR
 4351       FORMAT(I8,5X,I8,9X,I8,10X,I8,12X,E15.7)
 4352       FORMAT(4(I8,2X),E15.7)
            CALL DPWRST('XXX','WRIT')
          ENDIF
          ENDIF
 2010   CONTINUE
      ELSE
        DO2610I=1,N
          IX=Y(I)
          NSAMP=ITEMP1(I)
          NK=ITEMP2(I)
          ANSAMP=REAL(NSAMP)
          AK=REAL(NK)
          AX=REAL(IX)
CCCCC     AN=REAL(NSAMP)*REAL(NK)/REAL(IX)
          AN=((ANSAMP+1.0)*(AK+1.0)/(AX+1.0)) - 1.0
          NPOP=INT(AN)
          AN=NPOP
          AM=ANSAMP*AK/AN
          TERM1=(AM**(-1) + 2.0*AM**(-2) + 6.0*AN**(-3))
          AVAR=AN**2*TERM1
          IF(IPRINT.EQ.'ON')THEN
          IF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'HTML')THEN
C
C  STEP 4: DEFINE DATA ROW
C
            WRITE(ICOUT,5041)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,5043)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,5053)IX
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,5047)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,5043)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,5053)NSAMP
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,5047)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,5043)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,5053)NK
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,5047)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,5043)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,5053)NPOP
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,5047)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,5043)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,5055)AVAR
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,5047)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,5059)
            CALL DPWRST('XXX','WRIT')
C
          ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'HTML')THEN
            WRITE(ICOUT,8031)IX,NSAMP,NK,NPOP,AVAR,IBASLC,IBASLC
            CALL DPWRST('XXX','WRIT')
          ELSE
            WRITE(ICOUT,4351)IX,NSAMP,NK,NPOP,AVAR
            CALL DPWRST('XXX','WRIT')
            WRITE(IOUNI1,4352)IX,NSAMP,NK,NPOP,AVAR
          ENDIF
          ENDIF
 2610   CONTINUE
      ENDIF
C
C               ******************************************
C               **   STEP 42--                          **
C               **   CLOSE OUT TABLES                   **
C               ******************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLHY')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'ON')THEN
      IF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'HTML')THEN
C
C  STEP 4: END THE TABLE AND RESET ASIS MODE
C
 5091   FORMAT('</TABLE>')
 5093   FORMAT('</UL>')
 5099   FORMAT('<PRE>')
        WRITE(ICOUT,5091)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5093)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5099)
        CALL DPWRST('XXX','WRIT')
C
      ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'LATE')THEN
C
C STEP 3: END TABLE ENVIRONMENT, RESET ASIS MODE
C
 8091 FORMAT(A1,'end{center}')
 8093 FORMAT(A1,'end{table}')
 8099 FORMAT(A1,'begin{verbatim}')
        WRITE(ICOUT,8091)IBASLC
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,8093)IBASLC
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,8099)IBASLC
        CALL DPWRST('XXX','WRIT')
      ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'RTF')THEN
      ELSE
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
C
      ENDIF
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLHY')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLHY--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012   FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9015)N
 9015   FORMAT('N = ',I8)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLIG(Y,N,
     1XTEMP,MAXNXT,
     1GAMMA,XSCALE,
     1ICAPSW,ICAPTY,
     1ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR INVERSE GAUSSIAN DISTRIBUTION
C     EXAMPLE--INVERSE GAUSSIAN MAXIMUM LIKELIHOOD Y
C     REFERENCE--XX
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--98/5
C     ORIGINAL VERSION--MAY       1998.
C     UPDATED         --DECEMBER  2003. SUPPORT HTML/LATEX OUTPUT
C     UPDATED         --AUGUST    2005. MODIFY THE OUTPUT FORMAT FOR
C                                       CONSISTECY WITH OTHER ML
C                                       ROUTINES
C     UPDATED         --MARCH     2007. FIXED A FORMATTING ISSUE IN THE
C                                       HTML OUTPUT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      DOUBLE PRECISION DSUM
C
      CHARACTER*4 ICAPTY
      CHARACTER*4 ICAPSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 IBASLC
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION XTEMP(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='IG  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLIG')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLIG--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3
   52   FORMAT('IBUGA3 = ',A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,55)N
   55   FORMAT('N = ',I8)
        CALL DPWRST('XXX','BUG ')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,E15.7)
          CALL DPWRST('XXX','BUG ')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLIG')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(N.LT.1)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1111)
 1111   FORMAT('***** ERROR IN INVERSE GAUSSIAN MAXIMUM LIKELIHOOD ',
     1         'ESTIMATION.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1112)
 1112   FORMAT('      THE NUMBER OF OBSERVATIONS FOR THE RESPONSE ',
     1         'VARIABLE IS LESS THAN OR EQUAL TO 1.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1113)N
 1113   FORMAT('SAMPLE SIZE = ',I8)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      HOLD=Y(1)
      DO1135I=2,N
        IF(Y(I).NE.HOLD)GOTO1139
 1135 CONTINUE
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1131)HOLD
 1131 FORMAT('***** NOTE FROM INVERSE GAUSSIAN MAXIMUM ',
     1       'LIKELIHOOD ESTIMATION')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1132)HOLD
 1132 FORMAT('      RESPONSE VARIABLE HAS ALL ELEMENTS = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      GOTO9000
C
 1139 CONTINUE
C
 1290 CONTINUE
C
C               ****************************************
C               **  STEP 41--                         **
C               **  CARRY OUT CALCULATIONS            **
C               **  FOR INVERSE GAUSSIAN MLE ESTIMATE **
C               ****************************************
C
 4100 CONTINUE
C
      ISTEPN='41'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLIG')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IERROR='NO'
      IWRITE='OFF'
      DO4110I=1,N
        IF(Y(I).LT.0.0)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,4111)
 4111     FORMAT('***** NOTE FROM INVERSE GAUSSIAN MAXIMUM ',
     1           'LIKELIHOOD ESTIMATION--')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,4113)
 4113     FORMAT('      NON-POSITIVE VALUE DETECTED.')
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ENDIF
 4110 CONTINUE
C
      IWRITE='OFF'
      CALL MEAN(Y,N,IWRITE,XMEAN,IBUGA3,IERROR)
      CALL SD(Y,N,IWRITE,XSD,IBUGA3,IERROR)
      CALL MINIM(Y,N,IWRITE,XMIN,IBUGA3,IERROR)
      CALL MAXIM(Y,N,IWRITE,XMAX,IBUGA3,IERROR)
C
      DSUM=0.0D0
      DO4120I=1,N
        DSUM=DSUM + (1.0D0/DBLE(Y(I)) - 1.0D0/DBLE(XMEAN))
 4120 CONTINUE
      GAMMA=REAL(DBLE(N)/DSUM)
      XSCALE=XMEAN
C
C               *******************************************
C               **   STEP 42--                           **
C               **   WRITE OUT EVERYTHING                **
C               **   FOR INVERSE GAUSSIAN MLE ESTIMATE   **
C               *******************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLIG')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'ON')THEN
      IF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'HTML')THEN
C
C  STEP 1: END ASIS MODE AND WRITE A HEADER
C
 5001   FORMAT('</PRE>')
 5011   FORMAT('<UL>')
 5013   FORMAT('<TABLE NOBORDER>')
 5015   FORMAT('   <CAPTION ALIGN=CENTER>')
 5017   FORMAT('      <B>Inverse Gaussian Parameter Estimation</b>')
 5019   FORMAT('   </CAPTION>')
        WRITE(ICOUT,5001)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,999)
        WRITE(ICOUT,5011)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5013)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5015)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5017)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5019)
        CALL DPWRST('XXX','WRIT')
C
C  STEP 4: DEFINE DATA ROW
C
 5041   FORMAT('   <TR>')
 5043   FORMAT('      <TD ALIGN=LEFT VALIGN=BOTTOM WIDTH=350>')
 5045   FORMAT('         Number of Observations:')
 5061   FORMAT('         Sample Mean:')
 5062   FORMAT('         Sample Standard Deviation:')
 5063   FORMAT('         Sample Minimum:')
 5064   FORMAT('         Sample Maximum:')
 5065   FORMAT('         Estimate of Gamma Shape Parameter:')
 5066   FORMAT('         Estimate of Mu Shape Parameter:')
 5067   FORMAT('         Estimate of Gamma Shape Parameter:')
 5068   FORMAT('         Estimate of Mu Shape Parameter:')
 5047   FORMAT('      </TD>')
 5049   FORMAT('      <TD ALIGN=RIGHT VALIGN=BOTTOM WIDTH=150>')
 5051   FORMAT('         ',G15.7)
 5053   FORMAT('         ',I8)
 5055   FORMAT('         &nbsp;')
 5059   FORMAT('   </TR>')
 5071   FORMAT('         Summary Statistics:')
 5073   FORMAT('         Maximum Likelihood Estimates:')
C
        WRITE(ICOUT,5041)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5043)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5071)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5047)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5049)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5055)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5047)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5059)
        CALL DPWRST('XXX','WRIT')
C
        WRITE(ICOUT,5041)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5043)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5045)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5047)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5049)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5053)N
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5047)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5059)
        CALL DPWRST('XXX','WRIT')
C
        WRITE(ICOUT,5041)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5043)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5061)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5047)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5049)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5051)XMEAN
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5047)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5059)
        CALL DPWRST('XXX','WRIT')
C
        WRITE(ICOUT,5041)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5043)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5062)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5047)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5049)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5051)XSD
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5047)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5059)
        CALL DPWRST('XXX','WRIT')
C
        WRITE(ICOUT,5041)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5043)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5063)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5047)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5049)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5051)XMIN
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5047)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5059)
        CALL DPWRST('XXX','WRIT')
C
        WRITE(ICOUT,5041)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5043)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5064)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5047)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5049)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5051)XMAX
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5047)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5059)
        CALL DPWRST('XXX','WRIT')
C
        WRITE(ICOUT,5041)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5043)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5055)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5047)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5049)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5055)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5047)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5059)
        CALL DPWRST('XXX','WRIT')
C
        WRITE(ICOUT,5041)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5043)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5073)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5047)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5049)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5055)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5047)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5059)
        CALL DPWRST('XXX','WRIT')
C
        WRITE(ICOUT,5041)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5043)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5067)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5047)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5049)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5051)GAMMA
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5047)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5059)
        CALL DPWRST('XXX','WRIT')
C
        WRITE(ICOUT,5041)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5043)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5068)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5047)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5049)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5051)XSCALE
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5047)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5059)
        CALL DPWRST('XXX','WRIT')
C
C  STEP 4: END THE TABLE AND RESET ASIS MODE
C
 5091   FORMAT('</TABLE>')
 5093   FORMAT('</UL>')
 5099   FORMAT('<PRE>')
        WRITE(ICOUT,5091)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5093)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,5099)
        CALL DPWRST('XXX','WRIT')
C
      ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'LATE')THEN
C
C  STEP 1: END ASIS FORMAT, START TABLE ENVIRONMENT, WRITE A HEADER,
C          AND WRITE A TABLE CAPTION
C
 8001 FORMAT(A1,'end{verbatim}')
 8003 FORMAT(A1,'begin{table}')
 8007 FORMAT(5X,'$ ',A1,1X,A1,' $ ',A1,A1,' ')
 8009 FORMAT(A1,'begin{center}')
 8011 FORMAT(5X,'{',A1,'bf Inverse Gaussian Parameter Estimation}')
 8013 FORMAT(A1,'end{center}')
 8015 FORMAT(5X,'} ',A1,A1)
C
        CALL DPCONA(92,IBASLC)
C
        WRITE(ICOUT,8001)IBASLC
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,8003)IBASLC
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,8009)IBASLC
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,8011)IBASLC
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,8007)IBASLC,IBASLC,IBASLC,IBASLC
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,8007)IBASLC,IBASLC,IBASLC,IBASLC
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,8013)IBASLC
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
C
C STEP 2: START TABULAR ENVIRONMENT, WRITE SUBSESQUENT ROWS, END
C         TABULAR ENVIRONMENT
C
 8020 FORMAT(5X,A1,'begin{tabular} {lr}')
 8021 FORMAT(5X,'Number of Observations: & ',I8,2X,A1,A1)
 8022 FORMAT(5X,'Sample Mean: & ',G15.7,2X,A1,A1)
 8023 FORMAT(5X,'Sample Standard Deviation: & ',G15.7,2X,A1,A1)
 8024 FORMAT(5X,'Sample Minimum: & ',G15.7,2X,A1,A1)
 8025 FORMAT(5X,'Sample Maximum: & ',G15.7,2X,A1,A1)
 8028 FORMAT(5X,'Estimate of $',A1,'gamma$ shape parameter: & ',
     1       G15.7,2X,A1,A1)
 8029 FORMAT(5X,'Estimate of $',A1,'mu$ shape parameter: & ',
     1       G15.7,2X,A1,A1)
 8030 FORMAT(5X,'Summary Statistics: & ',2X,A1,A1)
 8032 FORMAT(5X,'Maximum Likelihood Estimates: & ',2X,A1,A1)
 8033 FORMAT(5X,' & ',2X,A1,A1)
 8040 FORMAT(5X,A1,'hline')
 8049 FORMAT(A1,'end{tabular}')
        WRITE(ICOUT,8009)IBASLC
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,8020)IBASLC
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,8030)IBASLC,IBASLC
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,8021)N,IBASLC,IBASLC
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,8022)XMEAN,IBASLC,IBASLC
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,8023)XSD,IBASLC,IBASLC
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,8024)XMIN,IBASLC,IBASLC
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,8025)XMAX,IBASLC,IBASLC
        CALL DPWRST('XXX','WRIT')
C
        WRITE(ICOUT,8033)IBASLC,IBASLC
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,8032)IBASLC,IBASLC
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,8028)IBASLC,GAMMA,IBASLC,IBASLC
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,8029)XSCALE,IBASLC,IBASLC
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,8049)IBASLC
        CALL DPWRST('XXX','WRIT')
C
C STEP 3: END TABLE ENVIRONMENT, RESET ASIS MODE
C
 8091 FORMAT(A1,'end{table}')
 8093 FORMAT(A1,'end{center}')
 8099 FORMAT(A1,'begin{verbatim}')
        WRITE(ICOUT,8093)IBASLC
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,8091)IBASLC
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,8099)IBASLC
        CALL DPWRST('XXX','WRIT')
      ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'RTF')THEN
      ELSE
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,4211)
 4211   FORMAT(12X,
     1  'INVERSE GAUSSIAN MAXIMUM LIKELIHOOD ESTIMATION:')
        CALL DPWRST('XXX','WRIT')
C
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,4220)
 4220   FORMAT('SUMMARY STATISTICS:')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,4221)N
 4221   FORMAT('NUMBER OF OBSERVATIONS                  = ',I8)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,4222)XMEAN
 4222   FORMAT('SAMPLE MEAN                             = ',G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,4223)XSD
 4223   FORMAT('SAMPLE STANDARD DEVIATION               = ',G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,4224)XMIN
 4224   FORMAT('SAMPLE MINIMUM                          = ',G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,4225)XMAX
 4225   FORMAT('SAMPLE MAXIMUM                          = ',G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
C
        WRITE(ICOUT,4240)
 4240   FORMAT('METHOD OF MAXIMUM LIKELIHOOD:')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,4241)GAMMA
 4241   FORMAT('ESTIMATE OF GAMMA SHAPE PARAMETER       = ',G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,4243)XSCALE
 4243   FORMAT('ESTIMATE OF MU SHAPE PARAMETER          = ',G15.7)
        CALL DPWRST('XXX','WRIT')
C
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4251)
 4251   FORMAT('MAXIMUM LIKELIHOOD ESTIMATES WILL BE SAVED AS ',
     1         'INTERNAL PARAMETERS')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4252)
 4252   FORMAT('GAMMAML, AND MUML.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
C
      ENDIF
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'OFF'.AND.ISUBRO.NE.'MLIG')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPMLIG--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012 FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)N
 9015 FORMAT('N = ',I8)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPMLJO(Y,XLOW,XHIGH,N,NVAR,ICASE,
     1                  TEMP1,TEMP2,TEMP3,TEMP4,DTEMP1,MAXNXT,
     1                  ALPHP1,ALPHP2,ALOCPE,SCALPE,IJOHN,Z,
     1                  ALPHM1,ALPHM2,ALOCMO,SCALMO,
     1                  ICAPSW,ICAPTY,IFORSW,IQUAME,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE PARAMETER ESTIMATES FOR
C              THE JOHNSON SU/SB DISTRIBUTIONS USING THE PERCENTILE
C              METHOD OF SLIFKER AND SHAPIRO.
C     EXAMPLE--JOHNSON PERCENTILE Y
C     REFERENCE--JAMES F. SLIFKER AND SAMUEL S. SHAPIRO, "THE JOHNSON
C                SYSTEM: SELECTION AND PARAMETER ESTIMATION",
C                TECHNOMETRICS, VOL. 22, NO. 2, MAY 1980, PP. 239-246.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004/4
C     ORIGINAL VERSION--APRIL     2004.
C     UPDATED         --APRIL     2011. USE DPDTA1 TO PRINT OUTPUT
C     UPDATED         --APRIL     2011. INCORPORATE MOMENT ESTIMATES
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ICASE
      CHARACTER*4 IQUAME
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ITYPE
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION XLOW(*)
      DIMENSION XHIGH(*)
      DIMENSION TEMP1(*)
      DIMENSION TEMP2(*)
      DIMENSION TEMP3(*)
      DIMENSION TEMP4(*)
      DOUBLE PRECISION DTEMP1(*)
C
      CHARACTER*10 IDIST2
      CHARACTER*40 IDIST
      PARAMETER (MAXROW=50)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 ITEXT(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='JO  '
C
      IERROR='NO'
      IWRITE='OFF'
      IDIST='JOHNSON SB/SU'
C
      ALPHP1=CPUMIN
      ALPHP2=CPUMIN
      ALOCPE=CPUMIN
      SCALPE=CPUMIN
      ALPHM1=CPUMIN
      ALPHM2=CPUMIN
      ALOCMO=CPUMIN
      SCALMO=CPUMIN
      IJOHN=-1
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLJO')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLJO--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N,NVAR,Z
   52   FORMAT('IBUGA3,ISUBRO,N,NVAR,Z = ',2(A4,2X),2I8,G15.7)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I),XLOW(I),XHIGH(I)
   57     FORMAT('I,Y(I),XLOW(I),XHIGH(I) = ',I8,3G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLJO')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     NOTE: THERE ARE 3 POSSIBLE CASES.
C
C     1. UNBINNED DATA
C     2. GROUPED DATA, BIN MID-POINTS PROVIDED
C     3. GROUPED DATA, BIN LOWER/UPPER LIMITS
C        PROVIDED (I.E., UNEQUAL SIZE BINS)
C
      NPERC=0
      MAXGRP=MAXNXT/2
      NMIN=4
      IF(NVAR.EQ.1)THEN
        CALL CKDIST(Y,N,NMIN,TEMP1,NPERC,ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
  180   CONTINUE
        NTOT2=N
        NCLASS=N
        IFLAG=0
        CALL SUMRAW(Y,N,IDIST,IFLAG,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,
     1              ISUBRO,IBUGA3,IERROR)
        NTOTZZ=N
        IF(IERROR.EQ.'YES')GOTO9000
        CALL STMOM3(Y,N,IWRITE,XSKEW,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        CALL STMOM4(Y,N,IWRITE,XKURT,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
      ELSEIF(NVAR.EQ.2)THEN
        CALL CKDIS2(Y,XLOW,TEMP1,N,MAXGRP,NMIN,TEMP2,NPERC,NTOT2,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IFLAG1=1
        IFLAG2=1
        CALL SUMGRP(Y,XLOW,N,IDIST,IFLAG1,IFLAG2,
     1              TEMP1,TEMP2,TEMP3,MAXNXT,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
      ELSEIF(NVAR.EQ.3)THEN
        CALL CKDIS3(Y,XLOW,XHIGH,TEMP1,N,MAXGRP,NMIN,TEMP2,NPERC,NTOT2,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IFLAG1=1
        IFLAG2=1
        CALL SUMGR2(Y,XLOW,XHIGH,N,IDIST,IFLAG1,IFLAG2,
     1              TEMP1,TEMP2,TEMP3,MAXNXT,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
      ELSE
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,111)
  111   FORMAT('***** ERROR IN JOHNSON SB/SU PARAMETER ESTIMATION--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,390)
  390   FORMAT('      MORE THAN THREE RESPONSE VARIABLES WERE ',
     1         'SPECIFIED.')
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
C               **************************************
C               **  STEP 21--                       **
C               **  CARRY OUT CALCULATIONS          **
C               **  FOR JOHNSON PERCENTILE ESTIMATE **
C               **************************************
C
C     NOTE: PERCENTILE ESTIMATE CURRENTLY ONLY AVAILABLE
C           FOR RAW (I.E., UNBINNED DATA).
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLJO')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NVAR.EQ.1)THEN
        AN=NTOTZZ
C
CCCCC   Z=0.524
        ZM=-Z
        Z3=3*Z
        Z3M=-3*Z
        CALL NORCDF(Z,PZ)
        CALL NORCDF(ZM,PZM)
        CALL NORCDF(Z3,PZ3)
        CALL NORCDF(Z3M,PZ3M)
C
        CALL QUANT(PZ,Y,N,IWRITE,TEMP1,MAXNXT,
     1             IQUAME,
     1             XZ,IBUGA3,IERROR)
        CALL QUANT(PZM,Y,N,IWRITE,TEMP1,MAXNXT,
     1             IQUAME,
     1             XZM,IBUGA3,IERROR)
        CALL QUANT(PZ3,Y,N,IWRITE,TEMP1,MAXNXT,
     1             IQUAME,
     1             XZ3,IBUGA3,IERROR)
        CALL QUANT(PZ3M,Y,N,IWRITE,TEMP1,MAXNXT,
     1             IQUAME,
     1             XZ3M,IBUGA3,IERROR)
C
        AM=XZ3 - XZ
        AN2=XZM - XZ3M
        AP=XZ  - XZM
        ACUT=AM*AN2/(AP*AP)
C
        IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLJO')THEN
          WRITE(ICOUT,2190)Z,ZM,Z3,Z3M
 2190     FORMAT('Z,ZM,Z3,Z3M = ',4G15.7)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,2191)PZ,PZM,PZ3,PZ3M
 2191     FORMAT('PZ,PZM,PZ3,PZ3M = ',4G15.7)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,2192)XZ,XZM,XZ3,XZ3M
 2192     FORMAT('XZ,XZM,XZ3,XZ3M = ',4G15.7)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,2193)AM,AN2,AP,ACUT
 2193     FORMAT('AM,AN2,AP,ACUT = ',4G15.7)
          CALL DPWRST('XXX','WRIT')
        ENDIF
C
        IF(ACUT.GE.0.99 .AND. ACUT.LE.1.01)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,2201)
 2201     FORMAT('***** FROM JOHNSON PERCENTILE ESTIMATION--')
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,2203)
 2203     FORMAT('      COMPUTATIONS SUGGEST THE LOGNORMAL ',
     1           'DISTRIBUTION')
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,2205)
 2205     FORMAT('      IS THE MOST APPROPRIATE MODEL.  NO JOHNSON ',
     1           'SB/SU ESTIMATION IS PERFORMED.')
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','WRIT')
          IJOHN=0
          GOTO9000
        ELSEIF(ACUT.GT.1.01)THEN
          ITYPE='SU'
          ANUM=2.0*Z
          TERM1=0.5*((AM/AP) + (AN2/AP))
          IF(TERM1.LT.1.0)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,2201)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,2213)
 2213       FORMAT('      SQUARE ROOT OF A NEGATVE NUMBER ENCOUNTERED')
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,2215)
 2215       FORMAT('      IN COMPUTING ESTIMATE OF ALPHA2.  NO JOHNSON',
     1             'SB/SU ESTIMATION IS PERFORMED.')
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','WRIT')
            GOTO9000
          ELSE
            ADENOM=LOG(TERM1+SQRT(TERM1*TERM1-1.0))
          ENDIF
          ALPHP2=ANUM/ADENOM
C
          ANUM=(AN2/AP) - (AM/AP)
          TERM1=(AM/AP)*(AN2/AP) - 1.0
          IF(TERM1.LT.0.0)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,2201)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,2213)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,2225)
 2225       FORMAT('      IN COMPUTING ESTIMATE OF ALPHA1.  NO JOHNSON',
     1             'SB/SU ESTIMATION IS PERFORMED.')
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,2227)Z
 2227       FORMAT('      TRY ADJUSTING THE VALUE OF Z (CURRENTLY = ',
     1             G15.7,')')
            CALL DPWRST('XXX','WRIT')
            GOTO9000
          ELSE
            ADENOM=2.0*SQRT(TERM1)
          ENDIF
          TERM1=ANUM/ADENOM
          TERM2=LOG(TERM1+SQRT(TERM1*TERM1+1.0))
          ALPHP1=ALPHP2*TERM2
C
          ANUM=2.0*AP*SQRT((AM/AP)*(AN2/AP) - 1.0)
          ADENOM=((AM/AP)+(AN2/AP)-2.0)*SQRT((AM/AP)+(AN2/AP)+2.0)
          SCALPE=ANUM/ADENOM
C
          TERM1=(XZ + XZM)/2.0
          ANUM=AP*((AN2/AP) - (AM/AP))
          ADENOM=2.0*((AM/AP) + (AN2/AP) - 2.0)
          ALOCPE=TERM1 + (ANUM/ADENOM)
          IJOHN=2
C
        ELSE
          ITYPE='SB'
          ANUM=Z
          TERM1=0.5*SQRT((1.0 + (AP/AM))*(1.0 + (AP/AN2)))
          IF(TERM1.LT.1.0)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,2201)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,2213)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,2235)
 2235       FORMAT('      IN COMPUTING ESTIMATE OF ALPHA2.  NO ',
     1         'JOHNSON SB/SU ESTIMATION IS PERFORMED.')
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,2227)Z
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','WRIT')
            GOTO9000
          ELSE
            ADENOM=LOG(TERM1+SQRT(TERM1*TERM1-1.0))
          ENDIF
          ALPHP2=ANUM/ADENOM
C
          ANUM=(AP/AN2) - (AP/AM)
          ANUM=ANUM*SQRT((1.0 + (AP/AM))*(1.0 + (AP/AN2)) - 4.0)
          ADENOM=2.0*((AP/AM)*(AP/AN2) - 1.0)
          TERM1=ANUM/ADENOM
          TERM2=LOG(TERM1+SQRT(TERM1*TERM1+1.0))
          ALPHP1=ALPHP2*TERM2
C
          TERM1=(1.0 + (AP/AM))*(1.0 + (AP/AN2) - 2.0)**2 - 4.0
          IF(TERM1.LT.0.0)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,2201)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,2213)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,2245)
 2245       FORMAT('      IN COMPUTING ESTIMATE OF SCALE FOR JOHNSON ',
     1             'SB.')
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,2247)
 2247       FORMAT('NO JOHNSON SB/SU ESTIMATION IS PERFORMED.')
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,2227)Z
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','WRIT')
            IERROR='YES'
            GOTO9000
          ELSE
CCCCC       ANUM=AP*SQRT(TERM1 - 4.0)
            ANUM=AP*SQRT(TERM1)
          ENDIF
          ADENOM=((AP/AM)*(AP/AN2) - 1.0)
          SCALPE=ANUM/ADENOM
C
          TERM1=(XZ + XZM)/2.0
          TERM2=SCALPE/2.0
          ANUM=AP*((AP/AN2) - (AP/AM))
          ADENOM=2.0*((AP/AM)*(AP/AN2) - 1.0)
          IF(ADENOM.EQ.0.0)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,2201)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,2253)
 2253       FORMAT('      DIVISION BY ZERO ENCOUNTERED IN COMPUTING')
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,2255)
 2255       FORMAT('      ESTIMATE OF LOCATION FOR JOHNSON SB.')
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,2257)
 2257       FORMAT('NO JOHNSON SB/SU ESTIMATION IS PERFORMED.')
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,2227)Z
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','WRIT')
            GOTO9000
          ELSE
            ALOCPE=TERM1 - TERM2 + (ANUM/ADENOM)
          ENDIF
          IJOHN=1
C
        ENDIF
C
      ENDIF
C
C               **************************************
C               **  STEP 31--                       **
C               **  CARRY OUT CALCULATIONS          **
C               **  FOR JOHNSON MOMENT     ESTIMATE **
C               **************************************
C
C     NOTE: MOMENT ESTIMATE CURRENTLY ONLY AVAILABLE
C           FOR RAW (I.E., UNBINNED DATA).
C
      ISTEPN='31'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLJO')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NVAR.EQ.1)THEN
        IF(ICASE.EQ.'JB')THEN
          IDIST2='JOHNSON SB'
          ITYPE2=3
        ELSE
          IDIST2='JOHNSON SU'
          ITYPE2=2
        ENDIF
        CALL JNSN(XMEAN,XSD,XSKEW,XKURT,ITYPE2,ALPHM1,ALPHM2,
     1            SCALMO,ALOCMO,IFAULT)
        IF(IFAULT.EQ.1)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,3101)IDIST2
 3101     FORMAT('***** ERROR FOR ',A10,' METHOD OF MOMENTS.')
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,3103)
 3103     FORMAT('      COMPUTED STANDARD DEVIATION LESS THAN ZERO.')
          CALL DPWRST('XXX','WRIT')
          GOTO9000
        ELSEIF(IFAULT.EQ.2)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,3101)IDIST2
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,3106)
 3106     FORMAT('      KURTOSIS < SKEWNESS**2 + 1')
          CALL DPWRST('XXX','WRIT')
          GOTO9000
        ELSEIF(IFAULT.EQ.3)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,3101)IDIST2
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,3108)
 3108     FORMAT('      FITTING FAILED TO CONVERGE.')
          CALL DPWRST('XXX','WRIT')
        ENDIF
C
      ENDIF
C
C               ***************************************
C               **   STEP 42--                      **
C               **   WRITE OUT EVERYTHING           **
C               **   FOR JOHNSON SB/SU ESTIMATION   **
C               **************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLJO')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     PRINT SUMMARY STATISTICS TABLE
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Johnson SB/SU Parameter Estimation: Full Sample Case'
      NCTITL=52
      ITITLZ=' '
      NCTITZ=0
C
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(NTOTZZ)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      IF(NVAR.GT.1)GOTO4209
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Percentile Method:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Value of Z:'
      NCTEXT(ICNT)=11
      AVALUE(ICNT)=Z
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Value of PZ = NORCDF(Z):'
      NCTEXT(ICNT)=24
      AVALUE(ICNT)=PZ
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Value of PZM = NORCDF(-Z):'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=PZM
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Value of PZ3 = NORCDF(3*Z):'
      NCTEXT(ICNT)=27
      AVALUE(ICNT)=PZ3
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Value of PZ3M = NORCDF(-3*Z):'
      NCTEXT(ICNT)=29
      AVALUE(ICNT)=PZ3M
      IDIGIT(ICNT)=NUMDIG
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Value of Quantile(0.5 + PZ/N):'
      NCTEXT(ICNT)=30
      AVALUE(ICNT)=XZ
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Value of Quantile(0.5 + PZM/N):'
      NCTEXT(ICNT)=31
      AVALUE(ICNT)=XZM
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Value of Quantile(0.5 + PZ3/N):'
      NCTEXT(ICNT)=31
      AVALUE(ICNT)=XZ3
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Value of Quantile(0.5 + PZ3M/N):'
      NCTEXT(ICNT)=32
      AVALUE(ICNT)=XZ3M
      IDIGIT(ICNT)=NUMDIG
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Value of M = XZ3 - XZ:'
      NCTEXT(ICNT)=22
      AVALUE(ICNT)=AM
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Value of N = XZM - XZ3:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=AN2
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Value of P = XZ - XZM:'
      NCTEXT(ICNT)=22
      AVALUE(ICNT)=AP
      IDIGIT(ICNT)=NUMDIG
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Value of ACUT = M*N/P**2:'
      NCTEXT(ICNT)=25
      AVALUE(ICNT)=ACUT
      IDIGIT(ICNT)=NUMDIG
      IF(ACUT.GT.1.0)THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='ACUT > 1 => Johnson SU Distribution:'
        NCTEXT(ICNT)=36
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
      ELSE
        ICNT=ICNT+1
        ITEXT(ICNT)='ACUT < 1 => Johnson SB Distribution:'
        NCTEXT(ICNT)=36
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
      ENDIF
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Alpha1:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=ALPHP1
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Alpha2:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=ALPHP2
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Location:'
      NCTEXT(ICNT)=21
      AVALUE(ICNT)=ALOCPE
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Scale:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=SCALPE
      IDIGIT(ICNT)=NUMDIG
C
      IF(NVAR.GT.1)GOTO4209
C
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      IF(ICASE.EQ.'SB')THEN
        ITEXT(ICNT)='Johnson SB Moments Method:'
        NCTEXT(ICNT)=26
      ELSE
        ITEXT(ICNT)='Johnson SU Moments Method:'
        NCTEXT(ICNT)=26
      ENDIF
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Alpha1:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=ALPHM1
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Alpha2:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=ALPHM2
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Location:'
      NCTEXT(ICNT)=21
      AVALUE(ICNT)=ALOCMO
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Scale:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=SCALMO
      IDIGIT(ICNT)=NUMDIG
C
 4209 CONTINUE
C
      NUMROW=ICNT
      DO2310I=1,NUMROW
        NTOT(I)=15
 2310 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLJO')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLJO--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)IERROR
 9012   FORMAT('IERROR = ',A4)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLKA(Y,X,N,NVAR,
     1                  TEMP1,TEMP2,TEMP3,
     1                  ALPHMO,BETAMO,ALPHML,BETAML,
     1                  AICMO,AICCMO,BICMO,
     1                  AICML,AICCML,BICML,
     1                  ICAPSW,ICAPTY,IFORSW,MAXNXT,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE METHOD OF MOMENT ESTIMATES
C              FOR THE KATZ DISTRIBUTION (NEED TO OBTAIN THE KATZ
C              ARTICLE TO ADD MAXIMUM LIKELIHOOD ESTIMATES).
C
C              KATZ PROPOSED THE REPARAMETERIZATION:
C
C                 MU = ALPHA/(1 - BETA)
C
C                 ETA = BETA/(1 - BETA)
C                     = (SIGMA**2 - MU)/MU
C
C              SO THE MOMENT ESTIMATES OF MU AND ETA ARE:
C
C                 MUHAT = XBAR
C                 ETAHAT = (S**2 - XBAR)/XBAR
C
C              WITH XBAR AND S**2 DENOTING THE SAMPLE MEAN AND
C              SAMPLE VARIANCE, RESPECTIVELY.  THE MOMENT ESTIMATES
C              FOR ALPHA AND BETA CAN BE DETERMINED FROM MUHAT
C              AND ETAHAT AS:
C
C                 ALPHAHAT = MUHAT*(1 - ETAHAT/(ETAHAT+1))
C                 BETAHAT  = ETAHAT/(ETAHAT+1)
C
C     EXAMPLE--KATZ MAXIMUM LIKELIHOOD Y 
C     REFERENCE--"UNIVARIATE DISCRETE DISTRIBUTIONS", THIRD EDITION,
C                JOHNSON, KEMP, AND KOTZ, WILEY, PP. 82-83.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2007/3
C     ORIGINAL VERSION--MARCH     2007.
C     UPDATED         --APRIL     2011. USE DPDTA1 TO PRINT OUTPUT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 IRELAT
      CHARACTER*4 IRHSTG
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION TEMP1(*)
      DIMENSION TEMP2(*)
      DIMENSION TEMP3(*)
C
      PARAMETER (MAXROW=20)
      CHARACTER*60 ITITLE
      CHARACTER*1  ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 IDIST
      CHARACTER*40 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(MAXROW)
      CHARACTER*4  VALIGN(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL      IFRST
      LOGICAL      ILAST
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='KA  '
C
      IERROR='NO'
      IWRITE='OFF'
C
      ALPHMO=CPUMIN
      BETAMO=CPUMIN
      ALPHML=CPUMIN
      BETAML=CPUMIN
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLKA')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLKA--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N,NVAR
   52   FORMAT('IBUGA3,ISUBRO,N,NVAR = ',2(A4,2X),2I8)
        CALL DPWRST('XXX','WRIT')
        IF(NVAR.EQ.1)THEN
          DO56I=1,MIN(N,100)
            WRITE(ICOUT,57)I,Y(I)
   57       FORMAT('I,Y(I) = ',I8,G15.7)
            CALL DPWRST('XXX','WRIT')
   56     CONTINUE
        ELSE
          DO61I=1,N
            WRITE(ICOUT,62)I,X(I),Y(I)
   62       FORMAT('I,X(I),Y(I) = ',I8,2G15.7)
            CALL DPWRST('XXX','WRIT')
   61     CONTINUE
        ENDIF
       ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  1) ROUND DATA TO INTEGER VALUES       **
C               **  2) COMPUTE SUMMARY STATISTICS         **
C               **  3) CHECK INPUT FOR NEGATIVE VALUES,   **
C               **     INSUFFICIENT SAMPLE SIZE           **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLKA')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IDIST='KATZ'
C
      NPERC=0
      MAXGRP=MAXNXT/2
      NMIN=2
      IF(NVAR.EQ.1)THEN
        DO1105I=1,N
          ITEMP=INT(Y(I)+0.5)
          Y(I)=REAL(ITEMP)
 1105   CONTINUE
        CALL CKDIST(Y,N,NMIN,TEMP2,NPERC,ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
        IFLAG=1
        CALL SUMRAW(Y,N,IDIST,IFLAG,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        NTOTZZ=N
C
      ELSE
        CALL CKDIS2(Y,X,TEMP1,N,MAXGRP,NMIN,TEMP2,NPERC,NTOTZZ,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IFLAG1=1
        IFLAG2=1
        CALL SUMGRP(Y,X,N,IDIST,IFLAG1,IFLAG2,
     1              TEMP1,TEMP2,TEMP3,MAXNXT,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
      ENDIF
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLKA')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1151)
 1151   FORMAT('AFTER COMPUTE SUMMARY STATISTICS--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1152)XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ
 1152   FORMAT('XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ = ',5G15.7,I10)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
C               ******************************************
C               **  STEP 21--                           **
C               **  CARRY OUT CALCULATIONS              **
C               **  FOR KATZ MLE ESTIMATE               **
C               ******************************************
C
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLKA')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      AMUHAT=XMEAN
      ETAHAT=(XVAR - XMEAN)/XMEAN
      ALPHMO=AMUHAT*(1.0 - ETAHAT/(ETAHAT+1.0))
      BETAMO=ETAHAT/(ETAHAT + 1.0)
C
C               ******************************************
C               **   STEP 42--                          **
C               **   WRITE OUT EVERYTHING               **
C               **   FOR KATZ MLE ESTIMATE             **
C               ******************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLKA')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     PRINT SUMMARY STATISTICS TABLE
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Katz Parameter Estimation'
      NCTITL=25
      ITITLZ=' '
      NCTITZ=0
C
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(NTOTZZ)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Moment Estimates:'
      NCTEXT(ICNT)=17
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Alpha:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=ALPHMO
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Beta:'
      NCTEXT(ICNT)=17
      AVALUE(ICNT)=BETAMO
      IDIGIT(ICNT)=NUMDIG
C
      NUMROW=ICNT
      DO2310I=1,NUMROW
        NTOT(I)=15
 2310 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLKA')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLKA--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)IERROR,ALPHMO,BETAMO
 9012   FORMAT('IERROR,ALPHMO,BETAMO = ',A4,2X,2G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLKP(Y,N,
     1                  DTEMP1,XMOM,MAXNXT,
     1                  SHA1LM,SHA2LM,ALOCLM,SCALLM,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE L-MOMENT ESTIMATES
C              FOR THE KAPPA DISTRIBUTION
C     EXAMPLE--KAPPA MAXIMUM LIKELIHOOD Y
C     REFERENCE--FORTRAN CODE WRITTEN FOR INCLUSION IN IBM
C                RESEARCH REPORT RC20525, 'FORTRAN ROUTINES FOR
C                USE WITH THE METHOD OF L-MOMENTS, VERSION 3',
C                J. R. M. HOSKING, IBM RESEARCH DIVISION,
C                T. J. WATSON RESEARCH CENTER, YORKTOWN HEIGHTS
C                NEW YORK 10598, U.S.A., VERSION 3     AUGUST 1996
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2008/6
C     ORIGINAL VERSION--JUNE      2008.
C     UPDATED         --JULY      2010. EXTRACT POINT ESTIMATES TO KAPML1
C     UPDATED         --JULY      2010. USE DPDTA1 TO PRINT OUTPUT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ICASPL
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION QP(1)
      DOUBLE PRECISION DTEMP1(*)
      DOUBLE PRECISION XMOM(*)
C
      DOUBLE PRECISION XPAR(4)
C
CCCCC PARAMETER (NUMALP=6)
CCCCC DIMENSION ALPHA(NUMALP)
CCCCC DIMENSION ALOWSC(NUMALP)
CCCCC DIMENSION AUPPSC(NUMALP)
CCCCC DIMENSION ALOWGA(NUMALP)
CCCCC DIMENSION AUPPGA(NUMALP)
C
      PARAMETER (MAXROW=20)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(MAXROW)
      CHARACTER*4  VALIGN(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
CCCCC DATA ALPHA /0.50, 0.25, 0.10, 0.05, 0.01, 0.001/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='KP  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLKP')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLKP--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N
   52   FORMAT('IBUGA3,ISUBRO,N = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLKP')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C               ***************************************************
C               **  STEP 21--                                    **
C               **  CARRY OUT CALCULATIONS                       **
C               **  FOR KAPPA L-MOMENT ESTIMATION                **
C               ***************************************************
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLKP')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NPERC=0
      NMIN=3
      CALL CKDIST(Y,N,NMIN,QP,NPERC,ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IERROR='NO'
      IWRITE='OFF'
C
      CALL KAPML1(Y,N,
     1            DTEMP1,XMOM,NMOM,
     1            XMEAN,XSD,XVAR,XMIN,XMAX,
     1            ALOCLM,SCALLM,SHA1LM,SHA2LM,
     1            ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C               ***********************************************
C               **   STEP 42--                               **
C               **   WRITE OUT EVERYTHING                    **
C               **   FOR KAPPA MLE ESTIMATION                **
C               ***********************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLKP')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
      IF(IBUGA3.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Kappa Parameter Estimation:'
      NCTITL=27
      ITITLZ='Full Sample Case'
      NCTITZ=16
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(N)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='First Sample L-Moment:'
      NCTEXT(ICNT)=22
      AVALUE(ICNT)=REAL(XMOM(1))
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Second Sample L-Moment:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(XMOM(2))
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Third Sample L-Moment:'
      NCTEXT(ICNT)=22
      AVALUE(ICNT)=REAL(XMOM(3))
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Fourth Sample L-Moment:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(XMOM(4))
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Method of L-Moments:'
      NCTEXT(ICNT)=20
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Location:'
      NCTEXT(ICNT)=22
      AVALUE(ICNT)=ALOCLM
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Scale:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=SCALLM
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Shape Parameter K:'
      NCTEXT(ICNT)=30
      AVALUE(ICNT)=SHA1LM
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Shape Parameter H:'
      NCTEXT(ICNT)=30
      AVALUE(ICNT)=SHA2LM
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='Log-likelihood:'
CCCCC NCTEXT(ICNT)=15
CCCCC AVALUE(ICNT)=ALIK
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=AIC
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AICc:'
CCCCC NCTEXT(ICNT)=5
CCCCC AVALUE(ICNT)=AICC
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='BIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=BIC
CCCCC IDIGIT(ICNT)=-7
C
      NUMROW=ICNT
      DO2320I=1,NUMROW
        NTOT(I)=15
 2320 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLKP')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLKP--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012   FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9015)N
 9015   FORMAT('N = ',I8)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLLB(Y,N,
     1                  XTEMP,YLOG,MAXNXT,CUSER,DUSER,
     1                  ALPHSV,BETASV,CSV,DSV,
     1                  A,B,ALPHA2,BETA2,ALPHA1,BETA1,
     1                  ALPHSE,BETASE,COVSE,
     1                  QP,XQPHAT,XQPLCL,XQPUCL,XQPSE,NPERC,
     1                  IOUNI1,IOUNI2,ALPHAP,
     1                  ICAPSW,ICAPTY,IFORSW,DTEMP1,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE METHOD OF MOMENT AND
C              MAXIMUM LIKELIHOOD ESTIMATES FOR THE SHAPE PARAMETERS
C              OF THE LOG BETA DISTRIBUTION.
C
C              THE ALGORITHM IS TO TAKE THE LOG OF THE DATA,
C              COMPUTE THE BETA MOMENT/ML ESTIMATES, AND THEN
C              TAKE THE EXPONENT OF THE RESULTS.
C
C     EXAMPLE--LOG BETA MOMENTS Y
C     REFERENCE--NADARAJAH AND GUPTA (2004).  "APPLICATIONS OF THE
C                BETA DISTRIBUTION" in "HANDBOOK OF THE BETA
C                DISTRIBUTION", EDITED BY GUPTA AND NADARAJAH,
C                MARCEL-DEKKER, PP.100-102.
C              --EVANS, HASTINGS, AND PEACOCK.  "STATISTICAL
C                DISTRIBUTIONS", THIRD EDITION, WILEY, 2000,
C                PP. 34-42.
C                JOHNSON, KOTZ, AND BALAKRISHNAN.  "CONTINUOUS
C                UNIVARIATE DISTRIBUTIONS, VOLUME II", SECOND
C                EDITION, WILEY, 1994.
C              --KARL BURY, "STATISTICAL DISTRIBUTIONS IN
C                ENGINEERING", CAMBRIDGE UNIVERSITY PRESS,
C                1999, CHAPTER 14.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2007/6
C     ORIGINAL VERSION--JUNE      2007.
C     UPDATED         --AUGUST    2007. SOME UPGRADES TO FIT
C                                       PROCEDURE.  ALLOW STARTING
C                                       VALUES, OTHER TWEAKS.
C     UPDATED         --SEPTEMBER 2012. USE DPDTA1, DPDTA5 ROUTINES
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION YLOG(*)
      DIMENSION XTEMP(*)
      DOUBLE PRECISION DTEMP1(*)
C
      PARAMETER (NUMALP=6)
      DIMENSION ALPHA(NUMALP)
      DIMENSION ALOWAL(NUMALP)
      DIMENSION AUPPAL(NUMALP)
      DIMENSION ALOWBE(NUMALP)
      DIMENSION AUPPBE(NUMALP)
      DIMENSION ALOWA2(NUMALP)
      DIMENSION AUPPA2(NUMALP)
      DIMENSION ALOWB2(NUMALP)
      DIMENSION AUPPB2(NUMALP)
      DIMENSION ALOWLO(NUMALP)
      DIMENSION AUPPLO(NUMALP)
      DIMENSION ALOWSC(NUMALP)
      DIMENSION AUPPSC(NUMALP)
C
      DIMENSION QP(*)
      DIMENSION XQPHAT(*)
      DIMENSION XQPSE(*)
      DIMENSION XQPLCL(*)
      DIMENSION XQPUCL(*)
C
      DOUBLE PRECISION TOL
      DOUBLE PRECISION XPAR(2)
      DOUBLE PRECISION FVEC(2)
      DOUBLE PRECISION DAE
      DOUBLE PRECISION DRE
      DOUBLE PRECISION DXSTRT
      DOUBLE PRECISION DXLOW
      DOUBLE PRECISION DXUP
C
      EXTERNAL BETFUN
      DOUBLE PRECISION BETFU2
      EXTERNAL BETFU2
      DOUBLE PRECISION BETFU5
      EXTERNAL BETFU5
      EXTERNAL BETFU7
      EXTERNAL BETFU8
      DOUBLE PRECISION DLBETA
      EXTERNAL DLBETA
C
      DOUBLE PRECISION DANS(10)
      DOUBLE PRECISION DA
      DOUBLE PRECISION DB
      DOUBLE PRECISION DC
      DOUBLE PRECISION DALPHA
      DOUBLE PRECISION DBETA
      DOUBLE PRECISION DALPBE
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM2
      DOUBLE PRECISION DTERM3
      DOUBLE PRECISION DTERM4
C
      INCLUDE 'DPCOMC.INC'
C
C---------------------------------------------------------------------
C
      COMMON /BETAML/ BETALL, BETAUL
C
      INTEGER N2
      DOUBLE PRECISION DSUM3
      DOUBLE PRECISION DSUM4
      DOUBLE PRECISION DLLAB
      DOUBLE PRECISION DK
      COMMON/BETCO9/DSUM3,DSUM4,DLLAB,DK,N2
C
      DOUBLE PRECISION DBETA2
      COMMON/BETCO2/DBETA2
C
      DOUBLE PRECISION DALPH2
      COMMON/BETCO5/DALPH2
C
      DOUBLE PRECISION DBETA3
      COMMON/BETCO3/DBETA3
C
      DOUBLE PRECISION DALPH3
      COMMON/BETCO4/DALPH3
C
      COMMON/BETCO7/P7,BETA3
      COMMON/BETCO8/P8,ALPHA3
C
      DOUBLE PRECISION DN
C
      DOUBLE PRECISION BE4FUN
      EXTERNAL BE4FUN
C
      DOUBLE PRECISION DTERM5
      DOUBLE PRECISION DTERM6
      DOUBLE PRECISION DTERM7
      DOUBLE PRECISION DTERM8
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DSUM2
      DOUBLE PRECISION DM1
      DOUBLE PRECISION DM2
      DOUBLE PRECISION DM3
      DOUBLE PRECISION DM4
C
      DOUBLE PRECISION DM1P
      DOUBLE PRECISION DM2P
      DOUBLE PRECISION DM3P
      DOUBLE PRECISION DM4P
      COMMON /BET4ML/ DM2P, DM3P, DM4P
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=40)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(NUMALP)
      CHARACTER*4  VALIGN(NUMALP)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C
      CHARACTER*4 ILIKFL
      CHARACTER*4 ILOCFL
      CHARACTER*4 ISCAFL
      CHARACTER*8 ISHAP1
      CHARACTER*8 ISHAP2
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA ALPHA /0.50, 0.25, 0.10, 0.05, 0.01, 0.001/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='LB  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLLB')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLLB--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3
   52   FORMAT('IBUGA3 = ',A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)N,CUSER,DUSER
   55   FORMAT('N,CUSER,DUSER = ',I8,2G15.7)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,E15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLLB')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(N.LE.2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1111)
 1111   FORMAT('***** ERROR IN DPMLLB--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1113)
 1113   FORMAT('      THE NUMBER OF OBSERVATIONS FOR THE RESPONSE ',
     1         'IS LESS THAN 3')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1115)N
 1115   FORMAT('SAMPLE SIZE = ',I8)
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      HOLD=Y(1)
      DO1135I=2,N
      IF(Y(I).NE.HOLD)GOTO1139
 1135 CONTINUE
 1130 CONTINUE
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1111)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1131)HOLD
 1131 FORMAT('      THE RESPONSE VARIABLE HAS ALL ELEMENTS = ',G15.7)
      CALL DPWRST('XXX','WRIT')
      IERROR='YES'
      GOTO9000
 1139 CONTINUE
C
      IF(NPERC.GT.0)THEN
        DO1145I=1,NPERC
          IF(QP(I).LE.0.0 .OR. QP(I).GE.100.0)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,1141)
 1141       FORMAT('***** WARNING IN LOG BETA MAXIMUM LIKELIHOOD--')
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,1143)QP(I)
 1143       FORMAT('      REQUESTED PERCENTILE (',G15.7,') IS ',
     1             'OUTSIDE THE (0,100) INTERVAL')
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,1144)
 1144       FORMAT('      NO PERCENTILE CONFIDENCE LIMITS WILL BE ',
     1             'COMPUTED.')
            CALL DPWRST('XXX','WRIT')
            NPERC=0
          ENDIF
 1145   CONTINUE
      ENDIF
C
      DO1155I=1,N
        IF(Y(I).LE.0.0)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,1111)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,1151)I
 1151     FORMAT('      ROW ',I8,' OF THE RESPONSE VARIABLE IS ',
     1           'NON-POSITIVE.')

          WRITE(ICOUT,1153)Y(I)
 1153     FORMAT('      THE VALUE OF RESPONSE VARIABLE = ',G15.7)

          CALL DPWRST('XXX','WRIT')
          IERROR='YES'
          GOTO9000
        ENDIF
 1155 CONTINUE
C
 1290 CONTINUE
C
C               *************************************
C               **  STEP 31--                      **
C               **  CARRY OUT CALCULATIONS         **
C               **  FOR BETA MOMENT/MLE ESTIMATION **
C               *************************************
C
 3100 CONTINUE
C
      ISTEPN='41'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLLB')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IERROR='NO'
      IWRITE='OFF'
C
      CALL SORT(Y,N,Y)
      CALL MINIM(Y,N,IWRITE,ZMIN,IBUGA3,IERROR)
      CALL MAXIM(Y,N,IWRITE,ZMAX,IBUGA3,IERROR)
      CALL MEAN(Y,N,IWRITE,ZMEAN,IBUGA3,IERROR)
      CALL VAR(Y,N,IWRITE,ZVAR,IBUGA3,IERROR)
      ZSD=SQRT(ZVAR)
C
CCCCC ALLOW FOR USER SPECIFIED LOWER AND UPPER LIMITS AND
CCCCC STARTING VALUES.  NOTE THAT CUSER AND DUSER DENOTE
CCCCC FIXED LIMITS WHILE CSV AND DSV DENOTE STARTING VALUES.
CCCCC IF USER DOES NOT SPECIFY THE LIMITS, THEN DETERMINE
CCCCC ESTIMATES IN THE FOLLOWING WAY:
CCCCC
CCCCC   1) USE MIN AND MAX AS INITIAL ESTIMATE IF NO
CCCCC      STARTING VALUES SPECIFIED.
CCCCC
CCCCC   2) USE THESE INITIAL ESTIMATES TO OBTAIN THE
CCCCC      METHOD OF MOMENT ESTIMATES OF ALPHA AND
CCCCC      BETA.
CCCCC
CCCCC   3) USE THE 4-PARAMETER BETA METHOD OF MOMENTS
CCCCC      TO GENERATE REFINED ESTIMATES OF LOWER AND
CCCCC      UPPER LIMITS.
CCCCC
CCCCC   USE THE METHOD OF MOMENT ESTIMATES AS STARTING
CCCCC   VALUES FOR MAXIMUM LIKELIHOOD METHOD.
C
      IF((CUSER.NE.CPUMIN .AND. DUSER.NE.CPUMIN) .AND.
     1   (CUSER.LT.ZMIN .AND. DUSER.GT.ZMAX))THEN
        C=CUSER
        D=DUSER
        IFIX=1
      ELSEIF((CSV.NE.CPUMIN .AND. DSV.NE.CPUMIN) .AND.
     1   (CSV.LT.ZMIN .AND. DSV.GT.ZMAX))THEN
        C=CSV
        D=DSV
        IFIX=0
      ELSE
        AINC=(ZMAX-ZMIN)*0.001
        C=ZMIN - AINC
        D=ZMAX + AINC
        IF(C.LE.0.0)C=0.1E-12
        IFIX=0
      ENDIF
      CINIT=C
      DINIT=D
C
      DO2801I=1,N
        YLOG(I)=(LOG(Y(I)) - LOG(C))/(LOG(D) - LOG(C))
 2801 CONTINUE
      CALL MINIM(YLOG,N,IWRITE,XMIN,IBUGA3,IERROR)
      CALL MAXIM(YLOG,N,IWRITE,XMAX,IBUGA3,IERROR)
C
      DN=DBLE(N)
      DSUM1=0.0D0
      DSUM2=0.0D0
      DSUM3=0.0D0
      DSUM4=0.0D0
      DO2810I=1,N
        DSUM1=DSUM1 + DBLE(YLOG(I))
        DSUM2=DSUM2 + DBLE(YLOG(I))**2
        DSUM3=DSUM3 + DBLE(YLOG(I))**3
        DSUM4=DSUM4 + DBLE(YLOG(I))**4
 2810 CONTINUE
      DM1=DSUM1/DN
      DM2=DSUM2/DN
      DM3=DSUM3/DN
      DM4=DSUM4/DN
      DM1P=DM1
      DM2P=DM2 - DM1**2
      DM3P=DM3 - 3.0D0*DM1*DM2 + 2.0D0*(DM1**3)
      DM4P=DM4 - 4.0D0*DM1*DM3 + 6.0D0*(DM1**2)*DM2 - 3.0D0*(DM1**4)
C
C     CHECK IF STARTING VALUES FOR ALPHA/BETA SPECIFIED
C
      IF(ALPHSV.GT.0.0 .AND. BETASV.GT.0.0)THEN
        XPAR(1)=DBLE(ALPHSV)
        XPAR(2)=DBLE(BETASV)
      ELSE
        XPAR(1)=1.0D0
        XPAR(2)=1.0D0
      ENDIF
C
      IOPT=2
      TOL=1.0D-6
      NVAR=2
      NPRINT=-1
      INFO=0
      LWA=MAXNXT
      CALL DNSQE(BE4FUN,JAC,IOPT,NVAR,XPAR,FVEC,TOL,NPRINT,INFO,
     1           DTEMP1,MAXNXT,YLOG,N)
C
      IF(INFO.EQ.2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1111)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2811)
 2811   FORMAT('      TOO MANY ITERATIONS WHEN COMPUTING THE ',
     1         'MOMENT ESTIMATES FOR ALPHA AND BETA.')
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ELSEIF(INFO.EQ.4)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1111)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2813)
 2813   FORMAT('      MOMENT ESTIMATES FOR ALPHA AND BETA NOT ',
     1         'MAKING GOOD PROGRESS.')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      ALPHMO=REAL(XPAR(1))
      BETAMO=REAL(XPAR(2))
C
C     NOW FINE-TUNE ESTIMATES OF C AND D (UNLESS A
C     FIXED LIMIT SPECIFIED)
C
      IF(IFIX.EQ.0)THEN
        EPS=(D-C)*0.001
        DA=DBLE(ALPHMO)
        DB=DBLE(BETAMO)
        DTERM1=DA*(DA+DB+1.0D0)
        DTERM2=DB
        AMOM=DM1 - DSQRT(DM2P)*DSQRT(DTERM1/DTERM2)
        DTERM1=DB*(DA+DB+1.0D0)
        DTERM2=DA
        BMOM=DM1 + DSQRT(DM2P)*DSQRT(DTERM1/DTERM2)
        IF(AMOM.GE.XMIN)AMOM=XMIN - EPS
        IF(BMOM.LE.XMAX)BMOM=XMAX + EPS
        C=EXP(AMOM)
        D=EXP(BMOM)
        EPS=(D-C)*0.01
        IF(C.GE.ZMIN)C=ZMIN - EPS
        IF(D.LE.ZMAX)D=ZMAX + EPS
        CMOM=C
        DMOM=D
      ELSE
        CMOM=C
        DMOM=D
      ENDIF
C
      DO3010I=1,N
        YLOG(I)=(LOG(Y(I)) - LOG(C))/(LOG(D) - LOG(C))
 3010 CONTINUE
C
      CALL MINIM(YLOG,N,IWRITE,XMIN,IBUGA3,IERROR)
      CALL MAXIM(YLOG,N,IWRITE,XMAX,IBUGA3,IERROR)
      CALL MEAN(YLOG,N,IWRITE,XMEAN,IBUGA3,IERROR)
      CALL VAR(YLOG,N,IWRITE,XVAR,IBUGA3,IERROR)
      XSD=SQRT(XVAR)
C
      A=0.0
      B=1.0
      BETALL=A
      BETAUL=B
C
      XMEAN1=(XMEAN-A)/(B-A)
      VAR1=XVAR/((B-A)**2)
      ALPHA1=XMEAN1*(XMEAN1*(1.0-XMEAN1)/VAR1 - 1.0)
      BETA1=(1.0-XMEAN1)*(XMEAN1*(1.0-XMEAN1)/VAR1 - 1.0)
C
      XPAR(1)=DBLE(ALPHA1)
      XPAR(2)=DBLE(BETA1)
      DPROD1=1.0D0
      DPROD2=1.0D0
      DN=DBLE(N)
C
      DO3101I=1,N
        DTERM1=DBLE((B-YLOG(I))/(B-A))**(1.0D0/DN)
        DTERM2=DBLE( (YLOG(I)-A)/(B-A))**(1.0D0/DN)
        IF(DTERM1.NE.0.0D0)DPROD1=DPROD1*DTERM1
        IF(DTERM2.NE.0.0D0)DPROD2=DPROD2*DTERM2
 3101 CONTINUE
      XPAR(1)=0.5D0*(1.0D0 - DPROD1)/(1.0D0 - DPROD2 - DPROD1)
      DO3103I=1,N
        DTERM1=DBLE((YLOG(I)-A)/(B-A))**(1.0D0/DN)
        DTERM2=DBLE( (B-YLOG(I))/(B-A))**(1.0D0/DN)
        IF(DTERM1.NE.0.0D0)DPROD1=DPROD1*DTERM1
        IF(DTERM2.NE.0.0D0)DPROD2=DPROD2*DTERM2
 3103 CONTINUE
      XPAR(2)=0.5D0*(1.0D0 - DPROD1)/(1.0D0 - DPROD1 - DPROD2)
C
      IOPT=2
      TOL=1.0D-6
      NVAR=2
      NPRINT=-1
      INFO=0
      LWA=MAXNXT
      CALL DNSQE(BETFUN,JAC,IOPT,NVAR,XPAR,FVEC,TOL,NPRINT,INFO,
     1           DTEMP1,MAXNXT,YLOG,N)
C
      IF(INFO.EQ.2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1111)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,3111)
 3111   FORMAT('      TOO MANY ITERATIONS WHEN COMPUTING THE ',
     1         'ML ESTIMATES FOR ALPHA AND BETA.')
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ELSEIF(INFO.EQ.4)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1111)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,3113)
 3113   FORMAT('      ML ESTIMATES FOR ALPHA AND BETA NOT ',
     1         'MAKING GOOD PROGRESS.')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      ALPHA2=REAL(XPAR(1))
      BETA2=REAL(XPAR(2))
C
CCCCC CONFIDENCE INTERVALS FOR SHAPE PARAMETERS
C
      DN=DBLE(N)
      DALPHA=DBLE(ALPHA2)
      DBETA=DBLE(BETA2)
      DALPBE=DBLE(ALPHA2 + BETA2)
C
      KODE=1
      NTEMP=1
      M=1
      NZ=0
C
      CALL DPSIFN(DALPHA,NTEMP,KODE,M,DANS,NZ,IERR)
      DA=DANS(1)
      IF(IERR.EQ.1)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,3201)
 3201   FORMAT('***** ERROR FROM LOG BETA MAXIMUM LIKELIHOOD--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,3203)
 3203   FORMAT('      UNABLE TO COMPUTE TRIGAMMA FUNCTION.')
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ELSEIF(IERR.EQ.2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,3201)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,3205)
 3205   FORMAT('      OVERFLOW IN COMPUTING THE TRIGAMMA FUNCTION.')
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ELSEIF(IERR.EQ.3)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,3201)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,3207)
 3207   FORMAT('      OVERFLOW IN COMPUTING THE TRIGAMMA FUNCTION.')
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      CALL DPSIFN(DBETA,NTEMP,KODE,M,DANS,NZ,IERR)
      DB=DANS(1)
      IF(IERR.EQ.1)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,3201)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,3203)
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ELSEIF(IERR.EQ.2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,3201)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,3205)
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ELSEIF(IERR.EQ.3)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,3201)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,3207)
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      CALL DPSIFN(DALPBE,NTEMP,KODE,M,DANS,NZ,IERR)
      DC=DANS(1)
      IF(IERR.EQ.1)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,3201)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,3203)
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ELSEIF(IERR.EQ.2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,3201)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,3205)
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ELSEIF(IERR.EQ.3)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,3201)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,3207)
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      DTERM1=1.0D0/(DN*(DA*DB - DC*(DA+DB)))
      DTERM2=DTERM1*(DB-DC)
      ALPHSE=REAL(DSQRT(DTERM2))
      DTERM2=DTERM1*(DA-DC)
      BETASE=REAL(DSQRT(DTERM2))
      DTERM2=DTERM1*DC
      COVSE=REAL(DSQRT(DTERM2))
C
      DO3310I=1,NUMALP
        ALP=ALPHA(I)
        P=1.0-(ALP/2.0)
        CALL NORPPF(P,PPF)
        ALOWAL(I)=ALPHA2 - PPF*ALPHSE
        AUPPAL(I)=ALPHA2 + PPF*ALPHSE
        ALOWBE(I)=BETA2 - PPF*BETASE
        AUPPBE(I)=BETA2 + PPF*BETASE
 3310 CONTINUE
C
      N2=N
      DA=DBLE(A)
      DB=DBLE(B)
      DALPH2=DBLE(ALPHA2)
      DALPH3=DBLE(ALPHA2)
      DBETA2=DBLE(BETA2)
      DBETA3=DBLE(BETA2)
      DSUM3=0.0D0
      DSUM4=0.0D0
      DO3320I=1,N
        DTEMP1(I)=DBLE(YLOG(I))
        DSUM3=DSUM3 + DLOG(DBLE(YLOG(I)) - DA)
        DSUM4=DSUM4 + DLOG(DB - DBLE(YLOG(I)))
 3320 CONTINUE
      DSUM3=DSUM3/(DN*(DB - DA))
      DSUM4=DSUM4/(DN*(DB - DA))
C
      DTERM1=-DN*DLBETA(DALPH2,DBETA2)
      DTERM2=DN*(DALPH2-1.0D0)*DSUM3
      DTERM3=DN*(DBETA2-1.0D0)*DSUM4
      DLLAB=DTERM1 + DTERM2 + DTERM3
C
      DAE=1.D-7
      DRE=1.D-7
      NUTEMP=1
C
      DO3410I=1,NUMALP
        ALP=ALPHA(I)
        CALL CHSPPF(1.0-ALP,NUTEMP,APPF)
        DK=DBLE(APPF)
C
        DXSTRT=DBLE(ALOWAL(I))
        DXLOW=DXSTRT/5.0D0
        DXUP=DBLE(ALPHA2)
        CALL DFZER2(BETFU2,DXLOW,DXUP,DXSTRT,DRE,DAE,IFLAG,DTEMP1)
        ALOWA2(I)=REAL(DXLOW)
C
        DXSTRT=DBLE(AUPPAL(I))
        DXUP=DXSTRT*5.0D0
        DXLOW=DBLE(ALPHA2)
        CALL DFZER2(BETFU2,DXLOW,DXUP,DXSTRT,DRE,DAE,IFLAG,DTEMP1)
        AUPPA2(I)=REAL(DXLOW)
C
        DXSTRT=DBLE(ALOWBE(I))
        DXLOW=DXSTRT/5.0D0
        DXUP=DBLE(BETA2)
        CALL DFZER2(BETFU5,DXLOW,DXUP,DXSTRT,DRE,DAE,IFLAG,DTEMP1)
        ALOWB2(I)=REAL(DXLOW)
C
        DXSTRT=DBLE(AUPPBE(I))
        DXUP=DXSTRT*5.0D0
        DXLOW=DBLE(BETA2)
        CALL DFZER2(BETFU5,DXLOW,DXUP,DXSTRT,DRE,DAE,IFLAG,DTEMP1)
        AUPPB2(I)=REAL(DXLOW)
C
 3410 CONTINUE
C
C  CONFIDENCE INTERVALS FOR SELECTED PERCENTILES.
C
C  1. STANDARD ERROR USES TECHNIQUE DEMONSTRATED IN EXAMPLE 14.3
C     (PP. 256-257) OF BURY.  THIS IS BASED ON PROPOGATION OF ERROR.
C 
C  2. CONFIDENCE INTERVAL IS THEN GENERATED USING NORMAL
C     APPROXIMATION (EXAMPLE 14.3 OF BURY).
C
      IF(NPERC.GE.1)THEN
C
        ALPHL=ALPHAP/2.0
        ALPHU=1.0 - ALPHAP/2.0
        CALL NORPPF(ALPHU,Z95)
C
        ALPHA3=ALPHA2
        BETA3=BETA2
        IORD=1
        EPS=0.001
        ACCUR=0.0
C
        WRITE(IOUNI1,3531)
        WRITE(IOUNI1,3532)
        DO3529I=1,NPERC
          QPTEMP=QP(I)/100.0
          CALL BETPPF(QPTEMP,ALPHA2,BETA2,APPF)
          XQPHAT(I)=APPF
C
          P7=QPTEMP
          P8=QPTEMP
C
          IFAIL=0
C
          ALPHAT = ALPHA2
          ALPHMN = 0.0001
          ALPHMX = ALPHA2 + 10.0
          CALL DIFF(IORD,ALPHAT,ALPHMN,ALPHMX,BETFU7,EPS,ACCUR,
     1              D1,ERROR,IFAIL)
C
          IF(IFAIL.EQ.1)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3501)
 3501       FORMAT('***** WARNING IN NUMERICAL DERIVATIVE FOR BETA ',
     1             'MAXIMUM LIKELIHOOD PERCENTILES.')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3503)
 3503       FORMAT('      THE ESTIMATED ERROR IN THE RESULT ',
     1             'EXCEEDS THE')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3505)
 3505       FORMAT('      REQUESTED ERROR, BUT THE MOST ACCURATE ',
     1             'RESULT')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3507)
 3507       FORMAT('      POSSIBLE HAS BEEN RETURNED.')
            CALL DPWRST('XXX','BUG ')
          ELSEIF(IFAIL.EQ.2)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3511)
 3511       FORMAT('***** ERROR IN NUMERICAL DERIVATIVE FOR BETA ',
     1             'MAXIMUM LIKELIHOOD PERCENTILES.')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3513)
 3513       FORMAT('      ERROR IN THE INPUT TO THE DIFF ROUTINE.')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3515)
 3515       FORMAT('      NO PERCENTILES WILL BE GENERATED.')
            CALL DPWRST('XXX','BUG ')
            NPERC=0
          ELSEIF(IFAIL.EQ.3)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3511)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3523)
 3523       FORMAT('      THE INTERVAL FOR DIFFERENTIATION, (',G15.7,
     1             ',',G15.7,')')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3525)
 3525       FORMAT('      IS TOO SMALL.')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3515)
            CALL DPWRST('XXX','BUG ')
            D1=0.0
            NPERC=0
          ENDIF
C
          BETAT = BETA2
          BETAMN = 0.0001
          BETAMX = BETA2 + 10.0
          CALL DIFF(IORD,BETAT,BETAMN,BETAMX,BETFU8,EPS,ACCUR,
     1              D2,ERROR,IFAIL)
C
          IF(IFAIL.EQ.1)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3501)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3503)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3505)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3507)
            CALL DPWRST('XXX','BUG ')
          ELSEIF(IFAIL.EQ.2)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3511)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3513)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3515)
            CALL DPWRST('XXX','BUG ')
            NPERC=0
          ELSEIF(IFAIL.EQ.3)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3511)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3523)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3525)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,3515)
            CALL DPWRST('XXX','BUG ')
            D2=0.0
            NPERC=0
          ENDIF
          V11=ALPHSE**2
          V22=BETASE**2
          V21=COVSE
          V12=V21
          TERM11=(D1*ALPHSE)**2
          TERM22=(D2*BETASE)**2
          TERM12=2.0*D2*D1*COVSE**2
          SEXQP=TERM11+TERM12+TERM22
          IF(SEXQP.GE.0.0)THEN
            SEXQP=SQRT(SEXQP)
          ELSE
            SEXQP=0.0
          ENDIF
          XQPSE(I)=SEXQP
          XQPLCL(I)=XQPHAT(I) - Z95*SEXQP
          XQPUCL(I)=XQPHAT(I) + Z95*SEXQP
C
C
          WRITE(IOUNI1,'(5E15.7)')
     1         QP(I),XQPHAT(I),XQPSE(I),XQPLCL(I),XQPUCL(I)
 3529   CONTINUE
 3531   FORMAT(15X,'       POINT     ','   STANDARD   ',
     1         '     LOWER     ',
     1         '     UPPER')
 3532   FORMAT('    PERCENTILE ','     ESTIMATE   ',
     1         '     ERRROR     ',
     1         'CONFIDENCE LIMIT ','CONFIDENCE LIMIT')
      ENDIF
C
C               *************************************
C               **   STEP 42--                     **
C               **   WRITE OUT EVERYTHING          **
C               **   FOR LOG BETA MLE ESTIMATION   **
C               *************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLLB')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     PRINT SUMMARY STATISTICS TABLE
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Log Beta Parameter Estimation:'
      NCTITL=30
      ITITLZ='Full Sample Case'
      NCTITZ=16
      ITEXT(1)='Summary Statistics:'
      NCTEXT(1)=19
      AVALUE(1)=0.0
      IDIGIT(1)=0
      ITEXT(2)='Number of Observations:'
      NCTEXT(2)=23
      AVALUE(2)=REAL(N)
      IDIGIT(2)=0
      ITEXT(3)='Sample Minimum:'
      NCTEXT(3)=15
      AVALUE(3)=ZMIN
      IDIGIT(3)=NUMDIG
      ITEXT(4)='Sample Maximum:'
      NCTEXT(4)=15
      AVALUE(4)=ZMAX
      IDIGIT(4)=NUMDIG
      ITEXT(5)='Sample Mean:'
      NCTEXT(5)=12
      AVALUE(5)=ZMEAN
      IDIGIT(5)=NUMDIG
      ITEXT(6)='Sample Standard Deviation:'
      NCTEXT(6)=26
      AVALUE(6)=ZSD
      IDIGIT(6)=NUMDIG
      ITEXT(7)='Initial Value Used for Lower Limit:'
      NCTEXT(7)=35
      AVALUE(7)=CINIT
      IDIGIT(7)=NUMDIG
      ITEXT(8)='Initial Value Used for Upper Limit:'
      NCTEXT(8)=35
      AVALUE(8)=DINIT
      IDIGIT(8)=NUMDIG
      ITEXT(9)=' '
      NCTEXT(9)=1
      AVALUE(9)=0.0
      IDIGIT(9)=-1
C
      ITEXT(10)='Method of Moment Estimates:'
      NCTEXT(10)=27
      AVALUE(10)=0.0
      IDIGIT(10)=0
C
      ICNT=6
      IF(AUSER.NE.CPUMIN)THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='User Specified Lower Limit:'
        NCTEXT(ICNT)=27
        AVALUE(ICNT)=AUSER
        IDIGIT(ICNT)=NUMDIG
      ENDIF
      IF(BUSER.NE.CPUMIN)THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='User Specified Upper Limit:'
        NCTEXT(ICNT)=27
        AVALUE(ICNT)=BUSER
        IDIGIT(ICNT)=NUMDIG
      ENDIF
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Moments:'
      NCTEXT(ICNT)=8
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Alpha:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=ALPHMO
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Beta:'
      NCTEXT(ICNT)=17
      AVALUE(ICNT)=BETAMO
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Maximum Likelihood:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Alpha:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=ALPHML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Standard Error of Alpha:'
      NCTEXT(ICNT)=24
      AVALUE(ICNT)=ALPHSE
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Beta:'
      NCTEXT(ICNT)=17
      AVALUE(ICNT)=BETAML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Standard Error of Beta:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=BETASE
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Covariance:'
      NCTEXT(ICNT)=11
      AVALUE(ICNT)=COVSE
      IDIGIT(ICNT)=NUMDIG
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='Log-likelihood:'
CCCCC NCTEXT(ICNT)=15
CCCCC AVALUE(ICNT)=ALIKE
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=AIC
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AICc:'
CCCCC NCTEXT(ICNT)=5
CCCCC AVALUE(ICNT)=AICC
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='BIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=BIC
CCCCC IDIGIT(ICNT)=-7
C
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
C
      NUMROW=ICNT
      DO2320I=1,NUMROW
        NTOT(I)=15
 2320 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
      ILIKFL='ON'
      ILOCFL='OFF'
      ISCAFL='OFF'
      ISHAP1='Alpha'
      NCSHA1=5
      ISHAP2='Beta'
      NCSHA2=4
      CALL DPDT8A(ALOWLO,AUPPLO,ALOWSC,AUPPSC,
     1            ALOWAL,AUPPAL,ALOWA2,AUPPA2,
     1            ALOWBE,AUPPBE,ALOWB2,AUPPB2,
     1            ALPHA,NUMALP,
     1            ICAPSW,ICAPTY,NUMDIG,
     1            ILOCFL,ISCAFL,ILIKFL,
     1            ISHAP1,NCSHA1,ISHAP2,NCSHA2,
     1            ISUBRO,IBUGA3,IERROR)
C
      IF(NPERC.GT.1)THEN
        ILIKFL='OFF'
        CALL DPDTA9(QP,XQPHAT,XQPLCL,XQPUCL,XQPSE,NPERC,
     1              ICAPSW,ICAPTY,ILIKFL,NUMDIG,ALPHAP,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
C
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLLB')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLLB--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012   FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9015)N
 9015   FORMAT('N = ',I8)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLLO(Y,N,
     1                  XTEMP,DTEMP1,MAXNXT,
     1                  ALOC,ASCALE,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR LOGISTIC DISTRIBUTION
C     EXAMPLE--LOGISTIC MAXIMUM LIKELIHOOD Y
C     REFERENCE--CHARLES ANTLE, LAWRENCE KLIMKO, AND WILLIAM
C                HARKNESS, (1970), "CONFIDENCE INTERVALS FOR THE
C                PARAMETERS OF THE LOGISTIC DISTRIBUTION", BIOMETRIKA,
C                PP. 397-402.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2003/10
C     ORIGINAL VERSION--OCTOBER   2003.
C     UPDATED         --JANUARY   2005. MODIFY THE OUTPUT FORMAT
C                                       TO MAKE MORE CONSISTENT
C                                       WITH OTHER DISTRIBUTIONS
C     UPDATED         --OCTOBER   2009. EXTRACT ML ESTIMATION TO
C                                       LOGML1 ROUTINE
C     UPDATED         --OCTOBER   2009. CALL LOGLI1 ROUTINE TO
C                                       COMPUTE VALUE OF LIKELIHOOD
C     UPDATED         --JUNE      2010. CALL DPDTA1 AND DPDTA7 TO PRINT
C                                       OUTPUT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
      CHARACTER*4 IWRITE
      CHARACTER*4 INORM
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION XTEMP(*)
      DOUBLE PRECISION DTEMP1(*)
C
      DIMENSION QP(1)
      DIMENSION ATABLE(6,5)
      DIMENSION BTABLE(5,10)
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (NUMALP=2)
      REAL ALPHA(NUMALP)
      REAL ALOWLO(NUMALP)
      REAL AUPPLO(NUMALP)
      REAL ALOWSC(NUMALP)
      REAL AUPPSC(NUMALP)
C
      PARAMETER (MAXROW=50)
      CHARACTER*60 ITITLE
      CHARACTER*1  ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(NUMALP)
      CHARACTER*4  VALIGN(NUMALP)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
C
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA PI/3.14159265358979/
C
      DATA (ATABLE(1,J),J=1,5)/6.3,12.8,25.7,32.2,64.4/
      DATA (ATABLE(2,J),J=1,5)/2.9,4.0,5.0,5.4,6.7/
      DATA (ATABLE(3,J),J=1,5)/2.50,3.29,4.07,4.30,5.06/
      DATA (ATABLE(4,J),J=1,5)/2.34,3.06,3.67,3.87,4.45/
      DATA (ATABLE(5,J),J=1,5)/2.25,2.93,3.54,3.70,4.19/
      DATA (ATABLE(6,J),J=1,5)/2.22,2.85,3.40,3.56,4.03/
C
      DATA (BTABLE(I,1),I=1,5)/0.01,0.24,0.436,0.588,0.707/
      DATA (BTABLE(I,2),I=1,5)/0.02,0.29,0.475,0.623,0.739/
      DATA (BTABLE(I,3),I=1,5)/0.024,0.304,0.492,0.640,0.749/
      DATA (BTABLE(I,4),I=1,5)/0.049,0.367,0.551,0.689,0.781/
      DATA (BTABLE(I,5),I=1,5)/0.098,0.454,0.626,0.745,0.821/
      DATA (BTABLE(I,6),I=1,5)/1.36,1.36,1.28,1.21,1.15/
      DATA (BTABLE(I,7),I=1,5)/1.66,1.53,1.45,1.29,1.21/
      DATA (BTABLE(I,8),I=1,5)/1.94,1.66,1.52,1.36,1.26/
      DATA (BTABLE(I,9),I=1,5)/2.03,1.75,1.55,1.38,1.27/
      DATA (BTABLE(I,10),I=1,5)/2.3,2.0,1.65,1.45,1.32/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='LO  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLLO')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLLO--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3
   52   FORMAT('IBUGA3 = ',A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)N
   55   FORMAT('N = ',I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,N
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,E15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLLO')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NPERC=0
      NMIN=3
      CALL CKDIST(Y,N,NMIN,QP,NPERC,ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C               ********************************
C               **  STEP 41--                 **
C               **  CARRY OUT CALCULATIONS    **
C               **  FOR LOGISTIC MLE ESTIMATE **
C               ********************************
C
 4100 CONTINUE
C
      ISTEPN='41'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLLO')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL LOGML1(Y,N,MAXNXT,
     1            DTEMP1,
     1            XMEAN,XSD,XMIN,XMAX,
     1            ALOC,ASCALE,
     1            ISUBRO,IBUGA3,IERROR)
C
      CALL LOGLI1(Y,N,ALOC,ASCALE,
     1            ALIK,AIC,AICC,BIC,
     1            ISUBRO,IBUGA3,IERROR)
C
C               ***********************************************
C               **  STEP 41B-                                **
C               **  COMPUTE 90% AND 95% CONFIDENCE INTERVALS **
C               **  USING METHOD GIVEN IN ANTLE PAPER        **
C               ***********************************************
C
      AN=REAL(N)
      IF(N.EQ.2)THEN
        A1=ATABLE(1,2)
        A2=ATABLE(1,3)
      ELSEIF(N.GE.3 .AND. N.LE.4)THEN
        AFACT=REAL(N-2)/REAL(5-2)
        A1=ATABLE(2,2) - AFACT*ABS(ATABLE(2,2)-ATABLE(1,2))
        A2=ATABLE(2,3) - AFACT*ABS(ATABLE(2,3)-ATABLE(1,3))
      ELSEIF(N.EQ.5)THEN
        A1=ATABLE(2,2)
        A2=ATABLE(2,3)
      ELSEIF(N.GE.6 .AND. N.LE.9)THEN
        AFACT=REAL(N-5)/REAL(10-5)
        A1=ATABLE(3,2) - AFACT*ABS(ATABLE(3,2)-ATABLE(2,2))
        A2=ATABLE(3,3) - AFACT*ABS(ATABLE(3,3)-ATABLE(2,3))
      ELSEIF(N.EQ.10)THEN
        A1=ATABLE(3,2)
        A2=ATABLE(3,3)
      ELSEIF(N.GE.11 .AND. N.LE.19)THEN
        AFACT=REAL(N-10)/REAL(20-10)
        A1=ATABLE(4,2) - AFACT*ABS(ATABLE(4,2)-ATABLE(3,2))
        A2=ATABLE(4,3) - AFACT*ABS(ATABLE(4,3)-ATABLE(3,3))
      ELSEIF(N.EQ.20)THEN
        A1=ATABLE(4,2)
        A2=ATABLE(4,3)
      ELSEIF(N.GE.21 .AND. N.LE.39)THEN
        AFACT=REAL(N-20)/REAL(40-20)
        A1=ATABLE(5,2) - AFACT*ABS(ATABLE(5,2)-ATABLE(4,2))
        A2=ATABLE(5,3) - AFACT*ABS(ATABLE(5,3)-ATABLE(4,3))
      ELSEIF(N.EQ.40)THEN
        A1=ATABLE(5,2)
        A2=ATABLE(5,3)
      ELSEIF(N.GT.40)THEN
        A1=ATABLE(6,2)
        A2=ATABLE(6,3)
      ENDIF
      ALOWLO(1)=ALOC - A1*ASCALE/SQRT(AN)
      AUPPLO(1)=ALOC + A1*ASCALE/SQRT(AN)
      ALOWLO(2)=ALOC - A2*ASCALE/SQRT(AN)
      AUPPLO(2)=ALOC + A2*ASCALE/SQRT(AN)
C
      IF(N.EQ.2)THEN
        B1=BTABLE(1,4)
        B2=BTABLE(1,7)
        B3=BTABLE(1,3)
        B4=BTABLE(1,8)
      ELSEIF(N.GE.3 .AND. N.LE.4)THEN
        AFACT=REAL(N-2)/REAL(5-2)
        B1=BTABLE(1,4) + AFACT*ABS(BTABLE(2,4)-BTABLE(1,4))
        B2=BTABLE(1,7) + AFACT*ABS(BTABLE(2,7)-BTABLE(1,7))
        B3=BTABLE(1,3) + AFACT*ABS(BTABLE(2,3)-BTABLE(1,3))
        B4=BTABLE(1,8) + AFACT*ABS(BTABLE(2,8)-BTABLE(1,8))
      ELSEIF(N.EQ.5)THEN
        B1=BTABLE(2,4)
        B2=BTABLE(2,7)
        B3=BTABLE(2,3)
        B4=BTABLE(2,8)
      ELSEIF(N.GE.6 .AND. N.LE.9)THEN
        AFACT=REAL(N-5)/REAL(10-5)
        B1=BTABLE(2,4) + AFACT*ABS(BTABLE(3,4)-BTABLE(2,4))
        B2=BTABLE(2,7) + AFACT*ABS(BTABLE(3,7)-BTABLE(2,7))
        B3=BTABLE(2,3) + AFACT*ABS(BTABLE(3,3)-BTABLE(2,3))
        B4=BTABLE(2,8) + AFACT*ABS(BTABLE(3,8)-BTABLE(2,8))
      ELSEIF(N.EQ.10)THEN
        B1=BTABLE(3,4)
        B2=BTABLE(3,7)
        B3=BTABLE(3,3)
        B4=BTABLE(3,8)
      ELSEIF(N.GE.11 .AND. N.LE.19)THEN
        AFACT=REAL(N-10)/REAL(20-10)
        B1=BTABLE(3,4) + AFACT*ABS(BTABLE(4,4)-BTABLE(3,4))
        B2=BTABLE(3,7) + AFACT*ABS(BTABLE(4,7)-BTABLE(3,7))
        B3=BTABLE(3,3) + AFACT*ABS(BTABLE(4,3)-BTABLE(3,3))
        B4=BTABLE(3,8) + AFACT*ABS(BTABLE(4,8)-BTABLE(3,8))
      ELSEIF(N.EQ.20)THEN
        B1=BTABLE(4,4)
        B2=BTABLE(4,7)
        B3=BTABLE(4,3)
        B4=BTABLE(4,8)
      ELSEIF(N.GE.21 .AND. N.LE.39)THEN
        AFACT=REAL(N-20)/REAL(40-20)
        B1=BTABLE(4,4) + AFACT*ABS(BTABLE(5,4)-BTABLE(4,4))
        B2=BTABLE(4,7) + AFACT*ABS(BTABLE(5,7)-BTABLE(4,7))
        B3=BTABLE(4,3) + AFACT*ABS(BTABLE(5,3)-BTABLE(4,3))
        B4=BTABLE(4,8) + AFACT*ABS(BTABLE(5,8)-BTABLE(4,8))
      ELSEIF(N.GE.40)THEN
        B1=BTABLE(5,4)
        B2=BTABLE(5,7)
        B3=BTABLE(5,3)
        B4=BTABLE(5,8)
      ENDIF
      ALOWSC(1)=ASCALE/B2
      AUPPSC(1)=ASCALE/B1
      ALOWSC(2)=ASCALE/B4
      AUPPSC(2)=ASCALE/B3
C
C               **********************************
C               **   STEP 42--                  **
C               **   WRITE OUT EVERYTHING       **
C               **   FOR LOGISTIC MLE ESTIMATE  **
C               **********************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLLO')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Logisitic Parameter Estimation'
      NCTITL=30
      ITEXT(1)='Summary Statistics:'
      NCTEXT(1)=19
      AVALUE(1)=0.0
      IDIGIT(1)=-1
      ITEXT(2)='Number of Observations:'
      NCTEXT(2)=23
      AVALUE(2)=REAL(N)
      IDIGIT(2)=0
      ICNT=3
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Maximum Likelihood Estimation Method:'
      NCTEXT(ICNT)=37
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Location Parameter:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=ALOC
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Scale Parameter:'
      NCTEXT(ICNT)=16
      AVALUE(ICNT)=ASCALE
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Log-likelihood:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=ALIK
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)='AIC:'
      NCTEXT(ICNT)=4
      AVALUE(ICNT)=AIC
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)='AICc:'
      NCTEXT(ICNT)=5
      AVALUE(ICNT)=AICC
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)='BIC:'
      NCTEXT(ICNT)=4
      AVALUE(ICNT)=BIC
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      NUMROW=ICNT
      DO2310I=1,NUMROW
        NTOT(I)=15
 2310 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.FALSE.
      NCTITZ=0
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,
     1            NCTEXT,AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
      IFRST=.FALSE.
      ITITLE=' '
      NCTITL=0
C
      ALPHA(1)=0.10
      ALPHA(2)=0.05
      INORM='YES'
      CALL DPDTA7(ALOWLO,AUPPLO,ALOWSC,AUPPSC,ALPHA,NUMALP,
     1            ICAPSW,ICAPTY,NUMDIG,INORM,
     1            ISUBRO,IBUGA3,IERROR)
C
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLLO')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLLO--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012   FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLL1(Y,N,MAXNXT,XTEMP,
     1                  SHAPML,SHAPSE,SCALML,SCALSE,UHATML,UHATSE,
     1                  NUMV,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  QP,XQPHAT,XQPLCL,XQPUCL,XQPSE,NPERC,
     1                  IOUNI1,IOUNI2,ALPHAP,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR LOGNORMAL DISTRIBUTION
C              FOR THE FULL SAMPLE CASE.
C     EXAMPLE--LOGNORMAL MAXIMUM LIKELIHOOD Y
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN
C                ENGINEERING", CAMBRIDGE UNIVERSITY PRESS,
C                1999, CHAPTER 13.
C              --"STATISTICAL DISTRIBUTIONS", THIRD EDITION,
C                EVANS, HASTINGS, AND PEACOCK, WILEY, 2001.
C              --"METHODS FOR STATISTICAL ANALYSIS OF RELIABILITY
C                AND LIFE DATA", MANN, SCHAFER, AND SINGPURWALLA,
C                WILEY, 1974, PP. 264-268.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004/11
C     ORIGINAL VERSION--NOVEMBER  2004. NOTE: THIS REPLACES AN
C                                       EARLIER IMPLEMENTATION.
C     UPDATED         --APRIL     2010. PUT POINT ESTIMATES IN A
C                                       SEPARATE ROUTINE TO MAKE IT
C                                       EASIER TO CALL FROM OTHER
C                                       ROUTINES (BOOTSTRAP, GOODNESS
C                                       OF FIT)
C     UPDATED         --APRIL     2010. USE DPDTA1, DPDTA8, DPDTA9
C                                       ROUTINES TO PRINT OUTPUT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ILIKFL
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      PARAMETER (NUMALP=6)
      DIMENSION ALPHA(NUMALP)
      DIMENSION ALOWSC(NUMALP)
      DIMENSION AUPPSC(NUMALP)
      DIMENSION ALOWUH(NUMALP)
      DIMENSION AUPPUH(NUMALP)
      DIMENSION ALOWSH(NUMALP)
      DIMENSION AUPPSH(NUMALP)
      DIMENSION ALOWS2(NUMALP)
      DIMENSION AUPPS2(NUMALP)
C
      DIMENSION Y(*)
      DIMENSION XTEMP(*)
      DIMENSION QP(*)
      DIMENSION XQPHAT(*)
      DIMENSION XQPSE(*)
      DIMENSION XQPLCL(*)
      DIMENSION XQPUCL(*)
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=30)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 ITEXT(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA ALPHA /0.50, 0.25, 0.10, 0.05, 0.01, 0.001/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='L1  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLL1')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLL1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)N,NUMV,IBUGA3
   55   FORMAT('N,NUMV,NPERC,IBUGA3 = ',3I8,2X,A4)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLL1')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NMIN=3
      CALL CKDIST(Y,N,NMIN,QP,NPERC,ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C               **********************************
C               **  STEP 41--                   **
C               **  CARRY OUT CALCULATIONS      **
C               **  FOR LOGNORMAL MLE           **
C               **  ESTIMATE (FULL SAMPLE CASE) **
C               **********************************
C
      CALL LGNML1(Y,N,MAXNXT,
     1            XTEMP,
     1            XMEAN,XMED,XSD,XVAR,XMIN,XMAX,XMEANL,XSDL,
     1            SCALML,SCALSE,SHAPML,SHAPSE,UHATML,UHATSE,
     1            ISUBRO,IBUGA3,IERROR)
C
C     CONFIDENCE INTERVALS FOR PARAMETERS.  NOTE THAT FOR THE
C     FULL SAMPLE CASE, THE SAMPLING DISTRIBUTIONS ARE EXACT.
C
      IDF=N-1
      ADF=REAL(N-1)
      DO4110I=1,NUMALP
        ALP=ALPHA(I)
        P1=ALP/2.0
        P2=1.0-(ALP/2.0)
        CALL TPPF(P1,REAL(IDF),TLOW)
        CALL TPPF(P2,REAL(IDF),TUPP)
        ALOWUH(I)=UHATML + TLOW*UHATSE
        AUPPUH(I)=UHATML + TUPP*UHATSE
        ALOWSC(I)=SCALML + TLOW*SCALSE
        AUPPSC(I)=SCALML + TUPP*SCALSE
        CALL CHSPPF(P1,IDF,CSLOW)
        CALL CHSPPF(P2,IDF,CSUPP)
        ALOWSH(I)=SHAPML*SQRT(ADF/CSUPP)
        AUPPSH(I)=SHAPML*SQRT(ADF/CSLOW)
 4110 CONTINUE
C
C     CONFIDENCE INTERVALS FOR SELECTED PERCENTILES.
C
C     FULL SAMPLE CASE BASED ON NON-CENTRAL T
C
      IF(NPERC.GE.1)THEN
C
        C1=SIGMA/SQRT(AN)
        ANU=REAL(N-1)
        ALPHL=ALPHAP/2.0
        ALPHU=1.0 - ALPHAP/2.0
C
        WRITE(IOUNI1,4191)
 4191   FORMAT(15X,'       POINT     ','     LOWER     ',
     1         '     UPPER')
        WRITE(IOUNI1,4192)
 4192   FORMAT('    PERCENTILE ','     ESTIMATE   ',
     1         'CONFIDENCE LIMIT ','CONFIDENCE LIMIT')
        DO4190I=1,NPERC
          QPTEMP=QP(I)/100.0
C
          CALL NORPPF(QPTEMP,APPF)
          DELTA=APPF*SQRT(AN)
C
          CALL LGNPPF(QPTEMP,SHAPML,ATEMP)
          XQPHAT(I)=SCALML*ATEMP
C
          IF(DELTA.LT.0.0)THEN
            DELTA2=-DELTA
            CALL NCTPPF(ALPHU,ANU,DELTA2,C2)
            C2=-C2
            CALL NCTPPF(ALPHL,ANU,DELTA2,C3)
            C3=-C3
          ELSE
            CALL NCTPPF(ALPHL,ANU,DELTA,C2)
            CALL NCTPPF(ALPHU,ANU,DELTA,C3)
          ENDIF
          ATEMP1=EXP(UHATML + C1*C2)
          ATEMP2=EXP(UHATML + C1*C3)
          XQPLCL(I)=MIN(ATEMP1,ATEMP2)
          XQPUCL(I)=MAX(ATEMP1,ATEMP2)
          WRITE(IOUNI1,'(3E15.7,2X,E15.7)')
     1         QP(I),XQPHAT(I),XQPLCL(I),XQPUCL(I)
C
          IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLL1')THEN
            WRITE(ICOUT,4193)XMEAN,XSD,ANU,ALPHA
 4193       FORMAT('XMEAN,XSD,ANU,ALPHA = ',4G15.7)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,4195)DELTA,C1,C2,C3
 4195       FORMAT('DELTA,C1,C2,C3 = ',4G15.7)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,4197)ATEMP1,ATEMP2
 4197       FORMAT('ATEMP1,ATEMP2 = ',2G15.7)
            CALL DPWRST('XXX','BUG ')
          ENDIF
C
 4190   CONTINUE
C
      ENDIF
C
C               *************************************
C               **   STEP 42--                     **
C               **   WRITE OUT EVERYTHING          **
C               **   FOR LOGNORMAL MLE ESTIMATE    **
C               *************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLL1')
     1  CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     PRINT SUMMARY STATISTICS TABLE
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Two-Parameter Lognormal Parameter Estimation:'
      NCTITL=45
      ITITLZ='Full Sample Case'
      NCTITZ=16
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(N)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Median:'
      NCTEXT(ICNT)=14
      AVALUE(ICNT)=XMED
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Maximum Likelihood:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Shape (Sigma):'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=SHAPML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Standard Error of Shape:'
      NCTEXT(ICNT)=24
      AVALUE(ICNT)=SHAPSE
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Scale:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=SCALML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Standard Error of Scale:'
      NCTEXT(ICNT)=24
      AVALUE(ICNT)=SCALSE
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of MU (= LOG(Scale)):'
      NCTEXT(ICNT)=30
      AVALUE(ICNT)=UHATML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Standard Error of MU:'
      NCTEXT(ICNT)=21
      AVALUE(ICNT)=UHATSE
      IDIGIT(ICNT)=NUMDIG
C
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='Log-likelihood:'
CCCCC NCTEXT(ICNT)=15
CCCCC AVALUE(ICNT)=ALIK
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=AIC
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AICc:'
CCCCC NCTEXT(ICNT)=5
CCCCC AVALUE(ICNT)=AICC
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='BIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=BIC
CCCCC IDIGIT(ICNT)=-7
C
      NUMROW=ICNT
      DO2320I=1,NUMROW
        NTOT(I)=15
 2320 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
      ILIKFL='LOGN'
      CALL DPDTA8(ALOWSC,AUPPSC,ALOWUH,AUPPUH,
     1            ALOWSH,AUPPSH,ALOWS2,AUPPS2,ALPHA,NUMALP,
     1            ICAPSW,ICAPTY,NUMDIG,ILIKFL,
     1            ISUBRO,IBUGA3,IERROR)
C
      IF(NPERC.GT.1)THEN
        ILIKFL='OFF'
        XQPSE(1)=CPUMIN
        CALL DPDTA9(QP,XQPHAT,XQPLCL,XQPUCL,XQPSE,NPERC,
     1              ICAPSW,ICAPTY,ILIKFL,NUMDIG,ALPHAP,
     1              ISUBRO,IBUGA3,IERROR)
      
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLL1')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLL1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)SHAPML,SCALML,UHATML
 9012   FORMAT('SHAPML,SCALML,UHATML = ',3G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9013)SHAPSE,SCALSE,UHATSE
 9013   FORMAT('SHAPSE,SCALSE,UHATSE = ',3G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLL2(Y,TAG,N,
     1                  XTEMP,TEMP1,DTEMP,ITEMP,MAXNXT,
     1                  SIGMML,SIGMSE,SCALML,SCALSE,
     1                  UHATML,UHATSE,COVSE,
     1                  NUMV,TEND,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  QP,XQPHAT,XQPLCL,XQPUCL,XQPLC2,
     1                  XQPUC2,XQPSE,NPERC,
     1                  IOUNI1,IOUNI2,ALPHAP,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR LOGNORMAL DISTRIBUTION
C              FOR THE TIME CENSORED CASE.  CURRENTLY, ONLY
C              SINGLY CENSORED DATA IS SUPPORTED (I.E., ALL
C              CENSOR TIMES ARE THE SAME).
C     EXAMPLE--LOGNORMAL MAXIMUM LIKELIHOOD Y X
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN
C                ENGINEERING", CAMBRIDGE UNIVERSITY PRESS,
C                1999, CHAPTER 11.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004/11
C     ORIGINAL VERSION--NOVEMBER  2004.
C     UPDATED         --JULY      2010. PRINT OUTPUT USING DPDTA1,
C                                       DPDTA7, DPDTA9
C     UPDATED         --JULY      2010. EXTRACT POINT ESTIMATES TO
C                                       LGNML2
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ICASE
      CHARACTER*4 IWRITE
      CHARACTER*40 IDIST
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      PARAMETER (NUMALP=6)
      DIMENSION ALPHA(NUMALP)
      DIMENSION ALOWSC(NUMALP)
      DIMENSION AUPPSC(NUMALP)
      DIMENSION ALOWS2(NUMALP)
      DIMENSION AUPPS2(NUMALP)
      DIMENSION ALOWUH(NUMALP)
      DIMENSION AUPPUH(NUMALP)
      DIMENSION ALOWU2(NUMALP)
      DIMENSION AUPPU2(NUMALP)
      DIMENSION ALOWSH(NUMALP)
      DIMENSION AUPPSH(NUMALP)
      DIMENSION ALOSH2(NUMALP)
      DIMENSION AUPSH2(NUMALP)
C
      DIMENSION Y(*)
      DIMENSION TAG(*)
      DIMENSION XTEMP(*)
      DIMENSION TEMP1(*)
      DIMENSION QP(*)
      DIMENSION XQPHAT(*)
      DIMENSION XQPSE(*)
      DIMENSION XQPLCL(*)
      DIMENSION XQPUCL(*)
      DIMENSION XQPLC2(*)
      DIMENSION XQPUC2(*)
      INTEGER ITEMP(*)
      DOUBLE PRECISION DTEMP(*)
C
      DOUBLE PRECISION LG1FUN
      DOUBLE PRECISION LG2FUN
      DOUBLE PRECISION LG4FUN
      DOUBLE PRECISION LG6FUN
      EXTERNAL LG1FUN
      EXTERNAL LG2FUN
      EXTERNAL LG4FUN
      EXTERNAL LG6FUN
C
      DOUBLE PRECISION C
      INTEGER IN
      INTEGER IM
      COMMON/LG1COM/C,IN,IM
C
      INTEGER N2
      INTEGER IR2
      INTEGER IM2
      DOUBLE PRECISION DLLUS
      DOUBLE PRECISION DC
      DOUBLE PRECISION DK
      DOUBLE PRECISION DSIGMA
      COMMON/LG2COM/DLLUS,DC,DK,DSIGMA,N2,IR2,IM2
C
      INTEGER N3
      INTEGER IR3
      INTEGER IM3
      DOUBLE PRECISION DLLUS2
      DOUBLE PRECISION DC2
      DOUBLE PRECISION DK2
      DOUBLE PRECISION DU2
      COMMON/LG4COM/DLLUS2,DC2,DK2,DU2,N3,IR3,IM3
C
      INTEGER N4
      INTEGER IR4
      INTEGER IM4
      DOUBLE PRECISION DLLUS3
      DOUBLE PRECISION DC3
      DOUBLE PRECISION DK3
      DOUBLE PRECISION DSIGMA3
      DOUBLE PRECISION DU3
      DOUBLE PRECISION DX05
      DOUBLE PRECISION DZ05
      DOUBLE PRECISION SEXQP
      COMMON/LG6COM/DLLUS3,DC3,DK3,DSIGMA3,DU3,DX05,DZ05,SEXQP,
     1N4,IR4,IM4
C
      DOUBLE PRECISION TOL
      DOUBLE PRECISION XPAR(2)
      DOUBLE PRECISION FVEC(2)
C
      DOUBLE PRECISION DXLOW
      DOUBLE PRECISION DXUP
      DOUBLE PRECISION DXSTRT
      DOUBLE PRECISION DN
      DOUBLE PRECISION DR
      DOUBLE PRECISION DM
      DOUBLE PRECISION DX
      DOUBLE PRECISION AE
      DOUBLE PRECISION RE
      DOUBLE PRECISION DS
      DOUBLE PRECISION DU
      DOUBLE PRECISION DZ
      DOUBLE PRECISION DH
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DSUM2
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM2
      DOUBLE PRECISION DTERM3
      DOUBLE PRECISION DTERM4
      DOUBLE PRECISION DSUM
      DOUBLE PRECISION DCDF
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=30)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*4  ILIKFL
      CHARACTER*40 ITEXT(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA ALPHA /0.50, 0.25, 0.10, 0.05, 0.01, 0.001/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='L2  '
      IWRITE='NO'
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLL2')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLL2--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,ICENTY,N,NUMV
   52   FORMAT('IBUGA3,ISUBRO,ICENTY,N,NUMV = ',3(A4,2X),2I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I),TAG(I)
   57     FORMAT('I,Y(I),TAG(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLL2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NMIN=3
      CALL CKDIST(Y,N,NMIN,QP,NPERC,ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      CALL LGNML2(Y,TAG,N,MAXNXT,
     1            ICASE,IDIST,
     1            TEMP1,XTEMP,DTEMP,ITEMP,
     1            XMEANF,XSDF,XVARF,XMINF,XMAXF,XMEDF,
     1            XMEANC,XSDC,XVARC,XMINC,XMAXC,XMEDC,
     1            SCALML,UHATML,UHATSE,SHAPML,SHAPSE,COVSE,
     1            IR,
     1            ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
      SIGMML=SHAPML
      SIGMSE=SHAPSE
      SCALSE=EXP(UHATML)
      AR=REAL(IR)
      DR=DBLE(IR)
      AN=REAL(N)
      DN=DBLE(N)
      AM=REAL(IM)
      DM=DBLE(IM)
      DS=DBLE(SIGMML)
      DU=DBLE(UHATML)
      DZ=(DLOG(C)-DU)/DS
C
      ISTEPN='34'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLL2')THEN
        CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
        WRITE(ICOUT,2418)SIGMML,UHATML,SCALML,DR
 2418   FORMAT('SIGML,UHATML,SCALML,IR = ',4G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2419)UHATSE,SIGMSE,COVSE
 2419   FORMAT('UHATSE,SIGMSE,COVSE = ',3G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
C     CONFIDENCE INTERVALS FOR PARAMETERS.  CAN BASE ON EITHER NORMAL
C     APPROXIMATION OR ON LIKELIHOOD RATIO APPROXIMATION.
C
C     NORMAL APPROXIMATION FIRST.
C
      DO4110I=1,NUMALP
        ALP=ALPHA(I)
        P=1.0-(ALP/2.0)
        CALL NORPPF(P,PPF)
CCCCC   ALOWSC(I)=SCALML - PPF*SCALSE
CCCCC   AUPPSC(I)=SCALML + PPF*SCALSE
        ALOWUH(I)=UHATML - PPF*UHATSE
        AUPPUH(I)=UHATML + PPF*UHATSE
        ALOWSC(I)=EXP(ALOWUH(I))
        AUPPSC(I)=EXP(AUPPUH(I))
        ALOWSH(I)=SIGMML - PPF*SIGMSE
        AUPPSH(I)=SIGMML + PPF*SIGMSE
 4110 CONTINUE
C
C     NOW DO LIKELIHOOD RATIO APPROXIMATION (SEE COMMENTS IN
C     LG2FUN FOR FORMULAS).
C
C     COMPUTE LL(UHAT,SIGMA) AND SAVE IN COMMOM BLOCK.
C
      N2=N
      IR2=IR
      IM2=IM
      DSIGMA=DBLE(SIGMML)
      DC=C
      N3=N
      IR3=IR
      IM3=IM
      DSIGM2=DBLE(SIGMML)
      DC2=C
      DU2=DBLE(UHATML)
C
      DX=(DLOG(DC) - DBLE(UHATML))/DSIGMA
      CALL NODCDF(DX,DTERM2)
      DTERM1=-DR*DLOG(DSIGMA) + DM*DLOG(1.0D0 - DTERM2)
      DSUM1=0.0D0
      DSUM2=0.0D0
      DO4118I=1,IR
        DTEMP(I)=DBLE(Y(I))
        DX=DLOG(DTEMP(I))
        DSUM1=DSUM1 + DX
        DSUM2=DSUM2 + ((DX - DBLE(UHATML))/DSIGMA)**2
 4118 CONTINUE
      DLLUS=DTERM1 - DSUM1 - 0.5D0*DSUM2
      DLLUS2=DLLUS
C
      DN=DBLE(N)
      AE=1.D-7
      RE=1.D-7
      NUTEMP=1
C
      DO4120I=1,NUMALP
        ALP=ALPHA(I)
        CALL CHSPPF(1.0-ALP,NUTEMP,APPF)
        DK=DBLE(APPF)
        DK2=DK
C
        DXSTRT=DBLE(ALOWSH(I))
        DXLOW=DXSTRT/5.0D0
        DXUP=DBLE(SIGMML)
        CALL DFZER2(LG4FUN,DXLOW,DXUP,DXSTRT,RE,AE,IFLAG,DTEMP)
        ALOSH2(I)=REAL(DXLOW)
C
        DXSTRT=DBLE(AUPPSH(I))
        DXUP=DXSTRT*5.0D0
        DXLOW=DBLE(SIGMML)
        CALL DFZER2(LG4FUN,DXLOW,DXUP,DXSTRT,RE,AE,IFLAG,DTEMP)
        AUPSH2(I)=REAL(DXLOW)
C
        DXSTRT=DBLE(ALOWUH(I))
        DXLOW=DXSTRT/2.0D0
        DXUP=DBLE(UHATML)
        CALL DFZER2(LG2FUN,DXLOW,DXUP,DXSTRT,RE,AE,IFLAG,DTEMP)
        ALOWU2(I)=REAL(DXLOW)
        ALOWS2(I)=EXP(ALOWU2(I))
C
        DXSTRT=DBLE(AUPPUH(I))
        DXUP=DXSTRT*2.0D0
        DXLOW=DBLE(UHATML)
        CALL DFZER2(LG2FUN,DXLOW,DXUP,DXSTRT,RE,AE,IFLAG,DTEMP)
        AUPPU2(I)=REAL(DXLOW)
        AUPPS2(I)=EXP(AUPPU2(I))
 4120 CONTINUE
C
      ISTEPN='35'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLL2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C  CONFIDENCE INTERVALS FOR SELECTED PERCENTILES.
C
C  BASE ON EITHER THE ASYMPTOTIC NORMAL APPROXIMATION OR THE
C  LIKELIHOOD RATIO.
C
C  NOTE: I HAVEN'T BEEN ABLE TO GET THE LIKELIHOOD RATION METHOD
C        TO WORK.  COMMENT OUT FOR NOW.  
C
      IF(NPERC.GE.1)THEN
C
        ALPHL=ALPHAP/2.0
        ALPHU=1.0 - ALPHAP/2.0
        CALL NORPPF(ALPHU,Z95)
        DU=DBLE(UHATML)
        DS=DBLE(SIGMML)
C
        WRITE(IOUNI1,4191)
 4191   FORMAT(15X,'       POINT     ','   STANDARD   ',
     1         '     LOWER     ','     UPPER')
        WRITE(IOUNI1,4192)
 4192   FORMAT('    PERCENTILE ','     ESTIMATE   ','     ERROR     ',
     1         'CONFIDENCE LIMIT ','CONFIDENCE LIMIT')
C
        N4=N
        IR4=IR
        IM4=IM
        DSIGMA3=DBLE(SIGMML)
        DC3=C
        DU3=DBLE(UHATML)
        DLLUS3=DLLUS
C
        NUTEMP=1
        CALL CHSPPF(1.0-ALPHAP,NUTEMP,APPF)
        DK=DBLE(APPF)
        DK3=DK
C
        DO4190I=1,NPERC
          QPTEMP=QP(I)/100.0
C
          CALL LGNPPF(QPTEMP,SIGMML,ATEMP)
          XQPHAT(I)=SCALML*ATEMP
C
          CALL NORPPF(QPTEMP,X95)
          D0=DEXP(DU + DBLE(X95)*DS)
          D1=DBLE(X95)*DEXP(DU + DBLE(X95)*DS)
          DTERM1=D0*D0*UHATSE**2
          DTERM2=D1*D1*SIGMSE**2
          DTERM3=D0*D1*COVSE
          DTERM4=D1*D0*COVSE
          DSUM=DTERM1 + DTERM2 + DTERM3 + DTERM4
          SEXQP=0.0
          IF(DSUM.GE.0.0D0)SEXQP=DSQRT(DSUM)
          XQPSE(I)=REAL(SEXQP)
          XQPLCL(I)=XQPHAT(I) - Z95*XQPSE(I)
          XQPUCL(I)=XQPHAT(I) + Z95*XQPSE(I)
C
CCCCC     DX05=DBLE(XQPHAT(I))
CCCCC     DZ05=DBLE(X95)
CCCCC     DXSTRT=DBLE(XQPLCL(I))
CCCCC     DXLOW=DXSTRT/2.0D0
CCCCC     DXUP=DBLE(XQPHAT(I))
CCCCC     CALL DFZER2(LG6FUN,DXLOW,DXUP,DXSTRT,RE,AE,IFLAG,DTEMP)
CCCCC     write(19,*)'i,iflag=',i,iflag
CCCCC     XQPLC2(I)=REAL(DXLOW)
C
CCCCC     DXSTRT=DBLE(XQPUCL(I))
CCCCC     DXUP=DXSTRT*5.0D0
CCCCC     DXLOW=DBLE(XQPHAT(I))
CCCCC     CALL DFZER2(LG6FUN,DXLOW,DXUP,DXSTRT,RE,AE,IFLAG,DTEMP)
CCCCC     XQPUC2(I)=REAL(DXLOW)
CCCCC     write(19,*)'i,xqphat(i),xqplc2(i)=',i,xqphat(i),xqplc2(i)
C
          WRITE(IOUNI1,'(4E15.7,2X,E15.7)')
     1         QP(I),XQPHAT(I),XQPSE(I),XQPLCL(I),XQPUCL(I)
          IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLL2')THEN
            WRITE(ICOUT,4193)D0,D1
 4193       FORMAT('D0,D1,DSUM = ',3G15.7)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,4195)DTERM1,DTERM2,DTERM3,DTERM4
 4195       FORMAT('DTERM1,DTERM2,DTERM3,DTERM4 = ',4G15.7)
            CALL DPWRST('XXX','BUG ')
          ENDIF
 4190   CONTINUE
C
      ENDIF
C
C               *************************************
C               **   STEP 42--                     **
C               **   WRITE OUT EVERYTHING          **
C               **   FOR LOGNORMAL MLE ESTIMATE    **
C               *************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLL2')
     1  CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     PRINT SUMMARY STATISTICS TABLE
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Two-Parameter Lognormal Parameter Estimation:'
      NCTITL=45
      ITITLZ='Time (Singly) Censored Case'
      NCTITZ=27
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Total Number of Observations:'
      NCTEXT(ICNT)=29
      AVALUE(ICNT)=REAL(N)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Uncensored Observations:'
      NCTEXT(ICNT)=34
      AVALUE(ICNT)=REAL(IR)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Censored Observations:'
      NCTEXT(ICNT)=32
      AVALUE(ICNT)=REAL(IM)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean (All Data):'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=XMEANF
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Median (All Data):'
      NCTEXT(ICNT)=25
      AVALUE(ICNT)=XMEDF
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample SD (All Data):'
      NCTEXT(ICNT)=21
      AVALUE(ICNT)=XSDF
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum (All Data):'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XMINF
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum (All Data):'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XMAXF
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean (Uncensored Data):'
      NCTEXT(ICNT)=30
      AVALUE(ICNT)=XMEANC
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Median (Uncensored Data):'
      NCTEXT(ICNT)=32
      AVALUE(ICNT)=XMEDC
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample SD (Uncensored Data):'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSDC
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum (Uncensored Data):'
      NCTEXT(ICNT)=33
      AVALUE(ICNT)=XMINC
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum (Uncensored Data):'
      NCTEXT(ICNT)=33
      AVALUE(ICNT)=XMAXC
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Maximum Likelihood:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Shape (Sigma):'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=SHAPML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Standard Error of Shape:'
      NCTEXT(ICNT)=24
      AVALUE(ICNT)=SHAPSE
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Mu (= LOG(Scale)):'
      NCTEXT(ICNT)=30
      AVALUE(ICNT)=UHATML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Standard Error of Mu:'
      NCTEXT(ICNT)=21
      AVALUE(ICNT)=UHATSE
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Shape/Mu Covariance:'
      NCTEXT(ICNT)=20
      AVALUE(ICNT)=COVSE
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Scale:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=SCALML
      IDIGIT(ICNT)=NUMDIG
C
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='Log-likelihood:'
CCCCC NCTEXT(ICNT)=15
CCCCC AVALUE(ICNT)=ALIK
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=AIC
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AICc:'
CCCCC NCTEXT(ICNT)=5
CCCCC AVALUE(ICNT)=AICC
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='BIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=BIC
CCCCC IDIGIT(ICNT)=-7
C
      NUMROW=ICNT
      DO2310I=1,NUMROW
        NTOT(I)=15
 2310 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
      ILIKFL='LGNC'
      CALL DPDT8D(ALOWSC,AUPPSC,ALOWS2,AUPPS2,
     1            ALOWUH,AUPPUH,ALOWU2,AUPPU2,
     1            ALOWSH,AUPPSH,ALOSH2,AUPSH2,ALPHA,NUMALP,
     1            ICAPSW,ICAPTY,NUMDIG,ILIKFL,
     1            ISUBRO,IBUGA3,IERROR)
C
      IF(NPERC.GT.1)THEN
        ILIKFL='OFF'
        CALL DPDTA9(QP,XQPHAT,XQPLCL,XQPUCL,XQPSE,NPERC,
     1              ICAPSW,ICAPTY,ILIKFL,NUMDIG,ALPHAP,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLL2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLL2--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)IBUGA3,IERROR
 9012   FORMAT('IBUGA3,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLLK(Y,X,N,NVAR,
     1                  TEMP1,TEMP2,TEMP3,DTEMP1,
     1                  AMOM,BETAMO,BMOM,
     1                  AFR,BETAFR,BFR,
     1                  AML,BETAML,BML,
     1                  ICAPSW,ICAPTY,IFORSW,MAXNXT,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR THE LAGRANGE KATZ DISTRIBUTION.
C
C              THE MOMENT ESTIMATES ARE:
C
C                 BETAHAT = 2 - 0.5*(A +/- SQRT(A*(A-4))
C
C                 AHAT = 0.5*XBAR**(3/2)*(1/SQRT(S2))*
C                        (SQRT(A) +/- SQRT(A-4))
C
C                 BHAT = -1 + 0.5*(SQRT(A) +/- SQRT(A-4)*
C                         (SQRT(A) - SQRT(XBAR/S2))
C
C              WHERE
C
C                 A = (3*S2**2 - S3*XBAR)**2/(XBAR - S2**3)
C
C              NOTE THAT THE MOMENT ESTIMATORS ONLY EXIST IF A >= 4
C
C              THE MOMENTS AND ZERO FREQUENCY ESTIMATE OF BETA
C              IS THE SOLUTION OF THE EQUATION
C
C                 (1-BETA)*(LOG(1-BETA))**2 -
C                 (BETA**2*S/XBAR**3)*[LOG(F0)]**2 = 0
C
C              THE ESTIMATES OF A AND B ARE THEN
C
C                 AHAT = SQRT(XBAR**3*(1 - BETAHAT)/S2)
C                 BHAT = 1 - BETAHAT - (AHAT/XBAR)
C
C              THE MAXIMUM LIKELIHOOD ESTIMATES OF B AND BETA
C              ARE THE SOLUTIONS TO THE EQUATIONS:
C
C                 N*XBAR*LOG(1-BETA)/BETA - 
C                 SUM[X=2 to k][SUM[i=1 to x-1]
C                 [X*N(x)/(XBAR*(1-B-BETA) + B*X + BETA*I)]] = 0
C
C                 -N*XBAR*(1-BETA)*LOG(1-BETA)/BETA + N*XBAR/BETA +
C                 SUM[X=2 to k][SUM[i=1 to x-1]
C                 [I*N(x)/(XBAR*(1-b-BETA) + B*X + BETA*I)]] = 0
C
C
C              THE ESTIMATE OF A IS THEN
C
C                 AHAT = XBAR*(1 - B - BETA)
C
C              THERE ARE TWO CASES:
C
C              1) ONE VARIABLE CASE: Y IS RAW DATA
C              2) TWO VARIABLE CASE: Y IS FREQUENCY, X IS CLASS
C                 MID-POINT.
C
C     EXAMPLE--LAGRANGE KATZ MAXIMUM LIKELIHOOD Y
C            --LAGRANGE KATZ MAXIMUM LIKELIHOOD Y X
C     REFERENCES--CONSUL AND FAMOYE (2006), "LAGRANGIAN PROBABILITY
C                 DISTRIBUTIONS", BIRKHAUSER, CHAPTER 10.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2006/8
C     ORIGINAL VERSION--AUGUST    2006.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-----------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*4 ISUBN0
      CHARACTER*4 IRELAT
      CHARACTER*4 IRHSTG
C
C-------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION TEMP1(*)
      DIMENSION TEMP2(*)
      DIMENSION TEMP3(*)
      DOUBLE PRECISION DTEMP1(*)
C
      DOUBLE PRECISION TOL
      DOUBLE PRECISION XPAR(3)
      DOUBLE PRECISION FVEC(2)
C
      DOUBLE PRECISION AE
      DOUBLE PRECISION RE
      DOUBLE PRECISION XLOW
      DOUBLE PRECISION XUP
      DOUBLE PRECISION XMID
      DOUBLE PRECISION DSUM
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM2
      DOUBLE PRECISION DATER1
      DOUBLE PRECISION DATER2
      DOUBLE PRECISION DATERM
      DOUBLE PRECISION DA
C
      DOUBLE PRECISION LKFUN
      DOUBLE PRECISION LKFU3
      DOUBLE PRECISION LKFU4
CCCCC EXTERNAL LKFUN
CCCCC EXTERNAL LKFU2
CCCCC EXTERNAL LKFU3
CCCCC EXTERNAL LKFU4
      DOUBLE PRECISION XBAR
      DOUBLE PRECISION S2
      DOUBLE PRECISION S3
      DOUBLE PRECISION F0FREQ
      DOUBLE PRECISION F1FREQ
      DOUBLE PRECISION F10FRE
      DOUBLE PRECISION DC1
      COMMON/LKCOM/XBAR,S2,S3,F0FREQ,F1FREQ,F10FRE,DC1,
     1              MAXRO2,NTOT2
C
      PARAMETER (MAXROW=40)
      CHARACTER*60 ITITLE
      CHARACTER*1  ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 IDIST
      CHARACTER*40 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(MAXROW)
      CHARACTER*4  VALIGN(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL      IFRST
      LOGICAL      ILAST
C
C-------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT---------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='LK  '
C
      IERROR='NO'
      IWRITE='OFF'
C
      AMOM=CPUMIN
      BETAMO=CPUMIN
      BMOM=CPUMIN
      AFR=CPUMIN
      BETAFR=CPUMIN
      BFR=CPUMIN
      THETF2=CPUMIN
      BETAF2=CPUMIN
      AMF2=CPUMIN
      AML=CPUMIN
      BETAML=CPUMIN
      BML=CPUMIN
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLLK')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLLK--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N,NVAR
   52   FORMAT('IBUGA3,ISUBRO,N,NVAR = ',2(A4,2X),2I8)
        CALL DPWRST('XXX','WRIT')
        IF(NVAR.EQ.1)THEN
          DO56I=1,MIN(N,100)
            WRITE(ICOUT,57)I,Y(I)
   57       FORMAT('I,Y(I) = ',I8,G15.7)
            CALL DPWRST('XXX','WRIT')
   56     CONTINUE
        ELSE
          DO61I=1,N
            WRITE(ICOUT,62)I,X(I),Y(I)
   62       FORMAT('I,X(I),Y(I) = ',I8,2G15.7)
            CALL DPWRST('XXX','WRIT')
   61     CONTINUE
        ENDIF
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  1) ROUND DATA TO INTEGER VALUES       **
C               **  2) COMPUTE SUMMARY STATISTICS         **
C               **  3) CHECK INPUT FOR NEGATIVE VALUES,   **
C               **     INSUFFICIENT SAMPLE SIZE           **
C               **  4) FOR RAW DATA CASE, BIN THE DATA.   **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLLP')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IDIST='LAGRANGE KATZ'
C
      NPERC=0
      MAXGRP=MAXNXT/2
      NMIN=2
      IF(NVAR.EQ.1)THEN
        DO1105I=1,N
          ITEMP=INT(Y(I)+0.5)
          Y(I)=REAL(ITEMP)
 1105   CONTINUE
        CALL CKDIST(Y,N,NMIN,TEMP1,NPERC,ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
        CALL SORT(Y,N,Y)
        IFLAG=1
        CALL SUMRAW(Y,N,IDIST,IFLAG,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        NTOTZZ=N
C
        IRELAT='OFF'
        IRHSTG='OFF'
        XSTART=XMIN-0.5
        XSTOP=XMAX+0.5
        CLWID=1.0
        CALL DPBINI(Y,N,IRELAT,CLWID,XSTART,XSTOP,IRHSTG,
     1              TEMP1,X,N2,IBUGA3,IERROR)
        ICNT=0
        DO1121I=1,N2
          Y(I)=TEMP1(I)
CCCCC     IF(TEMP1(I).GT.0.0)THEN
            ICNT=ICNT+1
            Y(ICNT)=Y(I)
            X(ICNT)=X(I)
CCCCC     ENDIF
1121    CONTINUE
        N2=ICNT
        IF(IERROR.EQ.'YES')GOTO9000
      ELSE
        CALL CKDIS2(Y,X,TEMP1,N,MAXGRP,NMIN,TEMP2,NPERC,NTOTZZ,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IFLAG1=1
        IFLAG2=1
        CALL SUMGRP(Y,X,N,IDIST,IFLAG1,IFLAG2,
     1              TEMP1,TEMP2,TEMP3,MAXNXT,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        ICNT=0
        NTOTZZ=0
        DO1211I=1,N
CCCCC     IF(Y(I).GT.0.0)THEN
            ICNT=ICNT+1
            Y(ICNT)=Y(I)
            X(ICNT)=X(I)
            NTOTZZ=NTOTZZ + INT(Y(I)+0.01)
CCCCC     ENDIF
1211    CONTINUE
        N2=ICNT
      ENDIF
C
      IINDX=MAXNXT/2
      IF(N2.LE.IINDX)THEN
        IML=0
        DO2210I=1,N2
          TEMP3(I)=Y(I)
          TEMP3(IINDX+I)=X(I)
 2210   CONTINUE
        IK=N2
      ELSE
        IML=1
      ENDIF
      F0=TEMP3(1)/REAL(NTOTZZ)
      F1=TEMP3(2)/REAL(NTOTZZ)
      IF(F0.NE.0.0)THEN
        F10=F1/F0
      ELSE
        F10=CPUMIN
      ENDIF
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLLK')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1151)
 1151   FORMAT('AFTER COMPUTE SUMMARY STATISTICS--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1152)XMEAN,XVAR,XSD,XMIN,XMAX
 1152   FORMAT('XMEAN,XVAR,XSD,XMIN,XMAX = ',5G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1154)F1,N,N2,NTOTZZ,IK,IWD
 1154   FORMAT('F1,N,N2,NTOTZZ,IK,IWD = ',G15.7,4I8)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
C               *********************************************
C               **  STEP 21--                              **
C               **  CARRY OUT CALCULATIONS                 **
C               **  FOR LAGRANGE KATZ MLE                  **
C               **  ESTIMATION                             **
C               *********************************************
C
 2100 CONTINUE
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLLK')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C
      IF(NVAR.EQ.1)THEN
        DSUM=0.0D0
        DO2108I=1,N
          DTERM1=DBLE(Y(I)) - DBLE(XMEAN)
          DSUM=DSUM +  DTERM1**3
 2108   CONTINUE
        S3=REAL(DSUM/DBLE(NTOTZZ-1))
C
      ELSE
        DSUM=0.0D0
        DO2208I=1,N
          DSUM=DSUM +  DBLE(Y(I))*(DBLE(I) - DBLE(XMEAN))**3
 2208   CONTINUE
        S3=REAL(DSUM/DBLE(NTOTZZ-1))
      ENDIF
C
      IMOM=0
      XBAR=DBLE(XMEAN)
      S2=DBLE(XSD)**2
      S3SKEW=S3/(DBLE(XSD)**3)
      DA=(3.0D0*S2**2 - S3*XBAR)**2/(XBAR - S2**3)
      IF(DA.GE.4.0D0)THEN
        DATER1=DA + DSQRT(DA*(DA-4.0D0))
        DATER2=DA - DSQRT(DA*(DA-4.0D0))
        BETAM1=2.0D0 - 0.5D0*DATER1
        BETAM2=2.0D0 - 0.5D0*DATER2
        print *,'dater1,dater2=',dater1,dater2
        print *,'betam1,betam2=',betam1,betam2
        IF(BETAM1.LT.1.0D0)THEN
          BETAM0=BETAM1
          DATERM=DATER1
        ELSEIF(BETAM2.LT.1.0D0)THEN
          BETAM0=BETAM2
          DATERM=DATER2
        ELSE
          IMOM=1
        ENDIF
        AMOM=REAL(0.5D0*XBAR**(1.5D0)*DATERM/DSQRT(S2))
        BMOM=REAL(1.0D0 + 0.5D0*DATERM*(DSQRT(DA) - DSQRT(XBAR/S2)))
      ELSE
        IMOM=1
      ENDIF
C
      AE=1.D-7
      RE=1.D-7
      XLOW=0.000001D0
      XUP=0.999999D0
      XMID=0.5D0
      F0FREQ=DBLE(F0)
      F1FREQ=DBLE(F1)
      F10FRE=DBLE(F10)
      NTOT2=NTOTZZ
C
CCCCC IFR=0
CCCCC IF(F0.GT.0.0)THEN
CCCCC   C1=S2*LOG(F0)**2/(XBAR**3)
CCCCC   IF(C1.GE.1.0 .OR. C1.LE.0.0)IFR=1
CCCCC ELSE
CCCCC   IFR=1
CCCCC ENDIF
CCCCC IF(IFR.EQ.0)THEN
CCCCC   DC1=DBLE(C1)
CCCCC   XLOW=0.000001D0
CCCCC   XUP=0.999999D0
CCCCC   XMID=DBLE(AMOM)
CCCCC   CALL DFZERO(GNBFU3,XLOW,XUP,XMID,RE,AE,IFLAG)
CCCCC   AFR=REAL(XLOW)
CCCCC   BFR=SQRT((1.0-AFR)*AMEAN**3/AVAR)/AFR
CCCCC   BETAFR=(1.0/AFR) - (BFR/AMEAN)
CCCCC   IF(BETAFR.LE.1.0)BETAFR=1.0
CCCCC ENDIF
C
      IF(IML.EQ.0)THEN
        IOPT=2
        TOL=1.0D-5
        NPAR=2
        NPRINT=-1
        INFO=0
        LWA=MAXNXT
        MAXRO2=MAXNXT
C
CCCCC   IF(IFR2.EQ.0)THEN
CCCCC     XPAR(1)=DBLE(BETAF2)
CCCCC     XPAR(2)=DBLE(AMF2)
CCCCC   ELSEIF(IFR.EQ.0)THEN
CCCCC     XPAR(1)=DBLE(BETAFR)
CCCCC     XPAR(2)=DBLE(BFR)
CCCCC   ELSE
CCCCC     XPAR(1)=DBLE(BETAMO)
CCCCC     XPAR(2)=DBLE(BMOM)
CCCCC   ENDIF
CCCCC   CALL DNSQE(GNBFU2,JAC,IOPT,NPAR,XPAR,FVEC,TOL,NPRINT,INFO,
CCCCC1             DTEMP1,LWA,TEMP3,IK)
CCCCC   print *,'info = ',info
C
CCCCC   BETAML=REAL(XPAR(1))
CCCCC   BML=REAL(XPAR(2))
CCCCC   IF(BETAML.LE.1.0)BETAML=1.0
CCCCC   AML=AMEAN/(BML + BETAML*XBAR)
      ENDIF
C
C               ***********************************************
C               **   STEP 42--                               **
C               **   WRITE OUT EVERYTHING                    **
C               **   FOR LAGRANGE KATZ MLE                   **
C               **   ESTIMATION                              **
C               ***********************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLNM')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     PRINT SUMMARY STATISTICS TABLE
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Lagrange Katz Parameter Estimation'
      NCTITL=34
      ITITLZ=' '
      NCTITZ=0
C
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(NTOTZZ)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Centralized Third Moment:'
      NCTEXT(ICNT)=32
      AVALUE(ICNT)=REAL(S3)
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Zero-Class Frequency:'
      NCTEXT(ICNT)=21
      AVALUE(ICNT)=F0
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Ones-Class Frequency:'
      NCTEXT(ICNT)=21
      AVALUE(ICNT)=F1
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Ratio of Ones/Zero Class Frequencies:'
      NCTEXT(ICNT)=37
      AVALUE(ICNT)=F10
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Method of Moments:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Theta:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=AMOM
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Beta:'
      NCTEXT(ICNT)=17
      AVALUE(ICNT)=BETAMO
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of M:'
      NCTEXT(ICNT)=14
      AVALUE(ICNT)=BMOM
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      IF(IFR.EQ.0)THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='Zero-Class Frequency and Moments:'
        NCTEXT(ICNT)=18
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of Theta:'
        NCTEXT(ICNT)=18
        AVALUE(ICNT)=AFR
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of Beta:'
        NCTEXT(ICNT)=17
        AVALUE(ICNT)=BETAFR
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of M:'
        NCTEXT(ICNT)=14
        AVALUE(ICNT)=BFR
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)=' '
        NCTEXT(ICNT)=0
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
      ENDIF
C
      IF(IML.EQ.0)THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='Maximum Likelihood:'
        NCTEXT(ICNT)=19
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of Theta:'
        NCTEXT(ICNT)=18
        AVALUE(ICNT)=AML
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of Beta:'
        NCTEXT(ICNT)=17
        AVALUE(ICNT)=BETAML
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of M:'
        NCTEXT(ICNT)=14
        AVALUE(ICNT)=BML
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)=' '
        NCTEXT(ICNT)=0
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
      ENDIF
C
      NUMROW=ICNT
      DO2410I=1,NUMROW
        NTOT(I)=15
 2410 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLLK')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLLK--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)IERROR
 9012   FORMAT('IERROR = ',A4)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLLP(Y,X,N,NVAR,
     1                  TEMP1,TEMP2,TEMP3,DTEMP1,
     1                  THETMO,ALAMMO,THETVM,ALAMVM,COVMOM,
     1                  THETFR,ALAMFR,THETVF,ALAMVF,COVFR,
     1                  THETWD,ALAMWD,
     1                  THETML,ALAMML,THETVL,ALAMVL,COVML,
     1                  AICMO,AICCMO,BICMO,
     1                  AICML,AICCML,BICML,
     1                  AICFR,AICCFR,BICFR,
     1                  AICWD,AICCWD,BICWD,
     1                  ICAPSW,ICAPTY,IFORSW,MAXNXT,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR THE LAGRANGE-POISSON DISTRIBUTION.
C
C              THE MOMENT ESTIMATORS ARE:
C
C                  THETAHAT = SQRT(XBAR**3/XVAR)
C                  LAMBDAHAT = THETAHAT*[SQRT(XVAR/XBAR**3) - 1/XBAR]
C
C              THE MEAN AND ZERO FREQUENCY ESTIMATORS ARE:
C
C                  THETAHAT = LOG(f0/N)
C                  LAMBDAHAT = 1 - THETHAT/XBAR
C
C              THE WEIGHTED DISCREPANCIES ESTIMATES ARE THE
C              SOLUTION TO THE EQUATIONS:
C
C              SUM[i=1 to k][Y(i) - LPOPDF(X)]*
C                 [(X*(THETA+LAMBDA)/(THETA*(THETA+LAMBDA*X)) - 1] = 0
C
C              SUM[i=1 to k][Y(i) - LPOPDF(X)]*
C                 [(X*(X-1)/(THETA+LAMBDA*X)) - X] = 0
C
C              THE EWRC ESTIMATES ARE THE SOLUTION TO THE EQUATIONS:
C
C              SUM[i=1 to k][Y(i)*(Y(i) - LPOPDF(X))]*
C                 [(X*(THETA+LAMBDA)/(THETA*(THETA+LAMBDA*X)) - 1] = 0
C
C              SUM[i=1 to k][Y(i)*(Y(i) - LPOPDF(X))]*
C                 [(X*(X-1)/(THETA+LAMBDA*X)) - X] = 0
C
C              THE MAXIMUM LIKELIHOOD ESTIMATE OF LAMBDA IS
C              THE SOLUTION OF THE EQUATION:
C
C                 SUM[X=0 to K][X*(X-1)*N(X)/(XBAR+(X-XBAR)*LAMBDA)] -
C                 N*XBAR = 0
C
C              THERE ARE TWO CASES:
C
C              1) ONE VARIABLE CASE: Y IS RAW DATA
C              2) TWO VARIABLE CASE: Y IS FREQUENCY, X IS CLASS
C                 MID-POINT.
C
C     EXAMPLE--LAGRANGE-POISSON MAXIMUM LIKELIHOOD Y
C            --LAGRANGE-POISSON MAXIMUM LIKELIHOOD Y X
C     REFERENCES--JOHNSON, KOTZ, AND KEMP (1992).  "UNIVARIATE
C                 DISCRETE DISTRIBUTIONS", SECOND EDITION, 
C                 WILEY, PP. 394-396.
C               --CONSUL AND FAMOYE (2006), "LAGRANGIAN PROBABILITY
C                 DISTRIBUTIONS", BIRKHAUSER, CHAPTER 8.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2006/6
C     ORIGINAL VERSION--JUNE      2006.
C     UPDATED         --APRIL     2011. USE DPDTA1 AND DPDTA5 TO PRINT
C                                       OUTPUT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-----------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*4 ISUBN0
      CHARACTER*4 IRELAT
      CHARACTER*4 IRHSTG
C
      PARAMETER (MAXROW=50)
      CHARACTER*60 ITITLE
      CHARACTER*1  ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 IDIST
      CHARACTER*40 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(MAXROW)
      CHARACTER*4  VALIGN(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL      IFRST
      LOGICAL      ILAST
C
      PARAMETER(NUMCLI=5)
      PARAMETER(MAXLIN=3)
      CHARACTER*60 ITITL2(MAXLIN,NUMCLI)
      INTEGER      NCTIT2(MAXLIN,NUMCLI)
      INTEGER      IWHTML(NUMCLI+1)
      INTEGER      IWRTF(NUMCLI)
      REAL         AMAT(MAXROW,NUMCLI)
C
C-------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION TEMP1(*)
      DIMENSION TEMP2(*)
      DIMENSION TEMP3(*)
      DOUBLE PRECISION DTEMP1(*)
C
      REAL LCL
      REAL UCL
C
      DOUBLE PRECISION TOL
      DOUBLE PRECISION XPAR(2)
      DOUBLE PRECISION FVEC(2)
C
      EXTERNAL LPOFUN
      EXTERNAL LPOFU2
      EXTERNAL LPOFU3
      DOUBLE PRECISION XBAR
      COMMON/LPOCOM/XBAR,MAXRO2,NTOTZZ
C
      PARAMETER (NUMALP=5)
      DIMENSION ALPHA(NUMALP)
      DIMENSION ALOWTH(NUMALP)
      DIMENSION AUPPTH(NUMALP)
      DIMENSION ALOWLA(NUMALP)
      DIMENSION AUPPLA(NUMALP)
C
C-------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA ALPHA /0.50, 0.25, 0.10, 0.05, 0.01/
C
C-----START POINT---------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='LP  '
C
      IERROR='NO'
      IWRITE='OFF'
C
      THETMO=CPUMIN
      ALAMMO=CPUMIN
      THETMO=CPUMIN
      ALAMVM=CPUMIN
      COVMOM=CPUMIN
      THETFR=CPUMIN
      ALAMFR=CPUMIN
      THETVF=CPUMIN
      ALAMVF=CPUMIN
      COVFR=CPUMIN
      THETWD=CPUMIN
      ALAMWD=CPUMIN
      THETML=CPUMIN
      ALAMML=CPUMIN
      THETVL=CPUMIN
      ALAMVL=CPUMIN
      COVML=CPUMIN
      AICMO=CPUMIN
      AICCMO=CPUMIN
      BICMO=CPUMIN
      AICML=CPUMIN
      AICCML=CPUMIN
      BICML=CPUMIN
      AICFR=CPUMIN
      AICCFR=CPUMIN
      BICFR=CPUMIN
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLLP')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLLP--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N,NVAR
   52   FORMAT('IBUGA3,ISUBRO,N,NVAR = ',2(A4,2X),2I8)
        CALL DPWRST('XXX','WRIT')
        IF(NVAR.EQ.1)THEN
          DO56I=1,MIN(N,100)
            WRITE(ICOUT,57)I,Y(I)
   57       FORMAT('I,Y(I) = ',I8,G15.7)
            CALL DPWRST('XXX','WRIT')
   56     CONTINUE
        ELSE
          DO61I=1,N
            WRITE(ICOUT,62)I,X(I),Y(I)
   62       FORMAT('I,X(I),Y(I) = ',I8,2G15.7)
            CALL DPWRST('XXX','WRIT')
   61     CONTINUE
        ENDIF
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  1) ROUND DATA TO INTEGER VALUES       **
C               **  2) COMPUTE SUMMARY STATISTICS         **
C               **  3) CHECK INPUT FOR NEGATIVE VALUES,   **
C               **     INSUFFICIENT SAMPLE SIZE           **
C               **  4) FOR RAW DATA CASE, BIN THE DATA.   **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLLP')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IDIST='LAGRANGE POISSON'
C
      NPERC=0
      MAXGRP=MAXNXT/2
      NMIN=2
      IF(NVAR.EQ.1)THEN
        DO1105I=1,N
          ITEMP=INT(Y(I)+0.5)
          Y(I)=REAL(ITEMP)
 1105   CONTINUE
        CALL CKDIST(Y,N,NMIN,TEMP1,NPERC,ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
        CALL SORT(Y,N,Y)
        IFLAG=1
        CALL SUMRAW(Y,N,IDIST,IFLAG,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        NTOTZZ=N
C
        IRELAT='OFF'
        IRHSTG='OFF'
        XSTART=XMIN-0.5
        XSTOP=XMAX+0.5
        CLWID=1.0
        CALL DPBINI(Y,N,IRELAT,CLWID,XSTART,XSTOP,IRHSTG,
     1              TEMP1,X,N2,IBUGA3,IERROR)
        ICNT=0
        DO1121I=1,N2
          Y(I)=TEMP1(I)
          IF(TEMP1(I).GT.0.0)THEN
            ICNT=ICNT+1
            Y(ICNT)=Y(I)
            X(ICNT)=X(I)
          ENDIF
1121    CONTINUE
        N2=ICNT
        IF(IERROR.EQ.'YES')GOTO9000
      ELSE
        CALL CKDIS2(Y,X,TEMP1,N,MAXGRP,NMIN,TEMP2,NPERC,NTOTZZ,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IFLAG1=1
        IFLAG2=1
        CALL SUMGRP(Y,X,N,IDIST,IFLAG1,IFLAG2,
     1              TEMP1,TEMP2,TEMP3,MAXNXT,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        ICNT=0
        NTOTZZ=0
        DO1211I=1,N
          IF(Y(I).GT.0.0)THEN
            ICNT=ICNT+1
            Y(ICNT)=Y(I)
            X(ICNT)=X(I)
            NTOTZZ=NTOTZZ + INT(Y(I)+0.01)
          ENDIF
1211    CONTINUE
        N2=ICNT
      ENDIF
C
      F1=Y(1)/REAL(NTOTZZ)
      IINDX=MAXNXT/2
      IF(N2.LE.IINDX)THEN
        IWD=0
        DO2210I=1,N2
          TEMP3(I)=Y(I)
          TEMP3(IINDX+I)=X(I)
 2210   CONTINUE
        IK=N
      ELSE
        IWD=1
      ENDIF
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLBT')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1151)
 1151   FORMAT('AFTER COMPUTE SUMMARY STATISTICS--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1152)XMEAN,XVAR,XSD,XMIN,XMAX
 1152   FORMAT('XMEAN,XVAR,XSD,XMIN,XMAX = ',5G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1154)F1,N,N2,NTOTZZ,IK,IWD
 1154   FORMAT('F1,N,N2,NTOTZZ,IK,IWD = ',G15.7,4I8)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
C               *********************************************
C               **  STEP 21--                              **
C               **  CARRY OUT CALCULATIONS                 **
C               **  FOR LAGRANGE-POISSON MLE ESTIMATION    **
C               *********************************************
C
 2100 CONTINUE
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLLP')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     MOMENT ESTIMATES AND ASSOCITED VARIANCES AND COVARIANCES
C
      AN=REAL(NTOTZZ)
      THETMO=SQRT(XMEAN**3/XSD**2)
      ALAMMO=THETMO*(SQRT(XSD**2/XMEAN**3) - 1.0/XMEAN)
      TERM1=THETMO/(2.0*AN)
      TERM2=THETMO + (2.0-2.0*ALAMMO+3.0*ALAMMO**2)/(1.0-ALAMMO)
      THETVM=TERM1*TERM2
      TERM1=(1.0 - ALAMMO)/(2.0*AN*THETMO)
      TERM2=THETMO - THETMO*ALAMMO + 2.0*ALAMMO + 3.0*THETMO**2
      ALAMVM=TERM1*TERM2
      TERM1=1.0/(2.0*AN)
      TERM2=THETMO*(1.0-ALAMMO) + 3.0*ALAMMO**2
      COVMOM=TERM1*TERM2
C
C     MEAN AND FIRST FREQUENCY ESTIMATE
C
      IF(F1.GT.0.0)THEN
        THETFR=LOG(1.0/F1)
        ALAMFR=1.0 - THETFR/XMEAN
        THETVF=(1.0/AN)*(EXP(THETMO) - 1.0)
        ALAMVF=1.0 - THETFR/XMEAN
        TERM1=(1.0 - ALAMFR)/(AN*THETFR**2)
        TERM2=(1.0 - ALAMFR)*(EXP(THETFR-1.0) +
     1        THETFR*(2.0*ALAMFR - 1.0))
        TERM1=(1.0-ALAMFR)/(AN*THETFR)
        TERM2=EXP(THETFR) - THETFR - 1.0
        COVFR=TERM1*TERM2
      ENDIF
C
C     WEIGHTED DISCREPANCIES
C
      XBAR=DBLE(XMEAN)
      IF(IWD.EQ.0)THEN
        IOPT=2
        TOL=1.0D-5
        NPAR=2
        NPRINT=-1
        INFO=0
        LWA=MAXNXT
        MAXRO2=MAXNXT
C
        IF(ALAMFR.GT.0.0 .AND. THETFR.GT.0.0)THEN
          XPAR(1)=DBLE(ALAMFR)
          XPAR(2)=DBLE(THETFR)
        ELSE
          XPAR(1)=DBLE(ALAMMO)
          XPAR(2)=DBLE(THETMO)
        ENDIF
        CALL DNSQE(LPOFUN,JAC,IOPT,NPAR,XPAR,FVEC,TOL,NPRINT,INFO,
     1             DTEMP1,LWA,TEMP3,IK)
C
        ALAMWD=REAL(XPAR(1))
        THETWD=REAL(XPAR(2))
C
        IF(ALAMFR.GT.0.0 .AND. THETFR.GT.0.0)THEN
          XPAR(1)=DBLE(ALAMFR)
          XPAR(2)=DBLE(THETFR)
        ELSE
          XPAR(1)=DBLE(ALAMMO)
          XPAR(2)=DBLE(THETMO)
        ENDIF
CCCCC   XPAR(1)=DBLE(ALAMWD)
CCCCC   XPAR(2)=DBLE(THETWD)
CCCCC   CALL DNSQE(LPOFU3,JAC,IOPT,NPAR,XPAR,FVEC,TOL,NPRINT,INFO,
CCCCC1             DTEMP1,LWA,TEMP3,IK)
CCCCC   ALAMEW=REAL(XPAR(1))
CCCCC   THETEW=REAL(XPAR(2))
        THETEW=CPUMIN
        ALAMEW=CPUMIN
      ENDIF
C
C     MAXIMUM LIKELIHOOD ESTIMATE
C
C     IF LAMBDA IS OUT OF RANGE, THEN SUPPRESS ML OUTPUT.
C
      IML=1
      IOPT=2
      TOL=1.0D-5
      NPAR=1
      NPRINT=-1
      INFO=0
      LWA=MAXNXT
      MAXRO2=MAXNXT
C
      IF(IWD.EQ.0)THEN
        XPAR(1)=DBLE(ALAMWD)
      ELSE
        XPAR(1)=DBLE(ALAMMO)
      ENDIF
      CALL DNSQE(LPOFU2,JAC,IOPT,NPAR,XPAR,FVEC,TOL,NPRINT,INFO,
     1             DTEMP1,LWA,TEMP3,IK)
C
      ALAMML=REAL(XPAR(1))
      IF(ALAMML.LT.0.0 .OR. ALAMML.GT.1.0)THEN
        IML=0
        ALAM=ALAMWD
        THET=THETWD
      ELSE
        THETML=XBAR*(1.0-ALAMML)
        THETVL=THETML*(THETML+2.0)/(2.0*AN)
        ALAMVL=(THETML+2.0*ALAMML-THETML*ALAMML)*(1.0-ALAMML)/
     1         (2.0*AN*THETML)
        COVML=-THETML*(1.0-ALAMML)/(2.0*AN)
        ALAM=ALAMML
        THET=THETML
      ENDIF
C
      DO2310I=1,NUMALP
C
        ALP=ALPHA(I)
        P1=ALP/2.0
        P2=1.0-(ALP/2.0)
        CALL NORPPF(P2,ZALPHA)
C
CCCCC   TERM1=XMEAN*(1.0 - ALAMML)**3*SQRT(AN)
CCCCC   TERM2=(1.0-ALAMML)**2*SQRT(AN) + ZALPHA
CCCCC   TERM3=(1.0-ALAMML)**2*SQRT(AN) - ZALPHA
CCCCC   UCL=TERM1/TERM3
CCCCC   LCL=TERM1/TERM2
        LCL=(XMEAN - ZALPHA*XSD)*(1.0 - ALAM)/SQRT(AN)
        IF(LCL.LT.0.0)LCL=0.0
        UCL=(XMEAN + ZALPHA*XSD)*(1.0 - ALAM)/SQRT(AN)
        ALOWTH(I)=LCL
        AUPPTH(I)=UCL
        UCL=1.0 - THET/(XMEAN + ZALPHA*XSD/SQRT(AN))
        LCL=1.0 - THET/(XMEAN - ZALPHA*XSD/SQRT(AN))
        IF(LCL.LT.0.0)LCL=0.0
        ALOWLA(I)=LCL
        AUPPLA(I)=UCL
C
 2310 CONTINUE
C
C               ***********************************************
C               **   STEP 42--                               **
C               **   WRITE OUT EVERYTHING                    **
C               **   FOR LAGRANGE-POISSON MLE ESTIMATION     **
C               ***********************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLLP')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     PRINT SUMMARY STATISTICS TABLE
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Lagrange-Poisson Parameter Estimation'
      NCTITL=37
      ITITLZ=' '
      NCTITZ=0
C
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(NTOTZZ)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='First Frequency:'
      NCTEXT(ICNT)=16
      AVALUE(ICNT)=F1
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Method of Moments:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Theta:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=THETMO
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Lambda:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=ALAMMO
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Asymptotic Variance of Theta:'
      NCTEXT(ICNT)=29
      AVALUE(ICNT)=THETVM
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Asymptotic Variance of Lambda:'
      NCTEXT(ICNT)=30
      AVALUE(ICNT)=ALAMVM
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Asymptotic Covariance of Theta/Lambda:'
      NCTEXT(ICNT)=38
      AVALUE(ICNT)=COVMOM
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Method of Zero Frequency and Mean:'
      NCTEXT(ICNT)=34
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Theta:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=THETFR
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Lambda:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=ALAMFR
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Asymptotic Variance of Theta:'
      NCTEXT(ICNT)=29
      AVALUE(ICNT)=THETVF
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Asymptotic Variance of Lambda:'
      NCTEXT(ICNT)=30
      AVALUE(ICNT)=ALAMVF
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Asymptotic Covariance of Theta-Lambda:'
      NCTEXT(ICNT)=38
      AVALUE(ICNT)=COVFR
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Method of Weighted Discrepancies:'
      NCTEXT(ICNT)=33
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Theta:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=THETWD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Lambda:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=ALAMWD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      IF(IML.EQ.1)THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='Method of Maximum Likelihood:'
        NCTEXT(ICNT)=29
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of Theta:'
        NCTEXT(ICNT)=18
        AVALUE(ICNT)=THETML
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of Lambda:'
        NCTEXT(ICNT)=19
        AVALUE(ICNT)=ALAMML
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Asymptotic Variance of Theta:'
        NCTEXT(ICNT)=29
        AVALUE(ICNT)=THETVL
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Asymptotic Variance of Lambda:'
        NCTEXT(ICNT)=30
        AVALUE(ICNT)=ALAMVL
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Asymptotic Covariance of Theta-Lambda:'
        NCTEXT(ICNT)=38
        AVALUE(ICNT)=COVML
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)=' '
        NCTEXT(ICNT)=0
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
      ENDIF
C
      NUMROW=ICNT
      DO2410I=1,NUMROW
        NTOT(I)=15
 2410 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
      ITITL9=' '
      NCTIT9=0
      ITITLE(1:42)='Large Sample Normal Confidence Limits for '
      ITITLE(43:59)='Theta and Lambda'
      NCTITL=59
      NUMLIN=3
      NUMCOL=5
C
      ITITL2(1,1)=' '
      ITITL2(2,1)='Confidence'
      ITITL2(3,1)='Coefficient'
      NCTIT2(1,1)=10
      NCTIT2(2,1)=10
      NCTIT2(3,1)=11
C
      ITITL2(1,2)=' '
      ITITL2(2,2)='Lower'
      ITITL2(3,2)='Limit'
      NCTIT2(1,2)=0
      NCTIT2(2,2)=5
      NCTIT2(3,2)=5
C
      ITITL2(1,3)='Theta'
      ITITL2(2,3)='Upper'
      ITITL2(3,3)='Limit'
      NCTIT2(1,3)=5
      NCTIT2(2,3)=5
      NCTIT2(3,3)=5
C
      ITITL2(1,4)=' '
      ITITL2(2,4)='Lower'
      ITITL2(3,4)='Limit'
      NCTIT2(1,4)=0
      NCTIT2(2,4)=5
      NCTIT2(3,4)=5
C
      ITITL2(1,5)='Lambda'
      ITITL2(2,5)='Upper'
      ITITL2(3,5)='Limit'
      NCTIT2(1,5)=6
      NCTIT2(2,5)=5
      NCTIT2(3,5)=5
C
      NMAX=0
      DO2321I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        NMAX=NMAX+NTOT(I)
        IDIGIT(I)=NUMDIG
 2321 CONTINUE
      IDIGIT(1)=2
      DO2323I=1,NUMALP
        NCTEXT(I)=0
        AMAT(I,1)=100.0*(1.0 - ALPHA(I))
        AMAT(I,2)=ALOWTH(I)
        AMAT(I,3)=AUPPTH(I)
        AMAT(I,4)=ALOWLA(I)
        AMAT(I,5)=AUPPLA(I)
 2323 CONTINUE
      IWHTML(1)=100
      IWHTML(2)=150
      IWHTML(3)=150
      IWHTML(4)=150
      IWHTML(5)=150
      IWHTML(6)=150
      IWRTF(1)=1600
      IWRTF(2)=IWRTF(1)+1800
      IWRTF(3)=IWRTF(2)+1800
      IWRTF(4)=IWRTF(3)+1800
      IWRTF(5)=IWRTF(4)+1800
      IFRST=.TRUE.
      ILAST=.TRUE.
C
C     THE CI FOR THETA IS NOT MAKING SENSE, SO COMMENT OUT
C     FOR NOW.
C
CCCCC CALL DPDTA2(ITITL9,NCTIT9,
CCCCC1            ITITLE,NCTITL,ITITL2,NCTIT2,
CCCCC1            MAXLIN,NUMLIN,NUMCLI,NUMCOL,
CCCCC1            ITEXT,NCTEXT,AMAT,MAXROW,NUMALP,
CCCCC1            IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
CCCCC1            ICAPSW,ICAPTY,IFRST,ILAST,
CCCCC1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLLP')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLLP--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012   FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLLS(Y,X,N,NVAR,
     1                  TEMP1,TEMP2,TEMP3,MAXNXT,
     1                  RHAT,PHAT,
     1                  AIC,AICC,BIC,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR THE LOST GAMES DISTRIBUTION.
C              THE MAXIMUM LIKELIHOOD ESTIMATES ARE:
C
C              1) USE THE MINIMUM VALUE AS THE ESTIMATE OF
C                 R.
C
C              2) THEN USE
C
C                   PHAT = XMEAN/(2*XMEAN-XMIN)
C
C                 AS THE ESTIMATE OF P.
C
C              THERE ARE TWO CASES:
C
C              1) ONE VARIABLE CASE: Y IS RAW DATA
C              2) TWO VARIABLE CASE: Y IS FREQUENCY, X IS CLASS
C                 MID-POINT.
C
C     EXAMPLE--LOST GAMES MAXIMUM LIKELIHOOD Y
C            --LOST GAMES MAXIMUM LIKELIHOOD Y X
C     REFERENCES--JOHNSON, KOTZ, AND KEMP (1992).  "UNIVARIATE
C                 DISCRETE DISTRIBUTIONS", SECOND EDITION, 
C                 WILEY, PP. 445-447.
C               --LUC DEVROYE (1986), "NON-UNIFORM RANDOM VARIATE
C                 GENERATION", SPRINGER-VERLANG, PP. 758-759.
C               --KEMP AND KEMP (1968), "ON A DISTRIBUTION ASSOCIATED
C                 WITH CERTAIN STOCHASTIC PROCESSES", JOURNAL OF
C                 THE ROYAL STATISTICAL SOCIETY, SERIES B, 30,
C                 PP. 401-410.
C               --HAIGHT (1961), "A DISTRIBUTION ANALOGOUS TO THE
C                 BOREL-TANNER", BIOMETRIKA, 48, PP. 167-173.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2006/6
C     ORIGINAL VERSION--JUNE      2006.
C     UPDATED         --APRIL     2011. USE DPDTA1 TO PRINT THE OUTPUT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-----------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*4 ISUBN0
C
C-------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION TEMP1(*)
      DIMENSION TEMP2(*)
      DIMENSION TEMP3(*)
C
      PARAMETER (MAXROW=20)
      CHARACTER*60 ITITLE
      CHARACTER*1  ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 IDIST
      CHARACTER*40 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(MAXROW)
      CHARACTER*4  VALIGN(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL      IFRST
      LOGICAL      ILAST
C
C-------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT---------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='LS  '
C
      IERROR='NO'
      IWRITE='OFF'
C
      RHAT=CPUMIN
      PHAT=CPUMIN
      AIC=CPUMIN
      AICC=CPUMIN
      BIC=CPUMIN
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLLS')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLLS--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N,NVAR
   52   FORMAT('IBUGA3,ISUBRO,N,NVAR = ',2(A4,2X),2I8)
        CALL DPWRST('XXX','WRIT')
        IF(NVAR.EQ.1)THEN
          DO56I=1,MIN(N,100)
            WRITE(ICOUT,57)I,Y(I)
   57       FORMAT('I,Y(I) = ',I8,G15.7)
            CALL DPWRST('XXX','WRIT')
   56     CONTINUE
        ELSE
          DO61I=1,N
            WRITE(ICOUT,62)I,X(I),Y(I)
   62       FORMAT('I,X(I),Y(I) = ',I8,2G15.7)
            CALL DPWRST('XXX','WRIT')
   61     CONTINUE
        ENDIF
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  1) ROUND DATA TO INTEGER VALUES       **
C               **  2) COMPUTE SUMMARY STATISTICS         **
C               **  3) CHECK INPUT FOR NEGATIVE VALUES,   **
C               **     INSUFFICIENT SAMPLE SIZE           **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLLS')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IDIST='LOST GAMES'
C
      NPERC=0
      MAXGRP=MAXNXT/2
      NMIN=2
      IF(NVAR.EQ.1)THEN
        DO1105I=1,N
          ITEMP=INT(Y(I)+0.5)
          Y(I)=REAL(ITEMP)
 1105   CONTINUE
        CALL CKDIST(Y,N,NMIN,TEMP1,NPERC,ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
        IFLAG=1
        CALL SUMRAW(Y,N,IDIST,IFLAG,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        NTOTZZ=N
C
      ELSE
        CALL CKDIS2(Y,X,TEMP1,N,MAXGRP,NMIN,TEMP2,NPERC,NTOTZZ,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IFLAG1=1
        IFLAG2=1
        CALL SUMGRP(Y,X,N,IDIST,IFLAG1,IFLAG2,
     1              TEMP1,TEMP2,TEMP3,MAXNXT,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
      ENDIF
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLLS')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1151)
 1151   FORMAT('AFTER COMPUTE SUMMARY STATISTICS--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1152)XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ
 1152   FORMAT('XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ = ',5G15.7,I10)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
C               *****************************************
C               **  STEP 21--                          **
C               **  CARRY OUT CALCULATIONS             **
C               **  FOR LOST GAMES MLE ESTIMATION      **
C               *****************************************
C
 2100 CONTINUE
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLLS')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      RHAT=XMIN
      PHAT=XMEAN/(2.0*XMEAN - RHAT)
C
C               ***********************************************
C               **   STEP 42--                               **
C               **   WRITE OUT EVERYTHING                    **
C               **   FOR LOST GAMES MLE ESTIMATION           **
C               ***********************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLNM')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     PRINT SUMMARY STATISTICS TABLE
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Lost Games Parameter Estimation'
      NCTITL=31
      ITITLZ=' '
      NCTITZ=0
C
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(NTOTZZ)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Maximum Likelihood Estimates:'
      NCTEXT(ICNT)=29
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of R:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=RHAT
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of P:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=PHAT
      IDIGIT(ICNT)=NUMDIG
C
      NUMROW=ICNT
      DO2310I=1,NUMROW
        NTOT(I)=15
 2310 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLLS')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLLS--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)RHAT,PHAT
 9012   FORMAT('RHAT,PHAT = ',2G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLMX(Y,N,ICASPL,
     1                  DTEMP1,MAXNXT,
     1                  ALOCMO,SCALMO,SCALSE,
     1                  ALOCML,SCALML,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR THE MAXWELL DISTRIBUTION.
C              NOTE THAT EITHER THE 1-PARAMETER CASE OR THE
C              2-PARAMETER CASE CAN BE REQUESTED.  CURRENTLY, ONLY
C              MOMENT ESTIMATES ARE GENERATED FOR 2-PARAMETER CASE.
C     EXAMPLE--MAXWELL MAXIMUM LIKELIHOOD Y
C              1-PARAMETER MAXWELL MAXIMUM LIKELIHOOD Y
C     REFERENCE--COHEN AND WHITTEN (1988), "PARAMETER ESTIMATION IN
C                RELIABILITY AND LIFE SPAN MODELS", MARCEL DEKKER, INC.,
C                CHAPTER 10.
C              --"CONTINUOUS UNIVARIATE DISTRIBUTIONS--VOLUME 1",
C                SECOND EDITION, JOHNSON, KOTZ, AND BALAKRISHNAN,
C                WILEY, 1994, P. 453.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004/6
C     ORIGINAL VERSION--JUNE      2004.
C     UPDATED         --JULY      2010. EXTRACT ESTIMATION TO
C                                       SEPARATE SUBROUTINE
C     UPDATED         --JULY      2010. CALL DPDTA1 TO PRINT OUTPUT
C                                       (THIS ALSO ADDS RTF FORMAT
C                                       OUTPUT)
C     UPDATED         --JULY      2010. ADD LIKELIHOOD/AIC TO OUTPUT
C     UPDATED         --JULY      2010. DISTINGUISH BETWEEN 1-PARAMETER
C                                       2-PARAMETER CASES
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*4 ICASE
      CHARACTER*4 INORM
      CHARACTER*4 ILIKFL
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DOUBLE PRECISION DTEMP1(*)
C
      PARAMETER (NUMALP=6)
      DIMENSION ALPHA(NUMALP)
      DIMENSION ALOWLO(NUMALP)
      DIMENSION AUPPLO(NUMALP)
      DIMENSION ALOWSC(NUMALP)
      DIMENSION AUPPSC(NUMALP)
      DIMENSION QP(1)
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=30)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*40 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(NUMALP)
      CHARACTER*4  VALIGN(NUMALP)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA ALPHA /0.50, 0.25, 0.10, 0.05, 0.01, 0.001/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='MX  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLMX')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLMX--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N
   52   FORMAT('IBUGA3,ISUBRO,N = ',A4,2X,A4,2X,G15.7)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLMX')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NPERC=0
      NMIN=2
      CALL CKDIST(Y,N,NMIN,QP,NPERC,ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C               **************************************
C               **  STEP 21--                       **
C               **  CARRY OUT CALCULATIONS FOR      **
C               **  MAXWELL MLE (FULL SAMPLE CASE)  **
C               **************************************
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLMX')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IERROR='NO'
      IWRITE='OFF'
C
      ICASE='2'
      IF(ICASPL.EQ.'1MAX')ICASE='1'
      CALL MAXML1(Y,N,ICASE,
     1            DTEMP1,
     1            XMEAN,XSD,XMIN,XMAX,
     1            ALOCML,SCALML,SCALSE,
     1            ALOCMO,SCALMO,
     1            ISUBRO,IBUGA3,IERROR)
      IF(ICASPL.EQ.'1MAX')THEN
        ALOCML=0.0
        CALL MAXLI1(Y,N,ICASE,
     1              ALOCML,SCALML,
     1              ALIK,AIC,AICC,BIC,
     1              ISUBRO,IBUGA3,IERROR)
        CALL MAXLI1(Y,N,ICASE,
     1              ALOCML,SCALMO,
     1              ALIKMO,AICMO,AICCMO,BICMO,
     1              ISUBRO,IBUGA3,IERROR)
      ELSE
CCCCC   CALL MAXLI1(Y,N,ICASE,
CCCCC1              ALOCML,SCALML,
CCCCC1              ALIK,AIC,AICC,BIC,
CCCCC1              ISUBRO,IBUGA3,IERROR)
        CALL MAXLI1(Y,N,ICASE,
     1              ALOCMO,SCALMO,
     1              ALIKMO,AICMO,AICCMO,BICMO,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
C
      IF(ICASPL.EQ.'1MAX')THEN
        NU=2*N
        DTERM1=DBLE(N)*2.0D0*DBLE(SCALML)**2
        DO2120I=1,NUMALP
          ALP=ALPHA(I)
          P=1.0-(ALP/2.0)
          CALL CHSPPF(P,NU,PPF1)
          P=ALP/2.0
          CALL CHSPPF(P,NU,PPF2)
          ALOWSC(I)=SQRT(REAL(DTERM1)/PPF1)
          AUPPSC(I)=SQRT(REAL(DTERM1)/PPF2)
 2120   CONTINUE
      ENDIF
C
C               *************************************
C               **   STEP 42--                     **
C               **   WRITE OUT EVERYTHING          **
C               **   FOR MAXWELL MLE ESTIMATE      **
C               *************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLMX')
     1  CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      IF(ICASPL.EQ.'1MAX')THEN
        ITITLE='1-Parameter Maxwell Parameter Estimation'
        NCTITL=40
      ELSE
        ITITLE='2-Parameter Maxwell Parameter Estimation'
        NCTITL=40
      ENDIF
      ITITLZ=' '
      NCTITZ=0
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(N)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Moments:'
      NCTEXT(ICNT)=8
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      IF(ICASPL.EQ.'MAXW')THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of Location:'
        NCTEXT(ICNT)=21
        AVALUE(ICNT)=ALOCMO
        IDIGIT(ICNT)=NUMDIG
      ENDIF
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Scale:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=SCALMO
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Log-likelihood:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=ALIKMO
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)='AIC:'
      NCTEXT(ICNT)=4
      AVALUE(ICNT)=AICMO
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)='AICc:'
      NCTEXT(ICNT)=5
      AVALUE(ICNT)=AICCMO
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)='BIC:'
      NCTEXT(ICNT)=4
      AVALUE(ICNT)=BICMO
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      IF(ICASPL.EQ.'1MAX')THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='Maximum Likelihood:'
        NCTEXT(ICNT)=19
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
C
CCCCC   ICNT=ICNT+1
CCCCC   ITEXT(ICNT)='Estimate of Location:'
CCCCC   NCTEXT(ICNT)=21
CCCCC   AVALUE(ICNT)=ALOCML
CCCCC   IDIGIT(ICNT)=NUMDIG
C
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of Scale:'
        NCTEXT(ICNT)=18
        AVALUE(ICNT)=SCALML
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Standard Error of Scale:'
        NCTEXT(ICNT)=24
        AVALUE(ICNT)=SCALSE
        IDIGIT(ICNT)=NUMDIG
C
        ICNT=ICNT+1
        ITEXT(ICNT)='Log-likelihood:'
        NCTEXT(ICNT)=15
        AVALUE(ICNT)=ALIK
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='AIC:'
        NCTEXT(ICNT)=4
        AVALUE(ICNT)=AIC
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='AICc:'
        NCTEXT(ICNT)=5
        AVALUE(ICNT)=AICC
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='BIC:'
        NCTEXT(ICNT)=4
        AVALUE(ICNT)=BIC
        IDIGIT(ICNT)=-7
      ENDIF
C
      NUMROW=ICNT
      DO2320I=1,NUMROW
        NTOT(I)=15
 2320 CONTINUE
C
      IFRST=.FALSE.
      ILAST=.FALSE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
      IF(NUMOUT.GT.1 .AND. ICASPL.EQ.'1MAX')THEN
        INORM='OFF'
        ALOWLO(1)=CPUMIN
        CALL DPDTA7(ALOWLO,AUPPLO,ALOWSC,AUPPSC,ALPHA,NUMALP,
     1              ICAPSW,ICAPTY,NUMDIG,INORM,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLMX')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLMX--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012   FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9015)N
 9015   FORMAT('N = ',I8)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLLX(Y,N,
     1XTEMP,DTEMP,ITEMP,MAXNXT,
     1SCALSV,SHAPSV,
     1SCALML,SCALSE,SHAPML,SHAPSE,COVSE,
     1ICAPSW,ICAPTY,IFORSW,
     1ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR THE LOGISTIC-EXPONENTIAL DISTRIBUTION
C              FOR THE FULL SAMPLE CASE.
C     NOTE--THE MAXIMIUM LIKELIHOOD ESTIMATES ARE THE SOLUTIONS
C           TO THE FOLLOWING EQUATIONS:
C
C             (N/BETA) + SUM[i=1 to N][LOG(EXP(ALPHA*X(i)) - 1) -
C             2*SUM[i=1 to N][(EXP(ALPHA*X(I) - 1)**BETA*
C             LOG(EXP(ALPHA*X(i)) -1)/{1 + (EXP(ALPHA*X(i)) - 1)**BETA}
C             = 0
C
C             (N/ALPHA) + SUM[i=1 to N][(BETA-1)*X(i)*EXP(ALPHA*X(i))/
C             (EXP(ALHA*X(i)) - 1) + SUM[i=1 to N][X(i)] -
C             2*SUM[i=1 to N][BETA*(EXP(ALPHA*X(I) - 1)**(BETA - 1)*
C             X9I)*EXP(ALPHA*X(i))/{1 + (EXP(ALPHA*X(i)) - 1)**BETA}
C             = 0
C
C           WHERE
C
C             BETA     = SHAPE PARAMETER
C             ALPHA    = SCALE PARAMETER
C
C     EXAMPLE--LOGISTIC-EXPONENTIAL MAXIMUM LIKELIHOOD Y
C     REFERENCE--LEEMIS AND MCQUESTION (2008), "UNIVARIATE DISTRIBUTION
C                RELATIONSHIPS", THE AMERICAN STATISTICIAN, VOL. 62,
C                NO. 1, PP. 45-53.
C              --LAN AND LEEMIS (2007), "THE LOGISTIC-EXPONENTIAL
C                SURVIVAL DISTRIBUTION", TECHNICAL REPORT, THE
C                COLLEGE OF WILLIAM AND MARY, DEPARTMENT OF
C                MATHEMATICS.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2008/2
C     ORIGINAL VERSION--FEBRUARY  2008.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      PARAMETER (NUMALP=6)
      DIMENSION ALPHA(NUMALP)
      DIMENSION ALOWSC(NUMALP)
      DIMENSION AUPPSC(NUMALP)
      DIMENSION ALOWBE(NUMALP)
      DIMENSION AUPPBE(NUMALP)
C
      DIMENSION QP(1)
      DIMENSION FISH(2,2)
      DIMENSION COV(2,2)
C
      DIMENSION Y(*)
      DIMENSION XTEMP(*)
      DOUBLE PRECISION DTEMP(*)
      INTEGER ITEMP(*)
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=10)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 ITEXT(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA ALPHA /0.50, 0.25, 0.10, 0.05, 0.01, 0.001/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='LX  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLLX')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLLX--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N
   52   FORMAT('IBUGA3,ISUBRO,N = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)N,SCALSV,SHAPSV
   55   FORMAT('N,SCALSV,SHAPSV = ',I8,2G15.7)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               *************************************
C               **  STEP 21--                      **
C               **  CARRY OUT CALCULATIONS         **
C               **  FOR LOGISTIC-EXPONENTIAL MLE   **
C               **  ESTIMATE (FULL SAMPLE CASE)    **
C               *************************************
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLLX')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NMIN=3
      NPERC=0
      CALL CKDIST(Y,N,NMIN,QP,NPERC,ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      CALL LEXML1(Y,N,MAXNXT,
     1            XTEMP,DTEMP,
     1            XMEAN,XSD,XVAR,XMIN,XMAX,XSUM,
     1            SCALSV,SHAPSV,SCALML,SHAPML,
     1            ISUBRO,IBUGA3,IERROR)
C
C  COMPUTE STANDARD ERRORS
C
CCCCC DN=DBLE(N)
CCCCC DALPHA=XPAR(2)
CCCCC DBETA=DBLE(BETAML)
C
CCCCC DSUM1=0.0D0
CCCCC DSUM2=0.0D0
CCCCC DO2160I=1,N
C
CCCCC   DX=DBLE(Y(I))
CCCCC   DA=DLOG(DX)
CCCCC   DB=(DALPHA*DX)**DBETA
CCCCC   DC=DLOG(DALPHA*DX)
C
CCCCC   DTERM1=(DC**2)*DB
CCCCC   DSUM1=DSUM1 + DTERM1*(DB+1.0D0)*DEXP(DB)
CCCCC   DSUM2=DSUM2 + DTERM1
C
 2160 CONTINUE
C
CCCCC DTERM1=-DN/DBETA**2
CCCCC FISH(1,1)=-REAL(DTERM1 - DSUM1 + DSUM2)
C
CCCCC DSUM1=0.0D0
CCCCC DSUM2=0.0D0
CCCCC DO2170I=1,N
C
CCCCC   DX=DBLE(Y(I))
CCCCC   DA=DLOG(DX)
CCCCC   DB=(DALPHA*DX)**DBETA
CCCCC   DC=DLOG(DALPHA*DX)
C
CCCCC   DSUM1=DSUM1 + DEXP(DB)*((DBETA-1.0D0)*DB + DB**2*DBETA)
CCCCC   DSUM2=DSUM2 + DB
C
 2170 CONTINUE
C
CCCCC DTERM1=-DBETA*DN/DALPHA**2
CCCCC DTERM2=DBETA/DALPHA**2
CCCCC DTERM3=DBETA*(DBETA-1.0D0)/DALPHA**2
CCCCC FISH(2,2)=-REAL(DTERM1 - DTERM2*DSUM1 + DTERM3*DSUM2)
C
CCCCC DSUM1=0.0D0
CCCCC DSUM2=0.0D0
CCCCC DO2180I=1,N
C
CCCCC   DX=DBLE(Y(I))
CCCCC   DA=DLOG(DX)
CCCCC   DB=(DALPHA*DX)**DBETA
CCCCC   DC=DLOG(DALPHA*DX)
C
CCCCC   DSUM1=DSUM1 + DB*DEXP(DB)*(1.0D0 + DBETA*DLOG(DALPHA) + 
CCCCC1                DBETA*DA + DBETA*DB*DC)
CCCCC   DSUM2=DSUM2 + DB*(1.0D0 + DBETA*DLOG(DALPHA) + DBETA*DA)
C
 2180 CONTINUE
C
CCCCC DTERM1=DN/DALPHA
CCCCC DTERM2=1.0D0/DALPHA
CCCCC FISH(1,2)=-REAL(DTERM1 - DTERM2*DSUM1 + DTERM2*DSUM2)
CCCCC FISH(2,1)=FISH(1,2)
C
CCCCC CALL SGECO(FISH,2,2,ITEMP,RCOND,XTEMP)
CCCCC IJOB=1
CCCCC CALL SGEDI(FISH,2,2,ITEMP,XTEMP,XTEMP(MAXNXT/2),IJOB)
CCCCC DO2810J=1,3
CCCCC   DO2815I=1,3
CCCCC     COV(I,J)=FISH(I,J)
 2815   CONTINUE
 2810 CONTINUE
C
CCCCC BETASE=SQRT(COV(1,1))
CCCCC ALPHSE=SQRT(COV(2,2))
CCCCC COVSE=COV(2,1)
C
C  CONFIDENCE INTERVALS FOR PARAMETERS BASED ON NORMAL
C  APPROXIMATION.
C
CCCCC DO2220I=1,NUMALP
CCCCC   ALP=ALPHA(I)
CCCCC   P=1.0-(ALP/2.0)
CCCCC   CALL NORPPF(P,PPF)
CCCCC   ALOWSC(I)=ALPHML - PPF*ALPHSE
CCCCC   AUPPSC(I)=ALPHML + PPF*ALPHSE
CCCCC   ALOWBE(I)=BETAML - PPF*BETASE
CCCCC   AUPPBE(I)=BETAML + PPF*BETASE
 2220 CONTINUE
C
C               ***********************************************
C               **   STEP 42--                              **
C               **   WRITE OUT EVERYTHING                   **
C               **   FOR LOGISTIC-EXPONENTIAL MLE ESTIMATE  **
C               **********************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLLX')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     PRINT SUMMARY STATISTICS TABLE
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Two-Parameter Logistic Exponential Parameter Estimation'
      NCTITL=55
      ITITLZ='Full Sample Case'
      NCTITZ=16
      ITEXT(1)='Summary Statistics:'
      NCTEXT(1)=19
      AVALUE(1)=0.0
      IDIGIT(1)=0
      ITEXT(2)='Number of Observations:'
      NCTEXT(2)=23
      AVALUE(2)=REAL(N)
      IDIGIT(2)=0
      ITEXT(3)='Sample Mean:'
      NCTEXT(3)=12
      AVALUE(3)=XMEAN
      IDIGIT(3)=NUMDIG
      ITEXT(4)='Sample Standard Deviation:'
      NCTEXT(4)=26
      AVALUE(4)=XSD
      IDIGIT(4)=NUMDIG
      ITEXT(5)='Sample Minimum:'
      NCTEXT(5)=15
      AVALUE(5)=XMIN
      IDIGIT(5)=NUMDIG
      ITEXT(6)='Sample Maximum:'
      NCTEXT(6)=15
      AVALUE(6)=XMAX
      IDIGIT(6)=NUMDIG
      NUMROW=6
      DO2310I=1,NUMROW
        NTOT(I)=15
 2310 CONTINUE
      NTOT(2)=8
C
      IFRST=.TRUE.
      ILAST=.FALSE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,
     1            NCTEXT,AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
      IFRST=.FALSE.
      ITITLE=' '
      NCTITL=0
C
      ITEXT(1)='Maximum Likelihood:'
      NCTEXT(1)=19
      AVALUE(1)=0.0
      IDIGIT(1)=-1
      ITEXT(2)='Estimate of Shape (Beta):'
      NCTEXT(2)=25
      AVALUE(2)=SHAPML
      IDIGIT(2)=NUMDIG
      ITEXT(3)='Estimate of Scale:'
      NCTEXT(3)=18
      AVALUE(3)=SCALML
      IDIGIT(3)=NUMDIG
C
      ICNT=3
C
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='Log-likelihood:'
CCCCC NCTEXT(ICNT)=15
CCCCC AVALUE(ICNT)=ALIK
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=AIC
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AICc:'
CCCCC NCTEXT(ICNT)=5
CCCCC AVALUE(ICNT)=AICC
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='BIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=BIC
CCCCC IDIGIT(ICNT)=-7
C
      NUMROW=ICNT
      DO2320I=1,NUMROW
        NTOT(I)=15
 2320 CONTINUE
C
      IFRST=.FALSE.
      ILAST=.FALSE.
      ITITLZ=' '
      NCTITZ=0
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLLX')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLLX--')
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLN1(Y,N,ICASE,
     1QP,XQPHAT,XQPSE,XQPLCL,XQPUCL,NPERC,
     1XMEAN,XSD,XSDMEA,XSDSD,
     1AIC,AICC,BIC,ALIKE,
     1ICAPSW,ICAPTY,IFORSW,
     1IOUNI1,IOUNI2,ALPHAP,
     1ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR NORMAL DISTRIBUTION.  THIS SUBROUTINE
C              COMPUTES THE UNGROUPED AND UNCENSORED CASE.
C     EXAMPLE--NORMAL MAXIMUM LIKELIHOOD Y
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN ENGINEERING",
C                CAMBRIDGE UNIVERSITY PRESS, 1999, CHAPTER 10.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2009/8
C     ORIGINAL VERSION--AUGUST    2009. EXTRACTED FROM DPMLNO
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ILIKFL
      CHARACTER*4 INORM
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*1 IBASLC
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION QP(*)
      DIMENSION XQPHAT(*)
      DIMENSION XQPSE(*)
      DIMENSION XQPLCL(*)
      DIMENSION XQPUCL(*)
C
      PARAMETER (NUMALP=6)
      DIMENSION ALPHA(NUMALP)
      DIMENSION ALOWSC(NUMALP)
      DIMENSION AUPPSC(NUMALP)
      DIMENSION ALOWLO(NUMALP)
      DIMENSION AUPPLO(NUMALP)
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=50)
      CHARACTER*60 ITITLE
      CHARACTER*1  ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 ITEXT(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA ALPHA /0.50, 0.25, 0.10, 0.05, 0.01, 0.001/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='N1  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLN1')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLN1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3
   52   FORMAT('IBUGA3 = ',A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)N,NUMV,NPERC
   55   FORMAT('N,NUMV,NPERC = ',3I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
        IF(NPERC.GT.0)THEN
          DO66I=1,NPERC
            WRITE(ICOUT,67)I,QP(I)
   67       FORMAT('I,QP(I) = ',I8,G15.7)
            CALL DPWRST('XXX','WRIT')
   66     CONTINUE
        ENDIF
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLN1')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NMIN=2
      CALL CKDIST(Y,N,NMIN,QP,NPERC,ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C               ******************************
C               **  STEP 2--                **
C               **  CARRY OUT CALCULATIONS  **
C               **  FOR NORMAL MLE ESTIMATE **
C               ******************************
C
      ISTEPN='2'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLN1')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IERROR='NO'
      IWRITE='OFF'
      AN=REAL(N)
C
      CALL NORML1(Y,N,ICASE,
     1            ALOWLO,AUPPLO,ALOWSC,AUPPSC,ALPHA,NUMALP,NUMOUT,
     1            XMEAN,XSD,XVAR,XMIN,XMAX,XSDMEA,XSDSD,
     1            ISUBRO,IBUGA3,IERROR)
C
      CALL NORLI1(Y,N,XMEAN,XSD,
     1            ALIK,AIC,AICC,BIC,
     1            ISUBRO,IBUGA3,IERROR)
C
C               **********************************************
C               **  STEP 3--                                **
C               **  ESTIMATE CONFIDENCE LIMITS FOR SELECTED **
C               **  PERCENTILES.  FOR FULL SAMPLE CASE,     **
C               **  PERCENTILE ESTIMATES BASED ON           **
C               **  NON-CENTRAL T DISTRIBUTION.             **
C               **********************************************
C
      ISTEPN='3'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLN1')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NPERC.GE.1)THEN
C
        CALL NORPE1(Y,N,NPERC,XMEAN,XSD,IOUNI1,
     1              QP,XQPHAT,XQPLCL,XQPUCL,
     1              ALPHAP,NUMALP,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
C
C               *********************************
C               **   STEP 42--                 **
C               **   WRITE OUT EVERYTHING      **
C               **   FOR NORMAL MLE ESTIMATE   **
C               **********************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLN1')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     PRINT SUMMARY STATISTICS TABLE
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Normal Parameter Estimation'
      NCTITL=27
      ITEXT(1)='Summary Statistics:'
      NCTEXT(1)=19
      AVALUE(1)=0.0
      IDIGIT(1)=-1
      ITEXT(2)='Number of Observations:'
      NCTEXT(2)=23
      AVALUE(2)=REAL(N)
      IDIGIT(2)=0
      ITEXT(3)='Sample Minimum:'
      NCTEXT(3)=15
      AVALUE(3)=XMIN
      IDIGIT(3)=NUMDIG
      ITEXT(4)='Sample Maximum:'
      NCTEXT(4)=15
      AVALUE(4)=XMAX
      IDIGIT(4)=NUMDIG
      NUMROW=4
      DO2310I=1,NUMROW
        NTOT(I)=15
 2310 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      NCTITZ=0
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,
     1            NCTEXT,AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
      IFRST=.FALSE.
      ITITLE=' '
      NCTITL=0
C
      ITEXT(1)='Maximum Likelihood:'
      NCTEXT(1)=19
      AVALUE(1)=0.0
      IDIGIT(1)=-1
      ITEXT(2)='Estimate of Location (Mean):'
      NCTEXT(2)=28
      AVALUE(2)=XMEAN
      IDIGIT(2)=NUMDIG
      ITEXT(3)='Standard Error of Location:'
      NCTEXT(3)=27
      AVALUE(3)=XSDMEA
      IDIGIT(3)=NUMDIG
      ICNT=3
      ITEXT(4)='Estimate of Scale (SD):'
      NCTEXT(4)=28
      AVALUE(4)=XSD
      IDIGIT(4)=NUMDIG
      ITEXT(5)='Standard Error of Scale:'
      NCTEXT(5)=24
      AVALUE(5)=XSDSD
      IDIGIT(5)=NUMDIG
      ICNT=5
      ICNT=ICNT+1
      ITEXT(ICNT)='Log-likelihood:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=ALIK
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)='AIC:'
      NCTEXT(ICNT)=4
      AVALUE(ICNT)=AIC
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)='AICc:'
      NCTEXT(ICNT)=5
      AVALUE(ICNT)=AICC
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)='BIC:'
      NCTEXT(ICNT)=4
      AVALUE(ICNT)=BIC
      IDIGIT(ICNT)=-7
      NUMROW=ICNT
      DO2320I=1,NUMROW
        NTOT(I)=15
 2320 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      NCTITZ=0
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
      IF(NUMOUT.GT.1)THEN
        INORM='YES'
        CALL DPDTA7(ALOWLO,AUPPLO,ALOWSC,AUPPSC,ALPHA,NUMALP,
     1              ICAPSW,ICAPTY,NUMDIG,INORM,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
C
      IF(NPERC.GT.1)THEN
        ILIKFL='OFF'
        XQPSE(1)=CPUMIN
        CALL DPDTA9(QP,XQPHAT,XQPLCL,XQPUCL,XQPSE,NPERC,
     1              ICAPSW,ICAPTY,ILIKFL,NUMDIG,ALPHAP,
     1              ISUBRO,IBUGA3,IERROR)
      
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLN1')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLN1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012   FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLN2(Y,X,N,
     1                  XTEMP,DTEMP1,ITEMP1,MAXNXT,
     1                  QP,XQPHAT,XQPSE,XQPLCL,XQPUCL,NPERC,
     1                  XMEAN,XSD,
     1                  AIC,AICC,BIC,ALIKE,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  IOUNI1,IOUNI2,ALPHAP,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR NORMAL DISTRIBUTION.  THIS SUBROUTINE
C              COMPUTES THE UNGROUPED AND MULTIPLY RIGHT CENSORED
C              CASE.
C     EXAMPLE--NORMAL MAXIMUM LIKELIHOOD Y X
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN ENGINEERING",
C                CAMBRIDGE UNIVERSITY PRESS, 1999, CHAPTER 10.
C              --CLIFFORD COHEN, "TRUNCATED AND CENSORED SAMPLES:
C                THEORY AND APPLICATIONS", DEKKER, 1991.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2009/8
C     ORIGINAL VERSION--SEPTEMBER 2009. EXTRACTED FROM DPMLNO
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ILIKFL
      CHARACTER*4 INORM
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*1 IBASLC
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION XTEMP(*)
      DIMENSION QP(*)
      DIMENSION XQPHAT(*)
      DIMENSION XQPSE(*)
      DIMENSION XQPLCL(*)
      DIMENSION XQPUCL(*)
      INTEGER          ITEMP1(*)
      DOUBLE PRECISION DTEMP1(*)
C
      PARAMETER (NUMALP=6)
      DIMENSION ALPHA(NUMALP)
      DIMENSION ALOWSC(NUMALP)
      DIMENSION AUPPSC(NUMALP)
      DIMENSION ALOWLO(NUMALP)
      DIMENSION AUPPLO(NUMALP)
C
      DIMENSION COV(2,2)
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=50)
      CHARACTER*60 ITITLE
      CHARACTER*1  ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(NUMALP)
      CHARACTER*4  VALIGN(NUMALP)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA ALPHA /0.50, 0.25, 0.10, 0.05, 0.01, 0.001/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='N2  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLN2')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLN2--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3
   52   FORMAT('IBUGA3 = ',A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)N,NUMV,NPERC
   55   FORMAT('N,NUMV,NPERC = ',3I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I),X(I)
   57     FORMAT('I,Y(I),X(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
        IF(NPERC.GT.0)THEN
          DO66I=1,NPERC
            WRITE(ICOUT,67)I,QP(I)
   67       FORMAT('I,QP(I) = ',I8,G15.7)
            CALL DPWRST('XXX','WRIT')
   66     CONTINUE
        ENDIF
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLN2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NMIN=2
      CALL CKDIST(Y,N,NMIN,QP,NPERC,ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C               ******************************
C               **  STEP 2--                **
C               **  CARRY OUT CALCULATIONS  **
C               **  FOR NORMAL MLE ESTIMATE **
C               ******************************
C
      ISTEPN='2'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLN2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IERROR='NO'
      IWRITE='OFF'
      AN=REAL(N)
C
      CALL NORML2(Y,X,N,IR,
     1            XTEMP,DTEMP1,ITEMP1,MAXNXT,IOUNI2,
     1            ALOWLO,AUPPLO,ALOWSC,AUPPSC,ALPHA,NUMALP,NUMOUT,
     1            XMEAN,XSD,XVAR,XMIN,XMAX,XSDMEA,XSDSD,XCOV,COV,
     1            ISUBRO,IBUGA3,IERROR)
C
      CALL NORLI2(Y,X,N,IR,XMEAN,XSD,
     1            ALIK,AIC,AICC,BIC,
     1            ISUBRO,IBUGA3,IERROR)
C
C               **********************************************
C               **  STEP 3--                                **
C               **  ESTIMATE CONFIDENCE LIMITS FOR SELECTED **
C               **  PERCENTILES.                            **
C               **********************************************
C
      ISTEPN='3'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLN2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NPERC.GE.1)THEN
C
        CALL NORPE2(Y,X,N,IR,NPERC,
     1              XMEAN,XSD,COV,IOUNI1,
     1              QP,XQPHAT,XQPLCL,XQPUCL,
     1              ALPHAP,NUMALP,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
C
C               **************************************
C               **   STEP 42--                      **
C               **   WRITE OUT EVERYTHING FOR       **
C               **   CENSORED NORMAL MLE ESTIMATE   **
C               **************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLN2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     PRINT SUMMARY STATISTICS TABLE
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Normal Parameter Estimation: Multiply Censored Case'
      NCTITL=51
      ITEXT(1)='Summary Statistics:'
      NCTEXT(1)=19
      AVALUE(1)=0.0
      IDIGIT(1)=-1
      ITEXT(2)='Total Number of Observations:'
      NCTEXT(2)=29
      AVALUE(2)=REAL(N)
      IDIGIT(2)=0
      ITEXT(3)='Number of Failure Times:'
      NCTEXT(3)=24
      AVALUE(3)=REAL(IR)
      IDIGIT(3)=0
      ITEXT(4)='Number of Censoring Times:'
      NCTEXT(4)=26
      AVALUE(4)=REAL(N-IR)
      IDIGIT(4)=0
      ITEXT(5)='Sample Minimum:'
      NCTEXT(5)=15
      AVALUE(5)=XMIN
      IDIGIT(5)=NUMDIG
      ITEXT(6)='Sample Maximum:'
      NCTEXT(6)=15
      AVALUE(6)=XMAX
      IDIGIT(6)=NUMDIG
      ITEXT(7)='Sample Mean of Failure Times:'
      NCTEXT(7)=29
      AVALUE(7)=XMEAN
      IDIGIT(7)=NUMDIG
      ITEXT(8)='Sample SD of Failure Times:'
      NCTEXT(8)=27
      AVALUE(8)=XSD
      IDIGIT(8)=NUMDIG
      NUMROW=8
      DO2310I=1,NUMROW
        NTOT(I)=15
 2310 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.FALSE.
      NCTITZ=0
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
      IFRST=.FALSE.
      ITITLE=' '
      NCTITL=0
C
      ITEXT(1)='Maximum Likelihood:'
      NCTEXT(1)=19
      AVALUE(1)=0.0
      IDIGIT(1)=0
      ITEXT(2)='Estimate of Location:'
      NCTEXT(2)=28
      AVALUE(2)=XMEAN
      IDIGIT(2)=NUMDIG
      ITEXT(3)='Standard Error of Location:'
      NCTEXT(3)=27
      AVALUE(3)=XSDMEA
      IDIGIT(3)=NUMDIG
      ICNT=3
      ITEXT(4)='Estimate of Scale (SD):'
      NCTEXT(4)=28
      AVALUE(4)=XSD
      IDIGIT(4)=NUMDIG
      ITEXT(5)='Standard Error of Scale:'
      NCTEXT(5)=24
      AVALUE(5)=XSDSD
      IDIGIT(5)=NUMDIG
      ITEXT(6)='Covariance:'
      NCTEXT(6)=11
      AVALUE(6)=XCOV
      IDIGIT(6)=NUMDIG
      ICNT=6
      ICNT=ICNT+1
      ITEXT(ICNT)='Log-likelihood:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=ALIK
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)='AIC:'
      NCTEXT(ICNT)=4
      AVALUE(ICNT)=AIC
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)='AICc:'
      NCTEXT(ICNT)=5
      AVALUE(ICNT)=AICC
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)='BIC:'
      NCTEXT(ICNT)=4
      AVALUE(ICNT)=BIC
      IDIGIT(ICNT)=-7
      NUMROW=ICNT
      DO2320I=1,NUMROW
        NTOT(I)=15
 2320 CONTINUE
C
      IFRST=.FALSE.
      ILAST=.FALSE.
      NCTITZ=0
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
      IF(NUMOUT.GT.1)THEN
        INORM='YES'
        CALL DPDTA7(ALOWLO,AUPPLO,ALOWSC,AUPPSC,ALPHA,NUMALP,
     1              ICAPSW,ICAPTY,NUMDIG,INORM,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
C
      IF(NPERC.GT.1)THEN
        ILIKFL='OFF'
        XQPSE(1)=CPUMIN
        CALL DPDTA9(QP,XQPHAT,XQPLCL,XQPUCL,XQPSE,NPERC,
     1              ICAPSW,ICAPTY,ILIKFL,NUMDIG,ALPHAP,
     1              ISUBRO,IBUGA3,IERROR)
      
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLN2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLN2--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012   FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLNB(Y,X,N,NVAR,
     1                  AK,AKSV,PSV,
     1                  XTEMP,TEMP2,TEMP3,DTEMP,ITEMP1,MAXNXT,
     1                  PMOM,AKMOM,PML,PMLBC,PMLBCV,AKML,
     1                  PSE,AKSE,COV,
     1                  AIC,AICC,BIC,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  IDIST2,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES AND METHOD OF MOMENT ESTIMATES FOR
C              NEGATIVE BINOMIAL DISTRIBUTION.  THE METHOD OF
C              MOMENT ESTIMATES ARE:
C                 PHAT = XBAR/S**2
C                 KHAT = XBAR**2/(S**2 - XBAR)
C              WITH XBAR AND S**2 DENOTING THE SAMPLE MEAN AND
C              VARIANCE, RESPECTIVELY.  THE MAXIMUM LIKELIHOOD
C              ESTIMATE OF P (ASSUMING K IS KNOWN) IS:
C                  PHAT = XBAR/(K + XBAR)
C              FOR THE K UNKNOWN CASE, WE USE THE METHOD GIVEN
C              IN THE BURY REFERENCE.
C     EXAMPLE--NEGATIVE BINOMIAL MAXIMUM LIKELIHOOD Y
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN ENGINEERING",
C                CAMBRIDGE UNIVERSITY PRESS, 1999, CHAPTER 10.
C              --JOHNSON, KEMP, AND KOTZ.  "UNIVARIATE DISCRETE
C                DISTRIBUTIONS", THIRD EDITION, WILEY, 2005, CHAPTER 5.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004/3
C     ORIGINAL VERSION--MARCH     2004.
C     UPDATED         --AUGUST    2005. REFORMAT OUTPUT FOR
C                                       CONSISTENCY WITH OTHER ML
C                                       ROUTINES
C     UPDATED         --MARCH     2009. CORRECT METHOD OF MOMENTS
C                                       FORMULA, ALSO CHECK THAT
C                                       S**2 > XBAR
C     UPDATED         --MARCH     2009. MODULARIZE THE CODE
C                                       (CREATE SUBROUTINES FOR
C                                       THE ESTIMATION AND PRINT
C                                       TABLE OUTPUT USING SUBROUTINES)
C     UPDATED         --MARCH     2009. ALLOW USER-SPECIFIED STARTING
C                                       VALUES, ONLY DO K KNOWN OR
C                                       UNKNOWN CASE, BUT NOT BOTH
C     UPDATED         --MARCH     2009. INCLUDE SUPPORT FOR GROUPED
C                                       DATA
C     UPDATED         --JULY      2009. INCORPORATE GEOMETRIC CASE
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*17 IDIST2
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*1 IBASLC
C
      CHARACTER*40 IDIST
C
      PARAMETER (NUMALP=5)
      DIMENSION ALPHA(NUMALP)
      DIMENSION ALOWP1(NUMALP)
      DIMENSION AUPPP1(NUMALP)
      DIMENSION ALOWK1(NUMALP)
      DIMENSION AUPPK1(NUMALP)
C
      INTEGER IFLAG
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION XTEMP(*)
      DIMENSION TEMP2(*)
      DIMENSION TEMP3(*)
      DOUBLE PRECISION DTEMP(*)
      INTEGER          ITEMP1(*)
C
      DOUBLE PRECISION DTEMP2
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=15)
      CHARACTER*60 ITITLE
      CHARACTER*1  ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(NUMALP)
      CHARACTER*4  VALIGN(NUMALP)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
C
      PARAMETER(NUMCLI=3)
      PARAMETER(MAXLIN=2)
      CHARACTER*60 ITITL2(MAXLIN,NUMCLI)
      INTEGER      NCTIT2(MAXLIN,NUMCLI)
      INTEGER      IWHTML(NUMALP)
      INTEGER      IWRTF(NUMALP)
      REAL         AMAT(MAXROW,NUMCLI)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA ALPHA /0.50, 0.25, 0.10, 0.05, 0.01/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='NB  '
C
      IERROR='NO'
C
      PMOM=-99.0
      AKMOM=-99.0
      PML=-99.0
      PMLBC=-99.0
      PMLBCV=-99.0
      AKML2=-99.0
      PML2=-99.0
      PML2BC=-99.0
      ALIK=CPUMIN
      AIC=-99.0
      AICC=-99.0
      BIC=-99.0
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLNB')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLNB--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N,NVAR
   52   FORMAT('IBUGA3,ISUBRO,N,NVAR = ',2(A4,2X),2I8)
        CALL DPWRST('XXX','WRIT')
        IF(NVAR.EQ.1)THEN
          DO56I=1,MIN(N,100)
            WRITE(ICOUT,57)I,Y(I)
   57       FORMAT('I,Y(I) = ',I8,G15.7)
            CALL DPWRST('XXX','WRIT')
   56     CONTINUE
        ELSE
          DO61I=1,N
            WRITE(ICOUT,62)I,X(I),Y(I)
   62       FORMAT('I,X(I),Y(I) = ',I8,2G15.7)
            CALL DPWRST('XXX','WRIT')
   61     CONTINUE
        ENDIF
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  1) ROUND DATA TO INTEGER VALUES       **
C               **  2) COMPUTE SUMMARY STATISTICS         **
C               **  3) CHECK INPUT FOR NEGATIVE VALUES,   **
C               **     INSUFFICIENT SAMPLE SIZE           **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLNB')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IDIST=' '
      IDIST(1:17)=IDIST2(1:17)
C
      NPERC=0
      MAXGRP=MAXNXT/2
      NMIN=2
      IERROR='NO'
      IF(NVAR.EQ.1)THEN
        DO1105I=1,N
          ITEMP=INT(Y(I)+0.5)
          Y(I)=REAL(ITEMP)
 1105   CONTINUE
        CALL CKDIST(Y,N,NMIN,XTEMP,NPERC,ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
        IFLAG=1
        CALL SUMRAW(Y,N,IDIST,IFLAG,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        NTOTZZ=N
C
      ELSE
        CALL CKDIS2(Y,X,XTEMP,N,MAXGRP,NMIN,TEMP2,NPERC,NTOTZZ,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IFLAG1=1
        IFLAG2=1
        CALL SUMGRP(Y,X,N,IDIST,IFLAG1,IFLAG2,
     1              XTEMP,TEMP2,TEMP3,MAXNXT,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
      ENDIF
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLNB')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1151)
 1151   FORMAT('AFTER COMPUTE SUMMARY STATISTICS--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1152)XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ
 1152   FORMAT('XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ = ',5G15.7,I10)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      IF(IERROR.EQ.'YES')GOTO9000
C
C               ******************************************
C               **  STEP 21--                           **
C               **  CARRY OUT CALCULATIONS              **
C               **  FOR NEGATIVE BINOMIAL MLE ESTIMATE  **
C               ******************************************
C
 2100 CONTINUE
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLNB')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IERFLG=0
      IF(XVAR.LE.0.0)THEN
        IERFLG=1
      ELSE
        ARATIO=XMEAN/XVAR
        AMXRAT=0.97
        IF(ARATIO.GT.AMXRAT)THEN
          IERFLG=1
        ENDIF
      ENDIF
C
      IF(IERFLG.EQ.1 .AND. AK.GT.0.0)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2111)IDIST2
 2111   FORMAT('***** ERROR IN ',A17,' MAXIMUM LIKELIHOOD--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2123)ARATIO
 2123   FORMAT('      THE RATIO OF THE SAMPLE MEAN TO THE SAMPLE ',
     1         'VARIANCE (= ',G15.7,')')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2125)AMXRAT
 2125   FORMAT('      IS GREATER THAN ',F8.3,'.  THE MOMENT AND ')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2126)
 2126   FORMAT('      MAXIMUM LIKELIHOOD ESTIMATORS WILL NOT BE ',
     1         'COMPUTED.')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2127)
 2127   FORMAT('      A POISSON OR BINOMIAL MODEL MIGHT BE MORE ',
     1         'APPROPRIATE.')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2128)XMEAN
 2128   FORMAT('      THE SAMPLE MEAN     = ',G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2129)XVAR
 2129   FORMAT('      THE SAMPLE VARIANCE = ',G15.7)
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ELSEIF(IERFLG.EQ.1 .AND. AK.LE.0.0)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2141)IDIST2
 2141   FORMAT('***** WARNING IN ',A17,' MAXIMUM LIKELIHOOD--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2123)ARATIO
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2145)AMXRAT
 2145   FORMAT('      IS GREATER THAN ',F8.3,'.')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2127)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2128)XMEAN
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2129)XVAR
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      IF(AK.GT.0.0)THEN
        ICASE=1
        IF(IDIST2.EQ.'GEOMETRIC')THEN
          PML=1.0/(XMEAN+1.0)
          PMLVAR=PML*PML*(1.0-PML)/REAL(N)
          PMLBC=CPUMIN
          AN=REAL(N)
          DO2160I=1,NUMALP
C
            ALP=ALPHA(I)
            P1=ALP/2.0
            P2=1.0-(ALP/2.0)
C
            CALL NBPPF(DBLE(P1),DBLE(PML),DBLE(AN),DTEMP2)
            SL=DTEMP2
            CALL NBPPF(DBLE(P2),DBLE(PML),DBLE(AN),DTEMP2)
            SU=DTEMP2
            ALOWP1(I)=1.0/((SU/AN)+1.0)
            AUPPP1(I)=1.0/((SL/AN)+1.0)
 2160     CONTINUE
          NUMOUT=NUMALP
        ELSE
          CALL NBML2(NTOTZZ,XMEAN,XVAR,AK,
     1               ALOWP1,AUPPP1,ALPHA,NUMALP,NUMOUT,
     1               PML,PMLBC,PMLBCV,IERFLG,
     1               ISUBRO,IBUGA3,IERROR)
        ENDIF
C
        IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLNB')THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,2151)
 2151     FORMAT('AFTER COMPUTE ML (K KNOWN CASE)--')
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,2152)PML,PMLBC,PMLBCV,NUMALP
 2152     FORMAT('PML,PMLBC,PMLBCV,NUMALP = ',4G15.7,I5)
          CALL DPWRST('XXX','WRIT')
        ENDIF
C
        IF(IERFLG.GT.0)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,2111)IDIST2
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,2201)
 2201     FORMAT('      UNABLE TO COMPUTE THE MAXIMUM LIKELIHOOD ',
     1           'ESTIMATE FOR THE K KNOWN CASE.')
          CALL DPWRST('XXX','WRIT')
          IERROR='YES'
          GOTO9000
        ENDIF
C
        IF(NVAR.EQ.1)THEN
          PTEMP=PMLBC
          IF(PMLBCV.LE.0.0)PTEMP=PML
          CALL NBLIK1(Y,N,PTEMP,AK,
     1                ALIK,AIC,AICC,BIC,
     1                ISUBRO,IBUGA3,IERROR)
        ELSE
          PTEMP=PMLBC
          IF(PMLBCV.LE.0.0)PTEMP=PML
          CALL NBLIK2(Y,X,N,PTEMP,AK,
     1                ALIK,AIC,AICC,BIC,
     1                ISUBRO,IBUGA3,IERROR)
        ENDIF
C
      ELSEIF(AK.LT.0.0 .AND. NVAR.EQ.1)THEN
C
        ICASE=2
        AKMOM=XMEAN*XMEAN/(XVAR - XMEAN)
        PMOM=XMEAN/XVAR
        IF(AKSV.LE.0.0)AKSV=AKMOM
        IF(PSV.LE.0.0)PSV=PMOM
C
        CALL NBML1(Y,N,XMEAN,XVAR,PSV,AKSV,
     1             XTEMP,DTEMP,ITEMP1,MAXNXT,
     1             ALOWP1,AUPPP1,ALOWK1,AUPPK1,ALPHA,NUMALP,NUMOUT,
     1             AKML,PML,PMLBC,PSE,AKSE,COVSE,IERFLG,
     1             ISUBRO,IBUGA3,IERROR)
C
        IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLNB')THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,2251)
 2251     FORMAT('AFTER COMPUTE ML (K UNKNOWN CASE)--')
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,2252)PML,PMLBC,AKML
 2252     FORMAT('PML,PMLBC,AKML = ',3G15.7)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,2253)PMOM,AKMOM
 2253     FORMAT('PMOM,AKMOM = ',2G15.7)
          CALL DPWRST('XXX','WRIT')
        ENDIF
C
        IF(IERFLG.EQ.2)THEN
C
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,111)
  111     FORMAT('***** WARNING FROM NEGATIVE BINOMIAL MAXIMUM ',
     1           'LIKELIHOOD--')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,113)
  113     FORMAT('      ESTIMATE OF K MAY NOT BE COMPUTED TO ',
     1           'DESIRED TOLERANCE.')
          CALL DPWRST('XXX','BUG ')
        ELSEIF(IERFLG.EQ.3)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,111)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,123)
  123     FORMAT('      ESTIMATE OF K MAY BE NEAR A SINGULAR POINT.')
          CALL DPWRST('XXX','BUG ')
        ELSEIF(IERFLG.EQ.4)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2111)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,133)
  133     FORMAT('      APPROPRIATE BRACKETING INTERVAL NOT FOUND.')
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ELSEIF(IERFLG.EQ.5)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2111)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,143)
  143     FORMAT('      MAXIMUM ITERATIONS EXCEEDED.')
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ENDIF
C
        CALL NBLIK1(Y,N,PMLBC,AKML,
     1              ALIK,AIC,AICC,BIC,
     1              ISUBRO,IBUGA3,IERROR)
C
      ELSEIF(AK.LT.0.0 .AND. NVAR.EQ.2)THEN
C
        ICASE=2
        AKMOM=XMEAN*XMEAN/(XVAR - XMEAN)
        PMOM=XMEAN/XVAR
        IF(AKSV.LE.0.0)AKSV=AKMOM
        IF(PSV.LE.0.0)PSV=PMOM
C
        CALL NBML3(Y,X,N,XMEAN,XVAR,PSV,AKSV,
     1             XTEMP,DTEMP,ITEMP1,MAXNXT,
     1             ALOWP1,AUPPP1,ALOWK1,AUPPK1,ALPHA,NUMALP,NUMOUT,
     1             AKML,PML,PMLBC,PSE,AKSE,COVSE,IERFLG,
     1             ISUBRO,IBUGA3,IERROR)
C
        IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLNB')THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,2251)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,2252)PML,PMLBC,AKML
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,2253)PMOM,AKMOM
          CALL DPWRST('XXX','WRIT')
        ENDIF
C
        IF(IERFLG.EQ.2)THEN
C
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,111)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,113)
          CALL DPWRST('XXX','BUG ')
        ELSEIF(IERFLG.EQ.3)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,111)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,123)
          CALL DPWRST('XXX','BUG ')
        ELSEIF(IERFLG.EQ.4)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2111)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,133)
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ELSEIF(IERFLG.EQ.5)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2111)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,143)
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
C
        ELSEIF(IERFLG.EQ.5)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2111)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,153)
  153     FORMAT('      TOO MANY CLASSES.')
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ENDIF
C
        CALL NBLIK2(Y,X,N,PMLBC,AKML,
     1              ALIK,AIC,AICC,BIC,
     1              ISUBRO,IBUGA3,IERROR)
C
      ENDIF
C
C               ******************************************
C               **   STEP 3--                           **
C               **   WRITE OUT EVERYTHING               **
C               **   FOR NEGATIVE BINOMIAL MLE ESTIMATE **
C               ******************************************
C
      ISTEPN='3'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLNB')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     PRINT SUMMARY STATISTICS TABLE
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      IF(IDIST2.EQ.'GEOMETRIC')THEN
        ITITLE='Geometric Parameter Estimation'
        NCTITL=30
      ELSE
        ITITLE='Negative Binomial Parameter Estimation'
        NCTITL=38
      ENDIF
      ITEXT(1)='Summary Statistics:'
      NCTEXT(1)=19
      AVALUE(1)=0.0
      IDIGIT(1)=-1
      ITEXT(2)='Number of Observations:'
      NCTEXT(2)=23
      AVALUE(2)=REAL(NTOTZZ)
      IDIGIT(2)=0
      ITEXT(3)='Sample Mean:'
      NCTEXT(3)=12
      AVALUE(3)=XMEAN
      IDIGIT(3)=NUMDIG
      ITEXT(4)='Sample Variance:'
      NCTEXT(4)=16
      AVALUE(4)=XVAR
      IDIGIT(4)=NUMDIG
      ITEXT(5)='Sample Standard Deviation:'
      NCTEXT(5)=26
      AVALUE(5)=XSD
      IDIGIT(5)=NUMDIG
      ITEXT(6)='Sample Minimum:'
      NCTEXT(6)=15
      AVALUE(6)=XMIN
      IDIGIT(6)=NUMDIG
      ITEXT(7)='Sample Maximum:'
      NCTEXT(7)=15
      AVALUE(7)=XMAX
      IDIGIT(7)=NUMDIG
      NUMROW=7
      DO2310I=1,NUMROW
        NTOT(I)=15
 2310 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.FALSE.
      NCTITZ=0
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
      IFRST=.FALSE.
      ITITLE=' '
      NCTITL=0
C
      IF(ICASE.EQ.1)THEN
        IF(IDIST2.EQ.'GEOMETRIC')THEN
          ITEXT(1)='Maximum Likelihood:'
          NCTEXT(1)=19
          AVALUE(1)=0.0
          IDIGIT(1)=-1
          ITEXT(2)='Estimate of p:'
          NCTEXT(2)=14
          AVALUE(2)=PML
          IDIGIT(2)=NUMDIG
          ITEXT(3)='Standard Error of Estimated p:'
          NCTEXT(3)=30
          AVALUE(3)=SQRT(PMLVAR)
          IDIGIT(3)=NUMDIG
          ICNT=3
        ELSE
          ITEXT(1)='Maximum Likelihood (k known case):'
          NCTEXT(1)=34
          AVALUE(1)=0.0
          IDIGIT(1)=0
          ITEXT(2)='User-specified k:'
          NCTEXT(2)=17
          AVALUE(2)=AK
          IDIGIT(2)=NUMDIG
          ITEXT(3)='Estimate of p:'
          NCTEXT(3)=14
          AVALUE(3)=PML
          IDIGIT(3)=NUMDIG
          ICNT=3
        ENDIF
        IF(PMLBCV.LE.0.0)THEN
          ICNT=ICNT+1
          ITEXT(ICNT)='Log-likelihood:'
          NCTEXT(ICNT)=15
          AVALUE(ICNT)=ALIK
          IDIGIT(ICNT)=NUMDIG
          ICNT=ICNT+1
          ITEXT(ICNT)='AIC:'
          NCTEXT(ICNT)=4
          AVALUE(ICNT)=AIC
          IDIGIT(ICNT)=NUMDIG
          ICNT=ICNT+1
          ITEXT(ICNT)='AICc:'
          NCTEXT(ICNT)=5
          AVALUE(ICNT)=AICC
          IDIGIT(ICNT)=NUMDIG
          ICNT=ICNT+1
          ITEXT(ICNT)='BIC:'
          NCTEXT(ICNT)=4
          AVALUE(ICNT)=BIC
          IDIGIT(ICNT)=NUMDIG
          NUMROW=ICNT
        ELSE
          ICNT=ICNT+1
          ITEXT(ICNT)='Bias Corrected estimate of p:'
          NCTEXT(ICNT)=29
          AVALUE(ICNT)=PMLBC
          IDIGIT(ICNT)=NUMDIG
          ICNT=ICNT+1
          ITEXT(ICNT)='Standard error of estimated p:'
          NCTEXT(ICNT)=30
          AVALUE(ICNT)=SQRT(PMLBCV)
          IDIGIT(ICNT)=NUMDIG
          ICNT=ICNT+1
          ITEXT(ICNT)='Log-likelihood:'
          NCTEXT(ICNT)=15
          AVALUE(ICNT)=ALIK
          IDIGIT(ICNT)=NUMDIG
          ICNT=ICNT+1
          ITEXT(ICNT)='AIC:'
          NCTEXT(ICNT)=4
          AVALUE(ICNT)=AIC
          IDIGIT(ICNT)=NUMDIG
          ICNT=ICNT+1
          ITEXT(ICNT)='AICc:'
          NCTEXT(ICNT)=5
          AVALUE(ICNT)=AICC
          IDIGIT(ICNT)=NUMDIG
          ICNT=ICNT+1
          ITEXT(ICNT)='BIC:'
          NCTEXT(ICNT)=4
          AVALUE(ICNT)=BIC
          IDIGIT(ICNT)=NUMDIG
          NUMROW=ICNT
        ENDIF
        DO2320I=1,NUMROW
          NTOT(I)=15
 2320   CONTINUE
C
        ILAST=.TRUE.
        NCTITZ=0
        CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1              AVALUE,IDIGIT,
     1              NTOT,NUMROW,
     1              ICAPSW,ICAPTY,ILAST,IFRST,
     1              ISUBRO,IBUGA3,IERROR)
C
        IF(NUMOUT.GT.1)THEN
C
          ITITL9=' '
          NCTIT9=0
          ITITLE(1:43)='Confidence interval (normal approximation) '
          ITITLE(44:48)='for p'
          NCTITL=48
          NUMLIN=2
          NUMCOL=3
          ITITL2(1,1)='Confidence'
          ITITL2(2,1)='Coefficient'
          ITITL2(1,2)='Lower'
          ITITL2(2,2)='Limit'
          ITITL2(1,3)='Upper'
          ITITL2(2,3)='Limit'
          NCTIT2(1,1)=10
          NCTIT2(2,1)=11
          NCTIT2(1,2)=5
          NCTIT2(2,2)=5
          NCTIT2(1,3)=5
          NCTIT2(2,3)=5
          NMAX=0
          DO2321I=1,NUMCOL
            VALIGN(I)='b'
            ALIGN(I)='r'
            NTOT(I)=15
            NMAX=NMAX+NTOT(I)
            IDIGIT(I)=NUMDIG
 2321     CONTINUE
          IDIGIT(1)=2
          DO2323I=1,NUMALP
            NCTEXT(I)=0
            AMAT(I,1)=100.0*(1.0 - ALPHA(I))
            AMAT(I,2)=ALOWP1(I)
            AMAT(I,3)=AUPPP1(I)
 2323     CONTINUE
          IWHTML(1)=150
          IWHTML(2)=150
          IWHTML(3)=150
          IWHTML(4)=150
          IWRTF(1)=2000
          IWRTF(2)=IWRTF(1)+2000
          IWRTF(3)=IWRTF(2)+2000
          IFRST=.FALSE.
          ILAST=.TRUE.
C
          CALL DPDTA2(ITITL9,NCTIT9,
     1                ITITLE,NCTITL,ITITL2,NCTIT2,
     1                MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1                ITEXT,NCTEXT,AMAT,MAXROW,NUMALP,
     1                IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1                ICAPSW,ICAPTY,IFRST,ILAST,
     1                ISUBRO,IBUGA3,IERROR)
        ENDIF
C
      ELSE
        ITITLE=' '
        NCTITL=0
        ITEXT(1)='Method of Moments:'
        NCTEXT(1)=19
        AVALUE(1)=0.0
        IDIGIT(1)=-1
        ITEXT(2)='Estimate of p:'
        NCTEXT(2)=14
        AVALUE(2)=PMOM
        IDIGIT(2)=NUMDIG
        ITEXT(3)='Estimate of k:'
        NCTEXT(3)=14
        AVALUE(3)=AKMOM
        IDIGIT(3)=NUMDIG
        NUMROW=3
        DO2330I=1,NUMROW
          NTOT(I)=15
 2330   CONTINUE
C
        ILAST=.FALSE.
        NCTITZ=0
        CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1              AVALUE,IDIGIT,
     1              NTOT,NUMROW,
     1              ICAPSW,ICAPTY,ILAST,IFRST,
     1              ISUBRO,IBUGA3,IERROR)
C
        ITEXT(1)='Maximum Likelihood (k unknown case):'
        NCTEXT(1)=36
        AVALUE(1)=0.0
        IDIGIT(1)=-1
        ITEXT(2)='Estimate of p:'
        NCTEXT(2)=14
        AVALUE(2)=PML
        IDIGIT(2)=NUMDIG
        ITEXT(3)='Bias Corrected estimate of p:'
        NCTEXT(3)=29
        AVALUE(3)=PMLBC
        IDIGIT(3)=NUMDIG
        ITEXT(4)='Estimate of k:'
        NCTEXT(4)=14
        AVALUE(4)=AKML
        IDIGIT(4)=NUMDIG
        ITEXT(5)='Standard error of p:'
        NCTEXT(5)=20
        AVALUE(5)=PSE
        IDIGIT(5)=NUMDIG
        ITEXT(6)='Standard error of k:'
        NCTEXT(6)=20
        AVALUE(6)=AKSE
        IDIGIT(6)=NUMDIG
        ITEXT(7)='Covariance of p and k:'
        NCTEXT(7)=22
        AVALUE(7)=COVSE
        IDIGIT(7)=NUMDIG
        ITEXT(8)='Log-likelihood:'
        NCTEXT(8)=15
        AVALUE(8)=ALIK
        IDIGIT(8)=NUMDIG
        ITEXT(9)='AIC:'
        NCTEXT(9)=4
        AVALUE(9)=AIC
        IDIGIT(9)=NUMDIG
        ITEXT(10)='AICc:'
        NCTEXT(10)=5
        AVALUE(10)=AICC
        IDIGIT(10)=NUMDIG
        ITEXT(11)='BIC:'
        NCTEXT(11)=4
        AVALUE(11)=BIC
        IDIGIT(11)=NUMDIG
        NUMROW=11
        DO2340I=1,NUMROW
          NTOT(I)=15
 2340   CONTINUE
C
        ILAST=.TRUE.
        ITITLZ=' '
        NCTITZ=0
        CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1              AVALUE,IDIGIT,
     1              NTOT,NUMROW,
     1              ICAPSW,ICAPTY,ILAST,IFRST,
     1              ISUBRO,IBUGA3,IERROR)
C
        IF(NUMOUT.GT.1)THEN
C
          ITITL9=' '
          NCTIT9=0
          ITITLE(1:43)='Confidence interval (normal approximation) '
          ITITLE(44:48)='for p'
          NCTITL=48
          NUMLIN=2
          NUMCOL=3
          ITITL2(1,1)='Confidence'
          ITITL2(2,1)='Coefficient'
          ITITL2(1,2)='Lower'
          ITITL2(2,2)='Limit'
          ITITL2(1,3)='Upper'
          ITITL2(2,3)='Limit'
          NCTIT2(1,1)=10
          NCTIT2(2,1)=11
          NCTIT2(1,2)=5
          NCTIT2(2,2)=5
          NCTIT2(1,3)=5
          NCTIT2(2,3)=5
          NMAX=0
          DO2421I=1,NUMCOL
            VALIGN(I)='b'
            ALIGN(I)='r'
            NTOT(I)=15
            NMAX=NMAX+NTOT(I)
            IDIGIT(I)=NUMDIG
 2421     CONTINUE
          IDIGIT(1)=2
          DO2423I=1,NUMALP
            NCTEXT(I)=0
            AMAT(I,1)=100.0*(1.0 - ALPHA(I))
            AMAT(I,2)=ALOWP1(I)
            AMAT(I,3)=AUPPP1(I)
 2423     CONTINUE
          IWHTML(1)=150
          IWHTML(2)=150
          IWHTML(3)=150
          IWHTML(4)=150
          IWRTF(1)=2000
          IWRTF(2)=IWRTF(1)+2000
          IWRTF(3)=IWRTF(2)+2000
          IFRST=.TRUE.
          ILAST=.FALSE.
C
          CALL DPDTA2(ITITL9,NCTIT9,
     1                ITITLE,NCTITL,ITITL2,NCTIT2,
     1                MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1                ITEXT,NCTEXT,AMAT,MAXROW,NUMALP,
     1                IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1                ICAPSW,ICAPTY,IFRST,ILAST,
     1                ISUBRO,IBUGA3,IERROR)
C
          ITITLE(1:43)='Confidence interval (normal approximation) '
          ITITLE(44:48)='for k'
          NCTITL=48
          NUMLIN=2
          NUMCOL=3
          ITITL2(1,1)='Confidence'
          ITITL2(2,1)='Coefficient'
          ITITL2(1,2)='Lower'
          ITITL2(2,2)='Limit'
          ITITL2(1,3)='Upper'
          ITITL2(2,3)='Limit'
          NCTIT2(1,1)=10
          NCTIT2(2,1)=11
          NCTIT2(1,2)=5
          NCTIT2(2,2)=5
          NCTIT2(1,3)=5
          NCTIT2(2,3)=5
          NMAX=0
          DO2521I=1,NUMCOL
            VALIGN(I)='b'
            ALIGN(I)='r'
            NTOT(I)=15
            NMAX=NMAX+NTOT(I)
            IDIGIT(I)=NUMDIG
 2521     CONTINUE
          IDIGIT(1)=2
          DO2523I=1,NUMALP
            NCTEXT(I)=0
            AMAT(I,1)=100.0*(1.0 - ALPHA(I))
            AMAT(I,2)=ALOWK1(I)
            AMAT(I,3)=AUPPK1(I)
 2523     CONTINUE
          IWHTML(1)=150
          IWHTML(2)=150
          IWHTML(3)=150
          IWHTML(4)=150
          IWRTF(1)=2000
          IWRTF(2)=IWRTF(1)+2000
          IWRTF(3)=IWRTF(2)+2000
          IFRST=.FALSE.
          ILAST=.TRUE.
C
          CALL DPDTA2(ITITL9,NCTIT9,
     1                ITITLE,NCTITL,ITITL2,NCTIT2,
     1                MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1                ITEXT,NCTEXT,AMAT,MAXROW,NUMALP,
     1                IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1                ICAPSW,ICAPTY,IFRST,ILAST,
     1                ISUBRO,IBUGA3,IERROR)
C
        ENDIF
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLNB')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLNB--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012   FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9015)N
 9015   FORMAT('N = ',I8)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLNM(Y,X,N,NVAR,Y2,X2,N2,
     1                  TEMP1,TEMP2,WORK,ITEMP1,MAXNXT,
     1                  CLLIMI,CLWIDT,NCOMP,
     1                  TEMP3,IHSTCW,MAXOBV,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  U1,SD1,U2,SD2,PMIX,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR THE NORMAL MIXTURE DISTRIBUTION.
C              IT USES APPLIED STATISTICS ALGORITHM 203 TO
C              PERFORM THE MAXIMUM LIKELIHOOD ESTIMATION.
C
C              THERE ARE TWO CASES:
C
C              1) ONE VARIABLE CASE: Y IS RAW DATA
C                 A) CALL DPBIN TO BIN DATA
C                 B) IF USER HAS SPECIFIED CLASS LIMITS OR WIDTH,
C                    PASS TO DPBIN.
C              2) TWO VARIABLE CASE: Y IS FREQUENCY, X IS CLASS
C                 MID-POINT.
C
C              NCOMP DEFINES NUMBER OF NORMAL DISTRIBUTIONS BEING
C              FIT.  MAXIMUM OF 20 ALLOWED.
C
C     EXAMPLE--NORMAL MIXTURE MAXIMUM LIKELIHOOD Y
C            --NORMAL MIXTURE MAXIMUM LIKELIHOOD Y X
C     REFERENCE--"MAXIMUM LIKELIHOOD ESTIMATION OF MIXTURES OF
C                DISTRIBUTIONS", M. AGHA AND T. IBRAHIM,
C                APPLIED STATISTICS, 1984, VOLUME 33, NO. 3,
C                PP. 327-329.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004/8
C     ORIGINAL VERSION--AUGUST    2004.
C     UPDATED         --MARCH     2006. SUPPORT FOR DIFFERENT DEFAULT
C                                       BINNING ALGORITHMS
C     UPDATED         --MARCH     2011. USE DPDTA1 TO PRINT
C     UPDATED         --MARCH     2011. EXTRACT ML TO NMXML1
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-----------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 IHSTCW
      CHARACTER*4 IHSTO2
      CHARACTER*4 IRELAT
      CHARACTER*4 IRHSTG
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*4 ISUBN0
      CHARACTER*4 IOP
C
      PARAMETER (MAXROW=50)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*45 ITEXT(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C
C-------------------------------------------------------------------
C
      PARAMETER (KMAX=20)
      PARAMETER (MMAX=200)
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION Y2(*)
      DIMENSION X2(*)
      DIMENSION TEMP1(*)
      DIMENSION TEMP2(*)
      DIMENSION TEMP3(*)
      DIMENSION CLLIMI(*)
      DIMENSION CLWIDT(*)
      INTEGER   ITEMP1(*)
C
      REAL TOL
C
      REAL ALPHA(KMAX)
      REAL XMEAN(KMAX)
      REAL XSD(KMAX)
C
C  FOR STORAGE EFFICIENCY, USE SINGLE "WORK" ARRAY FOR FOLLOWING.
C  TO AVOID CONFUSION, LEAVE ALPHA, XMEAN, AND XSD AS DISTINCT
C  ARRAYS (THESE TAKE A MINIMAL AMOUNT OF STORAGE, SINCE THESE
C  REFERENCED IN THIS ROUTINE, KEEP CLARITY IN CODE)
C
      DIMENSION WORK(*)
C
C-------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT---------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='NM  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLNM')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLNM--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO
   52   FORMAT('IBUGA3,ISUBRO = ',A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)N,NCOMP,NVAR
   55   FORMAT('N,NCOMP,NVAR = ',3I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,N
          WRITE(ICOUT,57)I,Y(I),X(I)
   57     FORMAT('I,Y(I),X(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               *****************************************
C               **  STEP 21--                          **
C               **  CARRY OUT CALCULATIONS             **
C               **  FOR NORMAL MIXTURE MLE ESTIMATION  **
C               *****************************************
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLNM')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IERROR='NO'
      IWRITE='OFF'
C
      CALL NMXML1(Y,X,N,NVAR,Y2,X2,N2,
     1            TEMP1,TEMP2,TEMP3,WORK,ITEMP1,MAXNXT,
     1            CLLIMI,CLWIDT,NCOMP,IHSTCW,
     1            ALPHA,XMEAN,XSD,KMAX,NTOT2,ALOGL,
     1            AMEAN,ASD,AMIN,AMAX,
     1            ISUBRO,IBUGA3,IERROR)
      U1=XMEAN(1)
      U2=XMEAN(2)
      SD1=XSD(1)
      SD2=XSD(2)
      PMIX=ALPHA(1)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IOP='OPEN'
      IFLAG1=1
      IFLAG2=0
      IFLAG3=0
      IFLAG4=0
      IFLAG5=0
      CALL DPAUFI(IOP,IFLAG1,IFLAG2,IFLAG3,IFLAG4,IFLAG5,
     1            IOUNI1,IOUNI2,IOUNI3,IOUNI4,IOUNI5,
     1            IBUGA3,ISUBRO,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      DO2300I=1,NCOMP
        WRITE(IOUNI1,2301)ALPHA(I),XMEAN(I),XSD(I)
 2300 CONTINUE
 2301 FORMAT(3(E15.7,1X))
C
      IOP='CLOS'
      CALL DPAUFI(IOP,IFLAG1,IFLAG2,IFLAG3,IFLAG4,IFLAG5,
     1            IOUNI1,IOUNI2,IOUNI3,IOUNI4,IOUNI5,
     1            IBUGA3,ISUBRO,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C               ***********************************************
C               **   STEP 42--                               **
C               **   WRITE OUT EVERYTHING                    **
C               **   FOR NORMAL MIXTURE MLE ESTIMATION       **
C               ***********************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLNM')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      NUMROW=ICNT
      DO2320I=1,50
        NTOT(I)=15
 2320 CONTINUE
C
      ITITLE='Normal Mixture Parameter Estimation'
      NCTITL=35
      ITITLZ=' '
      NCTITZ=0
C
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(N)
      IF(NUMVR.GT.1)AVALUE(ICNT)=REAL(NTOT2)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=AMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=ASD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=AMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=AMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      DO4230I=1,NCOMP
C
        IF(ICNT.GT.45)THEN
          NUMROW=ICNT
          IFRST=.TRUE.
          ILAST=.TRUE.
          CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1                AVALUE,IDIGIT,
     1                NTOT,NUMROW,
     1                ICAPSW,ICAPTY,ILAST,IFRST,
     1                ISUBRO,IBUGA3,IERROR)
          ICNT=0
          ITITLE=' '
          NCTITL=0
        ENDIF
C
        ICNT=ICNT+1
        ITEXT(ICNT)='Component    Maximum Likelihood Estimates:'
        WRITE(ITEXT(ICNT)(11:12),'(I2)')I
        NCTEXT(ICNT)=42
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
        ICNT=ICNT+1
        ITEXT(ICNT)='Mixing Proportion:'
        NCTEXT(ICNT)=18
        AVALUE(ICNT)=ALPHA(I)
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Mean:'
        NCTEXT(ICNT)=5
        AVALUE(ICNT)=XMEAN(I)
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Standard Deviation:'
        NCTEXT(ICNT)=19
        AVALUE(ICNT)=XSD(I)
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)=' '
        NCTEXT(ICNT)=0
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
 4230 CONTINUE
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Log-likelihood:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=ALOGL
      IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=AIC
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AICc:'
CCCCC NCTEXT(ICNT)=5
CCCCC AVALUE(ICNT)=AICC
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='BIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=BIC
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)=' '
CCCCC NCTEXT(ICNT)=0
CCCCC AVALUE(ICNT)=0.0
CCCCC IDIGIT(ICNT)=-1
C
      NUMROW=ICNT
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLNM')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLNM--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012   FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9015)N
 9015   FORMAT('N = ',I8)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLP1(Y,N,
     1                  DTEMP1,MAXNXT,
     1                  SHAPML,AML,SHAPSE,AMLSE,
     1                  SHAPMM,AMM,SHAPMO,AMOM,
     1                  QP,XQPHAT,XQPSE,XQPLCL,XQPUCL,NPERC,ALPHAP,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR PARETO DISTRIBUTION
C     EXAMPLE--PARETO MAXIMUM LIKELIHOOD Y
C     REFERENCE--COHEN AND WHITTEN (1988), "PARAMETER ESTIMATION IN
C                RELIABILITY AND LIFE SPAN MODELS", MARCEL DEKKER, INC.,
C                CHAPTER 11.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--98/5
C     ORIGINAL VERSION--MAY       1998.
C     UPDATED         --OCTOBER   2003. SUPPORT FOR HTML, LATEX OUTPUT
C     UPDATED         --OCTOBER   2003. CONFIDENCE INTERVAL FOR SHAPE
C                                       PARAMETER
C     UPDATED         --DECEMBER  2004. MODIFY FORMAT OF OUTPUT
C     UPDATED         --JULY      2010. USE DPDTA1, DPDT8A, AND DPDTA9
C                                       TO PRINT OUTPUT
C     UPDATED         --JULY      2010. EXTRACT POINT ESTIMATES TO
C                                       PARML1
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DSUM
      DOUBLE PRECISION DTERM1
C
      PARAMETER (NUMALP=6)
      DIMENSION ALPHA(NUMALP)
      DIMENSION ALOWGA(NUMALP)
      DIMENSION AUPPGA(NUMALP)
      DIMENSION ALOWLO(NUMALP)
      DIMENSION AUPPLO(NUMALP)
      DIMENSION ALOWSC(NUMALP)
      DIMENSION AUPPSC(NUMALP)
C
      DIMENSION Y(*)
      DOUBLE PRECISION DTEMP1(*)
C
      DIMENSION QP(*)
      DIMENSION XQPHAT(*)
      DIMENSION XQPSE(*)
      DIMENSION XQPLCL(*)
      DIMENSION XQPUCL(*)
C
      PARAMETER (MAXROW=40)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*50 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(MAXROW)
      CHARACTER*4  VALIGN(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C
      CHARACTER*4 ILIKFL
      CHARACTER*4 ILOCFL
      CHARACTER*4 ISCAFL
      CHARACTER*8 ISHAP1
      CHARACTER*8 ISHAP2
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA ALPHA /0.50, 0.25, 0.10, 0.05, 0.01, 0.001/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='P1  '
      IWRITE='NO'
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLP1')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLPA--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N,NPERC
   52   FORMAT('IBUGA3,ISUBRO,N,NPERC = ',A4,2X,A4,2X,2I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLP1')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NMIN=3
      CALL CKDIST(Y,N,NMIN,QP,NPERC,ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C     STEP 1: OBTAIN POINT ESTIMATES AND STANDARD ERRORS
C
      CALL PARML1(Y,N,
     1            DTEMP1,
     1            XMEAN,XSD,XMIN,XMAX,
     1            AMOM,SHAPMO,
     1            AMM,SHAPMM,
     1            AML,SHAPML,AMLSE,SHAPSE,
     1            ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      CALL PARLI1(Y,N,
     1            AMOM,SHAPMO,
     1            ALIKMO,AICMO,AICCMO,BICMO,
     1            ISUBRO,IBUGA3,IERROR)
C
      CALL PARLI1(Y,N,
     1            AMM,SHAPMM,
     1            ALIKMM,AICMM,AICCMM,BICMM,
     1            ISUBRO,IBUGA3,IERROR)
C
      CALL PARLI1(Y,N,
     1            AML,SHAPML,
     1            ALIKML,AICML,AICCML,BICML,
     1            ISUBRO,IBUGA3,IERROR)
C
C     NOW GENERATE CONFIDENCE INTERVALS FOR MODIFIED MAXIMUM
C     LIKELIHOOD
C
      NU=2*(N-1)
C
      DO4120I=1,NUMALP
        ALP=ALPHA(I)
        PL=ALP/2.0
        PU=1.0-(ALP/2.0)
        CALL CHSPPF(PL,NU,PPF1)
        CALL CHSPPF(PU,NU,PPF2)
        CALL NORPPF(PU,PPF3)
        ALOWGA(I)=SHAPML*PPF1/REAL(2*N)
        AUPPGA(I)=SHAPML*PPF2/REAL(2*N)
        IF(AMLSE.GT.0.0)THEN
          ALOWLO(I)=AML - PPF3*AMLSE
          AUPPLO(I)=AML + PPF3*AMLSE
          IF(AUPPLO(I).GT.XMIN)AUPPLO(I)=XMIN
        ELSE
          ALOWLO(I)=CPUMIN
          AUPPLO(I)=CPUMIN
        ENDIF
 4120 CONTINUE
C
C      CONFIDENCE INTERVALS FOR SELECTED PERCENTILES.
C
C      METHOD OF ASTRABADI AS DESCRIBED ON PP. 591-592 OF JOHNSON,
C      KOTZ, AND BALAKRISHNAN (SEE REFERENCE ABOVE).  THESE ARE
C      APPROXIMATE INTERVALS.  THIS STILL NEEDS ADDITIONAL
C      ALGORITHMIC WORK, SO COMMENT OUT FOR NOW.
C
      NPERC=0
      IF(NPERC.GE.1)THEN
C
        ALPHL=ALPHAP/2.0
        ALPHU=1.0 - ALPHAP/2.0
        NUTEMP=2*N
        CALL CHSPPF(ALPHL,NUTEMP,ZLOW)
        CALL CHSPPF(ALPHU,NUTEMP,ZUPP)
        print *,'zlow,zupp=',zlow,zupp
C
CCCCC   WRITE(IOUNI1,4131)
CCCCC   WRITE(IOUNI1,4132)
        DO4139I=1,NPERC
          QPTEMP=QP(I)/100.0
          CALL PARPPF(QPTEMP,SHAPML,AML,APPF)
          XQPHAT(I)=APPF
C
          TERM1=2.0*SHAPML*LOG(APPF/AML)/ZLOW
          TERM2=TERM1**(AN-1.0)
          TERM3=(1.0 - TERM1)**(AN-1.0)
          print *,'term1,term2,term3=',term1,term2,term3
          XQPLCL(I)=1.0 - TERM2
          XQPUCL(I)=1.0 - TERM3
CCCCC     WRITE(IOUNI1,'(4E15.7)')
CCCCC1         QP(I),XQPHAT(I),XQPLCL(I),XQPUCL(I)
 4139   CONTINUE
 4131   FORMAT(15X,'       POINT     ','     LOWER     ',
     1         '     UPPER')
 4132   FORMAT('    PERCENTILE ','     ESTIMATE   ',
     1         'CONFIDENCE LIMIT ','CONFIDENCE LIMIT')
C
      ENDIF
C
C               *********************************
C               **   STEP 42--                 **
C               **   WRITE OUT EVERYTHING      **
C               **   FOR PARETO MLE ESTIMATE   **
C               **********************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLP1')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Pareto Parameter Estimation'
      NCTITL=27
      ITITLZ='Full Sample Case'
      NCTITZ=16
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(N)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      IF(AMOM.GT.0.0)THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='Moments:'
        NCTEXT(ICNT)=8
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of Threshold (A):'
        NCTEXT(ICNT)=26
        AVALUE(ICNT)=AMOM
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of Shape (Gamma):'
        NCTEXT(ICNT)=26
        AVALUE(ICNT)=SHAPMO
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Log-likelihood:'
        NCTEXT(ICNT)=15
        AVALUE(ICNT)=ALIKMO
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='AIC:'
        NCTEXT(ICNT)=4
        AVALUE(ICNT)=AICMO
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='AICc:'
        NCTEXT(ICNT)=5
        AVALUE(ICNT)=AICCMO
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='BIC:'
        NCTEXT(ICNT)=4
        AVALUE(ICNT)=BICMO
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)=' '
        NCTEXT(ICNT)=0
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
      ENDIF
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Modified Moments:'
      NCTEXT(ICNT)=17
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Threshold (A):'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=AMM
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Shape (Gamma):'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=SHAPMM
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Log-likelihood:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=ALIKMM
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)='AIC:'
      NCTEXT(ICNT)=4
      AVALUE(ICNT)=AICMM
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)='AICc:'
      NCTEXT(ICNT)=5
      AVALUE(ICNT)=AICCMM
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)='BIC:'
      NCTEXT(ICNT)=4
      AVALUE(ICNT)=BICMM
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Modified Maximum Likelihood:'
      NCTEXT(ICNT)=28
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Threshold (A):'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=AML
      IDIGIT(ICNT)=NUMDIG
      IF(AMLSE.GT.0.0)THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='Standard Error of Threshold:'
        NCTEXT(ICNT)=28
        AVALUE(ICNT)=AMLSE
        IDIGIT(ICNT)=NUMDIG
      ENDIF
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Shape (Gamma):'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=SHAPML
      IDIGIT(ICNT)=NUMDIG
      IF(SHAPSE.GT.0.0)THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='Standard Error of Gamma:'
        NCTEXT(ICNT)=24
        AVALUE(ICNT)=SHAPSE
        IDIGIT(ICNT)=NUMDIG
      ENDIF
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Log-likelihood:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=ALIKML
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)='AIC:'
      NCTEXT(ICNT)=4
      AVALUE(ICNT)=AICML
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)='AICc:'
      NCTEXT(ICNT)=5
      AVALUE(ICNT)=AICCML
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)='BIC:'
      NCTEXT(ICNT)=4
      AVALUE(ICNT)=BICML
      IDIGIT(ICNT)=-7
C
      NUMROW=ICNT
      DO2320I=1,NUMROW
        NTOT(I)=15
 2320 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
      ALOWSC(1)=CPUMIN
      ILIKFL='EXAC'
      ILOCFL='OFF'
      ISCAFL='OFF'
      ISHAP1='A'
      NCSHA1=1
      ISHAP2='Gamma'
      NCSHA2=5
      CALL DPDT8A(ALOWSC,AUPPSC,ALOWSC,AUPPSC,
     1            ALOWLO,AUPPLO,ALOWLO,AUPPLO,
     1            ALOWGA,AUPPGA,ALOWGA,AUPPGA,
     1            ALPHA,NUMALP,
     1            ICAPSW,ICAPTY,NUMDIG,
     1            ILOCFL,ISCAFL,ILIKFL,
     1            ISHAP1,NCSHA1,ISHAP2,NCSHA2,
     1            ISUBRO,IBUGA3,IERROR)
C
      IF(NPERC.GE.1)THEN
        ILIKFL='PARE'
        XQPSE(1)=CPUMIN
        CALL DPDTA9(QP,XQPHAT,XQPLCL,XQPUCL,XQPSE,NPERC,
     1              ICAPSW,ICAPTY,ILIKFL,NUMDIG,ALPHAP,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLP1')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLP1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012   FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLPL(Y1,N,X1,NGROUP,XCEN,NCENS,NUMV,
     1                  XIDTEM,TEMP2,TEMP3,TEMP4,TEMP5,TEMP6,
     1                  TEMP7,TEMP8,MAXNXT,
     1                  TEND,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  IOUNI1,IOUNI2,ALPHAP,
     1                  AHAT,BHAT,AMTBF,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR A NON-HOMOGENEOUS POISSON PROCESS
C              THAT FOLLOWS THE "POWER LAW" MODEL.
C
C              THE POWER LAW MODEL IS:
C
C                  M(t) = a*t**b
C
C              WHERE
C
C               M(t) = CUMULATIVE REPAIR FUNCTION
C               t    = TIME TO FAILURE
C               a, b = PARAMETERS TO BE ESTIMATED
C
C               THE POWER LAW OFTEN APPLIES WHEN WE HAVE
C               MONOTONICALLY INCREASING OR DECREASING TRENDS
C               IN THE REPAIR DATA.
C
C              THE INPUT IS ASSUMED TO BE REPAIR TIMES.  WE CAN
C              OPTIONALLY HAVE A XCENORING VARIABLE (THERE SHOULD
C              BE AT MOST ONE XCENORING TIME).
C
C              FOR THE CASE WHERE THE TEST IS TERMINATED AT THE
C              NTH FAILURE, THE MAXIMUM LIKELIHOOD ESTIMATES ARE:
C
C                  bhat = (n-1)/SUM[i=1 to n-1][LOG(t(n)/t(i))]
C                  ahat = n/t(n)**bhat
C
C              FOR THE CASE WHERE THE TEST IS TERMINATED AT A FIXED
C              TIME T, THE MAXIMUM LIKELIHOOD ESTIMATES ARE:
C
C                  bhat = (n-1)/SUM[i=1 to n][LOG(T/t(i))]
C                  ahat = n/T**bhat
C
C              IF THERE ARE K COPIES OF THE SYSTEM, THEN THE
C              WE CAN COMBINE THE ESTIMATES TO OBTAIN:
C
C                 bhat = (N(s) - 1)/(SUM[q=1 tp k][SUM[i=1 to q]
C                        [LOG(T(q)/t(iq)]
C                 ahat = SUM[q=1 to k][n(q)]/SUM[q=1 to k][T(q)**bhat]
C
C              WHERE
C
C                 T(q)    = TRUNCATION TIME FOR QTH SYSTEM
C                 n(q)    = NUMBER OF FAILURE TIMES FOR QTH SYSTEM
C                 N(q)    = n(q) IF WE HAVE A XCENORING TIME
C                           n(q) - 1 IF THERE IS NO XCENORING TIME
C                 t(iq)   = ITH FAILURE TIME FOR QTH SYSTEM
C                 N(s)    = SUM[q=1 to k][N(q)][N(q)]
C
C     EXAMPLE--EXPONENTIAL MAXIMUM LIKELIHOOD Y
C     REFERENCE--TOBIAS AND TRINDADE, "APPLIED RELIABILITY", SECOND
C                EDITION, PP. 357-358.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2006/10
C     ORIGINAL VERSION--OCTOBER   2006.
C     UPDATED         --APRIL     2011. USE DPDTA1 TO PRINT OUTPUT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 IEXPBC
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      DOUBLE PRECISION DSUM
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DSUM2
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM2
C
C---------------------------------------------------------------------
C
      PARAMETER (NUMALP=6)
      PARAMETER (NUMAL2=5)
      DIMENSION ALPHA(NUMALP)
      DIMENSION ALPHA2(5)
      DIMENSION A2LOWB(NUMALP)
      DIMENSION A2UPPB(NUMALP)
C
      DIMENSION Y1(*)
      DIMENSION X1(*)
      DIMENSION XCEN(*)
      DIMENSION XIDTEM(*)
      DIMENSION TEMP2(*)
      DIMENSION TEMP3(*)
      DIMENSION TEMP4(*)
      DIMENSION TEMP5(*)
      DIMENSION TEMP6(*)
      DIMENSION TEMP7(*)
      DIMENSION TEMP8(*)
C
      PARAMETER (MAXROW=100)
      PARAMETER(NUMCLI=4)
      PARAMETER(MAXLIN=3)
C
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*60 ITITL9
      CHARACTER*40 IDIST
      CHARACTER*50 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(MAXROW)
      CHARACTER*4  VALIGN(MAXROW)
      CHARACTER*4  ITYPCO(NUMCLI)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL      IFRST
      LOGICAL      ILAST
      LOGICAL      IFLAGS
      LOGICAL      IFLAGE
C
      CHARACTER*60 ITITL2(MAXLIN,NUMCLI)
      CHARACTER*15 IVALUE(NUMALP,NUMCLI)
      INTEGER      NCTIT2(MAXLIN,NUMCLI)
      INTEGER      NCVALU(NUMALP,NUMCLI)
      INTEGER      IWHTML(NUMCLI+1)
      INTEGER      IWRTF(NUMCLI)
      REAL         AMAT(NUMALP,NUMCLI)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA ALPHA  /0.50, 0.20, 0.10, 0.05, 0.01, 0.001/
      DATA ALPHA2 /0.20, 0.15, 0.10, 0.05, 0.01/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='PL  '
C
      IERROR='NO'
      IWRITE='OFF'
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLPL')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLPL--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3
   52   FORMAT('IBUGA3 = ',A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)N,NGROUP,NCENS,NUMV,TEND
   55   FORMAT('N,NGROUP,NCENS,NUMV,TEND = ',4I8,G15.7)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y1(I),X1(I),XCEN(I)
   57     FORMAT('I,Y1(I),X1(I),XCEN(I) = ',I8,3G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLPL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(N.LT.2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1111)
 1111   FORMAT('***** ERROR IN POWER LAW MAXIMUM LIKELIHOOD--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1112)
 1112   FORMAT('      THE NUMBER OF OBSERVATIONS IS < 2')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1113)N
 1113   FORMAT('      SAMPLE SIZE = ',I8)
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      DO1135I=2,N
        IF(Y1(I).LE.0.0)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,1111)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,1132)I
 1132     FORMAT('      FAILURE TIME ',I8,' IS NON-POSITIVE.')
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,1134)Y1(I)
 1134     FORMAT('      FAILURE TIME = ',G15.7)
          CALL DPWRST('XXX','WRIT')
          IERROR='YES'
          GOTO9000
        ENDIF
 1135 CONTINUE
C
C               **********************************
C               **  STEP 41--                   **
C               **  CARRY OUT CALCULATIONS      **
C               **  FOR POWER LAW MLE           **
C               **  ESTIMATE (FULL SAMPLE CASE) **
C               **********************************
C
 4100 CONTINUE
C
      ISTEPN='41'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLPL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      AN=REAL(N)
C
C     CASE 1: NO GROUP OR CENSORING VARIABLE
C
      IF(NGROUP.EQ.0 .AND. NCENS.EQ.0)THEN
        CALL SORT(Y1,N,Y1)
        IF(TEND.LE.Y1(N))TEND=0.0
        IF(TEND.LE.0.0)THEN
          NFAIL=N
          NUMCEN=0
          DSUM=0.0D0
          ICNT=0
          DTERM2=DBLE(Y1(N))
          DO4110I=1,N-1
            DTERM1=DBLE(Y1(I))
            DSUM=DSUM + DLOG(DTERM2/DTERM1)
            ICNT=ICNT+1
            TEMP8(ICNT)=DTERM1/DTERM2
 4110     CONTINUE
          BHAT=DBLE(N-1)/DSUM
          AHAT=DBLE(N)/DTERM2**DBLE(BHAT)
          AMTBF=Y1(N)/(AN*BHAT)
          DO4115I=1,NUMALP
            ALP=ALPHA(I)
            P=1.0 - (ALP/2.0)
            CALL NORPPF(P,PPF)
            ANUM=AN*(AN-1.0)
            TERM1=AN + PPF**2/4.0
            TERM2=SQRT(AN*PPF**2/2.0 + PPF**4/16.0)
            ADEN=(TERM1 + TERM2)**2
            A2LOWB(I)=AMTBF*ANUM/ADEN
            TERM1=AN - PPF*SQRT(AN/2.0)
            ADEN=TERM1**2
            A2UPPB(I)=AMTBF*ANUM/ADEN
 4115     CONTINUE
        ELSE
          NFAIL=N
          NUMCEN=1
          DSUM=0.0D0
          ICNT=0
          DTERM2=DBLE(TEND)
          DO4120I=1,N
            DTERM1=DBLE(Y1(I))
            DSUM=DSUM + DLOG(DBLE(DTERM2/DTERM1))
            ICNT=ICNT+1
            TEMP8(ICNT)=DTERM1/DTERM2
 4120     CONTINUE
          BHAT=DBLE(N-1)/DSUM
          AHAT=DBLE(N)/DTERM2**DBLE(BHAT)
          AMTBF=TEND/(AN*BHAT)
          DO4125I=1,NUMALP
            ALP=ALPHA(I)
            P=1.0 - (ALP/2.0)
            CALL NORPPF(P,PPF)
            ANUM=AN*(AN-1.0)
            TERM1=AN + PPF**2/4.0
            TERM2=SQRT(AN*PPF**2/2.0 + PPF**4/16.0)
            ADEN=(TERM1 + TERM2)**2
            A2LOWB(I)=AMTBF*ANUM/ADEN
            TERM1=AN - PPF*SQRT(AN/2.0)
            ADEN=TERM1**2
            A2UPPB(I)=AMTBF*ANUM/ADEN
 4125     CONTINUE
        ENDIF
C
C     PRINT TABLE
C
      ITITLE='Power Law Maximum Likelihood Estimation (M(t) = a*t**b)'
      NCTITL=55
      IF(NUMCEN.EQ.0)THEN
        ITITLZ='Single System, Failure Truncated Case'
        NCTITZ=37
      ELSE
        ITITLZ='Single System, Time Truncated Case'
        NCTITZ=34
      ENDIF
C
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Failure Times:'
      NCTEXT(ICNT)=24
      AVALUE(ICNT)=REAL(NFAIL)
      IDIGIT(ICNT)=0
      IF(TEND.GT.0.0)THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='Censoring Time:'
        NCTEXT(ICNT)=15
        AVALUE(ICNT)=TEND
        IDIGIT(ICNT)=NUMDIG
      ENDIF
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Parameter Estimates:'
      NCTEXT(ICNT)=20
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of B:'
      NCTEXT(ICNT)=14
      AVALUE(ICNT)=BHAT
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of A:'
      NCTEXT(ICNT)=14
      AVALUE(ICNT)=AHAT
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Reliability Growth Slope:'
      NCTEXT(ICNT)=37
      AVALUE(ICNT)=1.0 - BHAT
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of MTBF at End of Test:'
      NCTEXT(ICNT)=32
      AVALUE(ICNT)=AMTBF
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      NUMROW=ICNT
      DO2310I=1,NUMROW
        NTOT(I)=15
 2310 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
      ITITL9='Approximate Confidence Interval for End of Test MTBF'
      NCTIT9=52
      ITITLE=' '
      NCTITL=0
C
      NUMLIN=2
      NUMCOL=3
      ITITL2(1,1)='Confidence'
      ITITL2(2,1)='Value (%)'
      NCTIT2(1,1)=10
      NCTIT2(2,1)=9
C
      ITITL2(1,2)='Lower'
      ITITL2(2,2)='Limit'
      NCTIT2(1,2)=5
      NCTIT2(2,2)=5
C
      ITITL2(1,3)='Upper'
      ITITL2(2,3)='Limit'
      NCTIT2(1,3)=5
      NCTIT2(2,3)=5
C
      NMAX=0
      DO2521I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        NMAX=NMAX+NTOT(I)
        IDIGIT(I)=NUMDIG
 2521 CONTINUE
      IDIGIT(1)=2
      DO2523I=1,NUMALP
        NCTEXT(I)=0
        AMAT(I,1)=100.0*(1.0 - ALPHA(I))
        AMAT(I,2)=A2LOWB(I)
        AMAT(I,3)=A2UPPB(I)
 2523 CONTINUE
      IWHTML(1)=150
      IWHTML(2)=150
      IWHTML(3)=150
      IWHTML(4)=150
      IWRTF(1)=2000
      IWRTF(2)=IWRTF(1)+2000
      IWRTF(3)=IWRTF(2)+2000
      IFRST=.TRUE.
      ILAST=.TRUE.
C
      CALL DPDTA2(ITITL9,NCTIT9,
     1            ITITLE,NCTITL,ITITL2,NCTIT2,
     1            MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1            ITEXT,NCTEXT,AMAT,NUMALP,NUMALP,
     1            IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1            ICAPSW,ICAPTY,IFRST,ILAST,
     1            ISUBRO,IBUGA3,IERROR)
C
C       CASE 2: GROUP VARIABLE, BUT NO CENSORING VARIABLE
C
      ELSEIF(NCENS.EQ.0)THEN
C
C       STEP 1: DETERMINE UNIQUE GROUPS
C
        NUMSET=0
        NS=0
        DSUM1=0.0D0
C
        DO4301I=1,N
          IF(NUMSET.EQ.0)GOTO4303
          DO4302J=1,NUMSET
            IF(X1(I).EQ.XIDTEM(J))GOTO4301
 4302     CONTINUE
 4303     CONTINUE
          NUMSET=NUMSET+1
          XIDTEM(NUMSET)=X1(I)
 4301   CONTINUE
        CALL SORT(XIDTEM,NUMSET,XIDTEM)
C
C       STEP 2: MAXIMUM LIKELIHOOD COMPUTATIONS
C
        ITITLE='Power Law Maximum Likelihood Estimation (M(t) = a*t**b)'
        NCTITL=55
        ITITLZ='Multiple Systems'
        NCTITZ=16
        ICNT=1
        ITEXT(ICNT)='Summary Statistics:'
        NCTEXT(ICNT)=19
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
        ICNT=1
        ITEXT(ICNT)='Number of Systems:'
        NCTEXT(ICNT)=18
        AVALUE(ICNT)=REAL(NUMSET)
        IDIGIT(ICNT)=-1
C
        J=0
        TENDSV=TEND
        DO4310ISET=1,NUMSET
C
          K=0
          DO4311I=1,N
            IF(X1(I).EQ.XIDTEM(ISET))THEN
              K=K+1
              TEMP2(K)=Y1(I)
            ENDIF
 4311     CONTINUE
          NI=K
          CALL SORT(TEMP2,NI,TEMP2)
C
C         CHECK FOR ERRORS:
C
C            1) REQUIRE AT LEAST 2 FAILURE TIMES
C            2) ALL FAILURE TIMES SHOULD BE LESS THAN TEND
C
          IF(NI.LT.2)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,4313)
 4313       FORMAT('***** WARNING IN POWER LAW MAXIMUM LIKELIHOOD--')
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,4314)ISET
 4314       FORMAT('      FOR SYSTEM ',I8,' THE NUMBER OF ',
     1             'REPAIR TIMES IS < 2')
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,4315)N
 4315       FORMAT('      NUMBER OF REPAIR TIMES = ',I8)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,4316)
 4316       FORMAT('      THIS SYSTEM WILL BE OMITTED FROM THE ',
     1             'ANALYSIS')
            CALL DPWRST('XXX','WRIT')
            TEMP4(ISET)=0.0
            GOTO4310
          ENDIF
          IF(TEMP2(NI).GE.TENDSV)THEN
            TEND=0.0
          ELSE
            TEND=TENDSV
          ENDIF
C
          IF(TEND.LE.0.0)THEN
            NS=NS + (NI-1)
            DSUM=0.0D0
            ICNT=0
            DTERM2=DBLE(TEMP2(NI))
            DO4330I=1,NI-1
              DTERM1=DBLE(TEMP2(I))
              DSUM=DSUM + DLOG(DTERM2/DTERM1)
              ICNT=ICNT+1
              TEMP8(ICNT)=REAL(DTERM1/DTERM2)
 4330       CONTINUE
            DSUM1=DSUM1 + DSUM
            TEMP4(ISET)=REAL(NI-1)
            TEMP5(ISET)=REAL(DTERM2)
          ELSE
            NS=NS + NI
            DSUM=0.0D0
            ICNT=0
            DTERM2=DBLE(TEND)
            DO4340I=1,NI
              DTERM1=DBLE(TEMP2(I))
              DSUM=DSUM + DLOG(DBLE(DTERM2/DTERM1))
              ICNT=ICNT+1
              TEMP8(ICNT)=REAL(DTERM1/DTERM2)
 4340       CONTINUE
            DSUM1=DSUM1 + DSUM
            TEMP4(ISET)=REAL(NI)
            TEMP5(ISET)=REAL(DTERM2)
          ENDIF
C
          IF(TEND.LE.0.0)THEN
            ICNT=ICNT+1
            ITEXT(ICNT)='System (Failure Censored):'
            NCTEXT(ICNT)=26
            AVALUE(ICNT)=REAL(ISET)
            IDIGIT(ICNT)=0
            ICNT=ICNT+1
            ITEXT(ICNT)='Last Repair Time:'
            NCTEXT(ICNT)=17
            AVALUE(ICNT)=TEMP2(NI)
            IDIGIT(ICNT)=NUMDIG
          ELSE
            ICNT=ICNT+1
            ITEXT(ICNT)='System (Time Censored):'
            NCTEXT(ICNT)=23
            AVALUE(ICNT)=REAL(ISET)
            IDIGIT(ICNT)=0
            ICNT=ICNT+1
            ITEXT(ICNT)='Censoring Time:'
            NCTEXT(ICNT)=15
            AVALUE(ICNT)=TEND
            IDIGIT(ICNT)=NUMDIG
          ENDIF
          ICNT=ICNT+1
          ITEXT(ICNT)='Number of Repair Times:'
          NCTEXT(ICNT)=23
          AVALUE(ICNT)=REAL(NI)
          IDIGIT(ICNT)=0
C
 4310   CONTINUE
C
        BHAT=DBLE(NS-1)/DSUM1
        DSUM=0.0D0
        DO4350ISET=1,NUMSET
          IF(TEMP4(ISET).GT.0.5)THEN
            DSUM=DSUM + TEMP5(ISET)**BHAT
          ENDIF
 4350   CONTINUE
        AHAT=DBLE(NS)/DSUM
CCCCC   AMTBF=Y1(N)/(AN*BHAT)
CCCCC   DO4335I=1,NUMALP
CCCCC     ALP=ALPHA(I)
CCCCC     P=1.0 - (ALP/2.0)
CCCCC     CALL NORPPF(P,PPF)
CCCCC     ANUM=AN*(AN-1.0)
CCCCC     TERM1=AN + PPF**2/4.0
CCCCC     TERM2=SQRT(AN*PPF**2/2.0 + PPF**4/16.0)
CCCCC     ADEN=(TERM1 + TERM2)**2
CCCCC     A2LOWB(I)=AMTBF*ANUM/ADEN
CCCCC     TERM1=AN - PPF*SQRT(AN/2.0)
CCCCC     ADEN=TERM1**2
CCCCC     A2UPPB(I)=AMTBF*ANUM/ADEN
C4355   CONTINUE
C
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of A:'
        NCTEXT(ICNT)=14
        AVALUE(ICNT)=AHAT
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of B:'
        NCTEXT(ICNT)=14
        AVALUE(ICNT)=BHAT
        IDIGIT(ICNT)=NUMDIG
C
        NUMROW=ICNT
        DO4360I=1,NUMROW
          NTOT(I)=15
 4360   CONTINUE
C
        IFRST=.TRUE.
        ILAST=.TRUE.
        CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1              AVALUE,IDIGIT,
     1              NTOT,NUMROW,
     1              ICAPSW,ICAPTY,ILAST,IFRST,
     1              ISUBRO,IBUGA3,IERROR)
C
C       CASE 3: BOTH GROUP VARIABLE AND CENSORING VARIABLE
C
      ELSE
C
C       STEP 1: DETERMINE UNIQUE GROUPS
C
        NUMSET=0
        DO4601I=1,N
          IF(NUMSET.EQ.0)GOTO4603
          DO4602J=1,NUMSET
            IF(X1(I).EQ.XIDTEM(J))GOTO4601
 4602     CONTINUE
 4603     CONTINUE
          NUMSET=NUMSET+1
          XIDTEM(NUMSET)=X1(I)
 4601   CONTINUE
        CALL SORT(XIDTEM,NUMSET,XIDTEM)
C
C       STEP 2A: EXTRACT RESPONSE AND CENSORING DATA FOR EACH
C                GROUP
C
        J=0
        ISETMX=NUMSET
        NS=0
        ICNT=0
        DSUM1=0.0D0
C
        DO4690ISET=1,NUMSET
C
          K=0
          DO4611I=1,N
            IF(X1(I).EQ.XIDTEM(ISET))THEN
              K=K+1
              TEMP2(K)=Y1(I)
              TEMP3(K)=XCEN(I)
            ENDIF
 4611     CONTINUE
          NI=K
C
C       STEP 2B: PROCESS THE CENSORING VARIABLE.  THERE CAN
C                BE AT MOST ONE CENSORING POINT FOR EACH
C                GROUP.
C
          CALL SORTC(TEMP2,TEMP3,NI,TEMP4,TEMP5)
          DO4620I=1,NI
            TEMP2(I)=TEMP4(I)
            TEMP3(I)=TEMP5(I)
 4620     CONTINUE
          AREP=TEMP3(1)
          ACEN=TEMP3(NI)
C
          IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLPL')THEN
            WRITE(ICOUT,4621)ISET,NI,AREP,ACEN
 4621       FORMAT('ISET,NI,AREP,ACEN = ',2I10,2G15.7)
            CALL DPWRST('XXX','BUG ')
          ENDIF
C
          IF(NI.LE.1)THEN
            NTEMPR=1
            NTEMPC=0
          ELSE
            IF(AREP.EQ.ACEN)THEN
              NTEMPR=NI
              NTEMPC=0
              TEND=0.0
              DO4630I=1,NI
                IF(TEMP3(I).NE.AREP)THEN
                  WRITE(ICOUT,999)
                  CALL DPWRST('XXX','BUG ')
                  WRITE(ICOUT,1111)
                  CALL DPWRST('XXX','BUG ')
                  WRITE(ICOUT,4631)
                  CALL DPWRST('XXX','BUG ')
                  WRITE(ICOUT,4632)
                  CALL DPWRST('XXX','BUG ')
                  WRITE(ICOUT,4633)
                  CALL DPWRST('XXX','BUG ')
                  WRITE(ICOUT,4634)XIDTEM(ISET)
                  CALL DPWRST('XXX','BUG ')
                  IERROR='YES'
                  GOTO9000
                ENDIF
 4630         CONTINUE
            ELSEIF(TEMP2(NI).EQ.TEMP2(NI-1))THEN
              NTEMPR=NI-1
              NI=NTEMPR
              NTEMPC=0
              TEND=0.0
              DO4635I=1,NTEMPR
                IF(TEMP3(I).NE.AREP)THEN
                  WRITE(ICOUT,999)
                  CALL DPWRST('XXX','BUG ')
                  WRITE(ICOUT,1111)
                  CALL DPWRST('XXX','BUG ')
                  WRITE(ICOUT,4631)
                  CALL DPWRST('XXX','BUG ')
                  WRITE(ICOUT,4632)
                  CALL DPWRST('XXX','BUG ')
                  WRITE(ICOUT,4633)
                  CALL DPWRST('XXX','BUG ')
                  WRITE(ICOUT,4634)XIDTEM(ISET)
                  CALL DPWRST('XXX','BUG ')
                  IERROR='YES'
                  GOTO9000
                ENDIF
 4635         CONTINUE
            ELSE
              NTEMPR=NI-1
              NTEMPC=1
              TEND=TEMP2(NI)
              DO4640I=1,NTEMPR
                IF(TEMP3(I).NE.AREP)THEN
                  WRITE(ICOUT,999)
                  CALL DPWRST('XXX','BUG ')
                  WRITE(ICOUT,1111)
                  CALL DPWRST('XXX','BUG ')
                  WRITE(ICOUT,4631)
                  CALL DPWRST('XXX','BUG ')
                  WRITE(ICOUT,4632)
                  CALL DPWRST('XXX','BUG ')
                  WRITE(ICOUT,4633)
                  CALL DPWRST('XXX','BUG ')
                  WRITE(ICOUT,4634)XIDTEM(ISET)
                  CALL DPWRST('XXX','BUG ')
                  IERROR='YES'
                  GOTO9000
                ENDIF
 4640         CONTINUE
            ENDIF
          ENDIF
 4631     FORMAT('      FOR EACH SYSTEM, THERE SHOULD BE AT MOST')
 4632     FORMAT('      ONE CENSORING TIME AND IT MUST BE THE ',
     1           'MAXIMUM')
 4633     FORMAT('      VALUE FOR THAT SYSTEM.')
 4634     FORMAT('      SUCH WAS NOT THE CASE FOR SYSTEM ',G15.7)
C
          IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLPL')THEN
            WRITE(ICOUT,4641)NTEMPR,NTEMPC,TEND
 4641       FORMAT('NTEMPR,NTEMPC,TEND = ',2I10,G15.7)
            CALL DPWRST('XXX','BUG ')
          ENDIF
C
          IF(ISET.EQ.1)THEN
            ITITLE=
     1      'Power Law Maximum Likelihood Estimation (M(t) = a*t**b)'
            NCTITL=55
            ITITLZ='Multiple Systems'
            NCTITZ=16
            ICNT=1
            ITEXT(ICNT)='Number of Systems:'
            NCTEXT(ICNT)=18
            AVALUE(ICNT)=REAL(NUMSET)
            IDIGIT(ICNT)=-1
          ENDIF
C
          IF(TEND.LE.0.0)THEN
            ICNT=ICNT+1
            ITEXT(ICNT)='System (Failure Censored):'
            NCTEXT(ICNT)=26
            AVALUE(ICNT)=REAL(ISET)
            IDIGIT(ICNT)=0
            ICNT=ICNT+1
            ITEXT(ICNT)='Last Repair Time:'
            NCTEXT(ICNT)=17
            AVALUE(ICNT)=TEMP2(NTEMPR)
            IDIGIT(ICNT)=NUMDIG
          ELSE
            ICNT=ICNT+1
            ITEXT(ICNT)='System (Time Censored):'
            NCTEXT(ICNT)=23
            AVALUE(ICNT)=REAL(ISET)
            IDIGIT(ICNT)=0
            ICNT=ICNT+1
            ITEXT(ICNT)='Censoring Time:'
            NCTEXT(ICNT)=15
            AVALUE(ICNT)=TEND
            IDIGIT(ICNT)=NUMDIG
          ENDIF
          ICNT=ICNT+1
          ITEXT(ICNT)='Number of Repair Times:'
          NCTEXT(ICNT)=23
          AVALUE(ICNT)=REAL(NTEMPR)
          IDIGIT(ICNT)=0
C
C         STEP 2C: MAXIMUM LIKELIHOOD COMPUTATIONS
C
C                  CHECK FOR ERRORS:
C
C                  1) REQUIRE AT LEAST 2 FAILURE TIMES
C                  2) ALL FAILURE TIMES SHOULD BE LESS THAN TEND
C
          IF(NI.LT.2)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,4613)
 4613       FORMAT('***** WARNING IN POWER LAW MAXIMUM LIKELIHOOD--')
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,4614)ISET
 4614       FORMAT('      FOR SYSTEM ',I8,' THE NUMBER OF ',
     1             'REPAIR TIMES IS < 2')
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,4615)N
 4615       FORMAT('      NUMBER OF REPAIR TIMES = ',I8)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,4616)
 4616       FORMAT('      THIS SYSTEM WILL BE OMITTED FROM THE ',
     1             'ANALYSIS')
            CALL DPWRST('XXX','WRIT')
            TEMP6(ISET)=0.0
            GOTO4690
          ENDIF
C
          IF(TEND.LE.0.0)THEN
            NS=NS + (NTEMPR-1)
            DSUM=0.0D0
            DTERM2=DBLE(TEMP2(NI))
            DO4680I=1,NTEMPR-1
              DTERM1=DBLE(TEMP2(I))
              DSUM=DSUM + DLOG(DTERM2/DTERM1)
              ICNT=ICNT+1
              TEMP8(ICNT)=REAL(DTERM1/DTERM2)
 4680       CONTINUE
            DSUM1=DSUM1 + DSUM
            TEMP6(ISET)=REAL(NTEMPR-1)
            TEMP7(ISET)=REAL(DTERM2)
          ELSE
            NS=NS + NTEMPR
            DSUM=0.0D0
            DTERM2=DBLE(TEND)
            DO4685I=1,NTEMPR
              DTERM1=DBLE(TEMP2(I))
              DSUM=DSUM + DLOG(DBLE(DTERM2/DTERM1))
              ICNT=ICNT+1
              TEMP8(ICNT)=REAL(DTERM1/DTERM2)
 4685       CONTINUE
            DSUM1=DSUM1 + DSUM
            TEMP6(ISET)=REAL(NTEMPR)
            TEMP7(ISET)=REAL(DTERM2)
          ENDIF
C
          IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLPL')THEN
            WRITE(ICOUT,4686)NS,DSUM
 4686       FORMAT('NS,DSUM = ',I10,G15.7)
            CALL DPWRST('XXX','BUG ')
          ENDIF
C
 4690   CONTINUE
C
        BHAT=DBLE(NS-1)/DSUM1
        DSUM=0.0D0
        DO4688ISET=1,NUMSET
C
          IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLPL')THEN
            WRITE(ICOUT,4689)ISET,TEMP5(ISET),TEMP7(ISET)
 4689       FORMAT('ISET,TEMP5(ISET),TEMP7(ISET) = ',I10,2G15.7)
            CALL DPWRST('XXX','BUG ')
          ENDIF
C
          IF(TEMP6(ISET).GT.0.5)THEN
            DSUM=DSUM + TEMP7(ISET)**BHAT
          ENDIF
 4688   CONTINUE
        AHAT=DBLE(NS)/DSUM
C
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of A:'
        NCTEXT(ICNT)=14
        AVALUE(ICNT)=AHAT
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of B:'
        NCTEXT(ICNT)=14
        AVALUE(ICNT)=BHAT
        IDIGIT(ICNT)=NUMDIG
C
        NUMROW=ICNT
        DO2410I=1,NUMROW
          NTOT(I)=15
 2410   CONTINUE
C
        IFRST=.TRUE.
        ILAST=.TRUE.
        CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1              AVALUE,IDIGIT,
     1              NTOT,NUMROW,
     1              ICAPSW,ICAPTY,ILAST,IFRST,
     1              ISUBRO,IBUGA3,IERROR)
C
      ENDIF
C
      CALL SORT(TEMP8,ICNT,TEMP8)
      ACNT=REAL(ICNT)
      DSUM=0.0D0
      DO4810I=1,ICNT
        AI=REAL(I)
        DTERM1=DBLE(TEMP8(I)**BHAT - (2.0*AI-1.0)/(2.0*ACNT))**2
        DSUM=DSUM + DTERM1
 4810 CONTINUE
      CNS=(1.0/(12.0*ACNT)) + REAL(DSUM)
C
      IF(ICNT.EQ.2)THEN
        CV020=0.138
        CV015=0.149
        CV010=0.162
        CV005=0.175
        CV001=0.186
      ELSEIF(ICNT.EQ.3)THEN
        CV020=0.121
        CV015=0.135
        CV010=0.154
        CV005=0.184
        CV001=0.230
      ELSEIF(ICNT.EQ.4)THEN
        CV020=0.121
        CV015=0.134
        CV010=0.155
        CV005=0.191
        CV001=0.280
      ELSEIF(ICNT.EQ.5)THEN
        CV020=0.121
        CV015=0.137
        CV010=0.160
        CV005=0.199
        CV001=0.300
      ELSEIF(ICNT.EQ.6)THEN
        CV020=0.123
        CV015=0.139
        CV010=0.162
        CV005=0.204
        CV001=0.310
      ELSEIF(ICNT.EQ.7)THEN
        CV020=0.124
        CV015=0.140
        CV010=0.165
        CV005=0.208
        CV001=0.320
      ELSEIF(ICNT.EQ.8)THEN
        CV020=0.124
        CV015=0.141
        CV010=0.165
        CV005=0.208
        CV001=0.320
      ELSEIF(ICNT.EQ.9)THEN
        CV020=0.124
        CV015=0.142
        CV010=0.167
        CV005=0.212
        CV001=0.320
      ELSEIF(ICNT.EQ.10)THEN
        CV020=0.125
        CV015=0.142
        CV010=0.167
        CV005=0.212
        CV001=0.320
      ELSEIF(ICNT.EQ.11)THEN
        CV020=0.126
        CV015=0.143
        CV010=0.169
        CV005=0.214
        CV001=0.320
      ELSEIF(ICNT.EQ.12)THEN
        CV020=0.126
        CV015=0.144
        CV010=0.169
        CV005=0.214
        CV001=0.320
      ELSEIF(ICNT.EQ.13)THEN
        CV020=0.126
        CV015=0.144
        CV010=0.169
        CV005=0.214
        CV001=0.330
      ELSEIF(ICNT.EQ.14)THEN
        CV020=0.126
        CV015=0.144
        CV010=0.169
        CV005=0.214
        CV001=0.330
      ELSEIF(ICNT.EQ.15)THEN
        CV020=0.126
        CV015=0.144
        CV010=0.169
        CV005=0.215
        CV001=0.330
      ELSEIF(ICNT.EQ.16)THEN
        CV020=0.127
        CV015=0.145
        CV010=0.171
        CV005=0.216
        CV001=0.330
      ELSEIF(ICNT.EQ.17)THEN
        CV020=0.127
        CV015=0.145
        CV010=0.171
        CV005=0.217
        CV001=0.330
      ELSEIF(ICNT.EQ.18)THEN
        CV020=0.127
        CV015=0.146
        CV010=0.171
        CV005=0.217
        CV001=0.330
      ELSEIF(ICNT.EQ.19)THEN
        CV020=0.127
        CV015=0.146
        CV010=0.171
        CV005=0.217
        CV001=0.330
      ELSEIF(ICNT.GE.20 .AND. ICNT.LE.25)THEN
        CV020=0.128
        CV015=0.146
        CV010=0.172
        CV005=0.217
        CV001=0.330
      ELSEIF(ICNT.GE.26 .AND. ICNT.LE.45)THEN
        CV020=0.128
        CV015=0.146
        CV010=0.172
        CV005=0.218
        CV001=0.330
      ELSEIF(ICNT.GE.46 .AND. ICNT.LE.80)THEN
        CV020=0.128
        CV015=0.146
        CV010=0.173
        CV005=0.220
        CV001=0.330
      ELSE
        CV020=0.129
        CV015=0.147
        CV010=0.173
        CV005=0.220
        CV001=0.34
      ENDIF
C
      ITITLE='Power Law Goodness Of Fit Test'
      NCTITL=30
      ITITLZ=' '
      NCTITZ=0
C
      ICNT=1
      ITEXT(ICNT)='H0: Repair Times Follow a Power Law Model'
      NCTEXT(ICNT)=41
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Ha: Repair Times Do Not Follow a Power Law Model'
      NCTEXT(ICNT)=48
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Value of Ns:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=REAL(NS)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Value of Test Statistic:'
      NCTEXT(ICNT)=24
      AVALUE(ICNT)=CNS
      IDIGIT(ICNT)=NUMDIG
C
      NUMROW=ICNT
      DO2610I=1,NUMROW
        NTOT(I)=15
 2610 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
      ITITLE='Upper One-Tailed Test'
      NCTITL=21
      ITITL9='H0: Power Law, Ha: Not Power Law'
      NCTIT9=32
C
      DO2830J=1,4
        DO2840I=1,3
          ITITL2(I,J)=' '
          NCTIT2(I,J)=0
 2840   CONTINUE
 2830 CONTINUE
C
      ITITL2(2,1)='Confidence'
      NCTIT2(2,1)=11
      ITITL2(3,1)='Value (%)'
      NCTIT2(3,1)=9
C
      ITITL2(2,2)='Test '
      NCTIT2(2,2)=4
      ITITL2(3,2)='Statistic'
      NCTIT2(3,2)=9
C
      ITITL2(2,3)='Critical'
      NCTIT2(2,3)=8
      ITITL2(3,3)='Value (>)'
      NCTIT2(3,3)=9
C
      ITITL2(1,4)='Null'
      NCTIT2(1,4)=4
      ITITL2(2,4)='Hypothesis'
      NCTIT2(2,4)=10
      ITITL2(3,4)='Conclusion'
      NCTIT2(3,4)=10
C
      NMAX=0
      NUMCOL=4
      DO2150I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        NMAX=NMAX+NTOT(I)
        ITYPCO(I)='NUME'
        IDIGIT(I)=NUMDIG
        IF(I.EQ.1 .OR. I.EQ.4)THEN
          ITYPCO(I)='ALPH'
        ENDIF
 2150 CONTINUE
C
      IWHTML(1)=125
      IWHTML(2)=175
      IWHTML(3)=175
      IWHTML(4)=175
      IINC=1800
      IINC2=1400
      IWRTF(1)=IINC
      IWRTF(2)=IWRTF(1)+IINC
      IWRTF(3)=IWRTF(2)+IINC
      IWRTF(4)=IWRTF(3)+IINC
C
      DO2860J=1,NUMAL2
C
        AMAT(J,2)=CNS
        IF(J.EQ.1)THEN
          AMAT(J,3)=CV020
        ELSEIF(J.EQ.2)THEN
          AMAT(J,3)=CV015
        ELSEIF(J.EQ.3)THEN
          AMAT(J,3)=CV010
        ELSEIF(J.EQ.4)THEN
          AMAT(J,3)=CV005
        ELSEIF(J.EQ.5)THEN
          AMAT(J,3)=CV001
        ENDIF
        IVALUE(J,4)(1:6)='REJECT'
        IF(ABS(CNS).LT.AMAT(J,3))THEN
          IVALUE(J,4)(1:6)='ACCEPT'
        ENDIF
        NCVALU(J,4)=6
C
        ALPHAT=100.0*(1.0 - ALPHA(J))
        WRITE(IVALUE(J,1)(1:4),'(F4.1)')ALPHAT
        IVALUE(J,1)(5:5)='%'
        NCVALU(J,1)=5
 2860 CONTINUE
C
      ICNT=NUMAL2
      NUMLIN=3
      NUMCOL=4
      IFRST=.TRUE.
      ILAST=.TRUE.
      IFLAGS=.TRUE.
      IFLAGE=.TRUE.
      CALL DPDTA5(ITITLE,NCTITL,
     1            ITITL9,NCTIT9,ITITL2,NCTIT2,
     1            MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1            IVALUE,NCVALU,AMAT,ITYPCO,NUMALP,NUMAL2,
     1            IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1            ICAPSW,ICAPTY,IFRST,ILAST,
     1            IFLAGS,IFLAGE,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLPL')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLPL--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9015)BHAT,AHAT,AMTBF,IERROR
 9015   FORMAT('BHAT,AHAT,AMTBF,IERROR = ',3G15.7,2X,A4)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLPN(TIMEL,TIMEU,RLNGTH,N,
     1                  NPAR,X,E,COV,CORR,SCL,H,STPSZ,FNBR,ALLFIX,
     1                  ILOG,IPRNT,
     1                  YTEMP1,DTEMP1,DTEMP2,IINDEX,MAXOBV,
     1                  ICAPTY,ICAPSW,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     TIMEL   = LOWER INTERVAL FOR FAILURE TIME
C     TIMEU   = UPPER INTERVAL FOR FAILURE TIME
C     RLNGTH  = LENGTH VARIABLE
C     N       = NUMBER OF OBSERVATIONS
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR THE POWER NORMAL DISTRIBUTION
C     EXAMPLE--POWER NORMAL MAXIMUM LIKELIHOOD Y
C     REFERENCE--WAYNE NELSON AND NECIP DOGANAKSOY, "A COMPUTER
C                PROGRAM POWNOR FOR FITTING THE POWER-NORMAL AND
C                -LOGNORMAL MODELS TO LIFE OR STRENGTH DATA FROM
C                SPECIMENS OF VARIOUS SIZES", NISTIR 4760, 3/1992.
C                PROJECT: 1990-91 ASA/NIST/NSF FELLOWSHIP
C     NOTE--DATAPLOT USES THE POWNOR SOFTWARE TO COMPUTE THE MAXIMUM
C           LIKELIHOOD ESTIMATES.  THIS CODE HAS BEEN MODIFIED SLIGHTLY
C           FOR INCORPORATION INTO DATAPLOT (THE BASIC NUMERICS HAVE
C           NOT BEEN MODIFIED).
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2008/7
C     ORIGINAL VERSION--JULY      2008.
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION X(NPAR)
      DOUBLE PRECISION E(NPAR)
      DOUBLE PRECISION SCL(NPAR)
      DOUBLE PRECISION STPSZ(NPAR)
      DOUBLE PRECISION FNBR(NPAR)
C
      DOUBLE PRECISION COV(NPAR,NPAR)
      DOUBLE PRECISION CORR(NPAR,NPAR)
      DOUBLE PRECISION H(NPAR,NPAR)
C
      DOUBLE PRECISION YTEMP1(*)
      DOUBLE PRECISION TIMEL(*)
      DOUBLE PRECISION TIMEU(*)
      DOUBLE PRECISION RLNGTH(*)
      DOUBLE PRECISION DTEMP1(*)
      DOUBLE PRECISION DTEMP2(*)
      DOUBLE PRECISION SLENGT(15)
C
      INTEGER IINDEX(*)
C
      LOGICAL TRANS
      LOGICAL ALLFIX
C
      CHARACTER*4 IBUGA3
      CHARACTER*4 ISUBRO
      CHARACTER*4 ICAPTY
      CHARACTER*4 ICAPSW
      CHARACTER*4 IERROR
      CHARACTER*4 IFOUND
C
      CHARACTER*4 ISTEPN
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISUBN0
C
      CHARACTER*24 GDATE
      CHARACTER*24 GTIME
C
      CHARACTER*40 ITITLE
C
      INCLUDE 'DPCOF2.INC'
C
      CHARACTER*80 IFILE1
      CHARACTER*12 ISTAT1
      CHARACTER*12 IFORM1
      CHARACTER*12 IACCE1
      CHARACTER*12 IPROT1
      CHARACTER*12 ICURS1
      CHARACTER*4 IERRF1
      CHARACTER*4 IENDF1
      CHARACTER*4 IREWI1
C
      COMMON /PNRDAT/ ISS
      COMMON /PNRFVA/ RMUFIX,RLNSFX,RLNLNF
      COMMON /PNRVAR/ MUTYPE,LNSGTY,LNLNTY
      COMMON /LENGTH/ SLENGT,NOLENG
      COMMON /LSTD/ TRANS
      COMMON /IO/INPUT,IOUT
C
      DOUBLE PRECISION PNRFUN
      EXTERNAL PNRFUN
      EXTERNAL POWELD
      EXTERNAL HESS
C
      REAL CPUMIN
      REAL CPUMAX
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      GTIME=' '
      GDATE=' '
      CALL DPTIME(GTIME,NCURRT,GDATE,NCURRD,
     1            IBUGA3,ISUBRO,IFOUND,IERROR)
      ZERO=0.D0
      NLEFTC=0
      NRGHTC=0
      NINTC=0
      NCOMP=0
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK INPUT FOR ERRORS.               **
C               ********************************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLPN')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      DO1118I=1,N
        IF(TIMEL(I).EQ.TIMEU(I).AND.TIMEL(I).EQ.-1E10)THEN
          CALL PNRERR(4,I)
        ELSEIF (TIMEL(I).EQ.TIMEU(I).AND.TIMEL(I).EQ.1E10)THEN
          CALL PNRERR(4,I)
        ELSEIF (TIMEL(I).EQ.-1E10.AND.TIMEU(I).EQ.1E10)THEN
          CALL PNRERR(4,I)
        ELSEIF (TIMEL(I).LT.-1E10.OR.TIMEU(I).GT.1E10)THEN
          CALL PNRERR(4,I)   
        ELSEIF (TIMEL(I).GT.TIMEU(I))THEN
          CALL PNRERR(4,I)
        ELSEIF (ILOG.EQ.1) THEN
          IF (TIMEL(I).NE.-1E10.AND.TIMEL(I).LE.0.D0)THEN
            CALL PNRERR(4,I)
          ELSEIF (TIMEU(I).LE.0.D0)THEN
            CALL PNRERR(4,I)
          ENDIF
        ENDIF
C
        IF (TIMEL(I).EQ.TIMEU(I))THEN
           IF (ILOG.EQ.1)TIMEL(I)=LOG(TIMEL(I))
           IF (ILOG.EQ.1)TIMEU(I)=LOG(TIMEU(I))
           NCOMP=NCOMP+1
           GOTO 1118
        ENDIF
C
        IF (TIMEL(I).EQ.-1E10)THEN
           IF (ILOG.EQ.1) TIMEU(I)=LOG(TIMEU(I))
           NLEFTC=NLEFTC+1
           GOTO 1118
        ENDIF
C
        IF (TIMEU(I).EQ.1E10)THEN
           IF (ILOG.EQ.1)TIMEL(I)=LOG(TIMEL(I))
           NRGHTC=NRGHTC+1
           GOTO 1118
        ENDIF
C
        IF (TIMEL(I).LT.TIMEU(I))THEN
           IF (ILOG.EQ.1)TIMEL(I)=LOG(TIMEL(I))
           IF (ILOG.EQ.1)TIMEU(I)=LOG(TIMEU(I))
           NINTC=NINTC+1
           GOTO 1118
        ENDIF
C
 1118 CONTINUE
C
C               ********************************************
C               **  STEP 12--                             **
C               **  OPEN "ITERATIONS" FILE.               **
C               ********************************************
C
      ISTEPN='12'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLPN')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRNT.EQ.1)THEN
        IOUNI1=IST1NU
        IFILE1=IST1NA
        ISTAT1=IST1ST
        IFORM1=IST1FO
        IACCE1=IST1AC
        IPROT1=IST1PR
        ICURS1=IST1CS
        ISUBN0='POT2'
        IERRF1='NO'
C
        IREWI1='ON'
        CALL DPOPFI(IOUNI1,IFILE1,ISTAT1,IFORM1,IACCE1,IPROT1,ICURS1,
     1              IREWI1,ISUBN0,IERRF1,IBUGA3,ISUBRO,IERROR)
        IF(IERRF1.EQ.'YES')GOTO9000
C
      ENDIF
C
   88 CONTINUE
      ISS=I-1
      IF (ALLFIX) THEN
         IPRNT=0
         TRANS=.FALSE.
         F=PNRFUN(X,NPAR,TIMEL,TIMEU,RLNGTH)
         GOTO 177
      ENDIF
C
      IF(IPRNT.EQ.1)THEN
        WRITE(IOUNI1,*) 'ITERATIONS:                   ',GDATE,
     1                  '  ',GTIME
        WRITE(IOUNI1,*)
      ENDIF
C
C               ********************************************
C               **  STEP 21--                             **
C               **  ML ESTIMATION OF PARAMETERS VIA       **
C               **  POWELL ALGORITHM.                     **
C               ********************************************
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLPN')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      DO 334 I=1,NPAR
         E(I)=0.0001D0
  334 CONTINUE
      ESCALE=1000.D0
      ICON=1
      MAXIT=100
C
      CALL POWELD(X,E,NPAR,F,ESCALE,IPRNT,ICON,MAXIT,PNRFUN,
     1            TIMEL,TIMEU,RLNGTH)
      TRANS=.FALSE.
      F=PNRFUN(X,NPAR,TIMEL,TIMEU,RLNGTH)
C
C               ********************************************
C               **  STEP 22--                             **
C               **  LOCAL ESTIMATE OF THE INFORMATION     **
C               **  MATRIX VIA NUMERICAL PERTURBATION     **
C               ********************************************
C
      ISTEPN='22'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLPN')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      DO 77 I=1,NPAR
         SCL(I)=1./DABS(X(I))
   77 CONTINUE
      TRANS=.FALSE.
      CALL HESS(PNRFUN,X,NPAR,SCL,STPSZ,FNBR,H,TIMEL,TIMEU,RLNGTH)
C
C               **********************************************
C               **  STEP 23--                               **
C               **  COVARIANCE MATRIX OF ESTIMATES BY       **
C               **  INVERTING THE LOCAL INFORMATION MATRIX  **
C               **********************************************
C
      ISTEPN='23'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLPN')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
CCCCC CALL ERSET(0,0,0)
CCCCC CALL DLINDS (NPAR,H,NPAR,COV,NPAR)
CCCCC ICODE=IERCD()
CCCCC IF (ICODE.NE.0)CALL PNRERR(6,0)
CCCCC CALL ERSET(0,2,2)
C
      DO2511I=1,NPAR
        DO2512J=1,NPAR
          COV(I,J)=H(I,J)
 2512   CONTINUE
 2511 CONTINUE
C
      CALL DGECO(COV,NPAR,NPAR,IINDEX,RCOND,YTEMP1)
      EPS=1.0E-20
      IF(RCOND.LE.EPS)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2571)
 2571   FORMAT('****** ERROR IN POWER NORMAL MAXIMUM LIKELIHOOD--')
        CALL DPWRST('XXX','ERRO ')
        WRITE(ICOUT,2572)
 2572   FORMAT('       THE FISHER INFORMATION MATRIX IS SINGULAR.')
        CALL DPWRST('XXX','ERRO ')
        WRITE(ICOUT,2573)
 2573   FORMAT('       UNABLE TO COMPUTE THE COVARIANCE MATRIX.')
        CALL DPWRST('XXX','ERRO ')
        DO2581I=1,NPAR
          DO2582J=1,NPAR
            COV(I,J)=0.0D0
 2582     CONTINUE
 2581   CONTINUE
      ELSE
        IJOB=1
        CALL DGEDI(COV,NPAR,NPAR,IINDEX,DTEMP1,DTEMP2,IJOB)
      END IF
C
C               **********************************************
C               **  STEP 24--                               **
C               **  CORRELATION MATRIX OF ESTIMATES BY      **
C               **  INVERTING THE LOCAL INFORMATION MATRIX  **
C               **********************************************
C
      ISTEPN='24'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLPN')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      DO 179 I=1,NPAR
         DO 180 J=1,NPAR
            IF (I.EQ.J) THEN
                CORR(I,J)=1.D0
            ELSE
                CORR(I,J)=COV(I,J)*((COV(I,I)*COV(J,J))**(-.5D0))
            ENDIF
180      CONTINUE
179   CONTINUE
C
C               **********************************************
C               **  STEP 31--                               **
C               **  PRINT OUT RESULTS                       **
C               **********************************************
C
      ISTEPN='31'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLPN')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
  177 CONTINUE
      IF(IPRINT.EQ.'ON')THEN
      IF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'HTML')THEN
      ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'LATE')THEN
      ELSEIF(ICAPSW.EQ.'ON' .AND. ICAPTY.EQ.'RTF')THEN
      ELSE
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,4011)GDATE,GTIME
 4011   FORMAT('POWNOR VERSION 1.0     ',A24,'  ',A24)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,4013)
 4013   FORMAT('DEVELOPED BY NECIP DOGANAKSOY AND WAYNE NELSON UNDER ',
     1         '1991 FELLOWSHIP')
        WRITE(ICOUT,4015)
 4015   FORMAT('GRANT FROM ASA/NSF/NIST. THE PROGRAM IS DOCUMENTED ',
     1         'IN NIST-IR 4760.')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,4021) ISS
 4021   FORMAT('TOTAL NUMBER OF DATA CASES       = ',I8)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,4023)NCOMP
 4023   FORMAT('EXACT OBSERVASTIONS              = ',I8)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,4025)NRGHTC
 4025   FORMAT('LEFT CENSORED OBSERVATIONS       = ',I8)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,4027)NLEFTC
 4027   FORMAT('LEFT CENSORED OBSERVATIONS       = ',I8)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,4028)NINTC
 4028   FORMAT('INTERVAL CENSORED OBSERVATIONS   = ',I8)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
C
        IF(ALLFIX) THEN
          WRITE(ICOUT,4031) -F
 4031     FORMAT('LOG-LIKELIHOOD                   =  ',F10.4)
          CALL DPWRST('XXX','WRIT')
        ELSE
          WRITE(ICOUT,4033) -F
 4033     FORMAT('MAXIMIZED LOG-LIKELIHOOD           = ',F10.4)
          CALL DPWRST('XXX','WRIT')
        ENDIF
C
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        IF(ALLFIX) THEN
          WRITE(ICOUT,4041)
 4041     FORMAT('PARAMETER ESTIMATES')
          CALL DPWRST('XXX','WRIT')
        ELSE
          WRITE(ICOUT,4043)
 4043     FORMAT('MAXIMUM LIKELIHOOD ESTIMATES FOR DISTRIBUTION ',
     1           'PARAMETERS')
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,4045)
 4045     FORMAT('WITH APPROXIMATE 95% CONFIDENCE LIMITS')
          CALL DPWRST('XXX','WRIT')
        ENDIF
C
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        IF(ALLFIX) THEN
          WRITE(ICOUT,4047)
 4047     FORMAT('PARAMETER                 ESTIMATE')
          CALL DPWRST('XXX','WRIT')
        ELSE
          WRITE(ICOUT,4049)
 4049     FORMAT('PARAMETER              ML ESTIMATE    LOWER LIMIT',
     1           'UPPER LIMIT     STD. ERROR')
          CALL DPWRST('XXX','WRIT')
        ENDIF
C
    5   FORMAT(I1,A18,3X,F12.4,3X,F12.4,3X,F12.4,3X,F12.4)
    6   FORMAT(A19,3X,F12.4,2X,A12)
        IF (MUTYPE.EQ.0) THEN
           I1=I1+1
           STDERR=(COV(I1,I1))**(.5D0)
           RLOWCL=X(I1)-1.96D0*STDERR
           RUPCL=X(I1)+1.96D0*STDERR
           WRITE(ICOUT,5) I1,' MU               ',
     1                    X(I1),RLOWCL,RUPCL,STDERR
           CALL DPWRST('XXX','WRIT')
           P1=X(I1)
           VP1=COV(I1,I1)
        ELSE
           P1=RMUFIX
           VP1=0.D0
           WRITE(ICOUT,6) '  MU               ',RMUFIX,
     1                    '     *FIXED*'
           CALL DPWRST('XXX','WRIT')
        ENDIF
  
        IF (LNSGTY.EQ.0) THEN
           I1=I1+1
           STDERR=(COV(I1,I1))**(.5D0)
           RLOWCL=X(I1)-1.96D0*STDERR
           RUPCL=X(I1)+1.96D0*STDERR
           WRITE(ICOUT,5) I1,' LN(SIGMA)        ',
     1                    X(I1),RLOWCL,RUPCL,STDERR
           CALL DPWRST('XXX','WRIT')
           TP2=X(I1)
           VTP2=COV(I1,I1)
        ELSE
           TP2=RLNSFX
           VTP2=0.D0
           WRITE(ICOUT,6) '  LN(SIGMA)        ',RLNSFX,
     1                    '     *FIXED*'
           CALL DPWRST('XXX','WRIT')
        ENDIF
C
        IF (LNLNTY.EQ.0) THEN
           I1=I1+1
           STDERR=(COV(I1,I1))**(.5D0)
           RLOWCL=X(I1)-1.96D0*STDERR
           RUPCL=X(I1)+1.96D0*STDERR
           WRITE(ICOUT,5) I1,' LN(NORMAL LENGTH)',X(I1),
     1                    RLOWCL,RUPCL,STDERR
           CALL DPWRST('XXX','WRIT')
           TP3=X(I1)
           VTP3=COV(I1,I1)
        ELSE
           TP3=RLNLNF
           VTP3=0.D0
           WRITE(ICOUT,6) '  LN(NORMAL LENGTH)',RLNLNF,
     1                    '     *FIXED*'
           CALL DPWRST('XXX','WRIT')
        ENDIF
C
        CP1TP2=0.D0
        CP1TP3=0.D0
        CTP2T3=0.D0
C
        IF(MUTYPE.EQ.0.AND.LNSGTY.EQ.0.AND.LNLNTY.EQ.0)THEN
          CP1TP2=COV(1,2)
          CP1TP3=COV(1,3)
          CTP2T3=COV(2,3)
        ENDIF
C
        IF(MUTYPE.EQ.1.AND.LNSGTY.EQ.0.AND.LNLNTY.EQ.0)THEN
          CTP2T3=COV(1,2)
        ELSEIF(MUTYPE.EQ.0.AND.LNSGTY.EQ.1.AND.LNLNTY.EQ.0)THEN
          CP1TP3=COV(1,2)
        ELSEIF(MUTYPE.EQ.0.AND.LNSGTY.EQ.0.AND.LNLNTY.EQ.1)THEN
          CP1TP2=COV(1,2)
        ENDIF
C
        IF(NPAR.EQ.1)GOTO 1799
CCCCC   CALL UMACH(-2,12)
CCCCC   CALL WROPT(-6,1,1)
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
C
CCCCC   CALL DWRRRN ('ESTIMATED INFORMATION MATRIX',NPAR,NPAR,H,NPAR,0)
        ITITLE='ESTIMATED INFORMATION MATRIX'
        CALL PNRWMA(ITITLE,NPAR,H,ICAPSW,ICAPTY)
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
C
CCCCC   CALL DWRRRN ('ESTIMATED COVARIANCE MATRIX',NPAR,NPAR,COV,NPAR,0)
        ITITLE='ESTIMATED COVARIANCE MATRIX'
        CALL PNRWMA(ITITLE,NPAR,COV,ICAPSW,ICAPTY)
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
C
CCCCC   CALL DWRRRN ('ESTIMATED CORRELATION MATRIX',NPAR,NPAR,CORR,NPAR,0)
        ITITLE='ESTIMATED CORRELATION MATRIX'
        CALL PNRWMA(ITITLE,NPAR,CORR,ICAPSW,ICAPTY)
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
C
      ENDIF
      ENDIF
C
1799  CONTINUE
      CALL PNRPER(P1,TP2,TP3,VP1,VTP2,VTP3,CP1TP2,CP1TP3,CTP2T3,
     1            SLENGT,NOLENG,ALLFIX,
     1            ICAPTY,ICAPSW)
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLPN')THEN
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLPO(Y,X,N,NVAR,
     1                  TEMP1,TEMP2,TEMP3,MAXNXT,
     1                  ALAMB,ALMBSE,XMIN,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR POISSON DISTRIBUTION
C     EXAMPLE--POISSON MAXIMUM LIKELIHOOD Y
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--98/3
C     ORIGINAL VERSION--MARCH     1998.
C     UPDATED         --MARCH     2004. SUPPORT FOR HTML, LATEX
C     UPDATED         --AUGUST    2005. REFORMAT FOR CONSISTENCY WITH
C                                       OTHER ML ROUTINES
C     UPDATED         --SEPTEMBER 2005. CONFIDENCE INTERVALS FOR
C                                       LAMBDA
C     UPDATED         --APRIL     2011. USE DPDTA1 AND DPDTA4 TO PRINT
C                                       OUTPUT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      PARAMETER (NUMALP=5)
      DIMENSION ALPHA(NUMALP)
      DIMENSION ALOWNO(NUMALP)
      DIMENSION AUPPNO(NUMALP)
C
      REAL POIFUN
      EXTERNAL POIFUN
      COMMON/POICOM/XSUM,CONST,NTEMP
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION TEMP1(*)
      DIMENSION TEMP2(*)
      DIMENSION TEMP3(*)
C
      PARAMETER (MAXROW=15)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*60 ITITL9
      CHARACTER*40 IDIST
      CHARACTER*40 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(MAXROW)
      CHARACTER*4  VALIGN(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL      IFRST
      LOGICAL      ILAST
C
      PARAMETER(NUMCLI=3)
      PARAMETER(MAXLIN=2)
      CHARACTER*60 ITITL2(MAXLIN,NUMCLI)
      INTEGER      NCTIT2(MAXLIN,NUMCLI)
      INTEGER      IWHTML(NUMCLI+1)
      INTEGER      IWRTF(NUMCLI)
      REAL         AMAT(NUMALP,NUMCLI)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
CCCCC DATA ALPHA /0.50, 0.25, 0.10, 0.05, 0.01, 0.001/
      DATA ALPHA /0.50, 0.25, 0.10, 0.05, 0.01/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='PO  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLPO')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLPO--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N,NVAR
   52   FORMAT('IBUGA3,ISUBRO,N,NVAR = ',2(A4,2X),2I8)
        CALL DPWRST('XXX','WRIT')
        IF(NVAR.EQ.1)THEN
          DO56I=1,MIN(N,100)
            WRITE(ICOUT,57)I,Y(I)
   57       FORMAT('I,Y(I) = ',I8,G15.7)
            CALL DPWRST('XXX','WRIT')
   56     CONTINUE
        ELSE
          DO61I=1,N
            WRITE(ICOUT,62)I,X(I),Y(I)
   62       FORMAT('I,X(I),Y(I) = ',I8,2G15.7)
            CALL DPWRST('XXX','WRIT')
   61     CONTINUE
        ENDIF
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  1) ROUND DATA TO INTEGER VALUES       **
C               **  2) COMPUTE SUMMARY STATISTICS         **
C               **  3) CHECK INPUT FOR NEGATIVE VALUES,   **
C               **     INSUFFICIENT SAMPLE SIZE           **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLPO')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IDIST='POISSON'
C
      NPERC=0
      MAXGRP=MAXNXT/2
      NMIN=2
      IF(NVAR.EQ.1)THEN
        DO1105I=1,N
          ITEMP=INT(Y(I)+0.5)
          Y(I)=REAL(ITEMP)
 1105   CONTINUE
        CALL CKDIST(Y,N,NMIN,TEMP1,NPERC,ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
        IFLAG=1
        CALL SUMRAW(Y,N,IDIST,IFLAG,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        CALL SUMDP(Y,N,IWRITE,XSUM,IBUGA3,IERROR)
        NTOTZZ=N
      ELSE
        CALL CKDIS2(Y,X,TEMP1,N,MAXGRP,NMIN,TEMP2,NPERC,NTOTZZ,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IFLAG1=1
        IFLAG2=1
        CALL SUMGRP(Y,X,N,IDIST,IFLAG1,IFLAG2,
     1              TEMP1,TEMP2,TEMP3,MAXNXT,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ,
     1              ISUBRO,IBUGA3,IERROR)
        XSUM=0.0
        DO1211I=1,N
          XSUM=XSUM + Y(I)*X(I)
 1211   CONTINUE
      ENDIF
      IF(IERROR.EQ.'YES')GOTO9000
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLPO')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1311)
 1311   FORMAT('AFTER COMPUTE SUMMARY STATISTICS--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1312)XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ
 1312   FORMAT('XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ = ',5G15.7,I10)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
C               *******************************
C               **  STEP 41--                **
C               **  CARRY OUT CALCULATIONS   **
C               **  FOR POISON MLE ESTIMATE  **
C               *******************************
C
      ALAMB=XMEAN
      ALMBSE=SQRT(ALAMB/REAL(NTOTZZ))
C
      NTEMP=NTOTZZ
      AE=1.E-5
      RE=1.E-5
      IFLAG=0
C
      DO2210I=1,NUMALP
C
        ALP=ALPHA(I)
        P1=ALP/2.0
        P2=1.0-(ALP/2.0)
C
        ITER=0
        CONST=P2
        ALOWLI=ALAMB - 5.0*ALMBSE
        IF(ALOWLI.LE.0.0)ALOWLI=0.00001
        AUPPLI=ALAMB
        ALOWSV=ALAMB - 5.0*ALMBSE
        ALAHAT=(AUPPLI+ALOWLI)/2.0
 2201   CONTINUE
        IFLAG=0
        CALL FZERO(POIFUN,ALOWLI,AUPPLI,ALAHAT,RE,AE,IFLAG)
        ALOWNO(I)=ALOWLI
        IF(IFLAG.EQ.2)THEN
C
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2211)
 2211     FORMAT('***** WARNING FROM POISSON MAXIMUM LIKELIHOOD--')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2213)
 2213     FORMAT('      ESTIMATE OF LOWER CONFIDENCE VALUE FOR ',
     1           'LAMBDA MAY NOT BE COMPUTED TO DESIRED TOLERANCE.')
          CALL DPWRST('XXX','BUG ')
        ELSEIF(IFLAG.EQ.3)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2211)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2223)
 2223     FORMAT('      ESTIMATE OF LOWER CONFIDENCE VALUE FOR ',
     1             'LAMBDA MAY BE NEAR A SINGULAR POINT.')
          CALL DPWRST('XXX','BUG ')
        ELSEIF(IFLAG.EQ.4)THEN
          ITER=ITER+1
          ALOWLI=ALOWSV/2.0
          AUPPLI=ALAMB
          ALAHAT=(AUPPLI+ALOWLI)/2.0
          IF(ITER.LT.10)GOTO2201
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2211)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2233)
 2233     FORMAT('      APPROPRIATE BRACKETING INTERVAL NOT FOUND.')
          CALL DPWRST('XXX','BUG ')
        ELSEIF(IFLAG.EQ.5)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2211)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2243)
 2243     FORMAT('      MAXIMUM ITERATIONS EXCEEDED.')
          CALL DPWRST('XXX','BUG ')
        ENDIF
C
        ITER=0
        IFLAG=0
        CONST=P1
        ALAHAT=ALAMB
        ALOWLI=ALAHAT
        IF(ALOWLI.LE.0.0)ALOWLI=0.00001
        AUPPLI=ALAHAT + 5.0*ALMBSE
        AUPPSV=AUPPLI
        AUPPLI=ALAMB + 5.0*ALMBSE
        ALOWLI=ALAMB
        AUPPSV=ALAMB + 5.0*ALMBSE
        ALAHAT=(AUPPLI+ALOWLI)/2.0
2251    CONTINUE
        IFLAG=0
        CALL FZERO(POIFUN,ALOWLI,AUPPLI,ALAHAT,RE,AE,IFLAG)
        AUPPNO(I)=ALOWLI
        IF(IFLAG.EQ.2)THEN
C
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2211)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2263)
 2263     FORMAT('      ESTIMATE OF UPPER CONFIDENCE VALUE FOR P ',
     1           'MAY NOT BE COMPUTED TO DESIRED TOLERANCE.')
          CALL DPWRST('XXX','BUG ')
        ELSEIF(IFLAG.EQ.3)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2211)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2273)
 2273     FORMAT('      ESTIMATE OF UPPER CONFIDENCE VALUE FOR P ',
     1           'MAY BE NEAR A SINGULAR POINT.')
          CALL DPWRST('XXX','BUG ')
        ELSEIF(IFLAG.EQ.4)THEN
          ITER=ITER+1
          AHIGLI=AHIGLI*2.0
          ALOWLI=ALAMB
          ALAHAT=ALAMB
          AUPPLI=AUPPSV*2.0
          IF(ITER.LT.1)GOTO2251
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2211)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2277)
 2277     FORMAT('      APPROPRIATE BRACKETING INTERVAL NOT FOUND.')
          CALL DPWRST('XXX','BUG ')
        ELSEIF(IFLAG.EQ.5)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2211)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,2283)
 2283     FORMAT('      MAXIMUM ITERATIONS EXCEEDED.')
          CALL DPWRST('XXX','BUG ')
        ENDIF
C
 2210 CONTINUE
C
C               *********************************
C               **   STEP 42--                 **
C               **   WRITE OUT EVERYTHING      **
C               **   FOR POISSON MLE ESTIMATE  **
C               **********************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLPO')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     PRINT SUMMARY STATISTICS TABLE
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Poisson Parameter Estimation'
      NCTITL=28
      ITITLZ=' '
      NCTITZ=0
C
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(NTOTZZ)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Method of Maximum Likelihood:'
      NCTEXT(ICNT)=29
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Lambda:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=ALAMB
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Standard Error of Lambda:'
      NCTEXT(ICNT)=25
      AVALUE(ICNT)=ALMBSE
      IDIGIT(ICNT)=NUMDIG
C
      NUMROW=ICNT
      DO2410I=1,NUMROW
        NTOT(I)=15
 2410 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
      ITITL9='Confidence Interval for Lambda Parameter'
      NCTIT9=40
      ITITLE=' '
      NCTITL=0
C
      NUMLIN=2
      NUMCOL=3
      DO2510J=1,NUMCLI
        DO2520I=1,NUMLIN
          ITITL2(I,J)=' '
          NCTIT2(I,J)=0
 2520   CONTINUE
 2510 CONTINUE
C
      ITITL2(1,1)='Confidence'
      ITITL2(2,1)='Value (%)'
      NCTIT2(1,1)=10
      NCTIT2(2,1)=9
C
      ITITL2(1,2)='Lower'
      ITITL2(2,2)='Limit'
      NCTIT2(1,2)=5
      NCTIT2(2,2)=5
C
      ITITL2(1,3)='Upper'
      ITITL2(2,3)='Limit'
      NCTIT2(1,3)=5
      NCTIT2(2,3)=5
C
      NMAX=0
      DO2321I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        NMAX=NMAX+NTOT(I)
        IDIGIT(I)=NUMDIG
 2321 CONTINUE
      IDIGIT(1)=2
      DO2323I=1,NUMALP
        NCTEXT(I)=0
        AMAT(I,1)=100.0*(1.0 - ALPHA(I))
        AMAT(I,2)=ALOWNO(I)
        AMAT(I,3)=AUPPNO(I)
 2323 CONTINUE
      IWHTML(1)=100
      IWHTML(2)=150
      IWHTML(3)=150
      IWHTML(4)=150
      IWRTF(1)=1600
      IWRTF(2)=IWRTF(1)+1800
      IWRTF(3)=IWRTF(2)+1800
      IFRST=.TRUE.
      ILAST=.TRUE.
C
      CALL DPDTA2(ITITL9,NCTIT9,
     1            ITITLE,NCTITL,ITITL2,NCTIT2,
     1            MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1            ITEXT,NCTEXT,AMAT,NUMALP,NUMALP,
     1            IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1            ICAPSW,ICAPTY,IFRST,ILAST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLPO')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLPO--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)IERROR,ALAMB,ALMBSE
 9012   FORMAT('IERROR,ALAMB,ALMBSE = ',A4,2X,2G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLPW(Y,X,X2,N,NUMVAR,ITYPE,A,B,
     1                  TEMP1,TEMP2,TEMP3,MAXNXT,
     1                  SHAPML,SHAPMO,SHAPSE,
     1                  ALIK,AIC,AICC,BIC,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR THE POWER DISTRIBUTION (OR THE
C              REFLECTED POWER DISTRIBUTION).  IT HANDLES EITHER
C              UNBINNED OR BINNED DATA.
C     EXAMPLE--POWER MAXIMUM LIKELIHOOD Y
C            --REFLECTED POWER MAXIMUM LIKELIHOOD Y
C            --POWER MAXIMUM LIKELIHOOD Y X
C     REFERENCE--EVANS, HASTINGS, AND PEACOCK (2000), "STATISTICAL
C                DISTRIBUTIONS", THIRD EDITION, WILEY, CHAPTER 33.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--98/6
C     ORIGINAL VERSION--JUNE      1998.
C     UPDATED         --MARCH     2004. SUPPORT FOR HTML, LATEX
C     UPDATED         --AUGUST    2005. REFORMAT OUTPUT FOR CONSISTENCY
C                                       WITH OTHER ML ROUTINES
C     UPDATED         --DECEMBER  2007. SCALE DATA TO (0,1) INTERVAL
C                                       BEFORE OBTAINING ML ESTIMATE
C     UPDATED         --MARCH     2008. SUPPORT FOR REFLECTED POWER
C                                       DISTRIBUTION
C     UPDATED         --MARCH     2008. SUPPORT FOR EQUI-SPACED
C                                       GROUPED DATA
C     UPDATED         --JULY      2010. USE DPDTA1 TO PRINT
C     UPDATED         --JULY      2010. EXTRACT ML TO POWML1 AND
C                                       POWML2
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ITYPE
      CHARACTER*4 ILIKFL
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      PARAMETER (NUMALP=6)
      DIMENSION ALPHA(NUMALP)
      DIMENSION ALOWSC(NUMALP)
      DIMENSION ALOWSH(NUMALP)
      DIMENSION AUPPSH(NUMALP)
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION X2(*)
      DIMENSION TEMP1(*)
      DIMENSION TEMP2(*)
      DIMENSION TEMP3(*)
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=20)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*40 ITEXT(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA ALPHA /0.50, 0.25, 0.10, 0.05, 0.01, 0.001/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='PW  '
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLPW')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLPW--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N,NUMVAR,A,B
   52   FORMAT('IBUGA3,ISUBRO,N,NUMVAR = ',2(A4,2X),2I8,2G15.7)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I),X(I),X2(I)
   57     FORMAT('I,Y(I),X(I),X2(I) = ',I8,3G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLPO')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IERROR='NO'
      IWRITE='OFF'
C
      NPERC=0
      NMIN=3
      IF(NUMVAR.EQ.1)THEN
        CALL CKDIST(Y,N,NMIN,TEMP2,NPERC,ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
      ELSEIF(NUMVAR.EQ.2)THEN
        CALL CKDIS2(Y,X,TEMP1,N,MAXNXT,NMIN,TEMP2,NPERC,NTOT2,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
      ELSEIF(NUMVAR.EQ.3)THEN
        CALL CKDIS3(Y,X,X2,TEMP1,N,MAXNXT,NMIN,TEMP2,NPERC,NTOT2,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
      ENDIF
C
C               **********************************
C               **  STEP 41--                   **
C               **  CARRY OUT CALCULATIONS      **
C               **  FOR POWER              MLE  **
C               **********************************
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLPO')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      ALIK=CPUMIN
      AIC=CPUMIN
      AICC=CPUMIN
      BIC=CPUMIN
C
      ZMIN=CPUMIN
      ZMAX=CPUMAX
      IF(A.NE.CPUMIN)ZMIN=A
      IF(B.NE.CPUMIN)ZMAX=B
      IF(NUMVAR.EQ.1)THEN
        DO1010I=1,N
          TEMP1(I)=Y(I)
 1010   CONTINUE
        CALL POWML1(TEMP1,N,ITYPE,
     1              XMIN,XMAX,XMEAN,XSD,
     1              SHAPMO,SHAPML,ZMIN,ZMAX,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        SHAPSE=SHAPML/SQRT(REAL(N))
        write(ipr,*)'dpmlpw: shapml,zmin,zmax=',shapml,zmin,zmax
        CALL POWLI1(Y,N,TEMP1,SHAPML,ZMIN,ZMAX,ITYPE,
     1              ALIK,AIC,AICC,BIC,
     1              ISUBRO,IBUGA3,IERROR)
        write(ipr,*)'        alik,bic=',alik,bic
      ELSEIF(NUMVAR.EQ.2 .OR. NUMVAR.EQ.3)THEN
        CALL POWML2(Y,X,X2,N,NUMVAR,ITYPE,
     1              TEMP1,TEMP2,TEMP3,
     1              XMIN,XMAX,XMEAN,XSD,NTOT2,
     1              SHAPMO,SHAPML,ZMIN,ZMAX,
     1              ISUBRO,IBUGA3,IERROR)
        SHAPSE=SHAPML/SQRT(REAL(NTOT2))
      ENDIF
C
C     STEP 2: CONFIDENCE INTERVAL FOR C BASED ON NORMAL APPROXIMATION
C
      DO2220I=1,NUMALP
        ALP=ALPHA(I)
        P=1.0-(ALP/2.0)
        CALL NORPPF(P,PPF)
        ALOWSC(I)=CPUMIN
        ALOWSH(I)=SHAPML - PPF*SHAPSE
        AUPPSH(I)=SHAPML + PPF*SHAPSE
 2220 CONTINUE
C
C               ***********************************************
C               **   STEP 42--                               **
C               **   WRITE OUT EVERYTHING                    **
C               **   FOR POWER MLE ESTIMATION                **
C               ***********************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLPW')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      IF(ITYPE.EQ.'POWE')THEN
        ITITLE='Power Parameter Estimation'
        NCTITL=26
      ELSE
        ITITLE='Reflected Power Parameter Estimation'
        NCTITL=36
      ENDIF
      ITITLZ=' '
      NCTITZ=0
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(N)
      IF(NUMVAR.GT.1)AVALUE(ICNT)=REAL(NTOT2)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Value Used for Lower Limit:'
      NCTEXT(ICNT)=27
      AVALUE(ICNT)=ZMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Value Used for Upper Limit:'
      NCTEXT(ICNT)=27
      AVALUE(ICNT)=ZMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Moments:'
      NCTEXT(ICNT)=8
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Shape (C):'
      NCTEXT(ICNT)=22
      AVALUE(ICNT)=SHAPMO
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Maximum Likelihood:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Shape (C):'
      NCTEXT(ICNT)=22
      AVALUE(ICNT)=SHAPML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Standard Error of Shape (C):'
      NCTEXT(ICNT)=28
      AVALUE(ICNT)=SHAPSE
      IDIGIT(ICNT)=NUMDIG
C
      IF(ALIK.NE.CPUMIN)THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='Log-likelihood:'
        NCTEXT(ICNT)=15
        AVALUE(ICNT)=ALIK
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='AIC:'
        NCTEXT(ICNT)=4
        AVALUE(ICNT)=AIC
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='AICc:'
        NCTEXT(ICNT)=5
        AVALUE(ICNT)=AICC
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='BIC:'
        NCTEXT(ICNT)=4
        AVALUE(ICNT)=BIC
        IDIGIT(ICNT)=-7
      ENDIF
C
      NUMROW=ICNT
      DO2320I=1,NUMROW
        NTOT(I)=15
 2320 CONTINUE
C
      IFRST=.FALSE.
      ILAST=.FALSE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
      ILIKFL='OFF'
      CALL DPDTA8(ALOWSC,ALOWSC,ALOWSC,ALOWSC,
     1            ALOWSH,AUPPSH,ALOWSH,AUPPSH,ALPHA,NUMALP,
     1            ICAPSW,ICAPTY,NUMDIG,ILIKFL,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLPW')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLPW--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012   FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9015)N
 9015   FORMAT('N = ',I8)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLPX(Y,N,MAXNXT,
     1                  TEMP1,TEMP2,DISPAR,DTEMP1,ITEMP,
     1                  SCALSV,BETASV,
     1                  SCALML,SCALSE,BETA,BETASE,COVSE,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR THE EXPONENTIAL POWER DISTRIBUTION
C              FOR THE FULL SAMPLE CASE.
C     EXAMPLE--EXPONENTIAL POWER MAXIMUM LIKELIHOOD Y
C     REFERENCE--DHILLON (1981), "LIFE DISTRIBUTIONS", IEEE
C                TRANSACTIONS ON RELIABILITY, VOL. R-30, NO. 5,
C                PP. 457-459.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2007/11
C     ORIGINAL VERSION--NOVEMBER  2007.
C     UPDATED         --JULY      2010. USE DPDTA1 TO PRINT OUTPUT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
      CHARACTER*4 IWRITE
      CHARACTER*4 ILIKFL
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      PARAMETER (NUMALP=6)
      DIMENSION ALPHA(NUMALP)
      DIMENSION ALOWSC(NUMALP)
      DIMENSION AUPPSC(NUMALP)
      DIMENSION ALOWBE(NUMALP)
      DIMENSION AUPPBE(NUMALP)
      DIMENSION ALOWS2(1)
      DIMENSION AUPPS2(1)
      DIMENSION ALOWB2(1)
      DIMENSION AUPPB2(1)
C
      DIMENSION QP(1)
      DIMENSION FISH(2,2)
      DIMENSION COV(2,2)
C
      DIMENSION Y(*)
      DIMENSION TEMP1(*)
      DIMENSION TEMP2(*)
      DIMENSION DISPAR(*)
      DOUBLE PRECISION DTEMP1(*)
      INTEGER ITEMP(*)
C
      EXTERNAL PEXFUN
C
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM2
      DOUBLE PRECISION DTERM3
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DSUM2
      DOUBLE PRECISION DSUM3
      DOUBLE PRECISION DA
      DOUBLE PRECISION DB
      DOUBLE PRECISION DC
      DOUBLE PRECISION DX
      DOUBLE PRECISION DN
      DOUBLE PRECISION DALPHA
      DOUBLE PRECISION DBETA
C
      DOUBLE PRECISION TOL
      DOUBLE PRECISION XPAR(2)
      DOUBLE PRECISION FVEC(2)
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=20)
      CHARACTER*40 ITITLE
      CHARACTER*1  ITITLZ
      CHARACTER*40 ITEXT(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA ALPHA /0.50, 0.25, 0.10, 0.05, 0.01, 0.001/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='PX  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLPX')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLPX--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N
   52   FORMAT('IBUGA3,ISUBRO,N = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)SCALSV,BETASV
   55   FORMAT('SCALSV,BETASV = ',2G15.7)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLPX')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NPERC=0
      NMIN=3
      CALL CKDIST(Y,N,NMIN,QP,NPERC,ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C               **********************************
C               **  STEP 21--                   **
C               **  CARRY OUT CALCULATIONS      **
C               **  FOR EXPONENTIAL POWER MLE   **
C               **  ESTIMATE (FULL SAMPLE CASE) **
C               **********************************
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLPX')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IERROR='NO'
      IWRITE='OFF'
C
      CALL PEXML1(Y,N,BETASV,SCALSV,MAXNXT,
     1            TEMP1,TEMP2,DISPAR,DTEMP1,
     1            XMEAN,XSD,XVAR,XMIN,XMAX,
     1            BETAML,SCALML,
     1            ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C     COMPUTE STANDARD ERRORS
C
      DN=DBLE(N)
      DALPHA=1.0D0/SCALML
      DBETA=DBLE(BETAML)
C
      DSUM1=0.0D0
      DSUM2=0.0D0
      DO2160I=1,N
C
        DX=DBLE(Y(I))
        DA=DLOG(DX)
        DB=(DALPHA*DX)**DBETA
        DC=DLOG(DALPHA*DX)
C
        DTERM1=(DC**2)*DB
        DSUM1=DSUM1 + DTERM1*(DB+1.0D0)*DEXP(DB)
        DSUM2=DSUM2 + DTERM1
C
 2160 CONTINUE
C
      DTERM1=-DN/DBETA**2
      FISH(1,1)=-REAL(DTERM1 - DSUM1 + DSUM2)
C
      DSUM1=0.0D0
      DSUM2=0.0D0
      DO2170I=1,N
C
        DX=DBLE(Y(I))
        DA=DLOG(DX)
        DB=(DALPHA*DX)**DBETA
        DC=DLOG(DALPHA*DX)
C
        DSUM1=DSUM1 + DEXP(DB)*((DBETA-1.0D0)*DB + DB**2*DBETA)
        DSUM2=DSUM2 + DB
C
 2170 CONTINUE
C
      DTERM1=-DBETA*DN/DALPHA**2
      DTERM2=DBETA/DALPHA**2
      DTERM3=DBETA*(DBETA-1.0D0)/DALPHA**2
      FISH(2,2)=-REAL(DTERM1 - DTERM2*DSUM1 + DTERM3*DSUM2)
C
      DSUM1=0.0D0
      DSUM2=0.0D0
      DO2180I=1,N
C
        DX=DBLE(Y(I))
        DA=DLOG(DX)
        DB=(DALPHA*DX)**DBETA
        DC=DLOG(DALPHA*DX)
C
        DSUM1=DSUM1 + DB*DEXP(DB)*(1.0D0 + DBETA*DLOG(DALPHA) + 
     1                DBETA*DA + DBETA*DB*DC)
        DSUM2=DSUM2 + DB*(1.0D0 + DBETA*DLOG(DALPHA) + DBETA*DA)
C
 2180 CONTINUE
C
      DTERM1=DN/DALPHA
      DTERM2=1.0D0/DALPHA
      FISH(1,2)=-REAL(DTERM1 - DTERM2*DSUM1 + DTERM2*DSUM2)
      FISH(2,1)=FISH(1,2)
C
      CALL SGECO(FISH,2,2,ITEMP,RCOND,TEMP1)
      IJOB=1
      CALL SGEDI(FISH,2,2,ITEMP,TEMP1,TEMP1(MAXNXT/2),IJOB)
      DO2810J=1,3
        DO2815I=1,3
          COV(I,J)=FISH(I,J)
 2815   CONTINUE
 2810 CONTINUE
C
      BETASE=SQRT(COV(1,1))
      SCALSE=SQRT(COV(2,2))
      COVSE=COV(2,1)
C
C  CONFIDENCE INTERVALS FOR PARAMETERS BASED ON NORMAL
C  APPROXIMATION.
C
      DO2220I=1,NUMALP
        ALP=ALPHA(I)
        P=1.0-(ALP/2.0)
        CALL NORPPF(P,PPF)
        ALOWSC(I)=SCALML - PPF*SCALSE
        AUPPSC(I)=SCALML + PPF*SCALSE
        ALOWBE(I)=BETAML - PPF*BETASE
        AUPPBE(I)=BETAML + PPF*BETASE
 2220 CONTINUE
C
C               *******************************************
C               **   STEP 42--                           **
C               **   WRITE OUT EVERYTHING                **
C               **   FOR EXPONENTIAL POWER MLE ESTIMATE  **
C               *******************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLPX')
     1  CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Exponential Power Parameter Estimation'
      NCTITL=38
      ITITLZ=' '
      NCTITZ=0
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(N)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Maximum Likelihood:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Shape (Beta):'
      NCTEXT(ICNT)=25
      AVALUE(ICNT)=BETAML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Scale:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=SCALML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Standard Deviation of Beta:'
      NCTEXT(ICNT)=27
      AVALUE(ICNT)=BETASE
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Standard Deviation of Scale:'
      NCTEXT(ICNT)=28
      AVALUE(ICNT)=SCALSE
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Beta/Scale Covariance:'
      NCTEXT(ICNT)=22
      AVALUE(ICNT)=COVSE
      IDIGIT(ICNT)=NUMDIG
C
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='Log-likelihood:'
CCCCC NCTEXT(ICNT)=15
CCCCC AVALUE(ICNT)=ALIKML
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=AICML
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AICc:'
CCCCC NCTEXT(ICNT)=5
CCCCC AVALUE(ICNT)=AICCML
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='BIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=BICML
CCCCC IDIGIT(ICNT)=-7
C
      NUMROW=ICNT
      DO2320I=1,NUMROW
        NTOT(I)=15
 2320 CONTINUE
C
      IFRST=.FALSE.
      ILAST=.FALSE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
      ILIKFL='OFF'
      CALL DPDTA8(ALOWSC,AUPPSC,ALOWS2,AUPPS2,
     1            ALOWBE,AUPPBE,ALOWB2,AUPPB2,ALPHA,NUMALP,
     1            ICAPSW,ICAPTY,NUMDIG,ILIKFL,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLPX')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLPX--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012   FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9015)N
 9015   FORMAT('N = ',I8)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLP3(Y,N,
     1                  DTEMP1,XMOM,MAXNXT,
     1                  SHAPML,SCALML,ALOCML,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE L-MOMENT ESTIMATES
C              FOR THE PEARSON TYPE 3 DISTRIBUTION
C     EXAMPLE--PEARSON TYPE 3 MAXIMUM LIKELIHOOD Y
C     REFERENCE--FORTRAN CODE WRITTEN FOR INCLUSION IN IBM
C                RESEARCH REPORT RC20525, 'FORTRAN ROUTINES FOR
C                USE WITH THE METHOD OF L-MOMENTS, VERSION 3',
C                J. R. M. HOSKING, IBM RESEARCH DIVISION,
C                T. J. WATSON RESEARCH CENTER, YORKTOWN HEIGHTS
C                NEW YORK 10598, U.S.A., VERSION 3     AUGUST 1996
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2008/6
C     ORIGINAL VERSION--JUNE      2008.
C     UPDATED         --JULY      2010. EXTRACT POINT ESTIMATES TO
C                                       PE3ML1
C     UPDATED         --JULY      2010. USE DPDTA1 TO PRINT OUTPUT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DOUBLE PRECISION DTEMP1(*)
      DOUBLE PRECISION XMOM(*)
      DIMENSION QP(1)
C
CCCCC PARAMETER (NUMALP=6)
CCCCC DIMENSION ALPHA(NUMALP)
CCCCC DIMENSION ALOWLO(NUMALP)
CCCCC DIMENSION AUPPLO(NUMALP)
CCCCC DIMENSION ALOWSC(NUMALP)
CCCCC DIMENSION AUPPSC(NUMALP)
CCCCC DIMENSION ALOWSH(NUMALP)
CCCCC DIMENSION AUPPSH(NUMALP)
C
      PARAMETER (MAXROW=20)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(MAXROW)
      CHARACTER*4  VALIGN(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
CCCCC DATA ALPHA /0.50, 0.25, 0.10, 0.05, 0.01, 0.001/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='P3  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLP3')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLP3--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N
   52   FORMAT('IBUGA3,ISUBRO,N = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ***************************************************
C               **  STEP 21--                                    **
C               **  CARRY OUT CALCULATIONS                       **
C               **  FOR PEARSON TYPE 3 L-MOMENT ESTIMATION       **
C               ***************************************************
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLP3')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NPERC=0
      NMIN=3
      CALL CKDIST(Y,N,NMIN,QP,NPERC,ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      CALL PE3ML1(Y,N,
     1            DTEMP1,XMOM,NMOM,
     1            XMEAN,XSD,XVAR,XMIN,XMAX,
     1            ALOCML,SCALML,SHAPML,
     1            ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C               ***********************************************
C               **   STEP 42--                               **
C               **   WRITE OUT EVERYTHING                    **
C               **   FOR PEARSON TYPE 3 MLE ESTIMATION       **
C               ***********************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLP3')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Three-Parameter Pearson Type 3 Parameter Estimation:'
      NCTITL=52
      ITITLZ='Full Sample Case'
      NCTITZ=16
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(N)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='First Sample L-Moment:'
      NCTEXT(ICNT)=22
      AVALUE(ICNT)=REAL(XMOM(1))
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Second Sample L-Moment:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(XMOM(2))
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Third Sample L-Moment:'
      NCTEXT(ICNT)=22
      AVALUE(ICNT)=REAL(XMOM(3))
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Method of L-Moments:'
      NCTEXT(ICNT)=20
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Location:'
      NCTEXT(ICNT)=22
      AVALUE(ICNT)=ALOCML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Scale:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=SCALML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Shape (Gamma):'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=SHAPML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='Log-likelihood:'
CCCCC NCTEXT(ICNT)=15
CCCCC AVALUE(ICNT)=ALIK
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=AIC
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AICc:'
CCCCC NCTEXT(ICNT)=5
CCCCC AVALUE(ICNT)=AICC
CCCCC IDIGIT(ICNT)=-7
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='BIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=BIC
CCCCC IDIGIT(ICNT)=-7
C
      NUMROW=ICNT
      DO2320I=1,NUMROW
        NTOT(I)=15
 2320 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLP3')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLP3--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012   FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9015)N
 9015   FORMAT('N = ',I8)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLQB(Y,X,N,NVAR,
     1                  TEMP1,TEMP2,TEMP3,DTEMP1,
     1                  XTEMP,ITEMP1,
     1                  PSTART,PHISTR,
     1                  PML,PHIML,AM,PVAR,PHIVAR,PPHCOV,
     1                  ICAPSW,ICAPTY,IFORSW,MAXNXT,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR THE QUASI BINOMIAL TYPE I
C              DISTRIBUTION.
C
C              THE MAXIMUM LIKELIHOOD ESTIMATES ARE THE SOLUTIONS
C              TO THE EQUATIONS:
C
C                 SUM[i=1 to N][(m-X(i))/(1 - P - X9i)*PHI] - M*N = 0
C
C                 SUM[i=1 to N][(X(i)*(X(i) - 1)/(p + X(i)*PHI) -
C                 SUM[i=1 to N][(M - X(i))/(1 - P - X(i)*PHI)] = 0
C
C              NOTE THAT M IS ASSUMED FIXED AND KNOWN AND WE ARE
C              SOLVING FOR P AND PHI.
C
C              WHEN THE DATA IS BINNED, THE MAXIMUM LIKELIHOOD
C              EQUATIONS BECOME
C
C                  SUM[i=1 to k][N(i)*(i-1)*i/(p+i*PHI)] -
C                  SUM[i=1 to k][N(i)*(M-i)*i/(1-p-i*PHI)] = 0
C
C                  (N/P) - SUM[i=1 to k][N(i)*(i-1)/(p+i*PHI)] -
C                  SUM[i=1 to k][N(i)*(i-1)/(P+i*PHI) -
C                  SUM[i=1 to k][N(i)*(M-i)/(1-P-i*PHI)] = 0
C
C              THERE ARE TWO CASES:
C
C              1) ONE VARIABLE CASE: Y IS RAW DATA
C              2) TWO VARIABLE CASE: Y IS FREQUENCY, X IS CLASS
C                 MID-POINT.
C
C     EXAMPLE--QUASI BINOMIAL TYPE I MAXIMUM LIKELIHOOD Y
C            --QUASI BINOMIAL TYPE I MAXIMUM LIKELIHOOD Y X
C     REFERENCES--CONSUL AND FAMOYE (2006), "LAGRANGIAN PROBABILITY
C                 DISTRIBUTIONS", BIRKHAUSER, PP. 70-80.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2006/7
C     ORIGINAL VERSION--JULY      2006.
C     UPDATED         --APRIL     2011. USED DPDTA1 TO PRINT OUTPUT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-----------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*4 ISUBN0
      CHARACTER*4 IRELAT
      CHARACTER*4 IRHSTG
C
      PARAMETER (MAXROW=30)
      CHARACTER*60 ITITLE
      CHARACTER*1  ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 IDIST
      CHARACTER*40 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(MAXROW)
      CHARACTER*4  VALIGN(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL      IFRST
      LOGICAL      ILAST
C
C-------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION TEMP1(*)
      DIMENSION TEMP2(*)
      DIMENSION TEMP3(*)
      DIMENSION XTEMP(*)
      DIMENSION ITEMP1(*)
      DOUBLE PRECISION DTEMP1(*)
C
      DOUBLE PRECISION TOL
      DOUBLE PRECISION XPAR(3)
      DOUBLE PRECISION FVEC(2)
C
      DOUBLE PRECISION AE
      DOUBLE PRECISION RE
      DOUBLE PRECISION XLOW
      DOUBLE PRECISION XUP
      DOUBLE PRECISION XMID
      DOUBLE PRECISION DSUM
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM2
      DOUBLE PRECISION DA
C
      DIMENSION FISH(2,2)
      DIMENSION COV(2,2)
C
      DOUBLE PRECISION QBIFUN
      EXTERNAL QBIFUN
      DOUBLE PRECISION DM
      DOUBLE PRECISION F0FREQ
      COMMON/QBICOM/DM,F0FREQ,MAXRO2,NTOT2
C
C-------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT---------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='QB  '
C
      IERROR='NO'
      IWRITE='OFF'
C
      PML=CPUMIN
      PHIML=CPUMIN
      PVAR=CPUMIN
      PHIVAR=CPUMIN
      PPHCOV=CPUMIN
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLQB')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLQB--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N,NVAR
   52   FORMAT('IBUGA3,ISUBRO,N,NVAR = ',2(A4,2X),2I8)
        CALL DPWRST('XXX','WRIT')
        IF(NVAR.EQ.1)THEN
          DO56I=1,MIN(N,100)
            WRITE(ICOUT,57)I,Y(I)
   57       FORMAT('I,Y(I) = ',I8,G15.7)
            CALL DPWRST('XXX','WRIT')
   56     CONTINUE
        ELSE
          DO61I=1,N
            WRITE(ICOUT,62)I,X(I),Y(I)
   62       FORMAT('I,X(I),Y(I) = ',I8,2G15.7)
            CALL DPWRST('XXX','WRIT')
   61     CONTINUE
        ENDIF
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  1) ROUND DATA TO INTEGER VALUES       **
C               **  2) COMPUTE SUMMARY STATISTICS         **
C               **  3) CHECK INPUT FOR NEGATIVE VALUES,   **
C               **     INSUFFICIENT SAMPLE SIZE           **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLQB')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IDIST='QUASI BINOMIAL TYPE I'
C
      NPERC=0
      MAXGRP=MAXNXT/2
      NMIN=2
      IF(NVAR.EQ.1)THEN
        DO1105I=1,N
          ITEMP=INT(Y(I)+0.5)
          Y(I)=REAL(ITEMP)
 1105   CONTINUE
        CALL CKDIST(Y,N,NMIN,TEMP1,NPERC,ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
        IFLAG=1
        CALL SUMRAW(Y,N,IDIST,IFLAG,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        NTOTZZ=N
C
C       NOW BIN THE DATA FOR USE BY THE ESTIMATION METHOD BELOW
C
        IRELAT='OFF'
        IRHSTG='OFF'
        XSTART=XMIN-0.5
        XSTOP=XMAX+0.5
        CLWID=1.0
        CALL DPBINI(Y,N,IRELAT,CLWID,XSTART,XSTOP,IRHSTG,
     1              TEMP1,X,N2,IBUGA3,IERROR)
        ICNT=0
        DO1121I=1,N2
          IF(TEMP1(I).GT.0.0)THEN
            ICNT=ICNT+1
            Y(ICNT)=TEMP1(I)
            X(ICNT)=X(I)
          ENDIF
1121    CONTINUE
        N2=ICNT
      ELSE
        CALL CKDIS2(Y,X,TEMP1,N,MAXGRP,NMIN,TEMP2,NPERC,NTOTZZ,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IFLAG1=1
        IFLAG2=1
        CALL SUMGRP(Y,X,N,IDIST,IFLAG1,IFLAG2,
     1              TEMP1,TEMP2,TEMP3,MAXNXT,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ,
     1              ISUBRO,IBUGA3,IERROR)
        ICNT=0
        DO1211I=1,N2
          IF(Y(I).GT.0.0)THEN
            ICNT=ICNT+1
            Y(ICNT)=Y(I)
            X(ICNT)=X(I)
          ENDIF
1211    CONTINUE
        N2=ICNT
      ENDIF
      IF(IERROR.EQ.'YES')GOTO9000
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLQB')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1311)
 1311   FORMAT('AFTER COMPUTE SUMMARY STATISTICS--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1312)XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ
 1312   FORMAT('XMEAN,XVAR,XSD,XMIN,XMAX,NTOTZZ = ',5G15.7,I10)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
C               *********************************************
C               **  STEP 21--                              **
C               **  CARRY OUT CALCULATIONS                 **
C               **  FOR QUASI BINOMIAL TYPE I MLE          **
C               **  ESTIMATION                             **
C               *********************************************
C
 2100 CONTINUE
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLQB')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      F0=Y(1)/REAL(NTOTZZ)
      F1=Y(2)/REAL(NTOTZZ)
      F2=Y(3)/REAL(NTOTZZ)
      IINDX=MAXNXT/2
      IF(N2.LE.IINDX)THEN
        IML=0
        DO2210I=1,N2
          NTOT=NTOT+Y(I)
          TEMP3(I)=Y(I)
          TEMP3(IINDX+I)=X(I)
 2210   CONTINUE
        IK=N
      ELSE
        IML=1
      ENDIF
C
      IF(AM.LT.AMAX)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1131)
 1131   FORMAT('******ERROR IN QUASI BINOMIAL TYPE I ',
     1         'MAXIMUM LIKELIHOOD ESTIMATION--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1401)
 1401   FORMAT('      USER-SPECIFIED VALUE OF THE M PARAMETER')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1403)
 1403   FORMAT('      IS LESS THAN THE DATA MAXIMUM.')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1405)AM
 1405   FORMAT('      VALUE OF M =        ',G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1407)XMAX
 1407   FORMAT('      DATA MAXIMUM =      ',G15.7)
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      IM=INT(AM+0.5)
      IF(IM.EQ.1)THEN
        PML=1.0 - F0
        PHIML=0.0
      ELSEIF(IM.EQ.2)THEN
        PML=1.0 - SQRT(F0)
        AN=REAL(NTOTZZ)
        AN0=AN*F0
        AN1=AN*F1
        AN2=AN*F2
        PHIML=((AN2 + 0.5*AN1)*SQRT(F0) - AN1/2.0)/(AN1+AN2)
      ELSE
        DM=DBLE(AM)
        F0FREQ=DBLE(F0)
        NTOT2=NTOTZZ
        IOPT=2
        TOL=1.0D-5
        NPAR=2
        NPRINT=-1
        INFO=0
        LWA=MAXNXT
        MAXRO2=MAXNXT
C
        ALOWLM=-0.999/AM
        AUPPLM=(1.0 - 0.001)/AM
        IF((PSTART.GT.0.0 .AND. PSTART.LT.1.0) .AND.
     1     (PHISTR.GT.ALOWLM .AND. PHISTR.LT.AUPPLM))THEN
          XPAR(1)=PSTART
          XPAR(2)=PHISTR
        ELSE
          XPAR(1)=1.0D0 - (F0FREQ)**(1.0D0/DM)
          XPAR(2)=(1.0D0/(2.0D0*(DM-2.0D0)))*(-1.0D0 +
     1            DSQRT(1.0D0+4.0D0*(DM-2.0D0)*
     1            (-1.0D0+DBLE(AMEAN)/(DM*XPAR(1)))/
     1            (DM-1.0D0)))
        ENDIF
        CALL DNSQE(QBIFUN,JAC,IOPT,NPAR,XPAR,FVEC,TOL,NPRINT,INFO,
     1             DTEMP1,LWA,TEMP3,IK)
C
        PML=REAL(XPAR(1))
        PHIML=REAL(XPAR(2))
      ENDIF
C
      AN=REAL(NTOTZZ)
C
      ANUM=AN*AM*(AM-1.0)*PML*(2.0 + (AM - 3.0)*PML)
      ADEN=(PML + 2.0*PHIML)*(1.0 - PML - AM*PHIML + PHIML)
      FISH(1,1)=ANUM/ADEN
C
      ANUM=AN*AM*(AM-1.0)*PML*(1.0 - (AM - 1.0)*PHIML)
      FISH(1,2)=ANUM/ADEN
      FISH(2,1)=FISH(1,2)
C
      ANUM=AN*AM*(PML-(AM-3.0)*PHIML+(AM-1.0)*(AM-3.0)*PHIML**2)
      FISH(2,2)=-(AN*AM/PML) - ANUM/ADEN
C
      NDIM=2
      CALL SGECO(FISH,NDIM,NDIM,ITEMP1,RCOND,XTEMP)
      IJOB=1
      CALL SGEDI(FISH,NDIM,NDIM,ITEMP1,XTEMP,XTEMP(MAXNXT/2),IJOB)
      DO2810J=1,NDIM
        DO2815I=1,NDIM
          COV(I,J)=FISH(I,J)
 2815   CONTINUE
 2810 CONTINUE
C
      PVAR=COV(1,1)
      PHIVAR=COV(2,2)
      PPHCOV=COV(2,1)
C
C               ***********************************************
C               **   STEP 42--                               **
C               **   WRITE OUT EVERYTHING                    **
C               **   FOR QUASI BINOMIAL TYPE I MLE           **
C               **   ESTIMATION                              **
C               ***********************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLQB')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     PRINT SUMMARY STATISTICS TABLE
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Quasi Binomial TYpe I Parameter Estimation'
      NCTITL=42
      ITITLZ=' '
      NCTITZ=0
C
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(NTOTZZ)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Zero-Class Frequency:'
      NCTEXT(ICNT)=28
      AVALUE(ICNT)=F0
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Method of Maximum Likelihood:'
      NCTEXT(ICNT)=29
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='User-Specified Value for M:'
      NCTEXT(ICNT)=27
      AVALUE(ICNT)=AM
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of P:'
      NCTEXT(ICNT)=14
      AVALUE(ICNT)=PML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Phi:'
      NCTEXT(ICNT)=16
      AVALUE(ICNT)=PHIML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Standard Error of P:'
      NCTEXT(ICNT)=20
      AVALUE(ICNT)=COV(1,1)
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Standard Error of Phi:'
      NCTEXT(ICNT)=22
      AVALUE(ICNT)=COV(2,2)
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Covariance Between P and Phi:'
      NCTEXT(ICNT)=29
      AVALUE(ICNT)=COV(2,1)
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      NUMROW=ICNT
      DO2310I=1,NUMROW
        NTOT(I)=15
 2310 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLQB')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLQB--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)IERROR
 9012   FORMAT('IERROR = ',A4)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLRA(Y,N,ICASPL,
     1                  DTEMP1,MAXNXT,
     1                  SCALMM,SCALSE,
     1                  ALOCML,SCALML,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR THE RAYLEIGH DISTRIBUTION.
C              NOTE THAT EITHER THE 1-PARAMETER CASE OR THE
C              2-PARAMETER CASE CAN BE REQUESTED.
C     EXAMPLE--RAYLEIGH MAXIMUM LIKELIHOOD Y
C              1-PARAMETER RAYLEIGH MAXIMUM LIKELIHOOD Y
C     REFERENCE--COHEN AND WHITTEN (1988), "PARAMETER ESTIMATION IN
C                RELIABILITY AND LIFE SPAN MODELS", MARCEL DEKKER, INC.,
C                CHAPTER 10.
C              --"CONTINUOUS UNIVARIATE DISTRIBUTIONS--VOLUME 1",
C                SECOND EDITION, JOHNSON, KOTZ, AND BALAKRISHNAN,
C                WILEY, 1994, P. 453.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004/6
C     ORIGINAL VERSION--JUNE      2004.
C     UPDATED         --AUGUST    2005. MODIFY FORMAT OF OUTPUT
C     UPDATED         --JULY      2010. EXTRACT ESTIMATION TO
C                                       SEPARATE SUBROUTINE
C     UPDATED         --JULY      2010. CALL DPDTA1 TO PRINT OUTPUT
C                                       (THIS ALSO ADDS RTF FORMAT
C                                       OUTPUT)
C     UPDATED         --JULY      2010. ADD LIKELIHOOD/AIC TO OUTPUT
C     UPDATED         --JULY      2010. DISTINGUISH BETWEEN 1-PARAMETER
C                                       2-PARAMETER CASES
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*4 ICASE
      CHARACTER*4 INORM
      CHARACTER*4 ILIKFL
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DOUBLE PRECISION DTEMP1(*)
C
      PARAMETER (NUMALP=6)
      DIMENSION ALPHA(NUMALP)
      DIMENSION ALOWLO(NUMALP)
      DIMENSION AUPPLO(NUMALP)
      DIMENSION ALOWSC(NUMALP)
      DIMENSION AUPPSC(NUMALP)
      DIMENSION QP(1)
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=30)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*40 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(NUMALP)
      CHARACTER*4  VALIGN(NUMALP)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA ALPHA /0.50, 0.25, 0.10, 0.05, 0.01, 0.001/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='RA  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLRA')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLRA--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N
   52   FORMAT('IBUGA3,ISUBRO,N = ',A4,2X,A4,2X,G15.7)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLRA')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NPERC=0
      NMIN=2
      CALL CKDIST(Y,N,NMIN,QP,NPERC,ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C               **************************************
C               **  STEP 21--                       **
C               **  CARRY OUT CALCULATIONS FOR      **
C               **  RAYLEIGH MLE (FULL SAMPLE CASE) **
C               **************************************
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLRA')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IERROR='NO'
      IWRITE='OFF'
C
      ICASE='2'
      IF(ICASPL.EQ.'1RAY')ICASE='1'
      CALL RAYML1(Y,N,ICASE,
     1            DTEMP1,
     1            XMEAN,XSD,XMIN,XMAX,
     1            ALOCML,SCALML,SCALSE,
     1            ALOCMM,SCALMM,SCA2SE,
     1            ISUBRO,IBUGA3,IERROR)
      IF(ICASPL.EQ.'1RAY')THEN
        ALOCML=0.0
        CALL RAYLI1(Y,N,ICASE,
     1              ALOCML,SCALML,
     1              ALIK,AIC,AICC,BIC,
     1              ISUBRO,IBUGA3,IERROR)
      ELSE
        CALL RAYLI1(Y,N,ICASE,
     1              ALOCML,SCALML,
     1              ALIK,AIC,AICC,BIC,
     1              ISUBRO,IBUGA3,IERROR)
        CALL RAYLI1(Y,N,ICASE,
     1              ALOCMM,SCALMM,
     1              ALIK2,AIC2,AICC2,BIC2,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
C
      IF(ICASPL.EQ.'1RAY')THEN
        NU=2*N
        DTERM1=DBLE(N)*2.0D0*DBLE(SCALML)**2
        DO2120I=1,NUMALP
          ALP=ALPHA(I)
          P=1.0-(ALP/2.0)
          CALL CHSPPF(P,NU,PPF1)
          P=ALP/2.0
          CALL CHSPPF(P,NU,PPF2)
          ALOWSC(I)=SQRT(REAL(DTERM1)/PPF1)
          AUPPSC(I)=SQRT(REAL(DTERM1)/PPF2)
 2120   CONTINUE
      ENDIF
C
C               *************************************
C               **   STEP 42--                     **
C               **   WRITE OUT EVERYTHING          **
C               **   FOR RAYLEIGH MLE ESTIMATE     **
C               *************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLRA')
     1  CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      IF(ICASPL.EQ.'1RAY')THEN
        ITITLE='1-Parameter Rayleigh Parameter Estimation'
        NCTITL=41
      ELSE
        ITITLE='2-Parameter Rayleigh Parameter Estimation'
        NCTITL=41
      ENDIF
      ITITLZ=' '
      NCTITZ=0
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(N)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      IF(ICASPL.EQ.'RAYL')THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='Modified Moments:'
        NCTEXT(ICNT)=17
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of Location:'
        NCTEXT(ICNT)=21
        AVALUE(ICNT)=ALOCMM
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of Scale:'
        NCTEXT(ICNT)=18
        AVALUE(ICNT)=SCALMM
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Log-likelihood:'
        NCTEXT(ICNT)=15
        AVALUE(ICNT)=ALIK2
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='AIC:'
        NCTEXT(ICNT)=4
        AVALUE(ICNT)=AIC2
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='AICc:'
        NCTEXT(ICNT)=5
        AVALUE(ICNT)=AICC2
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='BIC:'
        NCTEXT(ICNT)=4
        AVALUE(ICNT)=BIC2
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)=' '
        NCTEXT(ICNT)=0
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
      ENDIF
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Maximum Likelihood:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      IF(ICASPL.EQ.'RAYL')THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='Estimate of Location:'
        NCTEXT(ICNT)=21
        AVALUE(ICNT)=ALOCML
        IDIGIT(ICNT)=NUMDIG
      ENDIF
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Scale:'
      NCTEXT(ICNT)=18
      AVALUE(ICNT)=SCALML
      IDIGIT(ICNT)=NUMDIG
C
      IF(ICASPL.EQ.'1RAY')THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='Standard Error of Scale:'
        NCTEXT(ICNT)=24
        AVALUE(ICNT)=SCALSE
        IDIGIT(ICNT)=NUMDIG
      ENDIF
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Log-likelihood:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=ALIK
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)='AIC:'
      NCTEXT(ICNT)=4
      AVALUE(ICNT)=AIC
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)='AICc:'
      NCTEXT(ICNT)=5
      AVALUE(ICNT)=AICC
      IDIGIT(ICNT)=-7
      ICNT=ICNT+1
      ITEXT(ICNT)='BIC:'
      NCTEXT(ICNT)=4
      AVALUE(ICNT)=BIC
      IDIGIT(ICNT)=-7
C
      NUMROW=ICNT
      DO2320I=1,NUMROW
        NTOT(I)=15
 2320 CONTINUE
C
      IFRST=.FALSE.
      ILAST=.FALSE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
      IF(NUMOUT.GT.1 .AND. ICASPL.EQ.'1RAY')THEN
        INORM='OFF'
        ALOWLO(1)=CPUMIN
        CALL DPDTA7(ALOWLO,AUPPLO,ALOWSC,AUPPSC,ALPHA,NUMALP,
     1              ICAPSW,ICAPTY,NUMDIG,INORM,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLRA')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLRA--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012   FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9015)N
 9015   FORMAT('N = ',I8)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLRG(Y,XLOW,XHIGH,N,NVAR,
     1                  TEMP1,TEMP2,TEMP3,TEMP4,DTEMP1,MAXNXT,
     1                  ALPHSV,A,B,
     1                  ALPHML,BETAML,ALOWML,AUPPML,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR THE REFLECTED GENERALIZED TOPP
C              AND LEONE DISTRIBUTION.  THIS ESTIMATES THE
C              SHAPE PARAMETERS (I.E., LOWER/UPPER LIMIT PARAMETERS
C              ASSUMED KNOWN AND FIXED).
C
C              NOTE THAT THIS ALGORITHM WILL HANDLE
C              EITHER GROUPED OR UNGROUPED DATA.
C     EXAMPLE--REFLECTED GENERALIZED TOPP AND LEONE MLE Y
C              REFLECTED GENERALIZED TOPP AND LEONE MLE Y X
C              REFLECTED GENERALIZED TOPP AND LEONE MLE Y XLOW XHIGH
C     REFERENCE --KOTZ AND VAN DORP (2004), "BEYOND BETA: OTHER
C                 CONTINUOUS FAMILIES OF DISTRIBUTIONS WITH
C                 BOUNDED SUPPORT AND APPLICATIONS", WORLD
C                 SCIENTIFIC PUBLISHING CO., PP. 211-213.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2007/7
C     ORIGINAL VERSION--JULY      2007.
C     UPDATED         --JULY      2010. USE DPDTA1 TO PRINT
C     UPDATED         --JULY      2010. EXTRACT POINT ESTIMATES TO
C                                       RGTML1
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*4 IWRITE
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION XLOW(*)
      DIMENSION XHIGH(*)
      DIMENSION TEMP1(*)
      DIMENSION TEMP2(*)
      DIMENSION TEMP3(*)
      DIMENSION TEMP4(*)
      DOUBLE PRECISION DTEMP1(*)
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=20)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*40 ITEXT(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='RG  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLRG')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMRGT--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N,NVAR
   52   FORMAT('IBUGA3,ISUBRO,N,NVAR = ',2(A4,2X),2I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I),XLOW(I),XHIGH(I)
   57     FORMAT('I,Y(I),XLOW(I),XHIGH(I) = ',I8,3G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLRG')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     NOTE: THERE ARE 3 POSSIBLE CASES.
C
C     1. UNBINNED DATA
C     2. GROUPED DATA, BIN MID-POINTS PROVIDED
C     3. GROUPED DATA, BIN LOWER/UPPER LIMITS
C        PROVIDED (I.E., UNEQUAL SIZE BINS)
C
      NPERC=0
      MAXGRP=MAXNXT/2
      NMIN=4
      IF(NVAR.EQ.1)THEN
        CALL CKDIST(Y,N,NMIN,TEMP2,NPERC,ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
  180   CONTINUE
        NTOT2=N
        NCLASS=N
      ELSEIF(NVAR.EQ.2)THEN
        CALL CKDIS2(Y,XLOW,TEMP1,N,MAXGRP,NMIN,TEMP2,NPERC,NTOT2,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
      ELSEIF(NVAR.EQ.3)THEN
        CALL CKDIS3(Y,XLOW,XHIGH,TEMP1,N,MAXGRP,NMIN,TEMP2,NPERC,NTOT2,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
      ELSE
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,111)
  111   FORMAT('***** ERROR IN REFLECTED GENERALIZED TOPP AND ',
     1         'LEONE MAXIMUM LIKELIHOOD--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,390)
  390   FORMAT('      MORE THAN THREE RESPONSE VARIABLES WERE ',
     1         'SPECIFIED.')
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
C               ***************************************************
C               **  STEP 21--                                    **
C               **  CARRY OUT CALCULATIONS FOR THE               **
C               **  REFLECTED GENERALIZED TOPP AND LEONE    MLE  **
C               ***************************************************
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLRG')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IERROR='NO'
C
      CALL RGTML1(Y,XLOW,XHIGH,N,NVAR,MAXNXT,NTOT2,
     1            DTEMP1,TEMP1,TEMP2,TEMP3,TEMP4,
     1            XMIN,XMAX,XMEAN,XSD,
     1            ALPHSV,A,B,
     1            ALPHML,BETAML,ALOWML,AUPPML,
     1            ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      ALIK=CPUMIN
      AIC=CPUMIN
      AICC=CPUMIN
      BIC=CPUMIN
      IF(NVAR.EQ.1)THEN
        CALL RGTLI1(Y,N,
     1              ALOWML,AUPPML,ALPHML,BETAML,
     1              ALIK,AIC,AICC,BIC,
     1            ISUBRO,IBUGA3,IERROR)
      ENDIF
C
C               ***************************************************
C               **   STEP 42--                                   **
C               **   WRITE OUT EVERYTHING FOR REFLECTED          **
C               **   GENERALIZED TOPP AND LEONE  MLE ESTIMATION  **
C               ***************************************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLRG')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Reflected Generalized Topp and Leone Parameter Estimation'
      NCTITL=58
      ITITLZ='Full Sample Case'
      NCTITZ=16
      ICNT=1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(NTOT2)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Maximum Likelihood:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Value Used for Lower Limit:'
      NCTEXT(ICNT)=27
      AVALUE(ICNT)=ALOWML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Value Used for Upper Limit:'
      NCTEXT(ICNT)=27
      AVALUE(ICNT)=AUPPML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Shape (Alpha):'
      NCTEXT(ICNT)=25
      AVALUE(ICNT)=ALPHML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Shape (Beta):'
      NCTEXT(ICNT)=24
      AVALUE(ICNT)=BETAML
      IDIGIT(ICNT)=NUMDIG
C
      IF(ALIK.NE.CPUMIN)THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='Log-likelihood:'
        NCTEXT(ICNT)=15
        AVALUE(ICNT)=ALIK
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='AIC:'
        NCTEXT(ICNT)=4
        AVALUE(ICNT)=AIC
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='AICc:'
        NCTEXT(ICNT)=5
        AVALUE(ICNT)=AICC
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='BIC:'
        NCTEXT(ICNT)=4
        AVALUE(ICNT)=BIC
        IDIGIT(ICNT)=-7
      ENDIF
C
      NUMROW=ICNT
      DO2320I=1,NUMROW
        NTOT(I)=15
 2320 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLRG')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMRGT--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012   FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9015)N
 9015   FORMAT('N = ',I8)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLSL(Y,N,
     1                  TEMP1,TEMP2,TEMP3,DTEMP1,MAXNXT,
     1                  ALOC,ASCALE,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR SLASH DISTRIBUTION
C     EXAMPLE--SLASH MAXIMUM LIKELIHOOD Y
C     REFERENCE--KAREN KAFADAR, (1982), "A BIWEIGHT APPROACH TO
C                THE ONE-SAMPLE PROBLEM", JOURNAL OF THE
C                AMERICAN STATISTICAL ASSOCIATION, VOL. 77,
C                NO. 378, PP. 416-424.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2007/6
C     ORIGINAL VERSION--JUNE      2007.
C     UPDATED         --OCTOBER   2009. EXTRACT ESTIMATION TO
C                                       SEPARATE SUBROUTINE
C     UPDATED         --OCTOBER   2009. CALL DPDTA1 TO PRINT OUTPUT
C                                       (THIS ALSO ADDS RTF FORMAT
C                                       OUTPUT)
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION TEMP1(*)
      DIMENSION TEMP2(*)
      DIMENSION TEMP3(*)
      DIMENSION QP(1)
      DOUBLE PRECISION DTEMP1(*)
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (NUMALP=6)
      REAL ALPHA(NUMALP)
C
      PARAMETER (MAXROW=25)
      CHARACTER*60 ITITLE
      CHARACTER*1  ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(NUMALP)
      CHARACTER*4  VALIGN(NUMALP)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA ALPHA /0.50, 0.25, 0.10, 0.05, 0.01, 0.001/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='SL  '
C
      IERROR='NO'
      IWRITE='OFF'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLSL')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLSL--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3
   52   FORMAT('IBUGA3 = ',A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)N
   55   FORMAT('N = ',I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,N
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLSL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NPERC=0
      NMIN=3
      CALL CKDIST(Y,N,NMIN,QP,NPERC,ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C               ********************************
C               **  STEP 41--                 **
C               **  CARRY OUT CALCULATIONS    **
C               **  FOR SLASH MLE ESTIMATE    **
C               ********************************
C
 4000 CONTINUE
C
      ISTEPN='40'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLSL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL SLAML1(Y,N,MAXNXT,
     1            TEMP1,TEMP2,TEMP3,DTEMP1,
     1            XMEAN,XSD,XMIN,XMAX,XMED,XMAD,
     1            ALOC,ASCALE,
     1            ISUBRO,IBUGA3,IERROR)
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLSL')THEN
        ISTEPN='41'
        CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
        WRITE(ICOUT,1201)ALOC,SCALE
 1201   FORMAT('AFTER CALL SLAML1: ALOC,ASCALE = ',2G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1203)XMEAN,XSD,XMIN,XMAX,XMED,XMAD
 1203   FORMAT('XMEAN,XSD,XMIN,XMAX,XMED,XMAD = ',6G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      CALL SLALI1(Y,TEMP1,N,ALOC,ASCALE,
     1            ALIK,AIC,AICC,BIC,
     1            ISUBRO,IBUGA3,IERROR)
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLSL')THEN
        ISTEPN='42'
        CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
        WRITE(ICOUT,1205)ALIK,AIC,AICC,BIC
 1205   FORMAT('ALIK,AIC,AICC,BIC = ',4G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      IF(IERROR.EQ.'YES')GOTO9000
C
C               *********************************
C               **   STEP 42--                 **
C               **   WRITE OUT EVERYTHING      **
C               **   FOR SLASH MLE ESTIMATE    **
C               **********************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLSL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     PRINT SUMMARY STATISTICS TABLE
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Slash Parameter Estimation'
      NCTITL=26
      ITEXT(1)='Summary Statistics:'
      NCTEXT(1)=19
      AVALUE(1)=0.0
      IDIGIT(1)=0
      ITEXT(2)='Number of Observations:'
      NCTEXT(2)=23
      AVALUE(2)=REAL(N)
      IDIGIT(2)=0
      ITEXT(3)='Sample Mean:'
      NCTEXT(3)=12
      AVALUE(3)=XMEAN
      IDIGIT(3)=NUMDIG
      ITEXT(4)='Sample Standard Deviation:'
      NCTEXT(4)=26
      AVALUE(4)=XSD
      IDIGIT(4)=NUMDIG
      ITEXT(5)='Sample Median:'
      NCTEXT(5)=14
      AVALUE(5)=XMED
      IDIGIT(5)=NUMDIG
      ITEXT(6)='Sample Median Absolute Deviation:'
      NCTEXT(6)=33
      AVALUE(6)=XMAD
      IDIGIT(6)=NUMDIG
      ITEXT(7)='Sample Minimum:'
      NCTEXT(7)=15
      AVALUE(7)=XMIN
      IDIGIT(7)=NUMDIG
      ITEXT(8)='Sample Maximum:'
      NCTEXT(8)=15
      AVALUE(8)=XMAX
      IDIGIT(8)=NUMDIG
      ITEXT(9)=' '
      NCTEXT(9)=0
      AVALUE(9)=0.0
      IDIGIT(9)=-1
      ICNT=9
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Maximum Likelihood:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Location:'
      NCTEXT(ICNT)=21
      AVALUE(ICNT)=ALOC
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Scale:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=ASCALE
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Log-likelihood:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=ALIK
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='AIC:'
      NCTEXT(ICNT)=4
      AVALUE(ICNT)=AIC
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='AICc:'
      NCTEXT(ICNT)=5
      AVALUE(ICNT)=AICC
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='BIC:'
      NCTEXT(ICNT)=4
      AVALUE(ICNT)=BIC
      IDIGIT(ICNT)=NUMDIG
      NUMROW=ICNT
      DO2320I=1,NUMROW
        NTOT(I)=15
 2320 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      NCTITZ=0
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLSL')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLSL--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012   FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLTP(Y,N,IR,DTEMP1,MAXNXT,
     1                  GAMMML,AML,ANUML,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE CONDITIONAL MAXIMUM
C              LIKELIHOOD ESTIMATES FOR THE TRUNCATED PARETO
C              DISTRIBUTION.
C
C              THE CONDITIONAL MAXIMUM LIKELIHOOD ESTIMATE OF
C              NU IS THE DATA MAXIMUM.
C
C              TO FIND THIS ESTIMATE, SORT THE DATA FROM LARGEST
C              TO SMALLEST VALUE.  IF THERE ARE R+1 POINTS, THE
C              MAXIMUM LIKELIHOOD ESTIMATE OF GAMMA IS THE SOLUTION
C              OF THE EQUATION
C
C              (R/GAMMAHAT) +
C              R*(X(R+1)/X(X(1))**GAMMAHAT*LOG(X(R+1)/X(1))/
C              1 - (X(R+1)/X(1))**GAMMAHAT) -
C              SUM[i=1 TO R][LOG(X(i) - LN(X(R+1))] = 0
C
C              THIS TERMINOLOGY IS USED BY ABAN, MEERSCHAERT, AND
C              PANORSKA.  THEY BASE THIS ON TAKING THE LARGEST
C              R+1 POINTS OUT OF N (I.E., THE TRUNCATED PARETO
C              IS FIT TO THE TAILS OF THE DATA).  IN DATAPLOT,
C              IF R IS SPECIFIED, IT IS ASUMED THAT WE ARE FITTING
C              THE ENTIRE DATA SET.  SO IN THE ABOVE FORMULA,
C              X(1) IS THE MAXIMUM AND X(R+1) IS THE MINIMUM
C              POINT INCLUDED IN THE COMPUTATION.
C                
C
C              ONCE WE HAVE THE ESTIMATE OF GAMMA, THE ESTIMATE
C              OF THE LOWER BOUND PARAMETER IS:
C
C              AHAT = R**(1/GAMMAHAT)*(X(R+1))*
C              [N - (N - R)*(X(R+1_/X(1))**GAMMAHAT]**(-1/GAMMAHAT)
C
C     EXAMPLE--TRUNCATED PARETO MLE Y
C     REFERENCES--ABAN, MEERSCHAERT, AND PANORSKA (2006), "PARAMETER
C                 ESTIMATION FOR THE TRUNCATED PARETO DISTRIBUTION",
C                 JOURNAL OF THE AMERICAN STATISTICAL ASSOCIATION,
C                 VOL. 101, NO. 473, PP. 270-277.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2008/3
C     ORIGINAL VERSION--MARCH     2008.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*4 IWRITE
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DOUBLE PRECISION DTEMP1(*)
      DIMENSION QP(1)
C
      PARAMETER (MAXROW=20)
      CHARACTER*60 ITITLE
      CHARACTER*1  ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*40 ITEXT(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='TP  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLTP')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLTP--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N
   52   FORMAT('IBUGA3,ISUBRO,N = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLTP')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NPERC=0
      NMIN=4
      CALL CKDIST(Y,N,NMIN,QP,NPERC,ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      CALL TNPML1(Y,N,IR,DTEMP1,
     1            XMEAN,XSD,XMIN,XMAX,
     1            AML,ANUML,GAMMML,
     1            ISUBRO,IBUGA3,IERROR)
C
C     PRINT SUMMARY STATISTICS TABLE
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Truncated Pareto Parameter Estimation'
      NCTITL=37
      ITEXT(1)='Summary Statistics:'
      NCTEXT(1)=19
      AVALUE(1)=0.0
      IDIGIT(1)=0
      ITEXT(2)='Number of Observations:'
      NCTEXT(2)=23
      AVALUE(2)=REAL(N)
      IDIGIT(2)=0
      ITEXT(3)='Sample Mean:'
      NCTEXT(3)=12
      AVALUE(3)=XMEAN
      IDIGIT(3)=NUMDIG
      ITEXT(4)='Sample Standard Deviation:'
      NCTEXT(4)=26
      AVALUE(4)=XSD
      IDIGIT(4)=NUMDIG
      ITEXT(5)='Sample Minimum:'
      NCTEXT(5)=15
      AVALUE(5)=XMIN
      IDIGIT(5)=NUMDIG
      ITEXT(6)='Sample Minimum:'
      NCTEXT(6)=15
      AVALUE(6)=XMAX
      IDIGIT(6)=NUMDIG
      ITEXT(7)=' '
      NCTEXT(7)=0
      AVALUE(7)=0.0
      IDIGIT(7)=-1
C
      ICNT=8
      ITEXT(ICNT)='Conditional Maximum Likelihood:'
      NCTEXT(ICNT)=31
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Lower Bound (A):'
      NCTEXT(ICNT)=28
      AVALUE(ICNT)=AML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Upper Truncation (NU):'
      NCTEXT(ICNT)=34
      AVALUE(ICNT)=ANUML
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Estimate of Shape Parameter (Gamma):'
      NCTEXT(ICNT)=36
      AVALUE(ICNT)=GAMMML
      IDIGIT(ICNT)=NUMDIG
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='Log-likelihood:'
CCCCC NCTEXT(ICNT)=15
CCCCC AVALUE(ICNT)=ALIK
CCCCC IDIGIT(ICNT)=NUMDIG
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=AIC
CCCCC IDIGIT(ICNT)=NUMDIG
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='AICc:'
CCCCC NCTEXT(ICNT)=5
CCCCC AVALUE(ICNT)=AICC
CCCCC IDIGIT(ICNT)=NUMDIG
CCCCC ICNT=ICNT+1
CCCCC ITEXT(ICNT)='BIC:'
CCCCC NCTEXT(ICNT)=4
CCCCC AVALUE(ICNT)=BIC
CCCCC IDIGIT(ICNT)=NUMDIG
      NUMROW=ICNT
      DO2320I=1,NUMROW
        NTOT(I)=15
 2320 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
      NCTITZ=0
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLTP')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPMLTP--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012   FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9015)N
 9015   FORMAT('N = ',I8)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPMLTR(Y,N,
     1                  XTEMP,Z,DTEMP1,MAXNXT,
     1                  A,B,ALOWQN,AUPPQN,
     1                  CML,AML,BML,AQUANT,BQUANT,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD ESTIMATES
C              FOR THE TRIANGULAR DISTRIBUTION
C     EXAMPLE--TRIANGULAR MAXIMUM LIKELIHOOD Y
C     REFERENCE--KOTZ AND VAN DORP (2004), "BEYOND BETA: OTHER
C                CONTINUOUS FAMILIES OF DISTRIBUTIONS WITH BOUNDED
C                SUPPORT AND APPLICATIONS", WORLD SCIENTIFIC,
C                CHAPTER 1.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2007/5
C     ORIGINAL VERSION--MAY       2007.
C     UPDATED         --JULY      2007. USE ML FOR ESTIMATES
C                                       OF LOWER/UPPER BOUNDS
C     UPDATED         --JULY      2010. ADD LIKELIHOOD/AIC TO OUTPUT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION Z(*)
      DIMENSION XTEMP(*)
      DIMENSION QP(1)
      DOUBLE PRECISION DTEMP1(*)
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=30)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*40 ITEXT(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPML'
      ISUBN2='TR  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLTR')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPMLTR--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N
   52   FORMAT('IBUGA3,ISUBRO,N = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C     