<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/modules/sensors/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/modules/sensors/metadata.yaml"
sidebar_label: "Linux Sensors (lm-sensors)"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Hardware Devices and Sensors"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Linux Sensors (lm-sensors)


<img src="https://netdata.cloud/img/microchip.svg" width="150"/>


Plugin: go.d.plugin
Module: sensors

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector gathers real-time system sensor statistics,  including temperature, voltage, current, power, fan speed, energy consumption, and humidity,  utilizing the [sensors](https://linux.die.net/man/1/sensors) binary.




This collector is supported on all platforms.

This collector only supports collecting metrics from a single instance of this integration.


### Default Behavior

#### Auto-Detection

The following type of sensors are auto-detected:

- temperature
- fan
- voltage
- current
- power
- energy
- humidity


#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per sensor

These metrics refer to the sensor.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| chip | The hardware component responsible for the sensor monitoring. |
| feature | The specific sensor or monitoring point provided by the chip. |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| sensors.sensor_temperature | temperature | Celsius |
| sensors.sensor_voltage | voltage | Volts |
| sensors.sensor_current | current | Amperes |
| sensors.sensor_power | power | Watts |
| sensors.sensor_fan_speed | fan | RPM |
| sensors.sensor_energy | energy | Joules |
| sensors.sensor_humidity | humidity | percent |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

#### Install lm-sensors

- Install `lm-sensors` using your distribution's package manager.
- Run `sensors-detect` to detect hardware monitoring chips.



### Configuration

#### File

The configuration file name for this integration is `go.d/sensors.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/sensors.conf
```
#### Options

The following options can be defined globally: update_every.


<details open><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Data collection frequency. | 10 | no |
| binary_path | Path to the `sensors` binary. If an absolute path is provided, the collector will use it directly; otherwise, it will search for the binary in directories specified in the PATH environment variable. | /usr/bin/sensors | yes |
| timeout | Timeout for executing the binary, specified in seconds. | 2 | no |

</details>

#### Examples

##### Custom binary path

The executable is not in the directories specified in the PATH environment variable.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: sensors
    binary_path: /usr/local/sbin/sensors

```
</details>



## Troubleshooting

### Debug Mode

**Important**: Debug mode is not supported for data collection jobs created via the UI using the Dyncfg feature.

To troubleshoot issues with the `sensors` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m sensors
  ```

### Getting Logs

If you're encountering problems with the `sensors` collector, follow these steps to retrieve logs and identify potential issues:

- **Run the command** specific to your system (systemd, non-systemd, or Docker container).
- **Examine the output** for any warnings or error messages that might indicate issues.  These messages should provide clues about the root cause of the problem.

#### System with systemd

Use the following command to view logs generated since the last Netdata service restart:

```bash
journalctl _SYSTEMD_INVOCATION_ID="$(systemctl show --value --property=InvocationID netdata)" --namespace=netdata --grep sensors
```

#### System without systemd

Locate the collector log file, typically at `/var/log/netdata/collector.log`, and use `grep` to filter for collector's name:

```bash
grep sensors /var/log/netdata/collector.log
```

**Note**: This method shows logs from all restarts. Focus on the **latest entries** for troubleshooting current issues.

#### Docker Container

If your Netdata runs in a Docker container named "netdata" (replace if different), use this command:

```bash
docker logs netdata 2>&1 | grep sensors
```


