/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.internal;

import org.gradle.api.internal.DefaultNamedDomainObjectSet;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.ide.visualstudio.VisualStudioProject;
import org.gradle.ide.visualstudio.internal.DefaultVisualStudioProject;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectConfiguration;
import org.gradle.ide.visualstudio.internal.VisualStudioTargetBinary;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.plugins.ide.internal.IdeArtifactRegistry;
import org.gradle.util.VersionNumber;

public class VisualStudioProjectRegistry
extends DefaultNamedDomainObjectSet<DefaultVisualStudioProject> {
    private final FileResolver fileResolver;
    private final IdeArtifactRegistry ideArtifactRegistry;

    public VisualStudioProjectRegistry(FileResolver fileResolver, Instantiator instantiator, IdeArtifactRegistry ideArtifactRegistry) {
        super(DefaultVisualStudioProject.class, instantiator);
        this.fileResolver = fileResolver;
        this.ideArtifactRegistry = ideArtifactRegistry;
    }

    public VisualStudioProjectConfiguration getProjectConfiguration(VisualStudioTargetBinary targetBinary) {
        String projectName = targetBinary.getVisualStudioProjectName();
        return ((DefaultVisualStudioProject)this.getByName(projectName)).getConfiguration(targetBinary);
    }

    public VisualStudioProjectConfiguration addProjectConfiguration(VisualStudioTargetBinary nativeBinary) {
        DefaultVisualStudioProject project = this.getOrCreateProject(nativeBinary.getVisualStudioProjectName(), nativeBinary.getComponentName(), nativeBinary.getVisualStudioVersion(), nativeBinary.getSdkVersion());
        VisualStudioProjectConfiguration configuration = this.createVisualStudioProjectConfiguration(project, nativeBinary, nativeBinary.getVisualStudioConfigurationName());
        project.addConfiguration(nativeBinary, configuration);
        return configuration;
    }

    private VisualStudioProjectConfiguration createVisualStudioProjectConfiguration(VisualStudioProject project, VisualStudioTargetBinary nativeBinary, String configuration) {
        return (VisualStudioProjectConfiguration)this.getInstantiator().newInstance(VisualStudioProjectConfiguration.class, new Object[]{project, configuration, nativeBinary});
    }

    private DefaultVisualStudioProject getOrCreateProject(String vsProjectName, String componentName, VersionNumber visualStudioVersion, VersionNumber sdkVersion) {
        DefaultVisualStudioProject vsProject = (DefaultVisualStudioProject)this.findByName(vsProjectName);
        if (vsProject == null) {
            vsProject = (DefaultVisualStudioProject)this.getInstantiator().newInstance(DefaultVisualStudioProject.class, new Object[]{vsProjectName, componentName, visualStudioVersion, sdkVersion, this.fileResolver, this.getInstantiator()});
            this.add(vsProject);
            this.ideArtifactRegistry.registerIdeProject(vsProject.getPublishArtifact());
        }
        return vsProject;
    }
}

