/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import java.io.PrintStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;

public class PrintingMessageCollector
implements MessageCollector {
    private final boolean verbose;
    private final PrintStream errStream;
    private final MessageRenderer messageRenderer;
    private boolean hasErrors = false;

    public PrintingMessageCollector(@NotNull PrintStream errStream, @NotNull MessageRenderer messageRenderer, boolean verbose) {
        this.verbose = verbose;
        this.errStream = errStream;
        this.messageRenderer = messageRenderer;
    }

    @Override
    public void clear() {
    }

    @Override
    public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @Nullable CompilerMessageLocation location2) {
        if (!this.verbose && CompilerMessageSeverity.VERBOSE.contains((Object)severity)) {
            return;
        }
        this.hasErrors |= severity.isError();
        this.errStream.println(this.messageRenderer.render(severity, message, location2));
    }

    @Override
    public boolean hasErrors() {
        return this.hasErrors;
    }
}

