/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.cli.jvm.compiler.ClasspathRootsResolver;
import org.jetbrains.kotlin.cli.jvm.config.JavaSourceRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmClasspathRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmModulePathRoot;
import org.jetbrains.kotlin.cli.jvm.index.JavaRoot;
import org.jetbrains.kotlin.cli.jvm.modules.CliJavaModuleFinder;
import org.jetbrains.kotlin.cli.jvm.modules.JavaModuleGraph;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VfsUtilCore;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaModule;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightJavaModule;
import org.jetbrains.kotlin.config.ContentRoot;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModule;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModuleInfo;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 82\u00020\u0001:\u000389:BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\u0012J$\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00072\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J2\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00072\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\f0\u0007H\u0002J\u0014\u0010%\u001a\u00020 2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u0007J\u001e\u0010(\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020*\u0018\u00010)2\u0006\u0010+\u001a\u00020\fH\u0002J\u0012\u0010,\u001a\u0004\u0018\u00010\u001a2\u0006\u0010+\u001a\u00020\fH\u0002J\u001a\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010+\u001a\u00020\f2\u0006\u0010/\u001a\u00020\u0010H\u0002J\u0012\u00100\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u00020\fH\u0002J$\u00103\u001a\u00020\u00182\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\b2\n\b\u0002\u00107\u001a\u0004\u0018\u00010\fH\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;\u00b2\u0006\u000f\u0010<\u001a\u0004\u0018\u000101X\u008a\u0084\u0002\u00a2\u0006\u0000"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/ClasspathRootsResolver;", "", "psiManager", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiManager;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "additionalModules", "", "", "contentRootToVirtualFile", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/cli/jvm/config/JvmContentRoot;", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "javaModuleFinder", "Lorg/jetbrains/kotlin/cli/jvm/modules/CliJavaModuleFinder;", "requireStdlibModule", "", "outputDirectory", "(Lcom/intellij/psi/PsiManager;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Ljava/util/List;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/kotlin/cli/jvm/modules/CliJavaModuleFinder;ZLcom/intellij/openapi/vfs/VirtualFile;)V", "javaModuleGraph", "Lorg/jetbrains/kotlin/cli/jvm/modules/JavaModuleGraph;", "getJavaModuleGraph", "()Lorg/jetbrains/kotlin/cli/jvm/modules/JavaModuleGraph;", "addModularRoots", "", "modules", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule;", "result", "", "Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot;", "computeDefaultRootModules", "computeRoots", "Lorg/jetbrains/kotlin/cli/jvm/compiler/ClasspathRootsResolver$RootsAndModules;", "javaSourceRoots", "Lorg/jetbrains/kotlin/cli/jvm/compiler/ClasspathRootsResolver$RootWithPrefix;", "jvmClasspathRoots", "jvmModulePathRoots", "convertClasspathRoots", "contentRoots", "Lorg/jetbrains/kotlin/config/ContentRoot;", "findSourceModuleInfo", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiJavaModule;", "root", "modularBinaryRoot", "modularSourceRoot", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule$Explicit;", "hasOutputDirectoryInClasspath", "readManifestAttributes", "Ljava/util/jar/Attributes;", "jarRoot", "report", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "message", "file", "Companion", "RootWithPrefix", "RootsAndModules", "cli", "manifest"})
public final class ClasspathRootsResolver {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final JavaModuleGraph javaModuleGraph;
    private final PsiManager psiManager;
    private final MessageCollector messageCollector;
    private final List<String> additionalModules;
    private final Function1<JvmContentRoot, VirtualFile> contentRootToVirtualFile;
    private final CliJavaModuleFinder javaModuleFinder;
    private final boolean requireStdlibModule;
    private final VirtualFile outputDirectory;
    @NotNull
    public static final String MULTI_RELEASE_MODULE_INFO_CLS_FILE = "META-INF/versions/9/module-info.class";
    @NotNull
    public static final String AUTOMATIC_MODULE_NAME = "Automatic-Module-Name";
    @NotNull
    public static final String IS_MULTI_RELEASE = "Multi-Release";
    @Deprecated
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property0((PropertyReference0)new PropertyReference0Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ClasspathRootsResolver.class), "manifest", "<v#0>"))};
        Companion = new Companion(null);
    }

    @NotNull
    public final JavaModuleGraph getJavaModuleGraph() {
        return this.javaModuleGraph;
    }

    @NotNull
    public final RootsAndModules convertClasspathRoots(@NotNull List<? extends ContentRoot> contentRoots) {
        Intrinsics.checkParameterIsNotNull(contentRoots, (String)"contentRoots");
        List javaSourceRoots = new ArrayList();
        List jvmClasspathRoots = new ArrayList();
        List jvmModulePathRoots = new ArrayList();
        for (ContentRoot contentRoot : contentRoots) {
            VirtualFile root2;
            Object object;
            if (!(contentRoot instanceof JvmContentRoot)) continue;
            if ((VirtualFile)this.contentRootToVirtualFile.invoke((Object)contentRoot) == null) {
                continue;
            }
            ContentRoot contentRoot2 = contentRoot;
            if (contentRoot2 instanceof JavaSourceRoot) {
                object = javaSourceRoots;
                RootWithPrefix rootWithPrefix = new RootWithPrefix(root2, ((JavaSourceRoot)contentRoot).getPackagePrefix());
                object.add(rootWithPrefix);
                continue;
            }
            if (contentRoot2 instanceof JvmClasspathRoot) {
                object = jvmClasspathRoots;
                object.add(root2);
                continue;
            }
            if (contentRoot2 instanceof JvmModulePathRoot) {
                object = jvmModulePathRoots;
                object.add(root2);
                continue;
            }
            object = "Unknown root type: " + contentRoot;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        return this.computeRoots(javaSourceRoots, jvmClasspathRoots, jvmModulePathRoots);
    }

    private final RootsAndModules computeRoots(List<RootWithPrefix> javaSourceRoots, List<? extends VirtualFile> jvmClasspathRoots, List<? extends VirtualFile> jvmModulePathRoots) {
        boolean bl;
        List modules;
        List result2;
        block15: {
            Iterator packagePrefix;
            result2 = new ArrayList();
            modules = new ArrayList();
            boolean hasOutputDirectoryInClasspath = CollectionsKt.contains((Iterable)jvmClasspathRoots, (Object)this.outputDirectory) || CollectionsKt.contains((Iterable)jvmModulePathRoots, (Object)this.outputDirectory);
            for (RootWithPrefix rootWithPrefix : javaSourceRoots) {
                FqName fqName2;
                Object object;
                Collection collection;
                VirtualFile root2 = rootWithPrefix.component1();
                packagePrefix = rootWithPrefix.component2();
                JavaModule.Explicit modularRoot = this.modularSourceRoot(root2, hasOutputDirectoryInClasspath);
                if (modularRoot != null) {
                    collection = modules;
                    collection.add(modularRoot);
                    continue;
                }
                collection = result2;
                VirtualFile virtualFile2 = root2;
                JavaRoot.RootType rootType = JavaRoot.RootType.SOURCE;
                Iterator iterator2 = packagePrefix;
                if (iterator2 != null) {
                    FqName fqName3;
                    object = iterator2;
                    JavaRoot.RootType rootType2 = rootType;
                    VirtualFile virtualFile3 = virtualFile2;
                    Object prefix = object;
                    if (FqNamesUtilKt.isValidJavaFqName((String)prefix)) {
                        fqName3 = new FqName((String)prefix);
                    } else {
                        Object var15_22 = null;
                        Void it = var15_22;
                        ClasspathRootsResolver.report$default(this, CompilerMessageSeverity.STRONG_WARNING, "Invalid package prefix name is ignored: " + prefix, null, 4, null);
                        fqName3 = var15_22;
                    }
                    FqName fqName4 = fqName3;
                    virtualFile2 = virtualFile3;
                    rootType = rootType2;
                    fqName2 = fqName4;
                } else {
                    fqName2 = null;
                }
                FqName fqName5 = fqName2;
                JavaRoot.RootType rootType3 = rootType;
                VirtualFile virtualFile4 = virtualFile2;
                object = new JavaRoot(virtualFile4, rootType3, fqName5);
                collection.add(object);
            }
            for (VirtualFile virtualFile5 : jvmClasspathRoots) {
                Iterator<? extends VirtualFile> iterator3 = result2;
                packagePrefix = new JavaRoot(virtualFile5, JavaRoot.RootType.BINARY, null, 4, null);
                iterator3.add((VirtualFile)((Object)packagePrefix));
            }
            Iterable iterable = modules;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : iterable) {
                    boolean bl2;
                    block14: {
                        JavaModule module2 = (JavaModule)element$iv;
                        Iterable $receiver$iv2 = module2.getModuleRoots();
                        if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $receiver$iv2) {
                                JavaModule.Root it = (JavaModule.Root)element$iv2;
                                if (!Intrinsics.areEqual((Object)it.getFile(), (Object)this.outputDirectory)) continue;
                                bl2 = true;
                                break block14;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block15;
                }
                bl = false;
            }
        }
        boolean bl3 = bl;
        for (VirtualFile virtualFile6 : jvmModulePathRoots) {
            JavaModule module3;
            if (bl3 && Intrinsics.areEqual((Object)virtualFile6, (Object)this.outputDirectory) || (module3 = this.modularBinaryRoot(virtualFile6)) == null) continue;
            Collection collection = modules;
            collection.add(module3);
        }
        this.addModularRoots(modules, result2);
        return new RootsAndModules(result2, modules);
    }

    private final Pair<VirtualFile, PsiJavaModule> findSourceModuleInfo(VirtualFile root2) {
        PsiElement psiElement;
        PsiElement psiElement2;
        VirtualFile moduleInfoFile;
        block6: {
            PsiFile psiFile;
            VirtualFile virtualFile2 = root2.isDirectory() ? root2.findChild("module-info.java") : (Intrinsics.areEqual((Object)root2.getName(), (Object)"module-info.java") ? root2 : null);
            if (virtualFile2 == null) {
                return null;
            }
            moduleInfoFile = virtualFile2;
            PsiFile psiFile2 = this.psiManager.findFile(moduleInfoFile);
            if (psiFile2 == null) {
                return null;
            }
            PsiFile psiFile3 = psiFile = psiFile2;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile3, (String)"psiFile");
            PsiElement[] psiElementArray = psiFile3.getChildren();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElementArray, (String)"psiFile.children");
            PsiElement[] $receiver$iv = psiElementArray;
            PsiElement single$iv = null;
            boolean found$iv = false;
            for (PsiElement element$iv : $receiver$iv) {
                PsiElement it = element$iv;
                if (!(it instanceof PsiJavaModule)) continue;
                if (found$iv) {
                    psiElement2 = null;
                    break block6;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            psiElement2 = psiElement = !found$iv ? null : single$iv;
        }
        if (!(psiElement2 instanceof PsiJavaModule)) {
            psiElement = null;
        }
        PsiJavaModule psiJavaModule = (PsiJavaModule)psiElement;
        if (psiJavaModule == null) {
            return null;
        }
        PsiJavaModule psiJavaModule2 = psiJavaModule;
        return TuplesKt.to((Object)moduleInfoFile, (Object)psiJavaModule2);
    }

    /*
     * WARNING - void declaration
     */
    private final JavaModule.Explicit modularSourceRoot(VirtualFile root2, boolean hasOutputDirectoryInClasspath) {
        void moduleInfoFile;
        List list2;
        Pair<VirtualFile, PsiJavaModule> pair = this.findSourceModuleInfo(root2);
        if (pair == null) {
            return null;
        }
        Pair<VirtualFile, PsiJavaModule> pair2 = pair;
        VirtualFile virtualFile2 = (VirtualFile)pair2.component1();
        PsiJavaModule psiJavaModule = (PsiJavaModule)pair2.component2();
        JavaModule.Root sourceRoot = new JavaModule.Root(root2, false);
        if (hasOutputDirectoryInClasspath) {
            Object[] objectArray = new JavaModule.Root[2];
            objectArray[0] = sourceRoot;
            VirtualFile virtualFile3 = this.outputDirectory;
            if (virtualFile3 == null) {
                Intrinsics.throwNpe();
            }
            objectArray[1] = new JavaModule.Root(virtualFile3, true);
            list2 = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list2 = CollectionsKt.listOf((Object)sourceRoot);
        }
        List roots2 = list2;
        return new JavaModule.Explicit(JavaModuleInfo.Companion.create(psiJavaModule), roots2, (VirtualFile)moduleInfoFile);
    }

    private final JavaModule modularBinaryRoot(VirtualFile root2) {
        VirtualFile moduleInfoFile;
        Object object;
        Object var9_8;
        Lazy $i$a$1$takeIf;
        VirtualFileSystem virtualFileSystem = root2.getFileSystem();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileSystem, (String)"root.fileSystem");
        boolean isJar = Intrinsics.areEqual((Object)virtualFileSystem.getProtocol(), (Object)"jar");
        KProperty kProperty = $$delegatedProperties[0];
        Lazy manifest2 = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Attributes>(this, root2){
            final /* synthetic */ ClasspathRootsResolver this$0;
            final /* synthetic */ VirtualFile $root;

            @Nullable
            public final Attributes invoke() {
                return ClasspathRootsResolver.access$readManifestAttributes(this.this$0, this.$root);
            }
            {
                this.this$0 = classpathRootsResolver;
                this.$root = virtualFile2;
                super(0);
            }
        }));
        VirtualFile virtualFile2 = root2.findChild("module-info.class");
        if (virtualFile2 == null) {
            VirtualFile virtualFile3;
            VirtualFile it = virtualFile3 = root2;
            VirtualFile virtualFile4 = isJar ? virtualFile3 : null;
            if (virtualFile4 != null && (virtualFile4 = virtualFile4.findFileByRelativePath(MULTI_RELEASE_MODULE_INFO_CLS_FILE)) != null) {
                it = virtualFile3 = virtualFile4;
                $i$a$1$takeIf = manifest2;
                var9_8 = null;
                object = kProperty;
                Object object2 = (Attributes)$i$a$1$takeIf.getValue();
                virtualFile2 = object2 != null && (object2 = ((Attributes)object2).getValue(IS_MULTI_RELEASE)) != null && StringsKt.equals((String)object2, (String)"true", (boolean)true) ? virtualFile3 : null;
            } else {
                virtualFile2 = moduleInfoFile = null;
            }
        }
        if (moduleInfoFile != null) {
            JavaModuleInfo javaModuleInfo = JavaModuleInfo.Companion.read(moduleInfoFile);
            if (javaModuleInfo == null) {
                return null;
            }
            JavaModuleInfo moduleInfo2 = javaModuleInfo;
            return new JavaModule.Explicit(moduleInfo2, CollectionsKt.listOf((Object)new JavaModule.Root(root2, true)), moduleInfoFile);
        }
        if (isJar) {
            String moduleName;
            File originalFile;
            String automaticModuleName;
            List moduleRoot = CollectionsKt.listOf((Object)new JavaModule.Root(root2, true));
            $i$a$1$takeIf = manifest2;
            var9_8 = null;
            Attributes attributes = (Attributes)$i$a$1$takeIf.getValue();
            String string = automaticModuleName = attributes != null ? attributes.getValue(AUTOMATIC_MODULE_NAME) : null;
            if (automaticModuleName != null) {
                return new JavaModule.Automatic(automaticModuleName, moduleRoot);
            }
            File file2 = originalFile = VfsUtilCore.virtualToIoFile(root2);
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"originalFile");
            String string2 = moduleName = LightJavaModule.moduleName(FilesKt.getNameWithoutExtension((File)file2));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"moduleName");
            object = string2;
            if (object.length() == 0) {
                VirtualFile virtualFile5 = VfsUtilCore.getVirtualFileForJar(root2);
                if (virtualFile5 == null) {
                    virtualFile5 = root2;
                }
                this.report(CompilerMessageSeverity.ERROR, "Cannot infer automatic module name for the file", virtualFile5);
                return null;
            }
            return new JavaModule.Automatic(moduleName, moduleRoot);
        }
        return null;
    }

    private final Attributes readManifestAttributes(VirtualFile jarRoot) {
        Object object;
        VirtualFile virtualFile2 = jarRoot.findChild("META-INF");
        VirtualFile manifestFile = virtualFile2 != null ? virtualFile2.findChild("MANIFEST.MF") : null;
        try {
            Object object2;
            Object object3 = manifestFile;
            if (object3 != null && (object3 = ((VirtualFile)object3).getInputStream()) != null) {
                Object p1 = object = object3;
                object2 = new Manifest((InputStream)p1).getMainAttributes();
            } else {
                object2 = null;
            }
            object = object2;
        }
        catch (IOException e) {
            object = null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final void addModularRoots(List<? extends JavaModule> modules, List<JavaRoot> result2) {
        boolean bl;
        LinkedHashSet<String> allDependencies;
        JavaModule.Explicit explicit;
        block22: {
            List list2;
            Iterator<? extends JavaModule> $receiver$iv$iv;
            Iterable iterable;
            Iterable iterable2 = iterable = (Iterable)modules;
            Collection destination$iv$iv = new ArrayList();
            Iterator iterator2 = $receiver$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object t = iterator2.next();
                if (!(t instanceof JavaModule.Explicit)) continue;
                destination$iv$iv.add(t);
            }
            Iterable iterable3 = (List)destination$iv$iv;
            $receiver$iv$iv = iterable3;
            destination$iv$iv = new ArrayList();
            iterator2 = $receiver$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object t = iterator2.next();
                Object receiver = t;
                if (!((JavaModule)receiver).isSourceModule()) continue;
                destination$iv$iv.add(t);
            }
            List sourceModules = (List)destination$iv$iv;
            if (sourceModules.size() > 1) {
                for (JavaModule.Explicit explicit2 : sourceModules) {
                    this.report(CompilerMessageSeverity.ERROR, "Too many source module declarations found", explicit2.getModuleInfoFile());
                }
                return;
            }
            for (JavaModule javaModule : modules) {
                JavaModule existing = this.javaModuleFinder.findModule(javaModule.getName());
                if (existing == null) {
                    this.javaModuleFinder.addUserModule(javaModule);
                    continue;
                }
                if (!(Intrinsics.areEqual(javaModule.getModuleRoots(), existing.getModuleRoots()) ^ true)) continue;
                addModularRoots.1 getRootFile$ = addModularRoots.1.INSTANCE;
                VirtualFile virtualFile2 = getRootFile$.invoke(javaModule);
                VirtualFile existingFile = getRootFile$.invoke(existing);
                String atExistingPath = existingFile == null ? "" : " at: " + existingFile.getPath();
                this.report(CompilerMessageSeverity.STRONG_WARNING, "The root is ignored because a module with the same name '" + javaModule.getName() + "' " + "has been found earlier on the module path" + (String)atExistingPath, virtualFile2);
            }
            if (SequencesKt.none(this.javaModuleFinder.getAllObservableModules())) {
                return;
            }
            explicit = (JavaModule.Explicit)CollectionsKt.singleOrNull((List)sourceModules);
            boolean addAllModulePathToRoots = this.additionalModules.contains("ALL-MODULE-PATH");
            if (addAllModulePathToRoots && explicit != null) {
                ClasspathRootsResolver.report$default(this, CompilerMessageSeverity.ERROR, "-Xadd-modules=ALL-MODULE-PATH can only be used when compiling the unnamed module", null, 4, null);
                return;
            }
            if (explicit != null) {
                list2 = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)explicit.getName()), (Iterable)this.additionalModules);
            } else if (addAllModulePathToRoots) {
                Iterable $receiver$iv2;
                Iterable iterable4 = $receiver$iv2 = (Iterable)modules;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                for (Object e : iterable4) {
                    void receiver;
                    Object e2 = e;
                    Collection collection = destination$iv$iv2;
                    String string = ((JavaModule)receiver).getName();
                    collection.add(string);
                }
                list2 = (List)destination$iv$iv2;
            } else {
                list2 = CollectionsKt.plus((Collection)this.computeDefaultRootModules(), (Iterable)this.additionalModules);
            }
            List rootModules = list2;
            allDependencies = this.javaModuleGraph.getAllDependencies(rootModules);
            Iterable iterable5 = allDependencies;
            if (iterable5 instanceof Collection && ((Collection)iterable5).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : iterable5) {
                    String string = (String)element$iv;
                    if (!(this.javaModuleFinder.findModule(string) instanceof JavaModule.Automatic)) continue;
                    bl = true;
                    break block22;
                }
                bl = false;
            }
        }
        if (bl) {
            for (JavaModule javaModule : modules) {
                Object element$iv;
                if (!(javaModule instanceof JavaModule.Automatic)) continue;
                element$iv = allDependencies;
                String string = javaModule.getName();
                element$iv.add((String)string);
            }
        }
        ClasspathRootsResolver.report$default(this, CompilerMessageSeverity.LOGGING, "Loading modules: " + allDependencies, null, 4, null);
        Iterator<Object> iterator3 = allDependencies.iterator();
        while (iterator3.hasNext()) {
            String string;
            String string2 = string = (String)iterator3.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"moduleName");
            JavaModule module4 = this.javaModuleFinder.findModule(string2);
            if (module4 == null) {
                ClasspathRootsResolver.report$default(this, CompilerMessageSeverity.ERROR, "Module " + string + " cannot be found in the module graph", null, 4, null);
                continue;
            }
            for (JavaModule.Root root2 : module4.getModuleRoots()) {
                VirtualFile root22 = root2.component1();
                boolean isBinary = root2.component2();
                result2.add(new JavaRoot(root22, isBinary ? JavaRoot.RootType.BINARY : JavaRoot.RootType.SOURCE, null, 4, null));
            }
        }
        if (this.requireStdlibModule && explicit != null && !this.javaModuleGraph.reads(explicit.getName(), "kotlin.stdlib")) {
            this.report(CompilerMessageSeverity.ERROR, "The Kotlin standard library is not found in the module graph. Please ensure you have the 'requires kotlin.stdlib' clause in your module definition", explicit.getModuleInfoFile());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> computeDefaultRootModules() {
        JavaModule.Explicit module2;
        Object name;
        Map.Entry entry;
        Object element$iv$iv;
        Map $receiver$iv$iv;
        Sequence<JavaModule.Explicit> $receiver$iv;
        ArrayList<Object> result2 = new ArrayList<Object>();
        Sequence<JavaModule.Explicit> sequence2 = $receiver$iv = this.javaModuleFinder.getSystemModules();
        Map destination$iv$iv = new LinkedHashMap();
        Object object = $receiver$iv$iv.iterator();
        while (object.hasNext()) {
            void receiver;
            element$iv$iv = object.next();
            Object e = element$iv$iv;
            Map map2 = destination$iv$iv;
            String string = ((JavaModule)receiver).getName();
            map2.put(string, element$iv$iv);
        }
        Map systemModules2 = destination$iv$iv;
        $receiver$iv$iv = systemModules2;
        object = $receiver$iv$iv;
        Object object2 = "java.se";
        boolean javaSeExists = object.containsKey(object2);
        if (javaSeExists) {
            result2.add("java.se");
        }
        computeDefaultRootModules.1 exportsAtLeastOnePackageUnqualified$ = computeDefaultRootModules.1.INSTANCE;
        if (!javaSeExists) {
            element$iv$iv = systemModules2;
            object = element$iv$iv.entrySet().iterator();
            while (object.hasNext()) {
                entry = object2 = object.next();
                name = (String)entry.getKey();
                entry = object2;
                module2 = (JavaModule.Explicit)entry.getValue();
                if (!StringsKt.startsWith$default((String)name, (String)"java.", (boolean)false, (int)2, null) || !exportsAtLeastOnePackageUnqualified$.invoke(module2)) continue;
                result2.add(name);
            }
        }
        name = systemModules2;
        object = name.entrySet().iterator();
        while (object.hasNext()) {
            entry = object2 = object.next();
            name = (String)entry.getKey();
            entry = object2;
            module2 = (JavaModule.Explicit)entry.getValue();
            if (StringsKt.startsWith$default((String)name, (String)"java.", (boolean)false, (int)2, null) || !exportsAtLeastOnePackageUnqualified$.invoke(module2)) continue;
            result2.add(name);
        }
        return result2;
    }

    private final void report(CompilerMessageSeverity severity, String message, VirtualFile file2) {
        if (this.messageCollector == null) {
            throw (Throwable)new IllegalStateException((file2 != null ? file2.getPath() + ":" : "") + (Object)((Object)severity) + ": " + message + " (no MessageCollector configured)");
        }
        this.messageCollector.report(severity, message, file2 == null ? null : CompilerMessageLocation.Companion.create(MessageUtil.virtualFileToPath(file2)));
    }

    static /* bridge */ /* synthetic */ void report$default(ClasspathRootsResolver classpathRootsResolver, CompilerMessageSeverity compilerMessageSeverity, String string, VirtualFile virtualFile2, int n, Object object) {
        if ((n & 4) != 0) {
            virtualFile2 = null;
        }
        classpathRootsResolver.report(compilerMessageSeverity, string, virtualFile2);
    }

    public ClasspathRootsResolver(@NotNull PsiManager psiManager, @Nullable MessageCollector messageCollector2, @NotNull List<String> additionalModules, @NotNull Function1<? super JvmContentRoot, ? extends VirtualFile> contentRootToVirtualFile, @NotNull CliJavaModuleFinder javaModuleFinder, boolean requireStdlibModule, @Nullable VirtualFile outputDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)psiManager, (String)"psiManager");
        Intrinsics.checkParameterIsNotNull(additionalModules, (String)"additionalModules");
        Intrinsics.checkParameterIsNotNull(contentRootToVirtualFile, (String)"contentRootToVirtualFile");
        Intrinsics.checkParameterIsNotNull((Object)javaModuleFinder, (String)"javaModuleFinder");
        this.psiManager = psiManager;
        this.messageCollector = messageCollector2;
        this.additionalModules = additionalModules;
        this.contentRootToVirtualFile = contentRootToVirtualFile;
        this.javaModuleFinder = javaModuleFinder;
        this.requireStdlibModule = requireStdlibModule;
        this.outputDirectory = outputDirectory;
        this.javaModuleGraph = new JavaModuleGraph(this.javaModuleFinder);
    }

    @Nullable
    public static final /* synthetic */ Attributes access$readManifestAttributes(ClasspathRootsResolver $this, @NotNull VirtualFile jarRoot) {
        return $this.readManifestAttributes(jarRoot);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J)\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/ClasspathRootsResolver$RootsAndModules;", "", "roots", "", "Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot;", "modules", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule;", "(Ljava/util/List;Ljava/util/List;)V", "getModules", "()Ljava/util/List;", "getRoots", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "cli"})
    public static final class RootsAndModules {
        @NotNull
        private final List<JavaRoot> roots;
        @NotNull
        private final List<JavaModule> modules;

        @NotNull
        public final List<JavaRoot> getRoots() {
            return this.roots;
        }

        @NotNull
        public final List<JavaModule> getModules() {
            return this.modules;
        }

        public RootsAndModules(@NotNull List<JavaRoot> roots2, @NotNull List<? extends JavaModule> modules) {
            Intrinsics.checkParameterIsNotNull(roots2, (String)"roots");
            Intrinsics.checkParameterIsNotNull(modules, (String)"modules");
            this.roots = roots2;
            this.modules = modules;
        }

        @NotNull
        public final List<JavaRoot> component1() {
            return this.roots;
        }

        @NotNull
        public final List<JavaModule> component2() {
            return this.modules;
        }

        @NotNull
        public final RootsAndModules copy(@NotNull List<JavaRoot> roots2, @NotNull List<? extends JavaModule> modules) {
            Intrinsics.checkParameterIsNotNull(roots2, (String)"roots");
            Intrinsics.checkParameterIsNotNull(modules, (String)"modules");
            return new RootsAndModules(roots2, modules);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ RootsAndModules copy$default(RootsAndModules rootsAndModules, List list2, List list3, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = rootsAndModules.roots;
            }
            if ((n & 2) != 0) {
                list3 = rootsAndModules.modules;
            }
            return rootsAndModules.copy(list2, list3);
        }

        public String toString() {
            return "RootsAndModules(roots=" + this.roots + ", modules=" + this.modules + ")";
        }

        public int hashCode() {
            List<JavaRoot> list2 = this.roots;
            List<JavaModule> list3 = this.modules;
            return (list2 != null ? ((Object)list2).hashCode() : 0) * 31 + (list3 != null ? ((Object)list3).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof RootsAndModules)) break block3;
                    RootsAndModules rootsAndModules = (RootsAndModules)object;
                    if (!Intrinsics.areEqual(this.roots, rootsAndModules.roots) || !Intrinsics.areEqual(this.modules, rootsAndModules.modules)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/ClasspathRootsResolver$RootWithPrefix;", "", "root", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "packagePrefix", "", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;)V", "getPackagePrefix", "()Ljava/lang/String;", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "cli"})
    private static final class RootWithPrefix {
        @NotNull
        private final VirtualFile root;
        @Nullable
        private final String packagePrefix;

        @NotNull
        public final VirtualFile getRoot() {
            return this.root;
        }

        @Nullable
        public final String getPackagePrefix() {
            return this.packagePrefix;
        }

        public RootWithPrefix(@NotNull VirtualFile root2, @Nullable String packagePrefix) {
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            this.root = root2;
            this.packagePrefix = packagePrefix;
        }

        @NotNull
        public final VirtualFile component1() {
            return this.root;
        }

        @Nullable
        public final String component2() {
            return this.packagePrefix;
        }

        @NotNull
        public final RootWithPrefix copy(@NotNull VirtualFile root2, @Nullable String packagePrefix) {
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            return new RootWithPrefix(root2, packagePrefix);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ RootWithPrefix copy$default(RootWithPrefix rootWithPrefix, VirtualFile virtualFile2, String string, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFile2 = rootWithPrefix.root;
            }
            if ((n & 2) != 0) {
                string = rootWithPrefix.packagePrefix;
            }
            return rootWithPrefix.copy(virtualFile2, string);
        }

        public String toString() {
            return "RootWithPrefix(root=" + this.root + ", packagePrefix=" + this.packagePrefix + ")";
        }

        public int hashCode() {
            VirtualFile virtualFile2 = this.root;
            String string = this.packagePrefix;
            return (virtualFile2 != null ? virtualFile2.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof RootWithPrefix)) break block3;
                    RootWithPrefix rootWithPrefix = (RootWithPrefix)object;
                    if (!Intrinsics.areEqual((Object)this.root, (Object)rootWithPrefix.root) || !Intrinsics.areEqual((Object)this.packagePrefix, (Object)rootWithPrefix.packagePrefix)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/ClasspathRootsResolver$Companion;", "", "()V", "AUTOMATIC_MODULE_NAME", "", "IS_MULTI_RELEASE", "MULTI_RELEASE_MODULE_INFO_CLS_FILE", "cli"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

