/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.LanguageLibraryProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.ProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.TemplateLibraryVersionProvider;
import org.gradle.buildinit.plugins.internal.TemplateOperation;
import org.gradle.buildinit.plugins.internal.TemplateOperationFactory;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitDsl;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitTestFramework;
import org.gradle.internal.file.PathToFileResolver;

public abstract class GroovyProjectInitDescriptor
extends LanguageLibraryProjectInitDescriptor {
    private final DocumentationRegistry documentationRegistry;

    public GroovyProjectInitDescriptor(TemplateOperationFactory templateOperationFactory, FileResolver fileResolver, TemplateLibraryVersionProvider libraryVersionProvider, ProjectInitDescriptor globalSettingsDescriptor, DocumentationRegistry documentationRegistry) {
        super("groovy", templateOperationFactory, fileResolver, libraryVersionProvider, globalSettingsDescriptor);
        this.documentationRegistry = documentationRegistry;
    }

    @Override
    public void generate(BuildInitDsl dsl, BuildInitTestFramework testFramework) {
        this.globalSettingsDescriptor.generate(dsl, testFramework);
        BuildScriptBuilder buildScriptBuilder = new BuildScriptBuilder(dsl, (PathToFileResolver)this.fileResolver, "build").fileComment("This generated file contains a sample Groovy project to get you started.").fileComment("For more details take a look at the Groovy Quickstart chapter in the Gradle").fileComment("user guide available at " + this.documentationRegistry.getDocumentationFor("tutorial_groovy_projects")).plugin("Apply the groovy plugin to add support for Groovy", "groovy").compileDependency("Use the latest Groovy version for building this library", "org.codehaus.groovy:groovy-all:" + this.libraryVersionProvider.getVersion("groovy")).testCompileDependency("Use the awesome Spock testing and specification framework", "org.spockframework:spock-core:" + this.libraryVersionProvider.getVersion("spock"));
        this.configureBuildScript(buildScriptBuilder);
        buildScriptBuilder.create().generate();
        TemplateOperation groovySourceTemplate = this.sourceTemplateOperation();
        this.whenNoSourcesAvailable(groovySourceTemplate, this.testTemplateOperation(testFramework)).generate();
    }

    @Override
    public boolean supports(BuildInitTestFramework testFramework) {
        return testFramework == BuildInitTestFramework.SPOCK;
    }

    protected abstract TemplateOperation sourceTemplateOperation();

    protected abstract TemplateOperation testTemplateOperation(BuildInitTestFramework var1);

    protected void configureBuildScript(BuildScriptBuilder buildScriptBuilder) {
    }
}

