/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model;

import com.google.common.base.Preconditions;
import groovy.lang.Closure;
import java.io.File;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.xml.XmlTransformer;
import org.gradle.plugins.ide.api.XmlFileContentMerger;
import org.gradle.plugins.ide.eclipse.model.EclipseClasspath;
import org.gradle.plugins.ide.eclipse.model.EclipseJdt;
import org.gradle.plugins.ide.eclipse.model.EclipseProject;
import org.gradle.plugins.ide.eclipse.model.EclipseWtp;
import org.gradle.util.ConfigureUtil;

public class EclipseModel {
    private EclipseProject project;
    private EclipseClasspath classpath;
    private EclipseJdt jdt;
    private EclipseWtp wtp;

    @Inject
    protected ObjectFactory getObjectFactory() {
        throw new UnsupportedOperationException();
    }

    public EclipseProject getProject() {
        if (this.project == null) {
            XmlTransformer xmlTransformer = new XmlTransformer();
            xmlTransformer.setIndentation("\t");
            this.project = (EclipseProject)this.getObjectFactory().newInstance(EclipseProject.class, new Object[]{new XmlFileContentMerger(xmlTransformer)});
        }
        return this.project;
    }

    public void setProject(EclipseProject project) {
        this.project = project;
    }

    public EclipseClasspath getClasspath() {
        return this.classpath;
    }

    public void setClasspath(EclipseClasspath classpath) {
        this.classpath = classpath;
    }

    public EclipseJdt getJdt() {
        return this.jdt;
    }

    public void setJdt(EclipseJdt jdt) {
        this.jdt = jdt;
    }

    public EclipseWtp getWtp() {
        if (this.wtp == null) {
            this.wtp = (EclipseWtp)this.getObjectFactory().newInstance(EclipseWtp.class, new Object[0]);
        }
        return this.wtp;
    }

    public void setWtp(EclipseWtp wtp) {
        this.wtp = wtp;
    }

    public void project(Closure closure) {
        ConfigureUtil.configure((Closure)closure, (Object)this.getProject());
    }

    public void project(Action<? super EclipseProject> action) {
        action.execute((Object)this.getProject());
    }

    public void classpath(Closure closure) {
        ConfigureUtil.configure((Closure)closure, (Object)this.classpath);
    }

    public void classpath(Action<? super EclipseClasspath> action) {
        action.execute((Object)this.classpath);
    }

    public void wtp(Closure closure) {
        ConfigureUtil.configure((Closure)closure, (Object)this.wtp);
    }

    public void wtp(Action<? super EclipseWtp> action) {
        action.execute((Object)this.wtp);
    }

    public void jdt(Closure closure) {
        ConfigureUtil.configure((Closure)closure, (Object)this.getJdt());
    }

    public void jdt(Action<? super EclipseJdt> action) {
        action.execute((Object)this.getJdt());
    }

    public void pathVariables(Map<String, File> pathVariables) {
        Preconditions.checkNotNull(pathVariables);
        this.classpath.getPathVariables().putAll(pathVariables);
        if (this.wtp != null && this.wtp.getComponent() != null) {
            this.wtp.getComponent().getPathVariables().putAll(pathVariables);
        }
    }
}

