/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.tasks;

import java.io.File;
import javax.inject.Inject;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransportFactory;
import org.gradle.api.publish.internal.PublishOperation;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.publish.maven.internal.publisher.MavenRemotePublisher;
import org.gradle.api.publish.maven.internal.publisher.StaticLockingMavenPublisher;
import org.gradle.api.publish.maven.internal.publisher.ValidatingMavenPublisher;
import org.gradle.api.publish.maven.tasks.AbstractPublishToMaven;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.Factory;

public class PublishToMavenRepository
extends AbstractPublishToMaven {
    private MavenArtifactRepository repository;

    @Internal
    public MavenArtifactRepository getRepository() {
        return this.repository;
    }

    public void setRepository(MavenArtifactRepository repository) {
        this.repository = repository;
    }

    @TaskAction
    public void publish() {
        MavenPublicationInternal publicationInternal = this.getPublicationInternal();
        if (publicationInternal == null) {
            throw new InvalidUserDataException("The 'publication' property is required");
        }
        MavenArtifactRepository repository = this.getRepository();
        if (repository == null) {
            throw new InvalidUserDataException("The 'repository' property is required");
        }
        this.doPublish(publicationInternal, repository);
    }

    private void doPublish(final MavenPublicationInternal publication, final MavenArtifactRepository repository) {
        new PublishOperation(publication, repository.getName()){

            protected void publish() throws Exception {
                MavenRemotePublisher remotePublisher = new MavenRemotePublisher(PublishToMavenRepository.this.getLoggingManagerFactory(), PublishToMavenRepository.this.getMavenRepositoryLocator(), (Factory<File>)PublishToMavenRepository.this.getTemporaryDirFactory(), PublishToMavenRepository.this.getRepositoryTransportFactory());
                StaticLockingMavenPublisher staticLockingPublisher = new StaticLockingMavenPublisher(remotePublisher);
                ValidatingMavenPublisher validatingPublisher = new ValidatingMavenPublisher(staticLockingPublisher);
                validatingPublisher.publish(publication.asNormalisedPublication(), repository);
            }
        }.run();
    }

    @Inject
    protected RepositoryTransportFactory getRepositoryTransportFactory() {
        throw new UnsupportedOperationException();
    }
}

