/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.util.lease;

import java.util.concurrent.TimeUnit;
import org.simpleframework.util.lease.Contract;
import org.simpleframework.util.lease.Controller;
import org.simpleframework.util.lease.Lease;
import org.simpleframework.util.lease.LeaseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ContractLease<T>
implements Lease<T> {
    private final Controller<T> handler;
    private final Contract<T> contract;

    public ContractLease(Controller<T> handler, Contract<T> contract) {
        this.handler = handler;
        this.contract = contract;
    }

    @Override
    public long getExpiry(TimeUnit unit) throws LeaseException {
        return this.contract.getDelay(unit);
    }

    @Override
    public void renew(long duration, TimeUnit unit) throws LeaseException {
        if (duration >= 0L) {
            this.contract.setDelay(duration, unit);
        }
        this.handler.renew(this.contract);
    }

    @Override
    public void cancel() throws LeaseException {
        this.handler.cancel(this.contract);
    }

    @Override
    public T getKey() {
        return this.contract.getKey();
    }
}

