/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.base.Objects;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.changedetection.state.ValueSnapshot;
import org.gradle.api.internal.changedetection.state.ValueSnapshotter;
import org.gradle.caching.internal.BuildCacheHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.io.ClassLoaderObjectInputStream;

public class SerializedValueSnapshot
implements ValueSnapshot {
    private final HashCode implementationHash;
    private final byte[] serializedValue;

    public SerializedValueSnapshot(HashCode implementationHash, byte[] serializedValue) {
        this.implementationHash = implementationHash;
        this.serializedValue = serializedValue;
    }

    public HashCode getImplementationHash() {
        return this.implementationHash;
    }

    public byte[] getValue() {
        return this.serializedValue;
    }

    @Override
    public ValueSnapshot snapshot(Object value, ValueSnapshotter snapshotter) {
        ValueSnapshot snapshot = snapshotter.snapshot(value);
        if (this.hasSameSerializedValue(value, snapshot)) {
            return this;
        }
        return snapshot;
    }

    private boolean hasSameSerializedValue(Object value, ValueSnapshot snapshot) {
        if (snapshot instanceof SerializedValueSnapshot) {
            SerializedValueSnapshot newSnapshot = (SerializedValueSnapshot)snapshot;
            if (!Objects.equal((Object)this.implementationHash, (Object)newSnapshot.implementationHash)) {
                return false;
            }
            if (Arrays.equals(this.serializedValue, newSnapshot.serializedValue)) {
                return true;
            }
            Object oldValue = this.populateClass(value.getClass());
            if (oldValue.equals(value)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void appendToHasher(BuildCacheHasher hasher) {
        if (this.implementationHash == null) {
            hasher.putNull();
        } else {
            hasher.putHash(this.implementationHash);
        }
        hasher.putBytes(this.serializedValue);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SerializedValueSnapshot other = (SerializedValueSnapshot)obj;
        return Objects.equal((Object)this.implementationHash, (Object)other.implementationHash) && Arrays.equals(this.serializedValue, other.serializedValue);
    }

    protected Object populateClass(Class<?> originalClass) {
        Object populated;
        try {
            populated = new ClassLoaderObjectInputStream((InputStream)new ByteArrayInputStream(this.serializedValue), originalClass.getClassLoader()).readObject();
        }
        catch (Exception e) {
            throw new UncheckedIOException((Throwable)e);
        }
        return populated;
    }

    public int hashCode() {
        return Arrays.hashCode(this.serializedValue);
    }
}

