/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization.loadercache;

import org.gradle.api.internal.file.collections.ImmutableFileCollection;
import org.gradle.caching.internal.DefaultBuildCacheHasher;
import org.gradle.internal.classloader.ClasspathHasher;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.fingerprint.ClasspathFingerprinter;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.normalization.internal.InputNormalizationStrategy;

public class DefaultClasspathHasher
implements ClasspathHasher {
    private final ClasspathFingerprinter fingerprinter;

    public DefaultClasspathHasher(ClasspathFingerprinter fingerprinter) {
        this.fingerprinter = fingerprinter;
    }

    public HashCode hash(ClassPath classpath) {
        CurrentFileCollectionFingerprint fingerprint = this.fingerprinter.fingerprint(ImmutableFileCollection.of(classpath.getAsFiles()), InputNormalizationStrategy.NO_NORMALIZATION);
        DefaultBuildCacheHasher hasher = new DefaultBuildCacheHasher();
        hasher.putHash(fingerprint.getHash());
        return hasher.hash();
    }
}

