#include "YODA/Exceptions.h"
#include "YODA/Utils/StatsUtils.h"
#include <iostream>
#include <string>
#include <vector>

using namespace std;
using namespace YODA;

int main() {

  vector<vector<double>> wAvg = weightedAverage({ 1.0, 10.0, 100.0 }, { 0.5, 0.5, 0.5 },
                                                { 2.0, 20.0, 200.0 }, { 0.5, 0.5, 0.5 });
  double ref = 150;
  size_t i = 3;
  while (--i) {
    if (!fuzzyEquals(wAvg[0][i], ref))  return EXIT_FAILURE;
    if (!fuzzyEquals(wAvg[1][i], 0.125))  return EXIT_FAILURE;
    ref *= 0.1;
  }
  cout << "PASS: weighted average" << endl;

  vector<double> sample1{5., 15., 80.};
  vector<double> cdf_dist = cdf(sample1);
  vector<double> ref_vals{0.05, 0.2, 1.0};
  for (size_t i=0; i < cdf_dist.size(); ++i) {
    if (!fuzzyEquals(cdf_dist[i], ref_vals[i]))  return EXIT_FAILURE;
  }
  cout << "PASS: CDF" << endl;

  vector<double> sample2{10., 30., 60.};
  if ( !isZero(ksTest(sample1, sample1)) )  return EXIT_FAILURE;
  if ( !fuzzyEquals( ksTest(sample1, sample2), 0.2) )  return EXIT_FAILURE;
  cout << "PASS: K-S" << endl;

  vector<double> ksProbe{0.0, 0.2, 0.4, 0.6, 1.0};
  vector<double> ksRefs{1.0, 0.999999, 0.970041, 0.652711, 0.0995618};
  for (size_t i=0; i < ksProbe.size(); ++i) {
    if (!fuzzyEquals( pValFromKS(ksProbe[i], 3.0, 3.0), ksRefs[i]))  return EXIT_FAILURE;
  }
  cout << "PASS: K-S to p-value" << endl;

  cout << "SUCCESS." << endl;

  return EXIT_SUCCESS;
}
