/* Xpaint-procedure */

#include <Xpaint.h>
#include <Xpaint3d.h>

Widget paint = None;

/* Define and Plot a Lissajous curve */

void lissajous(point p, double x)
{
   double u, v;
   p[0] = cos(3*x);
   p[1] = sin(4*x);
   p[2] = 0 ;
   rescale(p, &u, &v);
   if (DoVxp(paint)) {
      sprintf(Global.vxpinput, "\n%g,%g", u, v);
      RecordVxp(paint);
   }
}

void PaintProcedure()
{
   Image * image;
   unsigned char * p;
   int x, y, i, j, n;
   unsigned char bg[3] = { 255,255,255 };  /* background = white */
   unsigned char fg[3] = { 240, 85, 30 };  /* foreground = brick */

   width = 1280;
   height = 960;
   zoom = 1;

   /* Create new canvas */
   paint = graphicCreate(makeGraphicShell(Global.toplevel),
		         width, height, zoom, None, None, NULL);
   SetVxp(paint, True);

   if (DoVxp(paint)) {
      sprintf(Global.vxpinput, "\n*color1 %02x%02x%02x", fg[0], fg[1], fg[2]);
      RecordVxp(paint);      
      strcpy(Global.vxpinput, "\n*0 pencil");
      RecordVxp(paint);
   }
   
   x_1 = -1.5; x_2 = 1.5;
   y_1 = -1.2; y_2 = 1.2;

   /* z is always set to 0 ; any interval which contains 0 works */
   z_1 = -1; z_2 = 4;

   create_3d_buffer();

   rotation_angles(0, 0, 0);

   n = 2000;
   curve(lissajous, 0, 2*M_PI, n);

   image = ImageNew(width, height);

   for (y = 0; y < height; y++) {
       for (x = 0; x < width; x++) {
           p = ImagePixel(image, x, y);
           i = x+y*width;
           if (luminosity[i]) setcolor(p, fg); else setcolor(p, bg);
       }
   }

   if (DoVxp(paint)) {
      strcpy(Global.vxpinput, "\n*end");
      RecordVxp(paint);
   }
   ImageToPaintWidget(image, paint);
   free_3d_buffer();
   ScriptEditor(Global.toplevel, paint, (XtPointer)2);
}

