#include "setup.h"
#ifndef HAVE_LIBZ
/*
 * NEVER EVER edit this manually, fix the mkhelp.pl script instead!
 * Generation time: Wed May 11 13:35:34 2005
 */
#include "setup.h"
#ifdef USE_MANUAL
#include "hugehelp.h"
#include <stdio.h>
void hugehelp(void)
{
   fputs(
"                                  _   _ ____  _     \n"
"  Project                     ___| | | |  _ \\| |    \n"
"                             / __| | | | |_) | |    \n"
"                            | (__| |_| |  _ <| |___ \n"
"                             \\___|\\___/|_| \\_\\_____|\n"
"\n"
"NAME\n"
"       curl - transfer a URL\n"
"\n"
"SYNOPSIS\n"
"       curl [options] [URL...]\n"
"\n"
"DESCRIPTION\n"
"       curl  is  a tool to transfer data from or to a server, using one of the\n"
, stdout);
 fputs(
"       supported protocols (HTTP, HTTPS, FTP, FTPS, GOPHER, DICT, TELNET, LDAP\n"
"       or FILE). The command is designed to work without user interaction.\n"
"\n"
"       curl offers a busload of useful tricks like proxy support, user authen-\n"
"       tication, ftp upload, HTTP post,  SSL  (https:)  connections,  cookies,\n"
"       file  transfer  resume  and  more. As you will see below, the amount of\n"
"       features will make your head spin!\n"
"\n"
, stdout);
 fputs(
"       curl is powered by  libcurl  for  all  transfer-related  features.  See\n"
"       libcurl(3) for details.\n"
"\n"
"URL\n"
"       The  URL  syntax is protocol dependent. You'll find a detailed descrip-\n"
"       tion in RFC 2396.\n"
"\n"
"       You can specify multiple URLs or parts of URLs  by  writing  part  sets\n"
"       within braces as in:\n"
"\n"
"        http://site.{one,two,three}.com\n"
"\n"
"       or you can get sequences of alphanumeric series by using [] as in:\n"
"\n"
"        ftp://ftp.numericals.com/file[1-100].txt\n"
, stdout);
 fputs(
"        ftp://ftp.numericals.com/file[001-100].txt    (with leading zeros)\n"
"        ftp://ftp.letters.com/file[a-z].txt\n"
"\n"
"       No nesting of the sequences is supported at the moment, but you can use\n"
"       several ones next to each other:\n"
"\n"
"        http://any.org/archive[1996-1999]/vol[1-4]/part{a,b,c}.html\n"
"\n"
"       You can specify any amount of URLs on the command line.  They  will  be\n"
"       fetched in a sequential manner in the specified order.\n"
"\n"
, stdout);
 fputs(
"       Curl will attempt to re-use connections for multiple file transfers, so\n"
"       that getting many files from the same server will not do multiple  con-\n"
"       nects / handshakes. This improves speed. Of course this is only done on\n"
"       files specified on a single command line and  cannot  be  used  between\n"
"       separate curl invokes.\n"
"\n"
"OPTIONS\n"
"       -a/--append\n"
"              (FTP)  When used in an FTP upload, this will tell curl to append\n"
, stdout);
 fputs(
"              to the target file  instead  of  overwriting  it.  If  the  file\n"
"              doesn't exist, it will be created.\n"
"\n"
"              If this option is used twice, the second one will disable append\n"
"              mode again.\n"
"\n"
"       -A/--user-agent <agent string>\n"
"              (HTTP) Specify the User-Agent string to send to the HTTP server.\n"
"              Some  badly  done CGIs fail if its not set to \"Mozilla/4.0\".  To\n"
, stdout);
 fputs(
"              encode blanks in the string, surround  the  string  with  single\n"
"              quote  marks.   This can also be set with the -H/--header option\n"
"              of course.\n"
"\n"
"              If this option is set more than once, the last one will  be  the\n"
"              one that's used.\n"
"\n"
"       --anyauth\n"
"              (HTTP) Tells curl to figure out authentication method by itself,\n"
"              and use the most secure one the remote site claims it  supports.\n"
, stdout);
 fputs(
"              This is done by first doing a request and checking the response-\n"
"              headers, thus inducing an extra network round-trip. This is used\n"
"              instead  of  setting a specific authentication method, which you\n"
"              can do with --basic, --digest, --ntlm, and  --negotiate.  (Added\n"
"              in 7.10.6)\n"
"\n"
"              Note  that  using --anyauth is not recommended if you do uploads\n"
"              from stdin, since it may require data to be sent twice and  then\n"
, stdout);
 fputs(
"              the client must be able to rewind. If the need should arise when\n"
"              uploading from stdin, the upload operation will fail.\n"
"\n"
"              If this option is used several times, the following  occurrences\n"
"              make no difference.\n"
"\n"
"       -b/--cookie <name=data>\n"
"              (HTTP)  Pass the data to the HTTP server as a cookie. It is sup-\n"
"              posedly the data previously received from the server in a  \"Set-\n"
, stdout);
 fputs(
"              Cookie:\"  line.  The data should be in the format \"NAME1=VALUE1;\n"
"              NAME2=VALUE2\".\n"
"\n"
"              If no '=' letter is used in the line, it is treated as  a  file-\n"
"              name  to  use to read previously stored cookie lines from, which\n"
"              should be used in this session if they match. Using this  method\n"
"              also  activates  the \"cookie parser\" which will make curl record\n"
, stdout);
 fputs(
"              incoming cookies too, which may be handy if you're using this in\n"
"              combination  with  the  -L/--location option. The file format of\n"
"              the file to read cookies from should be plain  HTTP  headers  or\n"
"              the Netscape/Mozilla cookie file format.\n"
"\n"
"              NOTE  that  the  file specified with -b/--cookie is only used as\n"
"              input. No cookies will be stored in the file. To store  cookies,\n"
, stdout);
 fputs(
"              use  the  -c/--cookie-jar option or you could even save the HTTP\n"
"              headers to a file using -D/--dump-header!\n"
"\n"
"              If this option is set more than once, the last one will  be  the\n"
"              one that's used.\n"
"\n"
"       -B/--use-ascii\n"
"              Enable  ASCII transfer when using FTP or LDAP. For FTP, this can\n"
"              also be enforced by using an URL that ends with \";type=A\".  This\n"
, stdout);
 fputs(
"              option  causes  data sent to stdout to be in text mode for win32\n"
"              systems.\n"
"\n"
"              If this option is used twice, the second one will disable  ASCII\n"
"              usage.\n"
"\n"
"       --basic\n"
"              (HTTP)  Tells curl to use HTTP Basic authentication. This is the\n"
"              default and this option is usually pointless, unless you use  it\n"
"              to  override  a  previously  set  option  that  sets a different\n"
, stdout);
 fputs(
"              authentication method (such as --ntlm,  --digest  and  --negoti-\n"
"              ate). (Added in 7.10.6)\n"
"\n"
"              If  this option is used several times, the following occurrences\n"
"              make no difference.\n"
"\n"
"       --ciphers <list of ciphers>\n"
"              (SSL) Specifies which ciphers to use in the connection. The list\n"
"              of  ciphers  must  be using valid ciphers. Read up on SSL cipher\n"
, stdout);
 fputs(
"              list          details           on           this           URL:\n"
"              http://www.openssl.org/docs/apps/ciphers.html\n"
"\n"
"              If this option is used several times, the last one will override\n"
"              the others.\n"
"\n"
"       --compressed\n"
"              (HTTP) Request a compressed response using one of the algorithms\n"
"              libcurl supports, and return the uncompressed document.  If this\n"
, stdout);
 fputs(
"              option is used and the server  sends  an  unsupported  encoding,\n"
"              Curl will report an error.\n"
"\n"
"              If  this option is used several times, each occurrence will tog-\n"
"              gle it on/off.\n"
"\n"
"       --connect-timeout <seconds>\n"
"              Maximum time in seconds that you allow  the  connection  to  the\n"
"              server  to  take.   This  only limits the connection phase, once\n"
, stdout);
 fputs(
"              curl has connected this option is of no more use. See  also  the\n"
"              -m/--max-time option.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -c/--cookie-jar <file name>\n"
"              Specify to which file you want curl to write all cookies after a\n"
"              completed  operation.  Curl  writes  all cookies previously read\n"
"              from a specified file as  well  as  all  cookies  received  from\n"
, stdout);
 fputs(
"              remote server(s). If no cookies are known, no file will be writ-\n"
"              ten. The file will be written using  the  Netscape  cookie  file\n"
"              format.  If  you  set  the  file name to a single dash, \"-\", the\n"
"              cookies will be written to stdout.\n"
"\n"
"              NOTE If the cookie jar can't be created or written to, the whole\n"
"              curl operation won't fail or even report an error clearly. Using\n"
, stdout);
 fputs(
"              -v will get a warning displayed, but that is  the  only  visible\n"
"              feedback you get about this possibly lethal situation.\n"
"\n"
"              If  this  option  is used several times, the last specified file\n"
"              name will be used.\n"
"\n"
"       -C/--continue-at <offset>\n"
"              Continue/Resume a previous file transfer at  the  given  offset.\n"
"              The  given  offset  is  the  exact  number of bytes that will be\n"
, stdout);
 fputs(
"              skipped counted from the beginning of the source file before  it\n"
"              is  transferred  to  the destination.  If used with uploads, the\n"
"              ftp server command SIZE will not be used by curl.\n"
"\n"
"              Use \"-C -\" to tell curl to automatically find out  where/how  to\n"
"              resume  the  transfer. It then uses the given output/input files\n"
"              to figure that out.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
, stdout);
 fputs(
"       --create-dirs\n"
"              When  used  in  conjunction with the -o option, curl will create\n"
"              the necessary local directory hierarchy as needed.  This  option\n"
"              creates  the dirs mentioned with the -o option, nothing else. If\n"
"              the -o file name uses no dir or if the dirs it mentions  already\n"
"              exist, no dir will be created.\n"
"\n"
"              To  create  remote directories when using FTP, try --ftp-create-\n"
"              dirs.\n"
"\n"
, stdout);
 fputs(
"       --crlf (FTP) Convert LF to CRLF in upload. Useful for MVS (OS/390).\n"
"\n"
"              If this option is used twice, the second will again disable crlf\n"
"              converting.\n"
"\n"
"       -d/--data <data>\n"
"              (HTTP)  Sends  the  specified data in a POST request to the HTTP\n"
"              server, in a way that can emulate as if a user has filled  in  a\n"
"              HTML  form  and pressed the submit button. Note that the data is\n"
, stdout);
 fputs(
"              sent exactly as specified with no  extra  processing  (with  all\n"
"              newlines  cut  off).   The data is expected to be \"url-encoded\".\n"
"              This will cause curl to pass the data to the  server  using  the\n"
"              content-type   application/x-www-form-urlencoded.   Compare   to\n"
"              -F/--form. If this option is used more than  once  on  the  same\n"
"              command  line, the data pieces specified will be merged together\n"
, stdout);
 fputs(
"              with a separating  &-letter.  Thus,  using  '-d  name=daniel  -d\n"
"              skill=lousy'  would  generate  a  post  chunk  that  looks  like\n"
"              'name=daniel&skill=lousy'.\n"
"\n"
"              If you start the data with the letter @, the rest  should  be  a\n"
"              file  name  to read the data from, or - if you want curl to read\n"
"              the data from stdin.  The contents of the file must  already  be\n"
, stdout);
 fputs(
"              url-encoded.  Multiple files can also be specified. Posting data\n"
"              from a file named 'foobar' would thus be done with --data  @foo-\n"
"              bar\".\n"
"\n"
"              To  post  data purely binary, you should instead use the --data-\n"
"              binary option.\n"
"\n"
"              -d/--data is the same as --data-ascii.\n"
"\n"
"              If this option is used several times,  the  ones  following  the\n"
"              first will append data.\n"
"\n"
"       --data-ascii <data>\n"
, stdout);
 fputs(
"              (HTTP) This is an alias for the -d/--data option.\n"
"\n"
"              If  this  option  is  used several times, the ones following the\n"
"              first will append data.\n"
"\n"
"       --data-binary <data>\n"
"              (HTTP) This posts data in a similar manner as --data-ascii does,\n"
"              although when using this option the entire context of the posted\n"
"              data is kept as-is. If you want to post a  binary  file  without\n"
, stdout);
 fputs(
"              the  strip-newlines  feature of the --data-ascii option, this is\n"
"              for you.\n"
"\n"
"              If this option is used several times,  the  ones  following  the\n"
"              first will append data.\n"
"\n"
"       --digest\n"
"              (HTTP) Enables HTTP Digest authentication. This is a authentica-\n"
"              tion that prevents the password from being sent over the wire in\n"
"              clear  text.  Use  this in combination with the normal -u/--user\n"
, stdout);
 fputs(
"              option to set user name and password. See also --ntlm, --negoti-\n"
"              ate and --anyauth for related options. (Added in curl 7.10.6)\n"
"\n"
"              If  this option is used several times, the following occurrences\n"
"              make no difference.\n"
"\n"
"       --disable-eprt\n"
"              (FTP) Tell curl to disable the use of the EPRT and LPRT commands\n"
"              when doing active FTP transfers. Curl will normally always first\n"
, stdout);
 fputs(
"              attempt to use EPRT, then LPRT before using PORT, but with  this\n"
"              option,  it  will  use PORT right away. EPRT and LPRT are exten-\n"
"              sions to the original FTP protocol, may not work on all  servers\n"
"              but  enable  more  functionality in a better way than the tradi-\n"
"              tional PORT command. (Added in 7.10.5)\n"
"\n"
"              If this option is used several times, each occurrence will  tog-\n"
"              gle this on/off.\n"
"\n"
, stdout);
 fputs(
"       --disable-epsv\n"
"              (FTP)  Tell  curl  to  disable  the use of the EPSV command when\n"
"              doing passive FTP transfers. Curl  will  normally  always  first\n"
"              attempt  to  use EPSV before PASV, but with this option, it will\n"
"              not try using EPSV.\n"
"\n"
"              If this option is used several times, each occurrence will  tog-\n"
"              gle this on/off.\n"
"\n"
"       -D/--dump-header <file>\n"
"              Write the protocol headers to the specified file.\n"
, stdout);
 fputs(
"\n"
"              This  option  is handy to use when you want to store the headers\n"
"              that a HTTP site sends to you. Cookies from  the  headers  could\n"
"              then  be  read  in a second curl invoke by using the -b/--cookie\n"
"              option! The -c/--cookie-jar option is however a  better  way  to\n"
"              store cookies.\n"
"\n"
"              When  used  on FTP, the ftp server response lines are considered\n"
"              being \"headers\" and thus are saved there.\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -e/--referer <URL>\n"
"              (HTTP)  Sends the \"Referer Page\" information to the HTTP server.\n"
"              This can also be set with the -H/--header flag of course.   When\n"
"              used  with  -L/--location  you can append \";auto\" to the referer\n"
"              URL to make curl automatically set the previous URL when it fol-\n"
, stdout);
 fputs(
"              lows  a  Location: header. The \";auto\" string can be used alone,\n"
"              even if you don't set an initial referer.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --engine <name>\n"
"              Select  the  OpenSSL crypto engine to use for cipher operations.\n"
"              Use --engine list  to  print  a  list  of  build-time  supported\n"
"              engines.  Note  that  not  all  (or  none) of the engines may be\n"
, stdout);
 fputs(
"              available at run-time.\n"
"\n"
"       --environment\n"
"              (RISC OS ONLY) Sets a range of environment variables, using  the\n"
"              names the -w option supports, to easier allow extraction of use-\n"
"              ful information after having run curl.\n"
"\n"
"              If this option is used several times, each occurrence will  tog-\n"
"              gle this on/off.\n"
"\n"
"       --egd-file <file>\n"
"              (HTTPS)  Specify  the  path name to the Entropy Gathering Daemon\n"
, stdout);
 fputs(
"              socket. The socket is used to seed the  random  engine  for  SSL\n"
"              connections. See also the --random-file option.\n"
"\n"
"       -E/--cert <certificate[:password]>\n"
"              (HTTPS)  Tells  curl  to use the specified certificate file when\n"
"              getting a file with HTTPS. The certificate must be in  PEM  for-\n"
"              mat.   If  the  optional  password  isn't  specified, it will be\n"
"              queried for on the terminal. Note that this certificate  is  the\n"
, stdout);
 fputs(
"              private key and the private certificate concatenated!\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --cert-type <type>\n"
"              (SSL) Tells curl what certificate type the provided  certificate\n"
"              is in. PEM, DER and ENG are recognized types.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --cacert <CA certificate>\n"
, stdout);
 fputs(
"              (HTTPS) Tells curl to use the specified certificate file to ver-\n"
"              ify the peer. The file may contain multiple CA certificates. The\n"
"              certificate(s) must be in PEM format.\n"
"\n"
"              curl recognizes the environment variable named  'CURL_CA_BUNDLE'\n"
"              if  that  is set, and uses the given path as a path to a CA cert\n"
"              bundle. This option overrides that variable.\n"
"\n"
, stdout);
 fputs(
"              The windows version of curl will automatically  look  for  a  CA\n"
"              certs file named 'curl-ca-bundle.crt', either in the same direc-\n"
"              tory as curl.exe, or in the Current Working Directory, or in any\n"
"              folder along your PATH.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --capath <CA certificate directory>\n"
"              (HTTPS) Tells curl to use the specified certificate directory to\n"
, stdout);
 fputs(
"              verify the peer. The certificates must be in PEM format, and the\n"
"              directory must have been processed using  the  c_rehash  utility\n"
"              supplied  with  openssl.  Using  --capath can allow curl to make\n"
"              https connections much more efficiently than using  --cacert  if\n"
"              the --cacert file contains many CA certificates.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -f/--fail\n"
, stdout);
 fputs(
"              (HTTP) Fail silently (no output at all) on server  errors.  This\n"
"              is  mostly done like this to better enable scripts etc to better\n"
"              deal with failed attempts. In normal cases when  a  HTTP  server\n"
"              fails  to deliver a document, it returns a HTML document stating\n"
"              so (which often also describes why and  more).  This  flag  will\n"
"              prevent curl from outputting that and fail silently instead.\n"
"\n"
, stdout);
 fputs(
"              If  this  option  is  used  twice, the second will again disable\n"
"              silent failure.\n"
"\n"
"       --ftp-account [data]\n"
"              (FTP) When an FTP server asks for \"account data\" after user name\n"
"              and  password has been provided, this data is sent off using the\n"
"              ACCT command. (Added in 7.13.0)\n"
"\n"
"              If this option is used twice, the second will override the  pre-\n"
"              vious use.\n"
"\n"
"       --ftp-create-dirs\n"
, stdout);
 fputs(
"              (FTP)  When  an  FTP URL/operation uses a path that doesn't cur-\n"
"              rently exist on the server, the standard behavior of curl is  to\n"
"              fail.  Using  this  option,  curl will instead attempt to create\n"
"              missing directories. (Added in 7.10.7)\n"
"\n"
"              If this option is used twice,  the  second  will  again  disable\n"
"              silent failure.\n"
"\n"
"       --ftp-pasv\n"
"              (FTP)  Use  PASV when transferring. PASV is the internal default\n"
, stdout);
 fputs(
"              behavior, but using this option can be used to override a previ-\n"
"              ous --ftp-port option. (Added in 7.11.0)\n"
"\n"
"              If  this  option  is  used  twice, the second will again disable\n"
"              silent failure.\n"
"\n"
"       --ftp-ssl\n"
"              (FTP) Make the FTP connection switch to use SSL/TLS.  (Added  in\n"
"              7.11.0)\n"
"\n"
"              If  this  option  is  used  twice, the second will again disable\n"
"              this.\n"
"\n"
"       -F/--form <name=content>\n"
, stdout);
 fputs(
"              (HTTP) This lets curl emulate a filled in form in which  a  user\n"
"              has  pressed  the  submit  button. This causes curl to POST data\n"
"              using the Content-Type multipart/form-data according to RFC1867.\n"
"              This  enables  uploading of binary files etc. To force the 'con-\n"
"              tent' part to be a file, prefix the file name with an @ sign. To\n"
"              just get the content part from a file, prefix the file name with\n"
, stdout);
 fputs(
"              the letter <. The difference between @ and  <  is  then  that  @\n"
"              makes  a  file  get attached in the post as a file upload, while\n"
"              the < makes a text field and just get the contents for that text\n"
"              field from a file.\n"
"\n"
"              Example,  to send your password file to the server, where 'pass-\n"
"              word' is the name of the form-field to which /etc/passwd will be\n"
"              the input:\n"
"\n"
, stdout);
 fputs(
"              curl -F password=@/etc/passwd www.mypasswords.com\n"
"\n"
"              To  read  the file's content from stdin instead of a file, use -\n"
"              where the file name should've been. This goes for both @  and  <\n"
"              constructs.\n"
"\n"
"              You  can  also  tell  curl  what  Content-Type  to  use by using\n"
"              'type=', in a manner similar to:\n"
"\n"
"              curl -F \"web=@index.html;type=text/html\" url.com\n"
"\n"
"              or\n"
"\n"
, stdout);
 fputs(
"              curl -F \"name=daniel;type=text/foo\" url.com\n"
"\n"
"              You can also explicitly change the name field of an file  upload\n"
"              part by setting filename=, like this:\n"
"\n"
"              curl -F \"file=@localfile;filename=nameinpost\" url.com\n"
"\n"
"              See further examples and details in the MANUAL.\n"
"\n"
"              This option can be used multiple times.\n"
"\n"
"       --form-string <name=string>\n"
"              (HTTP)  Similar  to  --form except that the value string for the\n"
, stdout);
 fputs(
"              named parameter is used literally. Leading '@' and  '<'  charac-\n"
"              ters, and the ';type=' string in the value have no special mean-\n"
"              ing. Use this in preference to --form if there's any possibility\n"
"              that  the  string  value may accidentally trigger the '@' or '<'\n"
"              features of --form.\n"
"\n"
"       -g/--globoff\n"
"              This option switches off the \"URL globbing parser\". When you set\n"
, stdout);
 fputs(
"              this  option, you can specify URLs that contain the letters {}[]\n"
"              without having them being interpreted by curl itself. Note  that\n"
"              these  letters are not normal legal URL contents but they should\n"
"              be encoded according to the URI standard.\n"
"\n"
"       -G/--get\n"
"              When used,  this  option  will  make  all  data  specified  with\n"
"              -d/--data  or  --data-binary  to  be  used in a HTTP GET request\n"
, stdout);
 fputs(
"              instead of the POST request that otherwise would  be  used.  The\n"
"              data will be appended to the URL with a '?'  separator.\n"
"\n"
"              If  used  in  combination with -I, the POST data will instead be\n"
"              appended to the URL with a HEAD request.\n"
"\n"
"              If used multiple times, nothing special happens.\n"
"\n"
"       -h/--help\n"
"              Usage help.\n"
"\n"
"       -H/--header <header>\n"
"              (HTTP) Extra header to use when getting  a  web  page.  You  may\n"
, stdout);
 fputs(
"              specify any number of extra headers. Note that if you should add\n"
"              a custom header that has the same name as one  of  the  internal\n"
"              ones  curl  would  use,  your externally set header will be used\n"
"              instead of the internal one. This allows you to make even trick-\n"
"              ier  stuff  than  curl would normally do. You should not replace\n"
"              internally set  headers  without  knowing  perfectly  well  what\n"
, stdout);
 fputs(
"              you're doing. Replacing an internal header with one without con-\n"
"              tent on the right side of the colon  will  prevent  that  header\n"
"              from appearing.\n"
"\n"
"              See also the -A/--user-agent and -e/--referer options.\n"
"\n"
"              This  option  can  be  used multiple times to add/replace/remove\n"
"              multiple headers.\n"
"\n"
"       -i/--include\n"
"              (HTTP) Include the HTTP-header in the  output.  The  HTTP-header\n"
, stdout);
 fputs(
"              includes  things  like  server-name, date of the document, HTTP-\n"
"              version and more...\n"
"\n"
"              If this option is used twice,  the  second  will  again  disable\n"
"              header include.\n"
"\n"
"       --interface <name>\n"
"              Perform  an operation using a specified interface. You can enter\n"
"              interface name, IP address or host name. An example  could  look\n"
"              like:\n"
"\n"
"               curl --interface eth0:1 http://www.netscape.com/\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -I/--head\n"
"              (HTTP/FTP/FILE) Fetch the HTTP-header only! HTTP-servers feature\n"
"              the  command  HEAD which this uses to get nothing but the header\n"
"              of a document. When used on a FTP or FILE  file,  curl  displays\n"
"              the file size and last modification time only.\n"
"\n"
"              If  this  option  is  used  twice, the second will again disable\n"
, stdout);
 fputs(
"              header only.\n"
"\n"
"       -j/--junk-session-cookies\n"
"              (HTTP) When curl is told to read cookies from a given file, this\n"
"              option  will  make  it  discard all \"session cookies\". This will\n"
"              basically have the same effect as if a new session  is  started.\n"
"              Typical  browsers  always  discard  session cookies when they're\n"
"              closed down. (Added in 7.9.7)\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, each occurrence will  tog-\n"
"              gle this on/off.\n"
"\n"
"       -k/--insecure\n"
"              (SSL)  This  option explicitly allows curl to perform \"insecure\"\n"
"              SSL connections and transfers. Starting with curl 7.10, all  SSL\n"
"              connections  will be attempted to be made secure by using the CA\n"
"              certificate bundle installed by default. This makes all  connec-\n"
, stdout);
 fputs(
"              tions  considered  \"insecure\"  to  fail  unless -k/--insecure is\n"
"              used.\n"
"\n"
"              If this option is used twice, the second time will again disable\n"
"              it.\n"
"\n"
"       --key <key>\n"
"              (SSL)  Private key file name. Allows you to provide your private\n"
"              key in this separate file.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --key-type <type>\n"
, stdout);
 fputs(
"              (SSL)  Private key file type. Specify which type your --key pro-\n"
"              vided private key is. DER, PEM and ENG are supported.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --krb4 <level>\n"
"              (FTP) Enable kerberos4 authentication and use. The level must be\n"
"              entered and should be one of 'clear', 'safe', 'confidential'  or\n"
"              'private'.  Should  you  use  a  level that is not one of these,\n"
, stdout);
 fputs(
"              'private' will instead be used.\n"
"\n"
"              This option requires that the library was built  with  kerberos4\n"
"              support.  This  is  not  very common. Use -V/--version to see if\n"
"              your curl supports it.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -K/--config <config file>\n"
"              Specify  which config file to read curl arguments from. The con-\n"
, stdout);
 fputs(
"              fig file is a text file in which command line arguments  can  be\n"
"              written  which  then will be used as if they were written on the\n"
"              actual command line. Options and their parameters must be speci-\n"
"              fied  on  the same config file line. If the parameter is to con-\n"
"              tain white spaces, the parameter must be inclosed within quotes.\n"
"              If  the  first  column  of a config line is a '#' character, the\n"
, stdout);
 fputs(
"              rest of the line will be treated as a comment.\n"
"\n"
"              Specify the filename as '-' to make  curl  read  the  file  from\n"
"              stdin.\n"
"\n"
"              Note  that  to  be able to specify a URL in the config file, you\n"
"              need to specify it using the --url option,  and  not  by  simply\n"
"              writing  the  URL  on its own line. So, it could look similar to\n"
"              this:\n"
"\n"
"              url = \"http://curl.haxx.se/docs/\"\n"
"\n"
, stdout);
 fputs(
"              This option can be used multiple times.\n"
"\n"
"              When curl is invoked, it always (unless -q is used) checks for a\n"
"              default  config  file  and  uses it if found. The default config\n"
"              file is checked for in the following places in this order:\n"
"\n"
"              1) curl tries to find the \"home dir\": It first  checks  for  the\n"
"              CURL_HOME and then the HOME environment variables. Failing that,\n"
, stdout);
 fputs(
"              it uses getpwuid() on unix-like systems (which returns the  home\n"
"              dir  given the current user in your system). On Windows, it then\n"
"              checks for the APPDATA variable, or as a last resort the '%USER-\n"
"              PROFILE%0lication Data'.\n"
"\n"
"              2)  On  windows, if there is no _curlrc file in the home dir, it\n"
"              checks for one in the same dir the executable curl is placed. On\n"
, stdout);
 fputs(
"              unix-like  systems,  it will simply try to load .curlrc from the\n"
"              determined home dir.\n"
"       --limit-rate <speed>\n"
"              Specify the maximum transfer rate you want  curl  to  use.  This\n"
"              feature is useful if you have a limited pipe and you'd like your\n"
"              transfer not use your entire bandwidth.\n"
"\n"
"              The given speed is measured in bytes/second, unless a suffix  is\n"
, stdout);
 fputs(
"              appended.   Appending  'k' or 'K' will count the number as kilo-\n"
"              bytes, 'm' or M' makes it megabytes while 'g' or  'G'  makes  it\n"
"              gigabytes. Examples: 200K, 3m and 1G.\n"
"\n"
"              If  you  are also using the -Y/--speed-limit option, that option\n"
"              will  take  precedence  and  might  cripple  the   rate-limiting\n"
"              slightly, to help keeping the speed-limit logic working.\n"
"\n"
"              This option was introduced in curl 7.10.\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -l/--list-only\n"
"              (FTP) When listing an FTP directory, this switch forces a  name-\n"
"              only  view.   Especially useful if you want to machine-parse the\n"
"              contents of an FTP directory since  the  normal  directory  view\n"
"              doesn't use a standard look or format.\n"
"\n"
"              This  option  causes  an  FTP NLST command to be sent.  Some FTP\n"
, stdout);
 fputs(
"              servers list only files in their response to NLST; they  do  not\n"
"              include subdirectories and symbolic links.\n"
"\n"
"              If this option is used twice, the second will again disable list\n"
"              only.\n"
"\n"
"       -L/--location\n"
"              (HTTP/HTTPS) If the server reports that the requested page has a\n"
"              different  location  (indicated  with the header line Location:)\n"
"              this flag will let curl attempt to reattempt the get on the  new\n"
, stdout);
 fputs(
"              place.  If used together with -i/--include or -I/--head, headers\n"
"              from all requested pages will be  shown.  If  authentication  is\n"
"              used,  curl  will only send its credentials to the initial host,\n"
"              so if a redirect takes curl to a different host, it won't inter-\n"
"              cept  the  user+password.  See also --location-trusted on how to\n"
"              change this.\n"
"\n"
, stdout);
 fputs(
"              If this option is used twice,  the  second  will  again  disable\n"
"              location following.\n"
"\n"
"       --location-trusted\n"
"              (HTTP/HTTPS) Like -L/--location, but will allow sending the name\n"
"              + password to all hosts that the site may redirect to. This  may\n"
"              or may not introduce a security breach if the site redirects you\n"
"              do a site to which you'll send your authentication  info  (which\n"
, stdout);
 fputs(
"              is plaintext in the case of HTTP Basic authentication).\n"
"\n"
"              If  this  option  is  used  twice, the second will again disable\n"
"              location following.\n"
"\n"
"       --max-filesize <bytes>\n"
"              Specify the maximum size (in bytes) of a file  to  download.  If\n"
"              the  file requested is larger than this value, the transfer will\n"
"              not start and curl will return with exit code 63.\n"
"\n"
, stdout);
 fputs(
"              NOTE: The file size is not always known prior to  download,  and\n"
"              for such files this option has no effect even if the file trans-\n"
"              fer ends up being larger than this given  limit.  This  concerns\n"
"              both FTP and HTTP transfers.\n"
"\n"
"       -m/--max-time <seconds>\n"
"              Maximum  time  in  seconds that you allow the whole operation to\n"
"              take.  This is useful for preventing your batch jobs from  hang-\n"
, stdout);
 fputs(
"              ing  for  hours  due to slow networks or links going down.  This\n"
"              doesn't work fully in win32 systems.  See  also  the  --connect-\n"
"              timeout option.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -M/--manual\n"
"              Manual. Display the huge help text.\n"
"\n"
"       -n/--netrc\n"
"              Makes curl scan the .netrc file in the user's home directory for\n"
, stdout);
 fputs(
"              login name and password. This is typically used for ftp on unix.\n"
"              If used with http, curl will  enable  user  authentication.  See\n"
"              netrc(4) or ftp(1) for details on the file format. Curl will not\n"
"              complain if that file hasn't the right  permissions  (it  should\n"
"              not  be  world  nor  group  readable).  The environment variable\n"
"              \"HOME\" is used to find the home directory.\n"
"\n"
, stdout);
 fputs(
"              A quick and very simple example of how  to  setup  a  .netrc  to\n"
"              allow  curl to ftp to the machine host.domain.com with user name\n"
"              'myself' and password\n"
"\n"
"              machine host.domain.com login myself password secret\n"
"\n"
"              If this option is used twice,  the  second  will  again  disable\n"
"              netrc usage.\n"
"\n"
"       --netrc-optional\n"
"              Very  similar to --netrc, but this option makes the .netrc usage\n"
, stdout);
 fputs(
"              optional and not mandatory as the --netrc does.\n"
"\n"
"       --negotiate\n"
"              (HTTP) Enables GSS-Negotiate authentication.  The  GSS-Negotiate\n"
"              method was designed by Microsoft and is used in their web appli-\n"
"              cations. It is  primarily  meant  as  a  support  for  Kerberos5\n"
"              authentication but may be also used along with another authenti-\n"
"              cation methods. For  more  information  see  IETF  draft  draft-\n"
, stdout);
 fputs(
"              brezak-spnego-http-04.txt. (Added in 7.10.6)\n"
"\n"
"              This option requires that the library was built with GSSAPI sup-\n"
"              port. This is not very common. Use -V/--version to see  if  your\n"
"              version supports GSS-Negotiate.\n"
"\n"
"              If  this option is used several times, the following occurrences\n"
"              make no difference.\n"
"\n"
"       -N/--no-buffer\n"
"              Disables the buffering of the output stream. In normal work sit-\n"
, stdout);
 fputs(
"              uations,  curl  will  use a standard buffered output stream that\n"
"              will have the effect that it will output the data in chunks, not\n"
"              necessarily  exactly  when  the data arrives.  Using this option\n"
"              will disable that buffering.\n"
"\n"
"              If this option is used twice, the second will  again  switch  on\n"
"              buffering.\n"
"\n"
"       --ntlm (HTTP)  Enables  NTLM  authentication.  The  NTLM authentication\n"
, stdout);
 fputs(
"              method was designed by Microsoft and is used by IIS web servers.\n"
"              It is a proprietary protocol, reversed engineered by clever peo-\n"
"              ple and implemented in curl based on their efforts. This kind of\n"
"              behavior  should  not be endorsed, you should encourage everyone\n"
"              who uses NTLM to switch to a public and  documented  authentica-\n"
"              tion method instead. Such as Digest. (Added in 7.10.6)\n"
"\n"
, stdout);
 fputs(
"              If  you  want to enable NTLM for your proxy authentication, then\n"
"              use --proxy-ntlm.\n"
"\n"
"              This option requires that the library was built  with  SSL  sup-\n"
"              port. Use -V/--version to see if your curl supports NTLM.\n"
"\n"
"              If  this option is used several times, the following occurrences\n"
"              make no difference.\n"
"\n"
"       -o/--output <file>\n"
"              Write output to <file> instead of stdout. If you are using {} or\n"
, stdout);
 fputs(
"              []  to  fetch  multiple documents, you can use '#' followed by a\n"
"              number in the <file> specifier. That variable will  be  replaced\n"
"              with the current string for the URL being fetched. Like in:\n"
"\n"
"                curl http://{one,two}.site.com -o \"file_#1.txt\"\n"
"\n"
"              or use several variables like:\n"
"\n"
"                curl http://{site,host}.host[1-5].com -o \"#1_#2\"\n"
"\n"
"              You  may  use  this  option  as many times as you have number of\n"
, stdout);
 fputs(
"              URLs.\n"
"\n"
"              See also the --create-dirs option to create the  local  directo-\n"
"              ries dynamically.\n"
"\n"
"       -O/--remote-name\n"
"              Write  output to a local file named like the remote file we get.\n"
"              (Only the file part of the remote file is used, the path is  cut\n"
"              off.)\n"
"\n"
"              The  remote  file  name  to use for saving is extracted from the\n"
"              given URL.  Nothing else\n"
"\n"
, stdout);
 fputs(
"              You may use this option as many times  as  you  have  number  of\n"
"              URLs.\n"
"\n"
"       --pass <phrase>\n"
"              (SSL) Pass phrase for the private key\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --proxy-anyauth\n"
"              Tells curl to pick a suitable authentication method when  commu-\n"
"              nicating  with  the  given  proxy.  This  will  cause  an  extra\n"
, stdout);
 fputs(
"              request/response round-trip. Added in curl 7.13.2.\n"
"\n"
"              If this option is used twice, the second will again disable  the\n"
"              proxy use-any authentication.\n"
"\n"
"       --proxy-basic\n"
"              Tells  curl  to use HTTP Basic authentication when communicating\n"
"              with the given proxy. Use --basic for enabling HTTP Basic with a\n"
"              remote  host.  Basic  is  the default authentication method curl\n"
"              uses with proxies.\n"
"\n"
, stdout);
 fputs(
"              If this option is used twice,  the  second  will  again  disable\n"
"              proxy HTTP Basic authentication.\n"
"\n"
"       --proxy-digest\n"
"              Tells  curl to use HTTP Digest authentication when communicating\n"
"              with the given proxy. Use --digest for enabling HTTP Digest with\n"
"              a remote host.\n"
"\n"
"              If  this  option  is  used  twice, the second will again disable\n"
"              proxy HTTP Digest.\n"
"\n"
"       --proxy-ntlm\n"
, stdout);
 fputs(
"              Tells curl to use HTTP NTLM  authentication  when  communicating\n"
"              with the given proxy. Use --ntlm for enabling NTLM with a remote\n"
"              host.\n"
"\n"
"              If this option is used twice,  the  second  will  again  disable\n"
"              proxy HTTP NTLM.\n"
"       -p/--proxytunnel\n"
"              When  an HTTP proxy is used (-x/--proxy), this option will cause\n"
"              non-HTTP protocols  to  attempt  to  tunnel  through  the  proxy\n"
, stdout);
 fputs(
"              instead  of merely using it to do HTTP-like operations. The tun-\n"
"              nel approach is made with the HTTP  proxy  CONNECT  request  and\n"
"              requires that the proxy allows direct connect to the remote port\n"
"              number curl wants to tunnel through to.\n"
"\n"
"              If this option is used twice,  the  second  will  again  disable\n"
"              proxy tunnel.\n"
"\n"
"       -P/--ftp-port <address>\n"
, stdout);
 fputs(
"              (FTP) Reverses the initiator/listener roles when connecting with\n"
"              ftp. This switch makes Curl use  the  PORT  command  instead  of\n"
"              PASV.  In  practice,  PORT  tells  the  server to connect to the\n"
"              client's specified address and port, while PASV asks the  server\n"
"              for  an  ip  address and port to connect to. <address> should be\n"
"              one of:\n"
"\n"
"              interface\n"
, stdout);
 fputs(
"                     i.e \"eth0\" to specify which interface's  IP  address  you\n"
"                     want to use  (Unix only)\n"
"\n"
"              IP address\n"
"                     i.e \"192.168.10.1\" to specify exact IP number\n"
"\n"
"              host name\n"
"                     i.e \"my.host.domain\" to specify machine\n"
"\n"
"              -      (any  single-letter string) to make it pick the machine's\n"
"                     default\n"
"\n"
"       If this option is used several times, the last one will be  used.  Dis-\n"
, stdout);
 fputs(
"       able  the  use  of PORT with --ftp-pasv. Disable the attempt to use the\n"
"       EPRT command instead of PORT by using --disable-eprt.  EPRT  is  really\n"
"       PORT++.\n"
"\n"
"       -q     If  used  as the first parameter on the command line, the curlrc\n"
"              config file will not be read and used. See the  -K/--config  for\n"
"              details on the default config file search path.\n"
"\n"
"       -Q/--quote <command>\n"
, stdout);
 fputs(
"              (FTP)  Send an arbitrary command to the remote FTP server. Quote\n"
"              commands are sent BEFORE the  transfer  is  taking  place  (just\n"
"              after  the  initial  PWD  command to be exact). To make commands\n"
"              take place after a successful transfer, prefix them with a  dash\n"
"              '-'. To make commands get sent after libcurl has changed working\n"
"              directory, just before the transfer command(s), prefix the  com-\n"
, stdout);
 fputs(
"              mand  with  '+'.  You may specify any amount of commands. If the\n"
"              server returns failure for one of the commands, the entire oper-\n"
"              ation  will  be aborted. You must send syntactically correct FTP\n"
"              commands as RFC959 defines.\n"
"\n"
"              This option can be used multiple times.\n"
"\n"
"       --random-file <file>\n"
"              (HTTPS) Specify the path name to file containing  what  will  be\n"
, stdout);
 fputs(
"              considered  as  random data. The data is used to seed the random\n"
"              engine for SSL connections.  See also the --egd-file option.\n"
"\n"
"       -r/--range <range>\n"
"              (HTTP/FTP) Retrieve a byte range (i.e a partial document) from a\n"
"              HTTP/1.1  or  FTP server. Ranges can be specified in a number of\n"
"              ways.\n"
"\n"
"              0-499     specifies the first 500 bytes\n"
"\n"
"              500-999   specifies the second 500 bytes\n"
"\n"
, stdout);
 fputs(
"              -500      specifies the last 500 bytes\n"
"\n"
"              9500      specifies the bytes from offset 9500 and forward\n"
"\n"
"              0-0,-1    specifies the first and last byte only(*)(H)\n"
"\n"
"              500-700,600-799\n"
"                        specifies 300 bytes from offset 500(H)\n"
"\n"
"              100-199,500-599\n"
"                        specifies two separate 100 bytes ranges(*)(H)\n"
"\n"
"       (*) = NOTE that this will cause the server to reply  with  a  multipart\n"
"       response!\n"
"\n"
, stdout);
 fputs(
"       You  should  also  be aware that many HTTP/1.1 servers do not have this\n"
"       feature enabled, so that when  you  attempt  to  get  a  range,  you'll\n"
"       instead get the whole document.\n"
"\n"
"       FTP  range  downloads  only  support  the  simple  syntax  'start-stop'\n"
"       (optionally with one of the numbers omitted). It depends on the non-RFC\n"
"       command SIZE.\n"
"\n"
"       If this option is used several times, the last one will be used.\n"
"\n"
"       -R/--remote-time\n"
, stdout);
 fputs(
"              When  used,  this  will  make  libcurl attempt to figure out the\n"
"              timestamp of the remote file, and if that is available make  the\n"
"              local file get that same timestamp.\n"
"\n"
"              If  this  option  is  used  twice, the second time disables this\n"
"              again.\n"
"\n"
"       --retry <num>\n"
"              If a transient error is returned when curl tries  to  perform  a\n"
"              transfer,  it  will retry this number of times before giving up.\n"
, stdout);
 fputs(
"              Setting the number to 0 makes curl do no retries (which  is  the\n"
"              default).  Transient  error  means either: a timeout, an FTP 5xx\n"
"              response code or an HTTP 5xx response code.\n"
"\n"
"              When curl is about to retry a transfer, it will first  wait  one\n"
"              second  and  then for all forthcoming retries it will double the\n"
"              waiting time until it reaches 10 minutes which then will be  the\n"
, stdout);
 fputs(
"              delay  between  the rest of the retries.  By using --retry-delay\n"
"              you  disable  this  exponential  backoff  algorithm.  See   also\n"
"              --retry-max-time  to  limit  the total time allowed for retries.\n"
"              (Option added in 7.12.3)\n"
"\n"
"              If this option is  used  multiple  times,  the  last  occurrence\n"
"              decide the amount.\n"
"\n"
"       --retry-delay <seconds>\n"
"              Make  curl  sleep  this amount of time between each retry when a\n"
, stdout);
 fputs(
"              transfer has failed with  a  transient  error  (it  changes  the\n"
"              default  backoff time algorithm between retries). This option is\n"
"              only interesting if --retry is also used. Setting this delay  to\n"
"              zero will make curl use the default backoff time.  (Option added\n"
"              in 7.12.3)\n"
"\n"
"              If this option is  used  multiple  times,  the  last  occurrence\n"
"              decide the amount.\n"
"\n"
"       --retry-max-time <seconds>\n"
, stdout);
 fputs(
"              The  retry  timer  is  reset  before the first transfer attempt.\n"
"              Retries will be done as usual (see --retry) as long as the timer\n"
"              hasn't reached this given limit. Notice that if the timer hasn't\n"
"              reached the limit, the request will be made and  while  perform-\n"
"              ing,  it may take longer than this given time period. To limit a\n"
"              single request's maximum  time,  use  -m/--max-time.   Set  this\n"
, stdout);
 fputs(
"              option to zero to not timeout retries. (Option added in 7.12.3)\n"
"\n"
"              If  this  option  is  used  multiple  times, the last occurrence\n"
"              decide the amount.\n"
"\n"
"       -s/--silent\n"
"              Silent mode. Don't show progress meter or error messages.  Makes\n"
"              Curl mute.\n"
"\n"
"              If  this  option  is  used  twice, the second will again disable\n"
"              mute.\n"
"\n"
"       -S/--show-error\n"
, stdout);
 fputs(
"              When used with -s it makes curl show error message if it  fails.\n"
"              If this option is used twice, the second will again disable show\n"
"              error.\n"
"\n"
"       --socks <host[:port]>\n"
"              Use the specified SOCKS5 proxy. If the port number is not speci-\n"
"              fied, it is assumed at port 1080. (Option added in 7.11.1)\n"
"\n"
"              This  option  overrides  any previous use of -x/--proxy, as they\n"
"              are mutually exclusive.\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --stderr <file>\n"
"              Redirect  all writes to stderr to the specified file instead. If\n"
"              the file name is a plain '-', it is instead written  to  stdout.\n"
"              This  option  has no point when you're using a shell with decent\n"
"              redirecting capabilities.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --tcp-nodelay\n"
, stdout);
 fputs(
"              Turn  on the TCP_NODELAY option. See the curl_easy_setopt(3) man\n"
"              page for details about this option. (Added in 7.11.2)\n"
"\n"
"              If this option is used several times,  each  occurrence  toggles\n"
"              this on/off.\n"
"\n"
"       -t/--telnet-option <OPT=val>\n"
"              Pass options to the telnet protocol. Supported options are:\n"
"\n"
"              TTYPE=<term> Sets the terminal type.\n"
"\n"
"              XDISPLOC=<X display> Sets the X display location.\n"
"\n"
, stdout);
 fputs(
"              NEW_ENV=<var,val> Sets an environment variable.\n"
"\n"
"       -T/--upload-file <file>\n"
"              This  transfers  the  specified local file to the remote URL. If\n"
"              there is no file part in the specified URL, Curl will append the\n"
"              local file name. NOTE that you must use a trailing / on the last\n"
"              directory to really prove to Curl that there is no file name  or\n"
"              curl will think that your last directory name is the remote file\n"
, stdout);
 fputs(
"              name to use. That will most likely cause the upload operation to\n"
"              fail.  If this is used on a http(s) server, the PUT command will\n"
"              be used.\n"
"\n"
"              Use the file name \"-\" (a single dash) to use stdin instead of  a\n"
"              given file.\n"
"\n"
"              Before 7.10.8, when this option was used several times, the last\n"
"              one was used.\n"
"\n"
"              In curl 7.10.8 and later, you can specify one -T for each URL on\n"
, stdout);
 fputs(
"              the  command  line.  Each -T + URL pair specifies what to upload\n"
"              and to where. curl also supports \"globbing\" of the -T  argument,\n"
"              meaning  that  you  can upload multiple files to a single URL by\n"
"              using the same URL globbing style supported  in  the  URL,  like\n"
"              this:\n"
"\n"
"              curl -T \"{file1,file2}\" http://www.uploadtothissite.com\n"
"\n"
"              or even\n"
"\n"
, stdout);
 fputs(
"              curl -T \"img[1-1000].png\" ftp://ftp.picturemania.com/upload/\n"
"\n"
"       --trace <file>\n"
"              Enables  a  full  trace  dump of all incoming and outgoing data,\n"
"              including descriptive information, to the given output file. Use\n"
"              \"-\" as filename to have the output sent to stdout.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"              (Added in 7.9.7)\n"
"\n"
"       --trace-ascii <file>\n"
, stdout);
 fputs(
"              Enables a full trace dump of all  incoming  and  outgoing  data,\n"
"              including descriptive information, to the given output file. Use\n"
"              \"-\" as filename to have the output sent to stdout.\n"
"\n"
"              This is very similar to --trace, but leaves out the hex part and\n"
"              only  shows  the ASCII part of the dump. It makes smaller output\n"
"              that might be easier to read for untrained humans.\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the last one will be used.\n"
"              (Added in 7.9.7)\n"
"\n"
"       --trace-time\n"
"              Prepends  a  time  stamp to each trace or verbose line that curl\n"
"              displays.\n"
"\n"
"              If this option is used several times, each occurrence will  tog-\n"
"              gle it on/off.  (Added in 7.14.0        )\n"
"\n"
"       -u/--user <user:password>\n"
"              Specify  user  and  password  to  use for server authentication.\n"
, stdout);
 fputs(
"              Overrides -n/--netrc and --netrc-optional.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -U/--proxy-user <user:password>\n"
"              Specify user and password to use for proxy authentication.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --url <URL>\n"
"              Specify a URL to fetch. This option is  mostly  handy  when  you\n"
"              want to specify URL(s) in a config file.\n"
"\n"
, stdout);
 fputs(
"              This  option  may  be used any number of times. To control where\n"
"              this URL is written, use the -o/--output or the -O/--remote-name\n"
"              options.\n"
"\n"
"       -v/--verbose\n"
"              Makes  the  fetching  more  verbose/talkative. Mostly usable for\n"
"              debugging. Lines starting with '>' means \"header data\"  sent  by\n"
"              curl, '<' means \"header data\" received by curl that is hidden in\n"
, stdout);
 fputs(
"              normal cases and lines starting with '*' means  additional  info\n"
"              provided by curl.\n"
"\n"
"              Note  that  if  you  only  want  HTTP  headers  in  the  output,\n"
"              -i/--include might be option you're looking for.\n"
"\n"
"              If you think this option still doesn't give you enough  details,\n"
"              consider using --trace or --trace-ascii instead.\n"
"\n"
"              If this option is used twice, the second will again disable ver-\n"
"              bose.\n"
"\n"
, stdout);
 fputs(
"       -V/--version\n"
"              Displays information about curl and the libcurl version it uses.\n"
"              The  first  line  includes the full version of curl, libcurl and\n"
"              other 3rd party libraries linked with the executable.\n"
"\n"
"              The second line (starts with \"Protocols:\") shows  all  protocols\n"
"              that libcurl reports to support.\n"
"\n"
"              The third line (starts with \"Features:\") shows specific features\n"
, stdout);
 fputs(
"              libcurl reports to offer. Available features include:\n"
"\n"
"              IPv6   You can use IPv6 with this.\n"
"\n"
"              krb4   Krb4 for ftp is supported.\n"
"\n"
"              SSL    HTTPS and FTPS are supported.\n"
"\n"
"              libz   Automatic decompression of compressed files over HTTP  is\n"
"                     supported.\n"
"\n"
"              NTLM   NTLM authentication is supported.\n"
"\n"
"              GSS-Negotiate\n"
"                     Negotiate authentication is supported.\n"
"\n"
, stdout);
 fputs(
"              Debug  This  curl  uses a libcurl built with Debug. This enables\n"
"                     more error-tracking and memory debugging etc.  For  curl-\n"
"                     developers only!\n"
"\n"
"              AsynchDNS\n"
"                     This curl uses asynchronous name resolves.\n"
"\n"
"              SPNEGO SPNEGO Negotiate authentication is supported.\n"
"\n"
"              Largefile\n"
"                     This curl supports transfers of large files, files larger\n"
"                     than 2GB.\n"
"\n"
, stdout);
 fputs(
"              IDN    This curl supports IDN - international domain names.\n"
"\n"
"              SSPI   SSPI is supported. If you use NTLM and set a  blank  user\n"
"                     name,  curl  will authenticate with your current user and\n"
"                     password.\n"
"\n"
"       -w/--write-out <format>\n"
"              Defines what to display after a completed and successful  opera-\n"
"              tion.  The  format is a string that may contain plain text mixed\n"
, stdout);
 fputs(
"              with any number of variables. The string  can  be  specified  as\n"
"              \"string\",  to  get  read  from  a particular file you specify it\n"
"              \"@filename\" and to tell curl to read the format from  stdin  you\n"
"              write \"@-\".\n"
"\n"
"              The  variables  present in the output format will be substituted\n"
"              by the value or text that curl thinks fit, as  described  below.\n"
, stdout);
 fputs(
"              All  variables are specified like %{variable_name} and to output\n"
"              a normal % you just write them like %%. You can output a newline\n"
"              by  using \\n, a carriage return with \\r and a tab space with \\t.\n"
"              NOTE: The %-letter is a special letter in the win32-environment,\n"
"              where  all  occurrences  of  %  must  be doubled when using this\n"
"              option.\n"
"\n"
"              Available variables are at this point:\n"
"\n"
, stdout);
 fputs(
"              url_effective  The URL that was fetched  last.  This  is  mostly\n"
"                             meaningful  if  you've  told curl to follow loca-\n"
"                             tion: headers.\n"
"\n"
"              http_code      The numerical code that was  found  in  the  last\n"
"                             retrieved HTTP(S) page.\n"
"\n"
"              http_connect   The  numerical  code  that  was found in the last\n"
"                             response  (from  a  proxy)  to  a  curl   CONNECT\n"
, stdout);
 fputs(
"                             request. (Added in 7.12.4)\n"
"\n"
"              time_total     The  total time, in seconds, that the full opera-\n"
"                             tion lasted. The time will be displayed with mil-\n"
"                             lisecond resolution.\n"
"\n"
"              time_namelookup\n"
"                             The  time,  in  seconds,  it  took from the start\n"
"                             until the name resolving was completed.\n"
"\n"
, stdout);
 fputs(
"              time_connect   The time, in seconds,  it  took  from  the  start\n"
"                             until  the  connect to the remote host (or proxy)\n"
"                             was completed.\n"
"\n"
"              time_pretransfer\n"
"                             The time, in seconds,  it  took  from  the  start\n"
"                             until  the  file transfer is just about to begin.\n"
"                             This includes all pre-transfer commands and nego-\n"
, stdout);
 fputs(
"                             tiations that are specific to the particular pro-\n"
"                             tocol(s) involved.\n"
"\n"
"              time_redirect  The time, in seconds, it took for all redirection\n"
"                             steps  include  name lookup, connect, pretransfer\n"
"                             and  transfer  before   final   transaction   was\n"
"                             started.  time_redirect shows the complete execu-\n"
, stdout);
 fputs(
"                             tion time for multiple  redirections.  (Added  in\n"
"                             7.12.3)\n"
"\n"
"              time_starttransfer\n"
"                             The  time,  in  seconds,  it  took from the start\n"
"                             until the first byte is just about to  be  trans-\n"
"                             ferred.  This  includes time_pretransfer and also\n"
"                             the  time  the  server  needs  to  calculate  the\n"
, stdout);
 fputs(
"                             result.\n"
"\n"
"              size_download  The total amount of bytes that were downloaded.\n"
"\n"
"              size_upload    The total amount of bytes that were uploaded.\n"
"\n"
"              size_header    The total amount of bytes of the downloaded head-\n"
"                             ers.\n"
"\n"
"              size_request   The total amount of bytes that were sent  in  the\n"
"                             HTTP request.\n"
"\n"
, stdout);
 fputs(
"              speed_download The average download speed that curl measured for\n"
"                             the complete download.\n"
"\n"
"              speed_upload   The average upload speed that curl  measured  for\n"
"                             the complete upload.\n"
"\n"
"              content_type   The  Content-Type  of  the requested document, if\n"
"                             there was any. (Added in 7.9.5)\n"
"\n"
"              num_connects   Number of new connects made in the recent  trans-\n"
, stdout);
 fputs(
"                             fer. (Added in 7.12.3)\n"
"\n"
"              num_redirects  Number  of  redirects  that  were followed in the\n"
"                             request. (Added in 7.12.3)\n"
"\n"
"       If this option is used several times, the last one will be used.\n"
"\n"
"       -x/--proxy <proxyhost[:port]>\n"
"              Use specified HTTP proxy. If the port number is  not  specified,\n"
"              it is assumed at port 1080.\n"
"\n"
"              This  option  overrides existing environment variables that sets\n"
, stdout);
 fputs(
"              proxy to use. If  there's  an  environment  variable  setting  a\n"
"              proxy, you can set proxy to \"\" to override it.\n"
"\n"
"              Note  that  all  operations that are performed over a HTTP proxy\n"
"              will transparently be converted to HTTP. It means  that  certain\n"
"              protocol specific operations might not be available. This is not\n"
"              the case if you can tunnel through the proxy, as done  with  the\n"
"              -p/--proxytunnel option.\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -X/--request <command>\n"
"              (HTTP) Specifies a custom request to use when communicating with\n"
"              the  HTTP server.  The specified request will be used instead of\n"
"              the standard GET. Read the HTTP 1.1  specification  for  details\n"
"              and explanations.\n"
"\n"
"              (FTP) Specifies a custom FTP command to use instead of LIST when\n"
"              doing file lists with ftp.\n"
, stdout);
 fputs(
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -y/--speed-time <time>\n"
"              If a download is slower than speed-limit bytes per second during\n"
"              a speed-time period, the download gets aborted. If speed-time is\n"
"              used, the default speed-limit will be 1 unless set with -y.\n"
"\n"
"              This  option  controls  transfers  and thus will not affect slow\n"
, stdout);
 fputs(
"              connects etc. If this is a concern for you, try  the  --connect-\n"
"              timeout option.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -Y/--speed-limit <speed>\n"
"              If a download is slower than this given speed, in bytes per sec-\n"
"              ond,  for  speed-time seconds it gets aborted. speed-time is set\n"
"              with -Y and is 30 if not set.\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -z/--time-cond <date expression>\n"
"              (HTTP)  Request  a  file  that  has been modified later than the\n"
"              given time and date, or one that has been modified  before  that\n"
"              time. The date expression can be all sorts of date strings or if\n"
"              it doesn't match any internal ones, it tries  to  get  the  time\n"
, stdout);
 fputs(
"              from  a  given  file  name  instead! See the curl_getdate(3) man\n"
"              pages for date expression details.\n"
"\n"
"              Start the date expression with a dash (-) to make it request for\n"
"              a  document that is older than the given date/time, default is a\n"
"              document that is newer than the specified date/time.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --max-redirs <num>\n"
, stdout);
 fputs(
"              Set   maximum   number  of  redirection-followings  allowed.  If\n"
"              -L/--location is used, this option can be used to  prevent  curl\n"
"              from following redirections \"in absurdum\".\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -0/--http1.0\n"
"              (HTTP) Forces curl to issue its requests using HTTP 1.0  instead\n"
"              of using its internally preferred: HTTP 1.1.\n"
"\n"
"       -1/--tlsv1\n"
, stdout);
 fputs(
"              (HTTPS) Forces curl to use TSL version 1 when negotiating with a\n"
"              remote TLS server.\n"
"\n"
"       -2/--sslv2\n"
"              (HTTPS) Forces curl to use SSL version 2 when negotiating with a\n"
"              remote SSL server.\n"
"\n"
"       -3/--sslv3\n"
"              (HTTPS) Forces curl to use SSL version 3 when negotiating with a\n"
"              remote SSL server.\n"
"\n"
"       --3p-quote\n"
"              (FTP) Specify arbitrary commands to send to the  source  server.\n"
, stdout);
 fputs(
"              See the -Q/--quote option for details. (Added in 7.13.0)\n"
"\n"
"       --3p-url\n"
"              (FTP)  Activates  a FTP 3rd party transfer. Specifies the source\n"
"              URL to get a file from, while the \"normal\" URL will be  used  as\n"
"              target URL, the file that will be written/created.\n"
"\n"
"              Note  that  not all FTP server allow 3rd party transfers. (Added\n"
"              in 7.13.0)\n"
"\n"
"       --3p-user\n"
, stdout);
 fputs(
"              (FTP) Specify user:password for the source URL transfer.  (Added\n"
"              in 7.13.0)\n"
"\n"
"       -4/--ipv4\n"
"              If  libcurl  is  capable  of resolving an address to multiple IP\n"
"              versions (which it is if it is ipv6-capable), this option  tells\n"
"              libcurl  to  resolve  names  to  IPv4  addresses only. (Added in\n"
"              7.10.8)\n"
"\n"
"       -6/--ipv6\n"
"              If libcurl is capable of resolving an  address  to  multiple  IP\n"
, stdout);
 fputs(
"              versions  (which it is if it is ipv6-capable), this option tells\n"
"              libcurl to resolve names  to  IPv6  addresses  only.  (Added  in\n"
"              7.10.8)\n"
"\n"
"       -#/--progress-bar\n"
"              Make curl display progress information as a progress bar instead\n"
"              of the default statistics.\n"
"\n"
"              If this option is used twice, the second will again disable  the\n"
"              progress bar.\n"
"\n"
"FILES\n"
"       ~/.curlrc\n"
"              Default config file.\n"
"\n"
, stdout);
 fputs(
"ENVIRONMENT\n"
"       http_proxy [protocol://]<host>[:port]\n"
"              Sets proxy server to use for HTTP.\n"
"\n"
"       HTTPS_PROXY [protocol://]<host>[:port]\n"
"              Sets proxy server to use for HTTPS.\n"
"\n"
"       FTP_PROXY [protocol://]<host>[:port]\n"
"              Sets proxy server to use for FTP.\n"
"\n"
"       GOPHER_PROXY [protocol://]<host>[:port]\n"
"              Sets proxy server to use for GOPHER.\n"
"       ALL_PROXY [protocol://]<host>[:port]\n"
, stdout);
 fputs(
"              Sets proxy server to use if no protocol-specific proxy is set.\n"
"\n"
"       NO_PROXY <comma-separated list of hosts>\n"
"              list  of  host names that shouldn't go through any proxy. If set\n"
"              to a asterisk\n"
"\n"
"EXIT CODES\n"
"       There exists a bunch of different error codes and  their  corresponding\n"
"       error  messages  that  may appear during bad conditions. At the time of\n"
"       this writing, the exit codes are:\n"
"\n"
, stdout);
 fputs(
"       1      Unsupported protocol. This build of curl has no support for this\n"
"              protocol.\n"
"\n"
"       2      Failed to initialize.\n"
"\n"
"       3      URL malformat. The syntax was not correct.\n"
"\n"
"       4      URL  user  malformatted. The user-part of the URL syntax was not\n"
"              correct.\n"
"\n"
"       5      Couldn't resolve proxy.  The  given  proxy  host  could  not  be\n"
"              resolved.\n"
"\n"
"       6      Couldn't resolve host. The given remote host was not resolved.\n"
"\n"
, stdout);
 fputs(
"       7      Failed to connect to host.\n"
"\n"
"       8      FTP  weird  server  reply.  The  server  sent data curl couldn't\n"
"              parse.\n"
"\n"
"       9      FTP access denied. The server denied login.\n"
"\n"
"       10     FTP  user/password  incorrect.  Either  one  or  both  were  not\n"
"              accepted by the server.\n"
"\n"
"       11     FTP  weird PASS reply. Curl couldn't parse the reply sent to the\n"
"              PASS request.\n"
"\n"
, stdout);
 fputs(
"       12     FTP weird USER reply. Curl couldn't parse the reply sent to  the\n"
"              USER request.\n"
"\n"
"       13     FTP  weird PASV reply, Curl couldn't parse the reply sent to the\n"
"              PASV request.\n"
"\n"
"       14     FTP weird 227 format.  Curl  couldn't  parse  the  227-line  the\n"
"              server sent.\n"
"\n"
"       15     FTP  can't  get host. Couldn't resolve the host IP we got in the\n"
"              227-line.\n"
"\n"
, stdout);
 fputs(
"       16     FTP can't reconnect. Couldn't connect to the host we got in  the\n"
"              227-line.\n"
"\n"
"       17     FTP  couldn't  set  binary.  Couldn't  change transfer method to\n"
"              binary.\n"
"\n"
"       18     Partial file. Only a part of the file was transferred.\n"
"\n"
"       19     FTP couldn't download/access the given file, the RETR (or  simi-\n"
"              lar) command failed.\n"
"\n"
"       20     FTP write error. The transfer was reported bad by the server.\n"
"\n"
, stdout);
 fputs(
"       21     FTP quote error. A quote command returned error from the server.\n"
"       22     HTTP page not retrieved. The requested  url  was  not  found  or\n"
"              returned  another  error  with  the HTTP error code being 400 or\n"
"              above. This return code only appears if -f/--fail is used.\n"
"\n"
"       23     Write error. Curl couldn't write data to a local  filesystem  or\n"
"              similar.\n"
"\n"
"       24     Malformed user. User name badly specified.\n"
"\n"
, stdout);
 fputs(
"       25     FTP  couldn't  STOR  file. The server denied the STOR operation,\n"
"              used for FTP uploading.\n"
"\n"
"       26     Read error. Various reading problems.\n"
"\n"
"       27     Out of memory. A memory allocation request failed.\n"
"\n"
"       28     Operation timeout. The specified  time-out  period  was  reached\n"
"              according to the conditions.\n"
"\n"
"       29     FTP couldn't set ASCII. The server returned an unknown reply.\n"
"\n"
, stdout);
 fputs(
"       30     FTP  PORT  failed.  The PORT command failed. Not all FTP servers\n"
"              support the PORT  command,  try  doing  a  transfer  using  PASV\n"
"              instead!\n"
"\n"
"       31     FTP  couldn't use REST. The REST command failed. This command is\n"
"              used for resumed FTP transfers.\n"
"\n"
"       32     FTP couldn't use SIZE. The SIZE command failed. The  command  is\n"
"              an extension to the original FTP spec RFC 959.\n"
"\n"
, stdout);
 fputs(
"       33     HTTP range error. The range \"command\" didn't work.\n"
"\n"
"       34     HTTP post error. Internal post-request generation error.\n"
"\n"
"       35     SSL connect error. The SSL handshaking failed.\n"
"\n"
"       36     FTP  bad  download  resume. Couldn't continue an earlier aborted\n"
"              download.\n"
"\n"
"       37     FILE couldn't read file. Failed to open the file. Permissions?\n"
"\n"
"       38     LDAP cannot bind. LDAP bind operation failed.\n"
"\n"
"       39     LDAP search failed.\n"
"\n"
, stdout);
 fputs(
"       40     Library not found. The LDAP library was not found.\n"
"\n"
"       41     Function not found. A required LDAP function was not found.\n"
"\n"
"       42     Aborted by callback. An application told curl to abort the oper-\n"
"              ation.\n"
"\n"
"       43     Internal error. A function was called with a bad parameter.\n"
"\n"
"       44     Internal error. A function was called in a bad order.\n"
"\n"
"       45     Interface  error.  A  specified  outgoing interface could not be\n"
"              used.\n"
"\n"
, stdout);
 fputs(
"       46     Bad password entered. An error was signaled  when  the  password\n"
"              was entered.\n"
"\n"
"       47     Too many redirects. When following redirects, curl hit the maxi-\n"
"              mum amount.\n"
"\n"
"       48     Unknown TELNET option specified.\n"
"\n"
"       49     Malformed telnet option.\n"
"\n"
"       51     The remote peer's SSL certificate wasn't ok\n"
"\n"
"       52     The server didn't reply anything, which here  is  considered  an\n"
"              error.\n"
"\n"
, stdout);
 fputs(
"       53     SSL crypto engine not found\n"
"\n"
"       54     Cannot set SSL crypto engine as default\n"
"\n"
"       55     Failed sending network data\n"
"\n"
"       56     Failure in receiving network data\n"
"\n"
"       57     Share is in use (internal error)\n"
"\n"
"       58     Problem with the local certificate\n"
"\n"
"       59     Couldn't use specified SSL cipher\n"
"\n"
"       60     Problem with the CA cert (path? permission?)\n"
"\n"
"       61     Unrecognized transfer encoding\n"
"\n"
"       62     Invalid LDAP URL\n"
"\n"
, stdout);
 fputs(
"       63     Maximum file size exceeded\n"
"\n"
"       XX     There  will appear more error codes here in future releases. The\n"
"              existing ones are meant to never change.\n"
"\n"
"AUTHORS / CONTRIBUTORS\n"
"       Daniel Stenberg is the main author, but the whole list of  contributors\n"
"       is found in the separate THANKS file.\n"
"\n"
"WWW\n"
"       http://curl.haxx.se\n"
"\n"
"FTP\n"
"       ftp://ftp.sunet.se/pub/www/utilities/curl/\n"
"\n"
"SEE ALSO\n"
"       ftp(1), wget(1)\n"
"\n"
"LATEST VERSION\n"
"\n"
, stdout);
 fputs(
"  You always find news about what's going on as well as the latest versions\n"
"  from the curl web pages, located at:\n"
"\n"
"        http://curl.haxx.se\n"
"\n"
"SIMPLE USAGE\n"
"\n"
"  Get the main page from netscape's web-server:\n"
"\n"
"        curl http://www.netscape.com/\n"
"\n"
"  Get the README file the user's home directory at funet's ftp-server:\n"
"\n"
"        curl ftp://ftp.funet.fi/README\n"
"\n"
"  Get a web page from a server using port 8000:\n"
"\n"
"        curl http://www.weirdserver.com:8000/\n"
"\n"
"  Get a list of a directory of an FTP site:\n"
"\n"
, stdout);
 fputs(
"        curl ftp://cool.haxx.se/\n"
"\n"
"  Get a gopher document from funet's gopher server:\n"
"\n"
"        curl gopher://gopher.funet.fi\n"
"\n"
"  Get the definition of curl from a dictionary:\n"
"\n"
"        curl dict://dict.org/m:curl\n"
"\n"
"  Fetch two documents at once:\n"
"\n"
"        curl ftp://cool.haxx.se/ http://www.weirdserver.com:8000/\n"
"\n"
"DOWNLOAD TO A FILE\n"
"\n"
"  Get a web page and store in a local file:\n"
"\n"
"        curl -o thatpage.html http://www.netscape.com/\n"
"\n"
, stdout);
 fputs(
"  Get a web page and store in a local file, make the local file get the name\n"
"  of the remote document (if no file name part is specified in the URL, this\n"
"  will fail):\n"
"\n"
"        curl -O http://www.netscape.com/index.html\n"
"\n"
"  Fetch two files and store them with their remote names:\n"
"\n"
"        curl -O www.haxx.se/index.html -O curl.haxx.se/download.html\n"
"\n"
"USING PASSWORDS\n"
"\n"
" FTP\n"
"\n"
"   To ftp files using name+passwd, include them in the URL like:\n"
"\n"
, stdout);
 fputs(
"        curl ftp://name:passwd@machine.domain:port/full/path/to/file\n"
"\n"
"   or specify them with the -u flag like\n"
"\n"
"        curl -u name:passwd ftp://machine.domain:port/full/path/to/file\n"
"\n"
" FTPS\n"
"\n"
"   It is just like for FTP, but you may also want to specify and use\n"
"   SSL-specific options for certificates etc.\n"
"\n"
" HTTP\n"
"\n"
"   The HTTP URL doesn't support user and password in the URL string. Curl\n"
"   does support that anyway to provide a ftp-style interface and thus you can\n"
"   pick a file like:\n"
"\n"
, stdout);
 fputs(
"        curl http://name:passwd@machine.domain/full/path/to/file\n"
"\n"
"   or specify user and password separately like in\n"
"\n"
"        curl -u name:passwd http://machine.domain/full/path/to/file\n"
"\n"
"   HTTP offers many different methods of authentication and curl supports\n"
"   several: Basic, Digest, NTLM and Negotiate. Without telling which method to\n"
"   use, curl defaults to Basic. You can also ask curl to pick the most secure\n"
"   ones out of the ones that the server accepts for the given URL, by using\n"
, stdout);
 fputs(
"   --anyauth.\n"
"\n"
"   NOTE! Since HTTP URLs don't support user and password, you can't use that\n"
"   style when using Curl via a proxy. You _must_ use the -u style fetch\n"
"   during such circumstances.\n"
"\n"
" HTTPS\n"
"\n"
"   Probably most commonly used with private certificates, as explained below.\n"
"\n"
" GOPHER\n"
"\n"
"   Curl features no password support for gopher.\n"
"\n"
"PROXY\n"
"\n"
" Get an ftp file using a proxy named my-proxy that uses port 888:\n"
"\n"
"        curl -x my-proxy:888 ftp://ftp.leachsite.com/README\n"
"\n"
, stdout);
 fputs(
" Get a file from a HTTP server that requires user and password, using the\n"
" same proxy as above:\n"
"\n"
"        curl -u user:passwd -x my-proxy:888 http://www.get.this/\n"
"\n"
" Some proxies require special authentication. Specify by using -U as above:\n"
"\n"
"        curl -U user:passwd -x my-proxy:888 http://www.get.this/\n"
"\n"
" See also the environment variables Curl support that offer further proxy\n"
" control.\n"
"\n"
"RANGES\n"
"\n"
"  With HTTP 1.1 byte-ranges were introduced. Using this, a client can request\n"
, stdout);
 fputs(
"  to get only one or more subparts of a specified document. Curl supports\n"
"  this with the -r flag.\n"
"\n"
"  Get the first 100 bytes of a document:\n"
"\n"
"        curl -r 0-99 http://www.get.this/\n"
"\n"
"  Get the last 500 bytes of a document:\n"
"\n"
"        curl -r -500 http://www.get.this/\n"
"\n"
"  Curl also supports simple ranges for FTP files as well. Then you can only\n"
"  specify start and stop position.\n"
"\n"
"  Get the first 100 bytes of a document using FTP:\n"
"\n"
"        curl -r 0-99 ftp://www.get.this/README  \n"
"\n"
"UPLOADING\n"
"\n"
" FTP\n"
"\n"
, stdout);
 fputs(
"  Upload all data on stdin to a specified ftp site:\n"
"\n"
"        curl -T - ftp://ftp.upload.com/myfile\n"
"\n"
"  Upload data from a specified file, login with user and password:\n"
"\n"
"        curl -T uploadfile -u user:passwd ftp://ftp.upload.com/myfile\n"
"\n"
"  Upload a local file to the remote site, and use the local file name remote\n"
"  too:\n"
" \n"
"        curl -T uploadfile -u user:passwd ftp://ftp.upload.com/\n"
"\n"
"  Upload a local file to get appended to the remote file using ftp:\n"
"\n"
, stdout);
 fputs(
"        curl -T localfile -a ftp://ftp.upload.com/remotefile\n"
"\n"
"  Curl also supports ftp upload through a proxy, but only if the proxy is\n"
"  configured to allow that kind of tunneling. If it does, you can run curl in\n"
"  a fashion similar to:\n"
"\n"
"        curl --proxytunnel -x proxy:port -T localfile ftp.upload.com\n"
"\n"
" HTTP\n"
"\n"
"  Upload all data on stdin to a specified http site:\n"
"\n"
"        curl -T - http://www.upload.com/myfile\n"
"\n"
"  Note that the http server must have been configured to accept PUT before\n"
, stdout);
 fputs(
"  this can be done successfully.\n"
"\n"
"  For other ways to do http data upload, see the POST section below.\n"
"\n"
"VERBOSE / DEBUG\n"
"\n"
"  If curl fails where it isn't supposed to, if the servers don't let you in,\n"
"  if you can't understand the responses: use the -v flag to get verbose\n"
"  fetching. Curl will output lots of info and what it sends and receives in\n"
"  order to let the user see all client-server interaction (but it won't show\n"
"  you the actual data).\n"
"\n"
"        curl -v ftp://ftp.upload.com/\n"
"\n"
, stdout);
 fputs(
"  To get even more details and information on what curl does, try using the\n"
"  --trace or --trace-ascii options with a given file name to log to, like\n"
"  this:\n"
"\n"
"        curl --trace trace.txt www.haxx.se\n"
" \n"
"\n"
"DETAILED INFORMATION\n"
"\n"
"  Different protocols provide different ways of getting detailed information\n"
"  about specific files/documents. To get curl to show detailed information\n"
"  about a single file, you should use -I/--head option. It displays all\n"
, stdout);
 fputs(
"  available info on a single file for HTTP and FTP. The HTTP information is a\n"
"  lot more extensive.\n"
"\n"
"  For HTTP, you can get the header information (the same as -I would show)\n"
"  shown before the data by using -i/--include. Curl understands the\n"
"  -D/--dump-header option when getting files from both FTP and HTTP, and it\n"
"  will then store the headers in the specified file.\n"
"\n"
"  Store the HTTP headers in a separate file (headers.txt in the example):\n"
"\n"
, stdout);
 fputs(
"        curl --dump-header headers.txt curl.haxx.se\n"
"\n"
"  Note that headers stored in a separate file can be very useful at a later\n"
"  time if you want curl to use cookies sent by the server. More about that in\n"
"  the cookies section.\n"
"\n"
"POST (HTTP)\n"
"\n"
"  It's easy to post data using curl. This is done using the -d <data>\n"
"  option.  The post data must be urlencoded.\n"
"\n"
"  Post a simple \"name\" and \"phone\" guestbook.\n"
"\n"
"        curl -d \"name=Rafael%20Sagula&phone=3320780\" \\\n"
, stdout);
 fputs(
"                http://www.where.com/guest.cgi\n"
"\n"
"  How to post a form with curl, lesson #1:\n"
"\n"
"  Dig out all the <input> tags in the form that you want to fill in. (There's\n"
"  a perl program called formfind.pl on the curl site that helps with this).\n"
"\n"
"  If there's a \"normal\" post, you use -d to post. -d takes a full \"post\n"
"  string\", which is in the format\n"
"\n"
"        <variable1>=<data1>&<variable2>=<data2>&...\n"
"\n"
"  The 'variable' names are the names set with \"name=\" in the <input> tags, and\n"
, stdout);
 fputs(
"  the data is the contents you want to fill in for the inputs. The data *must*\n"
"  be properly URL encoded. That means you replace space with + and that you\n"
"  write weird letters with %XX where XX is the hexadecimal representation of\n"
"  the letter's ASCII code.\n"
"\n"
"  Example:\n"
"\n"
"  (page located at http://www.formpost.com/getthis/\n"
"\n"
"        <form action=\"post.cgi\" method=\"post\">\n"
"        <input name=user size=10>\n"
"        <input name=pass type=password size=10>\n"
, stdout);
 fputs(
"        <input name=id type=hidden value=\"blablabla\">\n"
"        <input name=ding value=\"submit\">\n"
"        </form>\n"
"\n"
"  We want to enter user 'foobar' with password '12345'.\n"
"\n"
"  To post to this, you enter a curl command line like:\n"
"\n"
"        curl -d \"user=foobar&pass=12345&id=blablabla&ding=submit\"  (continues)\n"
"          http://www.formpost.com/getthis/post.cgi\n"
"\n"
"\n"
"  While -d uses the application/x-www-form-urlencoded mime-type, generally\n"
, stdout);
 fputs(
"  understood by CGI's and similar, curl also supports the more capable\n"
"  multipart/form-data type. This latter type supports things like file upload.\n"
"\n"
"  -F accepts parameters like -F \"name=contents\". If you want the contents to\n"
"  be read from a file, use <@filename> as contents. When specifying a file,\n"
"  you can also specify the file content type by appending ';type=<mime type>'\n"
"  to the file name. You can also post the contents of several files in one\n"
, stdout);
 fputs(
"  field.  For example, the field name 'coolfiles' is used to send three files,\n"
"  with different content types using the following syntax:\n"
"\n"
"        curl -F \"coolfiles=@fil1.gif;type=image/gif,fil2.txt,fil3.html\" \\\n"
"        http://www.post.com/postit.cgi\n"
"\n"
"  If the content-type is not specified, curl will try to guess from the file\n"
"  extension (it only knows a few), or use the previously specified type (from\n"
"  an earlier file if several files are specified in a list) or else it will\n"
, stdout);
 fputs(
"  using the default type 'text/plain'.\n"
"\n"
"  Emulate a fill-in form with -F. Let's say you fill in three fields in a\n"
"  form. One field is a file name which to post, one field is your name and one\n"
"  field is a file description. We want to post the file we have written named\n"
"  \"cooltext.txt\". To let curl do the posting of this data instead of your\n"
"  favourite browser, you have to read the HTML source of the form page and\n"
"  find the names of the input fields. In our example, the input field names\n"
, stdout);
 fputs(
"  are 'file', 'yourname' and 'filedescription'.\n"
"\n"
"        curl -F \"file=@cooltext.txt\" -F \"yourname=Daniel\" \\\n"
"             -F \"filedescription=Cool text file with cool text inside\" \\\n"
"             http://www.post.com/postit.cgi\n"
"\n"
"  To send two files in one post you can do it in two ways:\n"
"\n"
"  1. Send multiple files in a single \"field\" with a single field name:\n"
" \n"
"        curl -F \"pictures=@dog.gif,cat.gif\" \n"
" \n"
"  2. Send two fields with two field names: \n"
"\n"
, stdout);
 fputs(
"        curl -F \"docpicture=@dog.gif\" -F \"catpicture=@cat.gif\" \n"
"\n"
"  To send a field value literally without interpreting a leading '@'\n"
"  or '<', or an embedded ';type=', use --form-string instead of\n"
"  -F. This is recommended when the value is obtained from a user or\n"
"  some other unpredictable source. Under these circumstances, using\n"
"  -F instead of --form-string would allow a user to trick curl into\n"
"  uploading a file.\n"
"\n"
"REFERRER\n"
"\n"
, stdout);
 fputs(
"  A HTTP request has the option to include information about which address\n"
"  that referred to actual page.  Curl allows you to specify the\n"
"  referrer to be used on the command line. It is especially useful to\n"
"  fool or trick stupid servers or CGI scripts that rely on that information\n"
"  being available or contain certain data.\n"
"\n"
"        curl -e www.coolsite.com http://www.showme.com/\n"
"\n"
"  NOTE: The referer field is defined in the HTTP spec to be a full URL.\n"
"\n"
"USER AGENT\n"
"\n"
, stdout);
 fputs(
"  A HTTP request has the option to include information about the browser\n"
"  that generated the request. Curl allows it to be specified on the command\n"
"  line. It is especially useful to fool or trick stupid servers or CGI\n"
"  scripts that only accept certain browsers.\n"
"\n"
"  Example:\n"
"\n"
"  curl -A 'Mozilla/3.0 (Win95; I)' http://www.nationsbank.com/\n"
"\n"
"  Other common strings:\n"
"    'Mozilla/3.0 (Win95; I)'     Netscape Version 3 for Windows 95\n"
"    'Mozilla/3.04 (Win95; U)'    Netscape Version 3 for Windows 95\n"
, stdout);
 fputs(
"    'Mozilla/2.02 (OS/2; U)'     Netscape Version 2 for OS/2\n"
"    'Mozilla/4.04 [en] (X11; U; AIX 4.2; Nav)'           NS for AIX\n"
"    'Mozilla/4.05 [en] (X11; U; Linux 2.0.32 i586)'      NS for Linux\n"
"\n"
"  Note that Internet Explorer tries hard to be compatible in every way:\n"
"    'Mozilla/4.0 (compatible; MSIE 4.01; Windows 95)'    MSIE for W95\n"
"\n"
"  Mozilla is not the only possible User-Agent name:\n"
"    'Konqueror/1.0'             KDE File Manager desktop client\n"
, stdout);
 fputs(
"    'Lynx/2.7.1 libwww-FM/2.14' Lynx command line browser\n"
"\n"
"COOKIES\n"
"\n"
"  Cookies are generally used by web servers to keep state information at the\n"
"  client's side. The server sets cookies by sending a response line in the\n"
"  headers that looks like 'Set-Cookie: <data>' where the data part then\n"
"  typically contains a set of NAME=VALUE pairs (separated by semicolons ';'\n"
"  like \"NAME1=VALUE1; NAME2=VALUE2;\"). The server can also specify for what\n"
, stdout);
 fputs(
"  path the \"cookie\" should be used for (by specifying \"path=value\"), when the\n"
"  cookie should expire (\"expire=DATE\"), for what domain to use it\n"
"  (\"domain=NAME\") and if it should be used on secure connections only\n"
"  (\"secure\").\n"
"\n"
"  If you've received a page from a server that contains a header like:\n"
"        Set-Cookie: sessionid=boo123; path=\"/foo\";\n"
"\n"
"  it means the server wants that first pair passed on when we get anything in\n"
"  a path beginning with \"/foo\".\n"
"\n"
, stdout);
 fputs(
"  Example, get a page that wants my name passed in a cookie:\n"
"\n"
"        curl -b \"name=Daniel\" www.sillypage.com\n"
"\n"
"  Curl also has the ability to use previously received cookies in following\n"
"  sessions. If you get cookies from a server and store them in a file in a\n"
"  manner similar to:\n"
"\n"
"        curl --dump-header headers www.example.com\n"
"\n"
"  ... you can then in a second connect to that (or another) site, use the\n"
"  cookies from the 'headers' file like:\n"
"\n"
"        curl -b headers www.example.com\n"
"\n"
, stdout);
 fputs(
"  While saving headers to a file is a working way to store cookies, it is\n"
"  however error-prone and not the preferred way to do this. Instead, make curl\n"
"  save the incoming cookies using the well-known netscape cookie format like\n"
"  this:\n"
"\n"
"        curl -c cookies.txt www.example.com\n"
"\n"
"  Note that by specifying -b you enable the \"cookie awareness\" and with -L\n"
"  you can make curl follow a location: (which often is used in combination\n"
, stdout);
 fputs(
"  with cookies). So that if a site sends cookies and a location, you can\n"
"  use a non-existing file to trigger the cookie awareness like:\n"
"\n"
"        curl -L -b empty.txt www.example.com\n"
"\n"
"  The file to read cookies from must be formatted using plain HTTP headers OR\n"
"  as netscape's cookie file. Curl will determine what kind it is based on the\n"
"  file contents.  In the above command, curl will parse the header and store\n"
"  the cookies received from www.example.com.  curl will send to the server the\n"
, stdout);
 fputs(
"  stored cookies which match the request as it follows the location.  The\n"
"  file \"empty.txt\" may be a nonexistent file.\n"
"\n"
"  Alas, to both read and write cookies from a netscape cookie file, you can\n"
"  set both -b and -c to use the same file:\n"
"\n"
"        curl -b cookies.txt -c cookies.txt www.example.com\n"
"\n"
"PROGRESS METER\n"
"\n"
"  The progress meter exists to show a user that something actually is\n"
"  happening. The different fields in the output have the following meaning:\n"
"\n"
, stdout);
 fputs(
"  % Total    % Received % Xferd  Average Speed          Time             Curr.\n"
"                                 Dload  Upload Total    Current  Left    Speed\n"
"  0  151M    0 38608    0     0   9406      0  4:41:43  0:00:04  4:41:39  9287\n"
"\n"
"  From left-to-right:\n"
"   %             - percentage completed of the whole transfer\n"
"   Total         - total size of the whole expected transfer\n"
"   %             - percentage completed of the download\n"
"   Received      - currently downloaded amount of bytes\n"
, stdout);
 fputs(
"   %             - percentage completed of the upload\n"
"   Xferd         - currently uploaded amount of bytes\n"
"   Average Speed\n"
"   Dload         - the average transfer speed of the download\n"
"   Average Speed\n"
"   Upload        - the average transfer speed of the upload\n"
"   Time Total    - expected time to complete the operation\n"
"   Time Current  - time passed since the invoke\n"
"   Time Left     - expected time left to completion\n"
"   Curr.Speed    - the average transfer speed the last 5 seconds (the first\n"
, stdout);
 fputs(
"                   5 seconds of a transfer is based on less time of course.)\n"
"\n"
"  The -# option will display a totally different progress bar that doesn't\n"
"  need much explanation!\n"
"\n"
"SPEED LIMIT\n"
"\n"
"  Curl allows the user to set the transfer speed conditions that must be met\n"
"  to let the transfer keep going. By using the switch -y and -Y you\n"
"  can make curl abort transfers if the transfer speed is below the specified\n"
"  lowest limit for a specified time.\n"
"\n"
, stdout);
 fputs(
"  To have curl abort the download if the speed is slower than 3000 bytes per\n"
"  second for 1 minute, run:\n"
"\n"
"        curl -Y 3000 -y 60 www.far-away-site.com\n"
"\n"
"  This can very well be used in combination with the overall time limit, so\n"
"  that the above operation must be completed in whole within 30 minutes:\n"
"\n"
"        curl -m 1800 -Y 3000 -y 60 www.far-away-site.com\n"
"\n"
"  Forcing curl not to transfer data faster than a given rate is also possible,\n"
, stdout);
 fputs(
"  which might be useful if you're using a limited bandwidth connection and you\n"
"  don't want your transfer to use all of it (sometimes referred to as\n"
"  \"bandwidth throttle\").\n"
"\n"
"  Make curl transfer data no faster than 10 kilobytes per second:\n"
"\n"
"        curl --limit-rate 10K www.far-away-site.com\n"
"\n"
"    or\n"
"\n"
"        curl --limit-rate 10240 www.far-away-site.com\n"
"\n"
"  Or prevent curl from uploading data faster than 1 megabyte per second:\n"
"\n"
"        curl -T upload --limit-rate 1M ftp://uploadshereplease.com\n"
"\n"
, stdout);
 fputs(
"  When using the --limit-rate option, the transfer rate is regulated on a\n"
"  per-second basis, which will cause the total transfer speed to become lower\n"
"  than the given number. Sometimes of course substantially lower, if your\n"
"  transfer stalls during periods.\n"
"\n"
"CONFIG FILE\n"
"\n"
"  Curl automatically tries to read the .curlrc file (or _curlrc file on win32\n"
"  systems) from the user's home dir on startup.\n"
"\n"
"  The config file could be made up with normal command line switches, but you\n"
, stdout);
 fputs(
"  can also specify the long options without the dashes to make it more\n"
"  readable. You can separate the options and the parameter with spaces, or\n"
"  with = or :. Comments can be used within the file. If the first letter on a\n"
"  line is a '#'-letter the rest of the line is treated as a comment.\n"
"\n"
"  If you want the parameter to contain spaces, you must inclose the entire\n"
"  parameter within double quotes (\"). Within those quotes, you specify a\n"
"  quote as \\\".\n"
"\n"
, stdout);
 fputs(
"  NOTE: You must specify options and their arguments on the same line.\n"
"\n"
"  Example, set default time out and proxy in a config file:\n"
"\n"
"        # We want a 30 minute timeout:\n"
"        -m 1800\n"
"        # ... and we use a proxy for all accesses:\n"
"        proxy = proxy.our.domain.com:8080\n"
"\n"
"  White spaces ARE significant at the end of lines, but all white spaces\n"
"  leading up to the first characters of each line are ignored.\n"
"\n"
"  Prevent curl from reading the default file by using -q as the first command\n"
, stdout);
 fputs(
"  line parameter, like:\n"
"\n"
"        curl -q www.thatsite.com\n"
"\n"
"  Force curl to get and display a local help page in case it is invoked\n"
"  without URL by making a config file similar to:\n"
"\n"
"        # default url to get\n"
"        url = \"http://help.with.curl.com/curlhelp.html\"\n"
"\n"
"  You can specify another config file to be read by using the -K/--config\n"
"  flag. If you set config file name to \"-\" it'll read the config from stdin,\n"
"  which can be handy if you want to hide options from being visible in process\n"
, stdout);
 fputs(
"  tables etc:\n"
"\n"
"        echo \"user = user:passwd\" | curl -K - http://that.secret.site.com\n"
"\n"
"EXTRA HEADERS\n"
"\n"
"  When using curl in your own very special programs, you may end up needing\n"
"  to pass on your own custom headers when getting a web page. You can do\n"
"  this by using the -H flag.\n"
"\n"
"  Example, send the header \"X-you-and-me: yes\" to the server when getting a\n"
"  page:\n"
"\n"
"        curl -H \"X-you-and-me: yes\" www.love.com\n"
"\n"
"  This can also be useful in case you want curl to send a different text in a\n"
, stdout);
 fputs(
"  header than it normally does. The -H header you specify then replaces the\n"
"  header curl would normally send. If you replace an internal header with an\n"
"  empty one, you prevent that header from being sent. To prevent the Host:\n"
"  header from being used:\n"
"\n"
"        curl -H \"Host:\" www.server.com\n"
"\n"
"FTP and PATH NAMES\n"
"\n"
"  Do note that when getting files with the ftp:// URL, the given path is\n"
"  relative the directory you enter. To get the file 'README' from your home\n"
"  directory at your ftp site, do:\n"
"\n"
, stdout);
 fputs(
"        curl ftp://user:passwd@my.site.com/README\n"
"\n"
"  But if you want the README file from the root directory of that very same\n"
"  site, you need to specify the absolute file name:\n"
"\n"
"        curl ftp://user:passwd@my.site.com//README\n"
"\n"
"  (I.e with an extra slash in front of the file name.)\n"
"\n"
"FTP and firewalls\n"
"\n"
"  The FTP protocol requires one of the involved parties to open a second\n"
"  connction as soon as data is about to get transfered. There are two ways to\n"
"  do this.\n"
"\n"
, stdout);
 fputs(
"  The default way for curl is to issue the PASV command which causes the\n"
"  server to open another port and await another connection performed by the\n"
"  client. This is good if the client is behind a firewall that don't allow\n"
"  incoming connections.\n"
"\n"
"        curl ftp.download.com\n"
"\n"
"  If the server for example, is behind a firewall that don't allow connections\n"
"  on other ports than 21 (or if it just doesn't support the PASV command), the\n"
, stdout);
 fputs(
"  other way to do it is to use the PORT command and instruct the server to\n"
"  connect to the client on the given (as parameters to the PORT command) IP\n"
"  number and port.\n"
"\n"
"  The -P flag to curl supports a few different options. Your machine may have\n"
"  several IP-addresses and/or network interfaces and curl allows you to select\n"
"  which of them to use. Default address can also be used:\n"
"\n"
"        curl -P - ftp.download.com\n"
"\n"
, stdout);
 fputs(
"  Download with PORT but use the IP address of our 'le0' interface (this does\n"
"  not work on windows):\n"
"\n"
"        curl -P le0 ftp.download.com\n"
"\n"
"  Download with PORT but use 192.168.0.10 as our IP address to use:\n"
"\n"
"        curl -P 192.168.0.10 ftp.download.com\n"
"\n"
"NETWORK INTERFACE\n"
"\n"
"  Get a web page from a server using a specified port for the interface:\n"
"\n"
"        curl --interface eth0:1 http://www.netscape.com/\n"
"\n"
"  or\n"
"\n"
"        curl --interface 192.168.1.10 http://www.netscape.com/\n"
"\n"
"HTTPS\n"
"\n"
, stdout);
 fputs(
"  Secure HTTP requires SSL libraries to be installed and used when curl is\n"
"  built. If that is done, curl is capable of retrieving and posting documents\n"
"  using the HTTPS protocol.\n"
"\n"
"  Example:\n"
"\n"
"        curl https://www.secure-site.com\n"
"\n"
"  Curl is also capable of using your personal certificates to get/post files\n"
"  from sites that require valid certificates. The only drawback is that the\n"
"  certificate needs to be in PEM-format. PEM is a standard and open format to\n"
, stdout);
 fputs(
"  store certificates with, but it is not used by the most commonly used\n"
"  browsers (Netscape and MSIE both use the so called PKCS#12 format). If you\n"
"  want curl to use the certificates you use with your (favourite) browser, you\n"
"  may need to download/compile a converter that can convert your browser's\n"
"  formatted certificates to PEM formatted ones. This kind of converter is\n"
"  included in recent versions of OpenSSL, and for older versions Dr Stephen\n"
, stdout);
 fputs(
"  N. Henson has written a patch for SSLeay that adds this functionality. You\n"
"  can get his patch (that requires an SSLeay installation) from his site at:\n"
"  http://www.drh-consultancy.demon.co.uk/\n"
"\n"
"  Example on how to automatically retrieve a document using a certificate with\n"
"  a personal password:\n"
"\n"
"        curl -E /path/to/cert.pem:password https://secure.site.com/\n"
"\n"
"  If you neglect to specify the password on the command line, you will be\n"
, stdout);
 fputs(
"  prompted for the correct password before any data can be received.\n"
"\n"
"  Many older SSL-servers have problems with SSLv3 or TLS, that newer versions\n"
"  of OpenSSL etc is using, therefore it is sometimes useful to specify what\n"
"  SSL-version curl should use. Use -3, -2 or -1 to specify that exact SSL\n"
"  version to use (for SSLv3, SSLv2 or TLSv1 respectively):\n"
"\n"
"        curl -2 https://secure.site.com/\n"
"\n"
"  Otherwise, curl will first attempt to use v3 and then v2.\n"
"\n"
, stdout);
 fputs(
"  To use OpenSSL to convert your favourite browser's certificate into a PEM\n"
"  formatted one that curl can use, do something like this (assuming netscape,\n"
"  but IE is likely to work similarly):\n"
"\n"
"    You start with hitting the 'security' menu button in netscape. \n"
"\n"
"    Select 'certificates->yours' and then pick a certificate in the list \n"
"\n"
"    Press the 'export' button \n"
"\n"
"    enter your PIN code for the certs \n"
"\n"
"    select a proper place to save it \n"
"\n"
, stdout);
 fputs(
"    Run the 'openssl' application to convert the certificate. If you cd to the\n"
"    openssl installation, you can do it like:\n"
"\n"
"     # ./apps/openssl pkcs12 -in [file you saved] -clcerts -out [PEMfile]\n"
"\n"
"\n"
"RESUMING FILE TRANSFERS\n"
"\n"
" To continue a file transfer where it was previously aborted, curl supports\n"
" resume on http(s) downloads as well as ftp uploads and downloads.\n"
"\n"
" Continue downloading a document:\n"
"\n"
"        curl -C - -o file ftp://ftp.server.com/path/file\n"
"\n"
" Continue uploading a document(*1):\n"
, stdout);
 fputs(
"\n"
"        curl -C - -T file ftp://ftp.server.com/path/file\n"
"\n"
" Continue downloading a document from a web server(*2):\n"
"\n"
"        curl -C - -o file http://www.server.com/\n"
"\n"
" (*1) = This requires that the ftp server supports the non-standard command\n"
"        SIZE. If it doesn't, curl will say so.\n"
"\n"
" (*2) = This requires that the web server supports at least HTTP/1.1. If it\n"
"        doesn't, curl will say so.\n"
"\n"
"TIME CONDITIONS\n"
"\n"
" HTTP allows a client to specify a time condition for the document it\n"
, stdout);
 fputs(
" requests. It is If-Modified-Since or If-Unmodified-Since. Curl allow you to\n"
" specify them with the -z/--time-cond flag.\n"
"\n"
" For example, you can easily make a download that only gets performed if the\n"
" remote file is newer than a local copy. It would be made like:\n"
"\n"
"        curl -z local.html http://remote.server.com/remote.html\n"
"\n"
" Or you can download a file only if the local file is newer than the remote\n"
" one. Do this by prepending the date string with a '-', as in:\n"
"\n"
, stdout);
 fputs(
"        curl -z -local.html http://remote.server.com/remote.html\n"
"\n"
" You can specify a \"free text\" date as condition. Tell curl to only download\n"
" the file if it was updated since yesterday:\n"
"\n"
"        curl -z yesterday http://remote.server.com/remote.html\n"
"\n"
" Curl will then accept a wide range of date formats. You always make the date\n"
" check the other way around by prepending it with a dash '-'.\n"
"\n"
"DICT\n"
"\n"
"  For fun try\n"
"\n"
"        curl dict://dict.org/m:curl\n"
"        curl dict://dict.org/d:heisenbug:jargon\n"
, stdout);
 fputs(
"        curl dict://dict.org/d:daniel:web1913\n"
"\n"
"  Aliases for 'm' are 'match' and 'find', and aliases for 'd' are 'define'\n"
"  and 'lookup'. For example,\n"
"\n"
"        curl dict://dict.org/find:curl\n"
"\n"
"  Commands that break the URL description of the RFC (but not the DICT\n"
"  protocol) are\n"
"\n"
"        curl dict://dict.org/show:db\n"
"        curl dict://dict.org/show:strat\n"
"\n"
"  Authentication is still missing (but this is not required by the RFC)\n"
"\n"
"LDAP\n"
"\n"
, stdout);
 fputs(
"  If you have installed the OpenLDAP library, curl can take advantage of it\n"
"  and offer ldap:// support.\n"
"\n"
"  LDAP is a complex thing and writing an LDAP query is not an easy task. I do\n"
"  advice you to dig up the syntax description for that elsewhere. Two places\n"
"  that might suit you are:\n"
"\n"
"  Netscape's \"Netscape Directory SDK 3.0 for C Programmer's Guide Chapter 10:\n"
"  Working with LDAP URLs\":\n"
"  http://developer.netscape.com/docs/manuals/dirsdk/csdk30/url.htm\n"
"\n"
, stdout);
 fputs(
"  RFC 2255, \"The LDAP URL Format\" http://www.rfc-editor.org/rfc/rfc2255.txt\n"
"\n"
"  To show you an example, this is now I can get all people from my local LDAP\n"
"  server that has a certain sub-domain in their email address:\n"
"\n"
"        curl -B \"ldap://ldap.frontec.se/o=frontec??sub?mail=*sth.frontec.se\"\n"
"\n"
"  If I want the same info in HTML format, I can get it by not using the -B\n"
"  (enforce ASCII) flag.\n"
"\n"
"ENVIRONMENT VARIABLES\n"
"\n"
"  Curl reads and understands the following environment variables:\n"
"\n"
, stdout);
 fputs(
"        http_proxy, HTTPS_PROXY, FTP_PROXY, GOPHER_PROXY\n"
"\n"
"  They should be set for protocol-specific proxies. General proxy should be\n"
"  set with\n"
"        \n"
"        ALL_PROXY\n"
"\n"
"  A comma-separated list of host names that shouldn't go through any proxy is\n"
"  set in (only an asterisk, '*' matches all hosts)\n"
"\n"
"        NO_PROXY\n"
"\n"
"  If a tail substring of the domain-path for a host matches one of these\n"
"  strings, transactions with that node will not be proxied.\n"
"\n"
"\n"
, stdout);
 fputs(
"  The usage of the -x/--proxy flag overrides the environment variables.\n"
"\n"
"NETRC\n"
"\n"
"  Unix introduced the .netrc concept a long time ago. It is a way for a user\n"
"  to specify name and password for commonly visited ftp sites in a file so\n"
"  that you don't have to type them in each time you visit those sites. You\n"
"  realize this is a big security risk if someone else gets hold of your\n"
"  passwords, so therefore most unix programs won't read this file unless it is\n"
, stdout);
 fputs(
"  only readable by yourself (curl doesn't care though).\n"
"\n"
"  Curl supports .netrc files if told so (using the -n/--netrc and\n"
"  --netrc-optional options). This is not restricted to only ftp,\n"
"  but curl can use it for all protocols where authentication is used.\n"
"\n"
"  A very simple .netrc file could look something like:\n"
"\n"
"        machine curl.haxx.se login iamdaniel password mysecret\n"
"\n"
"CUSTOM OUTPUT\n"
"\n"
"  To better allow script programmers to get to know about the progress of\n"
, stdout);
 fputs(
"  curl, the -w/--write-out option was introduced. Using this, you can specify\n"
"  what information from the previous transfer you want to extract.\n"
"\n"
"  To display the amount of bytes downloaded together with some text and an\n"
"  ending newline:\n"
"\n"
"        curl -w 'We downloaded %{size_download} bytes\\n' www.download.com\n"
"\n"
"KERBEROS4 FTP TRANSFER\n"
"\n"
"  Curl supports kerberos4 for FTP transfers. You need the kerberos package\n"
"  installed and used at curl build time for it to be used.\n"
"\n"
, stdout);
 fputs(
"  First, get the krb-ticket the normal way, like with the kauth tool. Then use\n"
"  curl in way similar to:\n"
"\n"
"        curl --krb4 private ftp://krb4site.com -u username:fakepwd\n"
"\n"
"  There's no use for a password on the -u switch, but a blank one will make\n"
"  curl ask for one and you already entered the real password to kauth.\n"
"\n"
"TELNET\n"
"\n"
"  The curl telnet support is basic and very easy to use. Curl passes all data\n"
"  passed to it on stdin to the remote server. Connect to a remote telnet\n"
, stdout);
 fputs(
"  server using a command line similar to:\n"
"\n"
"        curl telnet://remote.server.com\n"
"\n"
"  And enter the data to pass to the server on stdin. The result will be sent\n"
"  to stdout or to the file you specify with -o.\n"
"\n"
"  You might want the -N/--no-buffer option to switch off the buffered output\n"
"  for slow connections or similar.\n"
"\n"
"  Pass options to the telnet protocol negotiation, by using the -t option. To\n"
"  tell the server we use a vt100 terminal, try something like:\n"
"\n"
, stdout);
 fputs(
"        curl -tTTYPE=vt100 telnet://remote.server.com\n"
"\n"
"  Other interesting options for it -t include:\n"
"\n"
"   - XDISPLOC=<X display> Sets the X display location.\n"
"\n"
"   - NEW_ENV=<var,val> Sets an environment variable.\n"
"\n"
"  NOTE: the telnet protocol does not specify any way to login with a specified\n"
"  user and password so curl can't do that automatically. To do that, you need\n"
"  to track when the login prompt is received and send the username and\n"
"  password accordingly.\n"
"\n"
"PERSISTENT CONNECTIONS\n"
"\n"
, stdout);
 fputs(
"  Specifying multiple files on a single command line will make curl transfer\n"
"  all of them, one after the other in the specified order.\n"
"\n"
"  libcurl will attempt to use persistent connections for the transfers so that\n"
"  the second transfer to the same host can use the same connection that was\n"
"  already initiated and was left open in the previous transfer. This greatly\n"
"  decreases connection time for all but the first transfer and it makes a far\n"
"  better use of the network.\n"
"\n"
, stdout);
 fputs(
"  Note that curl cannot use persistent connections for transfers that are used\n"
"  in subsequence curl invokes. Try to stuff as many URLs as possible on the\n"
"  same command line if they are using the same host, as that'll make the\n"
"  transfers faster. If you use a http proxy for file transfers, practically\n"
"  all transfers will be persistent.\n"
"\n"
"MAILING LISTS\n"
"\n"
"  For your convenience, we have several open mailing lists to discuss curl,\n"
"  its development and things relevant to this. Get all info at\n"
, stdout);
 fputs(
"  http://curl.haxx.se/mail/. Some of the lists available are:\n"
"\n"
"  curl-users\n"
"\n"
"    Users of the command line tool. How to use it, what doesn't work, new\n"
"    features, related tools, questions, news, installations, compilations,\n"
"    running, porting etc.\n"
"\n"
"  curl-library\n"
"\n"
"    Developers using or developing libcurl. Bugs, extensions, improvements.\n"
"\n"
"  curl-announce\n"
"\n"
"    Low-traffic. Only receives announcements of new public versions. At worst,\n"
, stdout);
 fputs(
"    that makes something like one or two mails per month, but usually only one\n"
"    mail every second month.\n"
"\n"
"  curl-and-php\n"
"\n"
"    Using the curl functions in PHP. Everything curl with a PHP angle. Or PHP\n"
"    with a curl angle.\n"
"\n"
"  curl-and-python\n"
"\n"
"    Python hackers using curl with or without the python binding pycurl.\n"
"\n"
"  Please direct curl questions, feature requests and trouble reports to one of\n"
"  these mailing lists instead of mailing any individual.\n"
, stdout) ;
}
#endif /* USE_MANUAL */
#else
/*
 * NEVER EVER edit this manually, fix the mkhelp.pl script instead!
 * Generation time: Wed May 11 13:35:34 2005
 */
#include "setup.h"
#ifdef USE_MANUAL
#include "hugehelp.h"
#include <stdio.h>
#include <zlib.h>
static const unsigned char hugehelpgz[] = {
  /* This mumbo-jumbo is the huge help text compressed with gzip.
     Thanks to this operation, the size of this data shrunk from 102372
     to 31559 bytes. You can disable the use of compressed help
     texts by NOT passing -c to the mkhelp.pl tool. */
  0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x03, 0xd5, 0xbd, 
  0x6b, 0x77, 0x1b, 0xc7, 0xb1, 0x2e, 0xfc, 0x9d, 0xbf, 0x62, 0x82, 0x2c, 
  0x07, 0x64, 0x02, 0x80, 0x17, 0x49, 0x8e, 0x25, 0x4b, 0x8e, 0x69, 0x92, 
  0xb2, 0xb9, 0x4c, 0x91, 0x3c, 0x04, 0xe5, 0xcb, 0x71, 0xbc, 0xb4, 0x06, 
  0xc0, 0x80, 0x9c, 0x10, 0xc0, 0x20, 0x33, 0x03, 0x5e, 0x9c, 0x9d, 0xf3, 
  0xdb, 0xdf, 0xaa, 0xa7, 0xaa, 0xba, 0x7b, 0x2e, 0xa0, 0x64, 0xc7, 0xda, 
  0x7b, 0xbf, 0xde, 0x3b, 0x22, 0x09, 0xcc, 0xf4, 0xb5, 0xba, 0xba, 0xae, 
  0x4f, 0x45, 0xd1, 0xfb, 0xfe, 0x7b, 0x87, 0xff, 0xbd, 0xa3, 0xff, 0xe4, 
  0xf7, 0x28, 0xda, 0x88, 0xa2, 0xf3, 0x3c, 0xfb, 0x47, 0x32, 0x2e, 0xdb, 
  0x5f, 0x78, 0xf7, 0xee, 0xbf, 0x22, 0xf9, 0x3f, 0x7a, 0xe1, 0xef, 0xf8, 
  0x89, 0x97, 0x1e, 0xf9, 0x6f, 0x3b, 0xf2, 0x2f, 0xfd, 0xd7, 0xbb, 0xad, 
  0xe8, 0x43, 0x5e, 0xfa, 0xaf, 0x68, 0x13, 0x2f, 0xbd, 0xd3, 0x9e, 0x5e, 
  0xf2, 0xef, 0x34, 0xca, 0xc7, 0x7b, 0xfa, 0x3b, 0x0f, 0x8f, 0xff, 0xd9, 
  0xe6, 0x17, 0xff, 0xfe, 0x8e, 0x7f, 0xa5, 0x4f, 0x36, 0x36, 0x4e, 0xf7, 
  0xdf, 0x1c, 0xd9, 0xab, 0xe3, 0x55, 0x3e, 0x8b, 0xfa, 0x51, 0x99, 0xc7, 
  0x8b, 0x62, 0x9a, 0xe4, 0x51, 0x1c, 0xbd, 0xbd, 0x38, 0xd9, 0xd8, 0x18, 
  0xfe, 0x78, 0x7a, 0x76, 0x3e, 0x3c, 0x1e, 0x56, 0x1e, 0xfb, 0x29, 0x5b, 
  0x96, 0x69, 0xb6, 0x28, 0x7e, 0x8e, 0x7e, 0xa2, 0x87, 0x06, 0x83, 0xc1, 
  0xcf, 0x1b, 0x1b, 0x87, 0x47, 0xc3, 0x83, 0x8b, 0xe3, 0xf3, 0xcb, 0xe3, 
  0xb3, 0xd3, 0xca, 0xb3, 0x51, 0x5a, 0x44, 0xd4, 0x58, 0x99, 0x65, 0x33, 
  0xfa, 0xc7, 0xb7, 0x3f, 0x89, 0xcb, 0x38, 0x9a, 0xe6, 0xd9, 0x3c, 0xca, 
  0x72, 0xfe, 0x22, 0x8e, 0x8a, 0x24, 0xbf, 0x4d, 0xf2, 0x5e, 0xb4, 0x2a, 
  0xd2, 0xc5, 0x55, 0x94, 0x2d, 0x92, 0x28, 0x9b, 0x46, 0xe5, 0x75, 0x62, 
  0xcd, 0x15, 0xab, 0xe5, 0x32, 0xcb, 0xcb, 0x64, 0x12, 0x2d, 0xf3, 0xac, 
  0xcc, 0xc6, 0xd9, 0xac, 0x88, 0x36, 0xbf, 0xb9, 0xbc, 0x3c, 0xef, 0x45, 
  0xfc, 0xef, 0xb0, 0x17, 0xbd, 0xe6, 0xdf, 0x5f, 0xe3, 0xd7, 0xaf, 0xcf, 
  0xce, 0xbf, 0x39, 0xba, 0xe8, 0x45, 0x87, 0xc7, 0x07, 0x97, 0xbd, 0xe8, 
  0xf2, 0xe8, 0xe4, 0xf4, 0x88, 0x7e, 0x9e, 0x1c, 0xee, 0x9f, 0x5b, 0x73, 
  0xd4, 0xed, 0xeb, 0xe3, 0x93, 0xa3, 0xad, 0x41, 0x74, 0x79, 0x9d, 0x44, 
  0xe3, 0x6c, 0x3e, 0x8f, 0x17, 0x13, 0x1e, 0xed, 0x24, 0x29, 0xd2, 0xab, 
  0x05, 0x75, 0x43, 0xa3, 0xba, 0xcb, 0xf2, 0x9b, 0xe8, 0x2e, 0x2d, 0xaf, 
  0xb3, 0x55, 0x49, 0x03, 0xa3, 0x71, 0xa7, 0x8b, 0x32, 0xc9, 0xe3, 0x31, 
  0xcf, 0x7f, 0xb0, 0x51, 0x99, 0x69, 0x36, 0xa5, 0x79, 0x15, 0x34, 0x91, 
  0xd1, 0xaa, 0x98, 0x65, 0xf1, 0x84, 0x87, 0x4f, 0xaf, 0x4c, 0x57, 0x34, 
  0xf1, 0x3c, 0x1d, 0xdf, 0x14, 0xd1, 0x2c, 0xbd, 0x49, 0x78, 0xf0, 0xf7, 
  0x0f, 0x36, 0x99, 0x9e, 0x34, 0x1a, 0xaf, 0x68, 0x9e, 0x8b, 0xbe, 0x35, 
  0x57, 0xa6, 0xe3, 0x98, 0x3b, 0xe8, 0x45, 0xd3, 0x72, 0x19, 0xad, 0x96, 
  0xdc, 0x9a, 0x4c, 0x32, 0x5a, 0x66, 0x05, 0xbd, 0x14, 0x0d, 0x87, 0x27, 
  0x51, 0xb4, 0x79, 0x5d, 0x96, 0xcb, 0xe2, 0xc5, 0x16, 0xf5, 0x9f, 0x2d, 
  0x16, 0x09, 0xc6, 0x54, 0xf4, 0xf8, 0xaf, 0xec, 0x26, 0x4d, 0x8a, 0x9e, 
  0x35, 0x37, 0x4d, 0x67, 0x49, 0xe4, 0x57, 0x3e, 0xca, 0x93, 0x62, 0x35, 
  0xa7, 0x4f, 0x78, 0xbe, 0xd1, 0x3c, 0xcb, 0x93, 0x41, 0xb4, 0x5f, 0x44, 
  0x0f, 0xd9, 0x8a, 0x66, 0x3a, 0x9b, 0xd1, 0x3e, 0x24, 0xd1, 0x28, 0x99, 
  0x65, 0x77, 0x3d, 0x5e, 0xfd, 0x28, 0x9e, 0x67, 0xab, 0x45, 0x49, 0x93, 
  0x71, 0xcd, 0x25, 0x71, 0xb9, 0xa2, 0x36, 0xe4, 0xe9, 0x79, 0x4c, 0x73, 
  0xa2, 0x77, 0xf3, 0xe8, 0x3a, 0xa1, 0x39, 0x17, 0xcb, 0x74, 0xf1, 0x87, 
  0xea, 0xba, 0xd0, 0x92, 0x2e, 0xb3, 0xbb, 0x24, 0xa7, 0x15, 0x1d, 0x3d, 
  0x44, 0xb4, 0x08, 0x23, 0x21, 0x8c, 0x29, 0xed, 0x40, 0x14, 0x53, 0x13, 
  0x6e, 0x68, 0xfd, 0x3c, 0x99, 0xc5, 0xbc, 0xc1, 0xae, 0x8f, 0x01, 0x4d, 
  0x35, 0x71, 0x14, 0xa0, 0xaf, 0x6e, 0x3e, 0xd9, 0xc2, 0xcb, 0x93, 0xa4, 
  0x8c, 0xd3, 0x59, 0x41, 0xdb, 0xc0, 0xa4, 0xaa, 0xcf, 0xf0, 0x66, 0x32, 
  0xe9, 0x12, 0xbd, 0x3c, 0x2c, 0xca, 0xf8, 0x1e, 0xdd, 0x2b, 0xbd, 0xd0, 
  0x1b, 0xcb, 0x64, 0x31, 0x49, 0x16, 0xe5, 0x20, 0xfa, 0x31, 0x5b, 0x75, 
  0xa9, 0xef, 0x69, 0x4a, 0x8b, 0x10, 0x6b, 0x53, 0xd4, 0x33, 0x6d, 0xfe, 
  0x38, 0x4f, 0x97, 0xc1, 0x56, 0x64, 0x0b, 0xda, 0xf3, 0xe8, 0xe2, 0xf5, 
  0x41, 0xb4, 0xf7, 0xe4, 0xf9, 0xa7, 0x7e, 0xcf, 0xa9, 0x81, 0x68, 0x1c, 
  0x2f, 0x68, 0xc6, 0xc9, 0x38, 0x9d, 0x3e, 0x44, 0xf3, 0xd5, 0xac, 0x4c, 
  0x97, 0xb4, 0xd2, 0xd4, 0x79, 0xc1, 0xd4, 0xb5, 0x8c, 0xf3, 0xb2, 0x60, 
  0x22, 0xc0, 0x07, 0x98, 0xfb, 0x5d, 0x9e, 0x96, 0x4c, 0xdc, 0xf8, 0x8e, 
  0x46, 0x98, 0x94, 0x85, 0x35, 0xc7, 0x44, 0x46, 0xfd, 0x8c, 0x88, 0xb6, 
  0x68, 0x69, 0xe3, 0x82, 0x3a, 0x7d, 0xe1, 0xfa, 0x8a, 0x78, 0xa7, 0x5f, 
  0x6c, 0x6f, 0x17, 0x69, 0x99, 0x0c, 0xfe, 0x45, 0x47, 0xa3, 0x57, 0xde, 
  0x65, 0xbd, 0xf2, 0x3a, 0x4f, 0x92, 0x7f, 0x0f, 0x88, 0x74, 0x37, 0x02, 
  0xa2, 0x7e, 0xd0, 0x71, 0x5d, 0x25, 0x25, 0x75, 0xf0, 0xcf, 0x55, 0xb2, 
  0xe0, 0x06, 0x69, 0x18, 0xf1, 0x6c, 0x79, 0x1d, 0x2f, 0x68, 0xe7, 0x89, 
  0x18, 0xf9, 0xb0, 0x11, 0x89, 0xf0, 0xa0, 0xe4, 0xb8, 0xfd, 0xf4, 0x73, 
  0xa3, 0xcf, 0x29, 0xba, 0xa4, 0x7f, 0x07, 0xfa, 0x52, 0x4c, 0x6b, 0x4d, 
  0x9d, 0x6d, 0x33, 0x3d, 0xfd, 0xb4, 0xdb, 0xdf, 0xdd, 0xd9, 0xf9, 0x79, 
  0x50, 0xde, 0x97, 0x1f, 0xf8, 0xc2, 0xce, 0x8e, 0x7f, 0x85, 0x9f, 0xde, 
  0xe4, 0x19, 0x47, 0x33, 0x22, 0x1a, 0xee, 0xff, 0x97, 0x24, 0xcf, 0x8a, 
  0xad, 0x96, 0xa6, 0x66, 0x49, 0x49, 0x07, 0x2e, 0x68, 0x27, 0xee, 0xff, 
  0x22, 0xdd, 0xda, 0xc3, 0xa7, 0x59, 0xb4, 0x48, 0x0a, 0xac, 0xab, 0x30, 
  0x8c, 0x60, 0xda, 0xb4, 0xf9, 0x9e, 0x6d, 0xc4, 0x25, 0xbe, 0x9d, 0x67, 
  0x73, 0xa2, 0x80, 0x1e, 0x1d, 0xd3, 0xd2, 0x2d, 0x16, 0x9d, 0x42, 0xc7, 
  0x66, 0x12, 0xe2, 0x42, 0xf1, 0x8c, 0x19, 0x50, 0x41, 0x0d, 0xd3, 0x60, 
  0x89, 0x0f, 0x24, 0xf1, 0xf8, 0x3a, 0xca, 0xe8, 0xed, 0xbc, 0xb9, 0x29, 
  0xf1, 0xe2, 0x61, 0x90, 0xe5, 0x57, 0xdb, 0x71, 0x3e, 0xbe, 0x4e, 0x6f, 
  0x69, 0x65, 0x9e, 0x3f, 0xff, 0xb4, 0x4f, 0xff, 0x3c, 0xff, 0x79, 0xfb, 
  0x36, 0x9b, 0xd1, 0x42, 0x3d, 0xfd, 0x79, 0x9b, 0xf7, 0xfb, 0x5f, 0x71, 
  0x6f, 0xd4, 0x1b, 0xff, 0x7b, 0x70, 0x5d, 0xce, 0x67, 0x6b, 0xa9, 0x88, 
  0x1a, 0xf3, 0x27, 0x4e, 0x49, 0x69, 0x81, 0x61, 0x1b, 0x87, 0x9a, 0xa5, 
  0x0b, 0x3a, 0xb0, 0x4c, 0xe7, 0x4c, 0x50, 0x7c, 0x04, 0xe9, 0xb4, 0xfa, 
  0xb3, 0x59, 0x8e, 0xaf, 0x69, 0xaa, 0x44, 0x49, 0xb1, 0x2e, 0x43, 0x99, 
  0xc6, 0x7c, 0x4a, 0x89, 0x41, 0x30, 0xf3, 0x92, 0xf5, 0x41, 0x67, 0x29, 
  0x3d, 0x97, 0xe5, 0x93, 0x24, 0xf7, 0x34, 0x7d, 0xc0, 0x07, 0x13, 0x6d, 
  0xc6, 0xb4, 0xea, 0xf3, 0x25, 0xe6, 0x9e, 0x27, 0x7d, 0x5a, 0x9e, 0x90, 
  0xc7, 0xe0, 0xf4, 0x39, 0x7a, 0x07, 0x7b, 0xb1, 0x23, 0x4c, 0xfc, 0xa7, 
  0xc8, 0xdc, 0xe1, 0xb9, 0xa6, 0x25, 0x27, 0x3a, 0xc4, 0xde, 0xcc, 0x79, 
  0x6a, 0xfc, 0x6c, 0x21, 0x6c, 0x1f, 0x03, 0x89, 0xe7, 0x89, 0xf2, 0x7d, 
  0xe9, 0x76, 0x91, 0x95, 0xd1, 0x24, 0xf3, 0x6d, 0x73, 0xaf, 0xee, 0x2c, 
  0x72, 0xf7, 0x05, 0xdd, 0x9b, 0x44, 0xc5, 0x93, 0xe2, 0x9a, 0xf8, 0x4e, 
  0xc1, 0xbc, 0x9b, 0xb6, 0x38, 0x9d, 0xd3, 0x09, 0xbf, 0xa5, 0x86, 0x69, 
  0x62, 0xc9, 0x64, 0x10, 0x9d, 0x4d, 0xe9, 0xbd, 0x55, 0x4e, 0x83, 0x2e, 
  0xf1, 0x35, 0xaf, 0xe1, 0xec, 0x81, 0x1a, 0xe6, 0x3b, 0x65, 0x11, 0xb2, 
  0xc5, 0x22, 0x5c, 0x0b, 0xac, 0x19, 0x0d, 0x75, 0x56, 0x5d, 0x6c, 0xe1, 
  0x93, 0xb4, 0x49, 0x3c, 0x38, 0x5a, 0xeb, 0x88, 0xa9, 0x65, 0xc2, 0xbf, 
  0x95, 0x77, 0x49, 0xb2, 0xf0, 0x74, 0x43, 0x9b, 0x4c, 0xdc, 0x4b, 0x99, 
  0xde, 0xe2, 0x36, 0xe3, 0x01, 0x6e, 0x6c, 0x9c, 0xe1, 0x4e, 0x74, 0x17, 
  0x68, 0x3f, 0xde, 0xee, 0xf7, 0xe3, 0x25, 0xf3, 0xa1, 0xda, 0xad, 0xbd, 
  0x49, 0x37, 0x17, 0xf1, 0xf2, 0xef, 0xe9, 0x26, 0x90, 0x1e, 0x78, 0x13, 
  0x17, 0x7c, 0x9f, 0xb9, 0x2b, 0x00, 0xd3, 0xc1, 0x42, 0x95, 0x09, 0xfd, 
  0x83, 0x9e, 0xf8, 0xee, 0x6c, 0x6b, 0x8e, 0x2f, 0x5b, 0x5a, 0xe2, 0x32, 
  0xce, 0x99, 0x13, 0xc8, 0x1d, 0x90, 0x2e, 0x8a, 0x92, 0xb9, 0x34, 0xd3, 
  0x56, 0x44, 0x2b, 0x96, 0x3b, 0x86, 0x94, 0x12, 0x4b, 0x8c, 0x8e, 0xa7, 
  0x11, 0xde, 0xc1, 0xd3, 0xb5, 0xe6, 0x26, 0x59, 0x52, 0x2c, 0xba, 0x65, 
  0x94, 0xdc, 0xa7, 0x7c, 0x03, 0xa5, 0xa5, 0x8c, 0x83, 0x96, 0x63, 0x9c, 
  0x27, 0xcc, 0xb4, 0x3d, 0x15, 0xe9, 0x7f, 0xc7, 0x53, 0x19, 0xaf, 0x08, 
  0x0b, 0xbc, 0x0b, 0x98, 0x55, 0x79, 0x97, 0x8e, 0x93, 0x9e, 0x9e, 0x53, 
  0xda, 0xde, 0x09, 0xae, 0x7a, 0x34, 0x36, 0x49, 0x8b, 0x78, 0x44, 0xe3, 
  0x6c, 0x9d, 0xcf, 0x3c, 0x9b, 0xd0, 0x37, 0x57, 0x71, 0x1a, 0xdc, 0xbb, 
  0xfd, 0x7d, 0x5a, 0x4c, 0xbe, 0x41, 0xfb, 0xf1, 0x15, 0x51, 0x7a, 0xf4, 
  0x52, 0x7e, 0x14, 0x74, 0xdf, 0x2e, 0xae, 0xbe, 0xa8, 0xaf, 0x2f, 0x5f, 
  0xa0, 0x5b, 0xd1, 0x50, 0x4f, 0x1a, 0x0f, 0xe0, 0x2d, 0xbf, 0xba, 0x1f, 
  0xbc, 0xc3, 0xab, 0x56, 0x50, 0xdf, 0xb6, 0x7a, 0xb8, 0x73, 0x85, 0x40, 
  0x07, 0xb5, 0xe6, 0x86, 0x19, 0xdf, 0xa1, 0xa3, 0x78, 0x42, 0x94, 0x25, 
  0xa4, 0x75, 0xf0, 0xf5, 0x31, 0xd1, 0x36, 0xdd, 0x23, 0x51, 0x3a, 0xa5, 
  0x05, 0x2a, 0x40, 0xcd, 0xc4, 0xe3, 0xb9, 0xb1, 0xce, 0x9b, 0xec, 0x17, 
  0x9a, 0x62, 0xbc, 0xfd, 0x74, 0xb0, 0xd3, 0xe1, 0xe3, 0x9b, 0xd5, 0x9a, 
  0x23, 0x7e, 0xc5, 0x13, 0x1c, 0xcd, 0xe2, 0xc5, 0x4d, 0xe1, 0x0e, 0x2a, 
  0x06, 0x45, 0x47, 0x6a, 0x95, 0xe7, 0xc4, 0x13, 0x26, 0xba, 0x3d, 0x3a, 
  0x56, 0xdc, 0x19, 0x91, 0x92, 0x6c, 0xad, 0xb9, 0x7f, 0xae, 0x32, 0x22, 
  0x45, 0x3a, 0x74, 0xf9, 0x0d, 0x5f, 0xa2, 0x72, 0x4e, 0x98, 0xd1, 0x10, 
  0x4f, 0xce, 0x78, 0xd7, 0x78, 0x5c, 0x78, 0x9f, 0x5b, 0xec, 0x7f, 0x43, 
  0xeb, 0xc8, 0xf7, 0x37, 0x9d, 0x43, 0xd9, 0xae, 0x5a, 0x73, 0x99, 0x9d, 
  0xa8, 0x0f, 0xd8, 0x65, 0x6e, 0x99, 0xa5, 0x0a, 0x3e, 0xfe, 0x0b, 0xda, 
  0x5c, 0xdb, 0xed, 0x59, 0x5c, 0x94, 0x7e, 0xaf, 0x71, 0x90, 0x02, 0xe9, 
  0xce, 0x3a, 0x5a, 0xe0, 0xbd, 0xb2, 0x2b, 0xd4, 0x12, 0x6c, 0x75, 0x9f, 
  0xf8, 0x07, 0xcb, 0x49, 0xed, 0xbb, 0x7a, 0x49, 0xe7, 0xa1, 0x70, 0x07, 
  0x62, 0x9a, 0x5e, 0x91, 0xf4, 0x10, 0xb1, 0xd0, 0x26, 0xa2, 0x95, 0x49, 
  0x54, 0xd1, 0x3c, 0x21, 0x59, 0x0e, 0x82, 0x08, 0x6d, 0x50, 0x32, 0x9b, 
  0xf6, 0x6a, 0xcd, 0xf1, 0x59, 0x5f, 0x81, 0x71, 0xf0, 0x45, 0x51, 0xf0, 
  0xfe, 0x8d, 0xd1, 0xd4, 0x42, 0x3e, 0xcb, 0x93, 0x39, 0x2f, 0x2c, 0x5f, 
  0xc4, 0xd1, 0x78, 0x16, 0xa7, 0xf3, 0x82, 0x8f, 0x82, 0x5d, 0x32, 0x45, 
  0x9d, 0x48, 0x2e, 0x95, 0xff, 0x80, 0x3e, 0x46, 0xcc, 0xff, 0xf2, 0x82, 
  0x39, 0x1c, 0x6f, 0x5f, 0x4c, 0x8d, 0x11, 0x83, 0xa6, 0xbf, 0xb9, 0x53, 
  0x62, 0xdb, 0xe3, 0x1b, 0x50, 0x20, 0x7a, 0x29, 0x96, 0xc4, 0x67, 0x93, 
  0x7e, 0xad, 0x39, 0xd9, 0xa2, 0x82, 0xd7, 0x73, 0xc5, 0x44, 0x32, 0x59, 
  0x8d, 0xd1, 0xd2, 0x82, 0x8e, 0x25, 0x71, 0x60, 0xe2, 0x90, 0x25, 0x24, 
  0x56, 0x10, 0x4b, 0x9f, 0xa8, 0x64, 0x39, 0x70, 0x43, 0xe0, 0xe5, 0xac, 
  0x35, 0x57, 0x61, 0x07, 0x85, 0xf2, 0xe9, 0xd8, 0x58, 0xe2, 0xb8, 0x7d, 
  0xed, 0x7a, 0xd1, 0xdd, 0x75, 0x4a, 0xb7, 0x21, 0x5d, 0x9d, 0xb5, 0xe6, 
  0x98, 0xbc, 0x88, 0x79, 0x83, 0xaa, 0xfa, 0xfd, 0x51, 0x5c, 0xa4, 0xe3, 
  0x1e, 0xfd, 0x32, 0x49, 0xaf, 0x12, 0x66, 0x19, 0xfd, 0xfe, 0xa2, 0x9c, 
  0xcd, 0x7b, 0xc2, 0x4e, 0xe9, 0x8f, 0xe4, 0x2a, 0xa3, 0xbb, 0xa9, 0xe4, 
  0xcb, 0x6c, 0x73, 0x7f, 0x32, 0x69, 0x19, 0x5d, 0xf4, 0xd7, 0xc1, 0xee, 
  0xce, 0xe0, 0xd3, 0xad, 0x3a, 0xcd, 0x9d, 0x82, 0xb6, 0x71, 0xbb, 0xa8, 
  0xf8, 0xe2, 0xa8, 0x83, 0x67, 0xca, 0xc7, 0x2e, 0x4f, 0x98, 0x85, 0xb3, 
  0xb0, 0x37, 0xe1, 0xd3, 0xc8, 0xf7, 0x3c, 0x0d, 0x4d, 0xf8, 0x68, 0x51, 
  0x6b, 0x0e, 0xd7, 0x51, 0x51, 0x92, 0x1c, 0xd2, 0xe3, 0xc3, 0x34, 0x4e, 
  0x78, 0x4b, 0xe7, 0xf1, 0x03, 0xf6, 0x27, 0xa5, 0xcd, 0x87, 0xae, 0x52, 
  0xea, 0xb1, 0x21, 0x5e, 0x01, 0x16, 0x26, 0xf3, 0xe0, 0x05, 0xaa, 0x33, 
  0x5e, 0xbe, 0xac, 0x67, 0x29, 0x3f, 0x38, 0x5f, 0xd1, 0xee, 0xd2, 0x5b, 
  0xe0, 0x6a, 0xb8, 0x4a, 0xef, 0x68, 0xd3, 0x06, 0x72, 0x68, 0x12, 0xda, 
  0x2e, 0x1a, 0x5d, 0x41, 0xba, 0xc5, 0x8c, 0x84, 0x93, 0x3c, 0x25, 0xb2, 
  0xbb, 0x6b, 0x36, 0x27, 0x63, 0xe6, 0x49, 0x86, 0xe3, 0xe4, 0xd7, 0xe5, 
  0x1b, 0x3a, 0x79, 0x24, 0xaf, 0x60, 0x83, 0x70, 0xb0, 0x98, 0x01, 0x7d, 
  0x28, 0x2f, 0x36, 0x59, 0xa7, 0x4c, 0xe7, 0x49, 0x21, 0x8d, 0x4e, 0xb3, 
  0x19, 0x89, 0xfe, 0x60, 0x2f, 0xd9, 0x98, 0x48, 0x3f, 0x87, 0x20, 0x55, 
  0xe7, 0xc5, 0x2c, 0xf4, 0x2f, 0x32, 0x62, 0xd8, 0xac, 0xf3, 0xf0, 0x13, 
  0xc1, 0x41, 0x1d, 0x11, 0x2f, 0x11, 0x15, 0x24, 0x7a, 0xb9, 0xa0, 0x0b, 
  0xfe, 0x15, 0x2f, 0xdf, 0x1a, 0x66, 0x1c, 0x9d, 0xc7, 0x45, 0x81, 0x7e, 
  0x6d, 0x8d, 0x6b, 0x5c, 0x97, 0xa5, 0xd2, 0x58, 0x35, 0x1a, 0x5a, 0xb7, 
  0x52, 0x25, 0xba, 0xfa, 0xc1, 0x20, 0xb5, 0x28, 0x61, 0x46, 0xec, 0x5a, 
  0x5a, 0xe6, 0xc9, 0x6d, 0x9a, 0x91, 0x22, 0xc6, 0xbb, 0x38, 0x4e, 0x48, 
  0x2e, 0x9b, 0x04, 0x62, 0x87, 0x34, 0x0d, 0x21, 0x29, 0xea, 0x0c, 0x93, 
  0xb2, 0xde, 0xdc, 0x01, 0xfa, 0x7b, 0xd1, 0x89, 0x02, 0x69, 0x4b, 0xda, 
  0xd5, 0xdd, 0xa2, 0x3d, 0x55, 0x16, 0x4d, 0xa2, 0xd0, 0x9c, 0xe8, 0xb0, 
  0xc3, 0xba, 0xf4, 0xee, 0xab, 0xef, 0xf6, 0x4f, 0xde, 0x1e, 0xed, 0x7e, 
  0x5e, 0xa7, 0x57, 0xfa, 0x6e, 0x4f, 0xbe, 0xdb, 0xeb, 0xb4, 0xed, 0x0d, 
  0x2d, 0x65, 0xf7, 0x55, 0x37, 0x12, 0x59, 0xd7, 0xed, 0x8e, 0xf6, 0xc0, 
  0x43, 0xc0, 0x85, 0x4b, 0x9f, 0x97, 0x72, 0xd7, 0xf2, 0xaa, 0xf0, 0xd8, 
  0xf9, 0x9e, 0xae, 0x8f, 0x9d, 0x97, 0x1c, 0xb7, 0xbf, 0xf0, 0x31, 0x26, 
  0xba, 0x78, 0x12, 0xae, 0x47, 0x51, 0x66, 0xac, 0x8b, 0xe9, 0x16, 0x71, 
  0xeb, 0x22, 0x91, 0xe9, 0xc1, 0xae, 0x35, 0xe7, 0x27, 0xec, 0xc7, 0x04, 
  0x26, 0x5f, 0x14, 0xa0, 0x24, 0x50, 0x32, 0x69, 0x3f, 0x31, 0x09, 0x9e, 
  0x03, 0xba, 0x50, 0x85, 0x85, 0xb1, 0xd2, 0x2f, 0xec, 0xa2, 0xce, 0x5f, 
  0xf9, 0xfa, 0x89, 0x58, 0x7f, 0xbe, 0xa5, 0x89, 0x14, 0x72, 0x5a, 0x3a, 
  0x3a, 0x16, 0x12, 0xa0, 0x68, 0x6b, 0x3a, 0xca, 0x60, 0xbc, 0x7a, 0x09, 
  0xb6, 0xce, 0x27, 0x3a, 0x6f, 0xf2, 0x08, 0x3a, 0xe6, 0xdc, 0xa5, 0xea, 
  0xbc, 0x6c, 0x67, 0x30, 0x06, 0xc5, 0x27, 0x98, 0x86, 0xcd, 0xd2, 0xe2, 
  0x83, 0xf2, 0x80, 0x6e, 0x9e, 0x28, 0xc3, 0x10, 0xc1, 0xb0, 0x7e, 0xd6, 
  0xa8, 0xb1, 0x51, 0xba, 0x90, 0xc3, 0xa4, 0xb7, 0x2b, 0x2e, 0xdc, 0xfe, 
  0x09, 0xd1, 0xf4, 0x2c, 0x53, 0x3e, 0x28, 0x87, 0x48, 0xec, 0x06, 0x90, 
  0xab, 0x94, 0x06, 0xbc, 0x8a, 0x1c, 0x70, 0x02, 0x91, 0x8e, 0x75, 0x17, 
  0x6c, 0x94, 0x72, 0x92, 0xdd, 0xca, 0x2e, 0xe9, 0x22, 0xa1, 0x0e, 0x41, 
  0xf6, 0xc6, 0xe3, 0x59, 0x97, 0x6b, 0x69, 0xee, 0x94, 0x54, 0xc6, 0x71, 
  0xbc, 0x4c, 0xb6, 0x55, 0x9e, 0xb0, 0x6d, 0x0c, 0xc6, 0xd1, 0x20, 0xb0, 
  0xd3, 0xb3, 0xcb, 0x23, 0x63, 0x97, 0x4e, 0xbc, 0x0b, 0x04, 0x5f, 0x61, 
  0xd8, 0xc1, 0xb1, 0x35, 0x81, 0x19, 0x3b, 0x1e, 0x17, 0x8d, 0x35, 0x5f, 
  0xae, 0x48, 0x5a, 0x24, 0xb5, 0xcb, 0xa6, 0x63, 0x92, 0xa0, 0x52, 0x96, 
  0x9d, 0x0c, 0xea, 0x85, 0x16, 0x29, 0x93, 0x8f, 0x9b, 0x66, 0x09, 0xe3, 
  0x6f, 0x45, 0x62, 0xab, 0x3c, 0x76, 0x43, 0xe8, 0xff, 0x23, 0x36, 0x49, 
  0xc4, 0xe9, 0xb4, 0x58, 0x2d, 0x62, 0x58, 0xa4, 0x2c, 0xc5, 0xb7, 0x89, 
  0x63, 0x14, 0xed, 0x57, 0xa4, 0x98, 0x94, 0x30, 0x51, 0xbd, 0x21, 0x0e, 
  0xa9, 0xf1, 0xc9, 0x6a, 0xbe, 0x54, 0x39, 0xe7, 0x0f, 0xff, 0x63, 0x82, 
  0xcc, 0x57, 0x22, 0xb3, 0xf6, 0xe3, 0x62, 0x9c, 0xa6, 0xb5, 0xb7, 0x8e, 
  0x16, 0xb8, 0x2a, 0xa2, 0xfd, 0xe1, 0xc1, 0xf1, 0xb1, 0x37, 0xd9, 0xdc, 
  0x89, 0x4e, 0xc0, 0xf3, 0x60, 0x75, 0x80, 0x56, 0x84, 0x2d, 0x59, 0x83, 
  0xe8, 0x35, 0x1b, 0xb1, 0xd8, 0xe8, 0x55, 0xaa, 0x78, 0xd7, 0x76, 0xda, 
  0x68, 0x7c, 0xc9, 0x82, 0x48, 0x63, 0x2c, 0x06, 0x18, 0x69, 0x86, 0x26, 
  0xc4, 0x46, 0x12, 0x10, 0x05, 0xdd, 0x92, 0x85, 0x10, 0x41, 0xe7, 0xf3, 
  0xf2, 0x61, 0x99, 0xbc, 0xda, 0x87, 0x84, 0x4a, 0x4d, 0xd6, 0xe7, 0x24, 
  0x4b, 0x43, 0x1d, 0xd1, 0xf8, 0x89, 0x42, 0x85, 0x23, 0xe2, 0x46, 0xe4, 
  0x5d, 0x9e, 0xb0, 0xbc, 0x25, 0xd7, 0x24, 0x93, 0x00, 0xab, 0xce, 0x10, 
  0xda, 0x59, 0x5b, 0xa4, 0x1b, 0xe5, 0xc9, 0x5e, 0x9d, 0xb5, 0x3c, 0x90, 
  0xf8, 0x31, 0x2f, 0x7e, 0x47, 0xc5, 0x41, 0xd6, 0xad, 0x41, 0x60, 0xa4, 
  0x15, 0x84, 0x82, 0x24, 0x24, 0x93, 0x35, 0xf7, 0x51, 0x55, 0x8e, 0x64, 
  0xda, 0xc4, 0xa9, 0xfc, 0x8a, 0x5f, 0xa9, 0xc9, 0x43, 0x5e, 0xb4, 0x6a, 
  0xee, 0xfe, 0x24, 0x99, 0xc6, 0xa4, 0xc3, 0x42, 0x46, 0x68, 0xcc, 0x65, 
  0x15, 0xcf, 0xe8, 0x70, 0x2d, 0x49, 0x08, 0x2c, 0x49, 0x03, 0xa5, 0x7b, 
  0x77, 0xb5, 0xe0, 0x9f, 0xa0, 0x72, 0x9c, 0x86, 0xb4, 0x6c, 0xea, 0x72, 
  0x50, 0xd7, 0xf2, 0x74, 0x92, 0x80, 0xf1, 0x07, 0xec, 0x1c, 0x64, 0xea, 
  0xb6, 0x46, 0x4e, 0x39, 0x1b, 0x96, 0xd8, 0xaa, 0xa5, 0xd7, 0x73, 0xbd, 
  0xb9, 0x76, 0x99, 0x78, 0xb3, 0x58, 0x11, 0xd7, 0xa4, 0x9b, 0xc5, 0x04, 
  0x35, 0x27, 0xbb, 0x45, 0x55, 0x99, 0xad, 0x7e, 0xe3, 0x10, 0x23, 0xdf, 
  0x1a, 0xa8, 0x0c, 0xf7, 0x88, 0xd4, 0x26, 0xda, 0xe5, 0xaf, 0x14, 0x42, 
  0x7e, 0xa3, 0x0c, 0xd2, 0x1f, 0xa7, 0xcb, 0x6b, 0x66, 0x03, 0x2f, 0x67, 
  0x69, 0x01, 0x53, 0x8a, 0x7e, 0xd0, 0x90, 0x43, 0x86, 0xc3, 0x13, 0xd3, 
  0x09, 0xc1, 0xca, 0x70, 0x75, 0xd8, 0xdb, 0x4a, 0x02, 0xa9, 0x59, 0x60, 
  0xcc, 0x02, 0x22, 0xbc, 0x9f, 0x9b, 0x6e, 0xea, 0x49, 0xee, 0x65, 0x91, 
  0xfe, 0xe4, 0xe6, 0xe4, 0xa9, 0xdc, 0xc6, 0xb3, 0x74, 0x62, 0xdf, 0x0e, 
  0xa2, 0x0b, 0xbe, 0x10, 0x56, 0x4b, 0x36, 0x3b, 0xb0, 0x35, 0x57, 0x3e, 
  0xaf, 0x35, 0x87, 0xc1, 0x07, 0x44, 0x05, 0x7b, 0x67, 0x85, 0xc9, 0x54, 
  0xae, 0x87, 0x34, 0xfc, 0x8e, 0x8e, 0xf7, 0x8b, 0x3a, 0x6f, 0x14, 0x83, 
  0xd5, 0xdd, 0xdd, 0xdd, 0x80, 0x84, 0xc6, 0x45, 0x51, 0xcc, 0x60, 0xb8, 
  0x9a, 0x64, 0xe3, 0x62, 0x9b, 0x74, 0xee, 0x62, 0xdb, 0x06, 0x57, 0x31, 
  0x51, 0xfd, 0x6a, 0x11, 0xb2, 0xca, 0x1f, 0x8d, 0x6e, 0x5b, 0x2e, 0x33, 
  0x18, 0xd4, 0x8a, 0xca, 0xb6, 0x65, 0x73, 0x22, 0xed, 0xa2, 0xa9, 0xaa, 
  0xe8, 0xf9, 0xbc, 0x30, 0x8d, 0x29, 0xf2, 0x4f, 0x3a, 0x6d, 0xa9, 0xe1, 
  0x39, 0x20, 0xfe, 0x77, 0x95, 0xe5, 0xc4, 0xd8, 0xe6, 0x45, 0x63, 0x61, 
  0xc5, 0x08, 0x6d, 0x7a, 0x9b, 0x68, 0x25, 0x79, 0x52, 0xae, 0x72, 0xd9, 
  0xeb, 0xd5, 0x22, 0xe8, 0x80, 0x16, 0x68, 0x35, 0x87, 0xd5, 0xd8, 0x56, 
  0xa1, 0x9d, 0x31, 0xda, 0x9a, 0xc8, 0xa9, 0x77, 0x72, 0x26, 0x2c, 0x0a, 
  0x2c, 0xb0, 0xd1, 0x6e, 0xad, 0x16, 0xde, 0x1e, 0x29, 0x3a, 0x3f, 0x2b, 
  0xf8, 0x75, 0xf1, 0xd3, 0x99, 0xe1, 0xf2, 0x84, 0x9f, 0x85, 0x82, 0x97, 
  0xe7, 0x59, 0x3e, 0xf8, 0x8d, 0x67, 0x4a, 0xcc, 0x97, 0xee, 0x28, 0xa9, 
  0x09, 0x29, 0xbb, 0xaa, 0x9f, 0x64, 0x36, 0x7d, 0xa5, 0xbc, 0x77, 0xdb, 
  0xd9, 0x74, 0x5a, 0xdd, 0x17, 0x90, 0x7e, 0x9f, 0xdb, 0x63, 0x2e, 0xff, 
  0x52, 0x38, 0x70, 0xe3, 0x38, 0xbd, 0x89, 0xef, 0xd3, 0xf9, 0x6a, 0x8e, 
  0x7e, 0xf9, 0xd8, 0xe8, 0x63, 0xc2, 0x96, 0x98, 0xbf, 0xc5, 0x7c, 0xb0, 
  0xf5, 0xbe, 0xf7, 0xe7, 0x49, 0x38, 0x5c, 0x93, 0x8d, 0xda, 0x02, 0xe2, 
  0x5b, 0x3a, 0xef, 0xce, 0x92, 0x21, 0xf2, 0xc9, 0x2c, 0x9d, 0xb3, 0x99, 
  0xa5, 0x7a, 0x36, 0xa3, 0xe5, 0x75, 0x5c, 0xd0, 0x3d, 0xc1, 0xf7, 0x75, 
  0x5d, 0xbc, 0xe3, 0x75, 0xa5, 0x6f, 0xed, 0xe9, 0xa4, 0xc1, 0x9c, 0x33, 
  0xc8, 0xe2, 0xb8, 0xf4, 0x69, 0x1d, 0x07, 0xec, 0x7c, 0x30, 0x99, 0xb5, 
  0x39, 0xba, 0xfe, 0x9c, 0x6e, 0xf2, 0x79, 0x7c, 0x8f, 0x55, 0x31, 0xa9, 
  0xf0, 0xf7, 0x3a, 0x36, 0x2a, 0x70, 0x07, 0x9b, 0x50, 0x93, 0x8e, 0x5e, 
  0x42, 0xb8, 0x61, 0x69, 0xbf, 0xbe, 0x09, 0xce, 0xc2, 0x95, 0x29, 0x3b, 
  0xc3, 0x93, 0xf0, 0xef, 0xc4, 0x74, 0x57, 0xdb, 0xe5, 0xc6, 0xb6, 0xbf, 
  0x04, 0x0e, 0x18, 0x93, 0xe3, 0xe2, 0x29, 0xab, 0x1f, 0x71, 0x53, 0x28, 
  0x5e, 0x92, 0x66, 0xc2, 0x04, 0xeb, 0x54, 0xcd, 0x81, 0x12, 0xa9, 0x34, 
  0x52, 0x44, 0x95, 0x66, 0x2a, 0xba, 0x57, 0x3c, 0x69, 0xd3, 0xb6, 0xe3, 
  0x40, 0xfc, 0xc4, 0xe8, 0x58, 0xa1, 0xb9, 0x63, 0x9b, 0xa6, 0xa8, 0x36, 
  0xfc, 0x8b, 0x35, 0xe7, 0x15, 0x38, 0xbc, 0x5b, 0x6b, 0xce, 0x0c, 0x32, 
  0xa0, 0x94, 0xcd, 0x62, 0x6b, 0xa0, 0xfa, 0x94, 0x9b, 0x13, 0x6d, 0xe5, 
  0xcd, 0x22, 0xbb, 0x23, 0x9d, 0x79, 0x91, 0x49, 0x5f, 0xb6, 0xbe, 0x3c, 
  0xf6, 0xfa, 0x09, 0x28, 0x93, 0x50, 0xb0, 0x0f, 0x9f, 0x2c, 0x9d, 0x08, 
  0x26, 0xd4, 0x6b, 0x92, 0xb8, 0x0d, 0xb4, 0xd5, 0x6a, 0xaa, 0x12, 0xb9, 
  0x1c, 0x54, 0xde, 0x01, 0xb9, 0xad, 0xbd, 0x14, 0x0e, 0x6d, 0x4d, 0xdc, 
  0x9f, 0x62, 0x79, 0x9e, 0xc4, 0xc5, 0x75, 0x2f, 0xea, 0xf4, 0x3b, 0xbd, 
  0x16, 0x8a, 0xab, 0x0b, 0xdc, 0x36, 0x2e, 0x27, 0x7e, 0xb5, 0xcb, 0xfe, 
  0x6a, 0x6e, 0xd0, 0x71, 0x32, 0xf1, 0x90, 0xa8, 0xd8, 0x2d, 0x03, 0xe3, 
  0x2d, 0x8b, 0x94, 0xbe, 0x31, 0xa1, 0xc7, 0xbb, 0xeb, 0x6c, 0xd6, 0x7a, 
  0x82, 0x02, 0x83, 0x43, 0xc6, 0xcd, 0xc0, 0xe4, 0x49, 0x0d, 0x40, 0x36, 
  0xaf, 0x71, 0xac, 0x68, 0x3c, 0x4b, 0xe2, 0x7c, 0xf6, 0xa0, 0xaa, 0x61, 
  0xfd, 0x04, 0xdd, 0xca, 0x54, 0xd8, 0x42, 0x1d, 0x13, 0x75, 0xe6, 0x0b, 
  0x5e, 0x5f, 0x92, 0xe6, 0x48, 0x23, 0x7a, 0x48, 0x26, 0xe2, 0xa3, 0x01, 
  0xef, 0x48, 0x55, 0x55, 0x94, 0x83, 0x1f, 0xdd, 0xa6, 0x45, 0x3a, 0x6a, 
  0xae, 0x76, 0x92, 0x4c, 0x46, 0xf1, 0xf8, 0x06, 0x2b, 0x8d, 0x36, 0x47, 
  0x10, 0x49, 0xaf, 0xe1, 0x82, 0x2c, 0xf8, 0x95, 0x07, 0x56, 0xb2, 0xaf, 
  0xe9, 0xe0, 0x15, 0x69, 0xb9, 0x8a, 0xd7, 0x9d, 0x58, 0xbd, 0x4b, 0x4d, 
  0xa8, 0x7a, 0xdf, 0xa1, 0xad, 0xd2, 0x72, 0x9b, 0x3e, 0xbe, 0xe6, 0x48, 
  0x1f, 0xe0, 0x48, 0x93, 0x24, 0xb6, 0x58, 0x91, 0x3e, 0x40, 0x6c, 0x95, 
  0xd8, 0x2e, 0x11, 0xc8, 0x17, 0x0d, 0x73, 0x84, 0x3c, 0xb2, 0x7d, 0x21, 
  0x9e, 0x5b, 0x6f, 0xde, 0xa8, 0x3a, 0x5f, 0x22, 0xa7, 0xe1, 0x5d, 0xa5, 
  0xbc, 0x17, 0x91, 0x34, 0xd7, 0x34, 0x4a, 0xd6, 0x9f, 0x88, 0xfc, 0xfa, 
  0x26, 0xf7, 0x31, 0x07, 0x39, 0x2c, 0x56, 0xf3, 0x11, 0x1b, 0x83, 0xa7, 
  0xa4, 0x32, 0xf0, 0x01, 0xc7, 0x26, 0xe8, 0x2c, 0xea, 0x4c, 0xfa, 0x26, 
  0x5d, 0x2e, 0x61, 0x50, 0x58, 0x2d, 0xca, 0xd0, 0xcc, 0x32, 0x4a, 0xae, 
  0xd2, 0xc5, 0x22, 0xf4, 0xcb, 0x65, 0x2b, 0xd2, 0x42, 0x64, 0xcc, 0xa3, 
  0x64, 0x0a, 0xad, 0xb0, 0x21, 0xeb, 0x62, 0x24, 0x3a, 0x21, 0xd6, 0x26, 
  0xed, 0x6a, 0x60, 0xd7, 0x6c, 0xa9, 0xca, 0xb9, 0x1c, 0x28, 0xec, 0x09, 
  0xf4, 0x16, 0xb5, 0xeb, 0xb5, 0x1d, 0x19, 0xf6, 0xa0, 0xeb, 0x35, 0x62, 
  0x4e, 0x9d, 0xe1, 0xf1, 0xff, 0x3d, 0xf2, 0xee, 0x26, 0xb3, 0x6c, 0x90, 
  0x6a, 0xc4, 0xd4, 0xdd, 0x20, 0x87, 0xb7, 0x24, 0x58, 0x74, 0xfa, 0x07, 
  0x51, 0xbf, 0x03, 0xf3, 0x54, 0xc5, 0xef, 0xb2, 0x2a, 0x33, 0x3a, 0xde, 
  0xec, 0xe8, 0x9c, 0x3d, 0x88, 0x2b, 0x99, 0xe9, 0x8d, 0xd5, 0xb5, 0x3c, 
  0xd9, 0xbe, 0xc6, 0x45, 0x97, 0x35, 0xf8, 0x95, 0x38, 0xdf, 0xb1, 0xd8, 
  0x36, 0x4f, 0x58, 0xb6, 0x4a, 0x75, 0xfc, 0xc8, 0x85, 0x26, 0xfb, 0x43, 
  0xcd, 0x91, 0xb2, 0xbd, 0x0d, 0x95, 0x5b, 0x1c, 0x56, 0x4d, 0xcd, 0x40, 
  0x8d, 0xdd, 0xd8, 0xa1, 0x36, 0x16, 0xf0, 0xfb, 0xdd, 0x40, 0x7d, 0xe1, 
  0x16, 0xa4, 0x15, 0xe4, 0xf5, 0x71, 0xc0, 0x6b, 0xa5, 0x8e, 0x31, 0xb6, 
  0x65, 0x10, 0x55, 0xff, 0x83, 0x64, 0x28, 0x35, 0x4b, 0x9a, 0x9b, 0x21, 
  0xd3, 0x41, 0xf4, 0x64, 0x09, 0xd1, 0x8d, 0xb4, 0xd9, 0x22, 0x1d, 0xd2, 
  0x0d, 0x4d, 0xe2, 0x57, 0x9c, 0xd3, 0x91, 0xcd, 0x68, 0x85, 0x89, 0x2d, 
  0xd0, 0x45, 0x50, 0x66, 0xf4, 0xf7, 0x75, 0x4a, 0x23, 0xcf, 0xc7, 0xd7, 
  0x0f, 0x7c, 0x59, 0xb0, 0x11, 0x95, 0x9d, 0x7e, 0x26, 0x18, 0xb4, 0xb9, 
  0x2f, 0xa4, 0x0f, 0x25, 0x71, 0x1e, 0x7d, 0xc4, 0xe2, 0x1c, 0x3d, 0x67, 
  0x04, 0x54, 0x1b, 0x1d, 0xd1, 0xc5, 0x35, 0xd3, 0x6d, 0x32, 0x63, 0x21, 
  0xe0, 0xb8, 0xcd, 0xae, 0xd3, 0xcf, 0x02, 0x06, 0x8e, 0x5d, 0x83, 0x2e, 
  0x92, 0x33, 0x23, 0x14, 0xa3, 0x98, 0x74, 0xc4, 0xa6, 0x64, 0xe9, 0x0b, 
  0xf7, 0x1a, 0x5f, 0x88, 0x0f, 0x75, 0xd7, 0x8f, 0xb8, 0xd4, 0xf4, 0xfd, 
  0xf7, 0xb9, 0xd5, 0x2e, 0x33, 0x9b, 0x8f, 0xbb, 0xfc, 0x6c, 0x65, 0x44, 
  0x81, 0x09, 0x4d, 0x05, 0xb4, 0xaf, 0xb4, 0x5e, 0xfd, 0x3e, 0x9d, 0x02, 
  0xdb, 0xbc, 0xba, 0xa6, 0x9a, 0xd6, 0x24, 0xf0, 0x7c, 0x36, 0x55, 0x57, 
  0x24, 0xb1, 0x1d, 0x22, 0x91, 0x32, 0x3a, 0x79, 0xcd, 0x64, 0x76, 0x70, 
  0x41, 0x3f, 0x69, 0x6b, 0xe5, 0xac, 0x31, 0x3f, 0x47, 0x68, 0x0b, 0x2b, 
  0xf7, 0x6f, 0xbe, 0x1b, 0x46, 0x9b, 0x67, 0xc3, 0xed, 0x27, 0xcf, 0x77, 
  0xb6, 0x7e, 0xbb, 0x36, 0x2f, 0x7e, 0x67, 0x76, 0xf0, 0x39, 0x7d, 0x9e, 
  0x07, 0xd3, 0xb8, 0x02, 0x31, 0x28, 0x9a, 0x5f, 0x30, 0xea, 0x09, 0xdb, 
  0x76, 0xd8, 0x18, 0xf1, 0xf2, 0x31, 0x5b, 0xf3, 0x50, 0xc4, 0x70, 0x71, 
  0xa1, 0x39, 0x96, 0x8d, 0xf7, 0x60, 0x0a, 0x3e, 0x3f, 0x1b, 0x5e, 0x3a, 
  0x9f, 0x4c, 0x60, 0x8a, 0x6e, 0x15, 0x4a, 0x7b, 0xf2, 0xce, 0x5d, 0xfc, 
  0x20, 0x27, 0x8f, 0x9d, 0x1f, 0xc9, 0x7c, 0xc5, 0xf1, 0x2b, 0x88, 0xa4, 
  0x98, 0xd2, 0x97, 0x88, 0xed, 0x61, 0x79, 0x93, 0x28, 0x65, 0x66, 0x27, 
  0xa3, 0x2e, 0x5e, 0x7d, 0x73, 0xf9, 0xe6, 0x44, 0x04, 0x05, 0x51, 0xb3, 
  0x4d, 0xe9, 0xc0, 0xca, 0xac, 0x46, 0x24, 0xe1, 0xf2, 0x2d, 0x58, 0x32, 
  0xd3, 0x83, 0xdf, 0x03, 0xbd, 0x39, 0x3b, 0x77, 0x43, 0x15, 0x81, 0x39, 
  0x06, 0x4c, 0x7c, 0x86, 0xe3, 0x51, 0x33, 0xf3, 0x11, 0x91, 0xa9, 0xaf, 
  0x88, 0xa3, 0x62, 0xf8, 0x80, 0x41, 0xa2, 0x91, 0x60, 0x0c, 0x96, 0xbb, 
  0xea, 0xb7, 0x57, 0x72, 0x27, 0x16, 0x62, 0x3a, 0xb1, 0x25, 0xae, 0x8b, 
  0xad, 0x41, 0x14, 0xd8, 0xc3, 0x69, 0x3b, 0x93, 0xfb, 0xa5, 0xca, 0xd2, 
  0x30, 0xfd, 0x74, 0xe8, 0x64, 0xf7, 0xc5, 0x9b, 0x39, 0xe9, 0xb4, 0xfa, 
  0xc3, 0xe4, 0xd8, 0xc7, 0x08, 0x2a, 0x50, 0x4e, 0xba, 0x6c, 0x73, 0x03, 
  0x38, 0xf1, 0xdf, 0x8b, 0x5d, 0x4d, 0x62, 0x20, 0x89, 0x85, 0xd4, 0x92, 
  0x07, 0x96, 0xc3, 0xd8, 0x6f, 0x3c, 0x53, 0xa3, 0xc6, 0xf6, 0x7d, 0x9f, 
  0xd4, 0xdc, 0x3e, 0x2f, 0x6b, 0x9f, 0xfa, 0xd0, 0xf1, 0x0c, 0x70, 0x99, 
  0xce, 0x97, 0x2c, 0x14, 0xb6, 0xf0, 0xe6, 0xfe, 0x6b, 0xa2, 0x23, 0x7e, 
  0x65, 0xb0, 0x8e, 0x6a, 0xbd, 0x39, 0x10, 0xfa, 0x85, 0x68, 0xe0, 0x32, 
  0x56, 0xe2, 0x03, 0x4d, 0xc1, 0x19, 0xf7, 0x8d, 0x5a, 0xf0, 0xbd, 0x6f, 
  0x22, 0x65, 0xce, 0x56, 0xd9, 0x19, 0x39, 0xf2, 0xf3, 0x24, 0xbf, 0xc2, 
  0x3a, 0x92, 0xec, 0xd2, 0x34, 0x06, 0x60, 0x8b, 0x62, 0x8b, 0x33, 0xc0, 
  0x8a, 0xfc, 0xa9, 0x2f, 0x2e, 0x03, 0x70, 0xbf, 0x15, 0xc7, 0x7e, 0xe9, 
  0x52, 0x75, 0xfb, 0x13, 0x91, 0x3c, 0x5e, 0x4d, 0xe2, 0x45, 0x9a, 0xcc, 
  0xf8, 0x8c, 0x34, 0xaf, 0xed, 0xd9, 0xec, 0xd5, 0x8c, 0x84, 0x88, 0x87, 
  0x2e, 0x35, 0x0e, 0xeb, 0x2a, 0x09, 0x4d, 0x8b, 0x04, 0x41, 0x0c, 0x30, 
  0x32, 0xb1, 0xff, 0x33, 0x1a, 0x5f, 0xaf, 0x16, 0x37, 0x66, 0x58, 0x9a, 
  0x91, 0x08, 0x59, 0x44, 0x08, 0x64, 0xab, 0x35, 0xd7, 0x0d, 0x7a, 0xfb, 
  0x53, 0xd8, 0x76, 0x1b, 0x43, 0x60, 0xf9, 0xac, 0x28, 0x39, 0x06, 0xca, 
  0x2d, 0x8a, 0x63, 0xc3, 0xea, 0x04, 0xf9, 0xb2, 0x67, 0x9e, 0xd0, 0xd2, 
  0x39, 0x21, 0x60, 0x6a, 0xad, 0x9f, 0x1f, 0x89, 0x6c, 0x70, 0x5e, 0x0f, 
  0xd8, 0xd9, 0x5d, 0xab, 0xe2, 0xd7, 0x20, 0x16, 0xd5, 0x37, 0x2f, 0x60, 
  0x45, 0x05, 0x6a, 0x51, 0x4f, 0x2a, 0xaf, 0x8a, 0xb7, 0x4d, 0xfd, 0x3f, 
  0x4a, 0x6c, 0x85, 0x49, 0x33, 0xe8, 0x58, 0x6c, 0x3c, 0xca, 0xd7, 0xa3, 
  0xa6, 0x70, 0x14, 0x1c, 0x06, 0x6a, 0xe6, 0x4d, 0x18, 0x33, 0x53, 0xf3, 
  0xc7, 0x1b, 0x35, 0x0c, 0xa2, 0xf3, 0x4c, 0xa2, 0x99, 0x78, 0x18, 0xed, 
  0xca, 0x93, 0xbb, 0x79, 0x26, 0x51, 0x77, 0x9a, 0x65, 0xa3, 0x38, 0xef, 
  0xea, 0x0e, 0xc2, 0x31, 0x4c, 0xcd, 0x4d, 0xe4, 0x1a, 0x87, 0x27, 0x16, 
  0xd3, 0x89, 0xbe, 0xa4, 0x07, 0xeb, 0xcc, 0x9f, 0x5e, 0xec, 0xb4, 0x5e, 
  0x30, 0xb2, 0xf5, 0x42, 0xad, 0x24, 0x5c, 0x10, 0x2b, 0x61, 0xbf, 0x48, 
  0xfe, 0xd0, 0x93, 0xad, 0x93, 0xed, 0x30, 0xf7, 0xb1, 0xf9, 0xcb, 0xa5, 
  0xa7, 0x46, 0x1f, 0x78, 0x71, 0x9d, 0x7a, 0xec, 0x59, 0xb7, 0xd8, 0x51, 
  0x25, 0x24, 0x08, 0x46, 0x48, 0x34, 0x06, 0x23, 0xf9, 0x6f, 0x14, 0x69, 
  0x4c, 0x61, 0x60, 0xee, 0x15, 0xb8, 0x35, 0x5b, 0x64, 0x44, 0x78, 0xe5, 
  0xe5, 0xfe, 0x41, 0xe8, 0x09, 0x66, 0x1e, 0xde, 0x8a, 0x7e, 0x2c, 0x8f, 
  0x5e, 0x31, 0x66, 0x10, 0xc6, 0xbe, 0xa6, 0xb1, 0x04, 0x4a, 0x61, 0x69, 
  0xdc, 0x34, 0xd7, 0x9b, 0x09, 0x9a, 0x4a, 0xc7, 0x5a, 0x41, 0x0d, 0x73, 
  0xf2, 0x53, 0xfa, 0xcd, 0x33, 0xd2, 0xbd, 0x79, 0xef, 0x94, 0x98, 0x1c, 
  0x8a, 0xe0, 0xa6, 0x2c, 0xd2, 0x79, 0x3a, 0x23, 0x35, 0x52, 0xc3, 0xca, 
  0x6a, 0xdb, 0x85, 0x58, 0xa1, 0x46, 0x60, 0xc5, 0x8c, 0x83, 0x68, 0xaf, 
  0xae, 0x43, 0x01, 0x25, 0xdc, 0x43, 0x9e, 0x16, 0xcb, 0x49, 0xb9, 0x1e, 
  0xb4, 0xfb, 0xd2, 0xce, 0x19, 0x77, 0xde, 0xb0, 0x07, 0x1a, 0xc9, 0xdc, 
  0x24, 0x4b, 0x52, 0xf3, 0x8a, 0x7e, 0x5a, 0x0c, 0x8c, 0xb1, 0xe0, 0x84, 
  0xf3, 0x9d, 0x92, 0xc1, 0x50, 0x68, 0x04, 0xa8, 0x8c, 0x42, 0x83, 0x79, 
  0x5b, 0x4e, 0x3d, 0xc2, 0x6a, 0x96, 0x7d, 0x7f, 0xe3, 0x69, 0x10, 0xaa, 
  0x8d, 0xa3, 0x32, 0x45, 0x93, 0x14, 0x35, 0xc0, 0xac, 0xa9, 0xf6, 0xf3, 
  0x50, 0xfe, 0x17, 0xd0, 0x2d, 0xec, 0xf7, 0xed, 0x3b, 0x2b, 0xbe, 0xa6, 
  0x42, 0x1c, 0x1c, 0x87, 0x62, 0xe8, 0x5f, 0xe7, 0xe1, 0x88, 0x83, 0x6f, 
  0x1a, 0x26, 0x13, 0xd9, 0x3e, 0xba, 0x1e, 0x58, 0x2b, 0x05, 0x87, 0xc4, 
  0xb6, 0xd1, 0x95, 0x7e, 0x97, 0xe5, 0xaa, 0x0f, 0x8e, 0x12, 0x9e, 0x03, 
  0x84, 0x13, 0x36, 0x08, 0x8b, 0x81, 0x81, 0x37, 0xbb, 0xe9, 0x83, 0x65, 
  0x83, 0x41, 0x04, 0xf7, 0xd1, 0x40, 0xb4, 0x2f, 0x73, 0xd6, 0x56, 0xdc, 
  0xb3, 0xee, 0xbe, 0x58, 0xb0, 0x89, 0x65, 0x16, 0xf5, 0x57, 0x1a, 0x0a, 
  0xd6, 0x6e, 0x9a, 0x45, 0x5c, 0x97, 0x86, 0x70, 0xe3, 0xae, 0x80, 0xa8, 
  0xa5, 0x43, 0x14, 0x3b, 0x1f, 0x38, 0xb1, 0xf9, 0x3e, 0x1e, 0xf1, 0x75, 
  0xe0, 0x55, 0x1f, 0x70, 0xc2, 0x7b, 0x6d, 0x71, 0xcb, 0x1a, 0x17, 0x1f, 
  0x3a, 0x43, 0x70, 0xd5, 0xfc, 0x6f, 0xf0, 0x88, 0xa8, 0x4c, 0xdd, 0x4f, 
  0x96, 0x79, 0xd9, 0x1a, 0x79, 0x78, 0x19, 0xaa, 0xb6, 0x26, 0x81, 0xc3, 
  0x16, 0x5e, 0xb8, 0x33, 0x70, 0x74, 0x7e, 0x71, 0x89, 0xf9, 0x9f, 0xf0, 
  0x2f, 0x2a, 0xe0, 0xd4, 0xc7, 0x81, 0x13, 0xae, 0x31, 0x4e, 0xec, 0xe8, 
  0x4f, 0xe0, 0xb4, 0x74, 0x11, 0xa2, 0x83, 0xc0, 0xbe, 0x2d, 0x9b, 0xc7, 
  0x92, 0xea, 0x8c, 0x24, 0xe9, 0x42, 0x28, 0xba, 0xb1, 0xe4, 0x2e, 0x14, 
  0x95, 0x47, 0xc2, 0x43, 0xe8, 0x89, 0xb2, 0x8c, 0x41, 0xa8, 0x21, 0x41, 
  0x38, 0xca, 0xf9, 0x19, 0x7f, 0xc9, 0x56, 0x23, 0xf3, 0xde, 0xaf, 0xb1, 
  0xd5, 0xf7, 0x22, 0xc4, 0x6d, 0x89, 0x07, 0x97, 0x9b, 0xe5, 0x37, 0xa3, 
  0x3c, 0xbd, 0xba, 0xa6, 0x43, 0x40, 0x43, 0x19, 0xd4, 0xa6, 0xca, 0x12, 
  0x23, 0x51, 0x64, 0x10, 0xa4, 0x6f, 0x62, 0x14, 0x34, 0x3b, 0x95, 0x58, 
  0x49, 0x05, 0xbb, 0x22, 0x02, 0x9d, 0x61, 0xc2, 0x16, 0x75, 0xde, 0x43, 
  0x24, 0x02, 0x9b, 0x1a, 0x10, 0x9b, 0xc5, 0x61, 0xa6, 0xdc, 0xa9, 0x08, 
  0xb7, 0xf5, 0xd1, 0xf1, 0xd0, 0x89, 0x0f, 0x8a, 0x37, 0x13, 0xd2, 0x66, 
  0x34, 0x55, 0x3d, 0x9a, 0x6e, 0x94, 0xf2, 0x41, 0xf8, 0xef, 0x48, 0x64, 
  0x24, 0x55, 0x3e, 0x84, 0x79, 0xd2, 0xfa, 0x4e, 0xd2, 0xb6, 0xb3, 0x49, 
  0xc3, 0xc1, 0xe4, 0x74, 0xb7, 0x1a, 0x9e, 0xba, 0x67, 0x5b, 0xbf, 0x8d, 
  0x4d, 0xb5, 0x3a, 0x15, 0xd6, 0x79, 0x15, 0xa4, 0xbd, 0x86, 0x5f, 0xc1, 
  0x13, 0x65, 0x71, 0xdb, 0x1e, 0x0e, 0x0b, 0xaa, 0xd4, 0x54, 0x12, 0xb6, 
  0x04, 0x39, 0x57, 0x6f, 0x83, 0x32, 0x87, 0xdf, 0x39, 0x89, 0xbb, 0x25, 
  0x8c, 0x4a, 0xe8, 0x91, 0x4f, 0xfc, 0x3a, 0x82, 0xd4, 0x09, 0x38, 0x92, 
  0x34, 0x9a, 0x7c, 0x94, 0x28, 0x5d, 0xa0, 0x0d, 0xfa, 0x57, 0x5a, 0x3c, 
  0xdf, 0x1f, 0x7e, 0x17, 0x50, 0x61, 0xb0, 0x96, 0x2e, 0x70, 0xb6, 0xae, 
  0x66, 0x11, 0x75, 0xb0, 0xa6, 0x2e, 0x54, 0xcc, 0x6d, 0x0d, 0xfe, 0xc7, 
  0x36, 0xa5, 0x16, 0x28, 0x21, 0x8e, 0x86, 0xba, 0x74, 0xf0, 0x3d, 0x9c, 
  0x07, 0xe0, 0xf3, 0x96, 0x5c, 0x11, 0x44, 0x5e, 0x54, 0x83, 0xcc, 0x11, 
  0x08, 0xb2, 0xd1, 0xa6, 0x09, 0x86, 0xc2, 0x8e, 0xc4, 0xe9, 0xe8, 0x21, 
  0x07, 0x0b, 0x09, 0x2f, 0x73, 0x89, 0x21, 0xe1, 0x76, 0xb5, 0x9b, 0xc6, 
  0x05, 0x1e, 0xf3, 0x65, 0x2f, 0x91, 0x63, 0x29, 0x1c, 0x02, 0xf0, 0x3b, 
  0x65, 0xb8, 0x87, 0x35, 0xa0, 0x4b, 0x03, 0x6f, 0xe4, 0x7e, 0x75, 0x71, 
  0x36, 0x08, 0x2c, 0x69, 0xca, 0x03, 0x0b, 0x51, 0x37, 0xa0, 0x4f, 0x58, 
  0x3c, 0x3d, 0xec, 0x14, 0x41, 0x7c, 0xb7, 0x8f, 0xa7, 0x80, 0x80, 0xe0, 
  0x43, 0x68, 0x5a, 0x79, 0xce, 0x1f, 0xa0, 0x46, 0xac, 0x89, 0x72, 0xe1, 
  0x15, 0xc8, 0xee, 0x12, 0x84, 0xbc, 0x45, 0x76, 0xc0, 0x71, 0xc2, 0x9b, 
  0x7a, 0xaa, 0x2c, 0x86, 0x3a, 0x03, 0x1a, 0x2b, 0x1b, 0x9a, 0xe2, 0xb2, 
  0x85, 0xc5, 0x87, 0x24, 0xa1, 0x25, 0xd4, 0x79, 0x4c, 0x45, 0xd2, 0x89, 
  0x45, 0xe8, 0x2a, 0xd2, 0x09, 0x67, 0xe9, 0xd4, 0x39, 0x12, 0x6e, 0xee, 
  0x8e, 0x2e, 0x57, 0x47, 0x9d, 0x9b, 0x2b, 0x79, 0x8b, 0x23, 0x71, 0xa0, 
  0x6e, 0xe5, 0xc9, 0x47, 0xb4, 0x3b, 0x26, 0xb4, 0x62, 0x79, 0xc2, 0x77, 
  0x1a, 0x51, 0xe3, 0xdb, 0x8b, 0x93, 0xc7, 0x0d, 0x3c, 0x88, 0x28, 0xbb, 
  0xd0, 0xc7, 0xcf, 0xe3, 0xab, 0xa4, 0x43, 0xbb, 0x25, 0x8e, 0x18, 0x95, 
  0x04, 0xde, 0x13, 0xd9, 0xfd, 0xe1, 0xb1, 0xd2, 0xd3, 0x59, 0x7c, 0x15, 
  0xc4, 0x46, 0xeb, 0xe2, 0x37, 0x03, 0x9c, 0x26, 0x16, 0x4d, 0x56, 0x0d, 
  0x24, 0x73, 0xe9, 0x27, 0x2a, 0xbd, 0x75, 0x3e, 0x67, 0x8b, 0x72, 0xc7, 
  0x86, 0xa8, 0x53, 0xae, 0xdb, 0xa3, 0x39, 0x6c, 0x27, 0x0b, 0x02, 0xe3, 
  0xaa, 0x56, 0x68, 0xc4, 0x9b, 0xe3, 0x58, 0xaa, 0x87, 0x80, 0x9f, 0xc7, 
  0x71, 0x22, 0xce, 0x43, 0x52, 0x44, 0x9d, 0x0f, 0x90, 0x54, 0x21, 0xb1, 
  0x84, 0x27, 0x3a, 0xaa, 0x17, 0x7a, 0x32, 0xc4, 0x0d, 0x66, 0x43, 0xd2, 
  0x90, 0x73, 0x1e, 0xac, 0x19, 0xcc, 0xe3, 0x19, 0x27, 0x22, 0xd5, 0x6d, 
  0x99, 0x6c, 0xb5, 0x76, 0x01, 0xb7, 0xec, 0x1d, 0xe2, 0x01, 0xc5, 0x9c, 
  0x43, 0x95, 0x22, 0x13, 0x45, 0x27, 0xf5, 0x31, 0xad, 0xd4, 0xc9, 0xe2, 
  0x8a, 0xd3, 0x36, 0x5e, 0xb6, 0xfa, 0x46, 0x93, 0x19, 0x92, 0x38, 0xc1, 
  0x02, 0xce, 0x68, 0xd5, 0x11, 0x7b, 0x91, 0x3f, 0x2c, 0x39, 0xc9, 0x47, 
  0xde, 0x53, 0x16, 0xc4, 0x72, 0x9d, 0xc4, 0x43, 0x78, 0x87, 0x57, 0x23, 
  0xbe, 0x9b, 0xc5, 0x53, 0xd7, 0xa1, 0x44, 0x6b, 0xf0, 0x85, 0xb0, 0xa4, 
  0xc5, 0x2a, 0xb1, 0xaa, 0xf2, 0x19, 0x87, 0x85, 0x8c, 0x56, 0xe9, 0x6c, 
  0x22, 0xae, 0x62, 0x9f, 0x93, 0xd4, 0x48, 0x02, 0xe0, 0x86, 0x38, 0x60, 
  0x3f, 0x0c, 0x71, 0x46, 0xde, 0x09, 0x64, 0x86, 0x4d, 0x4e, 0x99, 0x5b, 
  0xd0, 0xdc, 0xb7, 0xec, 0xda, 0xd3, 0x37, 0x34, 0xd8, 0xb1, 0x7e, 0x49, 
  0xdd, 0xc6, 0xa4, 0xa6, 0x21, 0xa3, 0xa2, 0x8c, 0xf2, 0xd5, 0x02, 0xbd, 
  0x57, 0x57, 0xea, 0x36, 0xcd, 0xb3, 0xc5, 0xbc, 0x19, 0x22, 0xb4, 0x79, 
  0x71, 0x3c, 0x3c, 0x88, 0xce, 0x86, 0xd1, 0xd9, 0xe9, 0xc9, 0x8f, 0x5b, 
  0xb4, 0x6c, 0x08, 0x28, 0xa2, 0x1b, 0xf3, 0x0a, 0x37, 0x6e, 0xf0, 0x62, 
  0x74, 0x1b, 0xe7, 0x29, 0x34, 0x89, 0xde, 0x7a, 0x43, 0x1d, 0x6f, 0x85, 
  0x9c, 0xcc, 0xfe, 0x9d, 0x6d, 0xb1, 0x8f, 0xbd, 0x40, 0x82, 0x55, 0x91, 
  0x32, 0xeb, 0x43, 0x78, 0x00, 0x0c, 0x94, 0xe2, 0x3b, 0x90, 0x1c, 0xca, 
  0x3a, 0xd1, 0xb2, 0xe1, 0x39, 0x3c, 0xd3, 0xe2, 0xb8, 0xbe, 0x8e, 0x6f, 
  0xb9, 0x7b, 0x9a, 0x68, 0xbb, 0x27, 0xe7, 0xbf, 0x4f, 0xac, 0x49, 0xae, 
  0x26, 0x7d, 0xa8, 0x9b, 0xad, 0x77, 0x27, 0xd8, 0xd5, 0x70, 0xcb, 0x3b, 
  0xea, 0x85, 0x1a, 0x97, 0x31, 0xdb, 0x67, 0xd5, 0x1f, 0x0c, 0x91, 0x66, 
  0x51, 0xe6, 0xd9, 0xf2, 0x21, 0xfa, 0x3a, 0x66, 0x06, 0xcb, 0x53, 0x3b, 
  0x8c, 0x93, 0x79, 0xc3, 0xb9, 0x51, 0x64, 0xe3, 0x9b, 0xa4, 0x94, 0xe3, 
  0x2a, 0xbf, 0x7b, 0x23, 0x3b, 0x6b, 0x3d, 0x6a, 0x4b, 0xe6, 0xcd, 0x9b, 
  0xf0, 0xed, 0xa7, 0xd4, 0x2a, 0xf9, 0x97, 0x44, 0xfe, 0x4d, 0x9b, 0xaa, 
  0xe5, 0x79, 0x05, 0x7a, 0x91, 0x28, 0xc0, 0xd2, 0x84, 0x4c, 0xad, 0x6e, 
  0xc8, 0xe8, 0x1f, 0xf1, 0xbd, 0xc6, 0xfe, 0x82, 0x97, 0xfc, 0x2f, 0x27, 
  0x10, 0x90, 0x4e, 0xf4, 0xd3, 0x0b, 0x53, 0xb2, 0x7e, 0x5e, 0xbb, 0x0c, 
  0x12, 0x73, 0xe7, 0x65, 0x3c, 0xb3, 0x27, 0x79, 0x09, 0x22, 0x68, 0x50, 
  0x1d, 0xf3, 0x4d, 0x36, 0x7b, 0xe5, 0xf2, 0x17, 0xd4, 0x75, 0x4f, 0xab, 
  0x89, 0x1e, 0x34, 0xc1, 0x37, 0x68, 0xc2, 0xc2, 0xf2, 0xd9, 0x1c, 0x7f, 
  0x7e, 0xf4, 0x06, 0x4b, 0xd1, 0x6f, 0x28, 0x53, 0xac, 0x7e, 0xfa, 0x94, 
  0x28, 0x99, 0x2e, 0x91, 0x89, 0x57, 0x6c, 0x69, 0x99, 0x99, 0xc1, 0xf9, 
  0x71, 0x86, 0x69, 0x51, 0x8d, 0x7c, 0x1c, 0x4e, 0xb8, 0x9c, 0x60, 0xd1, 
  0xd5, 0xda, 0x41, 0x24, 0x3b, 0x67, 0x65, 0xa1, 0x6a, 0xd7, 0xe7, 0xab, 
  0x27, 0x18, 0xaa, 0x39, 0x66, 0xeb, 0xf1, 0xee, 0x39, 0xe2, 0xa7, 0xa3, 
  0x9b, 0xe4, 0xc1, 0x45, 0x1b, 0xd9, 0x67, 0xe1, 0xeb, 0xb4, 0x99, 0xfc, 
  0x73, 0xc1, 0xda, 0xe9, 0x1f, 0x3e, 0xa6, 0x63, 0x90, 0xfa, 0x14, 0x2b, 
  0xfc, 0x4b, 0xfe, 0xb7, 0x3d, 0xca, 0x2e, 0x88, 0xad, 0xbc, 0x83, 0xcb, 
  0x24, 0x18, 0x28, 0xde, 0x55, 0x71, 0xf2, 0x36, 0x65, 0xf5, 0x24, 0xfc, 
  0xba, 0xe9, 0x22, 0x66, 0xab, 0x2c, 0x6d, 0x5d, 0x2f, 0x3a, 0x3c, 0xba, 
  0xc0, 0x0a, 0x1c, 0x9d, 0x7e, 0x0d, 0x89, 0x84, 0xc3, 0xc4, 0xaf, 0x16, 
  0xe9, 0x2f, 0x4c, 0xf5, 0xd4, 0x66, 0xf1, 0x51, 0xdd, 0xa1, 0xb1, 0xd0, 
  0xfb, 0xc1, 0x7e, 0x38, 0xd8, 0x75, 0x74, 0xde, 0x0c, 0x2d, 0x7d, 0x0f, 
  0x91, 0xd3, 0x53, 0x34, 0xa6, 0x3a, 0x61, 0x5a, 0xee, 0xda, 0x32, 0xb1, 
  0x3b, 0x5a, 0x0c, 0xd1, 0x74, 0x01, 0xb0, 0xe1, 0x8c, 0xdd, 0x67, 0x2e, 
  0x7d, 0xb2, 0x3a, 0x30, 0xa4, 0x4b, 0x36, 0x9c, 0x14, 0xfe, 0xfb, 0xcd, 
  0x62, 0x2b, 0x3c, 0x1a, 0x7c, 0x32, 0xd6, 0x44, 0x94, 0xbb, 0x80, 0x7c, 
  0xac, 0x74, 0xa1, 0x37, 0x51, 0xf3, 0x4a, 0x50, 0x1b, 0x75, 0xd4, 0x3d, 
  0x20, 0x29, 0xe4, 0xdd, 0xc1, 0xfe, 0xbb, 0xaf, 0xde, 0x9e, 0x1e, 0x9e, 
  0x1c, 0x75, 0x1b, 0x53, 0xb2, 0xab, 0x4e, 0xa2, 0xae, 0x7b, 0x96, 0x86, 
  0x15, 0xba, 0xc2, 0xc1, 0x1e, 0x91, 0x0d, 0x82, 0xdf, 0x10, 0x33, 0xa3, 
  0xf3, 0x6b, 0xe8, 0xd0, 0x8b, 0x09, 0x42, 0xcf, 0x83, 0x6d, 0xb6, 0x28, 
  0x44, 0x8d, 0x64, 0xb0, 0x01, 0xb6, 0xa8, 0x25, 0xbc, 0xdd, 0xc4, 0xe5, 
  0x48, 0x2a, 0x62, 0xf5, 0x5c, 0xef, 0x20, 0xef, 0xae, 0xae, 0x4a, 0x5b, 
  0x70, 0x88, 0x58, 0x2a, 0x7b, 0x44, 0xe3, 0x69, 0x59, 0xdd, 0xa2, 0x62, 
  0xae, 0xe7, 0x96, 0x88, 0x70, 0xfa, 0x3a, 0xc8, 0x71, 0x5e, 0x76, 0xe9, 
  0xce, 0x49, 0x99, 0xc3, 0xbb, 0xac, 0x3f, 0xbe, 0x03, 0xe0, 0xd3, 0x6d, 
  0xa8, 0xf3, 0xec, 0xfd, 0x8e, 0x85, 0x88, 0x06, 0xc9, 0x7d, 0x02, 0xd7, 
  0x86, 0xbe, 0x75, 0x80, 0x0b, 0xab, 0x8c, 0xbe, 0xcf, 0x72, 0xe4, 0x91, 
  0x1d, 0x9a, 0xbb, 0xdc, 0x1e, 0x8a, 0x17, 0x0f, 0x0d, 0x33, 0xe5, 0x6c, 
  0x82, 0x4b, 0x37, 0xa3, 0xe7, 0x91, 0xc3, 0x7f, 0xbe, 0x7f, 0xf9, 0xcd, 
  0xc7, 0x3d, 0x31, 0xd8, 0xbc, 0xda, 0x89, 0xf1, 0xae, 0xfd, 0xdf, 0xe3, 
  0xec, 0xf8, 0x38, 0x81, 0x86, 0xe2, 0x44, 0x03, 0x6e, 0x1e, 0x9f, 0xf0, 
  0x84, 0xb4, 0xd3, 0x7f, 0xcf, 0x78, 0x6c, 0xd3, 0x77, 0xae, 0x3d, 0xe1, 
  0xb5, 0x6b, 0x4e, 0x4b, 0x18, 0x25, 0x4c, 0xab, 0xe2, 0x5a, 0x4d, 0x26, 
  0x95, 0x88, 0xb1, 0xf1, 0xbb, 0x3c, 0xb9, 0x8e, 0x0b, 0x52, 0x03, 0x56, 
  0x65, 0xca, 0xc6, 0x9c, 0xfa, 0x45, 0xbe, 0x62, 0xff, 0xa5, 0x57, 0x16, 
  0x2c, 0x46, 0x37, 0xd2, 0xb4, 0x1a, 0xbf, 0x7e, 0xa2, 0x9c, 0xb0, 0xa8, 
  0x64, 0x4b, 0xc2, 0xea, 0x40, 0x4b, 0xb4, 0x6f, 0x51, 0x49, 0xdb, 0x9e, 
  0x73, 0x80, 0x37, 0x8c, 0x4a, 0xc9, 0x94, 0x26, 0xcc, 0x29, 0x6a, 0x33, 
  0xb5, 0x20, 0xad, 0x7c, 0x0f, 0xe0, 0x69, 0x74, 0x26, 0xdb, 0x82, 0x1e, 
  0xec, 0x6b, 0x50, 0xb4, 0xb2, 0x9b, 0x42, 0x52, 0xbb, 0xeb, 0xbc, 0xe6, 
  0xe3, 0x51, 0xd1, 0x94, 0xbd, 0xb4, 0x24, 0xd9, 0xb6, 0x6b, 0x81, 0xaf, 
  0x39, 0x1a, 0xad, 0xa0, 0xf1, 0x61, 0x72, 0x9b, 0x8b, 0x4c, 0x83, 0x68, 
  0x58, 0x06, 0xa6, 0x35, 0xdb, 0xe2, 0xeb, 0xd7, 0x1c, 0xcb, 0x08, 0x51, 
  0x2b, 0xda, 0x93, 0x1d, 0x90, 0xc2, 0x94, 0x15, 0xa5, 0x25, 0x8e, 0x03, 
  0xbc, 0x03, 0x33, 0x80, 0x9f, 0x1b, 0xfa, 0xb9, 0x1a, 0xea, 0x00, 0x19, 
  0x41, 0xe7, 0x3c, 0x29, 0xc7, 0xfe, 0xcb, 0x46, 0x46, 0x40, 0x3c, 0x93, 
  0x7d, 0x9d, 0x0a, 0xd2, 0x84, 0x5a, 0x90, 0xd8, 0x6f, 0xb1, 0x30, 0x23, 
  0xf6, 0x38, 0x2e, 0x2c, 0x84, 0x83, 0xd9, 0x89, 0x24, 0x04, 0xc9, 0x60, 
  0xeb, 0x47, 0x57, 0x22, 0xc1, 0xd9, 0x52, 0x9b, 0xcc, 0x52, 0xb1, 0x1a, 
  0x58, 0x98, 0x32, 0xc4, 0x10, 0x89, 0x65, 0x2e, 0x60, 0x13, 0x79, 0x73, 
  0xe2, 0xbe, 0x63, 0xb7, 0x6b, 0xd9, 0x0c, 0xc4, 0x23, 0x09, 0x6f, 0x53, 
  0x62, 0x45, 0xb3, 0x29, 0xc7, 0x00, 0x42, 0xe6, 0x13, 0x2c, 0x8c, 0x11, 
  0x46, 0xf4, 0xe0, 0xd1, 0x42, 0xb6, 0x5c, 0xac, 0x0d, 0xd4, 0xdf, 0x36, 
  0x73, 0x96, 0x3a, 0x02, 0x84, 0x3a, 0x05, 0xe4, 0x05, 0x7b, 0x50, 0x8a, 
  0xa9, 0x24, 0x96, 0xc4, 0x88, 0x69, 0x65, 0xa7, 0xd4, 0x9b, 0xf8, 0x6b, 
  0x3c, 0x63, 0x1f, 0x14, 0x44, 0xd2, 0xb0, 0xd7, 0x72, 0x7f, 0xe8, 0x7b, 
  0x95, 0x57, 0x94, 0x21, 0x8e, 0x91, 0x89, 0xc7, 0x88, 0x62, 0x8b, 0x7e, 
  0x62, 0x47, 0xca, 0xcf, 0xad, 0x16, 0x49, 0x98, 0x57, 0x34, 0x2f, 0xdf, 
  0xe5, 0x28, 0xde, 0x88, 0xab, 0xaf, 0x63, 0xef, 0xf3, 0xeb, 0x1d, 0x55, 
  0x4b, 0x9c, 0xcf, 0xa1, 0x25, 0xd5, 0xd8, 0x0b, 0x93, 0x1c, 0x26, 0x62, 
  0xbc, 0x03, 0x02, 0x90, 0xfa, 0x96, 0xcc, 0xd1, 0x25, 0xae, 0x93, 0xe9, 
  0xd4, 0xdb, 0x9b, 0x6a, 0xcd, 0xed, 0x1f, 0x1c, 0xac, 0xb3, 0xf1, 0x3e, 
  0x19, 0xec, 0x6c, 0xfd, 0x67, 0x61, 0x39, 0x2e, 0xf9, 0x44, 0x34, 0x95, 
  0xbc, 0xa1, 0x91, 0x89, 0xad, 0x61, 0x55, 0x34, 0x56, 0x74, 0x7d, 0xc8, 
  0x58, 0x88, 0x77, 0x80, 0xd8, 0x78, 0x5e, 0x51, 0x92, 0x13, 0xb6, 0x7d, 
  0x7c, 0x29, 0x44, 0x00, 0xbb, 0xf0, 0x99, 0x6c, 0x0c, 0x85, 0x80, 0x08, 
  0xab, 0xdf, 0x08, 0xac, 0x03, 0x19, 0x21, 0x98, 0xca, 0x44, 0x6c, 0x0b, 
  0xd5, 0x91, 0x5c, 0x7a, 0x5a, 0x98, 0x38, 0xe7, 0x84, 0x3b, 0x56, 0x14, 
  0xb3, 0xdc, 0xdd, 0xeb, 0x10, 0xb1, 0xb3, 0x96, 0x03, 0xe6, 0x39, 0x6f, 
  0x48, 0x80, 0xbd, 0x28, 0x10, 0x07, 0xcc, 0x07, 0x1e, 0x38, 0x29, 0x5a, 
  0x03, 0xda, 0xe6, 0xa9, 0x44, 0xda, 0x04, 0xa1, 0x5a, 0x0d, 0x43, 0xfc, 
  0x5f, 0x7f, 0xe5, 0x26, 0x59, 0x90, 0x0c, 0xb6, 0x49, 0xf5, 0x54, 0x21, 
  0xfd, 0xdf, 0x44, 0xfb, 0x44, 0x8a, 0x6b, 0x6c, 0xf0, 0x70, 0xc2, 0xb1, 
  0x51, 0x5b, 0x58, 0x93, 0x8b, 0xce, 0xe4, 0x20, 0x2c, 0xf9, 0x5c, 0x9d, 
  0xf7, 0x00, 0x47, 0x62, 0x25, 0x49, 0xf3, 0x9f, 0x1a, 0xa6, 0x44, 0x59, 
  0x79, 0xb1, 0x8d, 0x37, 0x7d, 0xc0, 0xa1, 0x75, 0x89, 0x16, 0xd2, 0x11, 
  0x9d, 0xc6, 0xbb, 0xd6, 0x77, 0x9c, 0x29, 0x4e, 0x87, 0xce, 0x21, 0xc7, 
  0x96, 0x96, 0x59, 0x59, 0xd5, 0xdd, 0x76, 0xd2, 0xff, 0xef, 0xe3, 0x28, 
  0x74, 0x81, 0xb7, 0x2e, 0xea, 0x9b, 0xf8, 0x46, 0x4e, 0x13, 0x53, 0x7d, 
  0x90, 0xbd, 0x50, 0xd0, 0x1d, 0x31, 0xbe, 0x36, 0x29, 0x87, 0xf4, 0xa6, 
  0xed, 0xcb, 0x93, 0xa1, 0x4b, 0x91, 0x8f, 0x9a, 0xfe, 0xd2, 0xff, 0x9e, 
  0x49, 0x72, 0x53, 0xc1, 0xd4, 0x2c, 0x50, 0x4a, 0x33, 0xbc, 0x35, 0x34, 
  0xe6, 0xb1, 0x10, 0x82, 0x19, 0x5b, 0x90, 0x70, 0x6e, 0x5c, 0x94, 0x9c, 
  0x85, 0xc5, 0x51, 0xa7, 0x68, 0x8b, 0x7e, 0xca, 0x1d, 0xc4, 0x77, 0x5f, 
  0x8b, 0x2b, 0x97, 0x59, 0xa4, 0x0b, 0x8f, 0x53, 0xe2, 0x97, 0x00, 0x39, 
  0x17, 0x21, 0xa7, 0xa6, 0x5b, 0xf0, 0x0d, 0x13, 0x8d, 0x10, 0xd6, 0xd7, 
  0x12, 0x4b, 0xe3, 0x0d, 0xf7, 0x07, 0x1a, 0x46, 0x76, 0xc9, 0x4a, 0xa8, 
  0x28, 0x4f, 0x71, 0x5e, 0x6e, 0x23, 0x78, 0x0c, 0xfc, 0x97, 0xd9, 0x7a, 
  0x3e, 0x51, 0x7c, 0x90, 0x8b, 0xd7, 0x07, 0xbb, 0x9f, 0x7d, 0xfa, 0xd7, 
  0x56, 0xab, 0xb1, 0x4a, 0x04, 0x45, 0x98, 0xb6, 0xcf, 0x31, 0xd4, 0x12, 
  0x82, 0x20, 0x51, 0x3f, 0x24, 0x25, 0x20, 0x2d, 0x16, 0x29, 0x99, 0xe8, 
  0xbf, 0x1b, 0xa2, 0xdc, 0xf8, 0x44, 0x84, 0xb2, 0x2b, 0x38, 0x51, 0x12, 
  0x57, 0x27, 0x76, 0x8d, 0x1e, 0x2f, 0xc0, 0x34, 0xbd, 0xf7, 0x11, 0x48, 
  0x1a, 0x5f, 0xce, 0xca, 0xd1, 0x22, 0xfa, 0x32, 0x62, 0xec, 0xb2, 0x41, 
  0x13, 0x5e, 0xe4, 0x1f, 0x2c, 0xa0, 0x5e, 0xa9, 0x6d, 0x58, 0xb7, 0x4b, 
  0x5a, 0x0f, 0x42, 0x8a, 0x1e, 0x69, 0xbc, 0x45, 0x18, 0xd4, 0x40, 0xad, 
  0x97, 0x22, 0x45, 0x7b, 0xa7, 0xb3, 0x01, 0xe3, 0xd0, 0x60, 0x70, 0xc5, 
  0xbd, 0x74, 0x46, 0x0c, 0x97, 0x9f, 0xf8, 0x65, 0x8b, 0xe7, 0xda, 0x67, 
  0xb4, 0x47, 0x12, 0xbb, 0x5f, 0x96, 0xb1, 0x61, 0x19, 0x59, 0x18, 0x88, 
  0xe8, 0x7f, 0x92, 0xd5, 0xab, 0x90, 0x38, 0x44, 0x31, 0xb3, 0xb6, 0xe8, 
  0xe1, 0x97, 0xda, 0x68, 0x2c, 0x89, 0xa8, 0xa4, 0x25, 0xcc, 0x24, 0x31, 
  0xab, 0x6d, 0x25, 0x2c, 0x50, 0x87, 0x2d, 0x30, 0xc9, 0x7d, 0xd9, 0x08, 
  0xb3, 0xe0, 0x77, 0x83, 0x75, 0x6a, 0xc8, 0x28, 0x47, 0xf7, 0x31, 0xe7, 
  0xc8, 0xf4, 0x22, 0x87, 0x1f, 0x03, 0x6d, 0xca, 0x87, 0x40, 0xa8, 0x3a, 
  0x1f, 0xde, 0x49, 0x08, 0x12, 0x8f, 0xba, 0xfc, 0x4c, 0x7d, 0xef, 0xf9, 
  0x9d, 0xae, 0xf1, 0x54, 0x6c, 0x81, 0x85, 0x9c, 0x31, 0x45, 0xca, 0x70, 
  0x5c, 0x72, 0xcf, 0x36, 0xd1, 0xd3, 0x36, 0x7a, 0x9a, 0xac, 0xb1, 0x3d, 
  0x09, 0x67, 0x26, 0xf1, 0xeb, 0x45, 0xab, 0x1e, 0xdf, 0x7f, 0xed, 0x06, 
  0xfa, 0xea, 0xcb, 0x4a, 0x6b, 0x77, 0x77, 0x83, 0xf9, 0x83, 0x7d, 0x57, 
  0x54, 0x80, 0xc6, 0x82, 0x58, 0x31, 0xf1, 0x90, 0x19, 0xc9, 0x74, 0x0b, 
  0x47, 0x5e, 0x3e, 0x82, 0xce, 0x5d, 0x93, 0x0c, 0x43, 0xa6, 0xa4, 0xc6, 
  0xec, 0xad, 0xdf, 0x8c, 0x1c, 0x50, 0x2f, 0x9f, 0xa7, 0x3e, 0x09, 0x36, 
  0xeb, 0xaa, 0x6a, 0xa5, 0x47, 0xfc, 0x2a, 0x4b, 0x64, 0xcf, 0x46, 0x19, 
  0x11, 0xfe, 0x97, 0x2a, 0x4c, 0xbd, 0x6c, 0x9a, 0x32, 0x8b, 0x32, 0x5f, 
  0x8d, 0xcb, 0xa6, 0x36, 0xc2, 0xb8, 0x5b, 0xb8, 0x6f, 0x2c, 0xbb, 0x2b, 
  0x70, 0x33, 0xc3, 0x38, 0x55, 0x65, 0x0a, 0xce, 0xcd, 0x6b, 0x0e, 0xbf, 
  0x7a, 0xf4, 0x23, 0xf2, 0xa6, 0xbb, 0x1a, 0x14, 0xac, 0x61, 0x51, 0x16, 
  0x25, 0x55, 0x66, 0x6b, 0x17, 0xbe, 0x73, 0x97, 0x8c, 0x5e, 0x7d, 0x99, 
  0x2e, 0x26, 0xc9, 0x3d, 0x92, 0x2e, 0x25, 0xff, 0x9a, 0x69, 0x70, 0x9b, 
  0xff, 0xec, 0x70, 0xfc, 0x60, 0xdb, 0xba, 0x67, 0xf9, 0xda, 0x16, 0x83, 
  0x38, 0xcc, 0xa0, 0xb5, 0x69, 0x96, 0xad, 0x6d, 0xcc, 0x30, 0xc8, 0xb0, 
  0x12, 0xc9, 0x3d, 0xc7, 0xd0, 0xa6, 0x2c, 0x4a, 0x8d, 0xaf, 0x61, 0xee, 
  0x77, 0x44, 0x28, 0x84, 0xc7, 0x5b, 0xb8, 0xd0, 0x73, 0x2a, 0x87, 0xb0, 
  0x2e, 0xfc, 0x33, 0x57, 0x19, 0x3d, 0x38, 0x40, 0x19, 0x7e, 0x14, 0x83, 
  0xea, 0x79, 0x1d, 0x6a, 0xfd, 0x82, 0xf0, 0xd3, 0xaf, 0xbe, 0x44, 0xc4, 
  0x3f, 0xff, 0xfa, 0xb9, 0x7b, 0x9b, 0xff, 0x21, 0x2a, 0x26, 0x2e, 0xb0, 
  0x76, 0x22, 0x6c, 0xad, 0x9e, 0xae, 0x72, 0xd8, 0x52, 0x12, 0x39, 0x92, 
  0x05, 0x28, 0xc3, 0x32, 0x67, 0x95, 0x95, 0xbc, 0xd9, 0x3f, 0x7d, 0xbb, 
  0x7f, 0xd2, 0xee, 0x92, 0x6e, 0x11, 0x45, 0x9c, 0x39, 0x0d, 0x3a, 0x6a, 
  0xe5, 0x82, 0xe7, 0xf3, 0xa8, 0xae, 0x31, 0xb9, 0x09, 0x1f, 0x85, 0x9e, 
  0x8a, 0x86, 0x4a, 0x11, 0x20, 0x27, 0xbd, 0x41, 0x93, 0xfb, 0x31, 0xc7, 
  0xb0, 0xb9, 0xb0, 0xee, 0xdb, 0x78, 0xb6, 0x32, 0xe4, 0x27, 0x8b, 0x1f, 
  0x6c, 0xf1, 0xa6, 0x70, 0xf4, 0x52, 0x4e, 0x3f, 0x43, 0xc0, 0x90, 0x59, 
  0xca, 0xd8, 0x94, 0x33, 0xce, 0xb6, 0x3a, 0x51, 0x5c, 0xbd, 0xee, 0x97, 
  0x5d, 0x39, 0x1b, 0xdd, 0x97, 0x5d, 0x8e, 0xe5, 0xa5, 0x77, 0x9a, 0x56, 
  0x25, 0x40, 0x0a, 0x99, 0x19, 0xb9, 0x2b, 0x54, 0xd3, 0xb5, 0x21, 0xe8, 
  0x9a, 0xc9, 0xb0, 0x60, 0xe2, 0x20, 0x95, 0x1a, 0x96, 0x17, 0xc6, 0x95, 
  0x4b, 0xe2, 0xc6, 0xcd, 0x05, 0xa9, 0xf0, 0xad, 0x03, 0x5f, 0x5b, 0xe0, 
  0x52, 0xd1, 0xab, 0xa1, 0xcc, 0x6c, 0xda, 0x92, 0x23, 0x91, 0x33, 0xbf, 
  0x60, 0xeb, 0x81, 0xa4, 0x67, 0xb5, 0x59, 0x45, 0x02, 0xdc, 0x0a, 0xc3, 
  0xbd, 0x92, 0xb1, 0xb0, 0xc5, 0x93, 0x2e, 0xe6, 0x94, 0xf1, 0x1c, 0x61, 
  0x8c, 0xa3, 0x6f, 0xaf, 0xae, 0x34, 0xb6, 0x8c, 0xe7, 0x4d, 0x6b, 0x47, 
  0xb3, 0x6e, 0xe4, 0x88, 0x29, 0x7a, 0x25, 0xd1, 0xb1, 0x06, 0x7b, 0xfb, 
  0x0d, 0xbd, 0x22, 0xb1, 0xe6, 0x6a, 0x96, 0x8d, 0x48, 0xcf, 0x7a, 0x84, 
  0x36, 0x44, 0x44, 0x43, 0x13, 0xc2, 0x96, 0x3b, 0xec, 0x63, 0xe5, 0xf7, 
  0x46, 0x12, 0x63, 0x02, 0x14, 0x93, 0x81, 0x68, 0x36, 0x88, 0x97, 0x4d, 
  0xca, 0x16, 0x71, 0xca, 0xeb, 0x13, 0x0f, 0x35, 0x10, 0x40, 0xc0, 0xfe, 
  0x49, 0x56, 0x81, 0x5a, 0x74, 0xfd, 0x7d, 0x5b, 0x44, 0xff, 0xfa, 0xf7, 
  0x4f, 0x3f, 0xb7, 0x84, 0x86, 0x73, 0xe6, 0x91, 0x7a, 0xc0, 0xe8, 0x69, 
  0x8b, 0xb8, 0x83, 0x44, 0x4e, 0x1b, 0x50, 0xfa, 0x0c, 0x27, 0x45, 0xbe, 
  0x1a, 0x04, 0x3e, 0xc6, 0xe6, 0x85, 0xc1, 0x12, 0xbf, 0x75, 0xc8, 0x66, 
  0x75, 0xf6, 0x41, 0xaa, 0x91, 0x62, 0x96, 0x5c, 0xd1, 0xbf, 0x3c, 0x65, 
  0x77, 0x7b, 0x4a, 0x9a, 0x5e, 0xf2, 0xa0, 0xcc, 0xba, 0x21, 0xf6, 0x2b, 
  0xba, 0xd9, 0xa4, 0x2a, 0x48, 0x01, 0x81, 0xed, 0xe2, 0xd8, 0x69, 0x66, 
  0xc1, 0x46, 0x7c, 0xcd, 0x1b, 0xd1, 0x58, 0x35, 0x07, 0x8d, 0xd7, 0xab, 
  0xcb, 0xb6, 0xa2, 0xfc, 0xc0, 0x27, 0x2e, 0x9e, 0x52, 0x89, 0x79, 0xf6, 
  0x06, 0xc2, 0x36, 0x21, 0xc6, 0x07, 0xe5, 0x32, 0xa9, 0xd4, 0x62, 0x62, 
  0x71, 0x44, 0x1d, 0xd8, 0x1f, 0xd8, 0x3a, 0xcc, 0x31, 0x5f, 0x1f, 0xb9, 
  0x1c, 0x91, 0x35, 0x68, 0x5a, 0x7a, 0x57, 0x57, 0xb3, 0x49, 0x90, 0x9c, 
  0xc5, 0x04, 0x7f, 0x07, 0x98, 0x27, 0x1f, 0xce, 0x0e, 0xdb, 0x56, 0xd4, 
  0x62, 0x98, 0xd7, 0xa8, 0x78, 0xb1, 0x80, 0x49, 0x80, 0x40, 0x32, 0xf1, 
  0xcb, 0x76, 0x62, 0xf9, 0x00, 0xdd, 0xbf, 0x75, 0x1d, 0xf8, 0xe0, 0x9a, 
  0x0c, 0xf1, 0x30, 0x2d, 0xab, 0x16, 0x41, 0xd9, 0x3f, 0xee, 0xf9, 0xd1, 
  0xfa, 0x2e, 0x6d, 0x2e, 0x4d, 0x97, 0xf2, 0xfa, 0x81, 0x7c, 0x73, 0xb4, 
  0x7f, 0x68, 0x13, 0x6e, 0x1b, 0x46, 0x0b, 0x2f, 0xf5, 0x99, 0x56, 0xc6, 
  0x50, 0xae, 0xd1, 0x41, 0xc8, 0x64, 0xaf, 0x11, 0x6e, 0x31, 0x5b, 0x36, 
  0x3c, 0xef, 0xf1, 0x15, 0x07, 0x03, 0xcd, 0x96, 0xc1, 0xb3, 0x41, 0x68, 
  0xc6, 0x4b, 0xf9, 0xb9, 0x86, 0x13, 0x1f, 0x21, 0x05, 0x46, 0x1f, 0x0d, 
  0x63, 0x8e, 0xcc, 0x8b, 0xc8, 0xb2, 0x28, 0xdd, 0xcd, 0x7c, 0x9b, 0x5d, 
  0x71, 0x60, 0x07, 0xe4, 0x05, 0xe2, 0x38, 0x75, 0xdd, 0x2f, 0x80, 0xed, 
  0xf4, 0x29, 0x93, 0x49, 0xd0, 0x7a, 0x11, 0xba, 0xf7, 0x34, 0x30, 0xc2, 
  0x20, 0xbf, 0x26, 0x0d, 0x74, 0x24, 0x3a, 0xa0, 0x45, 0x49, 0x52, 0x93, 
  0x8d, 0x8c, 0x5f, 0x62, 0xb5, 0xc7, 0xb9, 0x05, 0x16, 0x1a, 0x1e, 0xcf, 
  0x16, 0x49, 0x84, 0x15, 0x80, 0x31, 0x9a, 0xde, 0xdd, 0xc4, 0xa0, 0x71, 
  0x7e, 0x55, 0x25, 0xb9, 0x15, 0xa7, 0xc6, 0x8b, 0x74, 0xca, 0xe1, 0x8c, 
  0xfc, 0x92, 0x06, 0x8d, 0x68, 0x97, 0xa1, 0xcd, 0xf5, 0x71, 0x02, 0x77, 
  0xca, 0x7e, 0xb6, 0x30, 0x67, 0x0b, 0x6c, 0xd2, 0x02, 0x64, 0x62, 0x21, 
  0x2a, 0x08, 0x08, 0x01, 0xfe, 0x71, 0xe3, 0x9e, 0x00, 0x34, 0x42, 0xb9, 
  0x9a, 0x8a, 0xf7, 0x67, 0x61, 0x66, 0x15, 0x0c, 0xd4, 0x45, 0xe1, 0x4d, 
  0x32, 0x60, 0xf5, 0xda, 0x9a, 0x09, 0xb6, 0xdb, 0x72, 0x16, 0x37, 0x92, 
  0xfb, 0x6d, 0x38, 0x3a, 0x1d, 0x1f, 0xdf, 0x65, 0xcc, 0x11, 0x69, 0xe0, 
  0x82, 0xbe, 0x9b, 0xe4, 0xd3, 0x04, 0x09, 0x52, 0x9a, 0x73, 0x7e, 0xd7, 
  0xe4, 0x81, 0x8a, 0x16, 0x85, 0xb0, 0x41, 0x06, 0xeb, 0xe0, 0x2e, 0x15, 
  0x38, 0xc7, 0x4d, 0xdc, 0x2d, 0x19, 0xd1, 0xbf, 0xe5, 0x5b, 0x70, 0x4f, 
  0x6b, 0xd4, 0x39, 0xb3, 0x4a, 0x49, 0x94, 0x29, 0x47, 0x5b, 0xd9, 0x52, 
  0x8e, 0xb3, 0x99, 0xe7, 0x62, 0x66, 0x3c, 0xd5, 0x9b, 0x4f, 0x3a, 0x69, 
  0xcd, 0x03, 0xa1, 0xa3, 0x12, 0xe7, 0x95, 0x4c, 0xb8, 0x40, 0x10, 0xf2, 
  0x6e, 0xfb, 0x1a, 0x48, 0x26, 0xc2, 0x97, 0xc3, 0x90, 0x2a, 0x8b, 0x5a, 
  0x7e, 0x3c, 0x44, 0x0f, 0xc2, 0xb2, 0x63, 0x88, 0xd5, 0x73, 0x0c, 0x6f, 
  0xdc, 0x64, 0xb2, 0xad, 0x3b, 0xb3, 0xcd, 0x79, 0x89, 0xb7, 0x0d, 0x13, 
  0x98, 0xbd, 0x62, 0x07, 0xc3, 0x9f, 0xdb, 0x94, 0x46, 0x93, 0x2e, 0xc6, 
  0xb3, 0x55, 0x03, 0x26, 0x44, 0xcf, 0xeb, 0xb1, 0x7c, 0xe9, 0x22, 0xb7, 
  0xec, 0x94, 0xeb, 0xd5, 0xa8, 0xe6, 0x65, 0x4d, 0xd4, 0x09, 0x9f, 0x68, 
  0xe2, 0x85, 0x71, 0x3b, 0x50, 0x47, 0x69, 0xe1, 0x34, 0x95, 0xc9, 0x6c, 
  0xec, 0x7d, 0x3e, 0x5d, 0x3d, 0x66, 0x83, 0x6e, 0x67, 0xbc, 0x4d, 0x1d, 
  0x8d, 0x36, 0xfd, 0x49, 0xf0, 0x10, 0xf2, 0x92, 0x02, 0x48, 0x7b, 0x30, 
  0xf8, 0xc8, 0x26, 0x3c, 0x37, 0x6f, 0xcc, 0x23, 0x94, 0x45, 0x41, 0x95, 
  0x53, 0x5a, 0xfd, 0xf6, 0xc0, 0xa7, 0x73, 0xfa, 0x52, 0x73, 0x0c, 0xa3, 
  0xd0, 0xc0, 0x5a, 0x81, 0x7c, 0xc4, 0x4d, 0xa7, 0xcd, 0x0c, 0x9c, 0x5e, 
  0x90, 0x2c, 0xca, 0x96, 0x85, 0xb4, 0xde, 0x64, 0xcd, 0x8e, 0xcf, 0x99, 
  0x00, 0xd8, 0x36, 0xc3, 0x77, 0xe9, 0x35, 0xeb, 0xea, 0xfc, 0xc5, 0x20, 
  0xda, 0x5f, 0x98, 0x28, 0xae, 0x91, 0x96, 0xe2, 0x33, 0x6d, 0xe0, 0xb1, 
  0xdc, 0x24, 0x0d, 0x9d, 0x40, 0x95, 0x82, 0x60, 0x66, 0x49, 0x79, 0xbd, 
  0xf3, 0x62, 0x37, 0xc4, 0xb1, 0x59, 0x28, 0x0a, 0x03, 0xf0, 0xa1, 0x3f, 
  0x9e, 0xcb, 0xe9, 0x58, 0x2f, 0x96, 0x36, 0xea, 0xdc, 0x7e, 0xcd, 0xff, 
  0x63, 0x28, 0xf9, 0xe8, 0x75, 0x02, 0xdb, 0x5d, 0x8d, 0x48, 0x19, 0xb2, 
  0xe0, 0x0f, 0xf2, 0x89, 0x06, 0x7d, 0x9b, 0x14, 0xda, 0x96, 0x85, 0xe2, 
  0xb2, 0x06, 0x71, 0x9f, 0x8a, 0x8e, 0x8f, 0x59, 0x88, 0x3f, 0x3c, 0x83, 
  0xed, 0xc2, 0xae, 0x4d, 0x15, 0xbc, 0xda, 0x99, 0x04, 0x94, 0x6d, 0x8f, 
  0x5d, 0xe3, 0x81, 0x85, 0x81, 0x74, 0xac, 0x40, 0x62, 0x3c, 0xf0, 0x48, 
  0x55, 0x72, 0xbd, 0x2a, 0x14, 0x7f, 0xa1, 0x58, 0x87, 0x66, 0x57, 0xa4, 
  0xbf, 0x48, 0x12, 0x04, 0x56, 0x6d, 0x9e, 0x4d, 0xc4, 0xe7, 0x87, 0xe0, 
  0x4a, 0x20, 0xa1, 0xd0, 0x7c, 0x3f, 0xb6, 0x1b, 0x27, 0x58, 0xda, 0x60, 
  0x9b, 0xfe, 0x41, 0xdb, 0xf4, 0x8f, 0xd5, 0xe2, 0xa6, 0xaf, 0xf0, 0x84, 
  0x1a, 0x67, 0x5b, 0xb4, 0x33, 0x15, 0x2c, 0x88, 0x79, 0x00, 0xca, 0x4c, 
  0x8c, 0x2a, 0x4d, 0x9c, 0xbe, 0x58, 0x03, 0x10, 0x64, 0x8d, 0xd6, 0xa3, 
  0xff, 0x54, 0x84, 0x50, 0x36, 0x4a, 0xd2, 0xc8, 0xc7, 0xec, 0x70, 0x60, 
  0x81, 0xb4, 0x63, 0x80, 0x89, 0xda, 0x74, 0x67, 0xe0, 0x73, 0x61, 0x1b, 
  0x49, 0x79, 0x85, 0x46, 0x17, 0x5c, 0x1b, 0xce, 0x1d, 0xae, 0xfe, 0x64, 
  0xca, 0x97, 0x96, 0x4b, 0x2e, 0x5e, 0x24, 0x77, 0x0e, 0x85, 0x11, 0x6b, 
  0x89, 0x84, 0x4a, 0xa6, 0xda, 0x1a, 0x17, 0x7f, 0x58, 0x72, 0x73, 0xd4, 
  0x6e, 0x4e, 0x77, 0x33, 0x6e, 0x44, 0x0b, 0x6c, 0xb7, 0x01, 0x46, 0xb5, 
  0xc1, 0xa9, 0x99, 0x9f, 0x04, 0xfa, 0x6e, 0x83, 0x46, 0xc7, 0xb3, 0x4c, 
  0x20, 0x91, 0xee, 0x6a, 0xa6, 0xf6, 0xe7, 0x1f, 0xee, 0xbf, 0xf8, 0xfd, 
  0x23, 0xee, 0x6e, 0x70, 0x81, 0x08, 0x56, 0x6f, 0x6b, 0xec, 0x51, 0xf5, 
  0x32, 0x0b, 0x8c, 0x1c, 0x2a, 0xb2, 0xb8, 0x44, 0x64, 0x65, 0x93, 0x1d, 
  0x6b, 0xad, 0x53, 0xbf, 0x5a, 0x87, 0x27, 0x15, 0x9f, 0x3a, 0xd4, 0x66, 
  0x9f, 0x49, 0x30, 0xe4, 0x4d, 0xe0, 0x93, 0x09, 0xa1, 0xc0, 0x25, 0xff, 
  0xf4, 0x44, 0x2b, 0x79, 0x34, 0xda, 0x2e, 0xf2, 0xd2, 0xbe, 0x38, 0x93, 
  0x5c, 0x4a, 0xf5, 0x9c, 0x68, 0xdd, 0x80, 0x88, 0x2b, 0x11, 0xe7, 0xad, 
  0xf1, 0x26, 0x16, 0x07, 0x21, 0x11, 0x26, 0x90, 0xda, 0x62, 0xd8, 0xd9, 
  0xe9, 0x55, 0xf5, 0xcb, 0x28, 0xf1, 0xa9, 0x85, 0x54, 0xc0, 0x76, 0x78, 
  0x1c, 0x6d, 0xe9, 0x23, 0x45, 0x14, 0xc4, 0x86, 0x47, 0xc1, 0xc2, 0x88, 
  0x8a, 0x04, 0x27, 0xae, 0x21, 0xd8, 0x55, 0xf6, 0xa1, 0x99, 0x16, 0x57, 
  0x65, 0xaa, 0xbf, 0xd6, 0x11, 0x09, 0xde, 0xf2, 0x5e, 0xc6, 0x90, 0x96, 
  0xe1, 0xa5, 0xc8, 0xf1, 0x71, 0x2f, 0xe9, 0x9f, 0xf6, 0x80, 0xb4, 0xe8, 
  0x3c, 0x08, 0xa3, 0x73, 0x16, 0x47, 0xba, 0xb3, 0x2a, 0x62, 0xac, 0x3a, 
  0x64, 0xd5, 0xa4, 0x2b, 0x6f, 0xd4, 0x9a, 0xe3, 0xf7, 0x3d, 0x32, 0xaa, 
  0xe2, 0xc0, 0xb7, 0x5a, 0x8a, 0x7f, 0xc7, 0x58, 0x1a, 0xea, 0xf4, 0xbd, 
  0x21, 0x77, 0xcd, 0x19, 0xf2, 0xb3, 0x03, 0x17, 0x79, 0xaa, 0xd7, 0x0b, 
  0xb7, 0x82, 0xe9, 0xc9, 0x8a, 0xd1, 0x8c, 0x9b, 0xfe, 0xdd, 0x09, 0x0a, 
  0xaf, 0xf8, 0xd6, 0x38, 0xe3, 0xf2, 0x90, 0x4b, 0xac, 0x70, 0x9c, 0x4c, 
  0x18, 0x81, 0xe7, 0x82, 0x9b, 0x3f, 0xea, 0xe4, 0xf3, 0xd1, 0xd3, 0xe8, 
  0xe5, 0x8c, 0xde, 0x9c, 0x7d, 0xd1, 0xea, 0x5f, 0x53, 0x24, 0xcd, 0x9b, 
  0x24, 0x1f, 0x71, 0x69, 0x89, 0xa7, 0x75, 0xd0, 0x43, 0x8d, 0x30, 0x53, 
  0x24, 0x3f, 0x6e, 0xc7, 0x62, 0x7f, 0x1a, 0x31, 0xd9, 0x25, 0x28, 0x9f, 
  0x5f, 0xf0, 0x90, 0xad, 0x0a, 0x32, 0xd7, 0x45, 0xb6, 0x62, 0xb7, 0x17, 
  0x75, 0x8b, 0x78, 0x9a, 0xf0, 0x4f, 0x22, 0xd5, 0x29, 0x4c, 0x52, 0xa4, 
  0xcd, 0x76, 0x5b, 0x40, 0x5c, 0xbb, 0xba, 0x86, 0x5d, 0x2e, 0x6d, 0xa2, 
  0x69, 0xed, 0x00, 0x86, 0x02, 0xf2, 0x23, 0x47, 0x8c, 0x63, 0x2c, 0x06, 
  0x7a, 0xc4, 0xfa, 0x8e, 0x07, 0xb4, 0x2b, 0x1a, 0xf1, 0xf6, 0xae, 0xb9, 
  0xba, 0xde, 0xde, 0x7e, 0xd8, 0x42, 0x33, 0x96, 0xa2, 0x5b, 0x17, 0xde, 
  0xf4, 0x38, 0x4b, 0x47, 0x39, 0xdb, 0x3e, 0xee, 0x38, 0x16, 0x61, 0x95, 
  0xce, 0x4a, 0x8b, 0x44, 0x72, 0xab, 0xd8, 0x12, 0xb1, 0x44, 0x5b, 0xed, 
  0x02, 0x42, 0xf8, 0x7f, 0x88, 0x56, 0xa7, 0x0d, 0x7d, 0x80, 0x24, 0xc3, 
  0x4e, 0x39, 0x04, 0xc9, 0x7f, 0x47, 0x9c, 0xc1, 0xc4, 0x65, 0x09, 0x4b, 
  0x6e, 0x86, 0x18, 0x81, 0x04, 0x2b, 0xb8, 0x7c, 0x95, 0xe3, 0xfc, 0xbb, 
  0x53, 0xd1, 0xb7, 0x02, 0xbf, 0x34, 0x4d, 0xaf, 0xa2, 0x97, 0xfa, 0xb3, 
  0x2d, 0x5e, 0xdb, 0x85, 0x69, 0x2b, 0x38, 0xa4, 0x7f, 0xd2, 0x0b, 0x0c, 
  0x48, 0xc4, 0xc8, 0xaf, 0x20, 0x6a, 0x89, 0xdc, 0x60, 0x75, 0x85, 0x1a, 
  0xaa, 0xa0, 0x7b, 0x39, 0x0d, 0xbc, 0x53, 0x60, 0xd4, 0xae, 0x83, 0xb0, 
  0xf8, 0x84, 0x6b, 0xd4, 0x34, 0xb0, 0xba, 0xed, 0x4f, 0x61, 0xbb, 0xcc, 
  0x77, 0x0a, 0x3f, 0x5b, 0x38, 0x61, 0x95, 0x18, 0x60, 0x9f, 0xe3, 0x32, 
  0x3c, 0xee, 0x0d, 0x51, 0x47, 0xeb, 0x26, 0x88, 0x71, 0xb9, 0xe2, 0x48, 
  0xa4, 0x4a, 0xb5, 0x91, 0xb3, 0x65, 0x70, 0xd9, 0x5d, 0x27, 0x69, 0xee, 
  0x8d, 0xcf, 0x3e, 0x64, 0x0e, 0x3a, 0x44, 0x73, 0xb2, 0x9a, 0x86, 0xe4, 
  0xe5, 0x98, 0x70, 0xfd, 0xa4, 0x79, 0xc5, 0x27, 0xab, 0x18, 0xb4, 0x39, 
  0x90, 0xa2, 0x45, 0x8d, 0x8e, 0x65, 0x95, 0x38, 0xc1, 0x6b, 0xc9, 0x95, 
  0x72, 0x7a, 0xb5, 0x37, 0x7d, 0xfc, 0x9e, 0x0a, 0x2a, 0x5a, 0x57, 0x07, 
  0xf5, 0x10, 0x1a, 0xe9, 0x1b, 0x41, 0xc1, 0x8b, 0x1c, 0x58, 0x17, 0xd9, 
  0x6c, 0x35, 0x5f, 0xa8, 0xe4, 0xac, 0xe3, 0xc4, 0x2e, 0x60, 0xab, 0xba, 
  0x7f, 0xec, 0xaa, 0x05, 0xbd, 0xd4, 0xa0, 0x92, 0x26, 0xb6, 0x93, 0xcb, 
  0x5a, 0xc7, 0x6b, 0xb6, 0x0d, 0x01, 0x6c, 0x37, 0x90, 0x2b, 0x21, 0x90, 
  0x6f, 0xac, 0x83, 0xed, 0x53, 0x39, 0xdb, 0x4c, 0x3d, 0xdd, 0x7e, 0xd7, 
  0x59, 0x53, 0x54, 0x42, 0xf7, 0x2e, 0x37, 0x75, 0xc4, 0xb4, 0x00, 0xe3, 
  0x09, 0x74, 0xc5, 0x63, 0xd0, 0xf9, 0x6a, 0xe1, 0x34, 0x70, 0x7a, 0x67, 
  0xcb, 0x82, 0x51, 0xcf, 0x63, 0x9e, 0xda, 0x66, 0xf5, 0x5a, 0x20, 0xff, 
  0x81, 0x60, 0x1f, 0xbc, 0x9b, 0x96, 0x61, 0x3e, 0x5c, 0x5f, 0xd0, 0xe2, 
  0x34, 0x68, 0x06, 0x4a, 0x8d, 0xd4, 0x50, 0x61, 0xd4, 0xda, 0x94, 0x74, 
  0xc2, 0x87, 0x16, 0x5a, 0xf6, 0xf1, 0x92, 0xa8, 0xe2, 0xc4, 0x27, 0x9c, 
  0x31, 0x37, 0xee, 0x16, 0x4a, 0x2c, 0xc3, 0x0c, 0xf1, 0x6d, 0xa2, 0x4b, 
  0x22, 0xfc, 0xd6, 0xfb, 0xd9, 0x5a, 0xac, 0xec, 0x0d, 0xad, 0x92, 0xc7, 
  0xf4, 0x2a, 0xea, 0xa8, 0x0e, 0x89, 0x48, 0xda, 0xeb, 0xf8, 0xfe, 0x7e, 
  0x50, 0x24, 0x02, 0x84, 0xda, 0xf9, 0x4f, 0xdd, 0x42, 0xa1, 0xb1, 0xda, 
  0xb4, 0x0b, 0x49, 0x17, 0x94, 0x04, 0x01, 0x95, 0xbe, 0x37, 0x4d, 0x66, 
  0xfa, 0xa7, 0xb1, 0xb0, 0x2d, 0x29, 0x02, 0x21, 0x8e, 0xcd, 0x78, 0x0d, 
  0xa2, 0xb0, 0xed, 0x88, 0x6e, 0x3c, 0x16, 0x15, 0x9a, 0x61, 0x0a, 0xf3, 
  0xe2, 0x94, 0x2b, 0x3f, 0xa8, 0x47, 0x5e, 0xdf, 0x90, 0x17, 0xda, 0x50, 
  0x53, 0x38, 0x56, 0x82, 0x7b, 0xd4, 0xbc, 0x04, 0x87, 0x68, 0x6f, 0xa9, 
  0xe6, 0x30, 0xe6, 0x14, 0x4e, 0xb2, 0x41, 0xb1, 0xa0, 0xc6, 0x7a, 0xee, 
  0x6e, 0xa9, 0xf0, 0x9c, 0x0b, 0xfe, 0xba, 0xe0, 0xa0, 0xc1, 0x2d, 0x72, 
  0x9d, 0x49, 0x20, 0x73, 0xe7, 0x05, 0xe3, 0x9b, 0xd9, 0x19, 0x93, 0x39, 
  0x4a, 0xcc, 0x74, 0xf3, 0x0c, 0x21, 0x52, 0xfc, 0x9b, 0xb3, 0x37, 0x47, 
  0xc6, 0x6c, 0x64, 0x50, 0xf8, 0xa4, 0x35, 0xeb, 0x68, 0x80, 0x88, 0x4f, 
  0x0b, 0x2c, 0xec, 0x35, 0xc4, 0x41, 0x59, 0x1d, 0x52, 0x9a, 0x97, 0x77, 
  0xab, 0x74, 0xb2, 0x89, 0xf8, 0xcf, 0xd5, 0x22, 0xbd, 0xef, 0xc3, 0xf2, 
  0xa3, 0x18, 0xd4, 0x16, 0xfd, 0x68, 0x51, 0x93, 0x92, 0x21, 0x9a, 0xcd, 
  0x5b, 0x22, 0x7e, 0x0d, 0x3a, 0x0f, 0xa7, 0x43, 0x63, 0xae, 0xb5, 0x32, 
  0x9c, 0x5c, 0x60, 0xd2, 0xe4, 0x16, 0x71, 0xcd, 0x45, 0xf4, 0xbd, 0x84, 
  0x92, 0x63, 0xdf, 0x5b, 0x4a, 0x45, 0x04, 0xfb, 0xcd, 0xcd, 0xed, 0x9f, 
  0x9f, 0x1f, 0xee, 0x5f, 0xee, 0xbb, 0xb9, 0x21, 0x72, 0x1b, 0x3c, 0x03, 
  0x37, 0x19, 0xb1, 0x97, 0x4c, 0x21, 0x73, 0xba, 0x9f, 0xbc, 0x1d, 0x1e, 
  0x5d, 0xd4, 0xb9, 0xe3, 0xf9, 0xc5, 0x19, 0xab, 0xf3, 0x9f, 0xec, 0x18, 
  0x0a, 0x52, 0x74, 0x18, 0x97, 0x71, 0x13, 0x81, 0x67, 0x8f, 0x04, 0xc3, 
  0x33, 0x28, 0xac, 0x36, 0x3a, 0x75, 0xc6, 0x89, 0xc4, 0x11, 0xbd, 0xe3, 
  0x0d, 0xcd, 0xc7, 0xee, 0x5a, 0x82, 0x85, 0x41, 0xf7, 0xb2, 0xd7, 0x44, 
  0xec, 0x0b, 0x66, 0xc1, 0x97, 0x6d, 0x2d, 0x8a, 0x5d, 0x92, 0x03, 0xee, 
  0x49, 0x25, 0x28, 0x05, 0xd3, 0xcb, 0x6a, 0xc2, 0x31, 0x71, 0x71, 0xb1, 
  0xa6, 0x46, 0xbe, 0xa4, 0xdb, 0x1c, 0xdb, 0x1d, 0x49, 0xd6, 0x97, 0xe2, 
  0x74, 0x60, 0x1b, 0xc8, 0x95, 0x26, 0x52, 0x43, 0xfd, 0x8b, 0x81, 0x8d, 
  0x56, 0x71, 0x07, 0x1b, 0x07, 0x47, 0x12, 0x6d, 0x88, 0xc8, 0x6d, 0x0e, 
  0x03, 0x2f, 0x47, 0x02, 0x42, 0xb6, 0x0f, 0x79, 0xfd, 0x25, 0xaa, 0x47, 
  0x7d, 0xf1, 0x08, 0x57, 0x9e, 0x1b, 0xba, 0xad, 0xe1, 0x2d, 0xe2, 0x3d, 
  0x97, 0xa6, 0x1c, 0x64, 0xa9, 0x43, 0xb2, 0x6c, 0x8b, 0x2a, 0x36, 0x4c, 
  0x11, 0x39, 0xf2, 0xc8, 0x63, 0x13, 0x9f, 0x00, 0x74, 0xfd, 0x58, 0x20, 
  0x6d, 0x59, 0xd2, 0x4e, 0x97, 0x62, 0x63, 0x61, 0x3b, 0xf4, 0x44, 0xac, 
  0x94, 0x4c, 0x5d, 0x75, 0x0e, 0x67, 0x23, 0x61, 0xbe, 0xca, 0x12, 0xa4, 
  0x58, 0xf6, 0x05, 0x47, 0x65, 0x44, 0xef, 0xdf, 0xa5, 0x93, 0xf2, 0xba, 
  0x35, 0xcb, 0x41, 0xa8, 0x18, 0x73, 0xe6, 0xd1, 0xcc, 0x93, 0xb8, 0x58, 
  0x29, 0x7a, 0x3f, 0x20, 0x1f, 0xb7, 0x45, 0xed, 0x72, 0xe8, 0xe4, 0x31, 
  0x09, 0x65, 0x53, 0x0e, 0x0e, 0x6a, 0xea, 0x75, 0xe6, 0x14, 0xe2, 0x84, 
  0xa9, 0x7d, 0xfc, 0x2e, 0x20, 0x54, 0x37, 0xe2, 0x83, 0xfd, 0x56, 0x85, 
  0x53, 0x09, 0x8d, 0x45, 0x38, 0x81, 0xb8, 0x4a, 0x88, 0xb4, 0x6f, 0xd2, 
  0x59, 0x13, 0x95, 0x88, 0xbb, 0x27, 0x51, 0x7a, 0x8e, 0xd7, 0xdf, 0x74, 
  0x55, 0x4f, 0x05, 0x92, 0xde, 0x55, 0x2c, 0x78, 0x94, 0x08, 0xfb, 0x89, 
  0xba, 0x57, 0x78, 0x24, 0xea, 0x7e, 0xdd, 0x75, 0x41, 0x44, 0x0d, 0xf2, 
  0xbc, 0x4a, 0xf5, 0xa5, 0x81, 0xc5, 0xe9, 0x14, 0x2f, 0xa2, 0xbd, 0x9d, 
  0x9d, 0x6f, 0x7b, 0xd1, 0x93, 0x39, 0xd6, 0x78, 0xf7, 0xeb, 0x56, 0x73, 
  0x15, 0xc4, 0x72, 0xd6, 0x68, 0x60, 0x4a, 0x0f, 0xee, 0xb5, 0x1f, 0x49, 
  0x6e, 0xc4, 0xc2, 0x09, 0xf9, 0x04, 0x60, 0x30, 0x71, 0xd9, 0x0e, 0x40, 
  0xa8, 0x26, 0x0d, 0x5c, 0xe1, 0x4b, 0xc6, 0xb3, 0x9d, 0xc0, 0xd2, 0xa1, 
  0x41, 0xd5, 0xf0, 0x07, 0x44, 0x1c, 0x44, 0xbe, 0x34, 0x64, 0x83, 0x08, 
  0xb4, 0x25, 0xed, 0xb7, 0x84, 0x6b, 0xcf, 0xf8, 0x95, 0xd9, 0x03, 0x52, 
  0x27, 0xd9, 0x07, 0x46, 0x12, 0x7a, 0xb2, 0xb4, 0xf1, 0x85, 0x43, 0x9b, 
  0x65, 0x57, 0xe9, 0x18, 0xc0, 0x13, 0x6d, 0x7e, 0x82, 0xf0, 0x6a, 0xbb, 
  0x43, 0xfd, 0xbf, 0x32, 0xcf, 0x26, 0xab, 0x71, 0x1d, 0xba, 0xe4, 0xe3, 
  0x89, 0xe0, 0x33, 0xce, 0x87, 0x4e, 0x8b, 0xb2, 0xcf, 0x96, 0xbc, 0xf5, 
  0xf1, 0xd6, 0xfc, 0x88, 0x7a, 0x5f, 0xd8, 0x6e, 0x39, 0xf1, 0xb9, 0x2d, 
  0xa2, 0x73, 0x4b, 0xd0, 0x24, 0x22, 0xea, 0x98, 0x52, 0xa1, 0xc7, 0x37, 
  0xc2, 0x45, 0x15, 0x39, 0x36, 0xb9, 0x63, 0x3a, 0x3d, 0x52, 0x8f, 0xa3, 
  0x94, 0xb9, 0x08, 0x0e, 0xa2, 0x21, 0x0e, 0xcc, 0xe3, 0x31, 0x09, 0x8e, 
  0x49, 0x1f, 0xee, 0xfc, 0xf5, 0xd8, 0x73, 0x85, 0x06, 0xc4, 0x54, 0x86, 
  0xa5, 0x65, 0x84, 0x64, 0x27, 0xd5, 0x6d, 0x1e, 0x7c, 0x8b, 0x41, 0xac, 
  0xa9, 0xaf, 0xc6, 0x87, 0x38, 0xf6, 0xc1, 0xca, 0x10, 0x70, 0x88, 0xc4, 
  0xd7, 0x24, 0x62, 0xd5, 0x5d, 0x34, 0x52, 0x97, 0xc1, 0x82, 0xa9, 0x4f, 
  0x4f, 0x86, 0x2e, 0x24, 0x3c, 0xa8, 0x5f, 0x34, 0xd0, 0xe2, 0x65, 0xaf, 
  0xd7, 0x40, 0x1b, 0x16, 0x92, 0xb5, 0x8c, 0xf5, 0x92, 0x90, 0x45, 0x61, 
  0xe9, 0x69, 0x00, 0x1c, 0x40, 0xad, 0x71, 0xeb, 0x9f, 0x8b, 0x5a, 0xc1, 
  0xb5, 0x95, 0x98, 0x05, 0xb5, 0x7b, 0x5b, 0x38, 0x4a, 0x33, 0x84, 0xa8, 
  0x84, 0x26, 0xfd, 0x30, 0x1f, 0x65, 0x74, 0x4d, 0xb1, 0x50, 0x77, 0x53, 
  0xfc, 0xae, 0xa0, 0x91, 0x6d, 0xb0, 0xfc, 0x55, 0x33, 0x71, 0x98, 0x84, 
  0xdf, 0x6a, 0xd1, 0xd7, 0xac, 0xa3, 0xe3, 0x69, 0x08, 0xe3, 0x2e, 0xc8, 
  0xc6, 0x81, 0xba, 0xac, 0xbe, 0x6e, 0x84, 0xe2, 0xb0, 0x2f, 0x9a, 0x6f, 
  0xea, 0x86, 0xbc, 0xa0, 0x15, 0x18, 0xa2, 0xc8, 0x67, 0xfd, 0x6f, 0xd2, 
  0xb5, 0x0b, 0x13, 0x9d, 0x65, 0xfa, 0x78, 0x0b, 0xbe, 0xa8, 0x0d, 0x2e, 
  0x15, 0x7f, 0xab, 0x2d, 0x6c, 0x04, 0x59, 0x17, 0x98, 0xf7, 0x2c, 0xd1, 
  0x14, 0x8b, 0x4a, 0xb5, 0x46, 0xf7, 0x07, 0x33, 0xf9, 0xc4, 0x79, 0x1d, 
  0xd9, 0x60, 0x5c, 0x8f, 0xd4, 0x9a, 0xc1, 0xcf, 0xe3, 0x9c, 0xf3, 0x06, 
  0x3c, 0xa8, 0xa1, 0x01, 0x81, 0x57, 0x0e, 0x10, 0x7a, 0xe6, 0x04, 0xe9, 
  0xad, 0xc1, 0xe0, 0x10, 0x6b, 0x39, 0x50, 0xeb, 0xc3, 0x85, 0xf1, 0x70, 
  0xd5, 0x6c, 0x3f, 0xb9, 0x53, 0xf0, 0xde, 0xba, 0x3d, 0xa6, 0xdd, 0x5a, 
  0xe8, 0x7c, 0x12, 0x92, 0x85, 0xb0, 0x80, 0x73, 0x97, 0xcb, 0xf4, 0x72, 
  0x30, 0x71, 0x9e, 0xa8, 0x9d, 0xc5, 0x61, 0x8e, 0x18, 0xc8, 0x00, 0xfb, 
  0x9f, 0x7a, 0xcd, 0x14, 0x17, 0xd8, 0xcd, 0xe9, 0x2d, 0xd0, 0x22, 0xb8, 
  0xb1, 0x37, 0xfc, 0x06, 0xd5, 0x32, 0xe4, 0x75, 0x88, 0x1c, 0x40, 0x30, 
  0x80, 0xff, 0xa9, 0xdf, 0xb0, 0xb4, 0x2e, 0x2d, 0x2c, 0x89, 0xa5, 0xbf, 
  0xbf, 0x78, 0x2c, 0xa9, 0x10, 0x4c, 0xca, 0x36, 0xbd, 0x5f, 0xe6, 0x2b, 
  0x2c, 0x08, 0xcd, 0x94, 0x71, 0x81, 0x1b, 0xaa, 0x8a, 0x8b, 0xb5, 0x4b, 
  0x8b, 0x8f, 0xed, 0x42, 0x74, 0x84, 0xe8, 0x04, 0xfd, 0xd0, 0xb0, 0x56, 
  0x1f, 0xf1, 0x63, 0xe7, 0xe3, 0x84, 0xa5, 0x92, 0xca, 0x69, 0x32, 0xd4, 
  0x1b, 0x3e, 0x94, 0xc8, 0x4f, 0x2b, 0x54, 0x18, 0xb0, 0x20, 0xc2, 0x5a, 
  0x73, 0x7f, 0xf1, 0x31, 0xb2, 0xbc, 0x07, 0x33, 0xd9, 0xba, 0xe0, 0x8c, 
  0x01, 0xcb, 0x45, 0x6a, 0xb1, 0xd9, 0xb6, 0x65, 0x6a, 0xbd, 0x6e, 0x09, 
  0xc7, 0xe0, 0xb2, 0xa4, 0x8a, 0xb5, 0xe4, 0xae, 0x32, 0x01, 0x6e, 0x59, 
  0xe5, 0x0c, 0x9e, 0x34, 0xca, 0xe1, 0x6b, 0x50, 0x7c, 0x5e, 0xb4, 0x6d, 
  0xed, 0x16, 0x2d, 0xda, 0xed, 0x44, 0x70, 0xd9, 0xcb, 0xc4, 0x47, 0xdb, 
  0x3e, 0x48, 0xd9, 0x60, 0x1f, 0xe3, 0xdb, 0x20, 0xe3, 0xc5, 0x34, 0x8b, 
  0x54, 0x9d, 0x68, 0x66, 0x94, 0xa1, 0xd2, 0x13, 0x4c, 0x3e, 0xa6, 0x5f, 
  0xc7, 0x02, 0x61, 0xb4, 0xb6, 0xca, 0xcc, 0xd6, 0xc7, 0xf6, 0xa4, 0x3d, 
  0x4e, 0x0e, 0x5c, 0xde, 0x00, 0x77, 0x00, 0xfb, 0xfc, 0x5e, 0x42, 0x8c, 
  0xfa, 0x10, 0x09, 0x19, 0x8f, 0x6f, 0x9a, 0x28, 0xb9, 0xe5, 0xe3, 0x7e, 
  0x15, 0xc4, 0x89, 0xd8, 0x80, 0xa0, 0x08, 0xb7, 0x83, 0x2b, 0xcb, 0xa3, 
  0x9e, 0x8d, 0x70, 0xfe, 0x00, 0xd7, 0x31, 0xcd, 0x0d, 0xee, 0x8a, 0x3e, 
  0x40, 0x10, 0x60, 0xcf, 0xa0, 0xaf, 0xb4, 0x4e, 0x52, 0x3b, 0xb2, 0x92, 
  0x40, 0x8d, 0xc6, 0x86, 0xdd, 0xa3, 0x95, 0x35, 0x50, 0xeb, 0x03, 0x9c, 
  0x2e, 0xb9, 0x87, 0x41, 0x81, 0xd8, 0xdc, 0xa7, 0x4f, 0x5a, 0x11, 0xf4, 
  0x5f, 0xf8, 0x3c, 0x6b, 0xcc, 0x4c, 0x0d, 0xb3, 0xaa, 0xc9, 0xa3, 0xbc, 
  0x00, 0xdb, 0xc6, 0xa5, 0x92, 0xb9, 0x9b, 0x9d, 0xd8, 0x3c, 0x5a, 0xa0, 
  0x01, 0x51, 0x68, 0x47, 0x6e, 0xd6, 0xf0, 0x60, 0xf3, 0x05, 0x42, 0xda, 
  0x97, 0xfa, 0xf9, 0x0c, 0x49, 0xc5, 0x17, 0x11, 0xe3, 0x59, 0x36, 0xec, 
  0x6b, 0xc8, 0x42, 0x9c, 0x14, 0x5c, 0x49, 0x46, 0x22, 0xfe, 0x1a, 0x0b, 
  0xa5, 0x48, 0xef, 0x90, 0x07, 0x9d, 0xa5, 0x96, 0x81, 0x01, 0x12, 0xd2, 
  0x74, 0xeb, 0xa2, 0x37, 0x87, 0x53, 0xb3, 0xe8, 0xc0, 0x8b, 0x05, 0x9a, 
  0xf4, 0xbe, 0x2d, 0x4f, 0x15, 0x95, 0xba, 0x17, 0xef, 0x2b, 0x05, 0x22, 
  0x7e, 0x1b, 0x44, 0x9f, 0xad, 0xa9, 0x06, 0xe2, 0x8a, 0x0d, 0x04, 0x81, 
  0x09, 0x4d, 0x5b, 0x8e, 0x94, 0xff, 0x08, 0xaa, 0x59, 0x1a, 0xfa, 0xb4, 
  0xc6, 0xcb, 0xa4, 0x96, 0xc3, 0x3c, 0xe2, 0x52, 0x74, 0xd1, 0x3f, 0xb2, 
  0x91, 0xc1, 0x3d, 0x31, 0x6b, 0x6d, 0x09, 0x52, 0x55, 0x13, 0xc4, 0x35, 
  0x63, 0xf7, 0xd0, 0xa6, 0xad, 0xc4, 0x08, 0xc6, 0x03, 0xd2, 0x32, 0x9a, 
  0x08, 0x65, 0x80, 0x7c, 0x12, 0x5d, 0x01, 0x3d, 0x4c, 0x9c, 0x9e, 0x6d, 
  0x6a, 0x9d, 0x49, 0x6f, 0x40, 0x78, 0xa3, 0x81, 0x21, 0x9f, 0x51, 0x8a, 
  0x5e, 0xb9, 0x32, 0x57, 0x51, 0xad, 0x9a, 0x48, 0x58, 0x57, 0xa5, 0xe1, 
  0x77, 0x93, 0x32, 0x2b, 0x1f, 0xbd, 0xa6, 0xc8, 0x1b, 0xec, 0xe4, 0x62, 
  0xd5, 0x08, 0x1d, 0x7b, 0x83, 0x0f, 0x07, 0xd1, 0xa1, 0xc4, 0x02, 0x88, 
  0x88, 0xb2, 0xd2, 0x88, 0x3b, 0x01, 0x67, 0xf4, 0xad, 0x2c, 0xb6, 0x19, 
  0x2e, 0xb1, 0xcc, 0xc7, 0x8d, 0x46, 0xdc, 0x0d, 0x5b, 0x8c, 0x15, 0xa6, 
  0x6e, 0x80, 0x07, 0x2b, 0xa6, 0x05, 0xbe, 0x3f, 0xbb, 0x85, 0xd3, 0xce, 
  0x55, 0x48, 0x9e, 0x36, 0x5c, 0x27, 0xac, 0xcb, 0x2c, 0xda, 0xd0, 0x1b, 
  0x5d, 0x1d, 0x2e, 0x71, 0x75, 0x5b, 0xe5, 0x3a, 0xde, 0x5e, 0x06, 0xbd, 
  0x52, 0x83, 0xcf, 0x60, 0x4d, 0x48, 0x22, 0x58, 0x00, 0x9b, 0x03, 0x43, 
  0x54, 0x7a, 0x87, 0xc1, 0x07, 0xd3, 0x4e, 0x03, 0x17, 0x33, 0xac, 0x4a, 
  0xef, 0x4c, 0xa1, 0x34, 0xaf, 0xcd, 0xa7, 0x5b, 0x91, 0xf4, 0xba, 0xb9, 
  0x5b, 0x29, 0x52, 0x6f, 0x52, 0x58, 0x58, 0xa7, 0xaf, 0x82, 0x83, 0x58, 
  0xb6, 0x55, 0x5d, 0x61, 0xae, 0x0d, 0x16, 0x10, 0xab, 0x8f, 0x80, 0x58, 
  0x04, 0x93, 0x99, 0x8f, 0x22, 0x63, 0x87, 0x35, 0x72, 0x0b, 0xe1, 0xa8, 
  0xdd, 0x4c, 0x1d, 0x58, 0x72, 0x0b, 0x1b, 0x84, 0x08, 0x46, 0x2b, 0x36, 
  0x83, 0x1d, 0x96, 0x0d, 0x59, 0x79, 0x46, 0x6c, 0x03, 0xd6, 0x64, 0x9e, 
  0xec, 0x96, 0xc6, 0x4f, 0xb5, 0x99, 0xd9, 0x6a, 0xcd, 0x75, 0xd8, 0x1e, 
  0xd7, 0x09, 0x71, 0x66, 0x9c, 0xd5, 0xaf, 0xba, 0x8d, 0x0d, 0xda, 0xdd, 
  0x8f, 0xfe, 0xb9, 0x4a, 0xc7, 0x37, 0xd8, 0x41, 0x78, 0x89, 0x60, 0xd1, 
  0x49, 0x5c, 0x90, 0x10, 0xdd, 0x14, 0x5a, 0x38, 0x01, 0xb5, 0x52, 0x78, 
  0x7c, 0xa4, 0xcf, 0x29, 0xd5, 0x34, 0xd9, 0x82, 0xd6, 0x13, 0x72, 0x85, 
  0x7f, 0x69, 0xbb, 0x55, 0x16, 0x54, 0xfd, 0x0d, 0x02, 0xc5, 0x60, 0x92, 
  0xcd, 0xb9, 0x70, 0x34, 0x2d, 0xaa, 0x16, 0x8c, 0x58, 0x93, 0x93, 0xdb, 
  0x9d, 0x3f, 0x70, 0x6c, 0x74, 0xb7, 0x42, 0x60, 0x1b, 0x8d, 0x6c, 0xa5, 
  0xf6, 0x96, 0x85, 0x3e, 0xa5, 0x05, 0x2f, 0xd7, 0x10, 0xd3, 0xa3, 0xbb, 
  0xe6, 0x23, 0xcb, 0x74, 0xb2, 0x3c, 0x8d, 0x4a, 0x77, 0xf8, 0xb8, 0x6f, 
  0xd0, 0x35, 0xb5, 0x77, 0xbe, 0xe3, 0xd5, 0x0f, 0x8c, 0xe7, 0xf6, 0xbc, 
  0x55, 0x5d, 0xf1, 0xa3, 0x13, 0xcb, 0x4a, 0x70, 0x7a, 0xd1, 0x51, 0x6b, 
  0x14, 0x0c, 0xb1, 0x1f, 0x5e, 0x3a, 0x26, 0x37, 0xd6, 0x3a, 0x63, 0x43, 
  0xac, 0x10, 0x7f, 0x80, 0xbc, 0xcd, 0xcc, 0xb2, 0x3a, 0x4a, 0xad, 0x04, 
  0xfc, 0x38, 0x4e, 0xed, 0xd7, 0xc3, 0x61, 0xff, 0xd4, 0x1e, 0x6d, 0x9e, 
  0x48, 0x44, 0xfe, 0x55, 0x9e, 0xa9, 0x6f, 0x9b, 0x94, 0xb9, 0x63, 0x3b, 
  0xc7, 0x24, 0xe1, 0x34, 0x39, 0x09, 0x89, 0x78, 0x93, 0x8e, 0xf3, 0xac, 
  0xc8, 0xa6, 0x22, 0x20, 0x54, 0x6b, 0xaf, 0x72, 0x39, 0x86, 0x64, 0x24, 
  0xb8, 0xf2, 0x0d, 0x05, 0x40, 0x11, 0xc1, 0xb4, 0x28, 0x2d, 0xdf, 0xff, 
  0x73, 0x3a, 0x2c, 0x6c, 0x63, 0xe0, 0xac, 0x88, 0x32, 0xb2, 0x22, 0xad, 
  0xea, 0xcb, 0xd4, 0xeb, 0xe6, 0x5b, 0x75, 0xa5, 0x3e, 0x7b, 0xbc, 0x26, 
  0x1f, 0x6f, 0x81, 0x16, 0x30, 0x55, 0xeb, 0x93, 0x22, 0xae, 0x5d, 0x59, 
  0xae, 0x1f, 0xa2, 0xc9, 0xdd, 0x6b, 0xed, 0xa3, 0xd3, 0x39, 0x17, 0x52, 
  0x29, 0x52, 0xf1, 0x44, 0x43, 0xe0, 0x2c, 0xf8, 0x61, 0xa3, 0xe3, 0xa3, 
  0xcb, 0xd7, 0x44, 0x59, 0x79, 0x3c, 0x2d, 0xf5, 0x47, 0xc3, 0x24, 0x97, 
  0x27, 0xbf, 0xc4, 0x37, 0xfd, 0x62, 0xc9, 0x7b, 0xd5, 0x67, 0x66, 0xd9, 
  0xdf, 0x79, 0x3a, 0x28, 0x19, 0xa2, 0xf7, 0xbd, 0x75, 0xff, 0x7e, 0xad, 
  0xcf, 0x19, 0xf3, 0xa3, 0x8d, 0xdc, 0x3f, 0x3f, 0x6e, 0x2f, 0xf5, 0x9b, 
  0x97, 0x9e, 0xe5, 0x33, 0xa1, 0x7d, 0x90, 0xb3, 0x19, 0x20, 0x33, 0x2d, 
  0x16, 0x54, 0x7b, 0xcc, 0x79, 0x9c, 0x2b, 0x24, 0x34, 0xf8, 0x9f, 0x84, 
  0xec, 0x3d, 0xe5, 0x6b, 0x35, 0xeb, 0x8f, 0x56, 0xfc, 0x5d, 0xed, 0xc5, 
  0x43, 0x61, 0x03, 0x72, 0xb0, 0xe4, 0x89, 0xa0, 0xd0, 0x8e, 0x22, 0x5e, 
  0x14, 0xec, 0x77, 0x9c, 0x87, 0x00, 0x13, 0x90, 0x4f, 0x8a, 0x66, 0xd9, 
  0x2b, 0x29, 0x85, 0x54, 0x54, 0xd5, 0xed, 0xba, 0x2d, 0x4a, 0xba, 0x49, 
  0x26, 0xd5, 0xe6, 0xdb, 0x12, 0x48, 0xf0, 0xba, 0x8b, 0x5e, 0x53, 0x81, 
  0x56, 0x42, 0x1a, 0x54, 0x3b, 0xd4, 0x26, 0x7c, 0x1d, 0x8b, 0x85, 0x14, 
  0x1a, 0x90, 0x94, 0x80, 0x06, 0x77, 0x93, 0x4a, 0x30, 0x38, 0x5c, 0x56, 
  0xdb, 0x42, 0x61, 0x32, 0x5c, 0x0b, 0x71, 0x9e, 0x93, 0xa0, 0x5b, 0xb8, 
  0x9c, 0xfd, 0x60, 0x97, 0xda, 0x46, 0xe7, 0x01, 0x8e, 0xe3, 0xd2, 0x2f, 
  0xe0, 0x7f, 0x68, 0x88, 0x32, 0x26, 0xad, 0xf6, 0xc8, 0xa8, 0xd1, 0x75, 
  0x4b, 0x47, 0x82, 0x38, 0xed, 0x52, 0xc4, 0x8c, 0xdb, 0x45, 0xa7, 0x97, 
  0x27, 0x6f, 0xa2, 0x35, 0x6c, 0x0e, 0xdf, 0x55, 0xbf, 0xfa, 0x4f, 0x98, 
  0x1d, 0x7d, 0x71, 0x7c, 0x3c, 0x04, 0xab, 0x53, 0x0b, 0x60, 0x43, 0x56, 
  0x2a, 0xc5, 0x05, 0xbe, 0xcc, 0x33, 0xe2, 0x73, 0x24, 0xd2, 0xe4, 0x0f, 
  0x01, 0xbe, 0x31, 0x0b, 0xe0, 0x39, 0x37, 0x24, 0xd0, 0x72, 0xa0, 0x11, 
  0x4e, 0x36, 0x9a, 0x01, 0xce, 0x74, 0x99, 0x34, 0x2c, 0xfc, 0x7c, 0xd1, 
  0x63, 0x00, 0x7c, 0xe5, 0xb3, 0x9c, 0x11, 0x18, 0x9c, 0x47, 0xb1, 0x86, 
  0xa8, 0x0a, 0xff, 0x25, 0xe2, 0xe1, 0x63, 0xa9, 0x27, 0xfe, 0x06, 0x35, 
  0x96, 0xa6, 0x6b, 0x70, 0x05, 0x7c, 0xa1, 0x08, 0x2d, 0xec, 0x44, 0x9a, 
  0x51, 0x96, 0xc3, 0x8c, 0x14, 0xa4, 0x5d, 0x70, 0x2e, 0xd2, 0x2a, 0x67, 
  0x8b, 0x1d, 0x0f, 0xef, 0x81, 0xa4, 0xe3, 0x46, 0x16, 0x6a, 0x26, 0x4e, 
  0x43, 0x2c, 0x33, 0xf3, 0x0f, 0x97, 0x93, 0xcf, 0xe5, 0x10, 0x46, 0x6c, 
  0xb6, 0x84, 0xe1, 0xde, 0x62, 0x6b, 0x59, 0xf3, 0x7e, 0x0f, 0x3e, 0xba, 
  0xee, 0x87, 0x81, 0x9c, 0x44, 0x43, 0xad, 0xb5, 0x2a, 0xb8, 0xeb, 0x1f, 
  0x58, 0x3d, 0x15, 0x0e, 0x09, 0xb3, 0x4f, 0xab, 0x80, 0x8a, 0x31, 0x2a, 
  0xde, 0x3c, 0xeb, 0x42, 0xd9, 0xfd, 0x43, 0x8d, 0x32, 0x7a, 0x6d, 0x9e, 
  0x47, 0x64, 0xdf, 0xf6, 0xf1, 0x38, 0xe8, 0xef, 0xf7, 0x8a, 0x14, 0xe2, 
  0xf0, 0xc8, 0xf5, 0x5c, 0x7b, 0x7d, 0x24, 0x50, 0x5b, 0xec, 0x0f, 0x4f, 
  0xed, 0x7f, 0x94, 0x01, 0x67, 0x34, 0x52, 0x65, 0x54, 0x8f, 0x80, 0x20, 
  0x1b, 0x2b, 0xcb, 0xf4, 0xa1, 0x30, 0x4f, 0x46, 0xab, 0xf2, 0x59, 0x69, 
  0x82, 0xd8, 0x01, 0x95, 0xff, 0xeb, 0xdf, 0xcd, 0xd0, 0xb0, 0x9f, 0x7e, 
  0xd6, 0x90, 0x4a, 0x44, 0x91, 0xfb, 0xf8, 0x02, 0x23, 0xb3, 0xc2, 0x67, 
  0x0a, 0xf2, 0xf6, 0x71, 0x38, 0x8a, 0x4c, 0x51, 0x8e, 0x5b, 0xdd, 0xf6, 
  0xac, 0x4e, 0x36, 0x55, 0xb2, 0x74, 0x6c, 0x16, 0xe8, 0x0f, 0xec, 0xab, 
  0x00, 0x08, 0x2d, 0xa8, 0x65, 0xad, 0x49, 0x1c, 0x93, 0xb6, 0xf2, 0x33, 
  0xa1, 0xd3, 0xbb, 0x9a, 0xa2, 0x8a, 0x68, 0x0d, 0xb1, 0x40, 0x60, 0xfc, 
  0xec, 0x0d, 0x84, 0x7d, 0x30, 0x5d, 0x34, 0x03, 0xfb, 0xb5, 0x12, 0xa7, 
  0x84, 0x60, 0xfc, 0x8b, 0x61, 0x64, 0x49, 0xe1, 0xfe, 0xf7, 0x80, 0x4d, 
  0x6d, 0x90, 0xa4, 0xfb, 0x99, 0x24, 0x02, 0xbf, 0xfb, 0xe3, 0x2e, 0x0b, 
  0x19, 0x9d, 0x66, 0xfa, 0x33, 0x56, 0xc0, 0xf6, 0xdc, 0xc5, 0x02, 0xac, 
  0xc9, 0x23, 0xa8, 0x76, 0xc7, 0xbd, 0xf4, 0x58, 0x76, 0xff, 0xf7, 0x80, 
  0xff, 0xfd, 0x69, 0xb7, 0xff, 0xec, 0x67, 0xd7, 0xeb, 0x1f, 0x77, 0xdf, 
  0xfd, 0x71, 0xaf, 0xd3, 0x9a, 0x2d, 0xce, 0xe2, 0x98, 0x55, 0x2b, 0x0f, 
  0xad, 0x6f, 0xb1, 0x02, 0x60, 0x49, 0x26, 0x4c, 0x5c, 0x78, 0x77, 0xae, 
  0xcb, 0x08, 0x6b, 0x42, 0xf8, 0x16, 0xef, 0xc9, 0xd9, 0x09, 0x71, 0x73, 
  0x82, 0x1a, 0x06, 0x5a, 0xf8, 0x0b, 0xea, 0x81, 0x54, 0x45, 0x33, 0x55, 
  0xab, 0x01, 0x87, 0xc3, 0x9e, 0x96, 0xc9, 0x03, 0xe9, 0x38, 0xa2, 0x12, 
  0x07, 0x64, 0x7d, 0x86, 0xdc, 0x1f, 0xae, 0x1c, 0xd6, 0x6f, 0x51, 0x81, 
  0x84, 0xa8, 0x03, 0xaa, 0x8e, 0xb5, 0xa7, 0x00, 0xc5, 0x4e, 0xf3, 0xb8, 
  0x13, 0x2b, 0x40, 0x26, 0x88, 0x9b, 0x70, 0x37, 0xd4, 0x6f, 0x8e, 0xcd, 
  0xb3, 0xc5, 0xcc, 0xc7, 0x34, 0x49, 0x72, 0xb8, 0x4a, 0x29, 0xe1, 0xcb, 
  0x7a, 0x8c, 0x2d, 0x9c, 0x8b, 0x48, 0x2d, 0x95, 0x9a, 0x53, 0x8d, 0x9c, 
  0x86, 0xe9, 0x60, 0xab, 0xcd, 0x9d, 0x6d, 0xad, 0xd5, 0xeb, 0x01, 0x19, 
  0x94, 0x6f, 0x21, 0xa9, 0xb1, 0xa8, 0x57, 0x05, 0x74, 0xd9, 0xa0, 0x52, 
  0x61, 0xc3, 0x61, 0xcc, 0x06, 0x33, 0xda, 0x24, 0xc1, 0xe1, 0x75, 0x95, 
  0xe0, 0xda, 0xa8, 0x82, 0x89, 0x62, 0x65, 0xb9, 0xce, 0xba, 0x4f, 0x55, 
  0x82, 0x80, 0x1a, 0x00, 0xce, 0x0d, 0x9a, 0x30, 0xa2, 0x78, 0x1f, 0x55, 
  0xf4, 0xfb, 0xa8, 0x89, 0xf5, 0x72, 0x79, 0x9d, 0xd3, 0x85, 0xd8, 0x1e, 
  0xdd, 0x7b, 0xce, 0x4f, 0xc8, 0x03, 0xee, 0x18, 0x06, 0x21, 0xba, 0x1f, 
  0x31, 0xfc, 0x56, 0x2e, 0x0e, 0x2d, 0x81, 0x51, 0xdf, 0x8d, 0x0a, 0x56, 
  0xdf, 0x12, 0xca, 0x3e, 0x31, 0xf5, 0x54, 0xc2, 0x3f, 0xda, 0x6b, 0x8f, 
  0x8b, 0x2c, 0xc7, 0x32, 0xfc, 0xaa, 0x4e, 0xc8, 0x0b, 0x3c, 0xba, 0xb8, 
  0x8a, 0x5c, 0x49, 0x07, 0x5f, 0xbd, 0x12, 0xc3, 0x70, 0x36, 0x4d, 0x61, 
  0x61, 0x52, 0x58, 0x0c, 0x3e, 0x50, 0xec, 0x74, 0x23, 0x46, 0x0f, 0x46, 
  0xe5, 0x6d, 0xe7, 0xc9, 0xcc, 0x39, 0x62, 0xaa, 0xcf, 0xa5, 0x5f, 0x06, 
  0x51, 0xa3, 0x6a, 0xc7, 0x93, 0xc1, 0xde, 0xef, 0xea, 0x9b, 0x6c, 0x85, 
  0x72, 0xe5, 0x2b, 0x9b, 0x41, 0x8e, 0x99, 0x66, 0x6a, 0xf2, 0x5e, 0x63, 
  0xc9, 0xdb, 0x6a, 0xd7, 0xb7, 0xe1, 0xe7, 0xae, 0xf5, 0x27, 0xc8, 0x52, 
  0x63, 0xa5, 0x6d, 0x65, 0xd7, 0x31, 0x7a, 0xc5, 0xdd, 0x94, 0x35, 0x16, 
  0xa4, 0x6b, 0x74, 0x0f, 0x5a, 0x83, 0xf8, 0xc1, 0xdb, 0x12, 0xf4, 0x24, 
  0x9a, 0x69, 0x7b, 0x81, 0x5e, 0xb1, 0x96, 0x44, 0xfa, 0xa4, 0xab, 0x37, 
  0x6a, 0x41, 0x6a, 0xed, 0x64, 0xc1, 0x53, 0x6a, 0x0a, 0x2e, 0x85, 0x74, 
  0xc4, 0x03, 0x4b, 0x93, 0x8f, 0xee, 0x2e, 0x93, 0xfd, 0x59, 0xbb, 0x9e, 
  0xcd, 0x2d, 0x6a, 0xad, 0xb9, 0x13, 0xee, 0x51, 0xb8, 0x45, 0xad, 0x75, 
  0x77, 0xfe, 0xb3, 0x3d, 0x92, 0xfe, 0x5b, 0x36, 0x49, 0xfb, 0x6a, 0xc9, 
  0x84, 0x8f, 0x6d, 0x97, 0xb0, 0x49, 0x1f, 0xd9, 0xe1, 0x14, 0x2c, 0xa8, 
  0x4a, 0xbf, 0x8d, 0x25, 0x64, 0x89, 0xf4, 0x51, 0xae, 0xe2, 0xd6, 0xaf, 
  0x4d, 0x4b, 0x8a, 0x42, 0x76, 0xf2, 0x1b, 0x16, 0x10, 0xfa, 0x58, 0x65, 
  0xf9, 0xd0, 0x8b, 0xa6, 0xb9, 0xcb, 0x4a, 0xd5, 0xd3, 0xd1, 0xd6, 0xac, 
  0xdb, 0x47, 0x22, 0x44, 0x91, 0x8c, 0x6d, 0xd1, 0x96, 0xdb, 0xba, 0x6e, 
  0xe5, 0x6a, 0xb1, 0x48, 0x66, 0xad, 0xe5, 0x20, 0x88, 0x1d, 0xe2, 0x4d, 
  0x69, 0xc4, 0x86, 0xb2, 0xd9, 0xbf, 0xb7, 0x77, 0xb7, 0x7a, 0x95, 0xc1, 
  0xfa, 0x1a, 0x8d, 0x0d, 0x43, 0xf2, 0xa2, 0x6f, 0x2d, 0x41, 0xfd, 0x13, 
  0x14, 0xca, 0x6a, 0x41, 0x14, 0x19, 0x08, 0x4f, 0x31, 0x47, 0xcd, 0x2f, 
  0x83, 0x0d, 0xa4, 0x7e, 0xd6, 0xe4, 0x94, 0xb3, 0x4c, 0x30, 0x4f, 0x50, 
  0x69, 0x4e, 0x04, 0xe4, 0x14, 0xb2, 0xc7, 0x24, 0x93, 0xbc, 0x49, 0x08, 
  0x1c, 0x01, 0x0c, 0x3f, 0xae, 0x7c, 0xea, 0xa5, 0x71, 0x59, 0x24, 0x28, 
  0x85, 0x95, 0x67, 0x70, 0xf3, 0x16, 0x92, 0x39, 0xe5, 0xf6, 0x5a, 0xf0, 
  0x34, 0x65, 0x09, 0xa2, 0x83, 0xb3, 0xd3, 0xd3, 0xa3, 0x83, 0x4b, 0x77, 
  0x23, 0xb4, 0x39, 0xeb, 0x9a, 0x8a, 0x8f, 0x2a, 0x58, 0x92, 0x20, 0xa4, 
  0x1e, 0x69, 0x75, 0xe2, 0xf8, 0xb2, 0x0d, 0x38, 0x4a, 0xac, 0xc3, 0xb4, 
  0x4b, 0xe4, 0xe2, 0x65, 0x88, 0x51, 0x28, 0x2b, 0xb3, 0xb5, 0xb2, 0xa5, 
  0x2a, 0xb3, 0xff, 0x1e, 0x3a, 0x92, 0x6e, 0x83, 0xa3, 0x77, 0xbe, 0x1d, 
  0x60, 0xe9, 0xbd, 0xd4, 0x64, 0xde, 0xf6, 0xdc, 0x9a, 0x0b, 0xd1, 0xf7, 
  0x8b, 0x20, 0xe6, 0xa2, 0xcc, 0xf2, 0x6d, 0x0e, 0xbc, 0xe1, 0xfa, 0x91, 
  0x74, 0xa5, 0xce, 0x2c, 0x89, 0xd0, 0xf2, 0xdb, 0xd4, 0x6e, 0xd9, 0x2c, 
  0xce, 0xac, 0x8a, 0xbd, 0xaa, 0xd8, 0x62, 0x69, 0x86, 0x5f, 0x44, 0x25, 
  0x6d, 0x46, 0x1e, 0xe4, 0xea, 0x45, 0x3e, 0x2f, 0x36, 0x20, 0x99, 0x7a, 
  0xfc, 0xeb, 0xfe, 0xf0, 0x3b, 0x76, 0x29, 0x43, 0x32, 0xe0, 0x02, 0x02, 
  0x58, 0x1f, 0x79, 0xbd, 0x14, 0x06, 0x1c, 0xd6, 0x15, 0x95, 0x14, 0x83, 
  0x60, 0xeb, 0x1a, 0xa9, 0x8e, 0x8c, 0x90, 0xdb, 0x0d, 0x2b, 0x75, 0x5a, 
  0x8e, 0x33, 0xdc, 0x03, 0xb4, 0x50, 0x8a, 0x3f, 0x26, 0x20, 0x88, 0x80, 
  0x01, 0x0d, 0x3a, 0x68, 0xf1, 0xfc, 0x42, 0x2c, 0x49, 0xd9, 0xa7, 0x51, 
  0x6b, 0xa8, 0x3a, 0x98, 0x81, 0xdf, 0x00, 0x9f, 0x73, 0xd4, 0x04, 0x77, 
  0xa0, 0x15, 0x68, 0x28, 0x3b, 0x2e, 0x59, 0xba, 0xa1, 0x04, 0xc9, 0xd7, 
  0x83, 0x24, 0xea, 0x70, 0x1a, 0x75, 0x27, 0x0c, 0xdb, 0x97, 0xd8, 0x06, 
  0xf7, 0x2a, 0x4d, 0x99, 0x13, 0xba, 0xdd, 0x20, 0x5b, 0x42, 0x23, 0x8c, 
  0x8d, 0xaa, 0x31, 0x02, 0x9b, 0xb5, 0xf9, 0x76, 0x91, 0xde, 0x23, 0x48, 
  0xa7, 0x69, 0xbd, 0x70, 0xe9, 0xe1, 0x8f, 0x0c, 0x6b, 0xf7, 0xf9, 0xde, 
  0x60, 0xf7, 0xd3, 0xcf, 0xd8, 0xfe, 0xb1, 0x5b, 0x19, 0x9e, 0xd4, 0x24, 
  0xa7, 0x36, 0xe4, 0x00, 0x6d, 0xb4, 0x30, 0xdf, 0x36, 0x67, 0x4e, 0xd8, 
  0xf6, 0xfc, 0x61, 0x10, 0xb8, 0x6b, 0x2a, 0xad, 0xab, 0x3b, 0xa7, 0x51, 
  0x99, 0x52, 0x29, 0x9e, 0xa5, 0x32, 0x8e, 0xe7, 0xbb, 0x9a, 0x25, 0x5a, 
  0x6d, 0x55, 0x35, 0xdf, 0x2d, 0x97, 0x95, 0x41, 0xbc, 0x0a, 0x62, 0x6e, 
  0xe0, 0x76, 0xea, 0xae, 0x99, 0xa8, 0x01, 0x63, 0x6e, 0xfc, 0xe7, 0x32, 
  0xb9, 0x41, 0xc7, 0x1c, 0xa6, 0x3e, 0x2a, 0xc0, 0x97, 0xc6, 0x92, 0x2d, 
  0x21, 0xae, 0x0a, 0xf2, 0xd7, 0x4a, 0xa0, 0x06, 0xf3, 0x39, 0x30, 0xfb, 
  0x31, 0x1e, 0xad, 0x15, 0x58, 0x0b, 0x0e, 0xc2, 0x51, 0x50, 0xe5, 0x2d, 
  0x34, 0x6b, 0xa0, 0x4d, 0x97, 0x89, 0x5a, 0xad, 0x2d, 0x37, 0xd0, 0xd7, 
  0x20, 0x24, 0x90, 0xba, 0x3a, 0xf3, 0x71, 0x9d, 0xfc, 0xda, 0x5f, 0xfe, 
  0x12, 0xf0, 0x9c, 0x7f, 0xd6, 0x20, 0x6a, 0xd4, 0x51, 0x24, 0x99, 0x02, 
  0x3e, 0xa9, 0x27, 0xb3, 0x5c, 0x14, 0x9f, 0x93, 0xd4, 0x33, 0x53, 0xc4, 
  0xac, 0xe1, 0x75, 0x0e, 0xf3, 0x8b, 0xc2, 0x2a, 0xef, 0x48, 0x9a, 0xd1, 
  0xb4, 0x3f, 0x2d, 0xf9, 0x27, 0x5e, 0xf8, 0x20, 0x0d, 0xac, 0xc5, 0xeb, 
  0x5c, 0x73, 0xe0, 0x56, 0xb3, 0x2a, 0x34, 0x26, 0x24, 0xe1, 0x6a, 0xe4, 
  0x50, 0x5b, 0x83, 0xc9, 0xfd, 0x1f, 0x6a, 0x16, 0x69, 0x47, 0x9c, 0x5c, 
  0x86, 0x91, 0xb7, 0x73, 0x53, 0x94, 0x2d, 0x42, 0xc9, 0xd0, 0x7c, 0x94, 
  0x96, 0x30, 0xab, 0x05, 0x31, 0x9b, 0xc1, 0x8d, 0xe2, 0x11, 0x87, 0x07, 
  0xd1, 0xff, 0x59, 0x35, 0x85, 0x10, 0x2b, 0xc7, 0x27, 0x59, 0x98, 0x6c, 
  0xa2, 0xf9, 0xea, 0xe8, 0xf5, 0xd9, 0xc5, 0x51, 0xb5, 0xd6, 0xbc, 0xca, 
  0xde, 0xf1, 0x8d, 0x40, 0xa1, 0xb0, 0xa9, 0x87, 0x46, 0xc2, 0xa8, 0x88, 
  0x75, 0xa1, 0x10, 0xe8, 0xc5, 0x06, 0x30, 0x23, 0x81, 0x75, 0xd1, 0xf9, 
  0xf7, 0x87, 0x51, 0x2d, 0xa4, 0x14, 0xa7, 0x73, 0x0b, 0x90, 0x96, 0x52, 
  0x94, 0xa8, 0xbd, 0x2a, 0x20, 0x82, 0x9f, 0xa5, 0x3b, 0x69, 0x99, 0x95, 
  0xc2, 0x31, 0x1b, 0xf6, 0x39, 0x90, 0xc3, 0x46, 0x17, 0x42, 0x50, 0xce, 
  0x4d, 0xe4, 0x8a, 0x26, 0x71, 0x51, 0xbf, 0x3a, 0xba, 0xfd, 0x6e, 0xb3, 
  0x4b, 0xc4, 0x3b, 0x62, 0xe6, 0xd2, 0xc5, 0x2c, 0x1d, 0x89, 0xe9, 0x87, 
  0x31, 0xf3, 0x11, 0x61, 0x37, 0xb1, 0x58, 0xe8, 0x75, 0x50, 0xee, 0x3d, 
  0x01, 0x88, 0xd4, 0x4a, 0x6e, 0x95, 0xe8, 0x22, 0xed, 0x65, 0xb3, 0xd8, 
  0xaa, 0x00, 0x65, 0xf2, 0xe7, 0xcd, 0xea, 0x21, 0x0b, 0x07, 0xe3, 0xde, 
  0xfd, 0x4b, 0x77, 0xe0, 0x8d, 0x05, 0x21, 0x62, 0x50, 0x3c, 0x47, 0x44, 
  0x3c, 0x0a, 0x48, 0xc9, 0x04, 0x2c, 0x17, 0xae, 0x35, 0x2e, 0xd7, 0x65, 
  0xa7, 0x28, 0xd4, 0xac, 0xcb, 0xb8, 0x70, 0x28, 0x32, 0xd2, 0x48, 0x2f, 
  0x2c, 0xa6, 0xca, 0x42, 0x53, 0xb3, 0x88, 0x65, 0x80, 0x57, 0x80, 0x0c, 
  0x30, 0xc9, 0xd7, 0x95, 0x41, 0xf2, 0xf4, 0x11, 0xdf, 0x56, 0x3c, 0x2c, 
  0x4a, 0xdc, 0xa2, 0x08, 0xa9, 0x18, 0x67, 0x39, 0xa4, 0x9d, 0x66, 0xd4, 
  0xb0, 0xa7, 0xbb, 0x82, 0xc1, 0x51, 0x9f, 0x3f, 0x7b, 0xce, 0xa7, 0x04, 
  0x85, 0x8c, 0xfe, 0x73, 0x88, 0xbd, 0xb0, 0xe4, 0xcc, 0xa3, 0xd5, 0x74, 
  0xc2, 0x30, 0xb4, 0x4a, 0x29, 0x9d, 0x10, 0xab, 0x5e, 0xec, 0x08, 0xc8, 
  0x7e, 0xb3, 0xd9, 0xb7, 0x60, 0x46, 0x5a, 0xae, 0x3b, 0x5b, 0x6e, 0xb4, 
  0x6a, 0x0e, 0x0a, 0xab, 0x56, 0xca, 0x9e, 0x37, 0x0a, 0xec, 0xc8, 0x93, 
  0xad, 0x15, 0x9d, 0xb0, 0x53, 0x35, 0xe4, 0x80, 0x41, 0xc3, 0xe4, 0xe7, 
  0xaa, 0x06, 0x35, 0x4a, 0xeb, 0xe4, 0xdb, 0x58, 0x88, 0x2b, 0x5a, 0x02, 
  0xfc, 0xf8, 0x62, 0x1d, 0x0e, 0x09, 0xcb, 0x66, 0x9c, 0x88, 0x85, 0x5c, 
  0x12, 0x8e, 0xbd, 0xd3, 0x92, 0x4d, 0x9b, 0x7c, 0x09, 0xc6, 0xb0, 0xbe, 
  0xf1, 0x31, 0x36, 0x8b, 0xf2, 0x96, 0xc6, 0xec, 0x36, 0x4a, 0xd2, 0x53, 
  0x6b, 0xbb, 0x83, 0x5d, 0xc1, 0x45, 0x0b, 0xd9, 0xce, 0x05, 0xb7, 0x56, 
  0xd8, 0xd6, 0x85, 0xa8, 0x31, 0x8c, 0x48, 0xb1, 0xc6, 0xdc, 0xc9, 0x41, 
  0x72, 0x0d, 0x4a, 0xd8, 0xe9, 0x3f, 0x7d, 0xfe, 0x3c, 0xc0, 0xd0, 0x4a, 
  0x93, 0x90, 0xf7, 0x3f, 0xdb, 0xd9, 0x91, 0xd0, 0xc1, 0xfa, 0x6b, 0xf4, 
  0x45, 0xff, 0x39, 0x5e, 0xac, 0xbe, 0xa6, 0xf2, 0xef, 0xda, 0xf7, 0xfa, 
  0xfc, 0x4d, 0x4b, 0x77, 0xb8, 0x55, 0xd7, 0xbe, 0xf5, 0x7c, 0xcd, 0x5b, 
  0x92, 0x83, 0x22, 0xc0, 0xf6, 0xd3, 0x29, 0xc3, 0x4d, 0xe1, 0x49, 0x80, 
  0xda, 0x67, 0xf9, 0x5d, 0xdc, 0x8c, 0x19, 0xd9, 0xe9, 0xef, 0xf4, 0xfa, 
  0xbb, 0xeb, 0xa6, 0xeb, 0xc0, 0x54, 0xb0, 0x65, 0x2c, 0x41, 0x6d, 0xfe, 
  0x79, 0x6b, 0xf3, 0x9b, 0xad, 0xb6, 0xd9, 0xff, 0x75, 0x67, 0xa7, 0xf7, 
  0x29, 0xff, 0x7c, 0xfe, 0xbc, 0x5d, 0xc4, 0xa8, 0xf4, 0xf1, 0xc4, 0xa6, 
  0x56, 0x19, 0x2d, 0xb5, 0xd3, 0xd2, 0xfa, 0x2e, 0xb5, 0xba, 0xfb, 0xfc, 
  0x79, 0x8f, 0x7b, 0x79, 0xf6, 0x41, 0xad, 0x97, 0x77, 0x99, 0xc7, 0x3b, 
  0xd8, 0x75, 0x5d, 0x81, 0xe6, 0x8a, 0xda, 0x14, 0xe8, 0xcf, 0xe8, 0x15, 
  0xa2, 0x29, 0x83, 0x52, 0x47, 0x5e, 0xcd, 0x0c, 0x23, 0xed, 0x11, 0xc6, 
  0xbe, 0x84, 0x8f, 0x17, 0x1c, 0x34, 0x8e, 0x3c, 0x2a, 0xf3, 0x86, 0xcf, 
  0xb5, 0x85, 0xfd, 0xce, 0x57, 0x35, 0x82, 0x91, 0xde, 0x1c, 0x80, 0x12, 
  0x65, 0xc7, 0xbc, 0xed, 0x2e, 0xce, 0xd5, 0xcb, 0x0b, 0xa3, 0xac, 0xa3, 
  0x6d, 0xcb, 0x75, 0x20, 0x15, 0x93, 0x05, 0x04, 0xf5, 0x56, 0xfb, 0xc8, 
  0x3e, 0xcb, 0xd4, 0x12, 0x3f, 0xdb, 0xa4, 0x17, 0xe1, 0x9c, 0x52, 0x33, 
  0x62, 0x5c, 0x90, 0xe4, 0xa0, 0x50, 0xe9, 0xe5, 0xbb, 0x87, 0x87, 0x8a, 
  0xd9, 0x0b, 0xc8, 0x5a, 0xd7, 0x87, 0xa3, 0x9a, 0xf4, 0x64, 0xc8, 0xc3, 
  0x12, 0xf0, 0xe8, 0xd0, 0x79, 0xdc, 0x2c, 0xf8, 0xb4, 0xe9, 0xa1, 0x75, 
  0x81, 0xa4, 0x85, 0x25, 0xaf, 0xb8, 0x50, 0x12, 0xd1, 0x32, 0x24, 0x72, 
  0x4a, 0xf8, 0xf4, 0x3d, 0x5d, 0x34, 0x88, 0x73, 0xed, 0x17, 0x65, 0xb6, 
  0x74, 0xa8, 0x97, 0x9b, 0x16, 0x96, 0x43, 0xaf, 0x3b, 0x9c, 0x32, 0xbd, 
  0x2f, 0xe4, 0xbc, 0x12, 0x3f, 0x9e, 0x73, 0x3e, 0xf8, 0x64, 0x0b, 0xa1, 
  0x2c, 0x93, 0x64, 0x89, 0x78, 0x52, 0x15, 0x77, 0x58, 0xdd, 0x27, 0x9e, 
  0xbe, 0x51, 0x65, 0xf5, 0xd1, 0xf0, 0xf8, 0xff, 0x1e, 0x0d, 0x7e, 0x0f, 
  0x21, 0xb6, 0x66, 0x58, 0xbe, 0xf0, 0xae, 0x09, 0x7e, 0x6b, 0x6d, 0x65, 
  0x4b, 0x07, 0x00, 0x19, 0x62, 0xee, 0xd8, 0x6d, 0x1f, 0xc8, 0xb3, 0x24, 
  0xa2, 0xa1, 0x82, 0xb7, 0x84, 0x1a, 0xb4, 0x44, 0x59, 0xd2, 0x92, 0xcd, 
  0x97, 0x2d, 0x0e, 0x09, 0xc1, 0x43, 0xb5, 0xd8, 0x3b, 0xf6, 0x7d, 0xbb, 
  0x5a, 0x7a, 0xd2, 0x59, 0xb3, 0xb9, 0xc0, 0x4b, 0x22, 0x9b, 0x4c, 0x2f, 
  0x22, 0x09, 0xd2, 0xf5, 0xf3, 0x1f, 0x5a, 0xd6, 0x10, 0x48, 0x3b, 0xf1, 
  0x81, 0x1f, 0xcd, 0x3c, 0x3c, 0x56, 0xfb, 0x2b, 0x97, 0x67, 0xc2, 0x89, 
  0x92, 0x2f, 0x69, 0xa3, 0xbf, 0x68, 0xf6, 0x1c, 0x8b, 0x64, 0xc3, 0x3a, 
  0xae, 0x14, 0x42, 0xe1, 0xce, 0x45, 0xc4, 0x48, 0xd4, 0x22, 0x1f, 0x24, 
  0xf6, 0x4a, 0x5d, 0x43, 0x07, 0x22, 0xb6, 0x26, 0x0f, 0x31, 0x2c, 0xab, 
  0x2c, 0x9d, 0x63, 0x7a, 0x1e, 0x1a, 0x51, 0x7c, 0x22, 0x2a, 0x5d, 0x5d, 
  0xa5, 0xf0, 0xc9, 0xac, 0x96, 0x83, 0x86, 0x2f, 0xcc, 0x4a, 0x85, 0x38, 
  0x27, 0x1a, 0x75, 0xbf, 0xa3, 0xe6, 0x01, 0x8c, 0x0a, 0xc7, 0x16, 0x7d, 
  0xf0, 0xe8, 0x34, 0x7d, 0x77, 0x4d, 0xb5, 0x34, 0x95, 0xd9, 0x11, 0xdf, 
  0xe8, 0xa6, 0xac, 0x73, 0x46, 0xb0, 0x56, 0xa1, 0x15, 0x98, 0x5e, 0xf0, 
  0xa2, 0x48, 0xec, 0x6d, 0xcf, 0x92, 0xba, 0x9e, 0xdd, 0xdf, 0x37, 0xd3, 
  0xfc, 0xc5, 0x75, 0x80, 0x90, 0x71, 0x4e, 0xd1, 0x55, 0xe3, 0x1a, 0x3d, 
  0x5a, 0xfd, 0xf2, 0xf1, 0xa4, 0x70, 0x12, 0xbb, 0x56, 0x9a, 0xb3, 0xc3, 
  0x2b, 0x15, 0x07, 0xab, 0x68, 0x61, 0x32, 0x9a, 0x33, 0x7d, 0x17, 0xf3, 
  0xaa, 0x36, 0x23, 0x15, 0xcc, 0xea, 0x03, 0x69, 0x13, 0xb9, 0xd2, 0x48, 
  0x1d, 0x9f, 0x21, 0x30, 0xba, 0xbc, 0xa6, 0xd3, 0x8a, 0x82, 0x88, 0xba, 
  0x48, 0xd6, 0xe8, 0x24, 0x5b, 0xa9, 0xea, 0xd7, 0xb8, 0xa8, 0x25, 0xfd, 
  0x1e, 0x84, 0x46, 0x92, 0x69, 0x3a, 0x93, 0x4a, 0x32, 0x31, 0xd0, 0x6e, 
  0x77, 0x69, 0xfd, 0xd3, 0xc5, 0x4a, 0xb3, 0x2f, 0x05, 0xe7, 0xcc, 0x23, 
  0x4d, 0xb4, 0x2e, 0x3b, 0x47, 0x0e, 0x3b, 0x38, 0x78, 0x3d, 0x62, 0x45, 
  0xe0, 0xff, 0x2b, 0xa5, 0x0e, 0x46, 0xf4, 0x95, 0x57, 0x25, 0xb1, 0x16, 
  0x7d, 0xbc, 0xda, 0x44, 0x07, 0xa9, 0x94, 0x7f, 0x06, 0xdc, 0xfe, 0x3d, 
  0x2d, 0xb6, 0x24, 0x01, 0x31, 0x70, 0xd6, 0xf8, 0x86, 0x21, 0x79, 0x69, 
  0x01, 0xae, 0xb2, 0x9c, 0x36, 0x74, 0x6e, 0x31, 0xd7, 0xb8, 0x0e, 0xea, 
  0x12, 0x81, 0x76, 0xe5, 0x02, 0xd9, 0x41, 0xe1, 0x92, 0x35, 0x29, 0x72, 
  0x7f, 0x56, 0x2a, 0xf3, 0x12, 0x7b, 0x9f, 0x46, 0x14, 0xdb, 0xa8, 0x1b, 
  0x7e, 0x4e, 0x75, 0xfe, 0x05, 0x71, 0x1c, 0x7b, 0x83, 0x27, 0x1f, 0x00, 
  0x89, 0xa5, 0xe7, 0xdd, 0x89, 0xc0, 0xc6, 0x2f, 0xd5, 0xcb, 0x1b, 0xa3, 
  0x80, 0xa8, 0x0b, 0x60, 0x68, 0xac, 0xf1, 0xd8, 0xca, 0xb2, 0x88, 0x36, 
  0xd1, 0x38, 0xfe, 0xb2, 0x96, 0x8f, 0x84, 0xe9, 0x7b, 0x58, 0x89, 0x62, 
  0x96, 0x24, 0x4b, 0x5d, 0x5a, 0xaf, 0x9b, 0x60, 0x05, 0x6c, 0x13, 0x91, 
  0x3f, 0x23, 0xf4, 0x0a, 0x0e, 0xb1, 0x8e, 0x11, 0x40, 0xe5, 0xd2, 0x4a, 
  0x47, 0xee, 0x12, 0x2f, 0x1b, 0x87, 0x0f, 0x01, 0xcb, 0xa2, 0x99, 0x3d, 
  0x76, 0x72, 0xfd, 0xde, 0xea, 0x76, 0xe8, 0xfe, 0xba, 0x61, 0xe9, 0xa6, 
  0x6c, 0x55, 0x8b, 0xbe, 0x35, 0x91, 0xda, 0x16, 0x08, 0xcc, 0x67, 0x40, 
  0x1f, 0xc9, 0x27, 0x4d, 0xa7, 0x8e, 0x4b, 0x02, 0xbe, 0x54, 0x23, 0x2d, 
  0x07, 0x01, 0x07, 0xe2, 0x1a, 0x3c, 0x42, 0xc8, 0x8d, 0xe0, 0xe3, 0x5f, 
  0x92, 0x3c, 0x93, 0x03, 0xe0, 0xab, 0xf1, 0x9a, 0x28, 0x63, 0x23, 0x0f, 
  0x07, 0x3e, 0xa8, 0x91, 0x49, 0xc3, 0x74, 0xf7, 0xbf, 0x87, 0x68, 0xde, 
  0x9b, 0xde, 0xa1, 0x3e, 0xf7, 0x12, 0x50, 0xc9, 0xf4, 0x60, 0x6e, 0x06, 
  0x1f, 0x80, 0xaf, 0x06, 0xea, 0xb3, 0xb0, 0x30, 0x47, 0x17, 0x7a, 0x39, 
  0xd7, 0x8f, 0xcf, 0x85, 0xf2, 0x28, 0x63, 0x27, 0x28, 0xb9, 0x15, 0xb3, 
  0x20, 0xc1, 0x68, 0x34, 0x9b, 0x1c, 0x24, 0xa4, 0x43, 0xdb, 0xe2, 0x8f, 
  0x11, 0x08, 0xab, 0xd6, 0x22, 0xf4, 0xde, 0x2c, 0x15, 0xc2, 0x71, 0xf2, 
  0xc2, 0xba, 0x26, 0x61, 0x1e, 0x8c, 0xa6, 0xc1, 0x9c, 0x66, 0x6c, 0x1d, 
  0x76, 0xa8, 0xbc, 0xae, 0x1d, 0x7d, 0xb3, 0xc1, 0xf1, 0xad, 0x9d, 0x44, 
  0x1a, 0xe8, 0x85, 0x09, 0xa0, 0x6e, 0xd0, 0xf0, 0x36, 0x88, 0xe6, 0x0f, 
  0xab, 0xb0, 0xdd, 0x97, 0x2d, 0xc9, 0x27, 0x72, 0x51, 0xb2, 0x41, 0x00, 
  0x76, 0x11, 0x9e, 0x4f, 0x4b, 0xd2, 0x0e, 0x76, 0x80, 0x1a, 0x49, 0xb3, 
  0x09, 0x8c, 0x1d, 0xc2, 0x9d, 0xe2, 0x46, 0x01, 0x1a, 0x36, 0x4e, 0xda, 
  0x68, 0xba, 0x85, 0xcb, 0xc2, 0xc2, 0xfb, 0x3d, 0x35, 0x05, 0x56, 0xb2, 
  0x76, 0x06, 0x72, 0xc9, 0x46, 0x8f, 0xc0, 0x19, 0x12, 0x37, 0x04, 0x7d, 
  0x97, 0x22, 0x1f, 0x5b, 0x4a, 0x8a, 0x63, 0xda, 0xbf, 0x82, 0xe1, 0xad, 
  0x95, 0x71, 0x1a, 0xe4, 0xeb, 0x65, 0xc4, 0xdf, 0x42, 0xbb, 0x05, 0xe7, 
  0xe5, 0xa3, 0x1a, 0x4f, 0x5d, 0x9e, 0x90, 0x12, 0x3d, 0x73, 0xbe, 0x92, 
  0xa3, 0x43, 0x29, 0x4b, 0xcd, 0x59, 0x06, 0xcb, 0x3c, 0xbb, 0x82, 0x85, 
  0x5b, 0xed, 0x8c, 0xb9, 0xf2, 0xa5, 0x39, 0x87, 0x9b, 0x5e, 0xe1, 0x6a, 
  0x42, 0x0e, 0x4b, 0x1d, 0xa3, 0x84, 0x0f, 0xfa, 0x7c, 0xf5, 0x58, 0x78, 
  0xf0, 0xef, 0xe3, 0x2a, 0xad, 0xf6, 0xd1, 0x1f, 0xf2, 0xfc, 0x68, 0xdc, 
  0x7d, 0x8c, 0x72, 0x1d, 0x38, 0xba, 0x1a, 0x7b, 0x05, 0x30, 0x21, 0xc8, 
  0xc0, 0xe1, 0x09, 0x57, 0xa6, 0xc7, 0x84, 0xcf, 0xfc, 0x17, 0xb5, 0xe4, 
  0x06, 0xbf, 0x63, 0x94, 0x03, 0x77, 0x55, 0xb7, 0x83, 0x70, 0xc7, 0x21, 
  0x9b, 0xe1, 0x4a, 0xc5, 0x45, 0xf4, 0x12, 0x11, 0x58, 0x2f, 0x58, 0xa9, 
  0x69, 0xd4, 0x07, 0x7e, 0xdb, 0xa8, 0xf2, 0x38, 0x3c, 0x3b, 0xf8, 0x76, 
  0xf8, 0xcc, 0x9c, 0xb5, 0x86, 0x1a, 0xc5, 0x0a, 0x91, 0xc5, 0xba, 0x49, 
  0x40, 0xf8, 0x5a, 0x24, 0x2a, 0x08, 0x56, 0xcc, 0xe8, 0x8b, 0x62, 0x35, 
  0x47, 0x0d, 0x3e, 0x79, 0x7d, 0x77, 0xe7, 0xb3, 0x9d, 0x76, 0x8a, 0x26, 
  0x4d, 0x71, 0xeb, 0xf1, 0xa4, 0x7b, 0x5f, 0x59, 0x54, 0x0a, 0x19, 0x58, 
  0xdd, 0xf5, 0x95, 0x24, 0x76, 0x7a, 0x0f, 0x6b, 0x4f, 0x19, 0x56, 0x5d, 
  0xae, 0x61, 0xfd, 0x94, 0x36, 0x7a, 0x05, 0x1d, 0x2d, 0xb9, 0x1f, 0xcf, 
  0x48, 0x14, 0xba, 0xfd, 0xa8, 0xc8, 0x81, 0x45, 0x39, 0xa1, 0x31, 0xb7, 
  0x9b, 0xd3, 0x2e, 0x2c, 0xcf, 0x16, 0x62, 0x24, 0x03, 0x32, 0x09, 0xaa, 
  0x8f, 0xbe, 0x63, 0x45, 0x6c, 0xdc, 0x9e, 0x68, 0x22, 0x97, 0x86, 0xb5, 
  0xb6, 0x66, 0x73, 0xfa, 0x5a, 0x2e, 0x12, 0x43, 0x8c, 0xb4, 0xa6, 0x6e, 
  0xbf, 0x6b, 0xbb, 0x61, 0xaa, 0xb1, 0x43, 0x32, 0x43, 0xee, 0x8f, 0x44, 
  0x4e, 0x3e, 0xba, 0xf4, 0x9a, 0x30, 0xb9, 0xcc, 0xb8, 0xda, 0xfa, 0x9d, 
  0x56, 0x5b, 0xe8, 0xba, 0x18, 0xcb, 0x98, 0x08, 0x91, 0xe1, 0xbd, 0x71, 
  0x1e, 0x88, 0x6f, 0x34, 0xf9, 0x82, 0x25, 0xff, 0x4a, 0x69, 0xfb, 0x65, 
  0x8c, 0x02, 0x14, 0xe9, 0xc7, 0x2d, 0x1a, 0x5c, 0x8e, 0x97, 0xfd, 0x45, 
  0xd6, 0x26, 0xe0, 0x5e, 0x72, 0x42, 0xaa, 0x29, 0xde, 0x97, 0x07, 0xe7, 
  0xef, 0x4e, 0xcf, 0x0e, 0x8f, 0x4e, 0xf6, 0x7f, 0x74, 0x95, 0xcd, 0xcc, 
  0x65, 0xc1, 0xe7, 0xf9, 0x5d, 0x12, 0x17, 0x0f, 0xef, 0xe8, 0xb2, 0xa5, 
  0x2f, 0x37, 0x9f, 0x6c, 0xb1, 0x71, 0xa3, 0x51, 0x87, 0xe5, 0x2a, 0xa9, 
  0xa4, 0xa0, 0xa9, 0xbe, 0xe1, 0xe7, 0xd1, 0xa8, 0x95, 0xb6, 0xf7, 0x1b, 
  0x11, 0x5c, 0x45, 0x2c, 0x0c, 0x31, 0x5c, 0x19, 0x4b, 0x80, 0x2e, 0xa5, 
  0xa2, 0x0d, 0xc0, 0xa0, 0x81, 0xde, 0x5a, 0xd2, 0x11, 0x29, 0x93, 0xd9, 
  0x22, 0x29, 0x35, 0x57, 0x29, 0x7a, 0x79, 0x76, 0x7e, 0xf9, 0xea, 0x36, 
  0x6e, 0x60, 0x3b, 0x22, 0xe2, 0x4d, 0xf1, 0xca, 0x8d, 0x16, 0xe5, 0x4d, 
  0x17, 0x8f, 0xc0, 0xb1, 0xd5, 0x0a, 0x40, 0xe9, 0x9e, 0xa4, 0x23, 0xd6, 
  0x70, 0x94, 0x5e, 0x5e, 0xfe, 0x78, 0x7e, 0xf4, 0xea, 0x25, 0x83, 0x03, 
  0x7d, 0x21, 0xf5, 0xed, 0xc3, 0xa2, 0xdc, 0x82, 0x93, 0x59, 0x7f, 0xe7, 
  0x87, 0xc3, 0xe3, 0xe1, 0xf9, 0xc9, 0xd9, 0xc1, 0xab, 0x97, 0x3f, 0x18, 
  0x4a, 0x72, 0xf0, 0xae, 0xfb, 0xcc, 0xe5, 0x54, 0x37, 0x93, 0x89, 0x8f, 
  0xbe, 0x7f, 0x77, 0x74, 0xfa, 0xdd, 0xab, 0x97, 0xb7, 0x71, 0xde, 0xe3, 
  0xf9, 0xc9, 0xdb, 0x00, 0xd9, 0x6e, 0x26, 0xdd, 0x05, 0x4b, 0x74, 0xc9, 
  0x18, 0xee, 0xa8, 0xb6, 0xf3, 0x88, 0x29, 0x5c, 0x4e, 0x87, 0xcb, 0xd8, 
  0x35, 0x33, 0x91, 0x3b, 0xab, 0x81, 0x85, 0xa2, 0xea, 0x59, 0x42, 0xac, 
  0x63, 0xdb, 0xd9, 0x75, 0x90, 0x50, 0x3e, 0x78, 0xd3, 0xe0, 0x9d, 0x5c, 
  0xab, 0xf4, 0x72, 0x2f, 0x48, 0x65, 0x14, 0x30, 0xa0, 0xc7, 0xed, 0x23, 
  0x02, 0xb3, 0xea, 0x6d, 0x81, 0x0f, 0xe6, 0x77, 0x90, 0x8c, 0x13, 0x9a, 
  0x81, 0x20, 0x7a, 0x6d, 0xdb, 0x69, 0xe0, 0x53, 0xb5, 0xb6, 0xf8, 0xae, 
  0xa0, 0x5e, 0x30, 0xf7, 0x64, 0xa8, 0x56, 0xcc, 0x0d, 0xc3, 0xb1, 0xa0, 
  0x8d, 0xea, 0x24, 0x24, 0x32, 0xb4, 0x71, 0x7d, 0xfa, 0xd4, 0x4f, 0x0e, 
  0xf8, 0xbc, 0x71, 0xe3, 0xca, 0xe5, 0x44, 0xfb, 0xde, 0x8c, 0x91, 0xd5, 
  0x0c, 0x46, 0x2d, 0x25, 0x7a, 0xd4, 0xa1, 0xaa, 0x91, 0xd6, 0xa2, 0x27, 
  0xb0, 0xab, 0x9a, 0x83, 0x59, 0xd8, 0xa1, 0xe2, 0xcc, 0x9e, 0xb2, 0xb1, 
  0x8f, 0x65, 0x3f, 0x6b, 0x35, 0x4a, 0x3b, 0x8d, 0x76, 0x0c, 0x01, 0xe4, 
  0xcd, 0x71, 0xcd, 0x5c, 0xba, 0x3b, 0x2c, 0x76, 0x79, 0xfe, 0xd6, 0xfb, 
  0x6d, 0xdb, 0x20, 0xa6, 0xd7, 0xc0, 0x83, 0xda, 0x95, 0xeb, 0x17, 0xaa, 
  0xd3, 0xef, 0x44, 0x9b, 0xb1, 0x89, 0x98, 0xec, 0x87, 0xdb, 0x32, 0x3f, 
  0x71, 0xa3, 0xb2, 0x57, 0x43, 0x30, 0xf5, 0xb8, 0xd9, 0x8d, 0x9e, 0xbe, 
  0x12, 0x05, 0x01, 0xc9, 0x0e, 0x9f, 0xf5, 0x0c, 0x70, 0xba, 0x8a, 0x46, 
  0xf4, 0x18, 0x8b, 0x6d, 0x09, 0x86, 0xb0, 0x57, 0x9a, 0xcc, 0x3b, 0x84, 
  0x32, 0xfa, 0x4c, 0x8d, 0xed, 0x80, 0x70, 0xac, 0x17, 0xde, 0xe1, 0x66, 
  0xfa, 0x97, 0x12, 0xfb, 0xc5, 0x1c, 0x8d, 0x63, 0xda, 0x1b, 0xa9, 0x35, 
  0x55, 0x94, 0x76, 0x01, 0x25, 0x8c, 0x8e, 0xf8, 0x71, 0x7a, 0xf5, 0x2f, 
  0x78, 0x67, 0x19, 0xa7, 0x79, 0x60, 0x26, 0x87, 0xc3, 0x89, 0x57, 0xad, 
  0xad, 0x5c, 0x96, 0x3a, 0x52, 0x51, 0xfa, 0x6c, 0xa0, 0x70, 0x2e, 0xac, 
  0x87, 0xba, 0x34, 0x88, 0x8e, 0x55, 0x16, 0xea, 0x98, 0xe1, 0x84, 0xfa, 
  0x71, 0xb8, 0xa0, 0xbd, 0x46, 0xe2, 0x4f, 0xbc, 0x50, 0x08, 0x45, 0xf6, 
  0x72, 0x3d, 0x58, 0x9d, 0x33, 0xa5, 0x31, 0x27, 0x71, 0x2b, 0xfc, 0x80, 
  0x20, 0x5c, 0x60, 0x73, 0x11, 0xc0, 0xff, 0xb0, 0xb6, 0x48, 0x22, 0x4c, 
  0x99, 0x95, 0x42, 0x47, 0x45, 0xf9, 0x30, 0x0b, 0xe0, 0x7e, 0x25, 0xc7, 
  0xdf, 0x90, 0x1b, 0x7b, 0x02, 0xea, 0xff, 0x21, 0x88, 0x8c, 0x02, 0xf3, 
  0x7f, 0x19, 0x75, 0xfe, 0xc5, 0x83, 0xda, 0xed, 0xf1, 0xbf, 0x7b, 0xff, 
  0xee, 0x84, 0x30, 0xff, 0x32, 0xfa, 0x92, 0x83, 0xb1, 0x0b, 0xcb, 0x12, 
  0x68, 0x49, 0x0a, 0x60, 0x20, 0x80, 0xb5, 0xad, 0xa7, 0xf3, 0xab, 0x9f, 
  0x76, 0xfb, 0xbb, 0x3b, 0x3b, 0x3b, 0x3f, 0x0f, 0x96, 0xbc, 0x9a, 0x53, 
  0x34, 0xcf, 0x31, 0x48, 0xcb, 0x74, 0xcc, 0xb6, 0x7e, 0xda, 0xd1, 0x34, 
  0x46, 0x25, 0x01, 0xe9, 0x6f, 0x3b, 0xbc, 0xb6, 0x73, 0x94, 0x56, 0x68, 
  0x63, 0xbb, 0x2e, 0x65, 0x8b, 0xeb, 0x17, 0xae, 0x00, 0xf4, 0x85, 0x87, 
  0xa3, 0xc9, 0x4a, 0x6c, 0xcb, 0x31, 0x90, 0x79, 0xd5, 0x1a, 0xc7, 0xfb, 
  0x4d, 0xf7, 0xb0, 0x22, 0x0a, 0xc4, 0x65, 0xdc, 0x6b, 0x45, 0x4d, 0xc2, 
  0xb7, 0x89, 0x54, 0x96, 0xa6, 0x63, 0x14, 0x66, 0x6d, 0xf6, 0x8c, 0x7b, 
  0xcb, 0xf9, 0xd2, 0x48, 0x7d, 0x1c, 0x33, 0x3e, 0xc1, 0xf5, 0x54, 0x6d, 
  0x3a, 0xc1, 0x71, 0xe1, 0x11, 0x45, 0x19, 0x31, 0xcc, 0x32, 0xf3, 0x2c, 
  0x91, 0x2f, 0x91, 0x28, 0x1e, 0x93, 0xb9, 0x7e, 0x6f, 0xe1, 0xa7, 0x66, 
  0x29, 0x5b, 0x07, 0x1a, 0xaf, 0x8b, 0xdc, 0x8f, 0x8b, 0x71, 0x9a, 0x3e, 
  0xbe, 0xd4, 0xb1, 0x2c, 0xb4, 0xac, 0x73, 0xb8, 0xcc, 0x7e, 0x9d, 0x45, 
  0x11, 0x77, 0x2b, 0xfd, 0xff, 0x8f, 0xa5, 0xb6, 0xb4, 0x56, 0xcb, 0x8c, 
  0xf7, 0xa9, 0xd9, 0x98, 0xaa, 0xa4, 0x66, 0xcf, 0x12, 0x6a, 0xb4, 0x30, 
  0xa7, 0x46, 0x74, 0x9d, 0xdc, 0xcb, 0xcd, 0xdc, 0x8c, 0x5f, 0x54, 0xaf, 
  0xd1, 0x35, 0x07, 0x2b, 0x0a, 0xc2, 0xe4, 0xf0, 0xe0, 0xf8, 0xb8, 0x92, 
  0x84, 0xc1, 0x8b, 0x07, 0xc7, 0x8f, 0xa8, 0x8a, 0x05, 0x57, 0xdd, 0x61, 
  0x55, 0x18, 0xc3, 0x6d, 0x2b, 0xc5, 0x26, 0x68, 0x75, 0x1c, 0xf7, 0x11, 
  0x17, 0xa9, 0x39, 0xeb, 0x62, 0xb1, 0x8d, 0x92, 0x3a, 0x4e, 0x57, 0x37, 
  0xa0, 0x16, 0x57, 0x74, 0x98, 0x8a, 0xff, 0x71, 0x52, 0x6a, 0x71, 0x22, 
  0x9d, 0xe7, 0xea, 0xe1, 0x82, 0x45, 0x12, 0x86, 0x5f, 0x71, 0x02, 0x71, 
  0x4e, 0x1d, 0x73, 0x71, 0x21, 0x2a, 0x9a, 0x0d, 0x8d, 0x69, 0x94, 0x15, 
  0x0a, 0xe5, 0x2b, 0xe5, 0xd8, 0x9a, 0xf1, 0xe8, 0x56, 0x2c, 0x63, 0xf0, 
  0xdf, 0x50, 0xfb, 0x80, 0xa1, 0x06, 0x45, 0x76, 0xae, 0x4e, 0x7d, 0xf7, 
  0xe9, 0x60, 0xc7, 0x9e, 0x0b, 0xd6, 0x60, 0xa5, 0x75, 0x7f, 0xa2, 0x97, 
  0xfc, 0xef, 0x0b, 0x43, 0x24, 0x58, 0x0b, 0x6f, 0xad, 0x50, 0x17, 0x95, 
  0xb2, 0xe4, 0xae, 0xf0, 0x25, 0x72, 0x68, 0xb4, 0xdc, 0x79, 0x2d, 0x00, 
  0xbe, 0xda, 0xdc, 0x99, 0xd3, 0x87, 0x3d, 0x2e, 0x88, 0xd4, 0x1c, 0xaa, 
  0xc1, 0x11, 0x7c, 0x44, 0x25, 0xeb, 0xad, 0xe9, 0xdc, 0xbf, 0x66, 0xfe, 
  0x78, 0x34, 0xc4, 0x7d, 0x08, 0xd3, 0x87, 0xda, 0x12, 0x2b, 0x3f, 0xa6, 
  0x96, 0xc8, 0x97, 0xd6, 0x4b, 0xba, 0x46, 0xd7, 0x0d, 0x56, 0x40, 0x9a, 
  0xd9, 0xc3, 0xc9, 0xc9, 0x76, 0x75, 0xb3, 0x77, 0x04, 0x41, 0x93, 0xcf, 
  0xfe, 0x35, 0x4d, 0xc8, 0xe5, 0x4a, 0x37, 0xc3, 0x38, 0x2d, 0x7e, 0x33, 
  0xa8, 0x3c, 0xc8, 0xa2, 0x24, 0xc2, 0x39, 0x82, 0x08, 0xb7, 0xf7, 0xe0, 
  0x0e, 0xce, 0xc5, 0xcd, 0xa3, 0x20, 0x05, 0x95, 0x52, 0x68, 0x12, 0xcf, 
  0xc3, 0xb6, 0x4b, 0x8e, 0xc0, 0xc9, 0xb3, 0x99, 0x08, 0x3a, 0x6d, 0x6a, 
  0x21, 0x50, 0xa7, 0x0b, 0xb3, 0x02, 0xf4, 0x9c, 0x25, 0x3d, 0x4c, 0xc3, 
  0xd4, 0x24, 0xa7, 0xf7, 0xa4, 0xb0, 0x35, 0x0a, 0x5a, 0xf5, 0x6f, 0x25, 
  0xe7, 0x94, 0x8f, 0x73, 0x2b, 0x46, 0x8d, 0xa2, 0x4e, 0xf1, 0x5a, 0xe2, 
  0xb2, 0x10, 0xa4, 0x04, 0x7d, 0x63, 0xbb, 0x8c, 0x67, 0x37, 0x31, 0x5f, 
  0x0d, 0x83, 0xe8, 0x8d, 0xac, 0xeb, 0x4a, 0x0c, 0x5d, 0x6d, 0xd1, 0x82, 
  0xa3, 0xd5, 0xd5, 0x15, 0x6a, 0x86, 0x9d, 0x70, 0x04, 0x94, 0x60, 0x4f, 
  0xb9, 0x82, 0x20, 0xdd, 0x2f, 0xba, 0xea, 0x70, 0xec, 0x28, 0xe0, 0x1f, 
  0x5f, 0x4b, 0x9d, 0x48, 0xee, 0x85, 0xa6, 0xf8, 0xc5, 0x0c, 0xa7, 0x87, 
  0xda, 0x9d, 0x6d, 0x6f, 0x31, 0x90, 0x28, 0x8d, 0xca, 0x57, 0x76, 0x34, 
  0x67, 0xf5, 0x75, 0x4a, 0xcc, 0x61, 0xd1, 0xac, 0x15, 0xae, 0x28, 0x00, 
  0x0c, 0x3a, 0x26, 0xa1, 0xc7, 0xb3, 0xb6, 0x31, 0xfe, 0xd9, 0x7a, 0x63, 
  0x4b, 0x58, 0xaa, 0xa8, 0x1e, 0xb8, 0x15, 0x9b, 0x91, 0xe4, 0x52, 0x17, 
  0x42, 0xfb, 0x7f, 0x14, 0x6d, 0x3c, 0xb5, 0x04, 0x66, 0xb9, 0x94, 0x04, 
  0x31, 0x57, 0x22, 0xf2, 0x5d, 0xa9, 0x36, 0x27, 0x40, 0xca, 0x76, 0xd7, 
  0xaf, 0xeb, 0x0a, 0x22, 0xa1, 0xbb, 0x87, 0x94, 0x0a, 0xd5, 0xf4, 0xc3, 
  0x80, 0x99, 0x9a, 0x96, 0xda, 0x76, 0x3e, 0x51, 0xd3, 0x43, 0x15, 0xbc, 
  0xa0, 0xa2, 0x67, 0x29, 0x7e, 0x51, 0x01, 0x71, 0xe2, 0xbb, 0x1e, 0x0f, 
  0x26, 0x0b, 0xc9, 0x5e, 0x50, 0x03, 0x4a, 0x6f, 0x4d, 0xa8, 0x98, 0xf3, 
  0x5d, 0xba, 0x9b, 0xa3, 0x2a, 0xc9, 0x98, 0x75, 0xec, 0xf7, 0x4c, 0x24, 
  0xbb, 0x6d, 0x46, 0xf5, 0x31, 0xa9, 0x06, 0x24, 0x1f, 0xa4, 0x59, 0x37, 
  0xb1, 0x23, 0x70, 0x65, 0x55, 0x90, 0x40, 0xc4, 0x38, 0x24, 0xea, 0xc7, 
  0xc2, 0x3c, 0x1d, 0x12, 0x4f, 0x61, 0xc9, 0xda, 0x8a, 0xa5, 0x3d, 0x68, 
  0xf3, 0x04, 0xa9, 0xa3, 0x1a, 0x57, 0xa5, 0xaf, 0xb2, 0x06, 0x5d, 0x92, 
  0x05, 0x35, 0x6b, 0x82, 0x43, 0x1d, 0x41, 0xd2, 0x2e, 0x56, 0xa3, 0x29, 
  0xb3, 0x00, 0xd7, 0xe4, 0x49, 0x8e, 0x02, 0xb7, 0xe5, 0x83, 0xa6, 0x9a, 
  0xa7, 0x48, 0xee, 0x5d, 0xdc, 0x98, 0x79, 0xbb, 0x0a, 0x2a, 0xdd, 0x0a, 
  0x70, 0xac, 0x8b, 0x87, 0x21, 0x6d, 0x82, 0xc4, 0x35, 0x71, 0xac, 0x73, 
  0x6e, 0xa9, 0x2b, 0x2f, 0x3a, 0x5b, 0x26, 0x1d, 0xc5, 0x52, 0x7a, 0x4f, 
  0xbf, 0x68, 0x13, 0x7c, 0x6c, 0xc8, 0x0e, 0x07, 0xd4, 0xe9, 0x68, 0xad, 
  0xdd, 0xd3, 0xd6, 0xe6, 0xad, 0xbd, 0xbf, 0xd6, 0x0a, 0xb4, 0xbe, 0x73, 
  0xd5, 0x14, 0xc7, 0xae, 0x38, 0x6d, 0xa3, 0x3a, 0x5a, 0xa3, 0xe7, 0x8c, 
  0xd3, 0xd5, 0x07, 0xd1, 0xbe, 0x8b, 0x4a, 0x71, 0x75, 0x6d, 0x75, 0xf1, 
  0x5f, 0x34, 0x43, 0xf0, 0x6f, 0x3f, 0x8d, 0x7c, 0xb1, 0x67, 0xe6, 0xae, 
  0xf8, 0x48, 0x97, 0xb3, 0x05, 0x77, 0x12, 0x35, 0x56, 0xa2, 0xe8, 0x5b, 
  0xfe, 0x61, 0x58, 0x5a, 0x9c, 0xaa, 0xb1, 0xb6, 0xbe, 0x0b, 0x92, 0xff, 
  0xe5, 0x50, 0x0f, 0x41, 0x45, 0xaf, 0xf1, 0xcb, 0xa3, 0x35, 0x61, 0x68, 
  0x6e, 0xbf, 0x30, 0x2c, 0xd4, 0xaa, 0xcc, 0x98, 0x12, 0xc7, 0x6c, 0xa8, 
  0xcd, 0xe6, 0xcb, 0x5c, 0x2b, 0x52, 0x49, 0x6c, 0x2c, 0xfe, 0x54, 0x63, 
  0x73, 0x01, 0x8b, 0xbb, 0x72, 0x8e, 0x74, 0x4d, 0x98, 0xfd, 0xfa, 0xfe, 
  0x24, 0x61, 0xac, 0x0d, 0x41, 0xe3, 0xf1, 0xb9, 0x3d, 0x86, 0x2c, 0x64, 
  0x4d, 0xaf, 0x01, 0x27, 0x7a, 0xbc, 0xe1, 0x43, 0xbe, 0x31, 0x1c, 0x2c, 
  0x1f, 0xfc, 0xf0, 0xc8, 0x71, 0x8c, 0xdd, 0xb6, 0x07, 0xb0, 0x38, 0x78, 
  0x58, 0x6f, 0x7b, 0x09, 0x4c, 0x5b, 0xb3, 0x00, 0xb8, 0xc0, 0xe0, 0x74, 
  0x01, 0x2b, 0xba, 0x31, 0xcd, 0x73, 0x4e, 0x97, 0x66, 0xfe, 0xe0, 0xaf, 
  0xa9, 0x88, 0xae, 0x3c, 0x92, 0x26, 0x01, 0x0f, 0xc4, 0x9d, 0xf5, 0xd7, 
  0xa5, 0x2d, 0xdc, 0x26, 0x33, 0xb6, 0x4f, 0x15, 0x52, 0xcd, 0xae, 0x81, 
  0xea, 0x55, 0x3c, 0x2c, 0xc6, 0xd7, 0x87, 0xa7, 0xc3, 0xf6, 0xd7, 0x31, 
  0x5e, 0x73, 0x8f, 0xb3, 0xfb, 0x85, 0x9f, 0xce, 0xb3, 0x05, 0xfb, 0x49, 
  0xa0, 0x29, 0x31, 0xb4, 0xfd, 0xec, 0xb6, 0xc5, 0xf0, 0x3e, 0x3c, 0x3f, 
  0x3d, 0xfa, 0xfa, 0xcc, 0x7e, 0xfc, 0xb6, 0x15, 0x3e, 0x61, 0x44, 0xc4, 
  0x16, 0x1b, 0x5d, 0x63, 0x70, 0xce, 0xe4, 0xe2, 0x4d, 0xa8, 0x44, 0x7f, 
  0x00, 0x54, 0x14, 0xd2, 0xeb, 0x29, 0x05, 0x0a, 0xc6, 0x62, 0x7b, 0x73, 
  0xf0, 0xe1, 0xee, 0x7d, 0xfd, 0x55, 0x93, 0xdd, 0x1f, 0x9e, 0xae, 0xe9, 
  0x8e, 0xbf, 0xe9, 0x5b, 0x59, 0x51, 0xbd, 0x6f, 0x25, 0x51, 0x05, 0xab, 
  0xd3, 0xb2, 0x2a, 0xc3, 0xf3, 0x63, 0xfb, 0x51, 0x99, 0xba, 0x5d, 0x71, 
  0x7c, 0xba, 0x85, 0xc4, 0x39, 0x8e, 0x3b, 0x29, 0x59, 0xd7, 0x19, 0xcd, 
  0x62, 0xba, 0xf6, 0x20, 0xe6, 0xb6, 0x8f, 0x5c, 0x2a, 0x39, 0x86, 0x08, 
  0x40, 0xc1, 0x2a, 0x6b, 0x1a, 0x9d, 0xc1, 0x74, 0xf8, 0xb2, 0x07, 0x4d, 
  0x0e, 0xee, 0xfc, 0x0f, 0x8a, 0xcf, 0xe7, 0xef, 0xa4, 0x3b, 0xba, 0x93, 
  0xe0, 0x52, 0x62, 0x79, 0x8e, 0x34, 0x7c, 0xdc, 0x3e, 0x5f, 0x34, 0x0e, 
  0x04, 0x62, 0xc7, 0x9d, 0xd5, 0xcc, 0x8c, 0xea, 0x96, 0x35, 0x00, 0x64, 
  0x3c, 0x14, 0xb4, 0xc6, 0xe4, 0x7c, 0x0e, 0x81, 0x18, 0x50, 0xdb, 0xe0, 
  0x57, 0x0c, 0x37, 0x47, 0x3a, 0x14, 0x37, 0x94, 0xc2, 0x57, 0x68, 0x64, 
  0xe8, 0x83, 0x2b, 0xb5, 0x2d, 0xee, 0x29, 0x60, 0xb4, 0xce, 0xd3, 0xfb, 
  0x76, 0x18, 0x8c, 0xaa, 0x8c, 0x1b, 0x94, 0xa2, 0xc0, 0xbd, 0xa3, 0x55, 
  0xca, 0x5d, 0xc1, 0xd4, 0xa0, 0x0a, 0x75, 0x5c, 0x3f, 0xae, 0x1d, 0x79, 
  0xba, 0xd3, 0x0b, 0x62, 0x48, 0xa5, 0xba, 0x8b, 0x60, 0x57, 0x6a, 0xcc, 
  0xf6, 0x78, 0xc5, 0x86, 0x00, 0x98, 0x65, 0x81, 0x64, 0xe3, 0xca, 0xad, 
  0xd4, 0x9b, 0xfb, 0xd2, 0x8c, 0x0f, 0x1d, 0x33, 0x2c, 0x72, 0xe2, 0x9b, 
  0xcb, 0x9b, 0x45, 0xd3, 0x82, 0x8d, 0x82, 0x95, 0x90, 0x4e, 0xc4, 0x92, 
  0xdb, 0xa6, 0x1e, 0x00, 0x0b, 0xa2, 0xf3, 0x65, 0xbf, 0xd3, 0x7a, 0xc5, 
  0x05, 0xc0, 0x1b, 0xec, 0xf7, 0x84, 0x0c, 0xab, 0xee, 0x01, 0xb3, 0x94, 
  0x48, 0x37, 0xa6, 0xe5, 0x14, 0xab, 0x11, 0x89, 0x5a, 0xe5, 0xaa, 0x89, 
  0x2b, 0x3c, 0x7a, 0x08, 0xaa, 0xcc, 0xb3, 0x94, 0xcf, 0xeb, 0xef, 0x74, 
  0x6e, 0x11, 0xd9, 0xd8, 0xb2, 0x52, 0xc2, 0x8b, 0xaa, 0xe6, 0x9a, 0x51, 
  0x82, 0x22, 0xda, 0xb3, 0xec, 0xae, 0x2e, 0x93, 0xec, 0xf3, 0x6d, 0xee, 
  0x47, 0x87, 0x2b, 0xc8, 0xbb, 0x41, 0x38, 0x99, 0xf4, 0x93, 0x7f, 0xd9, 
  0xd7, 0xef, 0x78, 0xb9, 0xfe, 0x6d, 0xcb, 0xd5, 0x6a, 0xf8, 0x88, 0x4d, 
  0x72, 0xfe, 0x04, 0xcb, 0x8f, 0x0c, 0x11, 0x59, 0x1b, 0xa4, 0xa9, 0x48, 
  0x83, 0x9f, 0xf8, 0x8a, 0xa9, 0x3a, 0x7b, 0x14, 0x69, 0x64, 0x09, 0xa0, 
  0x39, 0x59, 0x95, 0x19, 0xff, 0x4e, 0x7a, 0x0e, 0x51, 0x34, 0x63, 0x57, 
  0xb1, 0xb7, 0x2e, 0x04, 0xa5, 0xfd, 0xbb, 0x28, 0xa3, 0x71, 0x44, 0x12, 
  0x8e, 0x14, 0x3b, 0xd2, 0xcf, 0x1b, 0x4e, 0x51, 0x8f, 0x50, 0xfb, 0x89, 
  0x65, 0xa8, 0x09, 0x85, 0x6b, 0x4d, 0x6d, 0xfb, 0x4c, 0x76, 0x06, 0xa0, 
  0xa4, 0xfd, 0xc0, 0xdd, 0xd4, 0x6b, 0xc0, 0x1f, 0xb1, 0xc7, 0x44, 0x04, 
  0xa2, 0x00, 0x38, 0x47, 0xca, 0x4d, 0x7f, 0x12, 0x89, 0xa3, 0x46, 0x62, 
  0x74, 0x38, 0x8e, 0x50, 0x43, 0x45, 0x57, 0x0e, 0x74, 0xab, 0x55, 0x19, 
  0x6b, 0xe2, 0x40, 0x3a, 0xc9, 0xa5, 0xba, 0x4d, 0x16, 0x19, 0x0e, 0xa7, 
  0x6e, 0x5b, 0xf1, 0x9e, 0x77, 0x02, 0x27, 0xc6, 0x32, 0x3a, 0xe6, 0x0c, 
  0x3d, 0x18, 0x0e, 0x16, 0x36, 0xbd, 0x09, 0xf4, 0x8c, 0x44, 0x40, 0x55, 
  0xca, 0x92, 0x89, 0x42, 0xbc, 0x36, 0xa6, 0x3d, 0xb4, 0x9d, 0x83, 0x97, 
  0xa8, 0xba, 0xd2, 0xbd, 0x85, 0x2f, 0x73, 0x36, 0xf1, 0x10, 0x93, 0x80, 
  0xdc, 0x81, 0x37, 0xab, 0xff, 0x78, 0x73, 0x80, 0x70, 0x6f, 0x56, 0x3b, 
  0xb6, 0x10, 0xa5, 0xb2, 0x5c, 0xbe, 0x43, 0x04, 0xa9, 0x3b, 0x4f, 0xc4, 
  0x52, 0x92, 0x1c, 0xc5, 0x3a, 0xf1, 0xb9, 0x9b, 0x95, 0x54, 0xf5, 0x09, 
  0xd4, 0xa3, 0x16, 0x0f, 0x48, 0x54, 0xf7, 0x6c, 0x4b, 0x1a, 0x88, 0xa0, 
  0xf8, 0x6e, 0x0e, 0xb7, 0xa4, 0x90, 0xf9, 0x9a, 0x41, 0x48, 0xde, 0xa9, 
  0x1e, 0x6a, 0x3f, 0x0a, 0x19, 0x86, 0xea, 0x6f, 0x58, 0x5e, 0x8c, 0x23, 
  0x5d, 0xeb, 0x93, 0x8b, 0xd6, 0x04, 0xca, 0x46, 0x9b, 0xc6, 0xcd, 0xc4, 
  0x90, 0xb2, 0xa5, 0x39, 0xe3, 0x76, 0xd9, 0x58, 0x32, 0xf6, 0xfb, 0x9a, 
  0x93, 0xda, 0xf2, 0x55, 0xdb, 0xd7, 0xde, 0xe0, 0x69, 0xc3, 0x6b, 0xcd, 
  0x56, 0x87, 0x77, 0x12, 0xbf, 0xe9, 0x78, 0x95, 0x0f, 0xe7, 0xec, 0xf1, 
  0x9b, 0x1a, 0xd6, 0xd6, 0xf3, 0xa9, 0xdd, 0x50, 0x54, 0x5a, 0xaf, 0x90, 
  0x96, 0x7d, 0xc5, 0xec, 0x13, 0xad, 0xb4, 0xe4, 0x2b, 0x53, 0x8e, 0x12, 
  0xbb, 0xae, 0x4c, 0x51, 0x99, 0xa7, 0xb3, 0xf7, 0x34, 0x37, 0x4b, 0x55, 
  0x53, 0x81, 0x10, 0xb4, 0x6a, 0x3d, 0x2d, 0x98, 0x10, 0xf3, 0x29, 0x56, 
  0x6f, 0x57, 0xcb, 0xc7, 0x1b, 0x94, 0xe9, 0x4a, 0xe8, 0x57, 0x00, 0xbb, 
  0xac, 0xb1, 0xd9, 0x25, 0x57, 0x94, 0x30, 0xe4, 0x1b, 0x51, 0xfd, 0x1f, 
  0x6f, 0x4e, 0x02, 0x81, 0x0d, 0xc0, 0x5d, 0x45, 0x35, 0x58, 0x0b, 0x38, 
  0xab, 0xce, 0x2e, 0xe3, 0xf6, 0x21, 0x57, 0x49, 0xab, 0xb9, 0xf8, 0x7e, 
  0x44, 0x7a, 0x15, 0x89, 0xc7, 0xfa, 0x43, 0x07, 0x65, 0xbe, 0xb8, 0xb6, 
  0xfc, 0x7b, 0x64, 0x05, 0x6f, 0x9a, 0xe9, 0x6e, 0xeb, 0xf1, 0xe6, 0x3e, 
  0x60, 0x2a, 0x4b, 0x3e, 0x52, 0x22, 0x16, 0xbe, 0x7f, 0xf9, 0x3f, 0xd2, 
  0x4c, 0x3d, 0x0e, 0xf8, 0x54, 0x98, 0x3c, 0x6e, 0x22, 0x17, 0x47, 0x3e, 
  0x4a, 0xae, 0xd2, 0x86, 0x3d, 0xb6, 0x4d, 0xda, 0x75, 0x0a, 0x3a, 0x33, 
  0x79, 0x9a, 0x58, 0xbf, 0x9e, 0xe3, 0x28, 0xd6, 0x21, 0x80, 0x7d, 0xbe, 
  0xef, 0x2c, 0xc4, 0x1a, 0x8c, 0xc1, 0xc7, 0x28, 0xb8, 0x67, 0xc7, 0xb6, 
  0x1d, 0x81, 0xfc, 0xd2, 0x52, 0x57, 0xb4, 0xde, 0x1c, 0x6b, 0xdf, 0x62, 
  0x81, 0xbc, 0x65, 0x85, 0x60, 0xcd, 0x5e, 0xb8, 0x62, 0x00, 0x6b, 0x16, 
  0x1b, 0xe0, 0x11, 0x4c, 0xe6, 0x1a, 0x0d, 0xef, 0xe2, 0x7c, 0x1a, 0xb6, 
  0x90, 0xba, 0xde, 0x58, 0x26, 0xcb, 0xc2, 0x17, 0x2e, 0x11, 0x8a, 0x97, 
  0x33, 0xd7, 0x33, 0x3a, 0x43, 0xf2, 0xe7, 0x87, 0x91, 0x82, 0xc4, 0xe5, 
  0xbb, 0xc4, 0x5b, 0x8d, 0x8a, 0xe5, 0x7d, 0x84, 0x49, 0x4d, 0xbe, 0x8a, 
  0xc7, 0x62, 0x45, 0x65, 0x22, 0x7c, 0xdf, 0xe8, 0xa4, 0xc2, 0x73, 0x7d, 
  0x15, 0xc4, 0x8a, 0xa0, 0x29, 0xa0, 0xa0, 0x61, 0xb1, 0x8d, 0x7c, 0x08, 
  0x1f, 0x03, 0xef, 0xe2, 0x75, 0xf2, 0xb1, 0x98, 0xc1, 0x6a, 0x15, 0xde, 
  0xd3, 0xd0, 0xb4, 0x26, 0xd6, 0xfe, 0x5b, 0x13, 0xff, 0x89, 0xa1, 0x62, 
  0xe4, 0x1f, 0x7e, 0x7c, 0x3e, 0x0a, 0xf7, 0x12, 0x13, 0x15, 0x32, 0xec, 
  0x1a, 0x27, 0x47, 0x32, 0x18, 0xda, 0x00, 0xf6, 0x6b, 0xff, 0xd1, 0xf0, 
  0x73, 0xec, 0x80, 0x4a, 0x16, 0xce, 0xd2, 0x55, 0x63, 0x11, 0x22, 0xbb, 
  0x35, 0xb3, 0x0e, 0xa2, 0x96, 0x58, 0x02, 0xcd, 0x3e, 0x08, 0x90, 0x29, 
  0x50, 0x57, 0x51, 0x73, 0x6e, 0xe8, 0x22, 0xe6, 0xd3, 0x53, 0xb6, 0xa6, 
  0x58, 0x34, 0x2f, 0x5c, 0xae, 0xee, 0xbc, 0xd1, 0x08, 0x10, 0xfe, 0x25, 
  0x79, 0x67, 0xc9, 0x64, 0x7a, 0x66, 0x70, 0x1b, 0xfa, 0x20, 0x7f, 0x49, 
  0xdc, 0x13, 0x89, 0x83, 0xc5, 0x3f, 0x7b, 0xba, 0xe5, 0x04, 0xa2, 0x35, 
  0x0d, 0x27, 0x88, 0x3e, 0xac, 0x35, 0x79, 0x7a, 0x5d, 0x5b, 0x6a, 0xd3, 
  0x7e, 0xb4, 0x2d, 0xf3, 0x56, 0xba, 0x61, 0x41, 0xae, 0x7a, 0xcf, 0x66, 
  0xb5, 0x89, 0x5d, 0xe8, 0xd1, 0x41, 0xbe, 0x7c, 0xd0, 0xe8, 0xc5, 0x36, 
  0xaf, 0xc2, 0xd7, 0xe3, 0x3d, 0xc2, 0x2a, 0x65, 0x72, 0x4a, 0xa3, 0x6b, 
  0xae, 0xcb, 0xe5, 0xf7, 0x81, 0xbb, 0x8e, 0xd9, 0x33, 0x74, 0xe5, 0xe7, 
  0xa5, 0xf5, 0xd8, 0xbc, 0xe2, 0xe3, 0xca, 0xb2, 0x35, 0x5d, 0x0d, 0x2d, 
  0xa4, 0xe4, 0x8e, 0xbf, 0x2b, 0xb0, 0xd1, 0x3e, 0x06, 0xb7, 0x7b, 0xe1, 
  0x18, 0xf4, 0xc3, 0xfa, 0x08, 0xfc, 0x10, 0x7e, 0xe5, 0x18, 0xa4, 0xbd, 
  0xc6, 0x08, 0xb4, 0x6e, 0xd6, 0x3b, 0x14, 0x9d, 0xd6, 0xe3, 0x7e, 0x20, 
  0x9f, 0xf5, 0x2f, 0xf1, 0x59, 0x36, 0x8d, 0x6a, 0xf5, 0x95, 0x2c, 0x4d, 
  0xb2, 0xd7, 0xac, 0x19, 0x1c, 0xb5, 0xc5, 0xac, 0xf1, 0x75, 0x4e, 0x3a, 
  0x7a, 0xbd, 0x40, 0xfd, 0xb3, 0x06, 0x73, 0x22, 0x59, 0xd7, 0x64, 0x94, 
  0x82, 0x35, 0x29, 0xa7, 0xd3, 0x93, 0xe2, 0x16, 0xb9, 0x2f, 0x10, 0xd7, 
  0xaf, 0x52, 0x6f, 0x8e, 0x38, 0xd2, 0x0f, 0x66, 0x16, 0x0d, 0x61, 0xf5, 
  0x49, 0xeb, 0x18, 0x7c, 0x15, 0x1a, 0x1b, 0x03, 0x56, 0x21, 0xf8, 0x58, 
  0x85, 0xf0, 0x24, 0x4f, 0x3c, 0xe8, 0x67, 0xba, 0xf8, 0x10, 0x96, 0xd0, 
  0x2e, 0x34, 0x07, 0xe3, 0xf8, 0xfd, 0xdc, 0x96, 0x2e, 0xd6, 0x39, 0x7a, 
  0x89, 0x1f, 0xef, 0x89, 0xee, 0xf6, 0x2a, 0xb9, 0xc7, 0xa6, 0x5a, 0x17, 
  0xd7, 0x2d, 0x15, 0x0c, 0xdc, 0x1b, 0x2d, 0x75, 0x3e, 0xd7, 0xc5, 0x75, 
  0x7f, 0x68, 0xf8, 0x76, 0x72, 0xaf, 0x45, 0xe6, 0x5a, 0xcb, 0x8c, 0x6a, 
  0x3e, 0x67, 0x52, 0x16, 0xed, 0x70, 0x4a, 0x1a, 0xea, 0xa7, 0x15, 0x85, 
  0x73, 0x60, 0xe8, 0x00, 0x83, 0x30, 0x68, 0xcc, 0xa3, 0xad, 0x72, 0x43, 
  0x02, 0x6a, 0x18, 0xb7, 0x35, 0x17, 0x44, 0xa6, 0x49, 0x64, 0xab, 0xf4, 
  0xd0, 0x01, 0x6e, 0x8d, 0x8d, 0xb8, 0xad, 0x36, 0x76, 0xe8, 0x70, 0x13, 
  0x05, 0xde, 0x61, 0x66, 0x79, 0x09, 0x4d, 0xb3, 0x52, 0x38, 0x7e, 0x10, 
  0xee, 0xfc, 0x60, 0xf5, 0xdb, 0x90, 0xb2, 0x41, 0xe9, 0x24, 0xc5, 0xd1, 
  0x0c, 0x66, 0x00, 0xa4, 0xa7, 0x73, 0x41, 0xef, 0x95, 0x02, 0x7f, 0xc0, 
  0xef, 0x4a, 0xfc, 0x88, 0xb8, 0x0c, 0xa5, 0xef, 0x31, 0x7d, 0x1f, 0x37, 
  0x04, 0x06, 0x73, 0xaf, 0x78, 0x19, 0x31, 0x18, 0x9e, 0xf8, 0xf3, 0x14, 
  0xab, 0xc5, 0x65, 0xdb, 0x56, 0x90, 0xde, 0x5b, 0x02, 0xf1, 0x50, 0x3f, 
  0x49, 0x2b, 0xf7, 0xa1, 0xc4, 0x48, 0x0d, 0x4d, 0xcb, 0x20, 0xbb, 0x60, 
  0x36, 0x42, 0x52, 0x91, 0x87, 0x91, 0xac, 0x7b, 0x17, 0x6b, 0x38, 0x6a, 
  0x1f, 0xbf, 0xfa, 0xca, 0x0f, 0xf0, 0x62, 0xcb, 0x55, 0xb4, 0x16, 0x23, 
  0x46, 0x70, 0xc1, 0x87, 0x2e, 0x98, 0x30, 0x26, 0xb6, 0x5c, 0x94, 0x24, 
  0x00, 0xd9, 0x9b, 0x1a, 0xa5, 0xd0, 0xc4, 0x0c, 0x6c, 0x43, 0xdc, 0x82, 
  0x94, 0x81, 0xfd, 0x36, 0x48, 0x07, 0xb1, 0x59, 0xba, 0x93, 0x58, 0xcf, 
  0x69, 0xd2, 0x6a, 0x08, 0x16, 0xe4, 0xd9, 0xd2, 0x9c, 0xc3, 0x87, 0xff, 
  0xfa, 0xe8, 0x72, 0x10, 0x5d, 0x98, 0x85, 0x11, 0x9d, 0x00, 0x44, 0xc2, 
  0x76, 0x5b, 0x61, 0x47, 0x80, 0x83, 0xa5, 0x2e, 0xd5, 0x96, 0x58, 0xc8, 
  0xe4, 0x9e, 0xd4, 0xe7, 0x45, 0x5c, 0xf3, 0xe0, 0x57, 0x10, 0x73, 0x5a, 
  0x16, 0x83, 0x33, 0x75, 0x03, 0x58, 0x1a, 0x5e, 0x90, 0x20, 0x32, 0xf5, 
  0xe4, 0x78, 0x78, 0x89, 0x05, 0x6a, 0x94, 0xed, 0x81, 0xab, 0x38, 0xd5, 
  0xaa, 0x81, 0xea, 0xa1, 0xe3, 0x88, 0xc0, 0x8f, 0xb7, 0xe9, 0x0f, 0xae, 
  0x78, 0xa8, 0xe4, 0xd7, 0xf1, 0xbf, 0xad, 0xd9, 0xd9, 0x4e, 0x26, 0x60, 
  0x0b, 0x3f, 0x33, 0x7c, 0xcd, 0x0f, 0x0b, 0xcb, 0x7b, 0x8a, 0xa8, 0xb2, 
  0x64, 0x4c, 0x2a, 0xb1, 0x21, 0x4c, 0x56, 0x79, 0x13, 0xdc, 0x26, 0x8e, 
  0x82, 0x0e, 0x25, 0x9d, 0xac, 0x57, 0x11, 0xa7, 0xd8, 0xee, 0x5c, 0x78, 
  0x18, 0x18, 0xea, 0x3e, 0x78, 0x61, 0x4d, 0x61, 0xbe, 0x30, 0xc9, 0x31, 
  0x1c, 0x92, 0x4d, 0x7b, 0xd7, 0x0a, 0xc7, 0x32, 0x0b, 0x93, 0x94, 0xa4, 
  0x87, 0xf7, 0xd5, 0xaf, 0x94, 0x10, 0x91, 0x6a, 0x0c, 0xbb, 0x78, 0xa3, 
  0x57, 0x85, 0xc7, 0x72, 0x8a, 0xa5, 0x9e, 0x00, 0xaf, 0x49, 0x53, 0xb6, 
  0x90, 0x1b, 0x1b, 0x5e, 0xad, 0x20, 0x5a, 0x3a, 0xb6, 0x82, 0x57, 0x06, 
  0x95, 0xde, 0x8b, 0x24, 0x73, 0xf1, 0x7f, 0x47, 0x19, 0xa6, 0x7a, 0x41, 
  0xd9, 0xf6, 0x52, 0xc4, 0x8f, 0x52, 0x45, 0x90, 0x35, 0x88, 0x97, 0x7b, 
  0xae, 0x90, 0xaf, 0x91, 0x47, 0xb3, 0x1e, 0x2a, 0xc3, 0x28, 0xe0, 0x34, 
  0x06, 0xbb, 0x6d, 0x35, 0xba, 0x68, 0x14, 0x55, 0xa2, 0xa8, 0x50, 0x04, 
  0x6f, 0x6a, 0x9b, 0x63, 0xa4, 0xff, 0xa3, 0x15, 0x16, 0x78, 0xb2, 0xc3, 
  0x6c, 0x19, 0xd9, 0x58, 0x49, 0xf9, 0x11, 0x97, 0xee, 0x17, 0xce, 0x1d, 
  0xa1, 0xc7, 0xfb, 0x20, 0xff, 0x97, 0x93, 0x18, 0xca, 0xaf, 0xf9, 0x8f, 
  0xd7, 0x70, 0x53, 0xe2, 0x52, 0x86, 0xf9, 0x68, 0x80, 0xd1, 0x72, 0x6f, 
  0x71, 0x46, 0xd1, 0x88, 0x13, 0x8a, 0xe7, 0xd9, 0x44, 0x9d, 0x05, 0x1c, 
  0x29, 0x6e, 0x4b, 0xdc, 0x8e, 0x14, 0x2d, 0x39, 0xc9, 0x7c, 0xf8, 0xe8, 
  0x59, 0xd4, 0xec, 0xce, 0x2c, 0x60, 0xb0, 0xd9, 0x9e, 0x33, 0x02, 0xb4, 
  0x94, 0xcd, 0x90, 0xcc, 0x4c, 0x05, 0x19, 0x0a, 0xa7, 0x61, 0x80, 0x3b, 
  0x7c, 0xa5, 0x17, 0x70, 0x19, 0x12, 0x53, 0xc3, 0x33, 0xe2, 0x3e, 0x42, 
  0xa5, 0xb2, 0x86, 0x68, 0x4c, 0x5b, 0x68, 0x21, 0x2d, 0x73, 0xd4, 0x44, 
  0x63, 0xb7, 0x95, 0x7a, 0x19, 0xb9, 0x98, 0x66, 0xa2, 0x96, 0x12, 0x8f, 
  0xef, 0x70, 0x95, 0x94, 0x81, 0x4e, 0xda, 0x56, 0xde, 0x93, 0x17, 0x4c, 
  0xc1, 0x97, 0x43, 0xa0, 0x6d, 0xe5, 0xb5, 0x7f, 0xa8, 0xa6, 0x28, 0x51, 
  0x73, 0x3c, 0xc8, 0xf5, 0xe9, 0x49, 0x52, 0x34, 0xbc, 0x3e, 0x59, 0xbd, 
  0x1b, 0x9a, 0x5e, 0x4f, 0x94, 0xf1, 0x2b, 0x5b, 0x96, 0x47, 0x71, 0xc2, 
  0x38, 0x3d, 0x21, 0xda, 0xec, 0x57, 0x80, 0xf9, 0xec, 0x3e, 0x6b, 0xea, 
  0x2e, 0xb1, 0x2f, 0xe0, 0xe0, 0x02, 0xa7, 0xb2, 0xd9, 0x24, 0xd8, 0x6d, 
  0x9d, 0x29, 0xf7, 0xb6, 0x2d, 0x16, 0x09, 0x63, 0x78, 0x69, 0x4b, 0xa9, 
  0xd7, 0x7a, 0x5b, 0xa4, 0x42, 0x84, 0x6d, 0xf9, 0x2b, 0xd6, 0xb5, 0xf7, 
  0x31, 0x03, 0x08, 0x39, 0xd3, 0x17, 0xea, 0x43, 0xd1, 0x8a, 0xff, 0x81, 
  0xe4, 0x5f, 0x9f, 0x28, 0x1c, 0xa0, 0x92, 0x57, 0xec, 0x3f, 0x7d, 0x57, 
  0x43, 0xa1, 0x88, 0x0c, 0x05, 0xa1, 0xad, 0x68, 0x63, 0xa5, 0x08, 0x68, 
  0x08, 0xe6, 0xde, 0x0e, 0xf7, 0x05, 0x2c, 0x11, 0x29, 0xdb, 0x17, 0xb5, 
  0x05, 0xd5, 0x82, 0xd4, 0x7c, 0xf9, 0x86, 0xd0, 0x20, 0x15, 0x75, 0x38, 
  0x38, 0x71, 0x44, 0x1a, 0xe9, 0x64, 0x35, 0xef, 0x7c, 0xc4, 0x15, 0xdc, 
  0xe1, 0x6a, 0xb7, 0x65, 0xb9, 0xdc, 0x1d, 0xec, 0xb4, 0x33, 0x91, 0xd7, 
  0x52, 0x6d, 0xda, 0xfc, 0x42, 0x29, 0xe9, 0x1e, 0x09, 0x0a, 0xd3, 0x2a, 
  0xc9, 0x15, 0xea, 0x13, 0x53, 0x41, 0x68, 0xc7, 0x9d, 0x92, 0x06, 0xa4, 
  0xbd, 0x83, 0xbc, 0x2d, 0xdc, 0xf1, 0x44, 0x32, 0x53, 0x22, 0xd6, 0xa6, 
  0x17, 0x4e, 0x96, 0x0a, 0x86, 0xb7, 0xcb, 0x7c, 0x6f, 0x56, 0xdc, 0xee, 
  0xae, 0x81, 0x43, 0xab, 0x8d, 0x8e, 0x05, 0xa2, 0xcb, 0xe1, 0x89, 0x0b, 
  0xc4, 0xda, 0x15, 0x79, 0xd1, 0x4a, 0x6f, 0xb9, 0xe0, 0xbf, 0x35, 0xe8, 
  0xdd, 0x97, 0x27, 0x43, 0x13, 0x18, 0xfd, 0x10, 0xf6, 0xf8, 0xd6, 0x2a, 
  0x66, 0xb7, 0x7b, 0x1f, 0x3e, 0x84, 0x61, 0x30, 0x84, 0xbd, 0x5f, 0x37, 
  0x04, 0x7e, 0xb5, 0x31, 0x84, 0x27, 0x3a, 0x84, 0x27, 0xbf, 0x6d, 0x08, 
  0x4f, 0x7e, 0x87, 0x21, 0xf4, 0x9f, 0x2c, 0x05, 0xe6, 0xf1, 0x11, 0x51, 
  0xf5, 0xa1, 0x89, 0xed, 0x28, 0xf1, 0x63, 0x89, 0x07, 0x79, 0x24, 0xc6, 
  0xbe, 0xca, 0xc7, 0xce, 0x06, 0x38, 0x68, 0x29, 0x0f, 0x81, 0xd0, 0x57, 
  0x0f, 0x2b, 0xa9, 0x34, 0x1e, 0xa4, 0x78, 0xd6, 0xb4, 0xfc, 0x27, 0x83, 
  0x9d, 0xad, 0xea, 0x40, 0x9b, 0x47, 0x4d, 0x31, 0x28, 0xf7, 0xd9, 0xa3, 
  0x1a, 0x97, 0x92, 0xc5, 0xc2, 0xc2, 0xb4, 0x0f, 0xc0, 0x33, 0x59, 0x6c, 
  0x10, 0xc8, 0xdd, 0x60, 0x68, 0x18, 0x6f, 0xb3, 0x88, 0x01, 0x4f, 0xe8, 
  0x0a, 0x21, 0x27, 0x52, 0xec, 0x90, 0xce, 0xb2, 0xc1, 0xe4, 0xf2, 0x6b, 
  0x1d, 0x71, 0xa5, 0x77, 0xf0, 0x68, 0x05, 0xcb, 0xb4, 0x25, 0x3c, 0xa2, 
  0xe4, 0x40, 0x9b, 0x52, 0xf2, 0x89, 0x7c, 0x21, 0xd4, 0xeb, 0x20, 0xa4, 
  0x40, 0xc3, 0x85, 0xb7, 0xa5, 0x32, 0xc6, 0xe4, 0x51, 0x8d, 0x58, 0x6a, 
  0xb6, 0xce, 0x02, 0x44, 0x3b, 0xad, 0x1f, 0xd8, 0x9c, 0xac, 0x5b, 0xca, 
  0x56, 0x8c, 0x8e, 0x96, 0x85, 0x6d, 0x46, 0xd5, 0x54, 0x09, 0xa0, 0x12, 
  0x82, 0xee, 0xaa, 0x35, 0xe8, 0x9e, 0x63, 0xd5, 0xdc, 0x32, 0x7f, 0x78, 
  0xcf, 0x4f, 0x39, 0x1e, 0x76, 0x79, 0xfb, 0xb4, 0x05, 0x85, 0xc0, 0x82, 
  0xc7, 0xa4, 0x8e, 0x06, 0xe7, 0x36, 0xcf, 0xc4, 0xb4, 0xe6, 0xfd, 0x77, 
  0xf1, 0xc2, 0x21, 0xfc, 0xf2, 0x85, 0x69, 0xf6, 0xff, 0xe3, 0xf3, 0xf6, 
  0x12, 0x69, 0x0e, 0x65, 0x49, 0xb3, 0xb6, 0xa7, 0xf6, 0xcb, 0xf2, 0xf6, 
  0xd3, 0xbe, 0xf6, 0x50, 0x43, 0x11, 0x17, 0xd4, 0xe5, 0x35, 0xd1, 0x8c, 
  0xb8, 0x05, 0x34, 0xf0, 0x4b, 0xe4, 0x08, 0x95, 0x42, 0x8e, 0xcf, 0x6f, 
  0x9f, 0x3a, 0xf0, 0xe1, 0x44, 0x22, 0xce, 0x02, 0xca, 0xde, 0x68, 0xb8, 
  0x1d, 0x76, 0x06, 0x9f, 0x05, 0x8b, 0xf2, 0xa9, 0x2c, 0xca, 0xa7, 0xcd, 
  0x45, 0xb1, 0x9e, 0x39, 0x00, 0x4b, 0x57, 0xa4, 0xbe, 0x20, 0x1e, 0xf3, 
  0x98, 0x47, 0xe2, 0x7d, 0x22, 0xeb, 0x17, 0xe5, 0xd7, 0xaf, 0xca, 0x63, 
  0x8b, 0x82, 0x18, 0x1d, 0x59, 0x92, 0xea, 0x8a, 0x7c, 0x1a, 0xae, 0x88, 
  0x2e, 0xc9, 0x7a, 0xd7, 0x4c, 0x63, 0x51, 0xfe, 0x28, 0xb6, 0x0d, 0xa0, 
  0x5d, 0xf4, 0x47, 0x71, 0xde, 0x86, 0x02, 0x24, 0xb8, 0x5a, 0x1a, 0x6d, 
  0xe5, 0xa0, 0x31, 0x2a, 0x41, 0xc2, 0x5a, 0x03, 0x4c, 0xbe, 0xa1, 0x66, 
  0xd6, 0x5f, 0x69, 0x15, 0xf5, 0xb0, 0xa4, 0xd7, 0x8b, 0x32, 0x1d, 0x17, 
  0xff, 0x0d, 0xc5, 0x34, 0xdc, 0xd8, 0xa8, 0xaf, 0xd7, 0xc7, 0x27, 0x47, 
  0x2e, 0x24, 0xf1, 0xff, 0x6d, 0x0f, 0x5a, 0xf1, 0x82, 0x0f, 0x9b, 0x88, 
  0xbe, 0xf4, 0xea, 0xd1, 0xe9, 0x77, 0xc7, 0x17, 0x67, 0xa7, 0x6f, 0x8e, 
  0x4e, 0x5d, 0x54, 0x02, 0x82, 0x25, 0xc4, 0x18, 0xf7, 0x93, 0x99, 0xb2, 
  0x5e, 0x6c, 0x6f, 0xff, 0x0c, 0x10, 0x8b, 0x2f, 0xd4, 0xce, 0xd9, 0x94, 
  0xb3, 0x0a, 0x35, 0xe0, 0x79, 0x70, 0x43, 0x4b, 0x2a, 0x81, 0xed, 0xcc, 
  0xad, 0x08, 0xae, 0xac, 0x77, 0xe7, 0x17, 0x67, 0x3f, 0xfc, 0xf8, 0x3b, 
  0xb6, 0x3f, 0xac, 0x40, 0x0b, 0xfe, 0xae, 0xcd, 0xbf, 0x0e, 0x47, 0xff, 
  0xf5, 0xd9, 0xf9, 0x37, 0x47, 0x17, 0xbf, 0x6b, 0xfb, 0xd2, 0xa4, 0xbb, 
  0x08, 0xf7, 0x4f, 0x4e, 0x7e, 0xb7, 0xe6, 0xa1, 0x9a, 0x3a, 0x7b, 0x64, 
  0xdf, 0xd9, 0x23, 0x5d, 0x79, 0x84, 0x8a, 0xd2, 0x7a, 0x7a, 0xa6, 0x1d, 
  0x8b, 0x91, 0xae, 0x6f, 0x90, 0x97, 0x13, 0x58, 0x8d, 0xa4, 0x64, 0x2d, 
  0xc9, 0x7b, 0x5f, 0x34, 0xce, 0x34, 0x50, 0x98, 0xa6, 0x01, 0x42, 0xb9, 
  0x99, 0x91, 0x81, 0x52, 0x89, 0x5c, 0x83, 0xcc, 0xd9, 0x2a, 0x05, 0x3d, 
  0xc4, 0x4c, 0xe0, 0x4d, 0x05, 0x1b, 0xb9, 0xba, 0x1c, 0x75, 0x92, 0xa7, 
  0xc5, 0x0d, 0x11, 0xe8, 0x0f, 0xc7, 0x97, 0xd1, 0xc1, 0xd9, 0xa1, 0x27, 
  0xf0, 0x4b, 0xf8, 0x3e, 0x60, 0xc6, 0xe6, 0x73, 0x3a, 0x5a, 0x2d, 0x38, 
  0xb7, 0x6c, 0xea, 0x6a, 0x9b, 0x19, 0xcc, 0x1f, 0x47, 0xf5, 0x14, 0x0e, 
  0x33, 0x2e, 0xe5, 0xc8, 0x5f, 0xc6, 0xf6, 0xe5, 0x58, 0x9d, 0x49, 0x60, 
  0x3c, 0x72, 0xf8, 0x78, 0x82, 0x85, 0x63, 0x97, 0x28, 0xc7, 0x4a, 0x72, 
  0x8e, 0x3f, 0x1d, 0x7e, 0x31, 0x36, 0xd1, 0x59, 0x9b, 0xf0, 0xe1, 0x91, 
  0x54, 0x11, 0xba, 0x38, 0xf7, 0x4b, 0x87, 0xa7, 0x14, 0x58, 0x0c, 0x05, 
  0xef, 0x33, 0x07, 0xc2, 0x9c, 0x22, 0x14, 0x5b, 0xd9, 0xf5, 0x1a, 0x40, 
  0xc3, 0xae, 0x8a, 0x12, 0x0b, 0x9f, 0x5a, 0xec, 0xc1, 0x1d, 0x60, 0x31, 
  0xe2, 0x88, 0xe8, 0x89, 0x25, 0x13, 0x18, 0x0c, 0x88, 0x81, 0x63, 0xca, 
  0xdd, 0x9a, 0x16, 0x6b, 0x8c, 0xcf, 0x7e, 0x5b, 0xf7, 0xf4, 0x58, 0x08, 
  0x4a, 0x19, 0x8b, 0xf0, 0x82, 0x72, 0x9d, 0xfe, 0x12, 0x68, 0x66, 0x4f, 
  0xbc, 0x5c, 0x43, 0x52, 0x8b, 0x55, 0x6e, 0x86, 0xcd, 0x54, 0x60, 0x37, 
  0xef, 0x62, 0x01, 0x9d, 0x51, 0x7c, 0x64, 0xff, 0xe6, 0x53, 0xff, 0xa6, 
  0xa6, 0xd6, 0xb9, 0x06, 0x5c, 0xe4, 0x10, 0x7f, 0xde, 0x0f, 0xd3, 0x31, 
  0xf9, 0xe9, 0x6a, 0xc3, 0x0d, 0x13, 0x57, 0xad, 0x9b, 0x67, 0x8a, 0x49, 
  0x64, 0x14, 0x65, 0xd7, 0x87, 0xaf, 0x8d, 0x54, 0xab, 0x97, 0xa4, 0xe4, 
  0x48, 0x2d, 0xb9, 0x52, 0x89, 0x4d, 0x18, 0x64, 0x6d, 0x25, 0x90, 0xa7, 
  0x3e, 0x5d, 0xd3, 0x8f, 0xd4, 0xf5, 0xb9, 0x74, 0xda, 0x72, 0x18, 0x7e, 
  0x63, 0x6b, 0xd3, 0x6c, 0xed, 0xaf, 0xf5, 0xb5, 0x0f, 0x82, 0x78, 0xaa, 
  0xc5, 0x54, 0x3e, 0x73, 0xcc, 0x8b, 0xdd, 0x5f, 0x9c, 0x53, 0xe1, 0xbc, 
  0xe4, 0x00, 0x89, 0xb5, 0x29, 0xda, 0x87, 0xf0, 0xd6, 0x02, 0xa4, 0x19, 
  0xc4, 0x31, 0xd6, 0xf1, 0x36, 0xac, 0x0f, 0x79, 0x98, 0x2d, 0xf3, 0xdc, 
  0x77, 0x12, 0x23, 0x9e, 0x98, 0xee, 0xae, 0x45, 0x6a, 0xbb, 0xa4, 0x4d, 
  0xcb, 0x47, 0x52, 0xe6, 0xd9, 0xbf, 0xba, 0xbb, 0xe3, 0xc7, 0xc7, 0xdb, 
  0xb9, 0xed, 0x73, 0x27, 0x39, 0x17, 0x59, 0x76, 0x2b, 0x8a, 0x8e, 0x00, 
  0x30, 0x29, 0x48, 0x05, 0x80, 0x55, 0x1e, 0x65, 0xec, 0x86, 0x80, 0x43, 
  0xaf, 0x65, 0x9b, 0x79, 0x14, 0xcb, 0x52, 0x52, 0xab, 0x3c, 0x32, 0x6e, 
  0xd0, 0xeb, 0x6e, 0x7d, 0x55, 0xce, 0xf7, 0x87, 0x43, 0x5b, 0x91, 0x83, 
  0x70, 0xe6, 0x32, 0x57, 0x75, 0x5e, 0x32, 0xaa, 0xae, 0xe5, 0x20, 0x37, 
  0xaf, 0x4f, 0x6d, 0xa3, 0xe6, 0xbe, 0xde, 0xdd, 0x73, 0x7d, 0x49, 0x57, 
  0x6f, 0x87, 0x47, 0x17, 0xbf, 0xae, 0xab, 0x96, 0xbe, 0xb4, 0x91, 0x7a, 
  0x5f, 0x4f, 0x5a, 0xe6, 0xf5, 0x9d, 0xb4, 0xd6, 0xfb, 0x4f, 0xe6, 0xf5, 
  0x5d, 0x4b, 0x5f, 0x4f, 0x6b, 0xf3, 0xda, 0xdb, 0xfb, 0xab, 0xab, 0xcd, 
  0x2e, 0x7d, 0xf9, 0xce, 0xb4, 0x37, 0x51, 0xd5, 0xe8, 0xc1, 0xbe, 0xa4, 
  0x3a, 0xad, 0xc5, 0x6a, 0x2f, 0x2a, 0xa8, 0xbe, 0xbb, 0xcf, 0xfc, 0xb4, 
  0xc6, 0x31, 0xda, 0x63, 0xbd, 0x46, 0xce, 0x4e, 0xe3, 0x48, 0x49, 0x19, 
  0xf5, 0x02, 0x25, 0x2f, 0xb8, 0xaa, 0x5e, 0x56, 0xb6, 0xbb, 0x7a, 0x6d, 
  0x18, 0x41, 0x3f, 0x9f, 0xba, 0x7e, 0xa4, 0x9b, 0x3c, 0xd1, 0x83, 0x15, 
  0x74, 0x53, 0x8b, 0x97, 0x93, 0x93, 0xea, 0xba, 0xf9, 0xb0, 0x7e, 0xfe, 
  0x1a, 0xcc, 0xc7, 0x2d, 0x91, 0x40, 0xff, 0xa5, 0x0b, 0x52, 0x73, 0x07, 
  0x01, 0xa7, 0x50, 0x80, 0x47, 0x1f, 0x08, 0xa5, 0xd5, 0xbd, 0x1a, 0x28, 
  0x27, 0xfa, 0xaa, 0xef, 0xe5, 0x33, 0x05, 0xfd, 0x11, 0xd4, 0x72, 0x49, 
  0xbb, 0x47, 0x3d, 0xc1, 0xb8, 0x92, 0xc3, 0x2e, 0xa5, 0x1e, 0x62, 0x9f, 
  0xb7, 0x91, 0x87, 0xac, 0x66, 0xf7, 0xb9, 0x5f, 0x13, 0x1b, 0x92, 0x59, 
  0xd1, 0xb7, 0xf5, 0xb4, 0x7b, 0x63, 0x9f, 0x80, 0xff, 0xf2, 0xdf, 0x17, 
  0x47, 0x97, 0x17, 0x08, 0x20, 0x44, 0x22, 0x7e, 0xdd, 0x7a, 0x3e, 0x8b, 
  0xf3, 0x2d, 0xe7, 0x71, 0x12, 0xa0, 0xcb, 0xe0, 0x66, 0xf1, 0x3c, 0x41, 
  0xc2, 0xc4, 0x05, 0xfe, 0x4c, 0xa2, 0x4d, 0x6c, 0x15, 0x78, 0xc0, 0x92, 
  0xd1, 0xc5, 0xc7, 0x3c, 0x5e, 0x7b, 0xd4, 0xf7, 0xfc, 0x51, 0x17, 0xbd, 
  0x5f, 0x1b, 0xdb, 0xd7, 0x3f, 0x6d, 0x10, 0x0e, 0xba, 0x57, 0x2e, 0x6e, 
  0x1f, 0x24, 0x55, 0xb5, 0x27, 0xec, 0xed, 0xf9, 0x48, 0x15, 0x40, 0x44, 
  0x09, 0x83, 0xd6, 0x70, 0x61, 0x19, 0xa3, 0x8f, 0xbc, 0x88, 0x24, 0x19, 
  0x24, 0x36, 0x07, 0xbc, 0x46, 0x22, 0x37, 0x8c, 0xa9, 0xae, 0x73, 0x57, 
  0x99, 0xdc, 0xe4, 0x07, 0x5f, 0xb5, 0x0f, 0x5d, 0x7a, 0x11, 0x44, 0xab, 
  0x85, 0x3e, 0xdd, 0xd9, 0x69, 0x36, 0x17, 0x8f, 0xb2, 0x5b, 0xf3, 0xfd, 
  0x6a, 0x50, 0xbc, 0x80, 0xed, 0x62, 0xf3, 0x21, 0x7d, 0x40, 0xd7, 0xea, 
  0x4f, 0xb9, 0x6a, 0x51, 0x9c, 0xce, 0x4c, 0x73, 0x08, 0x96, 0x4d, 0x38, 
  0xc9, 0xf7, 0xe1, 0xfa, 0x57, 0xf9, 0x87, 0x6c, 0x0d, 0xae, 0x8a, 0xa0, 
  0xcc, 0xa5, 0xa4, 0xf8, 0x3c, 0xd0, 0xec, 0xe7, 0x2d, 0xf3, 0x54, 0x4c, 
  0x86, 0xa0, 0x9b, 0xa7, 0xaa, 0x40, 0xcd, 0xd4, 0xa7, 0xce, 0x77, 0x00, 
  0xc0, 0x21, 0x72, 0xb1, 0x8d, 0xd3, 0xce, 0xce, 0x1e, 0xbc, 0xf5, 0x37, 
  0x78, 0xf3, 0x59, 0xdb, 0x19, 0x1a, 0x5e, 0x9e, 0x5d, 0x44, 0x4a, 0xea, 
  0xcd, 0xbb, 0x87, 0x97, 0x11, 0x4f, 0x38, 0xc7, 0x79, 0xaf, 0xc5, 0x39, 
  0x67, 0xd2, 0xb9, 0x86, 0xe0, 0x54, 0xca, 0x4d, 0xef, 0x09, 0x87, 0x80, 
  0x9b, 0x56, 0x57, 0xe5, 0xbb, 0x38, 0x07, 0x62, 0x1d, 0x27, 0x87, 0xf0, 
  0x8e, 0x90, 0x94, 0x40, 0xea, 0xd5, 0x3c, 0x50, 0xd6, 0xf6, 0xe4, 0xb8, 
  0x9f, 0xad, 0x4a, 0xa9, 0xd3, 0xc5, 0x39, 0x64, 0x4c, 0x80, 0x9a, 0x4d, 
  0xc6, 0x46, 0x14, 0x35, 0xfd, 0x3a, 0x73, 0x7b, 0xfd, 0x44, 0xc8, 0x51, 
  0x3e, 0xf3, 0x10, 0x47, 0xe2, 0x5b, 0x1b, 0xd4, 0xdc, 0xcf, 0xf8, 0x1c, 
  0xd9, 0x41, 0xea, 0xa8, 0x54, 0xe2, 0x53, 0x04, 0xce, 0xe6, 0x2d, 0x49, 
  0x17, 0x2d, 0x12, 0x0f, 0x32, 0x0d, 0x3e, 0x72, 0x62, 0xa8, 0xef, 0xba, 
  0xe5, 0xfc, 0x33, 0xa7, 0x02, 0x16, 0x46, 0x65, 0x91, 0x1d, 0x11, 0x73, 
  0x7e, 0xe4, 0xe2, 0x66, 0x41, 0x4c, 0x42, 0xaf, 0x39, 0x2f, 0x0e, 0x06, 
  0xb7, 0xbd, 0x14, 0x96, 0xd2, 0x99, 0x8a, 0x14, 0x82, 0x8f, 0x6a, 0x5c, 
  0x81, 0x4d, 0x50, 0x35, 0xb3, 0x53, 0x5d, 0x36, 0x35, 0xd1, 0xb5, 0xb4, 
  0x26, 0xac, 0x0d, 0x4e, 0x0b, 0x62, 0x3f, 0xa5, 0x38, 0xaa, 0x1d, 0x86, 
  0x2e, 0xa2, 0x49, 0xc5, 0x68, 0x8c, 0xbb, 0xad, 0xbd, 0xa8, 0x9a, 0xcf, 
  0xd2, 0x7b, 0xb2, 0xdb, 0x42, 0x6a, 0xac, 0x07, 0x5d, 0x1c, 0x0d, 0x2f, 
  0x65, 0x09, 0xf8, 0xb7, 0xc6, 0xc8, 0x25, 0x57, 0xcd, 0xea, 0xff, 0x14, 
  0xeb, 0x48, 0x8d, 0xc3, 0x0e, 0x99, 0xf4, 0xb9, 0x7d, 0x6f, 0x40, 0xf3, 
  0xbd, 0xef, 0x35, 0x37, 0x00, 0x96, 0x58, 0x06, 0x91, 0x47, 0xe7, 0xfc, 
  0x5b, 0x4b, 0xe7, 0x21, 0xce, 0x52, 0x13, 0xec, 0x7c, 0xc1, 0xf5, 0x3d, 
  0x93, 0x85, 0xd5, 0x91, 0x46, 0xd6, 0x51, 0x9e, 0x5e, 0x21, 0xb4, 0x16, 
  0x4b, 0x4d, 0x44, 0xc5, 0xf5, 0x48, 0xa2, 0xe7, 0xcf, 0x9e, 0x07, 0x83, 
  0x79, 0x12, 0x04, 0xea, 0xe1, 0x5a, 0x0a, 0x78, 0xb3, 0x7c, 0xd0, 0xd1, 
  0x4e, 0x3b, 0xa4, 0x39, 0x09, 0xa3, 0xc8, 0xf2, 0x9b, 0xa0, 0x85, 0xa7, 
  0x01, 0x03, 0xe5, 0xbb, 0x53, 0x1b, 0x38, 0x36, 0xcf, 0x1a, 0x7f, 0xe8, 
  0xe2, 0x3a, 0xae, 0xb8, 0x22, 0x9a, 0x90, 0x7c, 0x0d, 0x03, 0xf3, 0xc9, 
  0x33, 0x97, 0x34, 0x6b, 0x37, 0x72, 0x30, 0x14, 0xfe, 0x98, 0xc1, 0x1b, 
  0x8a, 0x6b, 0xa9, 0xd4, 0x53, 0x3f, 0x50, 0x4f, 0xfc, 0x4d, 0x8f, 0xcb, 
  0xc3, 0x3b, 0x86, 0x75, 0x3b, 0xaa, 0x17, 0x3e, 0x69, 0x5d, 0xab, 0x04, 
  0x6b, 0x16, 0xe7, 0x33, 0x86, 0x6d, 0x51, 0xbf, 0x6e, 0xc3, 0x89, 0x55, 
  0x8f, 0x1b, 0x7c, 0xa2, 0x37, 0xfd, 0xf1, 0xc9, 0x91, 0xdf, 0x3d, 0x01, 
  0x7c, 0x01, 0x8f, 0xf2, 0x12, 0x3c, 0xb1, 0xa4, 0x85, 0xbb, 0x8e, 0x07, 
  0xd1, 0x39, 0x23, 0xe9, 0xc1, 0x3d, 0x57, 0xfc, 0xcd, 0xb7, 0x26, 0x6c, 
  0xe0, 0xe4, 0x70, 0x1f, 0x02, 0x0a, 0xa2, 0x7d, 0xd2, 0x05, 0x97, 0x8a, 
  0xe6, 0x4f, 0x46, 0xa8, 0xee, 0xee, 0x58, 0x44, 0x63, 0xca, 0xcf, 0xfd, 
  0xcb, 0x5a, 0x72, 0xa9, 0xfe, 0xc8, 0x53, 0x39, 0x9e, 0x27, 0x5a, 0x9e, 
  0x9c, 0xdb, 0xc7, 0x8d, 0x25, 0x6b, 0x8a, 0x37, 0xc3, 0xd2, 0xe5, 0xfe, 
  0x7b, 0xdf, 0x82, 0x1e, 0x15, 0x52, 0x9e, 0x31, 0x88, 0xa0, 0x89, 0x7d, 
  0xab, 0x07, 0x38, 0x91, 0x96, 0xa6, 0xf6, 0xcc, 0xba, 0xa6, 0x84, 0xee, 
  0xf7, 0x47, 0x7a, 0xc5, 0x33, 0xe4, 0xdb, 0x6c, 0xc6, 0x80, 0xd0, 0xd4, 
  0xd6, 0x82, 0xaf, 0xb1, 0x99, 0x05, 0xc5, 0x54, 0x32, 0x8c, 0xb0, 0x35, 
  0x42, 0xcf, 0xeb, 0x8a, 0xf7, 0x04, 0x9d, 0x3c, 0x51, 0x8c, 0x33, 0x25, 
  0x3e, 0x27, 0x1c, 0x54, 0x46, 0xc7, 0x1d, 0x5b, 0x46, 0x4a, 0x0c, 0x7a, 
  0x71, 0xd5, 0xb5, 0x82, 0xa6, 0x9e, 0xfe, 0x8a, 0xa6, 0x00, 0x11, 0xc2, 
  0x0d, 0x11, 0x03, 0xae, 0x34, 0xf2, 0xcc, 0x37, 0x32, 0x05, 0x0a, 0x96, 
  0x36, 0x43, 0xed, 0x84, 0x7c, 0xde, 0x01, 0x33, 0xb9, 0xaa, 0x73, 0xaa, 
  0x90, 0x4a, 0x04, 0x58, 0x0b, 0xab, 0x09, 0xfa, 0x10, 0xda, 0xff, 0x2a, 
  0x0e, 0xb0, 0x5a, 0x12, 0xa0, 0x7a, 0x4f, 0xb0, 0xb2, 0x22, 0x63, 0xf0, 
  0x60, 0x8b, 0xf4, 0x8a, 0x66, 0x92, 0x4c, 0x0c, 0x01, 0x45, 0xea, 0x50, 
  0xea, 0x3b, 0x1b, 0xcd, 0x1c, 0x10, 0x6b, 0xc5, 0x77, 0x25, 0xe4, 0x7f, 
  0x99, 0x65, 0x52, 0x3e, 0xc4, 0x45, 0x64, 0x0e, 0x04, 0x70, 0xb7, 0xe9, 
  0xa4, 0x2c, 0x7a, 0x6a, 0x95, 0x48, 0x4b, 0x2d, 0x08, 0x77, 0xdf, 0x10, 
  0x1e, 0xd9, 0xe7, 0x5a, 0x47, 0x2f, 0x7e, 0xfa, 0x99, 0x5a, 0x3d, 0xe4, 
  0xde, 0xb9, 0x3c, 0x3a, 0x39, 0x3d, 0xba, 0x74, 0x00, 0x15, 0x4d, 0xf1, 
  0xe1, 0xe9, 0xf3, 0x9a, 0xe0, 0xa1, 0x38, 0x98, 0xf5, 0x60, 0x95, 0x67, 
  0xbb, 0x2e, 0xac, 0xde, 0x2a, 0x53, 0x26, 0x49, 0xde, 0x2d, 0x84, 0xf1, 
  0x24, 0x24, 0x5a, 0x4f, 0x35, 0xbf, 0x57, 0x30, 0xb3, 0xb3, 0x1b, 0xff, 
  0xea, 0x5e, 0x00, 0xa6, 0x20, 0x62, 0x48, 0xaa, 0xe7, 0x9f, 0xf5, 0x2d, 
  0x5a, 0x0f, 0x14, 0xc7, 0xee, 0x69, 0x3d, 0x00, 0xc9, 0x1b, 0x84, 0xbf, 
  0x21, 0x2c, 0xa2, 0xb4, 0x78, 0x1c, 0x0a, 0xf8, 0xd9, 0x13, 0xcf, 0x06, 
  0xf3, 0x87, 0x25, 0xa3, 0x30, 0x49, 0xcd, 0x24, 0x77, 0xa2, 0xfc, 0xa3, 
  0x42, 0xa0, 0x07, 0xc2, 0x38, 0xf8, 0x0e, 0x6f, 0xbe, 0xc5, 0x61, 0x7e, 
  0xb5, 0x1a, 0x7b, 0xcf, 0x9e, 0x85, 0xb6, 0x06, 0xf6, 0xb9, 0xf1, 0x7e, 
  0xd1, 0x5a, 0x31, 0x5f, 0x87, 0xfc, 0xe7, 0x1f, 0xfd, 0xd4, 0x3d, 0xca, 
  0x75, 0x43, 0xd2, 0x85, 0x62, 0xac, 0xac, 0x7f, 0x41, 0xe8, 0x63, 0x78, 
  0x1d, 0x0b, 0xca, 0x64, 0x2a, 0xc8, 0x0a, 0x9b, 0x69, 0xe5, 0x10, 0x79, 
  0x43, 0xfc, 0x33, 0x55, 0x69, 0x44, 0xc4, 0xf2, 0x58, 0x16, 0x22, 0x7b, 
  0x06, 0xdb, 0xe1, 0xdf, 0x78, 0x5e, 0xb5, 0xbb, 0xac, 0x2a, 0x81, 0xb3, 
  0x58, 0x80, 0x74, 0x79, 0x1d, 0x54, 0x45, 0xfc, 0x74, 0xa7, 0xbd, 0x8b, 
  0x83, 0x7d, 0xb4, 0x1f, 0x6d, 0x72, 0x75, 0xac, 0xbf, 0xb1, 0x78, 0xa5, 
  0xfc, 0xf9, 0x6f, 0x7e, 0x78, 0x9f, 0xee, 0x2a, 0x11, 0xb2, 0xde, 0x78, 
  0xb5, 0x48, 0x7f, 0x61, 0xba, 0x32, 0x89, 0x23, 0x59, 0x90, 0x0c, 0xce, 
  0x06, 0x42, 0xf7, 0xf4, 0x9e, 0x9e, 0xf5, 0xdb, 0x78, 0x96, 0x2a, 0x53, 
  0x7c, 0x7b, 0x71, 0xe2, 0xbf, 0x7f, 0xa2, 0x24, 0x2a, 0x51, 0x06, 0x52, 
  0x2b, 0x8f, 0xda, 0x64, 0x94, 0xe3, 0x24, 0x61, 0x17, 0x97, 0x3d, 0xf9, 
  0xc3, 0x0f, 0x81, 0x05, 0xd3, 0xe3, 0x88, 0xc6, 0x79, 0x00, 0x64, 0xa0, 
  0xa6, 0x42, 0xc1, 0xf3, 0xa4, 0x93, 0xb7, 0x42, 0x79, 0x9e, 0x3c, 0x99, 
  0x25, 0x0c, 0x67, 0x03, 0x0e, 0x5f, 0xa7, 0x34, 0x8b, 0xe8, 0xe5, 0x58, 
  0x17, 0xc1, 0x59, 0x4e, 0x14, 0xf0, 0x68, 0xc1, 0x01, 0x01, 0xaa, 0x98, 
  0x12, 0x2d, 0xee, 0xbf, 0xbd, 0xfc, 0xe6, 0xec, 0x62, 0x18, 0x6d, 0x73, 
  0x26, 0xe2, 0xe5, 0xc5, 0xf1, 0x57, 0x6f, 0x49, 0xc8, 0x76, 0x86, 0xd5, 
  0xc3, 0x98, 0x84, 0xef, 0x59, 0x34, 0x24, 0x69, 0x63, 0x94, 0xe4, 0x57, 
  0x86, 0xfe, 0x89, 0x04, 0x7d, 0x4e, 0x91, 0xcf, 0x72, 0x01, 0x66, 0xf3, 
  0x75, 0x7d, 0xcc, 0x2e, 0x2c, 0x21, 0x6d, 0x29, 0x7d, 0x99, 0x79, 0xa1, 
  0x2f, 0xad, 0x25, 0x52, 0xba, 0x0a, 0x4a, 0x97, 0xdf, 0xec, 0x9f, 0x7e, 
  0x3b, 0x34, 0x0f, 0xc4, 0xf7, 0xdf, 0x7f, 0x1f, 0x7a, 0x1e, 0x5e, 0x6c, 
  0x6f, 0x03, 0x63, 0xe7, 0x3a, 0xbe, 0xbf, 0x1f, 0x70, 0x31, 0xfa, 0xa0, 
  0x10, 0x9b, 0x47, 0x32, 0x2c, 0x56, 0x44, 0xa6, 0xf4, 0xf5, 0xf6, 0x72, 
  0x35, 0x62, 0xe4, 0xc4, 0xed, 0x55, 0xa9, 0x98, 0xc6, 0x78, 0x7b, 0x7b, 
  0x63, 0x63, 0x78, 0x74, 0x14, 0xed, 0x9f, 0x0c, 0xcf, 0x82, 0x77, 0x37, 
  0x77, 0xb7, 0xe8, 0x0c, 0x5f, 0x25, 0xe5, 0x26, 0x83, 0x5d, 0x9f, 0xec, 
  0x5f, 0xb2, 0x2c, 0xf8, 0xdd, 0xd1, 0xc5, 0xf0, 0xf8, 0xec, 0x94, 0xb7, 
  0x88, 0xd3, 0x9a, 0xe3, 0x19, 0x97, 0xf1, 0xe2, 0xcc, 0x25, 0xce, 0x0b, 
  0xbb, 0x33, 0x34, 0x61, 0x4e, 0xd2, 0x27, 0x5e, 0x22, 0xac, 0x5c, 0x3c, 
  0x44, 0x77, 0x9c, 0x70, 0x1e, 0x5b, 0x79, 0xad, 0x92, 0x85, 0x20, 0x73, 
  0x96, 0x6d, 0x44, 0x5e, 0x2d, 0x15, 0xc0, 0xd5, 0x64, 0x24, 0x81, 0x40, 
  0x3d, 0xc1, 0xcc, 0x45, 0xec, 0x76, 0x90, 0xf5, 0xdb, 0x3a, 0xf1, 0xe1, 
  0xf1, 0x9b, 0x73, 0x92, 0x46, 0xde, 0x0e, 0xf7, 0xbf, 0x3e, 0xe2, 0x47, 
  0xbf, 0x4e, 0x4a, 0xbf, 0x1f, 0x82, 0x7a, 0xcc, 0x9d, 0xd0, 0x42, 0x14, 
  0xe3, 0x78, 0xc9, 0x91, 0xd8, 0xd4, 0x4d, 0x5f, 0x38, 0x58, 0xd0, 0xb6, 
  0x70, 0x69, 0x8f, 0x31, 0x69, 0xcf, 0x03, 0x00, 0x32, 0x6c, 0xf7, 0xe2, 
  0x68, 0xff, 0xf0, 0xcd, 0x91, 0xf9, 0x9e, 0xc5, 0x68, 0x4b, 0x8d, 0x5e, 
  0x67, 0x28, 0xc7, 0x63, 0xb8, 0xb0, 0x9c, 0x4d, 0xcf, 0x8b, 0x4f, 0xdf, 
  0x70, 0x99, 0xcd, 0xf6, 0xee, 0xfc, 0x46, 0xe1, 0xd9, 0xc1, 0x34, 0xdd, 
  0x96, 0xd6, 0xad, 0xbf, 0xd8, 0x2d, 0x89, 0x96, 0x66, 0x33, 0xce, 0x2b, 
  0xd2, 0x3e, 0xb4, 0x84, 0xcf, 0x76, 0x76, 0x76, 0x1e, 0x99, 0x07, 0x6c, 
  0x59, 0xaa, 0xf4, 0xd3, 0x54, 0x5e, 0xf0, 0xe3, 0xdb, 0xbe, 0x7d, 0x23, 
  0xcd, 0x38, 0x18, 0x3b, 0xff, 0x29, 0xd5, 0x6e, 0x18, 0x5c, 0xb3, 0x7d, 
  0xd0, 0xe3, 0x2c, 0x73, 0x7b, 0x10, 0x34, 0x77, 0x95, 0x31, 0xf3, 0xf1, 
  0xd1, 0x4f, 0x12, 0xba, 0xa3, 0x0b, 0xa1, 0x5f, 0xb6, 0xaf, 0x85, 0x7c, 
  0x49, 0x2d, 0xcb, 0x2f, 0x6e, 0x45, 0xc2, 0xa5, 0x47, 0x1d, 0x41, 0x28, 
  0x74, 0xce, 0xda, 0xaf, 0xcb, 0x32, 0x49, 0x21, 0x92, 0x90, 0x24, 0x57, 
  0x6f, 0x97, 0xbf, 0xa1, 0x56, 0xf9, 0xc7, 0x20, 0xcb, 0xaf, 0xb6, 0xe7, 
  0x2f, 0x10, 0x61, 0x44, 0x0f, 0xbd, 0xe6, 0xec, 0x70, 0x14, 0x2d, 0xb3, 
  0xe1, 0x16, 0xbc, 0x6d, 0x1c, 0x19, 0xfa, 0x01, 0x73, 0xfe, 0x80, 0x35, 
  0x3e, 0x3c, 0xfb, 0xfe, 0xf4, 0xe4, 0x6c, 0xff, 0x30, 0xba, 0x3c, 0x23, 
  0x71, 0x87, 0x65, 0xe6, 0x96, 0x7d, 0x05, 0x6a, 0x45, 0x99, 0x09, 0x17, 
  0x8b, 0x03, 0x58, 0xe4, 0xfa, 0x18, 0xfa, 0x52, 0x70, 0x0c, 0x89, 0xdb, 
  0xd7, 0xe5, 0xfc, 0xfd, 0xc4, 0xfa, 0x21, 0x9d, 0xf4, 0x24, 0x32, 0xce, 
  0xdf, 0x39, 0x41, 0xc1, 0xaa, 0xc4, 0xaa, 0xe8, 0x56, 0xeb, 0x61, 0xb9, 
  0xbd, 0xdd, 0x14, 0xb7, 0x99, 0x47, 0x07, 0x16, 0x40, 0xe8, 0xa2, 0x5a, 
  0x08, 0x50, 0xdd, 0x18, 0x3d, 0x73, 0xc2, 0x48, 0x21, 0x23, 0xba, 0x51, 
  0xb7, 0x1a, 0x13, 0x3c, 0x5b, 0x3b, 0x25, 0x62, 0x33, 0xc9, 0x3d, 0x66, 
  0x5d, 0xdd, 0x38, 0xc1, 0x5f, 0xf1, 0xb3, 0xf3, 0x65, 0x42, 0xc5, 0x95, 
  0xa5, 0x43, 0x86, 0xaf, 0xad, 0xa5, 0x3b, 0xee, 0xc7, 0xf6, 0xd3, 0x77, 
  0xc1, 0xdf, 0x84, 0x2c, 0x66, 0xdb, 0xa9, 0x41, 0x32, 0x80, 0xb7, 0xc3, 
  0xe3, 0xd3, 0xaf, 0x61, 0x1c, 0xff, 0xfe, 0xec, 0xe2, 0x70, 0x48, 0xcd, 
  0x32, 0xef, 0xdd, 0x80, 0x5c, 0x08, 0x54, 0x24, 0x19, 0x95, 0x1c, 0x51, 
  0xee, 0xfa, 0x2f, 0x10, 0x31, 0x11, 0x83, 0x2b, 0x89, 0xa4, 0x18, 0xa6, 
  0x5f, 0x1b, 0x20, 0x46, 0xb4, 0x93, 0x1c, 0xbf, 0x2e, 0x71, 0x22, 0x93, 
  0x2f, 0xb5, 0x96, 0xb0, 0x16, 0x2d, 0x86, 0x87, 0x73, 0x9b, 0xb3, 0xd4, 
  0xb7, 0xf9, 0x06, 0xdf, 0x2e, 0xb3, 0x6d, 0x80, 0xda, 0x70, 0x2b, 0x59, 
  0xee, 0x30, 0x41, 0x2a, 0x2b, 0x12, 0xf5, 0x57, 0xd1, 0x74, 0x16, 0x5f, 
  0x09, 0x16, 0x6f, 0x6d, 0x39, 0x56, 0x51, 0xd0, 0x99, 0x76, 0xff, 0xa1, 
  0x5d, 0x32, 0xb2, 0x13, 0xda, 0x3b, 0x2e, 0x5d, 0x36, 0x25, 0x60, 0x30, 
  0xd4, 0xf4, 0x24, 0x17, 0xe2, 0x83, 0x16, 0x3d, 0x05, 0xa0, 0x71, 0x1d, 
  0x6b, 0x50, 0x4b, 0xf1, 0x6e, 0x88, 0xf0, 0xd7, 0x0f, 0x72, 0x42, 0x24, 
  0xd0, 0x8f, 0x5b, 0x0a, 0x04, 0x22, 0x09, 0xea, 0xa6, 0x3e, 0x59, 0xf1, 
  0x96, 0xc5, 0x37, 0x9b, 0x22, 0xaf, 0xa8, 0x45, 0xba, 0x9a, 0x29, 0xa5, 
  0x89, 0xe6, 0x18, 0x2c, 0xbf, 0x44, 0xcd, 0x8a, 0x3d, 0x70, 0x03, 0x6a, 
  0x6f, 0x52, 0x04, 0x46, 0x18, 0xce, 0x93, 0x59, 0x3c, 0xdc, 0xc5, 0x48, 
  0xba, 0x51, 0x90, 0x3b, 0x0e, 0x67, 0x62, 0xb6, 0x0e, 0xcc, 0x63, 0xaf, 
  0xb3, 0xb8, 0xe8, 0x74, 0x4d, 0x40, 0xe1, 0xd6, 0x50, 0x0b, 0x3a, 0xb6, 
  0xb4, 0x82, 0xe6, 0x46, 0x2b, 0xcd, 0xaf, 0xdf, 0xe9, 0xf7, 0x6f, 0x72, 
  0x73, 0x76, 0x26, 0x44, 0xcc, 0x1e, 0x64, 0x1f, 0xd2, 0xc5, 0xe3, 0xdb, 
  0xad, 0x83, 0xf8, 0xa0, 0x8e, 0xb1, 0xc8, 0x40, 0x1c, 0x2b, 0x44, 0x0b, 
  0xf2, 0x1e, 0x65, 0x31, 0xe5, 0x23, 0x1e, 0xb9, 0x06, 0xc9, 0xc4, 0xa3, 
  0xab, 0xc0, 0x1c, 0x6d, 0xc0, 0x39, 0x82, 0x38, 0xcc, 0x17, 0xa4, 0xbb, 
  0x15, 0xe9, 0xb8, 0x17, 0x1d, 0xa6, 0x74, 0xf7, 0x97, 0x3d, 0x8f, 0x55, 
  0xe4, 0x10, 0x9e, 0x48, 0xbf, 0x22, 0x1a, 0x46, 0x7a, 0x2e, 0xc9, 0x13, 
  0x88, 0xcc, 0x83, 0x92, 0x51, 0xf1, 0x1d, 0xd0, 0x32, 0xa8, 0xb6, 0xa5, 
  0x32, 0x3f, 0x22, 0x99, 0xd0, 0xb6, 0x07, 0x63, 0x01, 0xf1, 0xc5, 0xc5, 
  0x8d, 0xd3, 0xaf, 0x7d, 0xad, 0xee, 0x0c, 0xa5, 0x6e, 0xe9, 0x73, 0x50, 
  0x21, 0xa4, 0xc4, 0x6c, 0xe5, 0xdc, 0x0a, 0xf8, 0xdb, 0xc1, 0x43, 0x58, 
  0xc0, 0x18, 0x1c, 0x73, 0x85, 0x8b, 0xe0, 0x12, 0xaf, 0x01, 0xf8, 0x9d, 
  0x15, 0xc4, 0xde, 0x40, 0x50, 0x18, 0xad, 0x13, 0xaf, 0x88, 0x28, 0x3a, 
  0x0c, 0xd1, 0xf2, 0x87, 0x68, 0x98, 0x32, 0xc4, 0xab, 0x91, 0x2c, 0xf2, 
  0x91, 0x1e, 0xa3, 0x58, 0x97, 0x05, 0xa6, 0x52, 0xbf, 0x45, 0x8c, 0x0b, 
  0x0d, 0x06, 0xa8, 0x2b, 0x30, 0x6b, 0xdf, 0xa6, 0xb1, 0x04, 0xe7, 0xb0, 
  0xd7, 0x97, 0xe7, 0xfe, 0x8e, 0x81, 0x5a, 0xde, 0x79, 0x18, 0xcd, 0x95, 
  0xbe, 0x08, 0x8c, 0x14, 0x50, 0xbd, 0xb8, 0xef, 0x8b, 0x15, 0x2d, 0xeb, 
  0x38, 0xcd, 0x89, 0xc9, 0x73, 0x2a, 0xcf, 0x58, 0xf0, 0xa6, 0x10, 0x3b, 
  0x82, 0xb1, 0xb3, 0x22, 0x11, 0x8f, 0x88, 0xae, 0xb0, 0x5c, 0x6c, 0x1b, 
  0x83, 0x15, 0xde, 0x97, 0x9a, 0x59, 0xe6, 0x08, 0x1d, 0xac, 0x1c, 0x56, 
  0xe4, 0x5b, 0x21, 0x95, 0x07, 0x70, 0xc0, 0x0a, 0xd2, 0xb3, 0xa1, 0x31, 
  0x1d, 0x68, 0x17, 0xa3, 0x76, 0xb0, 0x75, 0x1c, 0x8e, 0xe1, 0x68, 0x39, 
  0xf0, 0xe4, 0xab, 0x70, 0xb0, 0xb1, 0x81, 0x08, 0x0c, 0x6e, 0x81, 0x2f, 
  0xba, 0x85, 0x63, 0xbb, 0xae, 0xd6, 0x87, 0xf8, 0xb6, 0x99, 0xc4, 0x27, 
  0xd1, 0xfc, 0x41, 0xd3, 0x10, 0xb1, 0x7b, 0xc0, 0x1c, 0x13, 0xc9, 0xe9, 
  0xb3, 0xcf, 0x1a, 0x97, 0xc2, 0xbd, 0x7b, 0xfa, 0x05, 0x7d, 0x1d, 0x48, 
  0x68, 0x33, 0x36, 0x39, 0x1b, 0xd8, 0xb8, 0x17, 0xd3, 0xbe, 0xae, 0x86, 
  0x36, 0x5a, 0xfa, 0x9c, 0xc5, 0x97, 0x70, 0x87, 0x6a, 0x26, 0x2a, 0xda, 
  0xb6, 0xd4, 0x01, 0xaa, 0x6f, 0x08, 0xa2, 0xba, 0x02, 0xcb, 0x16, 0xe2, 
  0xf2, 0x78, 0xd1, 0x3c, 0xb4, 0x3e, 0x70, 0x70, 0xd2, 0x18, 0x6c, 0x70, 
  0x7b, 0xd2, 0x0d, 0x3e, 0xe0, 0x0b, 0x97, 0x85, 0x81, 0x61, 0xa6, 0x0d, 
  0x73, 0xa8, 0xa6, 0x0e, 0xc6, 0xa1, 0x01, 0xd5, 0x30, 0x6c, 0x5d, 0x80, 
  0xa2, 0x2f, 0xe7, 0xfe, 0x76, 0xfd, 0x70, 0xde, 0xfe, 0xa6, 0xe1, 0x84, 
  0x65, 0x8e, 0xdb, 0x93, 0x2b, 0x0f, 0x02, 0x46, 0x21, 0x6b, 0x08, 0x76, 
  0x43, 0x82, 0x64, 0x0e, 0x67, 0x92, 0x26, 0x27, 0x6a, 0x82, 0x10, 0x51, 
  0xc3, 0xc5, 0xfe, 0xe9, 0xd7, 0x47, 0xa0, 0x4f, 0x66, 0x13, 0x3e, 0xd9, 
  0x8c, 0x33, 0x5e, 0xa4, 0x54, 0x72, 0x21, 0xbe, 0xf5, 0x94, 0xdf, 0x98, 
  0xac, 0xc6, 0x6c, 0x1a, 0x7a, 0xeb, 0x30, 0x8a, 0x80, 0xba, 0x34, 0x43, 
  0x29, 0x3a, 0x66, 0x11, 0x6a, 0xac, 0xdd, 0x88, 0x2c, 0x76, 0x15, 0x14, 
  0x8e, 0x52, 0xa9, 0xaa, 0x81, 0x16, 0xab, 0xd1, 0x32, 0xd6, 0xc4, 0x8b, 
  0x38, 0x8c, 0xe5, 0xb7, 0x02, 0xae, 0x95, 0x29, 0x30, 0xaf, 0xd3, 0xfa, 
  0xb6, 0x76, 0x0f, 0xe7, 0xb8, 0x87, 0x07, 0xa1, 0x70, 0x2b, 0x80, 0x04, 
  0xbe, 0x6c, 0xae, 0x08, 0xe5, 0xda, 0x60, 0x63, 0xe9, 0xf3, 0x88, 0x2b, 
  0x1f, 0xaf, 0x5b, 0x63, 0xd7, 0x68, 0xb5, 0xa0, 0xf1, 0x7b, 0xdb, 0x44, 
  0x5d, 0xe4, 0x75, 0x6d, 0x1e, 0x34, 0x8b, 0x11, 0x68, 0xcd, 0x59, 0x5d, 
  0x61, 0xf3, 0x33, 0xa9, 0x54, 0x26, 0xba, 0x1f, 0x34, 0xf1, 0x85, 0xcb, 
  0xc8, 0xe4, 0xa5, 0xdc, 0x88, 0xdc, 0xcd, 0x05, 0xc8, 0x06, 0x13, 0xe0, 
  0x96, 0x6c, 0x2b, 0x4f, 0x9d, 0xbd, 0xea, 0x83, 0x16, 0x46, 0xa9, 0x94, 
  0xba, 0x5d, 0xb7, 0x44, 0xd3, 0xe6, 0x6c, 0x54, 0x85, 0x8b, 0x48, 0x96, 
  0x3b, 0x67, 0x01, 0x9d, 0xe4, 0x39, 0x2f, 0xc5, 0xbd, 0x95, 0xc4, 0x77, 
  0x76, 0xd1, 0xc0, 0x19, 0x08, 0x40, 0x58, 0x46, 0x44, 0x93, 0xea, 0x08, 
  0xbe, 0xd4, 0x11, 0xb1, 0x9c, 0x36, 0xfd, 0xa8, 0x7f, 0x19, 0xf5, 0x03, 
  0xbe, 0xa1, 0x79, 0xef, 0xcc, 0x34, 0xe6, 0x0f, 0x76, 0x87, 0x6a, 0x1f, 
  0x68, 0xdf, 0x14, 0xbb, 0x4a, 0x0d, 0xa5, 0x9e, 0xc4, 0x95, 0x08, 0xc5, 
  0x34, 0xf8, 0x46, 0x4b, 0x97, 0xd2, 0x0d, 0xf8, 0x50, 0x8d, 0x4b, 0x7c, 
  0xd8, 0x50, 0xe2, 0xf5, 0xe5, 0x60, 0x78, 0x92, 0x3d, 0x93, 0xcf, 0xea, 
  0xaa, 0x82, 0x82, 0x00, 0xcd, 0x25, 0xe2, 0xbd, 0xcc, 0xb2, 0x17, 0x1b, 
  0xd1, 0x7f, 0x3a, 0xb8, 0x47, 0x86, 0x85, 0x48, 0x72, 0x94, 0x94, 0x49, 
  0x26, 0xb5, 0x61, 0x06, 0xec, 0x9f, 0x5b, 0x6d, 0x2e, 0x11, 0x5a, 0x92, 
  0x41, 0xc4, 0xed, 0x1d, 0x4b, 0x4b, 0xb6, 0x32, 0x2d, 0xf4, 0xce, 0x7b, 
  0xae, 0xc0, 0x08, 0x2e, 0x4e, 0xcf, 0x32, 0x8a, 0x59, 0xc2, 0x95, 0x8a, 
  0x92, 0x53, 0x9f, 0x68, 0x2c, 0x8e, 0x2a, 0x89, 0x25, 0x05, 0x6a, 0x02, 
  0x13, 0x11, 0x82, 0xcc, 0xc1, 0xd6, 0x6e, 0xe0, 0xe2, 0x98, 0x6a, 0x9e, 
  0x32, 0x84, 0xd0, 0xe3, 0xa9, 0x65, 0x6a, 0xf9, 0xb4, 0xef, 0x7c, 0x65, 
  0x65, 0x62, 0x59, 0xa2, 0xa4, 0xc1, 0xc7, 0xc5, 0x35, 0xec, 0xc0, 0xae, 
  0x24, 0x40, 0x63, 0xba, 0x95, 0xd4, 0x65, 0xe2, 0xcc, 0xc2, 0x96, 0xc1, 
  0x50, 0x2b, 0x4b, 0x51, 0x5d, 0x81, 0x40, 0x9e, 0xfe, 0xd0, 0x63, 0xc0, 
  0xdc, 0x62, 0xfd, 0x39, 0x68, 0x14, 0xed, 0xa8, 0x51, 0x1f, 0xe2, 0xf1, 
  0x9d, 0x50, 0x25, 0x6d, 0xc9, 0xd5, 0x09, 0x5c, 0x39, 0xd4, 0x4b, 0x40, 
  0xc6, 0x5c, 0x6d, 0x09, 0x21, 0x76, 0xa1, 0xae, 0x8d, 0x24, 0xd0, 0x19, 
  0x87, 0xd5, 0xb4, 0x22, 0xa4, 0x76, 0x7b, 0x2c, 0x48, 0x75, 0xd9, 0x32, 
  0xac, 0xa9, 0x44, 0x23, 0xc0, 0x78, 0xc5, 0x60, 0x92, 0x99, 0xf4, 0x89, 
  0x19, 0xca, 0x00, 0x7b, 0x51, 0xa1, 0xb9, 0x15, 0xe7, 0x67, 0xc3, 0x4b, 
  0x96, 0x07, 0x21, 0xbf, 0x9a, 0xc8, 0xf2, 0xdd, 0xd1, 0xc5, 0x57, 0x67, 
  0xc3, 0xa3, 0x68, 0x3b, 0x3a, 0x3c, 0xfa, 0xea, 0x2d, 0xb3, 0x0d, 0xde, 
  0x31, 0xd1, 0xd8, 0x50, 0x56, 0x4b, 0xf0, 0xf2, 0x10, 0xf5, 0xed, 0xc4, 
  0x39, 0x49, 0x72, 0xea, 0x19, 0x65, 0xf8, 0x5a, 0xe3, 0xfc, 0xc4, 0x2c, 
  0x11, 0xcd, 0x28, 0x85, 0xf3, 0xde, 0x27, 0xaf, 0xb3, 0x98, 0xb7, 0x60, 
  0xac, 0xb8, 0xd2, 0x10, 0x98, 0x0d, 0x40, 0xad, 0x78, 0xe1, 0xc5, 0xb8, 
  0x5b, 0x51, 0xe8, 0xf4, 0x68, 0x78, 0x50, 0x73, 0x03, 0x2f, 0x1f, 0x04, 
  0xb5, 0x98, 0x14, 0x87, 0x70, 0x96, 0xc9, 0xc5, 0xc5, 0xa1, 0xdc, 0x38, 
  0xd6, 0x80, 0xd6, 0x4c, 0x51, 0x8d, 0x42, 0xa1, 0x9e, 0x14, 0x4a, 0xbc, 
  0x10, 0x82, 0x83, 0x4f, 0x87, 0xbb, 0x98, 0x29, 0x47, 0x06, 0x43, 0x2a, 
  0x12, 0xc9, 0x40, 0x94, 0x8b, 0x53, 0x2d, 0x5c, 0xa2, 0x0b, 0x29, 0x86, 
  0xd1, 0x26, 0x1f, 0x09, 0xce, 0x01, 0x76, 0x25, 0x16, 0x37, 0x22, 0x85, 
  0xdc, 0xa6, 0x57, 0xc7, 0x5c, 0xe3, 0x0e, 0x2b, 0xbf, 0x35, 0xa8, 0x93, 
  0xce, 0xed, 0x7a, 0xc6, 0x70, 0x29, 0x33, 0xe5, 0x6c, 0x31, 0xb9, 0x8b, 
  0x5d, 0x3d, 0x33, 0x98, 0x50, 0x7d, 0x74, 0x3a, 0x3b, 0xa8, 0x1c, 0x6c, 
  0x89, 0x9c, 0x27, 0x76, 0x9e, 0x07, 0x12, 0xd7, 0x7a, 0x8c, 0x6e, 0x53, 
  0x3a, 0xd5, 0x43, 0xe6, 0x63, 0x81, 0x5c, 0x25, 0x27, 0x62, 0xcf, 0xd8, 
  0x52, 0xad, 0x6a, 0x53, 0xab, 0x64, 0xa3, 0x67, 0x50, 0x5a, 0xc7, 0xbf, 
  0x83, 0xf2, 0xbe, 0x0c, 0xed, 0x0d, 0xc4, 0x25, 0x37, 0x0e, 0x8f, 0x2e, 
  0xf7, 0x8f, 0x4f, 0x8e, 0x0e, 0xa3, 0xe3, 0xd3, 0xd7, 0x67, 0x17, 0x6f, 
  0xf6, 0x2f, 0xd5, 0xc0, 0x7a, 0xe8, 0xf4, 0x29, 0x87, 0x40, 0xed, 0xf4, 
  0x4e, 0xaf, 0x6b, 0x81, 0x86, 0x69, 0x1b, 0xaf, 0x14, 0x3b, 0x42, 0xd6, 
  0x21, 0xa9, 0x2c, 0xc2, 0x46, 0xa4, 0x86, 0x59, 0x8f, 0x29, 0xcd, 0x77, 
  0xf3, 0xb6, 0x33, 0x78, 0x0d, 0x6c, 0x3d, 0x4d, 0x1b, 0x42, 0x5d, 0xc8, 
  0x47, 0x9b, 0x72, 0x15, 0x82, 0xe4, 0x9e, 0x02, 0x00, 0x29, 0x02, 0x98, 
  0x41, 0x94, 0xfd, 0x63, 0x4e, 0x94, 0x43, 0xa2, 0xbd, 0x16, 0x95, 0xe3, 
  0x2a, 0xf2, 0x06, 0x31, 0x1e, 0xa3, 0xf6, 0x94, 0x2f, 0x9e, 0x0e, 0x12, 
  0x44, 0xd9, 0xaa, 0xa0, 0x4d, 0x17, 0xac, 0x6e, 0xa0, 0xd1, 0x03, 0xaf, 
  0xdb, 0x87, 0x1b, 0xac, 0x59, 0x97, 0x44, 0xce, 0xea, 0x16, 0x10, 0xff, 
  0xbf, 0x16, 0x4b, 0x7c, 0xad, 0x8d, 0x78, 0x2e, 0x6a, 0x56, 0x2d, 0x05, 
  0x18, 0x0a, 0x9b, 0xda, 0x74, 0x25, 0x8d, 0x48, 0x6a, 0xe9, 0x1f, 0x13, 
  0xc5, 0xf2, 0x7c, 0x78, 0x2d, 0x18, 0x29, 0x8e, 0x7f, 0x2e, 0xc2, 0x22, 
  0xb6, 0x60, 0x17, 0x5e, 0x42, 0x0e, 0x70, 0xe8, 0xf5, 0xb8, 0xf9, 0x83, 
  0x5b, 0x18, 0xa9, 0x1d, 0xd2, 0x43, 0x5c, 0x5d, 0xa5, 0xaf, 0xdd, 0x5b, 
  0x65, 0x2b, 0x16, 0x8e, 0x6c, 0x0b, 0x45, 0x70, 0x82, 0x40, 0x80, 0x78, 
  0xd0, 0xd7, 0xba, 0x06, 0x32, 0x0f, 0x10, 0x78, 0x69, 0x26, 0x34, 0x94, 
  0xdb, 0x76, 0x56, 0x2f, 0x07, 0x9a, 0xdf, 0xa8, 0xc7, 0xe6, 0x0a, 0x36, 
  0x0c, 0xdd, 0xb3, 0x58, 0xc9, 0xe0, 0x85, 0xd8, 0xfb, 0x1c, 0xb0, 0xfe, 
  0x9b, 0x06, 0x52, 0xc9, 0x34, 0xab, 0x0d, 0x26, 0xf7, 0x31, 0x8b, 0x7a, 
  0x4d, 0xa3, 0x5d, 0x65, 0x52, 0xe1, 0x8b, 0x55, 0x2b, 0x7d, 0xc8, 0xea, 
  0xad, 0x6b, 0x8c, 0x7e, 0xd2, 0x36, 0x02, 0x65, 0xe3, 0xa8, 0x7b, 0x43, 
  0x54, 0xc5, 0x10, 0x9c, 0x31, 0xac, 0xd5, 0x9c, 0x7e, 0xbd, 0xa1, 0x18, 
  0x59, 0xca, 0x2a, 0x61, 0x48, 0x0a, 0x53, 0xfa, 0xc6, 0x8c, 0xf9, 0xcf, 
  0x16, 0x1c, 0x3e, 0x25, 0xd5, 0x28, 0xba, 0xe8, 0x0d, 0xaf, 0x81, 0x55, 
  0x3e, 0x64, 0xae, 0xb7, 0xd8, 0x30, 0x9c, 0x22, 0x7b, 0x69, 0xac, 0x02, 
  0x28, 0xd8, 0xbf, 0x24, 0x77, 0x82, 0xcb, 0xb3, 0x05, 0x9b, 0xab, 0x2c, 
  0xc2, 0x66, 0xc0, 0xba, 0xaf, 0x5c, 0x1a, 0x20, 0x01, 0xcc, 0xd5, 0x61, 
  0x93, 0xe0, 0xf6, 0xf1, 0xa5, 0xb2, 0xfa, 0x92, 0x88, 0x1e, 0x73, 0x42, 
  0x80, 0x1d, 0x0a, 0x50, 0xb4, 0x6f, 0x05, 0x97, 0x1d, 0x27, 0x9d, 0xe6, 
  0x33, 0xb8, 0xd5, 0xd4, 0xb3, 0x7b, 0xce, 0x0f, 0xc4, 0x26, 0x65, 0x77, 
  0x3c, 0x90, 0x6f, 0x67, 0x79, 0x4d, 0x7d, 0x74, 0xa2, 0x2b, 0xd6, 0x53, 
  0x46, 0x34, 0xf4, 0x06, 0x07, 0x9d, 0xc8, 0xe3, 0xaf, 0x2e, 0xe2, 0x69, 
  0x9c, 0xcc, 0x3e, 0xd9, 0xdb, 0x19, 0xc6, 0x57, 0xab, 0x59, 0xfc, 0x27, 
  0xbc, 0xf8, 0xea, 0xc9, 0x93, 0xbd, 0x9d, 0xbf, 0x7e, 0xb6, 0xd3, 0x89, 
  0xfe, 0xde, 0x80, 0x0b, 0x0a, 0xcd, 0xda, 0x28, 0x42, 0xc6, 0x8c, 0x17, 
  0xfd, 0x0c, 0xc6, 0x57, 0xb0, 0xc6, 0x7f, 0xc3, 0xd2, 0x8b, 0xae, 0x41, 
  0x8c, 0x08, 0x59, 0xe1, 0x93, 0x0a, 0xe5, 0x4f, 0x57, 0x2e, 0xd1, 0xf5, 
  0x1f, 0x77, 0x5f, 0x08, 0x2b, 0xbb, 0x82, 0x0d, 0x25, 0x16, 0x8a, 0x8d, 
  0x5e, 0xa6, 0x0b, 0xba, 0x82, 0xbe, 0x88, 0xca, 0xf8, 0xca, 0xd1, 0x2a, 
  0x5a, 0x70, 0x85, 0xff, 0xcc, 0x2e, 0x38, 0x4d, 0x51, 0x26, 0x6b, 0x10, 
  0x6d, 0x5e, 0x0a, 0x80, 0x0e, 0x24, 0x9f, 0x65, 0x92, 0xcf, 0x24, 0xad, 
  0x27, 0x9e, 0x5b, 0xec, 0x01, 0xbf, 0xcf, 0x8e, 0xa8, 0xc1, 0x72, 0x66, 
  0x05, 0x02, 0xc5, 0xd2, 0x94, 0x7a, 0x82, 0x9b, 0x2d, 0x0b, 0x0f, 0x6d, 
  0x2f, 0xf7, 0x8d, 0x00, 0x0b, 0x01, 0x9a, 0x27, 0xf6, 0x69, 0x88, 0x3c, 
  0xab, 0x9e, 0x03, 0xcd, 0xee, 0x4f, 0x6c, 0xa6, 0x03, 0xfc, 0x8e, 0xea, 
  0x20, 0x5a, 0x6d, 0xaa, 0xc3, 0x1f, 0x33, 0x77, 0x30, 0xc8, 0x66, 0x4d, 
  0xfc, 0xaa, 0xcc, 0x2b, 0xf6, 0x7e, 0xe7, 0xe8, 0xa5, 0x29, 0xb8, 0xbb, 
  0x5f, 0xbc, 0x02, 0x41, 0xec, 0x7e, 0xf1, 0x27, 0xf7, 0xd9, 0x9e, 0x7e, 
  0xb6, 0xf7, 0xc5, 0x9f, 0x06, 0x03, 0x8c, 0x8f, 0x29, 0xa4, 0x6b, 0x5f, 
  0x77, 0x35, 0x5f, 0x24, 0xd6, 0x23, 0x2c, 0x7f, 0x39, 0x2c, 0x0d, 0xd9, 
  0xeb, 0x8e, 0xf5, 0x1c, 0xae, 0x72, 0x4f, 0x21, 0xb9, 0x1d, 0xdf, 0x4a, 
  0x0d, 0x1b, 0x10, 0x20, 0x5b, 0x45, 0xdb, 0xa2, 0x3b, 0x73, 0x16, 0xda, 
  0x29, 0x1c, 0x08, 0x41, 0x1c, 0xfd, 0x99, 0x29, 0xf5, 0xcf, 0x1b, 0x40, 
  0xc8, 0xa3, 0x6d, 0xe0, 0xed, 0x40, 0x99, 0x98, 0xc8, 0xc8, 0x56, 0xaa, 
  0x1b, 0x0a, 0xfa, 0x0f, 0xb7, 0xcc, 0xb1, 0x01, 0x7c, 0x09, 0x06, 0x90, 
  0xc5, 0x7f, 0x51, 0x33, 0xa9, 0x6c, 0xf8, 0x86, 0xe1, 0x4a, 0x4b, 0xd0, 
  0xb5, 0xa0, 0x13, 0xeb, 0x66, 0x7d, 0xf2, 0xc3, 0x0f, 0x2a, 0x4f, 0xd1, 
  0x2f, 0x3a, 0xee, 0x6b, 0xe2, 0x44, 0x5c, 0xf5, 0x99, 0xf1, 0x97, 0xa9, 
  0x71, 0xc1, 0x99, 0xd6, 0x1b, 0x7f, 0xaa, 0xf3, 0x94, 0x46, 0x68, 0x63, 
  0xa5, 0xc0, 0x15, 0x8f, 0x0c, 0x4b, 0x7a, 0x24, 0x4c, 0x0c, 0x94, 0xb9, 
  0x09, 0xc7, 0x88, 0x77, 0x33, 0x86, 0x84, 0xcf, 0x3b, 0x87, 0x4d, 0x07, 
  0xed, 0x53, 0x63, 0xa6, 0x02, 0xeb, 0x46, 0x82, 0x62, 0x45, 0xc8, 0x79, 
  0xd5, 0x91, 0x07, 0xaf, 0xd2, 0x8e, 0x1a, 0x23, 0xe5, 0x93, 0x8e, 0x4f, 
  0xff, 0x91, 0xdd, 0xc0, 0x96, 0xbd, 0x12, 0xc9, 0x29, 0xfd, 0x25, 0x79, 
  0xb5, 0xbb, 0xd3, 0xfe, 0x04, 0x2b, 0x46, 0x28, 0x37, 0xfa, 0xca, 0x1b, 
  0xc0, 0x1e, 0x7b, 0x3e, 0x9d, 0xc8, 0xd3, 0x5a, 0xe4, 0x05, 0x90, 0xd9, 
  0xaf, 0x3a, 0x23, 0xbe, 0x5f, 0xf9, 0xff, 0xd7, 0x8c, 0x03, 0x31, 0x0f, 
  0xfa, 0x6c, 0xb1, 0x1a, 0xcd, 0xd3, 0xca, 0x80, 0xb7, 0x79, 0x82, 0x5f, 
  0xc0, 0x9c, 0x92, 0x38, 0xda, 0x40, 0x30, 0x8c, 0x88, 0x7e, 0xdd, 0x69, 
  0x96, 0x8d, 0xe2, 0xbc, 0xab, 0x06, 0x3f, 0x1b, 0x67, 0x77, 0x77, 0xef, 
  0xc9, 0xd3, 0x67, 0xdd, 0x81, 0x8a, 0x69, 0x60, 0x10, 0xd0, 0xd1, 0x52, 
  0xd5, 0x65, 0xa4, 0x09, 0x97, 0x8a, 0x21, 0xb1, 0x7c, 0x88, 0x9c, 0x6f, 
  0x33, 0x8c, 0x33, 0x0f, 0xe3, 0xee, 0x5e, 0x49, 0x6f, 0x7f, 0xe2, 0x7e, 
  0x5e, 0xa1, 0x8b, 0x3f, 0xa5, 0x93, 0x57, 0x6e, 0x86, 0x7f, 0xe2, 0xb9, 
  0xbc, 0xd2, 0x49, 0xd0, 0xbe, 0x5a, 0x78, 0x5b, 0x11, 0x82, 0xbc, 0xbe, 
  0x6f, 0x73, 0x6d, 0x13, 0x37, 0x30, 0x69, 0x64, 0x27, 0xf7, 0x27, 0x62, 
  0x2a, 0x84, 0xb0, 0xea, 0x83, 0xb3, 0xb6, 0xef, 0xfb, 0xd4, 0x4a, 0x1f, 
  0x85, 0xdc, 0x3d, 0xbb, 0x8e, 0xe6, 0x1c, 0xa8, 0xca, 0x1b, 0xd1, 0xd3, 
  0x18, 0xbf, 0x19, 0xec, 0x1c, 0x2a, 0x08, 0x64, 0x19, 0x02, 0xbe, 0x0e, 
  0xbe, 0x3e, 0xee, 0xaa, 0xbb, 0x4a, 0x34, 0xb7, 0x5e, 0x5b, 0x85, 0x47, 
  0xb1, 0x45, 0xe7, 0x89, 0x65, 0xa5, 0x6e, 0x58, 0xe6, 0x69, 0xcc, 0xde, 
  0x17, 0xee, 0x57, 0x82, 0x94, 0xb9, 0x24, 0xad, 0xdc, 0x39, 0xb3, 0x18, 
  0x90, 0xde, 0xc0, 0xd0, 0x0b, 0x9a, 0x01, 0x4e, 0x83, 0xb8, 0x61, 0xa0, 
  0x1b, 0x7b, 0x04, 0xbe, 0xfe, 0x6b, 0x67, 0xb9, 0x76, 0x91, 0x5f, 0xfa, 
  0x28, 0x7d, 0x25, 0xdc, 0xc4, 0x18, 0x44, 0xc7, 0x95, 0x11, 0x10, 0x4a, 
  0x08, 0x79, 0x07, 0xec, 0xee, 0xa3, 0x44, 0x23, 0x00, 0xc5, 0x90, 0x21, 
  0x62, 0x21, 0x73, 0xcf, 0x97, 0x0e, 0x7e, 0xfe, 0x8b, 0x08, 0x88, 0xba, 
  0xf2, 0x96, 0xc6, 0x4a, 0xa9, 0x09, 0x48, 0xcc, 0xb5, 0x78, 0x49, 0xb5, 
  0x03, 0x67, 0xa5, 0x0f, 0x7c, 0x58, 0x2a, 0x16, 0x48, 0x0b, 0x32, 0xd1, 
  0xd1, 0x83, 0x5a, 0x02, 0xb8, 0x85, 0xee, 0xe7, 0x38, 0x04, 0x2f, 0x79, 
  0x1b, 0xf0, 0xf5, 0x17, 0x5d, 0x31, 0xdf, 0x55, 0xea, 0x97, 0xd6, 0xbc, 
  0x00, 0x42, 0xa0, 0xe1, 0x7c, 0xb2, 0xa9, 0xc3, 0x86, 0x10, 0x59, 0x2c, 
  0x65, 0x3d, 0x02, 0xfa, 0x54, 0x9a, 0xcc, 0x26, 0x5a, 0x1a, 0x43, 0x65, 
  0x21, 0xcb, 0x41, 0x4f, 0x38, 0x4c, 0x8d, 0x65, 0xc7, 0x2e, 0x3b, 0x88, 
  0xf1, 0x5e, 0xd7, 0xa7, 0xae, 0x5a, 0x5a, 0xff, 0x75, 0x9e, 0x58, 0xd9, 
  0x88, 0x0d, 0x0d, 0x83, 0xf7, 0xb2, 0x7c, 0x38, 0xb1, 0x22, 0x10, 0x1d, 
  0x7c, 0x3c, 0x99, 0x64, 0x81, 0x35, 0x8e, 0xc8, 0x6b, 0x0e, 0x4f, 0xd5, 
  0x4e, 0x5f, 0xf1, 0x72, 0xef, 0x0e, 0xae, 0xd2, 0xa9, 0x2c, 0x06, 0xb1, 
  0xc8, 0xab, 0x64, 0x9b, 0xfe, 0xe4, 0x12, 0x9a, 0x7b, 0x2c, 0x93, 0xf1, 
  0x2f, 0x4f, 0xe0, 0xc5, 0x0c, 0x6f, 0xfe, 0xe0, 0x6c, 0xb8, 0x73, 0xc1, 
  0xbf, 0xa4, 0xee, 0xc6, 0x57, 0x0c, 0x3e, 0x1d, 0x25, 0xc8, 0xbc, 0x52, 
  0x5c, 0x5d, 0x8a, 0xa9, 0x07, 0x35, 0x73, 0xa5, 0x0c, 0x2f, 0x4b, 0x0d, 
  0x85, 0x0f, 0xf1, 0xd0, 0x9a, 0x1b, 0x3e, 0x4c, 0x77, 0x33, 0x55, 0x8b, 
  0x09, 0xc7, 0xb8, 0xe1, 0x5e, 0x4d, 0xee, 0xb6, 0x80, 0x98, 0x63, 0xea, 
  0xad, 0x95, 0x4f, 0x0f, 0x43, 0xe6, 0x65, 0xf7, 0x01, 0x21, 0xbe, 0x11, 
  0x85, 0x31, 0xac, 0x52, 0x7b, 0xbc, 0xbe, 0x83, 0x55, 0xb0, 0x7f, 0x71, 
  0x7f, 0xa7, 0x45, 0xb9, 0x85, 0x02, 0xa1, 0xb3, 0x02, 0xaa, 0xba, 0xd6, 
  0xc4, 0xf5, 0xeb, 0x6e, 0xa9, 0xca, 0xe8, 0xaa, 0xcb, 0xd5, 0x07, 0xb6, 
  0xe1, 0xbb, 0x10, 0xde, 0x76, 0x34, 0x17, 0x04, 0x56, 0x90, 0xed, 0xac, 
  0x2f, 0xf7, 0xa5, 0x0a, 0x41, 0xfd, 0xd7, 0x83, 0xe8, 0x04, 0xd1, 0x0e, 
  0x45, 0xfc, 0x00, 0x72, 0xb6, 0x3b, 0xd5, 0x28, 0x80, 0xc8, 0x45, 0xa4, 
  0xee, 0x0d, 0xa9, 0x40, 0xc1, 0x39, 0x2c, 0x46, 0x46, 0xc0, 0xa6, 0xf2, 
  0x7a, 0xa6, 0x48, 0x14, 0x2a, 0x81, 0xf4, 0x60, 0x81, 0x76, 0xcf, 0xa1, 
  0xf4, 0x06, 0x9e, 0x42, 0x09, 0x51, 0x4f, 0xa4, 0x41, 0x23, 0xae, 0x8c, 
  0x25, 0x8b, 0x9c, 0x01, 0x2b, 0x77, 0x84, 0x2f, 0xa9, 0x32, 0x89, 0xd8, 
  0x59, 0xac, 0xe0, 0x3a, 0x9c, 0x26, 0xd4, 0x1a, 0x28, 0x8b, 0xe7, 0xce, 
  0xa4, 0xd3, 0x81, 0xa6, 0x38, 0x4b, 0x9c, 0x3e, 0xad, 0xa8, 0x8c, 0x1a, 
  0x51, 0xa5, 0x79, 0xdb, 0x22, 0x60, 0x78, 0xa4, 0x35, 0x1e, 0x24, 0x8f, 
  0x2b, 0xbe, 0xa5, 0x5f, 0xf8, 0x92, 0x1f, 0xe5, 0xb4, 0xd3, 0x56, 0x6b, 
  0x57, 0xaa, 0x61, 0x06, 0x65, 0x28, 0xbe, 0xb9, 0x7c, 0x73, 0x62, 0x20, 
  0x08, 0x96, 0xcc, 0xc3, 0x2b, 0x6b, 0x31, 0x0c, 0x98, 0xa2, 0x1a, 0x43, 
  0x44, 0x02, 0xd2, 0xa7, 0xe4, 0x66, 0x93, 0xb5, 0xe5, 0xd0, 0xeb, 0x88, 
  0x17, 0xa7, 0x72, 0x4c, 0x83, 0x27, 0xe4, 0x55, 0xa6, 0x1d, 0x22, 0x8d, 
  0x2e, 0x2f, 0x41, 0xb7, 0x17, 0x75, 0x79, 0xa8, 0xfc, 0x45, 0x17, 0xeb, 
  0x89, 0x8f, 0x83, 0xe5, 0xeb, 0x0e, 0x5a, 0x4e, 0x1e, 0x3f, 0xf3, 0xea, 
  0xcb, 0xca, 0x2a, 0xe1, 0x73, 0x6b, 0xea, 0x95, 0x44, 0x8a, 0x35, 0xa4, 
  0x6c, 0x7b, 0x37, 0x68, 0xff, 0xd5, 0x01, 0xb5, 0x22, 0x65, 0x2e, 0x64, 
  0x4f, 0x20, 0x50, 0xbb, 0xcf, 0x52, 0x04, 0x50, 0x36, 0x1a, 0x7a, 0xff, 
  0xc9, 0xbd, 0x34, 0xf6, 0xe3, 0x82, 0x25, 0x84, 0xa3, 0x09, 0x09, 0x18, 
  0xb7, 0xa5, 0xdd, 0x4c, 0x45, 0xd3, 0xbb, 0xcb, 0x60, 0x57, 0x00, 0x9f, 
  0xd9, 0xe5, 0x12, 0xf3, 0x8b, 0x46, 0x91, 0xe0, 0x34, 0x50, 0xd7, 0x3b, 
  0x58, 0xd0, 0x8e, 0xd9, 0x49, 0x9c, 0x12, 0x6f, 0xab, 0xdc, 0x34, 0x06, 
  0xd3, 0xd4, 0xb5, 0xbc, 0x2e, 0xf1, 0xab, 0x49, 0x76, 0xc5, 0xec, 0xaa, 
  0x47, 0x37, 0x2b, 0xff, 0xec, 0x44, 0x78, 0x7c, 0x4f, 0xfb, 0x95, 0x31, 
  0xe3, 0xb8, 0x88, 0xe8, 0x6e, 0x7f, 0x6b, 0x3c, 0x47, 0xd4, 0xb2, 0x25, 
  0x93, 0x6c, 0xac, 0xcd, 0xbb, 0xd6, 0x65, 0x4f, 0xa8, 0x0b, 0xf7, 0x85, 
  0xef, 0x2e, 0x58, 0xa1, 0x58, 0xdb, 0x96, 0x9a, 0x23, 0xb3, 0xb4, 0x94, 
  0x3b, 0x1c, 0x5d, 0xb3, 0x06, 0x03, 0xc3, 0x16, 0x43, 0x3a, 0xcb, 0x85, 
  0x35, 0xd3, 0xec, 0x98, 0xee, 0x97, 0x5d, 0x58, 0xc8, 0xb8, 0x2a, 0x1f, 
  0x58, 0x17, 0x33, 0xa4, 0xf9, 0x28, 0x01, 0x12, 0x83, 0xde, 0x4a, 0x5d, 
  0xb9, 0x0e, 0xfb, 0x22, 0x34, 0x68, 0x41, 0x98, 0x0a, 0x88, 0x22, 0x73, 
  0x0d, 0xd3, 0x1e, 0x39, 0xd6, 0x72, 0x3e, 0x17, 0x0b, 0xb7, 0x16, 0xc2, 
  0xb6, 0x4a, 0x28, 0x8c, 0x8c, 0x30, 0x2a, 0xc5, 0x87, 0xaa, 0xb7, 0x2d, 
  0xe4, 0x31, 0xe4, 0x25, 0x15, 0xec, 0xe6, 0x13, 0xf3, 0xe6, 0x6a, 0xb1, 
  0xe4, 0xf8, 0xe3, 0x31, 0xaa, 0xa1, 0xe9, 0x81, 0x1a, 0x44, 0x6f, 0x17, 
  0x82, 0x66, 0x95, 0xb0, 0x8e, 0x1c, 0x3a, 0x78, 0x7b, 0xce, 0x51, 0x4d, 
  0x2b, 0x15, 0x9c, 0xde, 0xea, 0x80, 0xc5, 0x26, 0x22, 0xc6, 0x6b, 0xed, 
  0x97, 0xef, 0xd7, 0x9c, 0xdd, 0xe7, 0x6a, 0x9c, 0x86, 0x38, 0xe0, 0xb2, 
  0x8c, 0x94, 0x0b, 0xb1, 0x7b, 0xee, 0xe8, 0xf5, 0xd1, 0xc5, 0x85, 0x38, 
  0x7a, 0xf7, 0x2b, 0xa8, 0xc8, 0xc8, 0xd6, 0x96, 0xd8, 0x76, 0x8d, 0x7c, 
  0x77, 0x41, 0x32, 0xcd, 0x72, 0x74, 0xc2, 0x0e, 0x15, 0xf7, 0x62, 0x23, 
  0x32, 0xef, 0xaa, 0x64, 0xf8, 0x89, 0x59, 0x18, 0x36, 0x45, 0x84, 0x48, 
  0x39, 0xfb, 0xfd, 0x8c, 0xef, 0x16, 0x58, 0x1d, 0x2b, 0x12, 0xc5, 0x46, 
  0x64, 0xaf, 0xe6, 0x02, 0x96, 0xef, 0x6a, 0xa8, 0x2b, 0x6c, 0xb1, 0x13, 
  0x4e, 0x07, 0x1a, 0xd5, 0x92, 0xa8, 0xcf, 0x74, 0xe6, 0x6c, 0x12, 0x98, 
  0xef, 0x94, 0x4f, 0x29, 0xeb, 0x4b, 0x58, 0x89, 0xa2, 0x5c, 0x2d, 0xd3, 
  0x89, 0x33, 0xf1, 0xd2, 0xe7, 0x24, 0xf4, 0x45, 0x72, 0xce, 0x0b, 0x1b, 
  0x31, 0xbc, 0x89, 0x66, 0x80, 0x08, 0x2d, 0x6c, 0x92, 0x03, 0xe7, 0xed, 
  0x63, 0x08, 0x73, 0x95, 0x42, 0x44, 0x8a, 0xa1, 0x0a, 0x16, 0xdb, 0x60, 
  0x46, 0x09, 0x4c, 0x8b, 0xcc, 0x2f, 0xcc, 0x43, 0x1d, 0xf2, 0x06, 0xb6, 
  0x5f, 0xcd, 0x7d, 0x6c, 0x98, 0x2f, 0x10, 0x83, 0x05, 0xc0, 0xcd, 0xa9, 
  0xf7, 0x06, 0x02, 0xec, 0x7c, 0xdc, 0x96, 0xb8, 0xb2, 0x39, 0x71, 0x46, 
  0x56, 0x48, 0x35, 0x5f, 0xd2, 0xf7, 0x06, 0x1c, 0x06, 0x75, 0x74, 0x11, 
  0xed, 0x7f, 0xcd, 0x88, 0x18, 0xff, 0xd9, 0xb6, 0xf2, 0x73, 0x7a, 0x2f, 
  0xd8, 0xa6, 0x6a, 0x9a, 0x4c, 0x32, 0x09, 0x91, 0x9f, 0x07, 0x95, 0x1d, 
  0x4d, 0xb5, 0xc6, 0x41, 0x70, 0xb9, 0x57, 0xf7, 0x6e, 0x23, 0x7a, 0xef, 
  0xee, 0x7d, 0xc8, 0xde, 0xf1, 0xc9, 0x0a, 0x77, 0x4f, 0x72, 0x0e, 0xc5, 
  0xff, 0x60, 0x7b, 0xa2, 0xa3, 0x2f, 0x1a, 0x4a, 0xa6, 0xec, 0xce, 0x7e, 
  0xd4, 0x7d, 0x93, 0xfd, 0x42, 0x62, 0x40, 0xbc, 0xfd, 0x64, 0xb0, 0x13, 
  0x6d, 0x7e, 0x9f, 0x2e, 0x9e, 0x3f, 0xfb, 0x3c, 0x3a, 0xde, 0xea, 0x56, 
  0x02, 0xde, 0x04, 0xe4, 0x74, 0x14, 0x2f, 0x6e, 0xdc, 0x56, 0x9d, 0xe1, 
  0x38, 0x4b, 0x90, 0x85, 0x81, 0xfb, 0xbd, 0xc0, 0xde, 0xaf, 0x6d, 0x51, 
  0x4a, 0xcf, 0x49, 0xec, 0x5c, 0xf4, 0x9d, 0x43, 0xb6, 0x62, 0x8d, 0x9e, 
  0x9e, 0x9a, 0xf0, 0xd2, 0x3d, 0x7f, 0xd6, 0x68, 0xe2, 0xa9, 0x6b, 0xe3, 
  0xad, 0xb4, 0xf1, 0x2b, 0x9b, 0xd8, 0x1b, 0xec, 0xec, 0x45, 0x9b, 0x67, 
  0xc3, 0xed, 0x3d, 0xd7, 0x42, 0xb3, 0x89, 0x3d, 0x34, 0xc1, 0x0f, 0x55, 
  0x5f, 0x7e, 0xca, 0xfd, 0xff, 0x94, 0x2c, 0x7e, 0x8e, 0x36, 0x7f, 0xd8, 
  0xdd, 0xa5, 0x06, 0x3e, 0x8f, 0xf6, 0x8f, 0x7f, 0x88, 0x9e, 0x0e, 0xa8, 
  0xb1, 0xd3, 0xf8, 0x56, 0x9b, 0x53, 0xf0, 0x8d, 0x21, 0x1a, 0xa1, 0xef, 
  0x1b, 0x6d, 0x3c, 0xab, 0xb5, 0x71, 0x42, 0x5a, 0xe0, 0x3d, 0xdd, 0x26, 
  0x3b, 0x83, 0x27, 0x7b, 0x51, 0xfa, 0xec, 0xb3, 0x4f, 0xad, 0x21, 0x6d, 
  0x03, 0xdf, 0x57, 0x2d, 0x93, 0x92, 0xec, 0x42, 0x42, 0xce, 0xd1, 0x3d, 
  0x71, 0x31, 0xb0, 0x06, 0xc0, 0x21, 0x5e, 0xc7, 0x52, 0xff, 0x77, 0x24, 
  0x80, 0xe6, 0xb4, 0x53, 0x62, 0xbd, 0x66, 0x37, 0x04, 0x92, 0x87, 0x1e, 
  0x5e, 0x34, 0x86, 0xc3, 0x9a, 0xa8, 0x3d, 0xfa, 0x79, 0xf4, 0x66, 0x78, 
  0x7c, 0x44, 0x33, 0xda, 0xa1, 0xa1, 0xf9, 0x35, 0x94, 0x01, 0xe1, 0x2b, 
  0x2c, 0x2e, 0xad, 0x2a, 0x35, 0xa3, 0x6d, 0x98, 0x84, 0x2d, 0xb1, 0x47, 
  0x8c, 0x00, 0x97, 0x15, 0x05, 0xfa, 0xe5, 0x6c, 0xd2, 0xfe, 0xfe, 0x15, 
  0x2b, 0x0c, 0x7a, 0xc9, 0x72, 0xd7, 0xdf, 0x66, 0x0b, 0x3a, 0x26, 0x79, 
  0x96, 0x6f, 0xef, 0x0e, 0x76, 0xba, 0x15, 0x39, 0xe1, 0xdb, 0xc3, 0xa3, 
  0xe8, 0x35, 0x8b, 0x15, 0x6f, 0xe2, 0x05, 0xf1, 0x46, 0xce, 0x1f, 0x2d, 
  0x6e, 0xd8, 0xdf, 0x2e, 0xbe, 0x1b, 0x79, 0xff, 0xe4, 0x61, 0x71, 0x4f, 
  0xfb, 0xf8, 0xd7, 0xc1, 0x2e, 0x27, 0x45, 0xb1, 0x8e, 0xfb, 0xfa, 0x0d, 
  0xfd, 0xbd, 0xfb, 0xb4, 0x1b, 0xf1, 0x57, 0x55, 0x7d, 0xdd, 0xce, 0xeb, 
  0xc6, 0xc1, 0xd9, 0xd9, 0xb7, 0xc7, 0x12, 0x7a, 0x71, 0xa0, 0x26, 0x54, 
  0x16, 0xab, 0x9c, 0x0e, 0x2c, 0x5c, 0x95, 0x74, 0x35, 0x8e, 0x45, 0xb5, 
  0x93, 0x45, 0x2b, 0x79, 0x93, 0x24, 0x4b, 0x20, 0x01, 0xd5, 0x38, 0x42, 
  0xa9, 0xbc, 0x59, 0x46, 0xc6, 0x62, 0x74, 0x3a, 0xa9, 0xe6, 0xbe, 0x32, 
  0xe8, 0xb6, 0x33, 0xd7, 0x8e, 0x1e, 0x5c, 0x06, 0x47, 0xec, 0x0b, 0x0c, 
  0x61, 0x88, 0x2e, 0x47, 0xde, 0xcc, 0xcd, 0x52, 0xb6, 0x93, 0x5e, 0x54, 
  0x4d, 0xb7, 0x3b, 0x4c, 0xca, 0xbe, 0x0c, 0xfa, 0x85, 0x5a, 0x68, 0xbb, 
  0x6a, 0x6e, 0x72, 0xc6, 0xb2, 0xa5, 0x62, 0x4c, 0xc2, 0x4c, 0xfc, 0xb0, 
  0xe4, 0x3a, 0x48, 0x33, 0x57, 0x1c, 0x0e, 0x55, 0xb5, 0x12, 0x04, 0x88, 
  0x9d, 0xee, 0xbf, 0x39, 0x7a, 0xf5, 0xdd, 0xfe, 0xc9, 0xdb, 0x23, 0x7a, 
  0x85, 0x51, 0x16, 0x37, 0x3d, 0x2a, 0x0c, 0xc6, 0x38, 0x4f, 0xc7, 0xd9, 
  0x8c, 0x5d, 0x4a, 0xdd, 0xcf, 0xbb, 0xe0, 0x4c, 0x34, 0x80, 0x0e, 0xbf, 
  0xb5, 0x2b, 0xaf, 0x11, 0x5d, 0xf0, 0x5f, 0x7b, 0xf2, 0xd7, 0xde, 0xe7, 
  0x9d, 0xad, 0xca, 0xa4, 0x1b, 0x3a, 0x31, 0xd3, 0xcb, 0x9d, 0x44, 0x80, 
  0x71, 0x80, 0x9e, 0x60, 0xa9, 0xc9, 0xaa, 0x74, 0xcc, 0x1f, 0x63, 0x77, 
  0x1a, 0x3f, 0xbb, 0x39, 0x7a, 0x08, 0x35, 0xee, 0x0e, 0xbf, 0xf4, 0x0a, 
  0x52, 0x45, 0x87, 0xa3, 0xfd, 0x55, 0xce, 0x80, 0xaf, 0x9a, 0xdb, 0xb0, 
  0x26, 0x92, 0xfb, 0x25, 0x47, 0x0b, 0x6d, 0x76, 0xe4, 0x97, 0x57, 0x87, 
  0xfb, 0x97, 0x47, 0xfc, 0x82, 0x75, 0x6f, 0x85, 0x09, 0x0d, 0x48, 0x87, 
  0xc7, 0xb3, 0xd9, 0x91, 0x0f, 0x5f, 0xf1, 0x84, 0x3a, 0x5b, 0xe2, 0xb7, 
  0x80, 0x57, 0xbb, 0x36, 0xae, 0x6c, 0xa1, 0xe1, 0x76, 0x96, 0xf1, 0x08, 
  0x9f, 0x9b, 0x46, 0x88, 0x6c, 0x76, 0xe4, 0xbb, 0x8e, 0xb3, 0xd6, 0x6a, 
  0xfd, 0x2d, 0x57, 0xe6, 0x38, 0x6e, 0x0b, 0x8c, 0x97, 0x4a, 0x05, 0x7e, 
  0x7f, 0xd4, 0x31, 0x21, 0xf6, 0xa5, 0x00, 0x08, 0xc8, 0x6d, 0x7c, 0x21, 
  0xa0, 0xa1, 0x6c, 0x51, 0xca, 0xb2, 0xdd, 0xbd, 0x27, 0x9f, 0x63, 0x3d, 
  0x5f, 0x75, 0xb6, 0xe9, 0x6e, 0xe8, 0x7c, 0xce, 0x5d, 0xa7, 0x66, 0xcf, 
  0x0c, 0xe2, 0xfe, 0x58, 0x93, 0x52, 0x8a, 0x92, 0xf0, 0x14, 0xde, 0x75, 
  0x58, 0xc2, 0x64, 0x5e, 0x58, 0xd0, 0x3b, 0x89, 0xa4, 0xb6, 0xc4, 0x28, 
  0xf3, 0xde, 0x63, 0xbf, 0x50, 0x9c, 0x67, 0xe1, 0x20, 0x06, 0xa5, 0xbb, 
  0xf0, 0xfe, 0xe8, 0x29, 0x6a, 0x1e, 0xe6, 0xa8, 0xb5, 0xbf, 0xb8, 0xcf, 
  0xf9, 0x83, 0x05, 0x5b, 0x17, 0x85, 0x29, 0xb4, 0xb2, 0x67, 0x0d, 0xe3, 
  0xc0, 0x48, 0x2d, 0x39, 0xa6, 0x86, 0x40, 0x16, 0x20, 0xd6, 0xf2, 0x00, 
  0x01, 0x49, 0xdc, 0xfd, 0x41, 0x94, 0x83, 0xdd, 0xd9, 0xf1, 0x88, 0x73, 
  0x44, 0x0c, 0xc4, 0x3e, 0xd4, 0xc1, 0xdd, 0xd2, 0xdb, 0xf1, 0x4b, 0x83, 
  0x94, 0x37, 0xbe, 0x28, 0x65, 0x2d, 0x0b, 0x67, 0x31, 0x82, 0x67, 0x51, 
  0x9f, 0xad, 0xee, 0x53, 0x2d, 0x66, 0x1b, 0xd3, 0x10, 0x05, 0x5e, 0x34, 
  0x63, 0x62, 0x35, 0x0b, 0x98, 0x4a, 0xd7, 0x47, 0x38, 0xb4, 0x38, 0x9e, 
  0x30, 0x45, 0xd5, 0xfb, 0x6c, 0x82, 0x83, 0xc1, 0xc0, 0xe3, 0xc1, 0x5f, 
  0xa3, 0x0e, 0x36, 0x86, 0x01, 0x1c, 0xb1, 0x0a, 0xf8, 0x45, 0x2c, 0x15, 
  0xa2, 0x14, 0xb2, 0x60, 0x4b, 0x03, 0x5f, 0xd4, 0x16, 0xe1, 0x8e, 0x46, 
  0x60, 0xd1, 0xe8, 0x6a, 0xb7, 0xdd, 0xf5, 0xd1, 0xbd, 0xb4, 0x09, 0x8f, 
  0x8c, 0x4d, 0x2c, 0x8d, 0x45, 0x8c, 0x8c, 0x32, 0xc7, 0xa7, 0x32, 0xb7, 
  0x16, 0x4c, 0xc1, 0x9c, 0x65, 0x26, 0xf5, 0xb5, 0xb0, 0x25, 0xb2, 0x68, 
  0x3a, 0x94, 0x9e, 0x04, 0x1a, 0x30, 0x93, 0xcb, 0xee, 0x90, 0xc3, 0x24, 
  0x45, 0x5e, 0x97, 0x39, 0xeb, 0x78, 0x28, 0xda, 0xa4, 0x37, 0x88, 0x83, 
  0x0f, 0xb5, 0x76, 0x26, 0x62, 0x98, 0x65, 0x6d, 0x19, 0x02, 0xbf, 0x66, 
  0x02, 0x28, 0xfc, 0x6a, 0x11, 0x2b, 0xf0, 0x08, 0x83, 0xd6, 0xcc, 0xe1, 
  0xe2, 0xd2, 0xc9, 0x7b, 0x23, 0x09, 0x47, 0x77, 0xf5, 0x25, 0x3d, 0xd1, 
  0x82, 0xf5, 0x8d, 0x7b, 0x68, 0xa1, 0xc7, 0xc7, 0x9c, 0xe3, 0x63, 0x6b, 
  0xd1, 0x79, 0xc6, 0x6b, 0x6b, 0xe3, 0x6f, 0xe5, 0x2a, 0xeb, 0xa2, 0x15, 
  0x15, 0x5b, 0x32, 0x24, 0xe4, 0x80, 0xef, 0x45, 0xf1, 0x1d, 0x97, 0x25, 
  0x20, 0x1a, 0x14, 0x27, 0x99, 0xd8, 0x63, 0x4e, 0x02, 0xab, 0xa2, 0x9b, 
  0xa1, 0x95, 0xed, 0x93, 0xf0, 0x22, 0xa9, 0xcc, 0xa7, 0xc0, 0x7d, 0xd9, 
  0x94, 0x6d, 0x20, 0x66, 0xbe, 0x4b, 0x01, 0xa2, 0xcf, 0x48, 0x24, 0x2a, 
  0xa1, 0x9b, 0x62, 0xce, 0x23, 0x27, 0x16, 0x3d, 0x54, 0xba, 0x49, 0x11, 
  0x07, 0xc8, 0x16, 0x0e, 0x09, 0xa2, 0xb0, 0xd5, 0x92, 0x9a, 0x8d, 0xd6, 
  0x49, 0x2f, 0x88, 0x0b, 0x67, 0xb2, 0xe2, 0x42, 0x92, 0x8b, 0xbe, 0xcb, 
  0x4b, 0x73, 0xb1, 0x57, 0x79, 0x7a, 0x75, 0x25, 0xaa, 0x5a, 0x54, 0x9f, 
  0x5a, 0x3b, 0x91, 0x9d, 0xf0, 0xaa, 0x24, 0xf3, 0x65, 0xf9, 0xb0, 0x6e, 
  0x35, 0x2f, 0x1d, 0x5c, 0xa6, 0xda, 0x5b, 0x2a, 0xc4, 0x6c, 0xfe, 0x47, 
  0x87, 0x47, 0x65, 0x09, 0x46, 0xa8, 0x7e, 0x5a, 0xf1, 0x17, 0x9f, 0x5d, 
  0x30, 0x13, 0x2b, 0xc2, 0x7c, 0x2a, 0xdb, 0x74, 0x24, 0x7a, 0xfb, 0x70, 
  0x93, 0x09, 0x5b, 0x95, 0xe7, 0x7c, 0x15, 0xdf, 0xb9, 0x58, 0x27, 0x41, 
  0x43, 0x1c, 0xc5, 0x5e, 0xd5, 0xda, 0x88, 0x2a, 0xb6, 0x5d, 0x2e, 0x31, 
  0x75, 0xbc, 0x50, 0x3e, 0x94, 0xdd, 0x26, 0x1e, 0xfa, 0xc0, 0x9b, 0x17, 
  0x3d, 0xd2, 0x8f, 0x9e, 0x7e, 0xc7, 0x4c, 0x6a, 0xce, 0x5c, 0xc7, 0xaf, 
  0x30, 0xc9, 0xda, 0xaa, 0x0c, 0xa2, 0xa0, 0xc9, 0x10, 0x7a, 0xd5, 0xdd, 
  0x24, 0x09, 0xbc, 0x7b, 0xf0, 0x51, 0x5b, 0x8b, 0x1a, 0x75, 0x0e, 0xfc, 
  0xec, 0x40, 0x35, 0xe1, 0x05, 0x49, 0x4b, 0xa5, 0xaa, 0xc2, 0xc5, 0xc8, 
  0x79, 0x5f, 0xaf, 0xcd, 0xb2, 0xe3, 0x36, 0xa9, 0x83, 0x54, 0x88, 0x91, 
  0x12, 0x01, 0x68, 0x00, 0x09, 0x53, 0xe6, 0xae, 0xdf, 0x9f, 0xc5, 0x1c, 
  0xb1, 0x92, 0x49, 0x24, 0x00, 0xb6, 0x0c, 0x44, 0x0d, 0x33, 0x5a, 0x8d, 
  0xa7, 0x36, 0x8e, 0x9f, 0x8b, 0xcc, 0x10, 0x5a, 0x63, 0x21, 0x05, 0xcd, 
  0x10, 0x95, 0x70, 0x23, 0xfd, 0xb1, 0x31, 0x77, 0x17, 0xf7, 0xd0, 0x9a, 
  0x71, 0x34, 0xaa, 0x9c, 0xd1, 0xf7, 0x1d, 0xd9, 0xf3, 0x8b, 0xb3, 0xaf, 
  0x2f, 0x8e, 0x86, 0xc3, 0xe8, 0xcd, 0xd1, 0xa5, 0xe8, 0xfa, 0x97, 0x12, 
  0x06, 0x27, 0x18, 0x8c, 0x70, 0x32, 0x18, 0x1e, 0x9d, 0x45, 0x9a, 0x98, 
  0x21, 0x01, 0x30, 0x78, 0x19, 0x3b, 0xd0, 0x20, 0xca, 0x41, 0x8f, 0x9f, 
  0x69, 0xf4, 0xdc, 0x35, 0xcc, 0xfc, 0x88, 0x65, 0x82, 0x1f, 0xd2, 0x59, 
  0xcd, 0xbd, 0x2d, 0x35, 0xa8, 0x31, 0x7b, 0x6d, 0x9c, 0xcb, 0xdb, 0xce, 
  0xb5, 0x90, 0x27, 0xa6, 0xf7, 0x49, 0x74, 0x69, 0x85, 0x20, 0x3f, 0x89, 
  0x2e, 0x8c, 0x3e, 0x3e, 0x89, 0x7e, 0xa0, 0x36, 0x27, 0x5c, 0x87, 0x54, 
  0xaa, 0x1f, 0x0d, 0x51, 0xf6, 0xc8, 0x17, 0x26, 0x40, 0x4d, 0xae, 0xe0, 
  0x3f, 0xa2, 0xf2, 0xfc, 0x3d, 0xa5, 0xf5, 0x90, 0x2a, 0x2a, 0x10, 0x0c, 
  0x1a, 0x4b, 0xe7, 0x7a, 0x3e, 0xd0, 0x8a, 0xc9, 0xd1, 0x49, 0x32, 0x2d, 
  0x21, 0x90, 0x70, 0x77, 0xd4, 0xdc, 0x0e, 0x63, 0x43, 0xed, 0x72, 0x45, 
  0x72, 0xfa, 0xf5, 0xc9, 0x67, 0x9f, 0xee, 0x7c, 0x26, 0xbf, 0xda, 0xbf, 
  0xcf, 0x9f, 0xee, 0x28, 0xf0, 0x1a, 0xfd, 0xf5, 0xf4, 0xc5, 0xd3, 0xdd, 
  0x17, 0x9c, 0xf0, 0xbf, 0xf3, 0x62, 0x87, 0xfe, 0xff, 0xa9, 0x7e, 0xc2, 
  0xb8, 0x08, 0xcf, 0xf7, 0x3e, 0xfb, 0x2b, 0x82, 0x60, 0x98, 0x3e, 0x66, 
  0xd4, 0x49, 0xbf, 0xcc, 0xfa, 0x39, 0x97, 0x54, 0x81, 0x10, 0xf4, 0x49, 
  0xd5, 0x1c, 0xc9, 0x5e, 0x75, 0x2e, 0x63, 0xc4, 0x13, 0xf7, 0xe5, 0x94, 
  0xd5, 0xb4, 0x2a, 0x19, 0xac, 0x61, 0xb1, 0x36, 0x37, 0x0d, 0x7d, 0x5b, 
  0x0a, 0x66, 0x21, 0x93, 0xb7, 0xf2, 0x0e, 0x89, 0x8c, 0x74, 0xb5, 0x06, 
  0x29, 0xc3, 0xbf, 0xb6, 0x6b, 0xcb, 0xbb, 0xda, 0x00, 0x42, 0x8d, 0x6e, 
  0x95, 0xbe, 0xa7, 0x45, 0xa7, 0x89, 0x46, 0x82, 0x22, 0x60, 0xb5, 0xa2, 
  0x5d, 0xbf, 0xb6, 0x3f, 0xb1, 0x5c, 0xf1, 0x5b, 0x4a, 0x0d, 0x51, 0xb3, 
  0x37, 0xab, 0x5d, 0xd6, 0xd6, 0x57, 0x85, 0x78, 0x36, 0xfc, 0xf6, 0xfb, 
  0x95, 0x0a, 0xea, 0x6b, 0xb9, 0x3c, 0x6a, 0xa9, 0xb0, 0xd5, 0x32, 0xe5, 
  0x46, 0x73, 0x6f, 0x97, 0x61, 0x7b, 0x1f, 0xd2, 0x9c, 0x9f, 0x11, 0x28, 
  0xd8, 0xed, 0x5c, 0x3f, 0xd8, 0x9c, 0x54, 0x02, 0xda, 0x5c, 0xa1, 0x2e, 
  0x43, 0x9a, 0xb0, 0x1b, 0x4f, 0x5e, 0x75, 0x24, 0xdb, 0x97, 0x37, 0x54, 
  0xfc, 0x2c, 0x90, 0xc3, 0x22, 0x82, 0xc2, 0x6d, 0x86, 0xdb, 0x5e, 0x9e, 
  0x37, 0xca, 0x6e, 0x74, 0xc5, 0xd4, 0x18, 0xf4, 0xa7, 0x7d, 0xe0, 0x3c, 
  0xb9, 0x43, 0xf7, 0xe8, 0xd4, 0x7c, 0x58, 0xbb, 0xab, 0x4e, 0xb1, 0xe9, 
  0xc2, 0xc4, 0xdb, 0x8e, 0xa4, 0x7f, 0x0e, 0x91, 0xe3, 0x61, 0xc1, 0x4c, 
  0x77, 0x11, 0xa1, 0x34, 0x89, 0x42, 0x54, 0x32, 0xf2, 0x04, 0xc3, 0x01, 
  0x6e, 0x19, 0x0b, 0xeb, 0xff, 0xd1, 0x45, 0x6b, 0xe1, 0x5e, 0xb3, 0x0a, 
  0xe4, 0x42, 0xf9, 0xb3, 0x30, 0x01, 0xaa, 0x82, 0x86, 0x5b, 0x8a, 0x82, 
  0x84, 0x4c, 0xb4, 0x0d, 0xa9, 0xe2, 0x47, 0x37, 0x2d, 0xdd, 0x1c, 0x41, 
  0x51, 0x9b, 0x3f, 0x6c, 0x6c, 0x0c, 0xcf, 0x8f, 0x8e, 0x0e, 0xa3, 0x93, 
  0xe3, 0x37, 0xc7, 0x97, 0x81, 0x40, 0xee, 0x2e, 0x12, 0xb3, 0xb4, 0x16, 
  0x1a, 0xbe, 0x56, 0x5b, 0x0e, 0x8f, 0x71, 0xa4, 0xc5, 0xcb, 0xf5, 0x2a, 
  0x9f, 0x27, 0x9a, 0xc0, 0x30, 0xab, 0xbf, 0x07, 0xd5, 0x1b, 0x29, 0xda, 
  0x83, 0xe8, 0xab, 0x20, 0x20, 0x32, 0x2a, 0x48, 0xb8, 0x19, 0x73, 0x61, 
  0x16, 0xb9, 0x24, 0x7e, 0xd4, 0xf0, 0x8c, 0xaa, 0xe4, 0xa4, 0x70, 0x24, 
  0xae, 0x22, 0x8b, 0xc6, 0xb4, 0xd6, 0x46, 0xc5, 0x6b, 0x9b, 0x48, 0x98, 
  0x73, 0x60, 0xa1, 0x43, 0xb4, 0xde, 0x5d, 0x82, 0xe4, 0xc0, 0x79, 0x2a, 
  0x19, 0x3d, 0x61, 0x2c, 0xb1, 0xab, 0x82, 0x70, 0x99, 0x09, 0x1f, 0x0f, 
  0x7b, 0x0c, 0x0b, 0xd4, 0x58, 0x20, 0xad, 0xf5, 0x15, 0x96, 0x3e, 0x79, 
  0xb2, 0xe3, 0x32, 0x05, 0x96, 0xe0, 0x39, 0x2a, 0xea, 0x73, 0x67, 0xbb, 
  0x11, 0xc9, 0x23, 0x2b, 0x96, 0xea, 0xf3, 0xd5, 0xa2, 0x71, 0xdd, 0xfd, 
  0x28, 0xef, 0xd2, 0xfc, 0x3f, 0xdd, 0xc1, 0xf5, 0x36, 0x8d, 0xf3, 0x3e, 
  0x49, 0x5e, 0x0f, 0x7d, 0xb3, 0xaa, 0x0a, 0x45, 0x68, 0x9c, 0xb1, 0x98, 
  0x7e, 0x92, 0x4a, 0x61, 0xa4, 0x50, 0x5a, 0xf4, 0xe9, 0x1e, 0x19, 0x1c, 
  0x92, 0x33, 0x3d, 0x00, 0x3c, 0xf5, 0x5e, 0x84, 0x5a, 0x90, 0x2e, 0xf2, 
  0x59, 0x64, 0x1d, 0x0f, 0x76, 0x63, 0xbb, 0xe8, 0x79, 0x14, 0x27, 0x03, 
  0x80, 0xad, 0x72, 0xab, 0x29, 0x4f, 0x53, 0xe7, 0xd2, 0x14, 0xad, 0xe7, 
  0xd1, 0xee, 0x67, 0x3c, 0x8f, 0x0f, 0x9b, 0x0f, 0x83, 0xe2, 0x5b, 0x0c, 
  0x9b, 0xa8, 0x0b, 0x99, 0xdf, 0x4d, 0xc9, 0x50, 0x00, 0xcc, 0xac, 0xac, 
  0xae, 0x05, 0xc3, 0x22, 0x56, 0x8f, 0xf5, 0x13, 0x75, 0xa4, 0xc3, 0x32, 
  0x05, 0xcf, 0xb6, 0x48, 0x48, 0x28, 0xdf, 0x25, 0xeb, 0xc2, 0xb6, 0x56, 
  0x89, 0xd5, 0xeb, 0xe6, 0x3e, 0x41, 0x0b, 0xcb, 0x00, 0xa8, 0xbb, 0xc5, 
  0xe4, 0x2e, 0x9d, 0x40, 0xaa, 0x36, 0x23, 0x00, 0xe8, 0x4f, 0x88, 0x4f, 
  0x62, 0xa4, 0xe1, 0xb8, 0x84, 0xc7, 0xd3, 0x8d, 0x4c, 0x05, 0x18, 0x5e, 
  0xd6, 0x0c, 0xc6, 0x85, 0x4d, 0xc8, 0x0f, 0x5c, 0xd1, 0xa1, 0xea, 0x13, 
  0x60, 0xd6, 0xdc, 0xf1, 0xbd, 0x70, 0xdc, 0x7e, 0x59, 0xce, 0xcc, 0xae, 
  0xe0, 0xa1, 0xae, 0xab, 0x73, 0xe6, 0xc4, 0xe6, 0x60, 0xda, 0xbb, 0x3b, 
  0x24, 0xbf, 0xce, 0xb2, 0x7a, 0x81, 0xa5, 0xa6, 0x52, 0x8a, 0x69, 0xf5, 
  0xb1, 0x3a, 0xbb, 0x3b, 0xdf, 0xae, 0x5f, 0x75, 0x80, 0xc9, 0x3d, 0xfa, 
  0xf2, 0xde, 0xd3, 0x47, 0x36, 0xed, 0x2c, 0x77, 0x15, 0x33, 0x7c, 0x1a, 
  0xbc, 0xf7, 0xbc, 0x34, 0xb6, 0x8d, 0x08, 0x3f, 0xb9, 0x8a, 0x51, 0xed, 
  0xf4, 0x91, 0xd1, 0x5b, 0xa6, 0x46, 0x6d, 0x28, 0x6f, 0x34, 0x1a, 0x5b, 
  0xbe, 0x2c, 0xd8, 0x42, 0xb6, 0x04, 0xcc, 0x86, 0x57, 0x63, 0x83, 0x92, 
  0xef, 0x49, 0xf5, 0x6d, 0xe1, 0x9c, 0xbd, 0x2a, 0x93, 0x30, 0xea, 0xc9, 
  0x93, 0x2b, 0xb8, 0xd2, 0xc1, 0x83, 0x59, 0xed, 0x67, 0x84, 0x23, 0x3d, 
  0xaf, 0xc4, 0x9b, 0x39, 0x6e, 0x48, 0xe8, 0x09, 0x8c, 0x77, 0x1c, 0x9b, 
  0xc8, 0xaa, 0xd5, 0xbb, 0x6b, 0x17, 0x03, 0xdb, 0x67, 0xc7, 0x19, 0x4a, 
  0xf4, 0xde, 0x99, 0x2f, 0x21, 0xac, 0xdc, 0x22, 0x55, 0x4d, 0x06, 0x48, 
  0x88, 0x13, 0x42, 0x71, 0xcc, 0x9e, 0x33, 0xba, 0xd8, 0x1b, 0x56, 0x8a, 
  0x87, 0x00, 0x0d, 0xf4, 0x94, 0x6a, 0xd1, 0x92, 0xeb, 0x8a, 0x39, 0x7e, 
  0x61, 0xc9, 0x92, 0x02, 0x4a, 0xc7, 0x76, 0xff, 0x83, 0xb3, 0xd3, 0xd7, 
  0xc7, 0x5f, 0xbb, 0x24, 0x7f, 0x61, 0xe2, 0xab, 0x32, 0x63, 0xbb, 0xa6, 
  0x18, 0x0d, 0xc5, 0x92, 0x1c, 0xba, 0xbb, 0x15, 0x80, 0x5c, 0x83, 0x6e, 
  0x89, 0x3d, 0xbd, 0x0b, 0x3f, 0x00, 0x03, 0x59, 0x3c, 0x61, 0x5b, 0xb9, 
  0xe0, 0x0f, 0x16, 0x5b, 0xde, 0xf2, 0x50, 0x03, 0x9d, 0x90, 0xec, 0x8c, 
  0x38, 0x2f, 0x57, 0x4b, 0x17, 0x3b, 0x18, 0x00, 0x98, 0x2b, 0x96, 0x12, 
  0xdf, 0x0a, 0x5c, 0xbb, 0x72, 0xb5, 0x14, 0xd6, 0x24, 0x31, 0x8f, 0x55, 
  0xc3, 0xae, 0xdc, 0x01, 0x6c, 0x59, 0xd0, 0x8c, 0x6d, 0xbd, 0x00, 0x1a, 
  0x01, 0x39, 0xb3, 0x8c, 0xfd, 0xfe, 0x41, 0x9c, 0xbc, 0xb9, 0x72, 0xb8, 
  0xec, 0x8e, 0x4c, 0xd4, 0x8a, 0xee, 0xcc, 0x45, 0x33, 0xe3, 0x79, 0x4b, 
  0x11, 0xbf, 0x1f, 0x5d, 0x39, 0x43, 0x0d, 0xfa, 0xf5, 0xae, 0xa2, 0x22, 
  0xb2, 0x6c, 0x07, 0x17, 0x98, 0x24, 0x83, 0x45, 0x00, 0x61, 0xd1, 0x13, 
  0x5f, 0x27, 0x3e, 0x79, 0xc5, 0x1e, 0x9a, 0x17, 0x0c, 0x6c, 0x36, 0x17, 
  0xf0, 0x86, 0xb0, 0xa6, 0x8c, 0x72, 0x49, 0x0f, 0x40, 0x76, 0x3c, 0x0d, 
  0x92, 0xc9, 0x24, 0x40, 0xd0, 0x88, 0x4e, 0xcc, 0xc5, 0x6c, 0x6b, 0xe9, 
  0xfe, 0xb1, 0xdb, 0xd7, 0xef, 0x34, 0xe1, 0xc2, 0xa5, 0xff, 0xda, 0x43, 
  0xa5, 0x54, 0x96, 0x10, 0xf0, 0x7b, 0xf1, 0xd4, 0x96, 0x81, 0x85, 0xd2, 
  0x07, 0x49, 0xf9, 0xf1, 0x0b, 0x9e, 0x31, 0x3c, 0x45, 0x36, 0x0b, 0xa4, 
  0xc2, 0x33, 0x8f, 0x67, 0xb7, 0x58, 0xa6, 0x54, 0xcd, 0x79, 0x98, 0x58, 
  0xa9, 0xea, 0xd4, 0xd9, 0xe9, 0x97, 0xad, 0xd8, 0xd8, 0x01, 0x84, 0x4f, 
  0x12, 0x77, 0xd8, 0x38, 0xfc, 0xbd, 0x4d, 0x90, 0xdf, 0x96, 0x2f, 0x34, 
  0x18, 0xdf, 0x12, 0xea, 0xa9, 0x21, 0x81, 0x04, 0xa5, 0xa1, 0xfe, 0x5d, 
  0x6c, 0x8b, 0xe2, 0xfa, 0xfb, 0xd1, 0x3a, 0xb7, 0x47, 0x6b, 0x4b, 0x4f, 
  0xf4, 0x14, 0xe7, 0x57, 0x8a, 0x88, 0xa1, 0x4e, 0x35, 0x28, 0x89, 0x0e, 
  0xf5, 0xd5, 0xd9, 0x28, 0x59, 0x28, 0x71, 0xc1, 0x32, 0x10, 0x9f, 0x56, 
  0x92, 0xce, 0xa7, 0xd9, 0x4f, 0x62, 0x9d, 0x74, 0x84, 0x18, 0x70, 0x9c, 
  0x3f, 0xba, 0x80, 0x94, 0xd8, 0xdf, 0x65, 0x86, 0x03, 0xe9, 0x4d, 0xb5, 
  0x7a, 0x99, 0x05, 0xaf, 0xb1, 0x3d, 0x0f, 0x9a, 0x70, 0xa2, 0x36, 0x14, 
  0xe9, 0xca, 0x8a, 0x7b, 0x0b, 0x84, 0x6b, 0x52, 0xf8, 0x26, 0xe4, 0xfb, 
  0x57, 0x9a, 0x0c, 0x4d, 0xe7, 0x59, 0xd3, 0xdb, 0x15, 0xaa, 0xe3, 0xb3, 
  0x1d, 0xb5, 0xc4, 0x95, 0x1a, 0xa5, 0x5a, 0x44, 0xfb, 0x17, 0x47, 0xc0, 
  0x0a, 0x43, 0xfa, 0x32, 0x8f, 0xb0, 0xd4, 0xfd, 0x81, 0x60, 0xcd, 0xab, 
  0xa0, 0xe7, 0x83, 0x3b, 0xbc, 0x0b, 0xde, 0x64, 0x62, 0xd2, 0xc0, 0x00, 
  0x3a, 0x64, 0x2e, 0xfc, 0x8c, 0x49, 0x6e, 0x7c, 0x1d, 0x73, 0x5e, 0x0c, 
  0x1c, 0x8b, 0xd3, 0x88, 0x93, 0x89, 0x85, 0xa4, 0x80, 0x14, 0x75, 0xb5, 
  0xc8, 0x0c, 0x67, 0xec, 0xbc, 0xc1, 0xd6, 0x0d, 0x88, 0x33, 0x0c, 0x4c, 
  0xc2, 0xa9, 0xf6, 0x19, 0x08, 0xff, 0x34, 0x84, 0x1d, 0xed, 0xab, 0xe2, 
  0x01, 0xf5, 0xe4, 0xd4, 0x6b, 0xb7, 0x1e, 0xfd, 0x13, 0xf7, 0x0c, 0xcb, 
  0x22, 0x75, 0xb9, 0x20, 0x71, 0x81, 0xf5, 0x62, 0xc8, 0x9e, 0x04, 0xc2, 
  0xaf, 0x24, 0xe6, 0x71, 0x68, 0xb5, 0xd8, 0xa8, 0x59, 0xf8, 0x89, 0x8b, 
  0xc4, 0x0a, 0x5e, 0x40, 0x1d, 0x98, 0xe8, 0x59, 0x65, 0xaa, 0xe0, 0x28, 
  0x61, 0x1a, 0xf1, 0x5c, 0x00, 0x0c, 0x2b, 0x64, 0xd1, 0x6e, 0xe6, 0xfd, 
  0xa3, 0x9b, 0xad, 0x1f, 0x83, 0xfb, 0x92, 0x3f, 0x7a, 0x15, 0x75, 0xd4, 
  0x7f, 0xca, 0xa3, 0x18, 0x70, 0x47, 0x60, 0xa9, 0x70, 0x9f, 0xf2, 0x2f, 
  0xf8, 0x18, 0xe1, 0x6e, 0x86, 0x5b, 0x34, 0x8e, 0x17, 0x01, 0xe2, 0x44, 
  0xa6, 0xee, 0x55, 0x3f, 0x10, 0xf1, 0xf1, 0x81, 0x43, 0x8f, 0x42, 0xd1, 
  0xb8, 0xff, 0xed, 0x36, 0xea, 0x02, 0xd2, 0x83, 0x6c, 0xca, 0xe1, 0xdc, 
  0x5d, 0x3b, 0xf0, 0x45, 0x52, 0x29, 0x16, 0xe1, 0x32, 0x84, 0x3a, 0xfd, 
  0x0e, 0xad, 0x45, 0x17, 0xf5, 0xe6, 0x95, 0xe1, 0xdb, 0x63, 0xbc, 0xab, 
  0x48, 0xa6, 0xf3, 0x02, 0x93, 0xf2, 0x2e, 0xc6, 0x78, 0x7c, 0xa8, 0x64, 
  0x36, 0x30, 0x02, 0x3a, 0x27, 0xfe, 0x38, 0x1c, 0x0c, 0x64, 0x87, 0x20, 
  0x4e, 0xe0, 0x36, 0x2d, 0xcc, 0x0f, 0x49, 0xb4, 0x3d, 0xd6, 0xa0, 0x08, 
  0x49, 0xa1, 0x4e, 0xca, 0x71, 0xb0, 0x94, 0xc9, 0xf8, 0x3a, 0x93, 0x60, 
  0x5a, 0x5a, 0xb4, 0x20, 0xff, 0xb2, 0x13, 0xfd, 0x97, 0xd2, 0xc0, 0xb7, 
  0x3e, 0x59, 0x8f, 0x09, 0x61, 0x40, 0x97, 0x70, 0xce, 0xd0, 0x51, 0x8e, 
  0x20, 0x8e, 0x7e, 0xb8, 0xbc, 0xd8, 0x8f, 0xbe, 0x39, 0xda, 0x3f, 0x3c, 
  0xba, 0x18, 0xd6, 0x2e, 0x7d, 0x0d, 0xff, 0x10, 0x09, 0x8d, 0xed, 0xc1, 
  0x10, 0x8d, 0x2d, 0xc5, 0x5c, 0xc3, 0xf5, 0x8d, 0xeb, 0x11, 0xf1, 0xf0, 
  0x41, 0xa2, 0xf3, 0xc1, 0x0a, 0x91, 0x38, 0x0e, 0x4a, 0x49, 0xf7, 0x67, 
  0x66, 0xe3, 0xda, 0xd0, 0x52, 0x9e, 0xce, 0x7a, 0x1e, 0x26, 0xca, 0x78, 
  0x68, 0x1b, 0x7f, 0x99, 0x4c, 0x32, 0x4b, 0x02, 0xac, 0xee, 0xdc, 0x37, 
  0x3e, 0xd5, 0x3a, 0x60, 0x5b, 0x7a, 0xc9, 0xa8, 0x01, 0xb1, 0xf3, 0x43, 
  0x9f, 0xfa, 0xed, 0xd3, 0xe2, 0xf7, 0xe7, 0xc9, 0x8b, 0xe8, 0x21, 0x29, 
  0x3a, 0x35, 0x6b, 0x60, 0xb5, 0xfb, 0x0d, 0x29, 0x58, 0xd7, 0x38, 0x49, 
  0xdf, 0xb4, 0xb6, 0xc4, 0xa7, 0x6b, 0xc6, 0x08, 0xc6, 0x75, 0x0d, 0x02, 
  0x97, 0x6a, 0x20, 0x24, 0xeb, 0x09, 0x6a, 0x64, 0xb5, 0x68, 0x80, 0x92, 
  0x57, 0x33, 0x35, 0x28, 0x0c, 0x03, 0xd1, 0x29, 0x40, 0xd6, 0x49, 0x4b, 
  0xbd, 0xd4, 0x61, 0x17, 0x51, 0x18, 0x34, 0x1e, 0x96, 0x3e, 0x14, 0xde, 
  0x0f, 0xf0, 0x85, 0x68, 0x78, 0x7e, 0x51, 0x71, 0x95, 0xaa, 0x5d, 0x54, 
  0xf1, 0x17, 0xb5, 0x39, 0x1e, 0x83, 0xa3, 0x79, 0x8b, 0xea, 0xe7, 0x2e, 
  0x0d, 0xda, 0x4e, 0xdf, 0x95, 0x50, 0x30, 0x56, 0xea, 0x61, 0xea, 0xe4, 
  0x60, 0x33, 0xd9, 0x78, 0x93, 0x57, 0x83, 0x14, 0xa0, 0x90, 0x98, 0x81, 
  0x90, 0x8e, 0xb0, 0x71, 0xf7, 0x5c, 0x12, 0x7d, 0x93, 0x15, 0xb8, 0x0b, 
  0x9a, 0x8f, 0xf3, 0x25, 0xdf, 0xb6, 0xfc, 0x78, 0x43, 0x5d, 0x5d, 0x0e, 
  0x90, 0x09, 0xe8, 0x68, 0x60, 0x5f, 0xe7, 0xfb, 0x97, 0xdf, 0xc0, 0xd1, 
  0x0a, 0x12, 0x3e, 0xcc, 0x58, 0xe1, 0x31, 0xf7, 0x5a, 0x33, 0x13, 0xcb, 
  0x29, 0x70, 0x22, 0xff, 0xfa, 0xc2, 0x53, 0x22, 0x4f, 0xc2, 0x91, 0x07, 
  0x13, 0x65, 0x9e, 0x90, 0x14, 0x9b, 0xaa, 0xe1, 0xd1, 0x03, 0x69, 0xb9, 
  0x98, 0x77, 0x97, 0x66, 0xe7, 0x82, 0x2e, 0xbb, 0x92, 0x83, 0xde, 0x95, 
  0x39, 0x81, 0xe8, 0x59, 0x98, 0x63, 0x8d, 0x27, 0xc4, 0x10, 0xc3, 0x17, 
  0x96, 0x69, 0xde, 0xa3, 0x3d, 0x6d, 0x87, 0x09, 0x0a, 0x8e, 0xf4, 0x97, 
  0xf3, 0x87, 0x41, 0x13, 0xa6, 0x22, 0xfa, 0x6a, 0x55, 0x56, 0xd9, 0x4a, 
  0x0d, 0xc9, 0xcc, 0x49, 0x96, 0x79, 0x96, 0x95, 0x55, 0x2c, 0x30, 0xac, 
  0x8e, 0x9c, 0x68, 0xc1, 0x83, 0x92, 0xb1, 0x70, 0x53, 0x0b, 0x95, 0xbb, 
  0x43, 0xc1, 0x30, 0x1e, 0x15, 0xd9, 0x6c, 0x55, 0x06, 0x61, 0xd7, 0xbf, 
  0x6e, 0xcc, 0xc1, 0xa0, 0x37, 0x8f, 0x07, 0x89, 0x11, 0x14, 0xc7, 0x0d, 
  0xe7, 0x31, 0x69, 0xfa, 0x5c, 0xd5, 0x91, 0xfd, 0x8e, 0x79, 0xb6, 0xa8, 
  0x42, 0xbe, 0x23, 0xc2, 0x7b, 0xcb, 0xef, 0x35, 0xdd, 0x85, 0xc9, 0x1d, 
  0x4b, 0xeb, 0x26, 0x11, 0xbf, 0x96, 0xba, 0xd6, 0x52, 0x74, 0xda, 0xa1, 
  0x72, 0x00, 0xd7, 0x61, 0xea, 0x6c, 0x58, 0x5c, 0x98, 0x02, 0x6e, 0x7f, 
  0x95, 0xd6, 0x81, 0x63, 0x6b, 0xfe, 0x42, 0xc9, 0xe5, 0x56, 0xf8, 0x53, 
  0x06, 0x14, 0xcd, 0xe4, 0xa7, 0x25, 0xd6, 0x68, 0x40, 0x93, 0xee, 0xb5, 
  0xea, 0x0c, 0x8a, 0x5e, 0x9c, 0xcb, 0x5d, 0x6f, 0x21, 0x96, 0x12, 0x3c, 
  0x66, 0x5e, 0x38, 0x1b, 0xa2, 0xdd, 0x78, 0xec, 0xa4, 0x03, 0xe2, 0x91, 
  0x16, 0xa8, 0x72, 0x15, 0x05, 0x91, 0x98, 0xcc, 0xf5, 0x0b, 0x4c, 0x6a, 
  0xb7, 0xeb, 0xc3, 0x72, 0x15, 0x36, 0xa2, 0xa0, 0xb8, 0x8d, 0x0c, 0x5e, 
  0xef, 0x39, 0x24, 0x7f, 0xc3, 0x21, 0x75, 0x17, 0xa7, 0x65, 0x78, 0xfd, 
  0x99, 0xda, 0xed, 0x4b, 0x81, 0x8f, 0x1e, 0x2a, 0x71, 0x18, 0x3e, 0x3a, 
  0xf1, 0x8a, 0x53, 0x19, 0xd4, 0xfc, 0xa2, 0x90, 0x19, 0xb0, 0xf5, 0x5c, 
  0xa7, 0x1a, 0x43, 0x29, 0x6b, 0x6e, 0xb6, 0x2f, 0x56, 0xde, 0x61, 0xcb, 
  0xda, 0x88, 0x42, 0x57, 0xa2, 0xf3, 0xf6, 0x0f, 0x9a, 0xa4, 0x31, 0x70, 
  0x70, 0x5b, 0xca, 0x2e, 0x8f, 0xc3, 0xac, 0x69, 0xac, 0x8a, 0x8b, 0xec, 
  0xfd, 0xa0, 0xae, 0xc3, 0xfe, 0x38, 0x56, 0x73, 0x11, 0xf9, 0xf5, 0x28, 
  0x84, 0x6f, 0xee, 0xed, 0x42, 0xff, 0x92, 0x28, 0x05, 0xa0, 0x57, 0xd5, 
  0x01, 0xa4, 0xea, 0xeb, 0x8e, 0x22, 0x5e, 0x00, 0x47, 0xb3, 0x84, 0x72, 
  0x75, 0xaa, 0x8a, 0xf8, 0x13, 0xb8, 0x57, 0x2a, 0x20, 0xe0, 0x92, 0xa4, 
  0x5c, 0x94, 0xf9, 0x6a, 0x5c, 0xc1, 0x11, 0x02, 0x31, 0xd4, 0x2a, 0x31, 
  0xe8, 0xf2, 0x66, 0xa1, 0x0a, 0xbb, 0x19, 0x57, 0x32, 0x36, 0xf4, 0xc9, 
  0xb0, 0x8b, 0x2d, 0x29, 0x4e, 0xa6, 0x15, 0x3c, 0x21, 0x8a, 0xd3, 0xf8, 
  0x1d, 0x81, 0xf5, 0xcf, 0x5d, 0xc2, 0x78, 0x05, 0x8e, 0x49, 0xa2, 0xef, 
  0x83, 0x2b, 0x46, 0xe5, 0x0d, 0xdc, 0xaf, 0x79, 0xa4, 0xc0, 0x50, 0xb8, 
  0xbd, 0xd9, 0x32, 0xb7, 0xe1, 0xc0, 0x9b, 0xa8, 0xbb, 0xbe, 0x2f, 0x45, 
  0x46, 0xfd, 0x6d, 0xd3, 0x42, 0x1a, 0x38, 0xaa, 0x43, 0xc6, 0x2a, 0x3c, 
  0x00, 0x54, 0x2d, 0x22, 0x33, 0x99, 0xd1, 0x94, 0x9d, 0x18, 0x24, 0x07, 
  0x71, 0xae, 0xeb, 0x37, 0x70, 0xd5, 0xb8, 0xac, 0x0e, 0x5b, 0xed, 0xd6, 
  0x6c, 0x5e, 0x01, 0xe7, 0x02, 0xbe, 0xd1, 0x20, 0xa2, 0x43, 0x33, 0x1d, 
  0x82, 0x9d, 0x60, 0xc1, 0x58, 0x80, 0xb7, 0x4d, 0x3a, 0x3e, 0x77, 0x5d, 
  0xd0, 0x10, 0x78, 0xc6, 0xdd, 0x59, 0xb2, 0xd3, 0x0d, 0xa0, 0xbd, 0x36, 
  0x25, 0xc0, 0x3d, 0x83, 0x90, 0xcf, 0x66, 0x32, 0x4c, 0x50, 0x94, 0x74, 
  0x0e, 0xe7, 0xda, 0x6a, 0x19, 0x0a, 0x35, 0xf1, 0x6b, 0x07, 0xb3, 0xfb, 
  0x7c, 0x6f, 0xb0, 0xfb, 0xe9, 0x67, 0x83, 0x9d, 0xc1, 0xee, 0x0e, 0x73, 
  0x16, 0x1e, 0x4a, 0x30, 0x38, 0x59, 0x97, 0x96, 0xae, 0x2a, 0xef, 0x35, 
  0xfb, 0x3c, 0x3d, 0xba, 0xfc, 0xfe, 0xec, 0xe2, 0xdb, 0xe8, 0xf8, 0xf4, 
  0xf2, 0xe8, 0xe2, 0xf5, 0xfe, 0xc1, 0x87, 0x22, 0x4c, 0x86, 0xd6, 0xd9, 
  0xa0, 0x9c, 0x52, 0x80, 0x79, 0xd6, 0x34, 0x81, 0xf9, 0x35, 0x4b, 0xca, 
  0xeb, 0x9d, 0x17, 0xbb, 0x8f, 0x02, 0x15, 0xb6, 0x58, 0xc1, 0xfc, 0xfb, 
  0x36, 0xa9, 0x5d, 0x9e, 0xd4, 0xfa, 0x56, 0x1c, 0x38, 0xd5, 0x50, 0xa2, 
  0x89, 0x5c, 0x24, 0x2a, 0xf8, 0x3b, 0x63, 0xe2, 0x0a, 0xca, 0xb7, 0x72, 
  0xf4, 0x91, 0x14, 0x83, 0x97, 0xe4, 0x51, 0x85, 0x35, 0xd1, 0x50, 0x6b, 
  0x65, 0xb7, 0x1c, 0x89, 0xbb, 0x4a, 0x67, 0xa5, 0x5a, 0x0d, 0xa4, 0x80, 
  0xef, 0x04, 0x92, 0x4c, 0x6b, 0xc5, 0x40, 0x54, 0xcb, 0x90, 0x92, 0x81, 
  0x13, 0x97, 0x13, 0xe1, 0x72, 0xec, 0x2b, 0x99, 0x25, 0x18, 0x6b, 0xb5, 
  0xfa, 0x54, 0x18, 0x30, 0x5a, 0xc3, 0x85, 0x2b, 0x2c, 0x82, 0x17, 0x13, 
  0xab, 0x58, 0x00, 0x0f, 0x74, 0x20, 0x38, 0x0d, 0xc1, 0x68, 0xa4, 0x2b, 
  0xc8, 0x0d, 0xc4, 0xce, 0x8b, 0x6c, 0x51, 0x05, 0x12, 0x2e, 0xf4, 0x76, 
  0x42, 0x9e, 0x80, 0x88, 0x39, 0x06, 0xc3, 0xca, 0xad, 0x17, 0x15, 0xc8, 
  0xaa, 0x48, 0x90, 0x7c, 0xc3, 0xd7, 0x45, 0xa2, 0x44, 0x3c, 0xe2, 0x24, 
  0x8f, 0xef, 0x18, 0xbe, 0x5c, 0x32, 0x33, 0x7d, 0xe4, 0x5e, 0x00, 0x22, 
  0xcd, 0xf2, 0x81, 0x5f, 0xf3, 0xe8, 0xfc, 0xe8, 0x4d, 0xdf, 0x2a, 0xea, 
  0xd0, 0xef, 0x62, 0x73, 0x41, 0x9a, 0x3c, 0xc7, 0x57, 0xc6, 0x02, 0xf7, 
  0xbe, 0xb0, 0xe8, 0x11, 0xf0, 0x44, 0x0d, 0x77, 0x09, 0x27, 0xc0, 0x87, 
  0x46, 0xd4, 0x6f, 0xe1, 0xb5, 0x7c, 0x18, 0x2d, 0xca, 0xd0, 0xe1, 0xb8, 
  0x55, 0x80, 0xc9, 0x78, 0x3f, 0x35, 0x44, 0x37, 0xda, 0x74, 0x61, 0xa9, 
  0xdc, 0x1f, 0x62, 0x2f, 0xe1, 0x1a, 0x77, 0xde, 0xf0, 0xcc, 0xf2, 0x8a, 
  0xcf, 0xbf, 0x3d, 0x18, 0xfe, 0x71, 0x77, 0x4f, 0x87, 0xb3, 0x65, 0xc2, 
  0x2f, 0xf3, 0xaa, 0x7a, 0xca, 0x39, 0xd8, 0x75, 0x38, 0x46, 0x4b, 0x20, 
  0xc6, 0x01, 0xc7, 0x66, 0x6c, 0xba, 0x24, 0x98, 0xad, 0x4a, 0x16, 0xcc, 
  0x86, 0xd4, 0x50, 0x33, 0x49, 0xca, 0x95, 0xa2, 0x61, 0xcb, 0x3f, 0x4b, 
  0x35, 0x50, 0x94, 0xe9, 0x40, 0x96, 0x2e, 0xb8, 0x2d, 0x5e, 0xd8, 0x47, 
  0xd2, 0xb2, 0xb6, 0x86, 0x0c, 0x69, 0x1f, 0xc0, 0x51, 0xdf, 0x73, 0x5e, 
  0x6f, 0xff, 0x2d, 0x83, 0xd9, 0xe9, 0xa5, 0x6e, 0x18, 0x34, 0xbe, 0x1b, 
  0x1c, 0x00, 0x8d, 0xd7, 0x9e, 0x18, 0xea, 0xf5, 0xc2, 0xe3, 0xf6, 0xf2, 
  0xd3, 0x67, 0xb4, 0x51, 0x74, 0xb2, 0x04, 0x95, 0x80, 0x99, 0x82, 0xd4, 
  0xca, 0x76, 0x8f, 0x1c, 0xe6, 0x0c, 0x90, 0xbc, 0x94, 0xc8, 0xc9, 0xd3, 
  0x41, 0xf4, 0x4d, 0xb2, 0xe0, 0xb4, 0x70, 0x8e, 0x31, 0xb3, 0x3c, 0x23, 
  0x44, 0xc2, 0x31, 0x6a, 0x3f, 0xbd, 0x4d, 0x4d, 0x25, 0xb1, 0x02, 0xb4, 
  0x11, 0xaf, 0x2b, 0x44, 0x91, 0x33, 0xa4, 0xf9, 0x98, 0xe3, 0xd1, 0x70, 
  0x13, 0xa9, 0x35, 0x12, 0xd5, 0x92, 0xd2, 0x42, 0x1b, 0xd8, 0xac, 0xc2, 
  0xac, 0xd1, 0xf7, 0xda, 0x9c, 0x1e, 0x73, 0xb8, 0x54, 0xd4, 0x78, 0xca, 
  0x6f, 0x21, 0x4e, 0x27, 0x16, 0xc5, 0xc2, 0x33, 0x95, 0x49, 0x7e, 0xcd, 
  0x1a, 0x7e, 0x41, 0xd7, 0x4d, 0xbc, 0x18, 0x3f, 0x0c, 0x26, 0x09, 0x11, 
  0x10, 0x9d, 0xb6, 0xc1, 0xea, 0x66, 0x3b, 0x38, 0xa6, 0xcc, 0xf2, 0xaf, 
  0x25, 0x03, 0xbe, 0x6a, 0xdf, 0xb5, 0xa2, 0x39, 0x4d, 0x70, 0xaa, 0xb8, 
  0x0a, 0xac, 0x4e, 0x24, 0x61, 0xb9, 0xec, 0x72, 0x3c, 0xd7, 0xc2, 0x3a, 
  0x1d, 0x45, 0x0e, 0x7d, 0x91, 0x5b, 0x18, 0x2c, 0x93, 0xb9, 0x2f, 0x1a, 
  0x6b, 0xfc, 0x41, 0x78, 0x83, 0x97, 0x9f, 0x03, 0x5b, 0xe4, 0x22, 0xb9, 
  0x9a, 0xa9, 0x40, 0x11, 0x4a, 0xe8, 0xae, 0x89, 0x96, 0x64, 0x07, 0x91, 
  0xeb, 0xb5, 0x9c, 0xee, 0x06, 0x8c, 0x67, 0x73, 0x54, 0x1e, 0x33, 0xc6, 
  0xaf, 0x35, 0xcc, 0x7c, 0x23, 0x8a, 0x8b, 0x01, 0x20, 0x48, 0xd4, 0x59, 
  0x13, 0x4b, 0x86, 0xc5, 0xde, 0xa8, 0x97, 0x85, 0xbe, 0x15, 0x0a, 0x01, 
  0xb8, 0xa7, 0xc6, 0x01, 0xc3, 0xc7, 0x67, 0xf5, 0x65, 0xe4, 0xac, 0xd0, 
  0xd7, 0xb7, 0x4f, 0xd8, 0xb0, 0x7b, 0x79, 0x32, 0xec, 0x09, 0x3d, 0x48, 
  0xe5, 0xf4, 0x00, 0x34, 0xda, 0x93, 0x1f, 0x9b, 0x39, 0x24, 0x56, 0xcb, 
  0xca, 0x08, 0xe6, 0x32, 0x1a, 0xe1, 0x0c, 0xde, 0x23, 0xe4, 0x43, 0xfe, 
  0x6d, 0x21, 0x34, 0x78, 0x96, 0x87, 0x63, 0xf5, 0x9f, 0x45, 0x20, 0x72, 
  0x58, 0x26, 0x28, 0xdb, 0x13, 0xf5, 0x9f, 0xf4, 0xa2, 0xfe, 0x1e, 0x20, 
  0x62, 0x76, 0xab, 0x0b, 0x49, 0x43, 0x23, 0x41, 0x74, 0x0c, 0xd8, 0xf9, 
  0x0d, 0x57, 0x02, 0xd6, 0x58, 0xc2, 0xa6, 0x92, 0xf5, 0x2d, 0xbd, 0xcf, 
  0x3f, 0xf6, 0x74, 0x52, 0xb7, 0xbb, 0x88, 0x53, 0x66, 0x79, 0xf4, 0x36, 
  0x99, 0x3d, 0x34, 0xc5, 0x86, 0xbd, 0x47, 0x77, 0x16, 0x19, 0x01, 0x77, 
  0xa9, 0x43, 0xba, 0x14, 0x38, 0x5d, 0x58, 0xfd, 0xf8, 0x64, 0xd3, 0x5e, 
  0xd9, 0x00, 0x68, 0x19, 0xd5, 0x9e, 0xbb, 0x88, 0x6e, 0xf7, 0xcc, 0xad, 
  0xca, 0xdf, 0xd8, 0xe2, 0x89, 0x5d, 0xda, 0x33, 0x92, 0x46, 0x9a, 0x1e, 
  0xc7, 0x76, 0x05, 0x94, 0xcb, 0x09, 0x3e, 0x44, 0xb7, 0xc4, 0x49, 0x2a, 
  0x9c, 0x86, 0x15, 0xa8, 0xd2, 0x21, 0xed, 0xf0, 0xf6, 0x03, 0x88, 0x93, 
  0x64, 0x61, 0x1f, 0xd1, 0x83, 0x78, 0x67, 0x9c, 0x69, 0x92, 0x60, 0x8b, 
  0xd5, 0x5c, 0x11, 0xf4, 0xc1, 0x88, 0x7b, 0xb8, 0x6e, 0xcb, 0x88, 0x38, 
  0x71, 0x2a, 0xf1, 0x6d, 0x33, 0x08, 0xd3, 0x10, 0xb0, 0xd4, 0x32, 0xe8, 
  0x17, 0x8a, 0xcd, 0x3d, 0x82, 0x1a, 0x07, 0x7a, 0xb9, 0x4e, 0x45, 0x61, 
  0x47, 0x38, 0x26, 0x16, 0x8c, 0x58, 0x45, 0x37, 0xa2, 0xd3, 0xb7, 0xe2, 
  0x46, 0xcb, 0x0c, 0xf1, 0x9e, 0x4e, 0x60, 0xd0, 0x9c, 0xb1, 0x21, 0xa4, 
  0xce, 0xa8, 0x1b, 0x32, 0xc9, 0xfe, 0x17, 0xbc, 0x08, 0x45, 0xd7, 0xaf, 
  0x9a, 0x22, 0xb7, 0x56, 0x97, 0x40, 0x9d, 0x01, 0xb4, 0xde, 0xd2, 0xd4, 
  0x79, 0x6e, 0x15, 0xc3, 0xba, 0xc9, 0x3d, 0x8b, 0x48, 0x5d, 0xeb, 0x57, 
  0xbe, 0x97, 0x9c, 0x77, 0xac, 0xef, 0xf9, 0xf1, 0xa9, 0xd4, 0xad, 0x72, 
  0x67, 0x29, 0x61, 0xc9, 0x5b, 0x9e, 0x13, 0x41, 0x58, 0xcc, 0xd9, 0xec, 
  0xa2, 0x13, 0x03, 0x0b, 0x13, 0x1c, 0x1f, 0x92, 0xd4, 0xba, 0xbb, 0x58, 
  0xc9, 0x08, 0xba, 0x7c, 0x53, 0x16, 0xc5, 0xac, 0x5b, 0x2b, 0x1c, 0xe2, 
  0x76, 0xb4, 0x76, 0x25, 0x39, 0xd3, 0xcd, 0x78, 0x12, 0x16, 0xc5, 0xd3, 
  0x56, 0x2a, 0x9c, 0xb2, 0x57, 0xcb, 0x0b, 0x0c, 0x6d, 0xc6, 0x7f, 0x8c, 
  0x06, 0xdb, 0xd4, 0x61, 0xb1, 0x6d, 0x2f, 0x2e, 0x6f, 0xc6, 0x05, 0xdd, 
  0x91, 0x9c, 0x04, 0xfb, 0x13, 0xb4, 0x70, 0x98, 0x98, 0x68, 0xc8, 0x93, 
  0x9f, 0xa3, 0xfe, 0x78, 0x26, 0x33, 0x44, 0x05, 0xa7, 0x9f, 0x88, 0x6e, 
  0xf8, 0x89, 0x9f, 0x37, 0x38, 0x21, 0x6c, 0xf8, 0xf6, 0x0d, 0xa3, 0x28, 
  0xa3, 0x90, 0xcc, 0xe5, 0xc5, 0xfe, 0xe9, 0xf0, 0xb5, 0x98, 0x15, 0x2f, 
  0xb3, 0xa0, 0x3e, 0x8d, 0xda, 0x64, 0x5d, 0x89, 0x34, 0x83, 0xd6, 0xe2, 
  0xda, 0x1c, 0x41, 0x58, 0xb2, 0x16, 0xaf, 0xe9, 0xd5, 0x01, 0x66, 0xa5, 
  0xf2, 0x0d, 0x18, 0x36, 0x9d, 0xa8, 0xcd, 0x62, 0xcb, 0xdd, 0xae, 0x45, 
  0x88, 0x4c, 0xef, 0x41, 0xdd, 0x44, 0x4b, 0x71, 0x0f, 0xf1, 0x99, 0x39, 
  0xb0, 0xc1, 0xd8, 0xa7, 0xc2, 0xd0, 0xd7, 0x62, 0x28, 0x1e, 0x90, 0xfe, 
  0xd1, 0x57, 0x50, 0xec, 0x00, 0x87, 0xdf, 0x99, 0xa2, 0x84, 0xa1, 0x2b, 
  0xfc, 0x99, 0x6b, 0x3c, 0xcc, 0x99, 0xb3, 0xa6, 0x37, 0xff, 0xbc, 0xbb, 
  0xd5, 0xde, 0xfc, 0xe5, 0xaf, 0x6d, 0xbe, 0x7d, 0xec, 0x26, 0xf0, 0xfb, 
  0xcc, 0x8c, 0xcd, 0x3f, 0xef, 0x6d, 0x3d, 0x3a, 0xa3, 0x30, 0xa9, 0xcc, 
  0xf7, 0x49, 0x6f, 0xf0, 0x60, 0xa3, 0x57, 0x56, 0xa1, 0x4d, 0x2f, 0x62, 
  0x17, 0xdd, 0x30, 0xf5, 0xb0, 0x6e, 0x15, 0x94, 0x03, 0x8e, 0x7e, 0x75, 
  0xe2, 0x9f, 0x77, 0x5a, 0x68, 0x90, 0x3e, 0xea, 0x41, 0x79, 0x38, 0x3c, 
  0xd2, 0xc6, 0x43, 0x9e, 0xc7, 0xe9, 0xd5, 0x45, 0x36, 0x40, 0xdf, 0x7b, 
  0x8f, 0xf4, 0xed, 0x67, 0x17, 0xe8, 0xba, 0xec, 0x01, 0xe4, 0x10, 0x22, 
  0x96, 0xc6, 0xb7, 0x49, 0xbb, 0xd0, 0x7e, 0x36, 0x7c, 0xe1, 0xa3, 0xf5, 
  0xfd, 0x5d, 0x1e, 0xbf, 0x39, 0xe2, 0xba, 0x10, 0x87, 0xc7, 0x8c, 0xd7, 
  0x35, 0x54, 0xc8, 0x3c, 0x53, 0x6b, 0x1d, 0x90, 0x68, 0x08, 0x6d, 0x2d, 
  0xae, 0x31, 0x17, 0xa9, 0xe3, 0xce, 0xbf, 0xdb, 0x09, 0xee, 0x5a, 0x43, 
  0x49, 0x0b, 0x4b, 0x58, 0x3b, 0x9e, 0xf6, 0xdf, 0x64, 0x13, 0xa8, 0x5e, 
  0x7d, 0x81, 0x0a, 0xa6, 0xb7, 0xe8, 0xc3, 0xb7, 0x8b, 0x79, 0xe5, 0xe3, 
  0x30, 0x2d, 0x4e, 0xb5, 0xea, 0x8d, 0x75, 0xf0, 0xdf, 0xbf, 0x6c, 0xf7, 
  0xfb, 0x28, 0xa9, 0x26, 0x11, 0x31, 0x6a, 0x17, 0xaf, 0x60, 0x1a, 0xd8, 
  0xd9, 0xa7, 0xf5, 0x49, 0x67, 0x0f, 0xe2, 0xc3, 0x8d, 0x7d, 0xe4, 0x8d, 
  0xcf, 0x81, 0xbb, 0x42, 0x35, 0x65, 0x67, 0x31, 0x12, 0x9b, 0xd0, 0x46, 
  0x05, 0x8d, 0x91, 0x85, 0xf3, 0xe4, 0xce, 0x87, 0x8e, 0x68, 0x59, 0x93, 
  0x6c, 0xf9, 0x80, 0x49, 0xde, 0x55, 0xbc, 0xd2, 0xad, 0xae, 0xa9, 0x5f, 
  0xe4, 0x9d, 0x0a, 0xe0, 0xbd, 0xf4, 0x10, 0x12, 0xa0, 0x7e, 0xa2, 0xf8, 
  0xf0, 0x67, 0x79, 0xc0, 0xc0, 0x74, 0xd8, 0xb1, 0xf9, 0xd4, 0x3d, 0x3e, 
  0x63, 0x00, 0x2c, 0x59, 0x1d, 0xa7, 0xc7, 0x94, 0xdc, 0xe0, 0xbb, 0x6d, 
  0xc0, 0x66, 0x62, 0xf3, 0x2b, 0x10, 0xd7, 0x31, 0xc8, 0x09, 0xcd, 0x11, 
  0x4a, 0x22, 0xcb, 0x8f, 0x95, 0x1c, 0xe8, 0x6e, 0xbf, 0x0b, 0xb4, 0xe3, 
  0x74, 0xd1, 0x32, 0x99, 0xfe, 0xaf, 0x9f, 0x4d, 0xc3, 0x6b, 0x15, 0x75, 
  0xa6, 0x0c, 0x24, 0xc0, 0x2e, 0x80, 0x8e, 0x0c, 0x40, 0xb0, 0x35, 0x84, 
  0xb6, 0x48, 0xa8, 0x67, 0xb6, 0x66, 0xca, 0x89, 0x28, 0x6a, 0x2e, 0xa8, 
  0xd0, 0xd9, 0x4a, 0xc5, 0xd2, 0xc5, 0x7c, 0x74, 0xb5, 0x9c, 0xc0, 0x9f, 
  0x2d, 0x91, 0x7c, 0x0f, 0x5c, 0xe7, 0x31, 0x9f, 0xc4, 0x0f, 0x2d, 0x83, 
  0x77, 0xdf, 0x7d, 0xe8, 0xd0, 0x7d, 0x28, 0x38, 0xae, 0x53, 0x4d, 0x9a, 
  0x24, 0x86, 0xc3, 0xfe, 0x2c, 0x29, 0xae, 0xc6, 0xf5, 0xa8, 0x81, 0xfa, 
  0x05, 0x69, 0x42, 0xac, 0x4d, 0x56, 0x5c, 0xc4, 0x55, 0x26, 0xe0, 0x27, 
  0x36, 0xa2, 0xf1, 0x75, 0xa2, 0x40, 0xdd, 0xde, 0xe4, 0x16, 0xe7, 0xa8, 
  0x9c, 0x52, 0xdd, 0x98, 0xb4, 0xb4, 0xbd, 0xe0, 0x50, 0x04, 0xde, 0x10, 
  0x22, 0xf2, 0xc3, 0xe3, 0x83, 0x4b, 0x83, 0x85, 0x9b, 0xf2, 0x1d, 0x9a, 
  0x3f, 0x7c, 0x58, 0xa1, 0x88, 0x47, 0x9f, 0x99, 0xbc, 0xb8, 0x4e, 0x48, 
  0x16, 0x5b, 0x8c, 0x56, 0x57, 0x2f, 0xfe, 0x11, 0xe7, 0x57, 0xd9, 0xe2, 
  0x7d, 0xcf, 0x4f, 0x90, 0x8b, 0xf3, 0x82, 0xb8, 0xd2, 0xee, 0xf3, 0xdd, 
  0x27, 0x12, 0xe8, 0x9d, 0x72, 0xc5, 0x1a, 0x30, 0x85, 0xee, 0xbc, 0x2b, 
  0xa8, 0x04, 0x88, 0x30, 0x77, 0x50, 0x04, 0x8b, 0x49, 0x57, 0x14, 0xad, 
  0x38, 0x7c, 0x76, 0xa2, 0xcf, 0x4a, 0xd2, 0x6e, 0x17, 0x60, 0x18, 0xf4, 
  0x38, 0x67, 0xb8, 0xad, 0x96, 0xdd, 0x41, 0xe5, 0x58, 0xbf, 0x67, 0xae, 
  0xdc, 0x85, 0xab, 0x8b, 0x71, 0x20, 0x8c, 0x58, 0x79, 0xe8, 0x28, 0x4f, 
  0xe2, 0x1b, 0x07, 0x95, 0x1f, 0x40, 0x16, 0x98, 0xd1, 0x9c, 0x6b, 0xea, 
  0x01, 0xe9, 0xd1, 0x52, 0x4d, 0xb0, 0xd4, 0xbe, 0xc2, 0xf6, 0x16, 0x8f, 
  0xf2, 0x3d, 0xfd, 0x73, 0x2c, 0xf8, 0x8b, 0xc9, 0xe8, 0x03, 0x1e, 0xa2, 
  0xc3, 0x26, 0x98, 0x5a, 0xfb, 0x55, 0x7c, 0x79, 0x96, 0xf6, 0x4b, 0x26, 
  0x35, 0x54, 0x31, 0x22, 0x2a, 0xd8, 0x94, 0x12, 0x3c, 0x62, 0xb5, 0x96, 
  0xa2, 0xa6, 0x5a, 0xad, 0x4d, 0xcd, 0x04, 0x34, 0x6e, 0x2e, 0x6f, 0x73, 
  0xb8, 0x7f, 0x1e, 0x68, 0x4c, 0xd0, 0x48, 0xbc, 0x75, 0x88, 0x9f, 0x63, 
  0x69, 0x39, 0x2c, 0x15, 0xd7, 0xf3, 0x72, 0x6e, 0x09, 0xe6, 0x38, 0xb9, 
  0x8d, 0x25, 0xa0, 0x38, 0xd3, 0x3b, 0x04, 0x86, 0x0c, 0x00, 0x56, 0xcf, 
  0x26, 0x31, 0x1c, 0x47, 0x7a, 0xf3, 0x40, 0x08, 0x47, 0x5b, 0xa9, 0x46, 
  0x8f, 0xd0, 0xde, 0xdc, 0x47, 0x1a, 0xf4, 0xae, 0xd1, 0xfd, 0xf2, 0xbb, 
  0x3c, 0xc6, 0x09, 0x9d, 0x0f, 0x36, 0x01, 0x61, 0xca, 0x34, 0xf8, 0xb8, 
  0xb8, 0x21, 0xfe, 0x29, 0x0e, 0x4f, 0xea, 0x3d, 0x1d, 0x27, 0x66, 0x4d, 
  0x9d, 0xa4, 0x12, 0x78, 0xe0, 0xeb, 0x91, 0x87, 0x1b, 0x26, 0xd7, 0x0e, 
  0xab, 0x2d, 0xb3, 0x22, 0x11, 0x70, 0xb7, 0xe8, 0xf2, 0x2e, 0x13, 0x51, 
  0xd3, 0x25, 0xd4, 0x4b, 0xe8, 0x5e, 0xb1, 0x4a, 0x05, 0x1f, 0xc2, 0x6a, 
  0xb1, 0x9f, 0xfa, 0x7c, 0x8f, 0x8e, 0x33, 0xa1, 0x1c, 0x3a, 0x3f, 0xd1, 
  0xf0, 0xf0, 0xdb, 0x88, 0x53, 0x91, 0xb9, 0x8f, 0x03, 0x06, 0x89, 0x67, 
  0x97, 0xef, 0x1c, 0x2a, 0xc4, 0xd7, 0x2b, 0x3e, 0xef, 0x07, 0xd7, 0xf1, 
  0x92, 0x25, 0xe1, 0xdd, 0x1d, 0xd6, 0xbb, 0xbf, 0xb7, 0xa4, 0x26, 0x3e, 
  0xa8, 0x56, 0x29, 0xaa, 0xe8, 0x04, 0x2a, 0xf9, 0x84, 0x54, 0xe9, 0x19, 
  0x4b, 0xc2, 0x55, 0x6b, 0x1f, 0x5d, 0x99, 0xc5, 0x36, 0x91, 0xe7, 0x2a, 
  0x9e, 0x15, 0x44, 0x1a, 0x79, 0x31, 0xb9, 0xd9, 0x1e, 0xd3, 0x3f, 0x4f, 
  0x76, 0xb6, 0x81, 0x37, 0x58, 0xc2, 0x38, 0xc6, 0x34, 0xb9, 0xb7, 0xf7, 
  0xec, 0x59, 0x2f, 0xea, 0xb8, 0x4a, 0x7f, 0x4c, 0xbe, 0xaf, 0xc1, 0x66, 
  0x3a, 0xa1, 0x1c, 0x93, 0x4f, 0xc7, 0xfd, 0x84, 0x78, 0x67, 0x96, 0x83, 
  0xc8, 0xe8, 0x4f, 0xfe, 0x1f, 0xbf, 0xcc, 0x59, 0x0e, 0x86, 0x10, 0x71, 
  0xad, 0x77, 0x2b, 0xfc, 0x50, 0x0e, 0x56, 0xc4, 0x88, 0xeb, 0x8e, 0x76, 
  0xc3, 0xcc, 0x12, 0xec, 0x81, 0x58, 0x26, 0xd9, 0xd2, 0x7c, 0x6a, 0xf3, 
  0x07, 0xbd, 0x69, 0x40, 0x69, 0x51, 0x25, 0x4f, 0xf1, 0x5a, 0x82, 0x88, 
  0x34, 0x8b, 0xbc, 0x58, 0x8d, 0xfa, 0x9a, 0x4e, 0x29, 0x6a, 0x46, 0x4a, 
  0xe7, 0x77, 0xce, 0xd5, 0x6c, 0xd5, 0xfa, 0xdb, 0xe0, 0xc9, 0x5f, 0x45, 
  0x1d, 0xa5, 0x30, 0xfe, 0x31, 0x80, 0x4b, 0x2c, 0x19, 0x73, 0xc9, 0x92, 
  0xec, 0x95, 0xfe, 0xf1, 0xb7, 0xbf, 0x51, 0xb3, 0x7f, 0xe3, 0x56, 0x5e, 
  0xfd, 0xb9, 0x28, 0xaf, 0x83, 0x67, 0x3a, 0x4a, 0xf6, 0xc7, 0xde, 0x21, 
  0x88, 0x20, 0x1f, 0x60, 0x72, 0x22, 0xeb, 0xe7, 0xcd, 0x89, 0xf2, 0xe5, 
  0x5e, 0x30, 0xbf, 0x14, 0xf9, 0x58, 0x62, 0x73, 0x73, 0x3e, 0xf6, 0xaf, 
  0xd8, 0x59, 0x97, 0x70, 0x1e, 0x2f, 0xd1, 0x22, 0x40, 0xd7, 0xb6, 0x4c, 
  0xba, 0x38, 0x3a, 0xfd, 0xee, 0xf8, 0xe2, 0xec, 0xf4, 0xcd, 0xd1, 0xe9, 
  0x65, 0xf4, 0xdd, 0xfe, 0xc5, 0xf1, 0xfe, 0x57, 0x27, 0x9a, 0x2e, 0xcc, 
  0x53, 0xe0, 0xd0, 0x08, 0x91, 0xba, 0x6b, 0x90, 0x99, 0x41, 0xfa, 0x46, 
  0x2b, 0x46, 0x7c, 0xad, 0x2a, 0xd4, 0x3b, 0x05, 0x61, 0x86, 0x79, 0xf5, 
  0x1d, 0x8a, 0x03, 0xf4, 0xd8, 0xdf, 0x67, 0xbf, 0x4a, 0xa1, 0x81, 0x77, 
  0x56, 0x35, 0x80, 0x8d, 0x98, 0x0f, 0x41, 0x3a, 0x2a, 0xc7, 0x70, 0x30, 
  0xe5, 0x1a, 0xcf, 0xf2, 0xe5, 0x47, 0x14, 0x37, 0x7f, 0x10, 0x7d, 0x2d, 
  0x19, 0xcd, 0x1a, 0x4d, 0xe4, 0x5e, 0xd5, 0xec, 0x1a, 0x35, 0xea, 0xc8, 
  0x7f, 0xee, 0x97, 0xfd, 0x93, 0x13, 0xdf, 0xe5, 0xbe, 0x48, 0xb8, 0x7d, 
  0x9f, 0x18, 0x6c, 0xb5, 0x97, 0x50, 0x72, 0x5b, 0xf0, 0x6c, 0x24, 0x11, 
  0xe6, 0xda, 0xaa, 0xbb, 0x5d, 0x65, 0x1e, 0x67, 0x7a, 0xf1, 0x10, 0x42, 
  0x4a, 0x73, 0xa7, 0xb4, 0x49, 0x9b, 0x02, 0x47, 0xc0, 0x4e, 0x48, 0x3a, 
  0x5c, 0x69, 0x71, 0xd3, 0x8b, 0xba, 0x7f, 0xee, 0x4a, 0x82, 0x52, 0x02, 
  0xbc, 0x55, 0xb4, 0x5e, 0xf8, 0x9a, 0x6e, 0xd1, 0xe9, 0x99, 0x1f, 0xd3, 
  0x31, 0x02, 0xe2, 0x99, 0xc4, 0x10, 0xff, 0x98, 0x3b, 0x2c, 0x9f, 0x44, 
  0x13, 0x7b, 0xfb, 0xf0, 0x71, 0x4b, 0x9c, 0x36, 0x86, 0x69, 0x2d, 0x7b, 
  0xaf, 0x69, 0x91, 0x38, 0x10, 0x44, 0x40, 0xec, 0x92, 0xb2, 0x16, 0x8f, 
  0x03, 0xf8, 0x5c, 0xb1, 0xe1, 0xb0, 0xda, 0x0b, 0x51, 0x40, 0x0a, 0x3a, 
  0xea, 0xba, 0xb2, 0x75, 0x48, 0x1d, 0x53, 0xab, 0x42, 0x59, 0x28, 0x08, 
  0xea, 0x7e, 0x5b, 0x11, 0xac, 0xc5, 0x5b, 0xc5, 0x01, 0xd4, 0x79, 0x3a, 
  0x51, 0x34, 0xb6, 0x56, 0x82, 0x18, 0xc0, 0xc9, 0x71, 0x71, 0x00, 0xec, 
  0xea, 0x45, 0x7a, 0x1f, 0x40, 0xfd, 0x4b, 0xb0, 0x25, 0xb1, 0x91, 0x9c, 
  0x33, 0x98, 0x16, 0x2a, 0x85, 0x20, 0x80, 0x11, 0x82, 0x79, 0x7c, 0x95, 
  0x99, 0xd0, 0x1d, 0x3b, 0xcf, 0xab, 0x64, 0x26, 0x49, 0x6c, 0x8a, 0xc9, 
  0x5e, 0x0e, 0x6e, 0xc9, 0x19, 0xbf, 0xe0, 0xa3, 0x35, 0x53, 0x33, 0xc7, 
  0xe3, 0x94, 0x01, 0x32, 0x7c, 0x11, 0xa4, 0xb5, 0xfa, 0x70, 0x6f, 0x66, 
  0x23, 0xe2, 0x9d, 0x34, 0xfc, 0x23, 0xa0, 0x4c, 0x59, 0x1a, 0x2c, 0x22, 
  0xc3, 0x30, 0x2c, 0x7e, 0x10, 0x4d, 0x6a, 0x90, 0x1f, 0x9a, 0x34, 0x2b, 
  0x28, 0x1d, 0x9c, 0x19, 0x67, 0xdc, 0x18, 0x13, 0x8a, 0xa3, 0x51, 0x7a, 
  0x15, 0x99, 0x01, 0x24, 0x62, 0x52, 0x00, 0x16, 0x56, 0x36, 0x4f, 0x78, 
  0xab, 0x80, 0x74, 0x05, 0x89, 0xfd, 0x9a, 0x6b, 0x8b, 0x7a, 0x68, 0x26, 
  0x9b, 0x49, 0xc1, 0x11, 0xe9, 0x81, 0x01, 0x0d, 0x46, 0xf4, 0x15, 0xaf, 
  0xa3, 0x85, 0xef, 0x28, 0x8c, 0xb3, 0x06, 0x33, 0xb1, 0x75, 0x16, 0xa0, 
  0x72, 0x0b, 0xa4, 0x4e, 0x58, 0x1a, 0x2a, 0xd6, 0xc1, 0x02, 0x3d, 0x99, 
  0x51, 0xc0, 0xa6, 0x92, 0xcc, 0xa6, 0xd1, 0xa6, 0xc3, 0x61, 0x46, 0x0d, 
  0x5a, 0x01, 0xb2, 0x64, 0xca, 0x96, 0x38, 0xec, 0x4a, 0xbd, 0x04, 0xdb, 
  0x2c, 0x05, 0x1c, 0x9a, 0x4a, 0x41, 0x54, 0x1a, 0xdf, 0x66, 0xc0, 0x73, 
  0x16, 0x44, 0x22, 0xf2, 0x98, 0x68, 0x8d, 0xfa, 0x57, 0x5f, 0x1c, 0x97, 
  0x74, 0x52, 0xd5, 0x83, 0xb9, 0xe5, 0x9d, 0xd7, 0x22, 0x06, 0x30, 0xad, 
  0x4a, 0x3e, 0x8a, 0xca, 0xc7, 0xb4, 0x5f, 0x66, 0x83, 0x0a, 0x4d, 0x58, 
  0x91, 0x65, 0x28, 0xcc, 0x66, 0x01, 0x10, 0xb3, 0x18, 0x21, 0xe2, 0x86, 
  0xf4, 0xe1, 0x6a, 0x92, 0xee, 0x6b, 0xac, 0x84, 0x80, 0xb6, 0x06, 0x33, 
  0xd1, 0x28, 0x5c, 0x96, 0xcf, 0x6a, 0x96, 0xb1, 0x80, 0x99, 0x99, 0xa3, 
  0x35, 0x44, 0xcf, 0xd5, 0x5a, 0x00, 0x69, 0x3c, 0x17, 0xe9, 0xd1, 0x93, 
  0xdf, 0xfc, 0x41, 0xe2, 0xb4, 0x36, 0x36, 0x0e, 0xde, 0x0e, 0x2f, 0xcf, 
  0xde, 0x44, 0x67, 0x6f, 0x2f, 0xcf, 0xdf, 0x5e, 0xea, 0xad, 0x35, 0x92, 
  0x48, 0x56, 0xd1, 0x0c, 0x45, 0x0c, 0xb0, 0xdd, 0x9c, 0xab, 0xf7, 0x18, 
  0x71, 0x0a, 0x19, 0x00, 0xd8, 0x02, 0x34, 0x16, 0x97, 0xc5, 0x02, 0x70, 
  0x22, 0xc1, 0x75, 0xc5, 0x9a, 0xdf, 0xd1, 0x9a, 0x23, 0x03, 0x11, 0x16, 
  0x1d, 0x4b, 0x8a, 0x81, 0xb6, 0xd3, 0x5e, 0x57, 0xe3, 0xa1, 0xaa, 0xbd, 
  0xc0, 0xcf, 0x5b, 0x45, 0xbd, 0xf1, 0x91, 0x27, 0x66, 0xd1, 0xf1, 0x06, 
  0x9f, 0x30, 0x08, 0x0e, 0xe1, 0x1f, 0xe3, 0xd2, 0xec, 0x98, 0x16, 0x87, 
  0x88, 0x88, 0x93, 0x6a, 0x2a, 0x56, 0x98, 0x11, 0x56, 0x66, 0x34, 0xc3, 
  0x6b, 0x17, 0x43, 0xcc, 0xe1, 0xd2, 0x88, 0x9d, 0x12, 0x5f, 0x3c, 0x07, 
  0x29, 0x59, 0xf9, 0xcf, 0x3b, 0xb6, 0x7e, 0x37, 0x6e, 0xd8, 0xbb, 0xa8, 
  0xfb, 0x7d, 0x12, 0x36, 0xf8, 0xc9, 0xbf, 0x38, 0xd1, 0xed, 0x9d, 0x7d, 
  0xf2, 0x6f, 0xe9, 0xf2, 0xef, 0x8b, 0x2e, 0x42, 0x8e, 0xaa, 0x4e, 0xd7, 
  0x6f, 0x8f, 0x2e, 0xbe, 0x3a, 0xba, 0x38, 0x1b, 0x3e, 0x45, 0xe4, 0x89, 
  0x59, 0xb9, 0x9a, 0xd4, 0x7e, 0x93, 0xe4, 0xa3, 0x24, 0xcf, 0x8a, 0xa7, 
  0xae, 0x82, 0x86, 0x2f, 0x9b, 0x0d, 0x85, 0x68, 0x61, 0x79, 0x4f, 0xf6, 
  0x24, 0x51, 0xc0, 0xf8, 0x86, 0xf8, 0xe5, 0x46, 0xd4, 0xe6, 0xca, 0x34, 
  0x53, 0x2c, 0xfb, 0x30, 0x35, 0xeb, 0x8a, 0x1b, 0x76, 0x88, 0x39, 0x8e, 
  0x54, 0x5f, 0xb3, 0xdd, 0xb8, 0xe7, 0x02, 0x93, 0x6e, 0xf2, 0x51, 0x9f, 
  0x48, 0xfa, 0xc6, 0xaa, 0xbf, 0x49, 0x78, 0x38, 0x31, 0x44, 0x89, 0x1b, 
  0xf5, 0x76, 0x84, 0x1b, 0x26, 0x7f, 0x2e, 0xf6, 0x60, 0xd5, 0x3d, 0xa4, 
  0x70, 0x97, 0x85, 0x01, 0x32, 0x0b, 0x7d, 0x2c, 0x71, 0x9f, 0xfa, 0x79, 
  0xea, 0xca, 0x04, 0x89, 0x15, 0x8b, 0x3f, 0x72, 0xd0, 0x45, 0x5a, 0x23, 
  0x02, 0xa1, 0x43, 0x53, 0x12, 0xb1, 0x97, 0x77, 0x13, 0xbd, 0x25, 0x80, 
  0xd6, 0xbb, 0x10, 0x2b, 0xb6, 0x30, 0xe9, 0xba, 0x2f, 0x83, 0xeb, 0x1a, 
  0x21, 0x84, 0x5d, 0x03, 0x74, 0xa3, 0xd1, 0x2c, 0x5e, 0xdc, 0xe0, 0xba, 
  0xc2, 0xf5, 0xc3, 0x4a, 0xa5, 0x0d, 0x95, 0xab, 0x40, 0xc1, 0x75, 0xa5, 
  0xb9, 0xf2, 0x10, 0xf0, 0x66, 0xcc, 0xbd, 0x1e, 0xac, 0xf4, 0xaf, 0x1a, 
  0x03, 0x02, 0x27, 0x0d, 0x8e, 0x8b, 0x96, 0x72, 0x92, 0xaa, 0xbc, 0x2e, 
  0xe0, 0x1e, 0x3a, 0xb7, 0x94, 0xdd, 0xb5, 0xb0, 0x11, 0xc9, 0x31, 0x4b, 
  0xc1, 0xa3, 0x84, 0x2f, 0x18, 0x84, 0x34, 0x1c, 0x0c, 0xa0, 0x03, 0xa4, 
  0xd2, 0x15, 0xae, 0xd2, 0x82, 0x32, 0x65, 0xe1, 0x4f, 0x40, 0x48, 0xf4, 
  0x85, 0x17, 0xc2, 0xaa, 0x1c, 0x8a, 0x68, 0x7d, 0xe0, 0x83, 0x46, 0x62, 
  0xfb, 0x4e, 0x06, 0xe1, 0x85, 0x4d, 0xe7, 0x86, 0xaa, 0x44, 0xfa, 0xaf, 
  0xdd, 0x21, 0x79, 0xbd, 0x4d, 0xc1, 0x07, 0x7f, 0x5b, 0x68, 0x79, 0x65, 
  0x8f, 0x92, 0x62, 0xe1, 0x9b, 0xd5, 0x90, 0x49, 0x1b, 0xb8, 0x16, 0x53, 
  0x4f, 0x0a, 0x04, 0x36, 0x89, 0x67, 0x09, 0xe1, 0x7e, 0x7a, 0xb9, 0x96, 
  0x13, 0x30, 0x93, 0xbc, 0x02, 0xd7, 0x19, 0x46, 0x2a, 0x4a, 0x22, 0x3f, 
  0x6c, 0x7d, 0x12, 0xbb, 0x0e, 0x0d, 0xc5, 0x49, 0xad, 0xfd, 0x53, 0xbe, 
  0x09, 0xb2, 0xfe, 0x68, 0x05, 0x9d, 0xcb, 0x43, 0x4e, 0x69, 0x3e, 0x1b, 
  0xa9, 0x62, 0x82, 0x31, 0x85, 0xef, 0xd9, 0x61, 0x81, 0x4c, 0x61, 0xf1, 
  0x61, 0x20, 0x75, 0xac, 0x8a, 0x3f, 0xe2, 0x50, 0x27, 0x24, 0x1e, 0x1b, 
  0x71, 0xa9, 0x1a, 0x7c, 0xab, 0x23, 0xd4, 0x4d, 0x76, 0xb1, 0x64, 0x0b, 
  0x2d, 0x53, 0x06, 0xe3, 0x79, 0x35, 0xfa, 0xd4, 0x55, 0x60, 0x26, 0xa6, 
  0xc5, 0xf3, 0x4d, 0x14, 0x08, 0xdb, 0xc2, 0x4a, 0x2d, 0x88, 0xfd, 0xb6, 
  0xe4, 0x02, 0x37, 0x92, 0x30, 0x1f, 0xcf, 0xa4, 0x54, 0xc1, 0xda, 0x4b, 
  0x42, 0xce, 0x51, 0x79, 0x79, 0xf9, 0xe3, 0xf9, 0xd1, 0x2b, 0x7b, 0xf3, 
  0xb1, 0x3d, 0x13, 0x1c, 0x29, 0x04, 0x56, 0x24, 0x8a, 0xd8, 0x18, 0x94, 
  0xd5, 0x23, 0x22, 0xeb, 0x97, 0xe6, 0xf0, 0x95, 0x6e, 0xfa, 0xd1, 0x0f, 
  0x87, 0xc7, 0xc3, 0xf3, 0x93, 0xb3, 0x83, 0x57, 0x2f, 0x7f, 0x30, 0x66, 
  0xfb, 0x05, 0x03, 0xa7, 0x88, 0x08, 0xe6, 0x3e, 0xf3, 0x79, 0xee, 0xfa, 
  0xde, 0xe9, 0xd1, 0xf7, 0xef, 0x48, 0xe6, 0x7f, 0xc5, 0xc8, 0xd6, 0xbd, 
  0xdb, 0x78, 0xa6, 0x2f, 0xb1, 0xe2, 0xd4, 0x22, 0xb6, 0x05, 0x59, 0x09, 
  0x6d, 0x0b, 0x8b, 0x4a, 0x7c, 0x1e, 0x66, 0x14, 0x45, 0xa6, 0x2d, 0xd6, 
  0x2a, 0x28, 0x90, 0x13, 0x57, 0x52, 0x0c, 0x5b, 0xaa, 0xe1, 0x65, 0xee, 
  0x62, 0xef, 0x96, 0x12, 0x73, 0xc7, 0x7e, 0xe6, 0xd0, 0x7d, 0x8b, 0x08, 
  0x4d, 0xfd, 0xc6, 0xc7, 0x36, 0x2a, 0x86, 0x6c, 0xce, 0x51, 0x0e, 0x0e, 
  0x8b, 0x4f, 0x3a, 0x16, 0xc7, 0xa8, 0x02, 0xf6, 0x29, 0x20, 0xcd, 0x62, 
  0xe2, 0x23, 0x8b, 0x8d, 0x83, 0xa9, 0x74, 0xe2, 0xc6, 0x12, 0x8f, 0xc7, 
  0xf4, 0x83, 0x81, 0x12, 0xb9, 0x28, 0xc9, 0x39, 0x97, 0xd5, 0x1d, 0x5e, 
  0xb2, 0x72, 0x74, 0x70, 0x76, 0x7a, 0x7a, 0x74, 0x60, 0x36, 0x65, 0x2b, 
  0xc4, 0x85, 0xfc, 0xf5, 0x2a, 0x00, 0x63, 0x58, 0x2f, 0xa1, 0x72, 0xa2, 
  0x1d, 0x83, 0xab, 0x26, 0xb4, 0xb1, 0x95, 0x40, 0xb2, 0xe4, 0x58, 0xc6, 
  0x14, 0x18, 0xd1, 0x78, 0x6a, 0x07, 0x38, 0x53, 0xd2, 0xa8, 0x95, 0x0d, 
  0xf0, 0x75, 0xdc, 0x67, 0xe9, 0xc8, 0x5b, 0xc1, 0x6b, 0x3e, 0x46, 0x76, 
  0x61, 0x2b, 0x70, 0x41, 0x78, 0x84, 0xcc, 0xbe, 0xed, 0xb3, 0x44, 0x8b, 
  0xcc, 0xea, 0xd5, 0x09, 0xf1, 0xc3, 0xfe, 0x1c, 0xe6, 0xf2, 0x39, 0xf5, 
  0x13, 0x5a, 0x86, 0x49, 0x60, 0xee, 0xd3, 0x20, 0x48, 0x51, 0xb1, 0x70, 
  0x00, 0xe0, 0xa9, 0xcc, 0x1a, 0x45, 0x61, 0x25, 0x2b, 0x87, 0x8d, 0x28, 
  0x24, 0x8f, 0x20, 0xcb, 0x18, 0xc1, 0x24, 0x3a, 0xb3, 0x86, 0x70, 0xa1, 
  0x52, 0xe1, 0x15, 0xa7, 0xf3, 0x00, 0x70, 0x68, 0xc2, 0x92, 0x14, 0xac, 
  0x6b, 0x61, 0x67, 0x76, 0x79, 0xf2, 0x0a, 0x5a, 0x51, 0x67, 0x71, 0xb7, 
  0xba, 0xd1, 0x4b, 0x5d, 0x06, 0x2c, 0x3c, 0xc2, 0xe8, 0xe2, 0x1c, 0x48, 
  0x7e, 0xa5, 0xc2, 0x65, 0x9b, 0x4e, 0xa3, 0x31, 0x71, 0x83, 0x2a, 0xb6, 
  0x89, 0xd1, 0xa5, 0x06, 0xb1, 0x3c, 0xba, 0xa2, 0x6e, 0x35, 0x85, 0x7c, 
  0xf3, 0xc4, 0x82, 0x5b, 0xc4, 0x78, 0x50, 0xb0, 0x03, 0x61, 0x61, 0x39, 
  0x1b, 0x92, 0x80, 0xc1, 0x41, 0x1e, 0xb9, 0xe2, 0xc6, 0x10, 0xfb, 0x63, 
  0x53, 0x31, 0x4a, 0x36, 0xa2, 0xe0, 0x20, 0x7b, 0xd1, 0x0c, 0x53, 0xcc, 
  0x81, 0x71, 0xe8, 0x72, 0x07, 0x64, 0x25, 0xf6, 0xf2, 0x07, 0xed, 0xd0, 
  0x25, 0x0b, 0xdb, 0x66, 0xf5, 0x24, 0xf7, 0x24, 0x46, 0xaa, 0x83, 0xd9, 
  0x6c, 0x83, 0x94, 0xb9, 0x42, 0x13, 0x11, 0x9d, 0x07, 0x52, 0x18, 0x1e, 
  0xea, 0xee, 0xf8, 0xd4, 0x9d, 0x8a, 0xa7, 0x8f, 0x04, 0xc7, 0x25, 0x8a, 
  0xc8, 0x8c, 0x15, 0x46, 0x1b, 0x61, 0x9d, 0xae, 0x3d, 0xbb, 0x43, 0xfc, 
  0x5a, 0xd1, 0xa2, 0xbe, 0xd9, 0x3f, 0x3e, 0x61, 0x8f, 0xe2, 0x09, 0x1d, 
  0xa7, 0xa1, 0x59, 0x7a, 0xe1, 0x76, 0x85, 0x47, 0x94, 0xe4, 0x66, 0x5a, 
  0x9a, 0x9e, 0x03, 0xbb, 0xb5, 0xe8, 0x45, 0xd0, 0x08, 0x9b, 0x47, 0x84, 
  0xcd, 0x2a, 0x36, 0x05, 0x31, 0xb7, 0xf1, 0x8a, 0xc3, 0x0d, 0x59, 0xf4, 
  0x05, 0x04, 0x14, 0x63, 0x23, 0xc2, 0x20, 0x05, 0xf6, 0x25, 0x2e, 0x62, 
  0xe0, 0x6b, 0x73, 0xc5, 0xf1, 0x5b, 0x95, 0x51, 0x05, 0x50, 0xe7, 0x6b, 
  0xb5, 0x02, 0x49, 0x7d, 0x9d, 0x72, 0xa3, 0xb5, 0x6e, 0xf5, 0x36, 0xf7, 
  0xb9, 0x2d, 0xb9, 0x88, 0x3e, 0xc5, 0x8c, 0xbb, 0xf7, 0xe8, 0x8f, 0x66, 
  0x7a, 0xe3, 0xf7, 0xfa, 0xcc, 0x4f, 0x0a, 0xb9, 0x02, 0xde, 0x16, 0x9a, 
  0x45, 0x54, 0x0f, 0xde, 0x50, 0x91, 0x4c, 0x0b, 0x34, 0x88, 0x0a, 0xd3, 
  0x33, 0x9c, 0x2e, 0x51, 0xbc, 0x98, 0x04, 0x7b, 0x2c, 0xee, 0xa2, 0x25, 
  0xab, 0xb7, 0xd8, 0x93, 0x08, 0x76, 0xc8, 0x1c, 0xa4, 0xe4, 0xf4, 0x22, 
  0xb8, 0xa2, 0x98, 0xf2, 0xf0, 0x2c, 0xe3, 0x0c, 0x05, 0x0e, 0x62, 0xfa, 
  0x53, 0xa2, 0x93, 0xf4, 0x2f, 0x34, 0x95, 0xaf, 0x00, 0x67, 0xd5, 0x43, 
  0x98, 0x20, 0xcc, 0x36, 0x52, 0x9f, 0x55, 0x46, 0xaf, 0xb6, 0x53, 0x19, 
  0xff, 0xa1, 0x99, 0xf6, 0x0c, 0x4d, 0x28, 0xcb, 0x6d, 0x75, 0x65, 0x17, 
  0x46, 0x52, 0x4f, 0xe3, 0xab, 0x15, 0x5b, 0x14, 0x1c, 0x5e, 0x34, 0x8f, 
  0x62, 0xce, 0x75, 0x70, 0x12, 0x29, 0x5d, 0xe3, 0x1a, 0xe7, 0xd3, 0xb3, 
  0xa2, 0xdd, 0x95, 0xd6, 0x4f, 0xb2, 0x3b, 0x2e, 0xbc, 0x33, 0x9d, 0x72, 
  0xd5, 0xcf, 0xb3, 0x85, 0x87, 0xad, 0xe2, 0x4b, 0x48, 0x1e, 0x9c, 0x1b, 
  0xd8, 0x37, 0xcd, 0x2d, 0x5a, 0xae, 0x46, 0x33, 0x12, 0xd0, 0x2c, 0xbe, 
  0x64, 0x10, 0xed, 0x63, 0x95, 0x88, 0xb0, 0xd1, 0x9c, 0xd8, 0x44, 0x71, 
  0xb6, 0x6b, 0xe1, 0x0c, 0x5a, 0x10, 0x90, 0x03, 0xba, 0xe7, 0xa8, 0x40, 
  0xc4, 0x6e, 0xfb, 0x79, 0xb6, 0xb0, 0xe8, 0xb4, 0x55, 0x21, 0x20, 0x26, 
  0x56, 0x3d, 0x70, 0x43, 0xf4, 0xbb, 0x74, 0xa6, 0xa8, 0x81, 0xca, 0x05, 
  0xf1, 0x46, 0x38, 0x99, 0x49, 0x7f, 0x79, 0xbd, 0xb4, 0x9d, 0xb6, 0xe3, 
  0x26, 0xd1, 0xd1, 0x1a, 0x0f, 0x05, 0xc3, 0xc2, 0xf9, 0x37, 0xe7, 0x83, 
  0xe8, 0x88, 0x5b, 0x92, 0x31, 0x29, 0x93, 0xc6, 0x75, 0x48, 0xdf, 0xd1, 
  0x64, 0xaf, 0x38, 0xef, 0xf1, 0x2c, 0xe7, 0xbf, 0xd0, 0x9a, 0x7e, 0x29, 
  0xb2, 0x2f, 0xbe, 0xad, 0xf6, 0x4a, 0x0d, 0x65, 0x5a, 0x27, 0xf6, 0x1c, 
  0xbf, 0xd3, 0x51, 0x21, 0x6d, 0xc0, 0x6d, 0x93, 0xef, 0x21, 0xcb, 0x2b, 
  0x29, 0x9f, 0xf2, 0x66, 0x34, 0x4a, 0x45, 0x99, 0x5a, 0x3e, 0x60, 0xff, 
  0x20, 0x3d, 0x21, 0x4f, 0x58, 0xf3, 0x09, 0xa4, 0x81, 0x80, 0xb4, 0x94, 
  0xfc, 0x9c, 0xeb, 0x53, 0xce, 0x55, 0x2e, 0xc9, 0x8e, 0x79, 0xa2, 0x8e, 
  0xe2, 0x4c, 0x8d, 0x4d, 0x72, 0x79, 0x14, 0x49, 0xed, 0xb8, 0x06, 0x80, 
  0xb5, 0xf6, 0x05, 0x73, 0x38, 0x1e, 0xcb, 0x6d, 0x3a, 0xa1, 0x2d, 0x18, 
  0x6c, 0xfc, 0x7f, 0x2d, 0xc6, 0x38, 0x42, 0xe4, 0x8f, 0x01, 0x00, 
};
/* Decompress and send to stdout a gzip-compressed buffer */
void hugehelp(void)
{
  unsigned char buf[0x10000];
  int status,headerlen;
  z_stream z;

  /* Make sure no gzip options are set */
  if (hugehelpgz[3] & 0xfe)
    return;

  headerlen = 10;
  z.avail_in = sizeof(hugehelpgz) - headerlen;
  z.next_in = (unsigned char *)hugehelpgz + headerlen;
  z.zalloc = (alloc_func)Z_NULL;
  z.zfree = (free_func)Z_NULL;
  z.opaque = 0;

  if (inflateInit2(&z, -MAX_WBITS) != Z_OK)
    return;

  while(1) {
    z.avail_out = (int)sizeof(buf);
    z.next_out = buf;
    status = inflate(&z, Z_SYNC_FLUSH);
    if (status == Z_OK || status == Z_STREAM_END) {
      fwrite(buf, sizeof(buf) - z.avail_out, 1, stdout);
      if (status == Z_STREAM_END)
         break;
    }
     else
      break;    /* Error */
  }
  inflateEnd(&z);
}
#endif /* USE_MANUAL */
#endif /* HAVE_LIBZ */
