/*-*- c++ -*-******************************************************************
**
**  Copyright (c) 1999,2000 Red Hat, Inc. Harald Hoyer (Harald.Hoyer@RedHat.de) 
**
**  $Id: cdrom.h,v 1.2 2003/07/21 11:19:13 saturn_de Exp $
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**
******************************************************************************/
#include "config.h"
#include <string>
using namespace std;

/** Small CDROM handling class 
 *  @author Harald Hoyer
 */
class CDRom {
public:
   /** Constructor.
    * @param devpath The path of the CDROM
    * @param mpath The path where to mount the cdrom
    */
   CDRom(string devpath);

   ~CDRom();

   /** Has the CDROM been opened 
    */
   bool isOpen();

   int open();
   int close();
   
  /** Test if this device is a CDROM
   */

  int test();

   /** Mount a possible isofs
    */
   bool mount();

   /** Has the media changed?
    * @returns true if changed
    */
   bool mediaChanged();
   
   /** Ejects the media
    *
    */
   bool eject();

   /** Set the device path
    *
    */
   void setDevPath(string &_devpath){
      devpath = _devpath;
   };

   typedef enum {
      tray_is_open,
      unknown,
      unmounted,
      mounted,
      audio
   } cdstatus_t;

   typedef enum {
      t_tray_is_open,
      t_unknown,
      t_audio,
      t_data,
      t_mixed
   } cdtype_t;
   
   cdstatus_t cdstatus;
   cdtype_t cdtype;
   string devpath;
   string mountpath;

   /** Check if media is ok.
    */
   bool checkOK();

   /** Check the medium.
    */
   cdstatus_t checkMedia();

   /** Check if the medium is already mounted.
    */
   bool isMounted();

   /** Get the fd of the cdrom
    */
   int getFD() {return cdromfd;};

   bool allowEject;

private:
   string volume_id;
   int cdromfd;
};
