/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import java.util.function.Function;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.TokenFilter;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.AttributeSource;

public abstract class ConditionalTokenFilter
extends TokenFilter {
    private final TokenStream delegate;
    private TokenState state = TokenState.READING;
    private boolean lastTokenFiltered;
    private AttributeSource.State bufferedState = null;
    private boolean exhausted;
    private boolean adjustPosition;
    private AttributeSource.State endState = null;
    private int endOffset;
    private final PositionIncrementAttribute posIncAtt = this.addAttribute(PositionIncrementAttribute.class);

    protected ConditionalTokenFilter(TokenStream input, Function<TokenStream, TokenStream> inputFactory) {
        super(input);
        this.delegate = inputFactory.apply(new OneTimeWrapper(this.input));
    }

    protected abstract boolean shouldFilter() throws IOException;

    @Override
    public void reset() throws IOException {
        super.reset();
        this.delegate.reset();
        this.state = TokenState.READING;
        this.lastTokenFiltered = false;
        this.bufferedState = null;
        this.exhausted = false;
        this.adjustPosition = false;
        this.endOffset = -1;
        this.endState = null;
    }

    @Override
    public void end() throws IOException {
        if (this.endState == null) {
            super.end();
            this.endState = this.captureState();
        } else {
            this.restoreState(this.endState);
        }
        this.endOffset = this.getAttribute(OffsetAttribute.class).endOffset();
        if (this.lastTokenFiltered) {
            this.delegate.end();
            this.endState = this.captureState();
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.delegate.close();
    }

    @Override
    public final boolean incrementToken() throws IOException {
        this.lastTokenFiltered = false;
        do {
            if (this.state != TokenState.READING) continue;
            if (this.bufferedState != null) {
                this.restoreState(this.bufferedState);
                this.bufferedState = null;
                this.lastTokenFiltered = false;
                return true;
            }
            if (this.exhausted) {
                return false;
            }
            if (!this.input.incrementToken()) {
                this.exhausted = true;
                return false;
            }
            if (this.shouldFilter()) {
                this.lastTokenFiltered = true;
                this.state = TokenState.PREBUFFERING;
                this.delegate.reset();
                boolean more = this.delegate.incrementToken();
                if (more) {
                    this.state = TokenState.DELEGATING;
                    if (this.adjustPosition) {
                        int posInc = this.posIncAtt.getPositionIncrement();
                        this.posIncAtt.setPositionIncrement(posInc - 1);
                    }
                } else {
                    this.state = TokenState.READING;
                    return this.endDelegating();
                }
                this.adjustPosition = false;
                return true;
            }
            return true;
        } while (this.state != TokenState.DELEGATING);
        this.lastTokenFiltered = true;
        if (this.delegate.incrementToken()) {
            return true;
        }
        this.state = TokenState.READING;
        return this.endDelegating();
    }

    private boolean endDelegating() throws IOException {
        if (this.bufferedState == null) {
            assert (this.exhausted);
            return false;
        }
        this.delegate.end();
        int posInc = this.posIncAtt.getPositionIncrement();
        this.restoreState(this.bufferedState);
        this.posIncAtt.setPositionIncrement(this.posIncAtt.getPositionIncrement() + posInc);
        if (this.adjustPosition) {
            this.posIncAtt.setPositionIncrement(this.posIncAtt.getPositionIncrement() - 1);
            this.adjustPosition = false;
        }
        this.bufferedState = null;
        return true;
    }

    private final class OneTimeWrapper
    extends TokenStream {
        private final OffsetAttribute offsetAtt;
        private final PositionIncrementAttribute posIncAtt;

        public OneTimeWrapper(AttributeSource attributeSource) {
            super(attributeSource);
            this.offsetAtt = attributeSource.addAttribute(OffsetAttribute.class);
            this.posIncAtt = attributeSource.addAttribute(PositionIncrementAttribute.class);
        }

        @Override
        public boolean incrementToken() throws IOException {
            if (ConditionalTokenFilter.this.state == TokenState.PREBUFFERING) {
                if (this.posIncAtt.getPositionIncrement() == 0) {
                    ConditionalTokenFilter.this.adjustPosition = true;
                    this.posIncAtt.setPositionIncrement(1);
                }
                ConditionalTokenFilter.this.state = TokenState.DELEGATING;
                return true;
            }
            assert (ConditionalTokenFilter.this.state == TokenState.DELEGATING);
            if (ConditionalTokenFilter.this.input.incrementToken()) {
                if (ConditionalTokenFilter.this.shouldFilter()) {
                    return true;
                }
                ConditionalTokenFilter.this.endOffset = this.offsetAtt.endOffset();
                ConditionalTokenFilter.this.bufferedState = this.captureState();
            } else {
                ConditionalTokenFilter.this.exhausted = true;
            }
            return false;
        }

        @Override
        public void reset() throws IOException {
        }

        @Override
        public void end() throws IOException {
            if (ConditionalTokenFilter.this.exhausted) {
                if (ConditionalTokenFilter.this.endState == null) {
                    ConditionalTokenFilter.this.input.end();
                    ConditionalTokenFilter.this.endState = this.captureState();
                }
                ConditionalTokenFilter.this.endOffset = this.offsetAtt.endOffset();
            }
            this.endAttributes();
            this.offsetAtt.setOffset(ConditionalTokenFilter.this.endOffset, ConditionalTokenFilter.this.endOffset);
        }
    }

    private static enum TokenState {
        READING,
        PREBUFFERING,
        DELEGATING;

    }
}

