/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.miscellaneous;

import java.util.Map;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.miscellaneous.FingerprintFilter;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.util.TokenFilterFactory;

public class FingerprintFilterFactory
extends TokenFilterFactory {
    public static final String NAME = "fingerprint";
    public static final String MAX_OUTPUT_TOKEN_SIZE_KEY = "maxOutputTokenSize";
    public static final String SEPARATOR_KEY = "separator";
    final int maxOutputTokenSize;
    final char separator;

    public FingerprintFilterFactory(Map<String, String> args) {
        super(args);
        this.maxOutputTokenSize = this.getInt(args, MAX_OUTPUT_TOKEN_SIZE_KEY, 1024);
        this.separator = this.getChar(args, SEPARATOR_KEY, ' ');
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new FingerprintFilter(input, this.maxOutputTokenSize, this.separator);
    }
}

