/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.ngram;

import java.util.Map;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.TokenFilter;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.ngram.EdgeNGramTokenFilter;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.util.TokenFilterFactory;

public class EdgeNGramFilterFactory
extends TokenFilterFactory {
    public static final String NAME = "edgeNGram";
    private final int maxGramSize;
    private final int minGramSize;
    private final boolean preserveOriginal;

    public EdgeNGramFilterFactory(Map<String, String> args) {
        super(args);
        this.minGramSize = this.requireInt(args, "minGramSize");
        this.maxGramSize = this.requireInt(args, "maxGramSize");
        this.preserveOriginal = this.getBoolean(args, "preserveOriginal", false);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    @Override
    public TokenFilter create(TokenStream input) {
        return new EdgeNGramTokenFilter(input, this.minGramSize, this.maxGramSize, this.preserveOriginal);
    }
}

