/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.no;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.TokenFilter;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.no.NorwegianLightStemmer;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.tokenattributes.KeywordAttribute;

public final class NorwegianLightStemFilter
extends TokenFilter {
    private final NorwegianLightStemmer stemmer;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAttr = this.addAttribute(KeywordAttribute.class);

    public NorwegianLightStemFilter(TokenStream input) {
        this(input, 1);
    }

    public NorwegianLightStemFilter(TokenStream input, int flags) {
        super(input);
        this.stemmer = new NorwegianLightStemmer(flags);
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            if (!this.keywordAttr.isKeyword()) {
                int newlen = this.stemmer.stem(this.termAtt.buffer(), this.termAtt.length());
                this.termAtt.setLength(newlen);
            }
            return true;
        }
        return false;
    }
}

