/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.index;

import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.DocIdSet;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.BitSetIterator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.FixedBitSet;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.RamUsageEstimator;

final class DocsWithFieldSet
extends DocIdSet {
    private static long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(DocsWithFieldSet.class);
    private FixedBitSet set;
    private int cost = 0;
    private int lastDocId = -1;

    DocsWithFieldSet() {
    }

    void add(int docID) {
        if (docID <= this.lastDocId) {
            throw new IllegalArgumentException("Out of order doc ids: last=" + this.lastDocId + ", next=" + docID);
        }
        if (this.set != null) {
            this.set = FixedBitSet.ensureCapacity(this.set, docID);
            this.set.set(docID);
        } else if (docID != this.cost) {
            this.set = new FixedBitSet(docID + 1);
            this.set.set(0, this.cost);
            this.set.set(docID);
        }
        this.lastDocId = docID;
        ++this.cost;
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + (this.set == null ? 0L : this.set.ramBytesUsed());
    }

    @Override
    public DocIdSetIterator iterator() {
        return this.set != null ? new BitSetIterator(this.set, this.cost) : DocIdSetIterator.all(this.cost);
    }
}

