/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.queryparser.xml.builders;

import org.graylog.shaded.elasticsearch7.org.apache.lucene.queryparser.xml.DOMUtils;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.queryparser.xml.ParserException;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.queryparser.xml.builders.SpanBuilderBase;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.queryparser.xml.builders.SpanQueryBuilder;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.spans.SpanBoostQuery;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.spans.SpanNotQuery;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.spans.SpanQuery;
import org.w3c.dom.Element;

public class SpanNotBuilder
extends SpanBuilderBase {
    private final SpanQueryBuilder factory;

    public SpanNotBuilder(SpanQueryBuilder factory) {
        this.factory = factory;
    }

    @Override
    public SpanQuery getSpanQuery(Element e) throws ParserException {
        Element includeElem = DOMUtils.getChildByTagOrFail(e, "Include");
        includeElem = DOMUtils.getFirstChildOrFail(includeElem);
        Element excludeElem = DOMUtils.getChildByTagOrFail(e, "Exclude");
        excludeElem = DOMUtils.getFirstChildOrFail(excludeElem);
        SpanQuery include = this.factory.getSpanQuery(includeElem);
        SpanQuery exclude = this.factory.getSpanQuery(excludeElem);
        SpanNotQuery snq = new SpanNotQuery(include, exclude);
        float boost = DOMUtils.getAttribute(e, "boost", 1.0f);
        return new SpanBoostQuery(snq, boost);
    }
}

