/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.search;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.LeafFieldComparator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Scorable;

final class MultiLeafFieldComparator
implements LeafFieldComparator {
    private final LeafFieldComparator[] comparators;
    private final int[] reverseMul;
    private final LeafFieldComparator firstComparator;
    private final int firstReverseMul;

    MultiLeafFieldComparator(LeafFieldComparator[] comparators, int[] reverseMul) {
        if (comparators.length != reverseMul.length) {
            throw new IllegalArgumentException("Must have the same number of comparators and reverseMul, got " + comparators.length + " and " + reverseMul.length);
        }
        this.comparators = comparators;
        this.reverseMul = reverseMul;
        this.firstComparator = comparators[0];
        this.firstReverseMul = reverseMul[0];
    }

    @Override
    public void setBottom(int slot) throws IOException {
        for (LeafFieldComparator comparator : this.comparators) {
            comparator.setBottom(slot);
        }
    }

    @Override
    public int compareBottom(int doc) throws IOException {
        int cmp = this.firstReverseMul * this.firstComparator.compareBottom(doc);
        if (cmp != 0) {
            return cmp;
        }
        for (int i = 1; i < this.comparators.length; ++i) {
            cmp = this.reverseMul[i] * this.comparators[i].compareBottom(doc);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    @Override
    public int compareTop(int doc) throws IOException {
        int cmp = this.firstReverseMul * this.firstComparator.compareTop(doc);
        if (cmp != 0) {
            return cmp;
        }
        for (int i = 1; i < this.comparators.length; ++i) {
            cmp = this.reverseMul[i] * this.comparators[i].compareTop(doc);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    @Override
    public void copy(int slot, int doc) throws IOException {
        for (LeafFieldComparator comparator : this.comparators) {
            comparator.copy(slot, doc);
        }
    }

    @Override
    public void setScorer(Scorable scorer) throws IOException {
        for (LeafFieldComparator comparator : this.comparators) {
            comparator.setScorer(scorer);
        }
    }
}

