/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.search.grouping;

import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.grouping.LongRange;

public class LongRangeFactory {
    private final long min;
    private final long width;
    private final long max;

    public LongRangeFactory(long min, long width, long max) {
        this.min = min;
        this.width = width;
        this.max = max;
    }

    public LongRange getRange(long value, LongRange reuse) {
        if (reuse == null) {
            reuse = new LongRange(Long.MIN_VALUE, Long.MAX_VALUE);
        }
        if (value < this.min) {
            reuse.max = this.min;
            reuse.min = Long.MIN_VALUE;
            return reuse;
        }
        if (value >= this.max) {
            reuse.min = this.max;
            reuse.max = Long.MAX_VALUE;
            return reuse;
        }
        long bucket = (value - this.min) / this.width;
        reuse.min = this.min + bucket * this.width;
        reuse.max = reuse.min + this.width;
        return reuse;
    }
}

