/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.search.grouping;

import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.FilterCollector;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.MultiCollector;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Scorable;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.ScoreDoc;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.ScoreMode;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.SimpleCollector;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Sort;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.TopDocs;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.TopDocsCollector;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.TopFieldCollector;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.TopScoreDocCollector;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.grouping.GroupDocs;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.grouping.GroupReducer;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.grouping.GroupSelector;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.grouping.SearchGroup;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.grouping.SecondPassGroupingCollector;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.grouping.TopGroups;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.ArrayUtil;

public class TopGroupsCollector<T>
extends SecondPassGroupingCollector<T> {
    private final Sort groupSort;
    private final Sort withinGroupSort;
    private final int maxDocsPerGroup;

    public TopGroupsCollector(GroupSelector<T> groupSelector, Collection<SearchGroup<T>> groups, Sort groupSort, Sort withinGroupSort, int maxDocsPerGroup, boolean getMaxScores) {
        super(groupSelector, groups, new TopDocsReducer(withinGroupSort, maxDocsPerGroup, getMaxScores));
        this.groupSort = Objects.requireNonNull(groupSort);
        this.withinGroupSort = Objects.requireNonNull(withinGroupSort);
        this.maxDocsPerGroup = maxDocsPerGroup;
    }

    public TopGroups<T> getTopGroups(int withinGroupOffset) {
        GroupDocs[] groupDocsResult = new GroupDocs[this.groups.size()];
        int groupIDX = 0;
        float maxScore = Float.MIN_VALUE;
        for (SearchGroup group : this.groups) {
            TopDocs topDocs;
            float groupMaxScore;
            TopDocsAndMaxScoreCollector collector = (TopDocsAndMaxScoreCollector)this.groupReducer.getCollector(group.groupValue);
            if (collector.sortedByScore) {
                TopDocs allTopDocs = collector.topDocsCollector.topDocs();
                float f = groupMaxScore = allTopDocs.scoreDocs.length == 0 ? Float.NaN : allTopDocs.scoreDocs[0].score;
                topDocs = allTopDocs.scoreDocs.length <= withinGroupOffset ? new TopDocs(allTopDocs.totalHits, new ScoreDoc[0]) : new TopDocs(allTopDocs.totalHits, ArrayUtil.copyOfSubArray(allTopDocs.scoreDocs, withinGroupOffset, Math.min(allTopDocs.scoreDocs.length, withinGroupOffset + this.maxDocsPerGroup)));
            } else {
                topDocs = collector.topDocsCollector.topDocs(withinGroupOffset, this.maxDocsPerGroup);
                groupMaxScore = collector.maxScoreCollector == null ? Float.NaN : collector.maxScoreCollector.getMaxScore();
            }
            groupDocsResult[groupIDX++] = new GroupDocs(Float.NaN, groupMaxScore, topDocs.totalHits, topDocs.scoreDocs, group.groupValue, group.sortValues);
            maxScore = Math.max(maxScore, groupMaxScore);
        }
        return new TopGroups(this.groupSort.getSort(), this.withinGroupSort.getSort(), this.totalHitCount, this.totalGroupedHitCount, groupDocsResult, maxScore);
    }

    private static class TopDocsReducer<T>
    extends GroupReducer<T, TopDocsAndMaxScoreCollector> {
        private final Supplier<TopDocsAndMaxScoreCollector> supplier;
        private final boolean needsScores;

        TopDocsReducer(Sort withinGroupSort, int maxDocsPerGroup, boolean getMaxScores) {
            this.needsScores = getMaxScores || withinGroupSort.needsScores();
            this.supplier = withinGroupSort == Sort.RELEVANCE ? () -> new TopDocsAndMaxScoreCollector(true, TopScoreDocCollector.create(maxDocsPerGroup, Integer.MAX_VALUE), null) : () -> {
                TopFieldCollector topDocsCollector = TopFieldCollector.create(withinGroupSort, maxDocsPerGroup, Integer.MAX_VALUE);
                MaxScoreCollector maxScoreCollector = getMaxScores ? new MaxScoreCollector() : null;
                return new TopDocsAndMaxScoreCollector(false, topDocsCollector, maxScoreCollector);
            };
        }

        @Override
        public boolean needsScores() {
            return this.needsScores;
        }

        @Override
        protected TopDocsAndMaxScoreCollector newCollector() {
            return this.supplier.get();
        }
    }

    private static class TopDocsAndMaxScoreCollector
    extends FilterCollector {
        private final TopDocsCollector<?> topDocsCollector;
        private final MaxScoreCollector maxScoreCollector;
        private final boolean sortedByScore;

        public TopDocsAndMaxScoreCollector(boolean sortedByScore, TopDocsCollector<?> topDocsCollector, MaxScoreCollector maxScoreCollector) {
            super(MultiCollector.wrap(topDocsCollector, maxScoreCollector));
            this.sortedByScore = sortedByScore;
            this.topDocsCollector = topDocsCollector;
            this.maxScoreCollector = maxScoreCollector;
        }
    }

    private static class MaxScoreCollector
    extends SimpleCollector {
        private Scorable scorer;
        private float maxScore = Float.MIN_VALUE;
        private boolean collectedAnyHits = false;

        public float getMaxScore() {
            return this.collectedAnyHits ? this.maxScore : Float.NaN;
        }

        @Override
        public ScoreMode scoreMode() {
            return ScoreMode.COMPLETE;
        }

        @Override
        public void setScorer(Scorable scorer) {
            this.scorer = scorer;
        }

        @Override
        public void collect(int doc) throws IOException {
            this.collectedAnyHits = true;
            this.maxScore = Math.max(this.scorer.score(), this.maxScore);
        }
    }
}

