/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.search.join;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.BinaryDocValues;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.DocValues;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReader;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.SortedSetDocValues;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.SimpleCollector;

abstract class DocValuesTermsCollector<DV>
extends SimpleCollector {
    protected DV docValues;
    private final Function<DV> docValuesCall;

    public DocValuesTermsCollector(Function<DV> docValuesCall) {
        this.docValuesCall = docValuesCall;
    }

    @Override
    protected final void doSetNextReader(LeafReaderContext context) throws IOException {
        this.docValues = this.docValuesCall.apply(context.reader());
    }

    static Function<BinaryDocValues> binaryDocValues(String field) {
        return ctx -> DocValues.getBinary(ctx, field);
    }

    static Function<SortedSetDocValues> sortedSetDocValues(String field) {
        return ctx -> DocValues.getSortedSet(ctx, field);
    }

    @FunctionalInterface
    static interface Function<R> {
        public R apply(LeafReader var1) throws IOException;
    }
}

