/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.cluster.state;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.ClusterModule;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.ClusterName;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.ClusterState;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.node.DiscoveryNodes;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.unit.ByteSizeValue;

public class ClusterStateResponse
extends ActionResponse {
    private ClusterName clusterName;
    private ClusterState clusterState;
    private boolean waitForTimedOut = false;

    public ClusterStateResponse(StreamInput in) throws IOException {
        super(in);
        this.clusterName = new ClusterName(in);
        this.clusterState = in.getVersion().onOrAfter(Version.V_6_6_0) ? in.readOptionalWriteable(innerIn -> ClusterState.readFrom(innerIn, null)) : ClusterState.readFrom(in, null);
        if (in.getVersion().before(Version.V_7_0_0)) {
            new ByteSizeValue(in);
        }
        if (in.getVersion().onOrAfter(Version.V_6_6_0)) {
            this.waitForTimedOut = in.readBoolean();
        }
    }

    public ClusterStateResponse(ClusterName clusterName, ClusterState clusterState, boolean waitForTimedOut) {
        this.clusterName = clusterName;
        this.clusterState = clusterState;
        this.waitForTimedOut = waitForTimedOut;
    }

    public ClusterState getState() {
        return this.clusterState;
    }

    public ClusterName getClusterName() {
        return this.clusterName;
    }

    public boolean isWaitForTimedOut() {
        return this.waitForTimedOut;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.clusterName.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_6_6_0)) {
            out.writeOptionalWriteable(this.clusterState);
        } else if (out.getVersion().onOrAfter(Version.V_6_3_0)) {
            this.clusterState.writeTo(out);
        } else {
            ClusterModule.filterCustomsForPre63Clients(this.clusterState).writeTo(out);
        }
        if (out.getVersion().before(Version.V_7_0_0)) {
            ByteSizeValue.ZERO.writeTo(out);
        }
        if (out.getVersion().onOrAfter(Version.V_6_6_0)) {
            out.writeBoolean(this.waitForTimedOut);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterStateResponse response = (ClusterStateResponse)o;
        return this.waitForTimedOut == response.waitForTimedOut && Objects.equals(this.clusterName, response.clusterName) && Objects.equals(ClusterStateResponse.getVersion(this.clusterState), ClusterStateResponse.getVersion(response.clusterState)) && Objects.equals(ClusterStateResponse.getMasterNodeId(this.clusterState), ClusterStateResponse.getMasterNodeId(response.clusterState));
    }

    public int hashCode() {
        return Objects.hash(this.clusterName, ClusterStateResponse.getVersion(this.clusterState), ClusterStateResponse.getMasterNodeId(this.clusterState), this.waitForTimedOut);
    }

    private static String getMasterNodeId(ClusterState clusterState) {
        if (clusterState == null) {
            return null;
        }
        DiscoveryNodes nodes = clusterState.getNodes();
        if (nodes != null) {
            return nodes.getMasterNodeId();
        }
        return null;
    }

    private static Long getVersion(ClusterState clusterState) {
        if (clusterState != null) {
            return clusterState.getVersion();
        }
        return null;
    }
}

