/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.dangling;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.Writeable;

public class DanglingIndexInfo
implements Writeable {
    private final String nodeId;
    private final String indexName;
    private final String indexUUID;
    private final long creationDateMillis;

    public DanglingIndexInfo(String nodeId, String indexName, String indexUUID, long creationDateMillis) {
        this.nodeId = nodeId;
        this.indexName = indexName;
        this.indexUUID = indexUUID;
        this.creationDateMillis = creationDateMillis;
    }

    public DanglingIndexInfo(StreamInput in) throws IOException {
        this.nodeId = in.readString();
        this.indexName = in.readString();
        this.indexUUID = in.readString();
        this.creationDateMillis = in.readLong();
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getIndexUUID() {
        return this.indexUUID;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public long getCreationDateMillis() {
        return this.creationDateMillis;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.nodeId);
        out.writeString(this.indexName);
        out.writeString(this.indexUUID);
        out.writeLong(this.creationDateMillis);
    }
}

