/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ingest;

import java.util.concurrent.atomic.AtomicInteger;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionListenerResponseHandler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.ClusterChangedEvent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.ClusterStateApplier;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Randomness;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportService;

public final class IngestActionForwarder
implements ClusterStateApplier {
    private final TransportService transportService;
    private final AtomicInteger ingestNodeGenerator = new AtomicInteger(Randomness.get().nextInt());
    private DiscoveryNode[] ingestNodes;

    public IngestActionForwarder(TransportService transportService) {
        this.transportService = transportService;
        this.ingestNodes = new DiscoveryNode[0];
    }

    public void forwardIngestRequest(ActionType<?> action, ActionRequest request, ActionListener<?> listener) {
        this.transportService.sendRequest(this.randomIngestNode(), action.name(), request, new ActionListenerResponseHandler(listener, action.getResponseReader()));
    }

    private DiscoveryNode randomIngestNode() {
        DiscoveryNode[] nodes = this.ingestNodes;
        if (nodes.length == 0) {
            throw new IllegalStateException("There are no ingest nodes in this cluster, unable to forward request to an ingest node.");
        }
        return nodes[Math.floorMod(this.ingestNodeGenerator.incrementAndGet(), nodes.length)];
    }

    @Override
    public void applyClusterState(ClusterChangedEvent event) {
        this.ingestNodes = event.state().getNodes().getIngestNodes().values().toArray(DiscoveryNode.class);
    }
}

