/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.ElasticsearchException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.AliasMetadata;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.StatusToXContentObject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentParserUtils;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.RestStatus;

public class GetAliasesResponse
implements StatusToXContentObject {
    private final RestStatus status;
    private final String error;
    private final ElasticsearchException exception;
    private final Map<String, Set<AliasMetadata>> aliases;

    GetAliasesResponse(RestStatus status, String error, Map<String, Set<AliasMetadata>> aliases) {
        this.status = status;
        this.error = error;
        this.aliases = aliases;
        this.exception = null;
    }

    private GetAliasesResponse(RestStatus status, ElasticsearchException exception) {
        this.status = status;
        this.error = null;
        this.aliases = Collections.emptyMap();
        this.exception = exception;
    }

    @Override
    public RestStatus status() {
        return this.status;
    }

    public String getError() {
        return this.error;
    }

    public ElasticsearchException getException() {
        return this.exception;
    }

    public Map<String, Set<AliasMetadata>> getAliases() {
        return this.aliases;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.status != RestStatus.OK) {
            builder.field("error", this.error);
            builder.field("status", this.status.getStatus());
        }
        for (Map.Entry<String, Set<AliasMetadata>> entry : this.aliases.entrySet()) {
            builder.startObject(entry.getKey());
            builder.startObject("aliases");
            for (AliasMetadata alias : entry.getValue()) {
                AliasMetadata.Builder.toXContent(alias, builder, ToXContent.EMPTY_PARAMS);
            }
            builder.endObject();
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static GetAliasesResponse fromXContent(XContentParser parser) throws IOException {
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser::getTokenLocation);
        HashMap<String, Set<AliasMetadata>> aliases = new HashMap<String, Set<AliasMetadata>>();
        String error = null;
        ElasticsearchException exception = null;
        RestStatus status = RestStatus.OK;
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            XContentParser.Token token;
            if (parser.currentToken() != XContentParser.Token.FIELD_NAME) continue;
            String currentFieldName = parser.currentName();
            if ("status".equals(currentFieldName)) {
                token = parser.nextToken();
                if (token == XContentParser.Token.FIELD_NAME) continue;
                XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_NUMBER, token, parser::getTokenLocation);
                status = RestStatus.fromCode(parser.intValue());
                continue;
            }
            if ("error".equals(currentFieldName)) {
                token = parser.nextToken();
                if (token == XContentParser.Token.VALUE_STRING) {
                    error = parser.text();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    parser.nextToken();
                    exception = ElasticsearchException.innerFromXContent(parser, true);
                    continue;
                }
                if (token != XContentParser.Token.START_ARRAY) continue;
                parser.skipChildren();
                continue;
            }
            String indexName = parser.currentName();
            if (parser.nextToken() != XContentParser.Token.START_OBJECT) continue;
            Set<AliasMetadata> parseInside = GetAliasesResponse.parseAliases(parser);
            aliases.put(indexName, parseInside);
        }
        if (exception != null) {
            assert (error == null);
            assert (aliases.isEmpty());
            return new GetAliasesResponse(status, exception);
        }
        return new GetAliasesResponse(status, error, aliases);
    }

    private static Set<AliasMetadata> parseAliases(XContentParser parser) throws IOException {
        XContentParser.Token token;
        HashSet<AliasMetadata> aliases = new HashSet<AliasMetadata>();
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("aliases".equals(currentFieldName)) {
                    while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        AliasMetadata fromXContent = AliasMetadata.Builder.fromXContent(parser);
                        aliases.add(fromXContent);
                    }
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            if (token != XContentParser.Token.START_ARRAY) continue;
            parser.skipChildren();
        }
        return aliases;
    }
}

