/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.eql;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.IndicesOptions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.Validatable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.unit.TimeValue;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentObject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryBuilder;

public class EqlSearchRequest
implements Validatable,
ToXContentObject {
    private String[] indices;
    private IndicesOptions indicesOptions = IndicesOptions.fromOptions(false, false, true, false);
    private QueryBuilder filter = null;
    private String timestampField = "@timestamp";
    private String eventCategoryField = "event.category";
    private boolean isCaseSensitive = true;
    private int size = 10;
    private int fetchSize = 1000;
    private String query;
    private String tiebreakerField;
    private TimeValue waitForCompletionTimeout;
    private boolean keepOnCompletion;
    private TimeValue keepAlive;
    static final String KEY_FILTER = "filter";
    static final String KEY_TIMESTAMP_FIELD = "timestamp_field";
    static final String KEY_TIEBREAKER_FIELD = "tiebreaker_field";
    static final String KEY_EVENT_CATEGORY_FIELD = "event_category_field";
    static final String KEY_CASE_SENSITIVE = "case_sensitive";
    static final String KEY_SIZE = "size";
    static final String KEY_FETCH_SIZE = "fetch_size";
    static final String KEY_QUERY = "query";
    static final String KEY_WAIT_FOR_COMPLETION_TIMEOUT = "wait_for_completion_timeout";
    static final String KEY_KEEP_ALIVE = "keep_alive";
    static final String KEY_KEEP_ON_COMPLETION = "keep_on_completion";

    public EqlSearchRequest(String indices, String query) {
        this.indices(indices);
        this.query(query);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.filter != null) {
            builder.field(KEY_FILTER, this.filter);
        }
        builder.field(KEY_TIMESTAMP_FIELD, this.timestampField());
        if (this.tiebreakerField != null) {
            builder.field(KEY_TIEBREAKER_FIELD, this.tiebreakerField());
        }
        builder.field(KEY_EVENT_CATEGORY_FIELD, this.eventCategoryField());
        builder.field(KEY_SIZE, this.size());
        builder.field(KEY_FETCH_SIZE, this.fetchSize());
        builder.field(KEY_CASE_SENSITIVE, this.isCaseSensitive());
        builder.field(KEY_QUERY, this.query);
        if (this.waitForCompletionTimeout != null) {
            builder.field(KEY_WAIT_FOR_COMPLETION_TIMEOUT, this.waitForCompletionTimeout);
        }
        if (this.keepAlive != null) {
            builder.field(KEY_KEEP_ALIVE, this.keepAlive);
        }
        builder.field(KEY_KEEP_ON_COMPLETION, this.keepOnCompletion);
        builder.endObject();
        return builder;
    }

    public EqlSearchRequest indices(String ... indices) {
        Objects.requireNonNull(indices, "indices must not be null");
        for (String index : indices) {
            Objects.requireNonNull(index, "index must not be null");
        }
        this.indices = indices;
        return this;
    }

    public QueryBuilder filter() {
        return this.filter;
    }

    public EqlSearchRequest filter(QueryBuilder filter) {
        this.filter = filter;
        return this;
    }

    public String timestampField() {
        return this.timestampField;
    }

    public EqlSearchRequest timestampField(String timestampField) {
        Objects.requireNonNull(timestampField, "timestamp field must not be null");
        this.timestampField = timestampField;
        return this;
    }

    public String tiebreakerField() {
        return this.tiebreakerField;
    }

    public EqlSearchRequest tiebreakerField(String tiebreakerField) {
        Objects.requireNonNull(tiebreakerField, "tiebreaker field must not be null");
        this.tiebreakerField = tiebreakerField;
        return this;
    }

    public String eventCategoryField() {
        return this.eventCategoryField;
    }

    public EqlSearchRequest eventCategoryField(String eventCategoryField) {
        Objects.requireNonNull(eventCategoryField, "event category field must not be null");
        this.eventCategoryField = eventCategoryField;
        return this;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public EqlSearchRequest isCaseSensitive(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
        return this;
    }

    public int size() {
        return this.size;
    }

    public EqlSearchRequest size(int size) {
        this.size = size;
        if (this.fetchSize <= 0) {
            throw new IllegalArgumentException("size must be greater than 0");
        }
        return this;
    }

    public int fetchSize() {
        return this.fetchSize;
    }

    public EqlSearchRequest fetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        if (fetchSize < 2) {
            throw new IllegalArgumentException("fetch size must be greater than 1");
        }
        return this;
    }

    public String query() {
        return this.query;
    }

    public EqlSearchRequest query(String query) {
        Objects.requireNonNull(query, "query must not be null");
        this.query = query;
        return this;
    }

    public TimeValue waitForCompletionTimeout() {
        return this.waitForCompletionTimeout;
    }

    public EqlSearchRequest waitForCompletionTimeout(TimeValue waitForCompletionTimeout) {
        this.waitForCompletionTimeout = waitForCompletionTimeout;
        return this;
    }

    public Boolean keepOnCompletion() {
        return this.keepOnCompletion;
    }

    public void keepOnCompletion(Boolean keepOnCompletion) {
        this.keepOnCompletion = keepOnCompletion;
    }

    public TimeValue keepAlive() {
        return this.keepAlive;
    }

    public EqlSearchRequest keepAlive(TimeValue keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EqlSearchRequest that = (EqlSearchRequest)o;
        return this.size == that.size && this.fetchSize == that.fetchSize && Arrays.equals(this.indices, that.indices) && Objects.equals(this.indicesOptions, that.indicesOptions) && Objects.equals(this.filter, that.filter) && Objects.equals(this.timestampField, that.timestampField) && Objects.equals(this.tiebreakerField, that.tiebreakerField) && Objects.equals(this.eventCategoryField, that.eventCategoryField) && Objects.equals(this.query, that.query) && Objects.equals(this.isCaseSensitive, that.isCaseSensitive) && Objects.equals(this.waitForCompletionTimeout, that.waitForCompletionTimeout) && Objects.equals(this.keepAlive, that.keepAlive) && Objects.equals(this.keepOnCompletion, that.keepOnCompletion);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.indices), this.indicesOptions, this.filter, this.size, this.fetchSize, this.timestampField, this.tiebreakerField, this.eventCategoryField, this.query, this.isCaseSensitive, this.waitForCompletionTimeout, this.keepAlive, this.keepOnCompletion);
    }

    public String[] indices() {
        return Arrays.copyOf(this.indices, this.indices.length);
    }

    public EqlSearchRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = Objects.requireNonNull(indicesOptions, "indicesOptions must not be null");
        return this;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }
}

