/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.indexlifecycle;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.IndicesOptions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.TimedRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ValidationException;

public class ExplainLifecycleRequest
extends TimedRequest {
    private final String[] indices;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpen();

    public ExplainLifecycleRequest(String ... indices) {
        if (indices.length == 0) {
            throw new IllegalArgumentException("Must at least specify one index to explain");
        }
        this.indices = indices;
    }

    public String[] getIndices() {
        return this.indices;
    }

    public ExplainLifecycleRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    @Override
    public Optional<ValidationException> validate() {
        return Optional.empty();
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.indices), this.indicesOptions);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ExplainLifecycleRequest other = (ExplainLifecycleRequest)obj;
        return Objects.deepEquals(this.getIndices(), other.getIndices()) && Objects.equals(this.indicesOptions(), other.indicesOptions());
    }

    public String toString() {
        return "ExplainLifecycleRequest [indices()=" + Arrays.toString(this.indices) + ", indicesOptions()=" + this.indicesOptions + "]";
    }
}

