/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.indices.rollover;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.rollover.Condition;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.rollover.MaxAgeCondition;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.rollover.MaxDocsCondition;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.rollover.MaxSizeCondition;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.TimedRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.indices.CreateIndexRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.unit.ByteSizeValue;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.unit.TimeValue;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentObject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;

public class RolloverRequest
extends TimedRequest
implements ToXContentObject {
    private final String alias;
    private final String newIndexName;
    private boolean dryRun;
    private final Map<String, Condition<?>> conditions = new HashMap(2);
    private final CreateIndexRequest createIndexRequest = new CreateIndexRequest("_na_");

    public RolloverRequest(String alias, String newIndexName) {
        if (alias == null) {
            throw new IllegalArgumentException("The index alias cannot be null!");
        }
        this.alias = alias;
        this.newIndexName = newIndexName;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getNewIndexName() {
        return this.newIndexName;
    }

    public RolloverRequest dryRun(boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public RolloverRequest addMaxIndexAgeCondition(TimeValue age) {
        MaxAgeCondition maxAgeCondition = new MaxAgeCondition(age);
        if (this.conditions.containsKey(maxAgeCondition.name())) {
            throw new IllegalArgumentException(maxAgeCondition.name() + " condition is already set");
        }
        this.conditions.put(maxAgeCondition.name(), maxAgeCondition);
        return this;
    }

    public RolloverRequest addMaxIndexDocsCondition(long numDocs) {
        MaxDocsCondition maxDocsCondition = new MaxDocsCondition(numDocs);
        if (this.conditions.containsKey(maxDocsCondition.name())) {
            throw new IllegalArgumentException(maxDocsCondition.name() + " condition is already set");
        }
        this.conditions.put(maxDocsCondition.name(), maxDocsCondition);
        return this;
    }

    public RolloverRequest addMaxIndexSizeCondition(ByteSizeValue size) {
        MaxSizeCondition maxSizeCondition = new MaxSizeCondition(size);
        if (this.conditions.containsKey(maxSizeCondition.name())) {
            throw new IllegalArgumentException(maxSizeCondition + " condition is already set");
        }
        this.conditions.put(maxSizeCondition.name(), maxSizeCondition);
        return this;
    }

    public Map<String, Condition<?>> getConditions() {
        return this.conditions;
    }

    public CreateIndexRequest getCreateIndexRequest() {
        return this.createIndexRequest;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.createIndexRequest.innerToXContent(builder, params);
        builder.startObject("conditions");
        for (Condition<?> condition : this.conditions.values()) {
            condition.toXContent(builder, params);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }
}

