/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionRequestValidationException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml.job.config.Job;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentObject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;

public class FlushJobRequest
extends ActionRequest
implements ToXContentObject {
    public static final ParseField CALC_INTERIM = new ParseField("calc_interim", new String[0]);
    public static final ParseField START = new ParseField("start", new String[0]);
    public static final ParseField END = new ParseField("end", new String[0]);
    public static final ParseField ADVANCE_TIME = new ParseField("advance_time", new String[0]);
    public static final ParseField SKIP_TIME = new ParseField("skip_time", new String[0]);
    public static final ConstructingObjectParser<FlushJobRequest, Void> PARSER = new ConstructingObjectParser("flush_job_request", a -> new FlushJobRequest((String)a[0]));
    private final String jobId;
    private Boolean calcInterim;
    private String start;
    private String end;
    private String advanceTime;
    private String skipTime;

    public FlushJobRequest(String jobId) {
        this.jobId = jobId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public boolean getCalcInterim() {
        return this.calcInterim;
    }

    public void setCalcInterim(boolean calcInterim) {
        this.calcInterim = calcInterim;
    }

    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public String getEnd() {
        return this.end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public String getAdvanceTime() {
        return this.advanceTime;
    }

    public void setAdvanceTime(String advanceTime) {
        this.advanceTime = advanceTime;
    }

    public String getSkipTime() {
        return this.skipTime;
    }

    public void setSkipTime(String skipTime) {
        this.skipTime = skipTime;
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.calcInterim, this.start, this.end, this.advanceTime, this.skipTime);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FlushJobRequest other = (FlushJobRequest)obj;
        return Objects.equals(this.jobId, other.jobId) && this.calcInterim == other.calcInterim && Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end) && Objects.equals(this.advanceTime, other.advanceTime) && Objects.equals(this.skipTime, other.skipTime);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        if (this.calcInterim != null) {
            builder.field(CALC_INTERIM.getPreferredName(), this.calcInterim);
        }
        if (this.start != null) {
            builder.field(START.getPreferredName(), this.start);
        }
        if (this.end != null) {
            builder.field(END.getPreferredName(), this.end);
        }
        if (this.advanceTime != null) {
            builder.field(ADVANCE_TIME.getPreferredName(), this.advanceTime);
        }
        if (this.skipTime != null) {
            builder.field(SKIP_TIME.getPreferredName(), this.skipTime);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        PARSER.declareBoolean(FlushJobRequest::setCalcInterim, CALC_INTERIM);
        PARSER.declareString(FlushJobRequest::setStart, START);
        PARSER.declareString(FlushJobRequest::setEnd, END);
        PARSER.declareString(FlushJobRequest::setAdvanceTime, ADVANCE_TIME);
        PARSER.declareString(FlushJobRequest::setSkipTime, SKIP_TIME);
    }
}

