/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml.dataframe;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml.dataframe.DataFrameAnalysis;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentParser;

public class Classification
implements DataFrameAnalysis {
    public static final ParseField NAME = new ParseField("classification", new String[0]);
    static final ParseField DEPENDENT_VARIABLE = new ParseField("dependent_variable", new String[0]);
    static final ParseField LAMBDA = new ParseField("lambda", new String[0]);
    static final ParseField GAMMA = new ParseField("gamma", new String[0]);
    static final ParseField ETA = new ParseField("eta", new String[0]);
    static final ParseField MAX_TREES = new ParseField("max_trees", new String[0]);
    static final ParseField FEATURE_BAG_FRACTION = new ParseField("feature_bag_fraction", new String[0]);
    static final ParseField NUM_TOP_FEATURE_IMPORTANCE_VALUES = new ParseField("num_top_feature_importance_values", new String[0]);
    static final ParseField PREDICTION_FIELD_NAME = new ParseField("prediction_field_name", new String[0]);
    static final ParseField TRAINING_PERCENT = new ParseField("training_percent", new String[0]);
    static final ParseField CLASS_ASSIGNMENT_OBJECTIVE = new ParseField("class_assignment_objective", new String[0]);
    static final ParseField NUM_TOP_CLASSES = new ParseField("num_top_classes", new String[0]);
    static final ParseField RANDOMIZE_SEED = new ParseField("randomize_seed", new String[0]);
    private static final ConstructingObjectParser<Classification, Void> PARSER = new ConstructingObjectParser(NAME.getPreferredName(), true, a -> new Classification((String)a[0], (Double)a[1], (Double)a[2], (Double)a[3], (Integer)a[4], (Double)a[5], (Integer)a[6], (String)a[7], (Double)a[8], (Integer)a[9], (Long)a[10], (ClassAssignmentObjective)((Object)((Object)a[11]))));
    private final String dependentVariable;
    private final Double lambda;
    private final Double gamma;
    private final Double eta;
    private final Integer maxTrees;
    private final Double featureBagFraction;
    private final Integer numTopFeatureImportanceValues;
    private final String predictionFieldName;
    private final Double trainingPercent;
    private final ClassAssignmentObjective classAssignmentObjective;
    private final Integer numTopClasses;
    private final Long randomizeSeed;

    public static Classification fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public static Builder builder(String dependentVariable) {
        return new Builder(dependentVariable);
    }

    private Classification(String dependentVariable, @Nullable Double lambda, @Nullable Double gamma, @Nullable Double eta, @Nullable Integer maxTrees, @Nullable Double featureBagFraction, @Nullable Integer numTopFeatureImportanceValues, @Nullable String predictionFieldName, @Nullable Double trainingPercent, @Nullable Integer numTopClasses, @Nullable Long randomizeSeed, @Nullable ClassAssignmentObjective classAssignmentObjective) {
        this.dependentVariable = Objects.requireNonNull(dependentVariable);
        this.lambda = lambda;
        this.gamma = gamma;
        this.eta = eta;
        this.maxTrees = maxTrees;
        this.featureBagFraction = featureBagFraction;
        this.numTopFeatureImportanceValues = numTopFeatureImportanceValues;
        this.predictionFieldName = predictionFieldName;
        this.trainingPercent = trainingPercent;
        this.classAssignmentObjective = classAssignmentObjective;
        this.numTopClasses = numTopClasses;
        this.randomizeSeed = randomizeSeed;
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    public String getDependentVariable() {
        return this.dependentVariable;
    }

    public Double getLambda() {
        return this.lambda;
    }

    public Double getGamma() {
        return this.gamma;
    }

    public Double getEta() {
        return this.eta;
    }

    public Integer getMaxTrees() {
        return this.maxTrees;
    }

    public Double getFeatureBagFraction() {
        return this.featureBagFraction;
    }

    public Integer getNumTopFeatureImportanceValues() {
        return this.numTopFeatureImportanceValues;
    }

    public String getPredictionFieldName() {
        return this.predictionFieldName;
    }

    public Double getTrainingPercent() {
        return this.trainingPercent;
    }

    public Long getRandomizeSeed() {
        return this.randomizeSeed;
    }

    public ClassAssignmentObjective getClassAssignmentObjective() {
        return this.classAssignmentObjective;
    }

    public Integer getNumTopClasses() {
        return this.numTopClasses;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DEPENDENT_VARIABLE.getPreferredName(), this.dependentVariable);
        if (this.lambda != null) {
            builder.field(LAMBDA.getPreferredName(), this.lambda);
        }
        if (this.gamma != null) {
            builder.field(GAMMA.getPreferredName(), this.gamma);
        }
        if (this.eta != null) {
            builder.field(ETA.getPreferredName(), this.eta);
        }
        if (this.maxTrees != null) {
            builder.field(MAX_TREES.getPreferredName(), this.maxTrees);
        }
        if (this.featureBagFraction != null) {
            builder.field(FEATURE_BAG_FRACTION.getPreferredName(), this.featureBagFraction);
        }
        if (this.numTopFeatureImportanceValues != null) {
            builder.field(NUM_TOP_FEATURE_IMPORTANCE_VALUES.getPreferredName(), this.numTopFeatureImportanceValues);
        }
        if (this.predictionFieldName != null) {
            builder.field(PREDICTION_FIELD_NAME.getPreferredName(), this.predictionFieldName);
        }
        if (this.trainingPercent != null) {
            builder.field(TRAINING_PERCENT.getPreferredName(), this.trainingPercent);
        }
        if (this.randomizeSeed != null) {
            builder.field(RANDOMIZE_SEED.getPreferredName(), this.randomizeSeed);
        }
        if (this.classAssignmentObjective != null) {
            builder.field(CLASS_ASSIGNMENT_OBJECTIVE.getPreferredName(), (Object)this.classAssignmentObjective);
        }
        if (this.numTopClasses != null) {
            builder.field(NUM_TOP_CLASSES.getPreferredName(), this.numTopClasses);
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dependentVariable, this.lambda, this.gamma, this.eta, this.maxTrees, this.featureBagFraction, this.numTopFeatureImportanceValues, this.predictionFieldName, this.trainingPercent, this.randomizeSeed, this.numTopClasses, this.classAssignmentObjective});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Classification that = (Classification)o;
        return Objects.equals(this.dependentVariable, that.dependentVariable) && Objects.equals(this.lambda, that.lambda) && Objects.equals(this.gamma, that.gamma) && Objects.equals(this.eta, that.eta) && Objects.equals(this.maxTrees, that.maxTrees) && Objects.equals(this.featureBagFraction, that.featureBagFraction) && Objects.equals(this.numTopFeatureImportanceValues, that.numTopFeatureImportanceValues) && Objects.equals(this.predictionFieldName, that.predictionFieldName) && Objects.equals(this.trainingPercent, that.trainingPercent) && Objects.equals(this.randomizeSeed, that.randomizeSeed) && Objects.equals(this.numTopClasses, that.numTopClasses) && Objects.equals((Object)this.classAssignmentObjective, (Object)that.classAssignmentObjective);
    }

    public String toString() {
        return Strings.toString(this);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), DEPENDENT_VARIABLE);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), LAMBDA);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), GAMMA);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), ETA);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), MAX_TREES);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), FEATURE_BAG_FRACTION);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), NUM_TOP_FEATURE_IMPORTANCE_VALUES);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), PREDICTION_FIELD_NAME);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), TRAINING_PERCENT);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), NUM_TOP_CLASSES);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), RANDOMIZE_SEED);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), ClassAssignmentObjective::fromString, CLASS_ASSIGNMENT_OBJECTIVE);
    }

    public static enum ClassAssignmentObjective {
        MAXIMIZE_ACCURACY,
        MAXIMIZE_MINIMUM_RECALL;


        public static ClassAssignmentObjective fromString(String value) {
            return ClassAssignmentObjective.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static class Builder {
        private String dependentVariable;
        private Double lambda;
        private Double gamma;
        private Double eta;
        private Integer maxTrees;
        private Double featureBagFraction;
        private Integer numTopFeatureImportanceValues;
        private String predictionFieldName;
        private Double trainingPercent;
        private Integer numTopClasses;
        private Long randomizeSeed;
        private ClassAssignmentObjective classAssignmentObjective;

        private Builder(String dependentVariable) {
            this.dependentVariable = Objects.requireNonNull(dependentVariable);
        }

        public Builder setLambda(Double lambda) {
            this.lambda = lambda;
            return this;
        }

        public Builder setGamma(Double gamma) {
            this.gamma = gamma;
            return this;
        }

        public Builder setEta(Double eta) {
            this.eta = eta;
            return this;
        }

        public Builder setMaxTrees(Integer maxTrees) {
            this.maxTrees = maxTrees;
            return this;
        }

        public Builder setFeatureBagFraction(Double featureBagFraction) {
            this.featureBagFraction = featureBagFraction;
            return this;
        }

        public Builder setNumTopFeatureImportanceValues(Integer numTopFeatureImportanceValues) {
            this.numTopFeatureImportanceValues = numTopFeatureImportanceValues;
            return this;
        }

        public Builder setPredictionFieldName(String predictionFieldName) {
            this.predictionFieldName = predictionFieldName;
            return this;
        }

        public Builder setTrainingPercent(Double trainingPercent) {
            this.trainingPercent = trainingPercent;
            return this;
        }

        public Builder setRandomizeSeed(Long randomizeSeed) {
            this.randomizeSeed = randomizeSeed;
            return this;
        }

        public Builder setNumTopClasses(Integer numTopClasses) {
            this.numTopClasses = numTopClasses;
            return this;
        }

        public Builder setClassAssignmentObjective(ClassAssignmentObjective classAssignmentObjective) {
            this.classAssignmentObjective = classAssignmentObjective;
            return this;
        }

        public Classification build() {
            return new Classification(this.dependentVariable, this.lambda, this.gamma, this.eta, this.maxTrees, this.featureBagFraction, this.numTopFeatureImportanceValues, this.predictionFieldName, this.trainingPercent, this.numTopClasses, this.randomizeSeed, this.classAssignmentObjective);
        }
    }
}

