/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.security.user.privileges;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentObject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentHelper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentType;

public abstract class AbstractIndicesPrivileges {
    static final ParseField NAMES = new ParseField("names", new String[0]);
    static final ParseField ALLOW_RESTRICTED_INDICES = new ParseField("allow_restricted_indices", new String[0]);
    static final ParseField PRIVILEGES = new ParseField("privileges", new String[0]);
    static final ParseField FIELD_PERMISSIONS = new ParseField("field_security", new String[0]);
    static final ParseField QUERY = new ParseField("query", new String[0]);
    protected final Set<String> indices;
    protected final Set<String> privileges;
    protected final boolean allowRestrictedIndices;

    AbstractIndicesPrivileges(Collection<String> indices, Collection<String> privileges, boolean allowRestrictedIndices) {
        if (null == indices || indices.isEmpty()) {
            throw new IllegalArgumentException("indices privileges must refer to at least one index name or index name pattern");
        }
        if (null == privileges || privileges.isEmpty()) {
            throw new IllegalArgumentException("indices privileges must define at least one privilege");
        }
        this.indices = Collections.unmodifiableSet(new HashSet<String>(indices));
        this.privileges = Collections.unmodifiableSet(new HashSet<String>(privileges));
        this.allowRestrictedIndices = allowRestrictedIndices;
    }

    public Set<String> getIndices() {
        return this.indices;
    }

    public Set<String> getPrivileges() {
        return this.privileges;
    }

    public boolean allowRestrictedIndices() {
        return this.allowRestrictedIndices;
    }

    public abstract boolean isUsingDocumentLevelSecurity();

    public abstract boolean isUsingFieldLevelSecurity();

    public static class FieldSecurity
    implements ToXContentObject {
        static final ParseField GRANT_FIELDS = new ParseField("grant", new String[0]);
        static final ParseField EXCEPT_FIELDS = new ParseField("except", new String[0]);
        private static final ConstructingObjectParser<FieldSecurity, Void> PARSER = new ConstructingObjectParser(FIELD_PERMISSIONS.getPreferredName(), true, FieldSecurity::buildObjectFromParserArgs);
        private final Set<String> grantedFields;
        private final Set<String> deniedFields;

        private static FieldSecurity buildObjectFromParserArgs(Object[] args) {
            return new FieldSecurity((Collection)args[0], (Collection)args[1]);
        }

        static FieldSecurity parse(XContentParser parser, Void context) throws IOException {
            return PARSER.parse(parser, context);
        }

        FieldSecurity(Collection<String> grantedFields, Collection<String> deniedFields) {
            this.grantedFields = grantedFields == null ? null : Collections.unmodifiableSet(new HashSet<String>(grantedFields));
            this.deniedFields = deniedFields == null ? null : Collections.unmodifiableSet(new HashSet<String>(deniedFields));
        }

        public Set<String> getGrantedFields() {
            return this.grantedFields;
        }

        public Set<String> getDeniedFields() {
            return this.deniedFields;
        }

        public boolean isUsingFieldLevelSecurity() {
            return this.limitsGrantedFields() || this.hasDeniedFields();
        }

        private boolean hasDeniedFields() {
            return this.deniedFields != null && false == this.deniedFields.isEmpty();
        }

        private boolean limitsGrantedFields() {
            return this.grantedFields != null && (this.grantedFields.size() != 1 || !this.grantedFields.iterator().next().equals("*"));
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.grantedFields == null) {
                builder.field(GRANT_FIELDS.getPreferredName(), Collections.singletonList("*"));
            } else {
                builder.field(GRANT_FIELDS.getPreferredName(), this.grantedFields);
            }
            if (this.deniedFields != null) {
                builder.field(EXCEPT_FIELDS.getPreferredName(), this.deniedFields);
            }
            return builder.endObject();
        }

        public String toString() {
            try {
                return XContentHelper.toXContent(this, XContentType.JSON, true).utf8ToString();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unexpected", e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldSecurity that = (FieldSecurity)o;
            return Objects.equals(this.grantedFields, that.grantedFields) && Objects.equals(this.deniedFields, that.deniedFields);
        }

        public int hashCode() {
            return Objects.hash(this.grantedFields, this.deniedFields);
        }

        static {
            PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), GRANT_FIELDS);
            PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), EXCEPT_FIELDS);
        }
    }
}

