/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.coordination;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.Writeable;

public class Join
implements Writeable {
    private final DiscoveryNode sourceNode;
    private final DiscoveryNode targetNode;
    private final long term;
    private final long lastAcceptedTerm;
    private final long lastAcceptedVersion;

    public Join(DiscoveryNode sourceNode, DiscoveryNode targetNode, long term, long lastAcceptedTerm, long lastAcceptedVersion) {
        assert (term >= 0L);
        assert (lastAcceptedTerm >= 0L);
        assert (lastAcceptedVersion >= 0L);
        this.sourceNode = sourceNode;
        this.targetNode = targetNode;
        this.term = term;
        this.lastAcceptedTerm = lastAcceptedTerm;
        this.lastAcceptedVersion = lastAcceptedVersion;
    }

    public Join(StreamInput in) throws IOException {
        this.sourceNode = new DiscoveryNode(in);
        this.targetNode = new DiscoveryNode(in);
        this.term = in.readLong();
        this.lastAcceptedTerm = in.readLong();
        this.lastAcceptedVersion = in.readLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.sourceNode.writeTo(out);
        this.targetNode.writeTo(out);
        out.writeLong(this.term);
        out.writeLong(this.lastAcceptedTerm);
        out.writeLong(this.lastAcceptedVersion);
    }

    public DiscoveryNode getSourceNode() {
        return this.sourceNode;
    }

    public DiscoveryNode getTargetNode() {
        return this.targetNode;
    }

    public boolean targetMatches(DiscoveryNode matchingNode) {
        return this.targetNode.getId().equals(matchingNode.getId());
    }

    public long getLastAcceptedVersion() {
        return this.lastAcceptedVersion;
    }

    public long getTerm() {
        return this.term;
    }

    public long getLastAcceptedTerm() {
        return this.lastAcceptedTerm;
    }

    public String toString() {
        return "Join{term=" + this.term + ", lastAcceptedTerm=" + this.lastAcceptedTerm + ", lastAcceptedVersion=" + this.lastAcceptedVersion + ", sourceNode=" + this.sourceNode + ", targetNode=" + this.targetNode + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Join join = (Join)o;
        if (!this.sourceNode.equals(join.sourceNode)) {
            return false;
        }
        if (!this.targetNode.equals(join.targetNode)) {
            return false;
        }
        if (this.lastAcceptedVersion != join.lastAcceptedVersion) {
            return false;
        }
        if (this.term != join.term) {
            return false;
        }
        return this.lastAcceptedTerm == join.lastAcceptedTerm;
    }

    public int hashCode() {
        int result = (int)(this.lastAcceptedVersion ^ this.lastAcceptedVersion >>> 32);
        result = 31 * result + this.sourceNode.hashCode();
        result = 31 * result + this.targetNode.hashCode();
        result = 31 * result + (int)(this.term ^ this.term >>> 32);
        result = 31 * result + (int)(this.lastAcceptedTerm ^ this.lastAcceptedTerm >>> 32);
        return result;
    }
}

