/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.common.lucene;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.InfoStream;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.logging.Loggers;

public final class LoggerInfoStream
extends InfoStream {
    private final Logger parentLogger;
    private final Map<String, Logger> loggers = new ConcurrentHashMap<String, Logger>();

    public LoggerInfoStream(Logger parentLogger) {
        this.parentLogger = parentLogger;
    }

    @Override
    public void message(String component, String message) {
        this.getLogger(component).trace("{} {}: {}", (Object)Thread.currentThread().getName(), (Object)component, (Object)message);
    }

    @Override
    public boolean isEnabled(String component) {
        return this.getLogger(component).isTraceEnabled() && !component.equals("TP");
    }

    private Logger getLogger(String component) {
        return this.loggers.computeIfAbsent(component, c -> Loggers.getLogger(this.parentLogger, "." + c));
    }

    @Override
    public void close() {
    }
}

