/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.core.internal.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.core.internal.io.IOUtils;

public class Streams {
    public static long copy(InputStream in, OutputStream out) throws IOException {
        long l;
        Objects.requireNonNull(in, "No InputStream specified");
        Objects.requireNonNull(out, "No OutputStream specified");
        byte[] buffer = new byte[8192];
        Exception err = null;
        try {
            int bytesRead;
            long byteCount = 0L;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                byteCount += (long)bytesRead;
            }
            out.flush();
            l = byteCount;
        }
        catch (IOException | RuntimeException e) {
            try {
                err = e;
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.close(err, in, out);
                throw throwable;
            }
        }
        IOUtils.close(err, in, out);
        return l;
    }
}

