/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.fetch.subphase.highlight;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;

public class SearchContextHighlight {
    private final Map<String, Field> fields;
    private boolean globalForceSource = false;

    public SearchContextHighlight(Collection<Field> fields) {
        assert (fields != null);
        this.fields = new LinkedHashMap<String, Field>(fields.size());
        for (Field field : fields) {
            this.fields.put(field.field, field);
        }
    }

    public Collection<Field> fields() {
        return this.fields.values();
    }

    public void globalForceSource(boolean globalForceSource) {
        this.globalForceSource = globalForceSource;
    }

    boolean globalForceSource() {
        return this.globalForceSource;
    }

    public boolean forceSource(Field field) {
        if (this.globalForceSource) {
            return true;
        }
        Field _field = this.fields.get(field.field);
        return _field == null ? false : _field.fieldOptions.forceSource;
    }

    public static class Field {
        private final String field;
        private final FieldOptions fieldOptions;

        Field(String field, FieldOptions fieldOptions) {
            assert (field != null);
            assert (fieldOptions != null);
            this.field = field;
            this.fieldOptions = fieldOptions;
        }

        public String field() {
            return this.field;
        }

        public FieldOptions fieldOptions() {
            return this.fieldOptions;
        }
    }

    public static class FieldOptions {
        private int fragmentCharSize = -1;
        private int numberOfFragments = -1;
        private int fragmentOffset = -1;
        private String encoder;
        private String[] preTags;
        private String[] postTags;
        private Boolean scoreOrdered;
        private Boolean highlightFilter;
        private Boolean requireFieldMatch;
        private String highlighterType;
        private Boolean forceSource;
        private String fragmenter;
        private HighlightBuilder.BoundaryScannerType boundaryScannerType;
        private int boundaryMaxScan = -1;
        private Character[] boundaryChars = null;
        private Locale boundaryScannerLocale;
        private Query highlightQuery;
        private int noMatchSize = -1;
        private Set<String> matchedFields;
        private Map<String, Object> options;
        private int phraseLimit = -1;

        public int fragmentCharSize() {
            return this.fragmentCharSize;
        }

        public int numberOfFragments() {
            return this.numberOfFragments;
        }

        public int fragmentOffset() {
            return this.fragmentOffset;
        }

        public String encoder() {
            return this.encoder;
        }

        public String[] preTags() {
            return this.preTags;
        }

        public String[] postTags() {
            return this.postTags;
        }

        public Boolean scoreOrdered() {
            return this.scoreOrdered;
        }

        public Boolean highlightFilter() {
            return this.highlightFilter;
        }

        public Boolean requireFieldMatch() {
            return this.requireFieldMatch;
        }

        public String highlighterType() {
            return this.highlighterType;
        }

        public String fragmenter() {
            return this.fragmenter;
        }

        public HighlightBuilder.BoundaryScannerType boundaryScannerType() {
            return this.boundaryScannerType;
        }

        public int boundaryMaxScan() {
            return this.boundaryMaxScan;
        }

        public Character[] boundaryChars() {
            return this.boundaryChars;
        }

        public Locale boundaryScannerLocale() {
            return this.boundaryScannerLocale;
        }

        public Query highlightQuery() {
            return this.highlightQuery;
        }

        public int noMatchSize() {
            return this.noMatchSize;
        }

        public int phraseLimit() {
            return this.phraseLimit;
        }

        public Set<String> matchedFields() {
            return this.matchedFields;
        }

        public Map<String, Object> options() {
            return this.options;
        }

        static /* synthetic */ String[] access$702(FieldOptions x0, String[] x1) {
            x0.preTags = x1;
            return x1;
        }

        static /* synthetic */ String[] access$802(FieldOptions x0, String[] x1) {
            x0.postTags = x1;
            return x1;
        }

        static /* synthetic */ Character[] access$1602(FieldOptions x0, Character[] x1) {
            x0.boundaryChars = x1;
            return x1;
        }

        static class Builder {
            private final FieldOptions fieldOptions = new FieldOptions();

            Builder() {
            }

            Builder fragmentCharSize(int fragmentCharSize) {
                this.fieldOptions.fragmentCharSize = fragmentCharSize;
                return this;
            }

            Builder numberOfFragments(int numberOfFragments) {
                this.fieldOptions.numberOfFragments = numberOfFragments;
                return this;
            }

            Builder fragmentOffset(int fragmentOffset) {
                this.fieldOptions.fragmentOffset = fragmentOffset;
                return this;
            }

            Builder encoder(String encoder) {
                this.fieldOptions.encoder = encoder;
                return this;
            }

            Builder preTags(String[] preTags) {
                FieldOptions.access$702(this.fieldOptions, preTags);
                return this;
            }

            Builder postTags(String[] postTags) {
                FieldOptions.access$802(this.fieldOptions, postTags);
                return this;
            }

            Builder scoreOrdered(boolean scoreOrdered) {
                this.fieldOptions.scoreOrdered = scoreOrdered;
                return this;
            }

            Builder highlightFilter(boolean highlightFilter) {
                this.fieldOptions.highlightFilter = highlightFilter;
                return this;
            }

            Builder requireFieldMatch(boolean requireFieldMatch) {
                this.fieldOptions.requireFieldMatch = requireFieldMatch;
                return this;
            }

            Builder highlighterType(String type) {
                this.fieldOptions.highlighterType = type;
                return this;
            }

            Builder forceSource(boolean forceSource) {
                this.fieldOptions.forceSource = forceSource;
                return this;
            }

            Builder fragmenter(String fragmenter) {
                this.fieldOptions.fragmenter = fragmenter;
                return this;
            }

            Builder boundaryScannerType(HighlightBuilder.BoundaryScannerType boundaryScanner) {
                this.fieldOptions.boundaryScannerType = boundaryScanner;
                return this;
            }

            Builder boundaryMaxScan(int boundaryMaxScan) {
                this.fieldOptions.boundaryMaxScan = boundaryMaxScan;
                return this;
            }

            Builder boundaryChars(Character[] boundaryChars) {
                FieldOptions.access$1602(this.fieldOptions, boundaryChars);
                return this;
            }

            Builder boundaryScannerLocale(Locale boundaryScannerLocale) {
                this.fieldOptions.boundaryScannerLocale = boundaryScannerLocale;
                return this;
            }

            Builder highlightQuery(Query highlightQuery) {
                this.fieldOptions.highlightQuery = highlightQuery;
                return this;
            }

            Builder noMatchSize(int noMatchSize) {
                this.fieldOptions.noMatchSize = noMatchSize;
                return this;
            }

            Builder phraseLimit(int phraseLimit) {
                this.fieldOptions.phraseLimit = phraseLimit;
                return this;
            }

            Builder matchedFields(Set<String> matchedFields) {
                this.fieldOptions.matchedFields = matchedFields;
                return this;
            }

            Builder options(Map<String, Object> options) {
                this.fieldOptions.options = options;
                return this;
            }

            FieldOptions build() {
                return this.fieldOptions;
            }

            Builder merge(FieldOptions globalOptions) {
                if (this.fieldOptions.preTags == null && globalOptions.preTags != null) {
                    FieldOptions.access$702(this.fieldOptions, Arrays.copyOf(globalOptions.preTags, globalOptions.preTags.length));
                }
                if (this.fieldOptions.postTags == null && globalOptions.postTags != null) {
                    FieldOptions.access$802(this.fieldOptions, Arrays.copyOf(globalOptions.postTags, globalOptions.postTags.length));
                }
                if (this.fieldOptions.highlightFilter == null) {
                    this.fieldOptions.highlightFilter = globalOptions.highlightFilter;
                }
                if (this.fieldOptions.scoreOrdered == null) {
                    this.fieldOptions.scoreOrdered = globalOptions.scoreOrdered;
                }
                if (this.fieldOptions.fragmentCharSize == -1) {
                    this.fieldOptions.fragmentCharSize = globalOptions.fragmentCharSize;
                }
                if (this.fieldOptions.numberOfFragments == -1) {
                    this.fieldOptions.numberOfFragments = globalOptions.numberOfFragments;
                }
                if (this.fieldOptions.encoder == null) {
                    this.fieldOptions.encoder = globalOptions.encoder;
                }
                if (this.fieldOptions.requireFieldMatch == null) {
                    this.fieldOptions.requireFieldMatch = globalOptions.requireFieldMatch;
                }
                if (this.fieldOptions.boundaryScannerType == null) {
                    this.fieldOptions.boundaryScannerType = globalOptions.boundaryScannerType;
                }
                if (this.fieldOptions.boundaryMaxScan == -1) {
                    this.fieldOptions.boundaryMaxScan = globalOptions.boundaryMaxScan;
                }
                if (this.fieldOptions.boundaryChars == null && globalOptions.boundaryChars != null) {
                    FieldOptions.access$1602(this.fieldOptions, Arrays.copyOf(globalOptions.boundaryChars, globalOptions.boundaryChars.length));
                }
                if (this.fieldOptions.boundaryScannerLocale == null) {
                    this.fieldOptions.boundaryScannerLocale = globalOptions.boundaryScannerLocale;
                }
                if (this.fieldOptions.highlighterType == null) {
                    this.fieldOptions.highlighterType = globalOptions.highlighterType;
                }
                if (this.fieldOptions.fragmenter == null) {
                    this.fieldOptions.fragmenter = globalOptions.fragmenter;
                }
                if ((this.fieldOptions.options == null || this.fieldOptions.options.size() == 0) && globalOptions.options != null) {
                    this.fieldOptions.options = new HashMap(globalOptions.options);
                }
                if (this.fieldOptions.highlightQuery == null && globalOptions.highlightQuery != null) {
                    this.fieldOptions.highlightQuery = globalOptions.highlightQuery;
                }
                if (this.fieldOptions.noMatchSize == -1) {
                    this.fieldOptions.noMatchSize = globalOptions.noMatchSize;
                }
                if (this.fieldOptions.forceSource == null) {
                    this.fieldOptions.forceSource = globalOptions.forceSource;
                }
                if (this.fieldOptions.phraseLimit == -1) {
                    this.fieldOptions.phraseLimit = globalOptions.phraseLimit;
                }
                return this;
            }
        }
    }
}

