/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.profile;

public class Timer {
    private boolean doTiming;
    private long timing;
    private long count;
    private long lastCount;
    private long start;

    long nanoTime() {
        return System.nanoTime();
    }

    public final void start() {
        assert (this.start == 0L) : "#start call misses a matching #stop call";
        boolean bl = this.doTiming = this.count - this.lastCount >= Math.min(this.lastCount >>> 8, 1024L);
        if (this.doTiming) {
            this.start = this.nanoTime();
        }
        ++this.count;
    }

    public final void stop() {
        if (this.doTiming) {
            this.timing += (this.count - this.lastCount) * Math.max(this.nanoTime() - this.start, 1L);
            this.lastCount = this.count;
            this.start = 0L;
        }
    }

    public final long getCount() {
        if (this.start != 0L) {
            throw new IllegalStateException("#start call misses a matching #stop call");
        }
        return this.count;
    }

    public final long getApproximateTiming() {
        if (this.start != 0L) {
            throw new IllegalStateException("#start call misses a matching #stop call");
        }
        long timing = this.timing;
        if (this.count > this.lastCount) {
            assert (this.lastCount > 0L);
            timing += (this.count - this.lastCount) * timing / this.lastCount;
        }
        return timing;
    }
}

